# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.apis_api_rest_resp_consumer_config import (
    ApisAPIRestRespConsumerConfig,
)
from httpmq.models.apis_api_rest_resp_sequence_info import ApisAPIRestRespSequenceInfo
from httpmq import util


class ApisAPIRestRespConsumerInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        ack_floor: ApisAPIRestRespSequenceInfo = None,
        config: ApisAPIRestRespConsumerConfig = None,
        created: str = None,
        delivered: ApisAPIRestRespSequenceInfo = None,
        name: str = None,
        num_ack_pending: int = None,
        num_pending: int = None,
        num_redelivered: int = None,
        num_waiting: int = None,
        stream_name: str = None,
    ):
        """ApisAPIRestRespConsumerInfo - a model defined in OpenAPI

        :param ack_floor: The ack_floor of this ApisAPIRestRespConsumerInfo.
        :param config: The config of this ApisAPIRestRespConsumerInfo.
        :param created: The created of this ApisAPIRestRespConsumerInfo.
        :param delivered: The delivered of this ApisAPIRestRespConsumerInfo.
        :param name: The name of this ApisAPIRestRespConsumerInfo.
        :param num_ack_pending: The num_ack_pending of this ApisAPIRestRespConsumerInfo.
        :param num_pending: The num_pending of this ApisAPIRestRespConsumerInfo.
        :param num_redelivered: The num_redelivered of this ApisAPIRestRespConsumerInfo.
        :param num_waiting: The num_waiting of this ApisAPIRestRespConsumerInfo.
        :param stream_name: The stream_name of this ApisAPIRestRespConsumerInfo.
        """
        self.openapi_types = {
            "ack_floor": ApisAPIRestRespSequenceInfo,
            "config": ApisAPIRestRespConsumerConfig,
            "created": str,
            "delivered": ApisAPIRestRespSequenceInfo,
            "name": str,
            "num_ack_pending": int,
            "num_pending": int,
            "num_redelivered": int,
            "num_waiting": int,
            "stream_name": str,
        }

        self.attribute_map = {
            "ack_floor": "ack_floor",
            "config": "config",
            "created": "created",
            "delivered": "delivered",
            "name": "name",
            "num_ack_pending": "num_ack_pending",
            "num_pending": "num_pending",
            "num_redelivered": "num_redelivered",
            "num_waiting": "num_waiting",
            "stream_name": "stream_name",
        }

        self._ack_floor = ack_floor
        self._config = config
        self._created = created
        self._delivered = delivered
        self._name = name
        self._num_ack_pending = num_ack_pending
        self._num_pending = num_pending
        self._num_redelivered = num_redelivered
        self._num_waiting = num_waiting
        self._stream_name = stream_name

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespConsumerInfo":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespConsumerInfo of this ApisAPIRestRespConsumerInfo.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ack_floor(self):
        """Gets the ack_floor of this ApisAPIRestRespConsumerInfo.


        :return: The ack_floor of this ApisAPIRestRespConsumerInfo.
        :rtype: ApisAPIRestRespSequenceInfo
        """
        return self._ack_floor

    @ack_floor.setter
    def ack_floor(self, ack_floor):
        """Sets the ack_floor of this ApisAPIRestRespConsumerInfo.


        :param ack_floor: The ack_floor of this ApisAPIRestRespConsumerInfo.
        :type ack_floor: ApisAPIRestRespSequenceInfo
        """
        if ack_floor is None:
            raise ValueError("Invalid value for `ack_floor`, must not be `None`")

        self._ack_floor = ack_floor

    @property
    def config(self):
        """Gets the config of this ApisAPIRestRespConsumerInfo.


        :return: The config of this ApisAPIRestRespConsumerInfo.
        :rtype: ApisAPIRestRespConsumerConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this ApisAPIRestRespConsumerInfo.


        :param config: The config of this ApisAPIRestRespConsumerInfo.
        :type config: ApisAPIRestRespConsumerConfig
        """
        if config is None:
            raise ValueError("Invalid value for `config`, must not be `None`")

        self._config = config

    @property
    def created(self):
        """Gets the created of this ApisAPIRestRespConsumerInfo.

        Created is when this consumer was defined

        :return: The created of this ApisAPIRestRespConsumerInfo.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this ApisAPIRestRespConsumerInfo.

        Created is when this consumer was defined

        :param created: The created of this ApisAPIRestRespConsumerInfo.
        :type created: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")

        self._created = created

    @property
    def delivered(self):
        """Gets the delivered of this ApisAPIRestRespConsumerInfo.


        :return: The delivered of this ApisAPIRestRespConsumerInfo.
        :rtype: ApisAPIRestRespSequenceInfo
        """
        return self._delivered

    @delivered.setter
    def delivered(self, delivered):
        """Sets the delivered of this ApisAPIRestRespConsumerInfo.


        :param delivered: The delivered of this ApisAPIRestRespConsumerInfo.
        :type delivered: ApisAPIRestRespSequenceInfo
        """
        if delivered is None:
            raise ValueError("Invalid value for `delivered`, must not be `None`")

        self._delivered = delivered

    @property
    def name(self):
        """Gets the name of this ApisAPIRestRespConsumerInfo.

        Name is the name of the consumer

        :return: The name of this ApisAPIRestRespConsumerInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApisAPIRestRespConsumerInfo.

        Name is the name of the consumer

        :param name: The name of this ApisAPIRestRespConsumerInfo.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def num_ack_pending(self):
        """Gets the num_ack_pending of this ApisAPIRestRespConsumerInfo.

        NumAckPending is the number of ACK pending / messages in-flight

        :return: The num_ack_pending of this ApisAPIRestRespConsumerInfo.
        :rtype: int
        """
        return self._num_ack_pending

    @num_ack_pending.setter
    def num_ack_pending(self, num_ack_pending):
        """Sets the num_ack_pending of this ApisAPIRestRespConsumerInfo.

        NumAckPending is the number of ACK pending / messages in-flight

        :param num_ack_pending: The num_ack_pending of this ApisAPIRestRespConsumerInfo.
        :type num_ack_pending: int
        """
        if num_ack_pending is None:
            raise ValueError("Invalid value for `num_ack_pending`, must not be `None`")

        self._num_ack_pending = num_ack_pending

    @property
    def num_pending(self):
        """Gets the num_pending of this ApisAPIRestRespConsumerInfo.

        NumPending is the number of message to be delivered for this consumer

        :return: The num_pending of this ApisAPIRestRespConsumerInfo.
        :rtype: int
        """
        return self._num_pending

    @num_pending.setter
    def num_pending(self, num_pending):
        """Sets the num_pending of this ApisAPIRestRespConsumerInfo.

        NumPending is the number of message to be delivered for this consumer

        :param num_pending: The num_pending of this ApisAPIRestRespConsumerInfo.
        :type num_pending: int
        """
        if num_pending is None:
            raise ValueError("Invalid value for `num_pending`, must not be `None`")

        self._num_pending = num_pending

    @property
    def num_redelivered(self):
        """Gets the num_redelivered of this ApisAPIRestRespConsumerInfo.

        NumRedelivered is the number of messages redelivered

        :return: The num_redelivered of this ApisAPIRestRespConsumerInfo.
        :rtype: int
        """
        return self._num_redelivered

    @num_redelivered.setter
    def num_redelivered(self, num_redelivered):
        """Sets the num_redelivered of this ApisAPIRestRespConsumerInfo.

        NumRedelivered is the number of messages redelivered

        :param num_redelivered: The num_redelivered of this ApisAPIRestRespConsumerInfo.
        :type num_redelivered: int
        """
        if num_redelivered is None:
            raise ValueError("Invalid value for `num_redelivered`, must not be `None`")

        self._num_redelivered = num_redelivered

    @property
    def num_waiting(self):
        """Gets the num_waiting of this ApisAPIRestRespConsumerInfo.

        NumWaiting NATS JetStream does not clearly document this

        :return: The num_waiting of this ApisAPIRestRespConsumerInfo.
        :rtype: int
        """
        return self._num_waiting

    @num_waiting.setter
    def num_waiting(self, num_waiting):
        """Sets the num_waiting of this ApisAPIRestRespConsumerInfo.

        NumWaiting NATS JetStream does not clearly document this

        :param num_waiting: The num_waiting of this ApisAPIRestRespConsumerInfo.
        :type num_waiting: int
        """
        if num_waiting is None:
            raise ValueError("Invalid value for `num_waiting`, must not be `None`")

        self._num_waiting = num_waiting

    @property
    def stream_name(self):
        """Gets the stream_name of this ApisAPIRestRespConsumerInfo.

        Stream is the name of the stream

        :return: The stream_name of this ApisAPIRestRespConsumerInfo.
        :rtype: str
        """
        return self._stream_name

    @stream_name.setter
    def stream_name(self, stream_name):
        """Sets the stream_name of this ApisAPIRestRespConsumerInfo.

        Stream is the name of the stream

        :param stream_name: The stream_name of this ApisAPIRestRespConsumerInfo.
        :type stream_name: str
        """
        if stream_name is None:
            raise ValueError("Invalid value for `stream_name`, must not be `None`")

        self._stream_name = stream_name
