# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ApisAPIRestRespConsumerConfig(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        ack_wait: int = None,
        deliver_group: str = None,
        deliver_subject: str = None,
        filter_subject: str = None,
        max_ack_pending: int = None,
        max_deliver: int = None,
        max_waiting: int = None,
        notes: str = None,
    ):
        """ApisAPIRestRespConsumerConfig - a model defined in OpenAPI

        :param ack_wait: The ack_wait of this ApisAPIRestRespConsumerConfig.
        :param deliver_group: The deliver_group of this ApisAPIRestRespConsumerConfig.
        :param deliver_subject: The deliver_subject of this ApisAPIRestRespConsumerConfig.
        :param filter_subject: The filter_subject of this ApisAPIRestRespConsumerConfig.
        :param max_ack_pending: The max_ack_pending of this ApisAPIRestRespConsumerConfig.
        :param max_deliver: The max_deliver of this ApisAPIRestRespConsumerConfig.
        :param max_waiting: The max_waiting of this ApisAPIRestRespConsumerConfig.
        :param notes: The notes of this ApisAPIRestRespConsumerConfig.
        """
        self.openapi_types = {
            "ack_wait": int,
            "deliver_group": str,
            "deliver_subject": str,
            "filter_subject": str,
            "max_ack_pending": int,
            "max_deliver": int,
            "max_waiting": int,
            "notes": str,
        }

        self.attribute_map = {
            "ack_wait": "ack_wait",
            "deliver_group": "deliver_group",
            "deliver_subject": "deliver_subject",
            "filter_subject": "filter_subject",
            "max_ack_pending": "max_ack_pending",
            "max_deliver": "max_deliver",
            "max_waiting": "max_waiting",
            "notes": "notes",
        }

        self._ack_wait = ack_wait
        self._deliver_group = deliver_group
        self._deliver_subject = deliver_subject
        self._filter_subject = filter_subject
        self._max_ack_pending = max_ack_pending
        self._max_deliver = max_deliver
        self._max_waiting = max_waiting
        self._notes = notes

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespConsumerConfig":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespConsumerConfig of this ApisAPIRestRespConsumerConfig.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ack_wait(self):
        """Gets the ack_wait of this ApisAPIRestRespConsumerConfig.

        AckWait duration (ns) to wait for an ACK for the delivery of a message

        :return: The ack_wait of this ApisAPIRestRespConsumerConfig.
        :rtype: int
        """
        return self._ack_wait

    @ack_wait.setter
    def ack_wait(self, ack_wait):
        """Sets the ack_wait of this ApisAPIRestRespConsumerConfig.

        AckWait duration (ns) to wait for an ACK for the delivery of a message

        :param ack_wait: The ack_wait of this ApisAPIRestRespConsumerConfig.
        :type ack_wait: int
        """
        if ack_wait is None:
            raise ValueError("Invalid value for `ack_wait`, must not be `None`")

        self._ack_wait = ack_wait

    @property
    def deliver_group(self):
        """Gets the deliver_group of this ApisAPIRestRespConsumerConfig.

        DeliverGroup is the delivery group if this consumer uses delivery group  A consumer using delivery group allows multiple clients to subscribe under the same consumer and group name tuple. For subjects this consumer listens to, the messages will be shared amongst the connected clients.

        :return: The deliver_group of this ApisAPIRestRespConsumerConfig.
        :rtype: str
        """
        return self._deliver_group

    @deliver_group.setter
    def deliver_group(self, deliver_group):
        """Sets the deliver_group of this ApisAPIRestRespConsumerConfig.

        DeliverGroup is the delivery group if this consumer uses delivery group  A consumer using delivery group allows multiple clients to subscribe under the same consumer and group name tuple. For subjects this consumer listens to, the messages will be shared amongst the connected clients.

        :param deliver_group: The deliver_group of this ApisAPIRestRespConsumerConfig.
        :type deliver_group: str
        """

        self._deliver_group = deliver_group

    @property
    def deliver_subject(self):
        """Gets the deliver_subject of this ApisAPIRestRespConsumerConfig.

        DeliverSubject subject this consumer is listening on

        :return: The deliver_subject of this ApisAPIRestRespConsumerConfig.
        :rtype: str
        """
        return self._deliver_subject

    @deliver_subject.setter
    def deliver_subject(self, deliver_subject):
        """Sets the deliver_subject of this ApisAPIRestRespConsumerConfig.

        DeliverSubject subject this consumer is listening on

        :param deliver_subject: The deliver_subject of this ApisAPIRestRespConsumerConfig.
        :type deliver_subject: str
        """

        self._deliver_subject = deliver_subject

    @property
    def filter_subject(self):
        """Gets the filter_subject of this ApisAPIRestRespConsumerConfig.

        FilterSubject sets the consumer to filter for subjects matching this NATs subject string  See https://docs.nats.io/nats-concepts/subjects

        :return: The filter_subject of this ApisAPIRestRespConsumerConfig.
        :rtype: str
        """
        return self._filter_subject

    @filter_subject.setter
    def filter_subject(self, filter_subject):
        """Sets the filter_subject of this ApisAPIRestRespConsumerConfig.

        FilterSubject sets the consumer to filter for subjects matching this NATs subject string  See https://docs.nats.io/nats-concepts/subjects

        :param filter_subject: The filter_subject of this ApisAPIRestRespConsumerConfig.
        :type filter_subject: str
        """

        self._filter_subject = filter_subject

    @property
    def max_ack_pending(self):
        """Gets the max_ack_pending of this ApisAPIRestRespConsumerConfig.

        MaxAckPending controls the max number of un-ACKed messages permitted in-flight

        :return: The max_ack_pending of this ApisAPIRestRespConsumerConfig.
        :rtype: int
        """
        return self._max_ack_pending

    @max_ack_pending.setter
    def max_ack_pending(self, max_ack_pending):
        """Sets the max_ack_pending of this ApisAPIRestRespConsumerConfig.

        MaxAckPending controls the max number of un-ACKed messages permitted in-flight

        :param max_ack_pending: The max_ack_pending of this ApisAPIRestRespConsumerConfig.
        :type max_ack_pending: int
        """

        self._max_ack_pending = max_ack_pending

    @property
    def max_deliver(self):
        """Gets the max_deliver of this ApisAPIRestRespConsumerConfig.

        MaxDeliver max number of times a message can be deliveried (including retry) to this consumer

        :return: The max_deliver of this ApisAPIRestRespConsumerConfig.
        :rtype: int
        """
        return self._max_deliver

    @max_deliver.setter
    def max_deliver(self, max_deliver):
        """Sets the max_deliver of this ApisAPIRestRespConsumerConfig.

        MaxDeliver max number of times a message can be deliveried (including retry) to this consumer

        :param max_deliver: The max_deliver of this ApisAPIRestRespConsumerConfig.
        :type max_deliver: int
        """

        self._max_deliver = max_deliver

    @property
    def max_waiting(self):
        """Gets the max_waiting of this ApisAPIRestRespConsumerConfig.

        MaxWaiting NATS JetStream does not clearly document this

        :return: The max_waiting of this ApisAPIRestRespConsumerConfig.
        :rtype: int
        """
        return self._max_waiting

    @max_waiting.setter
    def max_waiting(self, max_waiting):
        """Sets the max_waiting of this ApisAPIRestRespConsumerConfig.

        MaxWaiting NATS JetStream does not clearly document this

        :param max_waiting: The max_waiting of this ApisAPIRestRespConsumerConfig.
        :type max_waiting: int
        """

        self._max_waiting = max_waiting

    @property
    def notes(self):
        """Gets the notes of this ApisAPIRestRespConsumerConfig.

        Description an optional description of the consumer

        :return: The notes of this ApisAPIRestRespConsumerConfig.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ApisAPIRestRespConsumerConfig.

        Description an optional description of the consumer

        :param notes: The notes of this ApisAPIRestRespConsumerConfig.
        :type notes: str
        """

        self._notes = notes
