# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.apis_api_rest_resp_stream_info import ApisAPIRestRespStreamInfo
from httpmq.models.goutils_error_detail import GoutilsErrorDetail
from httpmq import util


class ApisAPIRestRespAllJetStreams(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        error: GoutilsErrorDetail = None,
        request_id: str = None,
        streams: Dict[str, ApisAPIRestRespStreamInfo] = None,
        success: bool = None,
    ):
        """ApisAPIRestRespAllJetStreams - a model defined in OpenAPI

        :param error: The error of this ApisAPIRestRespAllJetStreams.
        :param request_id: The request_id of this ApisAPIRestRespAllJetStreams.
        :param streams: The streams of this ApisAPIRestRespAllJetStreams.
        :param success: The success of this ApisAPIRestRespAllJetStreams.
        """
        self.openapi_types = {
            "error": GoutilsErrorDetail,
            "request_id": str,
            "streams": Dict[str, ApisAPIRestRespStreamInfo],
            "success": bool,
        }

        self.attribute_map = {
            "error": "error",
            "request_id": "request_id",
            "streams": "streams",
            "success": "success",
        }

        self._error = error
        self._request_id = request_id
        self._streams = streams
        self._success = success

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespAllJetStreams":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespAllJetStreams of this ApisAPIRestRespAllJetStreams.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def error(self):
        """Gets the error of this ApisAPIRestRespAllJetStreams.


        :return: The error of this ApisAPIRestRespAllJetStreams.
        :rtype: GoutilsErrorDetail
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ApisAPIRestRespAllJetStreams.


        :param error: The error of this ApisAPIRestRespAllJetStreams.
        :type error: GoutilsErrorDetail
        """

        self._error = error

    @property
    def request_id(self):
        """Gets the request_id of this ApisAPIRestRespAllJetStreams.

        RequestID gives the request ID to match against logs

        :return: The request_id of this ApisAPIRestRespAllJetStreams.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this ApisAPIRestRespAllJetStreams.

        RequestID gives the request ID to match against logs

        :param request_id: The request_id of this ApisAPIRestRespAllJetStreams.
        :type request_id: str
        """
        if request_id is None:
            raise ValueError("Invalid value for `request_id`, must not be `None`")

        self._request_id = request_id

    @property
    def streams(self):
        """Gets the streams of this ApisAPIRestRespAllJetStreams.

        Streams the set of stream details mapped against its names

        :return: The streams of this ApisAPIRestRespAllJetStreams.
        :rtype: Dict[str, ApisAPIRestRespStreamInfo]
        """
        return self._streams

    @streams.setter
    def streams(self, streams):
        """Sets the streams of this ApisAPIRestRespAllJetStreams.

        Streams the set of stream details mapped against its names

        :param streams: The streams of this ApisAPIRestRespAllJetStreams.
        :type streams: Dict[str, ApisAPIRestRespStreamInfo]
        """

        self._streams = streams

    @property
    def success(self):
        """Gets the success of this ApisAPIRestRespAllJetStreams.

        Success indicates whether the request was successful

        :return: The success of this ApisAPIRestRespAllJetStreams.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this ApisAPIRestRespAllJetStreams.

        Success indicates whether the request was successful

        :param success: The success of this ApisAPIRestRespAllJetStreams.
        :type success: bool
        """
        if success is None:
            raise ValueError("Invalid value for `success`, must not be `None`")

        self._success = success
