# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.apis_api_rest_resp_consumer_info import ApisAPIRestRespConsumerInfo
from httpmq.models.goutils_error_detail import GoutilsErrorDetail
from httpmq import util


class ApisAPIRestRespAllJetStreamConsumers(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        consumers: Dict[str, ApisAPIRestRespConsumerInfo] = None,
        error: GoutilsErrorDetail = None,
        request_id: str = None,
        success: bool = None,
    ):
        """ApisAPIRestRespAllJetStreamConsumers - a model defined in OpenAPI

        :param consumers: The consumers of this ApisAPIRestRespAllJetStreamConsumers.
        :param error: The error of this ApisAPIRestRespAllJetStreamConsumers.
        :param request_id: The request_id of this ApisAPIRestRespAllJetStreamConsumers.
        :param success: The success of this ApisAPIRestRespAllJetStreamConsumers.
        """
        self.openapi_types = {
            "consumers": Dict[str, ApisAPIRestRespConsumerInfo],
            "error": GoutilsErrorDetail,
            "request_id": str,
            "success": bool,
        }

        self.attribute_map = {
            "consumers": "consumers",
            "error": "error",
            "request_id": "request_id",
            "success": "success",
        }

        self._consumers = consumers
        self._error = error
        self._request_id = request_id
        self._success = success

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespAllJetStreamConsumers":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespAllJetStreamConsumers of this ApisAPIRestRespAllJetStreamConsumers.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def consumers(self):
        """Gets the consumers of this ApisAPIRestRespAllJetStreamConsumers.

        Consumers the set of consumer details mapped against consumer name

        :return: The consumers of this ApisAPIRestRespAllJetStreamConsumers.
        :rtype: Dict[str, ApisAPIRestRespConsumerInfo]
        """
        return self._consumers

    @consumers.setter
    def consumers(self, consumers):
        """Sets the consumers of this ApisAPIRestRespAllJetStreamConsumers.

        Consumers the set of consumer details mapped against consumer name

        :param consumers: The consumers of this ApisAPIRestRespAllJetStreamConsumers.
        :type consumers: Dict[str, ApisAPIRestRespConsumerInfo]
        """

        self._consumers = consumers

    @property
    def error(self):
        """Gets the error of this ApisAPIRestRespAllJetStreamConsumers.


        :return: The error of this ApisAPIRestRespAllJetStreamConsumers.
        :rtype: GoutilsErrorDetail
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ApisAPIRestRespAllJetStreamConsumers.


        :param error: The error of this ApisAPIRestRespAllJetStreamConsumers.
        :type error: GoutilsErrorDetail
        """

        self._error = error

    @property
    def request_id(self):
        """Gets the request_id of this ApisAPIRestRespAllJetStreamConsumers.

        RequestID gives the request ID to match against logs

        :return: The request_id of this ApisAPIRestRespAllJetStreamConsumers.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this ApisAPIRestRespAllJetStreamConsumers.

        RequestID gives the request ID to match against logs

        :param request_id: The request_id of this ApisAPIRestRespAllJetStreamConsumers.
        :type request_id: str
        """
        if request_id is None:
            raise ValueError("Invalid value for `request_id`, must not be `None`")

        self._request_id = request_id

    @property
    def success(self):
        """Gets the success of this ApisAPIRestRespAllJetStreamConsumers.

        Success indicates whether the request was successful

        :return: The success of this ApisAPIRestRespAllJetStreamConsumers.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this ApisAPIRestRespAllJetStreamConsumers.

        Success indicates whether the request was successful

        :param success: The success of this ApisAPIRestRespAllJetStreamConsumers.
        :type success: bool
        """
        if success is None:
            raise ValueError("Invalid value for `success`, must not be `None`")

        self._success = success
