# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ApisAPIRestReqStreamSubjects(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, subjects: List[str] = None):
        """ApisAPIRestReqStreamSubjects - a model defined in OpenAPI

        :param subjects: The subjects of this ApisAPIRestReqStreamSubjects.
        """
        self.openapi_types = {"subjects": List[str]}

        self.attribute_map = {"subjects": "subjects"}

        self._subjects = subjects

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestReqStreamSubjects":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestReqStreamSubjects of this ApisAPIRestReqStreamSubjects.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def subjects(self):
        """Gets the subjects of this ApisAPIRestReqStreamSubjects.

        Subjects the list of new subject this stream will listen to

        :return: The subjects of this ApisAPIRestReqStreamSubjects.
        :rtype: List[str]
        """
        return self._subjects

    @subjects.setter
    def subjects(self, subjects):
        """Sets the subjects of this ApisAPIRestReqStreamSubjects.

        Subjects the list of new subject this stream will listen to

        :param subjects: The subjects of this ApisAPIRestReqStreamSubjects.
        :type subjects: List[str]
        """
        if subjects is None:
            raise ValueError("Invalid value for `subjects`, must not be `None`")
        if subjects is not None and len(subjects) < 1:
            raise ValueError(
                "Invalid value for `subjects`, number of items must be greater than or equal to `1`"
            )

        self._subjects = subjects
