[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1341346.svg)](https://doi.org/10.5281/zenodo.1341346)
[![Build Status](https://travis-ci.com/raysect/source.svg?branch=master)](https://travis-ci.com/raysect/source)

<a name="logo"/>
<a href="https://www.raysect.org/" target="_blank">
<img src="https://raysect.github.io/documentation/_images/RaysectLogo_small.png" alt="Raysect Logo"></img>
</a>

Raysect Python Raytracing Package
=================================

A ray-tracing framework for optical/non-optical physics simulations.

The aims of the Raysect project are as follows:

* develop a ray-tracer that is easy for scientists and engineers to use and extend

* the raytracer must be robust and high precision

The general development philosophy is ease of use trumps performance, but performance is not to be ignored.

For more information, see the [documentation pages](http://www.raysect.org/).


![Dispersion of light passing through a prism](docs/source/demonstrations/optics/prism_720x405.png)

*Caption: a simulation of Newton's classic experiment, white light being dispersed by a glass prism.*


Please note, this code is currently under heavy development and subject to change.

Raysect currently only supports Linux. Windows support will come at a later stage.

Please note, for legal reasons we require the copyright to any contributed code to be passed to the Raysect project. Please see CONTRIBUTING.txt in the repository.

Development Team
----------------

* Dr Alex Meakins
* Dr Matthew Carr

Citing the Code
---------------

* Dr Alex Meakins, & Matthew Carr. (2018, August 7). raysect/source: v0.5.2 Release (Version v0.5.2). Zenodo. http://doi.org/10.5281/zenodo.1341376
