# Generated by Django 2.2.11 on 2020-04-13 16:39

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0027_export_backend'),
    ]

    operations = [
        migrations.CreateModel(
            name='Import',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('params', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Importer',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('pulp_type', models.TextField(default=None)),
                ('name', models.TextField(db_index=True, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PulpImport',
            fields=[
                ('import_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_pulp_export', serialize=False, to='core.Import')),
            ],
            options={
                'default_related_name': '%(app_label)s_pulp_export',
            },
            bases=('core.import',),
        ),
        migrations.CreateModel(
            name='PulpImporter',
            fields=[
                ('importer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_pulp_importer', serialize=False, to='core.Importer')),
            ],
            options={
                'default_related_name': '%(app_label)s_pulp_importer',
            },
            bases=('core.importer',),
        ),
        migrations.AddField(
            model_name='import',
            name='importer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Importer'),
        ),
        migrations.AddField(
            model_name='import',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.Task'),
        ),
        migrations.CreateModel(
            name='PulpImporterRepository',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('source_repo', models.TextField()),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Repository')),
                ('pulp_importer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='repo_map', to='core.PulpImporter')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
