# Generated by Django 2.2.6 on 2020-03-17 19:43

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('core', '0022_rename_last_version'),
    ]

    operations = [
        migrations.CreateModel(
            name='Export',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('params', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExportedResource',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('object_id', models.UUIDField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('export', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='exported_resources', to='core.Export')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Exporter',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('pulp_type', models.TextField(default=None)),
                ('name', models.TextField(db_index=True, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.DeleteModel(
            name='FileSystemExporter',
        ),
        migrations.AddField(
            model_name='export',
            name='exporter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Exporter'),
        ),
        migrations.AddField(
            model_name='export',
            name='task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.Task'),
        ),
        migrations.CreateModel(
            name='PulpExporter',
            fields=[
                ('exporter_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_pulp_exporter', serialize=False, to='core.Exporter')),
                ('path', models.TextField()),
                ('last_export', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='core_pulp_exporter', to='core.Export')),
                ('repositories', models.ManyToManyField(related_name='core_pulp_exporter', to='core.Repository')),
            ],
            options={
                'default_related_name': '%(app_label)s_pulp_exporter',
            },
            bases=('core.exporter',),
        ),
    ]
