# Generated by Django 2.2.2 on 2019-06-28 13:08

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import pulpcore.app.models.content
import pulpcore.app.models.fields
import pulpcore.app.models.publication
import pulpcore.app.models.task
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Artifact',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('file', pulpcore.app.models.fields.ArtifactFileField(max_length=255, upload_to=pulpcore.app.models.content.Artifact.storage_path)),
                ('size', models.IntegerField()),
                ('md5', models.CharField(db_index=True, max_length=32)),
                ('sha1', models.CharField(db_index=True, max_length=40)),
                ('sha224', models.CharField(db_index=True, max_length=56)),
                ('sha256', models.CharField(db_index=True, max_length=64, unique=True)),
                ('sha384', models.CharField(db_index=True, max_length=96, unique=True)),
                ('sha512', models.CharField(db_index=True, max_length=128, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Content',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
            ],
            options={
                'verbose_name_plural': 'content',
            },
            bases=(models.Model, pulpcore.app.models.content.QueryMixin),
        ),
        migrations.CreateModel(
            name='ContentAppStatus',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('last_heartbeat', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentArtifact',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('relative_path', models.CharField(max_length=255)),
                ('artifact', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='core.Artifact')),
                ('content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Content')),
            ],
            options={
                'unique_together': {('content', 'relative_path')},
            },
            bases=(models.Model, pulpcore.app.models.content.QueryMixin),
        ),
        migrations.CreateModel(
            name='ContentGuard',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Exporter',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('last_export', models.DateTimeField(null=True)),
            ],
            options={
                'default_related_name': 'exporters',
            },
        ),
        migrations.CreateModel(
            name='Publisher',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
            ],
            options={
                'default_related_name': 'publishers',
            },
        ),
        migrations.CreateModel(
            name='Remote',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('url', models.TextField()),
                ('ssl_ca_certificate', models.TextField(null=True)),
                ('ssl_client_certificate', models.TextField(null=True)),
                ('ssl_client_key', models.TextField(null=True)),
                ('ssl_validation', models.BooleanField(default=True)),
                ('proxy_url', models.TextField(null=True)),
                ('username', models.TextField(null=True)),
                ('password', models.TextField(null=True)),
                ('download_concurrency', models.PositiveIntegerField(default=20)),
                ('policy', models.TextField(choices=[('immediate', 'When syncing, download all metadata and content now.'), ('on_demand', 'When syncing, download metadata, but do not download content now. Instead, download content as clients request it, and save it in Pulp to be served for future client requests.'), ('streamed', 'When syncing, download metadata, but do not download content now. Instead,download content as clients request it, but never save it in Pulp. This causes future requests for that same content to have to be downloaded again.')], default='immediate')),
            ],
            options={
                'default_related_name': 'remotes',
            },
        ),
        migrations.CreateModel(
            name='Repository',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('description', models.TextField(null=True)),
                ('last_version', models.PositiveIntegerField(default=0)),
            ],
            options={
                'verbose_name_plural': 'repositories',
            },
        ),
        migrations.CreateModel(
            name='RepositoryVersion',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('number', models.PositiveIntegerField(db_index=True)),
                ('complete', models.BooleanField(db_index=True, default=False)),
                ('base_version', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='versions', to='core.RepositoryVersion')),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='core.Repository')),
            ],
            options={
                'ordering': ('number',),
                'get_latest_by': 'number',
                'default_related_name': 'versions',
                'unique_together': {('repository', 'number')},
            },
        ),
        migrations.CreateModel(
            name='ReservedResource',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('resource', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('state', models.TextField(choices=[('waiting', 'Waiting'), ('skipped', 'Skipped'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('canceled', 'Canceled')])),
                ('name', models.CharField(max_length=255)),
                ('started_at', models.DateTimeField(null=True)),
                ('finished_at', models.DateTimeField(null=True)),
                ('non_fatal_errors', django.contrib.postgres.fields.JSONField(default=list)),
                ('error', django.contrib.postgres.fields.JSONField(null=True)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='spawned_tasks', to='core.Task')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Upload',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('file', models.FileField(max_length=255, upload_to='')),
                ('size', models.BigIntegerField()),
                ('completed', models.DateTimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Worker',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('last_heartbeat', models.DateTimeField(auto_now=True)),
                ('gracefully_stopped', models.BooleanField(default=False)),
                ('cleaned_up', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UploadChunk',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('offset', models.BigIntegerField()),
                ('size', models.BigIntegerField()),
                ('upload', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chunks', to='core.Upload')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TaskReservedResource',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('resource', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ReservedResource')),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.Task')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='task',
            name='worker',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tasks', to='core.Worker'),
        ),
        migrations.AddField(
            model_name='reservedresource',
            name='tasks',
            field=models.ManyToManyField(related_name='reserved_resources', through='core.TaskReservedResource', to='core.Task'),
        ),
        migrations.AddField(
            model_name='reservedresource',
            name='worker',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reservations', to='core.Worker'),
        ),
        migrations.CreateModel(
            name='RepositoryVersionContentDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count_type', models.CharField(choices=[('A', 'added'), ('P', 'present'), ('R', 'removed')], max_length=1)),
                ('content_type', models.TextField()),
                ('count', models.IntegerField()),
                ('repository_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='counts', to='core.RepositoryVersion')),
            ],
        ),
        migrations.CreateModel(
            name='RepositoryContent',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='version_memberships', to='core.Content')),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Repository')),
                ('version_added', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='added_memberships', to='core.RepositoryVersion')),
                ('version_removed', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='removed_memberships', to='core.RepositoryVersion')),
            ],
            options={
                'unique_together': {('repository', 'content', 'version_added'), ('repository', 'content', 'version_removed')},
            },
        ),
        migrations.AddField(
            model_name='repository',
            name='content',
            field=models.ManyToManyField(related_name='repositories', through='core.RepositoryContent', to='core.Content'),
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('complete', models.BooleanField(db_index=True, default=False)),
                ('pass_through', models.BooleanField(default=False)),
                ('publisher', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Publisher')),
                ('repository_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.RepositoryVersion')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProgressReport',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('message', models.TextField()),
                ('state', models.TextField(choices=[('waiting', 'Waiting'), ('skipped', 'Skipped'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('canceled', 'Canceled')], default='waiting')),
                ('total', models.IntegerField(null=True)),
                ('done', models.IntegerField(default=0)),
                ('suffix', models.TextField(null=True)),
                ('task', models.ForeignKey(default=pulpcore.app.models.task.Task.current, on_delete=django.db.models.deletion.CASCADE, related_name='progress_reports', to='core.Task')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CreatedResource',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('object_id', models.UUIDField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('task', models.ForeignKey(default=pulpcore.app.models.task.Task.current, on_delete=django.db.models.deletion.CASCADE, related_name='created_resources', to='core.Task')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='content',
            name='_artifacts',
            field=models.ManyToManyField(through='core.ContentArtifact', to='core.Artifact'),
        ),
        migrations.CreateModel(
            name='BaseDistribution',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_type', models.TextField(default=None)),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('base_path', models.CharField(max_length=255, unique=True)),
                ('content_guard', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.ContentGuard')),
                ('remote', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.Remote')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProgressBar',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('core.progressreport',),
        ),
        migrations.CreateModel(
            name='ProgressSpinner',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('core.progressreport',),
        ),
        migrations.CreateModel(
            name='RemoteArtifact',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('url', models.TextField(validators=[django.core.validators.URLValidator])),
                ('size', models.IntegerField(null=True)),
                ('md5', models.CharField(max_length=32, null=True)),
                ('sha1', models.CharField(max_length=40, null=True)),
                ('sha224', models.CharField(max_length=56, null=True)),
                ('sha256', models.CharField(max_length=64, null=True)),
                ('sha384', models.CharField(max_length=96, null=True)),
                ('sha512', models.CharField(max_length=128, null=True)),
                ('content_artifact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ContentArtifact')),
                ('remote', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Remote')),
            ],
            options={
                'unique_together': {('content_artifact', 'remote')},
            },
            bases=(models.Model, pulpcore.app.models.content.QueryMixin),
        ),
        migrations.CreateModel(
            name='PublishedMetadata',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('relative_path', models.CharField(max_length=255)),
                ('file', models.FileField(max_length=255, upload_to='')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='published_metadata', to='core.Publication')),
            ],
            options={
                'default_related_name': 'published_metadata',
                'unique_together': {('publication', 'relative_path'), ('publication', 'file')},
            },
        ),
        migrations.CreateModel(
            name='PublishedArtifact',
            fields=[
                ('_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('_created', models.DateTimeField(auto_now_add=True)),
                ('_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('relative_path', models.CharField(max_length=255)),
                ('content_artifact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='published_artifact', to='core.ContentArtifact')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='published_artifact', to='core.Publication')),
            ],
            options={
                'default_related_name': 'published_artifact',
                'unique_together': {('publication', 'content_artifact'), ('publication', 'relative_path')},
            },
        ),
    ]
