from .test31 import Test31


class WorkersTest(Test31):
    # TODO(kavigupta) we probably should have some way to test the async aspect, which we aren't doing
    def test_fw(self):
        self.assertOutput(
            [
                "31",
                "c",
                "-s",
                "-w",
                "2",
                "-fw",
                "%w",
                "w1,w2",
                "-f",
                "%x",
                "a,b,c",
                "--no-email",
                "echo %x.%w",
            ],
            [
                "Completed: 0, In Progress: 0, Queued: 3",
                "Launching echo_a.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_a.w1'",
                "a.w1",
                "END SCREEN",
                "Completed: 1, In Progress: 0, Queued: 2",
                "Launching echo_b.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_b.w1'",
                "b.w1",
                "END SCREEN",
                "Completed: 2, In Progress: 0, Queued: 1",
                "Launching echo_c.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_c.w1'",
                "c.w1",
                "END SCREEN",
                "All tasks completed",
                "",
            ],
        )

    def test_worker_thread(self):
        self.assertOutput(
            [
                "31",
                "c",
                "-w",
                "2",
                "-fw",
                "%w",
                "w1,w2",
                "-f",
                "%x",
                "a,b,c",
                "--no-email",
                "echo %x.%w",
            ],
            [
                "BEGIN SCREEN",
                "NAME = 'worker-monitor'",
                "Completed: 0, In Progress: 0, Queued: 3",
                "Launching echo_a.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_a.w1'",
                "a.w1",
                "END SCREEN",
                "Completed: 1, In Progress: 0, Queued: 2",
                "Launching echo_b.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_b.w1'",
                "b.w1",
                "END SCREEN",
                "Completed: 2, In Progress: 0, Queued: 1",
                "Launching echo_c.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_c.w1'",
                "c.w1",
                "END SCREEN",
                "All tasks completed",
                "END SCREEN",
                "",
            ],
        )

    def test_named_worker_thread(self):
        self.assertOutput(
            [
                "31",
                "c",
                "-w",
                "2",
                "-wn",
                "abc",
                "-fw",
                "%w",
                "w1,w2",
                "-f",
                "%x",
                "a,b,c",
                "--no-email",
                "echo %x.%w",
            ],
            [
                "BEGIN SCREEN",
                "NAME = 'abc'",
                "Completed: 0, In Progress: 0, Queued: 3",
                "Launching echo_a.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_a.w1'",
                "a.w1",
                "END SCREEN",
                "Completed: 1, In Progress: 0, Queued: 2",
                "Launching echo_b.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_b.w1'",
                "b.w1",
                "END SCREEN",
                "Completed: 2, In Progress: 0, Queued: 1",
                "Launching echo_c.w1",
                "BEGIN SCREEN",
                "NAME = 'echo_c.w1'",
                "c.w1",
                "END SCREEN",
                "All tasks completed",
                "END SCREEN",
                "",
            ],
        )
