# How to Contribute to ogs5py

We are happy about all contributions! :thumbsup:


## Did you find a bug?

- Ensure that the bug was not already reported under
[GitHub issues](https://github.com/GeoStat-Framework/ogs5py/issues)
- If the bug wasn't already reported, open a
[new issue](https://github.com/GeoStat-Framework/ogs5py/issues) with a clear
description of the problem and if possible with a
[minimal working example](https://en.wikipedia.org/wiki/Minimal_working_example).
- please add the version number to the issue:

```python
import ogs5py
print(ogs5py.__version__)
```


## Do you have suggestions for new features?

Open a [new issue](https://github.com/GeoStat-Framework/ogs5py/issues)
with your idea or suggestion and we'd love to discuss about it.
 

## Do you want to enhance GSTools or fix something?

- Fork the repo on [GitHub](https://github.com/GeoStat-Framework/ogs5py).
- Add yourself to AUTHORS.md (if you want to).
- We use the black code format, please use the script `black --line-length 79 ogs5py/` after you have written your code.
- Add some tests if possible.
- Push to your fork and submit a pull request.
