# Stars in Hipparcos catalogue whose magnitudes are <=6
# or are present in constellationship.fab
hip_stars = """
hip,ra,dec,Vmag
71683,219.90206584,-60.83397468,-0.01
53253,163.37356736,-58.8531708,3.78
8198,26.34846064,9.15773579,4.26
26634,84.91224946,-34.07410786,2.65
79882,244.58037087,-4.69251067,3.23
92175,281.79363678,-4.74786733,4.22
86032,263.73362733,12.56003477,2.08
110609,336.12912965,49.47639255,4.55
14354,46.29413912,38.84027386,3.32
57363,176.40174608,-66.72876272,3.63
22549,72.80151623,5.60510396,3.68
102422,311.32239594,61.83878197,3.41
24608,79.1723294,45.99799111,0.08
51233,156.97083204,36.70721174,4.2
2081,6.57104571,-42.30598151,2.4
116771,354.98767042,5.62629159,4.13
114724,348.58066516,-6.04900282,4.22
98337,299.68928113,19.49214775,3.51
57380,176.46482927,6.52937639,4.04
69673,213.9153001,19.1824103,-0.05
84012,257.59453052,-15.72491023,2.43
28716,90.97993717,20.13845182,4.64
6193,19.86664622,27.26405858,4.74
36917,113.845387,-28.36932346,4.65
20535,66.00923865,-34.01684639,3.97
57399,176.51255835,47.77940596,3.69
59449,182.91296303,-52.36846029,3.97
28734,91.03006202,23.26334108,4.16
116805,355.10211725,44.33393168,4.15
69701,214.00362402,-6.00054666,4.07
90185,276.04299301,-34.38461611,1.79
104521,317.58541733,10.13157953,4.7
112716,342.39792615,-13.59263187,4.05
41037,125.6284816,-59.50948307,1.86
110672,336.31926326,1.37740059,4.8
112724,342.42006922,66.2004077,3.5
102485,311.52388737,-25.27089759,4.13
102488,311.55284473,33.9702561,2.48
43103,131.67425219,28.75989827,4.03
36962,113.98060996,26.89574074,4.06
12387,39.87065299,0.32851065,4.08
69732,214.09591139,46.08830542,4.18
100453,305.5570912,40.25667924,2.23
43109,131.6937942,6.41880927,3.38
26727,85.18969642,-1.94257224,1.74
18532,59.4634614,40.01021467,2.9
112748,342.50080334,24.60157928,3.51
18543,59.50735988,-13.50851533,2.97
41075,125.70879003,43.18813064,4.25
71795,220.2872992,13.72830024,3.78
79992,244.93515331,46.31336639,3.91
63608,195.54415463,10.95915037,2.85
12413,39.94996945,-42.89166991,4.74
63613,195.56776386,-71.54885522,3.61
80000,244.96009378,-50.15550766,4.01
55425,170.25169486,-54.4910193,3.9
77952,238.78567608,-63.43072662,2.83
102532,311.66459285,16.12429621,4.27
55434,170.28414306,6.02932171,4.05
61585,189.29590999,-69.13556382,2.69
30867,97.20445834,-7.0330625,3.76
16537,53.23268409,-9.45826215,3.72
82080,251.49268245,82.03726206,4.21
51362,157.36959259,-2.73907802,5.19
30883,97.24077812,20.21213298,4.13
18597,59.68645594,-61.40018557,4.56
94376,288.13875006,67.66154129,3.07
80047,245.08668995,-78.69574502,4.68
84143,258.03830643,-43.23918896,3.32
71860,220.48231508,-47.38820014,2.3
45238,138.29989786,-69.71720773,1.67
18614,59.74125467,35.7910326,3.98
98495,300.14813841,-72.91050366,3.97
116928,355.51169238,1.78004078,4.49
12484,40.1650536,-54.54991148,5.21
12486,40.1668101,-39.8553755,4.11
96468,294.18032351,-1.2866009,4.36
86228,264.32971086,-42.99782386,1.86
102618,311.91896433,-9.49577573,3.78
43234,132.10821073,5.83781245,4.35
106723,324.27012962,-19.46601155,4.51
71908,220.62674745,-64.97513849,3.18
16611,53.44698381,-21.63288274,4.26
51437,157.57283183,-0.63702597,5.08
28910,91.53884928,-14.9352543,4.67
14576,47.04221485,40.9556477,2.09
18673,59.98118081,-24.01621526,4.62
80112,245.29715015,-25.59279641,2.9
110838,336.83319902,-64.96635445,4.51
86263,264.39667273,-15.39855727,3.54
78072,239.11326153,15.66161688,3.85
33018,103.19724251,33.96125399,3.6
49402,151.28112504,-13.06462598,4.6
53502,164.17937983,-37.1377655,4.6
22783,73.51254722,66.34267806,4.26
92420,282.51997782,33.36266704,3.52
24845,79.89385195,-13.1767885,4.29
22797,73.56290198,2.44067205,3.71
71957,220.76509742,-5.65820663,3.87
45336,138.59107912,2.3142803,3.89
78104,239.22115205,-29.21407322,3.87
114971,349.29140788,3.28228889,3.7
104732,318.2341091,30.22691571,3.21
57632,177.26490656,14.57206032,2.14
18724,60.17006562,12.49034659,3.41
14632,47.26674871,49.61327752,4.05
80170,245.48005997,19.15313028,3.74
112948,343.13139485,-32.87550403,4.46
114996,349.3573889,-58.23573417,3.99
90422,276.74340114,-45.96845881,3.49
22845,73.72386617,10.1508331,4.64
112961,343.15364976,-7.57959928,3.73
47431,144.96400779,-1.14281015,3.9
4427,14.17721554,60.71674038,2.15
14668,47.37404785,44.8575437,3.79
78159,239.39688262,26.8778799,4.14
4436,14.18838148,38.49934462,3.86
67927,208.67116138,18.39771704,2.68
115033,349.47589677,-9.18251333,4.41
55642,170.9810513,10.52950862,4.0
61789,189.96887275,-39.9873025,4.63
76127,233.23242724,31.35913344,4.14
41312,126.43414409,-66.13689023,3.77
82273,252.16622864,-69.02771504,1.91
59747,183.78631548,-58.74892785,2.79
12653,40.63944366,-50.80029384,5.4
37229,114.70779243,-26.8038363,3.8
4463,14.30166657,23.41764802,4.4
110960,337.20796732,-0.01997197,3.65
29038,91.89302018,14.7684717,4.42
51576,158.00609749,-61.68533255,3.3
84345,258.66191003,14.39033281,2.78
59774,183.85650051,57.0326169,3.32
33152,103.53313596,-24.18421076,3.89
90496,276.99266896,-25.42170011,2.82
55687,171.15246271,-10.85932331,4.81
33160,103.54749079,-12.0386279,4.08
6537,21.00585424,-8.18325655,3.6
86414,264.86619338,46.00633181,3.82
110991,337.29277618,58.41519853,4.07
65936,202.76106938,-39.40730717,3.9
100751,306.41190763,-56.7350901,1.94
43409,132.63301402,-27.70984441,4.02
110997,337.3173945,-43.49556461,3.97
55705,171.22051587,-17.68400965,4.06
104858,318.62006328,10.00698105,4.47
84379,258.75796073,24.83920414,3.12
84380,258.76180979,36.80916183,3.16
59803,183.95154259,-17.54192947,2.58
115102,349.70600166,-32.53202671,4.41
37279,114.82549301,5.22499306,0.4
20894,67.16558676,15.87088266,3.4
20889,67.15416474,19.18043155,3.53
68002,208.88494064,-47.28837511,2.55
12706,40.8251625,3.23581853,3.47
57757,177.67382733,1.76471793,3.59
35228,109.20760182,-67.95715182,3.97
72105,221.24674043,27.07422244,2.35
22957,74.09281008,13.51446582,4.06
111022,337.38259256,47.70688669,4.34
49583,151.83313456,16.76266443,3.48
102831,312.49200878,-33.77972227,4.89
10670,34.32861359,33.84719358,4.03
2484,7.88611087,-62.95821764,4.36
49593,151.85733981,35.24469332,4.49
78265,239.71297035,-26.11410529,2.89
82363,252.4464847,-59.04137792,3.77
27072,86.11579339,-22.44838217,3.59
92609,283.05431199,-62.18759351,4.22
35264,109.28565178,-37.09746988,2.71
8645,27.86513997,-10.33503772,3.74
90568,277.2077448,-49.07058791,4.1
70090,215.13929846,-37.88529479,4.05
80331,245.9978587,61.51421312,2.73
16852,54.21826338,0.40166163,4.29
80343,246.02576647,-20.03732689,4.48
18907,60.78908352,5.98930513,3.91
27100,86.19324494,-65.73552592,4.34
82396,252.54088739,-34.29323171,2.29
4577,14.65150376,-29.35744905,4.3
12770,41.03062458,-13.85869636,4.24
90595,277.29939072,-14.56581345,4.67
16870,54.27366762,-40.27454534,4.57
23015,74.24841152,33.16609031,2.69
106985,325.02273477,-16.6623077,3.69
12777,41.04994313,49.22844773,4.1
76267,233.67195048,26.71469302,2.22
61932,190.37932752,-48.95988844,2.2
53740,164.94360292,-18.29878342,4.08
49641,151.98450128,-0.37163673,4.48
113136,343.66255214,-15.82082024,3.27
31216,98.22594705,7.33296511,4.47
45556,139.27252781,-59.27522929,2.21
76276,233.70061304,10.53886686,3.8
96757,295.02413251,18.01389046,4.39
61941,190.41517626,-1.44937487,2.74
23040,74.3216524,53.75210119,4.43
111104,337.6219165,43.12337585,4.52
49669,152.0929611,11.96720706,1.36
39429,120.89602782,-40.0031477,2.21
76297,233.78519974,-41.166757,2.8
109074,331.4459822,-0.3198507,2.95
35350,109.52324476,16.54038314,3.58
59929,184.39282008,-67.9607357,4.06
104987,318.9559653,5.24784463,3.92
12828,41.23559307,10.1141459,4.27
72220,221.56218374,1.89288544,3.73
6686,21.45396795,60.23528317,2.66
14879,48.01886556,-28.98761809,3.8
12843,41.27577129,-18.57256259,4.47
76333,233.88157906,-14.78953681,3.91
78384,240.03053401,-38.39670656,3.42
109111,331.52868903,-39.54335326,4.47
94779,289.27570325,53.36845943,3.8
88635,271.45202872,-30.42409129,2.98
111169,337.82292092,50.28249144,3.76
102978,312.95537911,-26.91913259,4.12
33347,104.03427011,-17.05424211,4.36
78401,240.08335942,-22.62170993,2.29
21060,67.70874876,-44.95374954,5.07
96837,295.26224687,17.47604116,4.39
37447,115.31180176,-9.55113089,3.94
10826,34.83663617,-2.97764262,6.47
102989,312.99483886,-33.17797395,6.06
80463,246.35397192,14.03326957,4.57
57936,178.22716875,-33.90812431,4.29
107089,325.36935979,-77.39004641,3.73
82514,252.96763467,-38.04737967,3.0
109139,331.60929021,-13.86967906,4.29
111188,337.87637809,-32.34607343,4.29
23123,74.63709138,1.71401579,4.47
29271,92.56030656,-74.75304517,5.08
80473,246.39632325,-23.4471785,4.57
8796,28.27044954,29.57882927,3.42
113246,343.9870813,-32.53962827,4.2
60000,184.58676739,-79.31223982,4.24
92791,283.62618249,36.8986131,4.22
45688,139.71101495,36.80259678,3.82
109176,331.75277532,25.34511155,3.77
51839,158.86710909,-78.60778577,4.11
8832,28.38255961,19.29385177,3.88
88714,271.65779638,-50.09147713,3.65
86670,265.62197877,-39.02998302,2.39
58001,178.45769772,53.69476008,2.41
68245,209.56777521,-42.10075343,3.83
53910,165.46031999,56.38242679,2.34
27288,86.73891997,-14.82195004,3.55
76440,234.18009374,-66.31703754,4.11
74395,228.071229,-52.09924722,3.41
78493,240.36068726,29.85106144,4.98
677,2.09691071,29.09043199,2.07
33449,104.31919106,58.42275948,4.35
49841,152.64698939,-12.35408295,3.61
72370,221.96545315,-79.0447507,3.83
76470,234.25604093,-28.13507945,3.6
92855,283.81635716,-26.29672225,2.05
8886,28.59885632,63.67010151,3.35
80569,246.75597864,-18.45625099,4.22
68282,209.66978489,-44.80358412,3.87
27321,86.82119852,-51.06651408,3.85
78527,240.47227393,58.56525152,4.01
25281,81.11923643,-2.39714624,3.35
80582,246.79598315,-47.55478604,4.46
8903,28.66003816,20.80803505,2.64
66249,203.67330011,-0.59582018,3.38
117452,357.231442,-28.13026767,4.59
6867,22.09136277,-43.31823391,3.41
109268,332.0582728,-46.96097543,1.73
86742,265.86813797,4.56730281,2.76
113368,344.41269372,-29.62223615,1.17
88794,271.88562777,28.7624885,3.84
35550,110.03073983,21.98232055,3.5
19167,61.64601411,50.35126182,4.25
60129,184.97648721,-0.66680331,3.89
101093,307.3953547,62.99410487,4.21
27366,86.93912023,-9.66960478,2.07
109285,332.09587026,-32.98846846,4.5
41704,127.56612488,60.71816925,3.35
746,2.29452113,59.1497796,2.28
115438,350.74261152,-20.10058008,3.96
105199,319.64488119,62.58557261,2.45
64238,197.48746449,-5.53900959,4.38
64241,197.49698594,17.52943143,4.32
29426,92.98498257,14.20876508,4.45
80628,246.95078039,-8.37173117,4.62
25336,81.28276276,6.34970223,1.64
11001,35.43726143,-68.65941811,4.08
107259,325.87692018,58.78004608,4.23
765,2.35267495,-45.74742618,3.88
21248,68.37730272,-29.7664919,4.49
92946,284.0549266,4.20359514,4.62
21281,68.49907315,-55.04497465,3.3
88866,272.14505748,-63.66855312,4.33
47908,146.46280429,23.77425466,2.97
43813,133.84844309,5.94556331,3.11
45860,140.26375544,34.39256184,3.14
82729,253.64585529,-42.36131277,3.62
4906,15.73586845,7.89013546,4.27
33579,104.65645182,-28.97208374,1.5
37677,115.95195447,-28.95482577,3.94
54061,165.93195289,61.7510332,1.81
9007,28.98946829,-51.60889586,3.69
78639,240.80373746,-49.22969549,4.65
107315,326.04649214,9.87501126,2.38
76600,234.66403964,-29.77775386,3.66
103227,313.70251293,-58.45415486,3.67
58188,179.0039732,-17.15082863,5.17
39757,121.88603686,-24.30432404,2.83
25428,81.57297249,28.60745001,1.65
93015,284.23762024,-67.23349464,4.4
107354,326.16139335,25.64503558,4.14
13147,42.27258148,-32.40589767,4.45
2912,9.22020689,33.71934362,4.34
70497,216.2991518,51.85074357,4.04
109410,332.49685019,33.17822387,4.28
90982,278.3757739,-42.31250982,4.62
105319,319.96662074,-53.44942748,4.39
31592,99.17098928,-19.2558792,3.95
37740,116.11189245,24.3979926,3.57
62322,191.57002677,-68.10811913,3.04
109427,332.54993837,6.19786491,3.52
107380,326.23670806,-33.02578153,4.35
45941,140.52840967,-55.01066799,2.47
39794,121.98247078,-68.61706214,4.35
23416,75.49222568,43.82330836,3.03
80763,247.35192046,-26.43200249,1.06
72571,222.57212471,-27.96037084,4.42
111497,338.83908579,-0.11749758,4.04
64394,197.9683061,27.87818312,4.23
27530,87.45692625,-56.16666304,4.5
97165,296.24365768,45.13080969,2.86
19343,62.1653782,47.71251275,3.96
21393,68.88766065,-30.56234148,3.81
86929,266.4332804,-64.72387151,3.61
56211,172.8509187,69.33107594,3.82
13209,42.49596812,27.26050706,3.61
23453,75.61952888,41.07583744,3.69
33694,105.01682255,76.97740778,4.55
93085,284.43250651,-21.1066543,3.52
72607,222.67636006,74.15550491,2.07
99240,302.18170154,-66.18206819,3.55
68520,210.41163881,1.54453185,4.23
74666,228.87567917,33.31483347,3.46
7083,22.81293588,-49.07270222,3.93
23467,75.67916017,-71.31430012,5.3
21421,68.9801611,16.50930139,0.87
72622,222.71963807,-16.04177818,2.75
80816,247.55499986,21.48961328,2.78
50099,153.43424113,-70.03790334,3.29
109492,332.71365289,58.20126083,3.39
56243,172.94195189,-59.44206107,5.07
39863,122.14853276,-2.98378594,4.36
7097,22.87087261,15.34582301,3.62
86974,266.61469538,27.72067625,3.42
95168,290.41816155,-17.84719749,3.92
31681,99.42792124,16.39925217,1.93
37826,116.32895983,28.02619862,1.16
21444,69.07975664,-3.35245903,3.93
31685,99.44029726,-43.19593364,3.17
17358,55.73126161,47.78755139,3.01
29651,93.71388683,-6.27477613,3.99
13268,42.67420868,55.89549611,3.77
3031,9.63894077,29.31175144,4.34
29655,93.71940501,22.50679887,3.31
23522,75.8545419,60.44224552,4.03
62434,191.93026305,-59.68876362,1.25
17378,55.81209088,-9.76339465,3.52
78820,241.35929462,-19.80545336,2.56
113638,345.2200484,-52.754137,4.11
84970,260.50241,-24.99954543,3.27
27628,87.73997037,-35.76830865,3.12
91117,278.80177781,-8.24407292,3.85
70638,216.73014215,-83.66788445,4.31
80883,247.7284288,1.98392313,3.82
103413,314.29340932,41.16713558,3.94
97278,296.56491454,10.6132612,2.72
80894,247.78486581,-16.61273261,4.29
25606,82.06134664,-20.75944097,2.81
27654,87.83039904,-20.87908866,3.76
93194,284.73592771,32.68955742,3.25
50191,153.68398022,-42.12194167,3.85
39953,122.383126,-47.33658771,1.75
3092,9.83198236,30.86102393,3.27
9236,29.69247303,-61.5698591,2.86
56343,173.25048102,-31.85762516,3.54
89112,272.80734401,-45.9544176,4.52
115738,351.73314692,1.25560806,4.95
54301,166.63511623,-62.42411328,4.62
17440,56.0499063,-64.80690264,3.84
74785,229.25172845,-9.3829174,2.61
44066,134.62175702,11.85770096,4.26
87073,266.89617277,-40.12699753,2.99
107556,326.76018807,-16.12728595,2.85
17448,56.07971679,32.28824817,3.84
23595,76.10167557,-35.48297839,4.55
1067,3.30897012,15.1835959,2.83
101421,308.30321322,11.3032628,4.03
5165,16.5210284,-46.71841361,3.32
76852,235.38773012,19.67040059,4.51
23607,76.14228959,15.40410527,4.65
83000,254.41707231,9.37503268,3.19
93244,284.90565584,15.06829817,4.02
113726,345.48026764,42.32597924,3.62
35904,111.02376056,-29.3031036,2.45
46146,141.16357964,26.1823241,4.47
78914,241.62265863,-45.17318517,4.73
87108,266.97316882,2.70727617,3.75
74824,229.37853924,-58.80120806,4.07
97365,296.84692668,18.5342861,3.68
107608,326.93395765,-30.89830426,5.02
68702,210.95585201,-60.37303931,0.61
44127,134.80189116,48.04182647,3.12
66657,204.97191001,-53.46639378,2.29
3179,10.12683548,56.53733109,2.24
81008,248.15121699,11.48804151,4.84
15474,49.87917471,-21.75786384,3.7
58484,179.90655602,-78.22183894,4.88
115830,351.99206304,6.37899212,4.27
85112,260.92060269,37.1459463,4.15
91262,279.23473511,38.7836918,0.03
19587,62.96641752,-6.83758114,4.04
23685,76.3652677,-22.37103258,3.19
83081,254.65504861,-55.99014085,3.12
23693,76.37773246,-57.47270388,4.71
11407,36.74634294,-47.70384014,4.24
99473,302.82618951,-0.82146099,3.24
68756,211.09729071,64.37585051,3.67
15510,49.98187828,-43.06978344,4.26
76952,235.68568764,26.29563742,3.81
97433,297.0431338,70.26793017,3.84
50335,154.1725706,23.41731066,3.43
81065,248.3628478,-78.89714775,3.86
38070,117.02153444,-25.93716858,4.4
17593,56.53556491,-12.10158939,4.43
109754,333.4697084,39.71492708,4.5
54463,167.14745809,-58.9750369,3.93
48319,147.74732429,59.03873553,3.78
74946,229.72742565,-68.67954501,2.87
52419,160.73917189,-64.39445006,2.74
50371,154.27073249,-61.33230426,3.39
50372,154.27413109,42.91436491,3.45
36046,111.43165048,27.7980804,3.78
83153,254.89603227,-53.16043772,4.06
23767,76.62871992,41.23447447,3.18
44248,135.15987807,41.782911,3.96
113881,345.94357301,28.08278909,2.44
13531,43.56441901,52.7624789,3.93
11484,37.03976038,8.46005355,4.3
87261,267.46450837,-37.04330355,3.19
48356,147.8695573,-14.84660315,4.11
5348,17.09617396,-55.24576016,3.94
81126,248.52575889,42.437041,4.2
31978,100.24441938,9.89575411,4.66
27890,88.52522878,-63.08962721,4.65
17651,56.71203143,-23.24972265,4.22
5364,17.1474649,-10.18226422,3.46
93429,285.42011337,-5.73911489,4.02
34045,105.93955289,-15.63328598,4.11
68862,211.51152954,-41.17963292,4.36
79101,242.19240795,44.93490599,4.23
77055,236.01466385,77.79449293,4.29
89341,273.44087411,-21.05883369,3.84
25859,82.80314914,-35.47051883,3.86
83207,255.07239072,30.92640462,3.92
27913,88.59576026,20.27617455,4.39
21770,70.14046881,-41.86375251,4.44
54539,167.41586845,44.49848682,3.0
85258,261.32495294,-55.52988403,2.84
95501,291.3745854,3.1147753,3.36
17678,56.80975497,-74.23896234,3.26
9487,30.5117503,2.76375946,3.82
77070,236.06697851,6.42562699,2.63
85267,261.34857936,-56.37772676,3.31
38170,117.3235632,-24.85978574,3.34
68895,211.59290444,-26.6823611,3.25
109857,333.75912456,57.04358673,4.18
19747,63.50047645,-42.29436792,3.85
34088,106.02721594,20.57029706,4.01
113963,346.19022409,15.20526442,2.49
29997,94.71157129,69.31978723,4.76
60718,186.64956584,-63.09909166,0.77
36145,111.67854711,49.21152684,4.61
48437,148.12681031,-8.10503034,5.07
46390,141.89684698,-8.65860253,1.99
56633,174.17047243,-9.80224683,4.7
5434,17.37552272,47.24179245,4.26
93506,285.65297476,-29.88010539,2.6
23875,76.96243797,-5.08644618,2.78
19780,63.60618205,-62.47385803,3.33
68933,211.67061857,-36.36995445,2.06
60742,186.73446813,28.2684229,4.35
5447,17.43301493,35.6205577,2.07
111944,340.12857952,44.27630499,4.5
42313,129.41402575,5.70378169,4.14
48455,148.19090535,26.00695149,3.88
25930,83.00166968,-0.29909204,2.25
111954,340.16391659,-27.04361694,4.18
27989,88.7929386,7.40706274,0.45
75097,230.18214784,71.83401605,3.0
3419,10.8973794,-17.9866046,2.04
36188,111.78767771,8.28931548,2.89
44382,135.61164961,-66.39607654,4.0
19812,63.72442567,48.40933095,4.12
21861,70.51450254,-37.14429672,5.04
30060,94.90577841,59.01096456,4.44
97649,297.69582916,8.86832198,0.76
81266,248.97064054,-28.21601625,2.82
109937,333.99240257,37.74873668,4.14
25985,83.18256633,-17.82228853,2.58
105858,321.61085665,-65.36619828,4.21
13701,44.10687368,-8.89814446,3.89
75141,230.34300711,-40.64751791,3.22
101769,309.38725441,14.59508707,3.64
101772,309.39179996,-47.2915018,3.11
71053,217.95745802,30.37143717,3.57
60823,187.00992483,-50.23063496,3.91
50583,154.99314355,19.84148873,2.01
105881,321.66677526,-22.41133249,3.77
52633,161.44584694,-80.54018778,4.45
54682,167.91453864,-22.82584719,4.46
112029,340.3655033,10.83136442,3.41
42402,129.6893236,3.34143518,4.45
71075,218.0194663,38.30825261,3.04
7588,24.42852736,-57.23675749,0.45
9640,30.97480447,42.32972473,2.1
75177,230.45154169,-36.26137639,3.57
85423,261.8386404,-29.8670334,4.28
77233,236.54690158,15.42182561,3.65
110003,334.20848509,-7.78329031,4.17
46515,142.31133187,-35.95133548,4.51
19893,64.00660681,-51.486648,4.26
44471,135.90636137,47.15652471,3.57
7607,24.49815046,48.62821317,3.59
1473,4.5819037,36.78522405,4.51
64962,199.73040326,-23.17151233,2.99
28103,89.10122041,-14.16770015,3.71
9677,31.12266035,-29.2968189,4.68
19921,64.12095285,-59.30215628,4.44
17874,57.3635215,-36.20025014,4.17
5586,17.9151534,30.08963821,4.51
26069,83.40632371,-62.48982532,3.76
17884,57.38034127,65.52597247,4.39
54751,168.15005395,-60.31762504,4.59
81377,249.28974079,-10.56708997,2.54
62956,193.50728928,55.95982116,1.76
93683,286.1707572,-21.74149568,3.76
32246,100.98302496,25.13112417,3.06
15863,51.08070979,49.86117959,1.79
11767,37.95451535,89.26410951,1.97
52727,161.69240913,-49.42025537,2.69
112122,340.66687781,-46.8845769,2.07
118268,359.82787346,6.86332112,4.03
75264,230.67029542,-44.68962207,3.37
116231,353.24274717,-37.81826761,4.38
99848,303.86800672,47.71420822,3.96
97804,298.11819944,1.00566053,3.87
79374,242.99889379,-19.46070821,4.0
42515,130.02559777,-35.30835239,3.97
13847,44.56531119,-40.30467242,2.88
1562,4.8569773,-8.82392145,3.56
95771,292.17637441,24.66490477,4.44
15900,51.20330738,9.02886984,3.61
112158,340.75057261,30.2212452,2.93
87585,268.38220612,56.87264281,3.73
60965,187.4660642,-16.51543255,2.94
17959,57.5896213,71.33226569,4.59
28199,89.38420824,-35.28327968,4.36
89642,274.40681271,-36.76168598,3.1
106032,322.16498797,70.56071603,3.23
118322,359.97907782,-65.57713201,4.49
93747,286.35253418,13.86347817,2.99
110130,334.62539235,-60.25958759,2.87
108085,328.48218523,-37.36485231,3.0
73273,224.63302849,-43.13396008,2.68
46651,142.67500055,-40.46676938,3.6
75323,230.84435831,-59.32078728,4.48
13884,44.69915268,-64.07128407,4.98
1599,5.01775052,-64.87479041,4.23
58948,181.30224822,8.73298544,4.12
30277,95.52845101,-33.43640007,3.85
101958,309.90953078,15.91207193,3.77
20042,64.47359293,-33.79834786,3.55
40526,124.12883578,9.1855447,3.53
91726,280.5684449,-9.05254866,4.7
65109,200.14924004,-36.71229493,2.75
54872,168.52708898,20.52371682,2.56
32349,101.28715539,-16.71611582,-1.44
22109,71.37562968,-3.25465749,4.01
54879,168.56002157,15.42957019,3.33
26207,83.78448789,9.93415842,3.39
97886,298.36539742,24.07961388,4.57
20070,64.56090838,50.29550228,4.6
32362,101.32235265,12.89559111,3.35
3693,11.83468919,24.26717799,4.08
93805,286.56224338,-4.88255421,3.43
95853,292.42649598,51.72977887,3.76
5742,18.4372798,24.58371315,4.67
50801,155.58225241,41.49951638,3.06
63090,193.90086578,3.39747026,3.39
30324,95.67493869,-17.95591772,1.98
73334,224.79035436,-42.10419383,3.13
93825,286.60462682,-37.06343689,4.23
13954,44.92875737,8.90736485,4.71
48774,149.21559015,-54.56779042,3.52
30343,95.74011257,22.51358585,2.87
77450,237.18490342,18.14156366,4.09
34444,107.09785107,-26.39319967,1.83
46733,142.88211727,63.06186073,3.65
91792,280.75890049,-71.4281134,4.01
63125,194.00694736,38.3183798,2.89
9884,31.79336293,23.46242313,2.01
44700,136.63236217,38.45221539,4.56
46750,142.930117,22.96797056,4.32
61084,187.79149709,-57.11321169,1.59
114341,347.36165473,-21.1724096,3.68
85670,262.60817511,52.30138713,2.79
28328,89.78668859,-42.81513544,3.96
93864,286.7350369,-27.67042304,3.32
34481,107.18694146,-70.4989317,3.78
71352,218.87676586,-42.15782447,2.33
85693,262.68462483,26.11064528,4.41
85696,262.69098221,-37.29581099,2.7
75458,231.23239471,58.96606559,3.29
28358,89.88181908,54.28465615,3.72
26311,84.05338934,-1.20191983,1.69
28360,89.88217889,44.94743278,1.9
77512,237.39852576,26.06839434,4.59
3786,12.17060122,7.58507917,4.44
104139,316.48678349,-17.23286077,4.08
95947,292.68033578,27.95968112,3.05
7884,25.35789264,5.48761322,4.45
77516,237.40503496,-3.43020774,3.54
52943,162.40620179,-16.19364835,3.11
67275,206.81559553,17.45690604,4.5
102098,310.35797809,45.280338,1.25
30419,95.94202277,4.59286494,4.39
16083,51.79230269,9.73267975,3.73
28380,89.93028743,37.21258518,2.65
85727,262.77463763,-60.68384819,3.6
100064,304.51356413,-12.54485184,3.58
67301,206.88515682,49.31326506,1.85
30438,95.9879578,-52.69566046,-0.62
79593,243.58641439,-3.69432297,2.73
20205,64.94834891,15.62764232,3.65
24305,78.23292017,-16.20546821,3.29
98036,298.82830569,6.40676346,3.71
40702,124.63145814,-76.91972263,4.05
87808,269.06325226,37.25053918,3.86
46853,143.21430974,51.67730022,3.17
24327,78.30782374,-12.94129154,4.36
110351,335.25644466,46.53656951,4.55
91919,281.08477214,39.67012325,4.67
61199,188.11672818,-72.13298844,3.84
44816,136.99899358,-43.43258935,2.23
112405,341.51461617,-81.38161517,4.13
87833,269.15154113,51.48889499,2.24
81693,250.32150123,31.60272561,2.81
85792,262.96038867,-49.8761448,2.84
106278,322.88972517,-5.57117221,2.9
18216,58.42792843,-24.61222998,4.64
3881,12.45353036,41.07891087,4.53
42799,130.80614655,3.39866225,4.3
89908,275.18929342,71.33781433,4.22
94005,287.08737435,-40.49670284,4.57
42806,130.82144197,21.46850069,4.66
14135,45.56988401,4.08973396,2.54
112440,341.63282775,23.56565397,3.97
77622,237.70402545,4.47773018,3.71
110395,335.41406405,-1.38733152,3.86
59196,182.08958257,-50.72242559,2.58
85822,263.05416851,86.58646042,4.35
59199,182.10340415,-24.72887552,4.02
14146,45.59791746,-23.62447166,4.08
77634,237.73974002,-33.62716543,3.97
91971,281.1931559,37.60511483,4.34
85829,263.06677411,55.17295855,4.86
32578,101.96520524,2.4121591,4.48
18246,58.53300625,31.88363552,2.84
89931,275.24850731,-29.82810326,2.72
42828,130.89807304,-33.18638557,3.68
10064,32.38594522,34.98729693,3.0
89937,275.26409444,72.73284302,3.55
73555,225.48650975,40.39056569,3.49
26451,84.4111907,21.14254914,2.97
32607,102.04771795,-61.94139161,3.24
61281,188.37060139,69.78823768,3.85
65378,200.9814288,54.92536175,2.23
16228,52.26722286,59.94033011,4.21
116584,354.39101047,46.45815183,3.81
46952,143.55575799,36.39755774,4.54
89962,275.32750318,-2.89882514,3.23
69483,213.37086581,51.78996497,4.53
51056,156.47839283,33.79612024,4.72
24436,78.63446812,-8.20164055,0.18
87933,269.44119041,29.24787975,3.7
51069,156.52261134,-16.83629043,3.83
8068,25.91515608,50.68873247,4.01
34693,107.78487783,30.24516301,4.41
61317,188.43560252,41.35747975,4.24
67464,207.37615454,-41.68770924,3.41
102281,310.86472445,15.07458079,4.43
92041,281.41411035,-26.99077831,3.17
108431,329.47947795,-54.99257552,4.4
116631,354.53417222,43.26807316,4.29
42911,131.17124835,18.15430871,3.94
14240,45.90341436,-59.73777523,5.12
42913,131.17594322,-54.70882109,1.93
94114,287.36809043,-37.90447444,4.11
55203,169.54554950000002,31.5292889,3.79
8102,26.01701214,-15.93748006,3.49
85927,263.40216661,-37.10382115,1.62
81833,250.72402184,38.92225448,3.48
38827,119.19464272,-52.98235988,3.46
75695,231.95721171,29.10570271,3.66
61359,188.59681092,-23.39675917,2.65
22449,72.46004413,6.96127568,3.19
55219,169.61973665,33.09430567,3.49
59316,182.53116941,-22.61976647,3.02
83895,257.19664842,65.71468331,3.17
81852,250.76940133,-77.51743472,4.23
102333,311.00972399,-51.92097088,4.51
94141,287.44097099,-21.02361486,2.88
77760,238.16892286,42.45151803,4.6
12225,39.3515484,-52.5430859,5.3
65474,201.29824701,-11.16132203,0.98
57283,176.19073179,-18.35067436,4.71
28614,90.59582821,9.64727656,4.12
110538,335.89009791,52.22904653,4.42
79822,244.37619927,75.75533045,4.95
94160,287.50732036,-39.34079617,4.1
34769,107.96608433,-0.49276432,4.15
51172,156.78792133,-31.06777887,4.28
2021,6.43780017,-77.25424559,2.82
20455,65.73372189,17.5425142,3.77
53229,163.32793791,34.21487112,3.79
22509,72.65300729,8.90017585,4.35
112623,342.13874318,-51.31686379,3.49
88048,269.75663119,-9.77363197,3.32
55282,169.83519815,-14.7785414,3.56
36850,113.64942834,31.88827629,1.58
90098,275.80675509,-61.49390093,4.35
73714,226.0175648,-25.28196464,3.25
116727,354.83687081,77.63227593,3.21
14328,46.19912802,53.50644013,2.91
100345,305.25281519,-14.78136716,3.05
102395,311.23955989,-66.20321257,3.42
32768,102.48403461,-50.61455978,2.94
65536,201.53361196,72.3914759,5.82
65545,201.5475583,-1.19247104,5.97
65550,201.56917611,46.02805514,5.88
98325,299.65825586,30.98366542,5.51
98332,299.67204736,-69.16395702,5.74
32809,102.59070404,-17.08455489,5.77
32810,102.59728614,-31.70605741,5.74
32814,102.60624458,13.41317681,5.68
65581,201.67986526,-12.70766416,5.27
98353,299.73832815,-26.19576726,4.84
65593,201.73381813,-41.49756217,5.69
65595,201.7366828,78.6438692,5.74
98375,299.79390784,23.10128127,5.68
32844,102.69143512,41.78123001,4.99
98383,299.83510276,45.772541,5.92
32851,102.7076328,-0.54088194,5.78
32855,102.7181354,-34.36731852,4.99
88,0.26909344,-48.8098756,5.71
32864,102.73787312,67.57193419,5.14
65639,201.86318324,-15.97357823,4.76
107,0.33383021,-50.33737333,5.53
98412,299.93407757,-35.27630546,4.37
98416,299.94726369,-9.95823773,5.87
98421,299.96398797,-34.69779905,5.3
122,0.39876554,-77.06572447,4.78
98425,299.97998104,37.04288544,5.15
124,0.40423123,61.2228008,5.58
98438,300.01378502,17.51651107,5.33
32912,102.8624429,-70.96341123,5.41
145,0.45603512,-3.02750382,5.13
32921,102.88769134,21.76114781,5.28
154,0.490079,-6.01407212,4.37
98461,300.06638742,-37.70171949,5.95
98470,300.08437729,-33.70345186,5.65
32938,102.92675235,-36.23026974,5.94
171,0.54231321,27.08225603,5.8
98478,300.09625434,-66.94935994,5.75
183,0.58300278,-29.72041402,5.04
65721,202.10753905,13.77878731,4.97
65728,202.11286336,59.94578679,5.4
194,0.62375948,8.48546309,5.7
32968,102.99994465,23.60171799,5.68
207,0.65036241,66.09896618,5.87
98512,300.20136014,-45.11291835,5.8
98526,300.24574019,8.55773487,5.9
98543,300.27520144,27.75357306,4.66
65790,202.30416835,10.81830976,5.65
33024,103.20611647,8.3803734,5.75
98571,300.33984712,50.1046949,5.06
65810,202.35522543,-51.16513397,5.04
33048,103.27103853,59.4485433,5.34
98583,300.3689394,64.82097431,5.22
301,0.93495762,-17.33598771,4.55
98608,300.43643688,-59.3758934,4.95
98609,300.43629598,24.80042345,5.88
33077,103.32838668,-19.032763,5.65
98624,300.46858915,-66.94396609,5.32
33092,103.38711401,-20.22425377,4.82
98633,300.49416893,-13.63721711,5.69
330,1.05692695,62.2876637,5.9
98636,300.50596562,24.93804313,5.23
33104,103.4260352,68.88830947,5.11
343,1.08247517,-16.52903618,5.78
355,1.12549376,-10.5095233,4.99
377,1.17211746,-71.43689145,5.59
379,1.17492163,67.16644546,5.68
98688,300.66450229,-27.70984484,4.43
98702,300.70446942,67.8735649,4.51
33184,103.60277157,-1.12699558,5.44
418,1.27562467,61.31397012,5.8
33202,103.66098292,13.17782721,4.73
98738,300.8183324,18.50099282,5.99
443,1.33392048,-5.7076182,4.61
98754,300.87506577,16.03125458,5.73
98761,300.88941349,-37.9406987,4.77
98767,300.90585631,29.89680555,5.73
66006,202.99118799,-6.25581614,4.68
476,1.42483879,13.39626645,5.55
33248,103.76141033,-20.4048761,5.8
33277,103.82778182,25.37569753,5.74
98819,301.02593601,17.07017322,5.8
518,1.56589255,58.43673285,5.98
98823,301.03464661,7.27796579,5.51
522,1.57989765,-49.07519111,5.7
531,1.61058271,64.19616861,5.57
66065,203.14957695,-28.69276831,5.69
33302,103.90596197,-20.13649687,4.66
98842,301.08163573,-32.05629561,4.99
98844,301.09646574,-0.7093086,5.67
33316,103.94553278,-22.94143934,5.29
66091,203.21517405,-15.36301166,5.52
98863,301.15072827,32.21859764,5.62
66098,203.24197067,-10.16499993,5.21
33345,104.02769064,-14.04342969,5.0
33357,104.06662718,-48.72114406,4.94
33372,104.10763844,9.95657776,5.9
33377,104.13357225,46.27399831,5.85
33384,104.1436477,-79.42019304,5.45
98920,301.28955674,19.99107063,5.09
636,1.94541637,-22.50855978,5.93
33415,104.23354304,46.70535221,5.88
33421,104.25216441,33.6810387,5.91
655,2.0145307,-33.52932605,5.67
98962,301.3869957,61.99541982,5.4
66198,203.53044103,55.34843362,5.6
66200,203.53304559,3.65896665,4.92
671,2.07305222,-8.82411211,5.99
66234,203.61358066,49.01597263,4.68
33478,104.3912802,-24.63084103,5.45
66247,203.66854064,-13.2143237,5.92
33485,104.40461277,45.09409429,4.9
66257,203.69920134,37.18241487,4.91
99026,301.55769149,53.16568776,5.81
729,2.2601029,18.21196314,5.57
99031,301.59069831,35.97246811,5.38
761,2.33778595,-27.98792818,5.42
99080,301.72253149,23.61442518,5.08
66320,203.88040075,-5.3961912,5.7
33558,104.60455873,-34.1117085,5.07
33575,104.64957958,-25.41415695,5.59
813,2.50917617,11.14581307,5.54
814,2.50906524,-82.22404699,5.29
99120,301.84648453,-52.880793,4.93
33603,104.73760308,3.60235542,5.96
840,2.57862406,-5.24858764,5.84
841,2.58019098,46.07227168,5.01
66400,204.20187031,-26.49519801,5.73
99171,302.00759586,-0.67818539,5.97
873,2.67847777,-12.57989671,5.84
66417,204.2461792,24.61329748,5.72
66427,204.27504351,-44.14320351,5.96
66435,204.29578548,71.24225187,5.5
66438,204.30160477,-61.69185588,5.63
910,2.81607181,-15.46797744,4.89
33682,104.96056686,-67.91644271,5.18
66454,204.34780642,-46.42787917,5.91
66458,204.36511796,36.29489816,4.82
930,2.89341697,-27.79973666,5.41
33715,105.06593401,16.07899813,5.73
950,2.93336928,-35.13311958,5.24
99255,302.22227861,77.71141943,4.38
33729,105.09898513,-8.40682071,5.95
983,3.04160825,-17.93827767,5.29
99303,302.35674599,36.83962153,4.93
33779,105.21452067,-51.4025847,5.14
66563,204.67528292,-29.56086741,5.81
33804,105.27477623,-25.21563451,5.64
66575,204.70396386,-57.62271715,6.0
33827,105.33924341,70.80829581,5.69
1074,3.33175776,-84.99397839,5.78
1086,3.37850157,41.03536964,5.71
33856,105.42978223,-27.93483037,3.49
1096,3.42602016,-26.02234535,5.94
66634,204.87686652,52.92120839,5.46
66640,204.89423728,10.74626874,5.57
99404,302.6397368,26.90416876,5.51
33878,105.48493536,-5.72206536,5.22
66656,204.9522902,-40.05170854,5.61
66666,204.99919734,-49.94995564,5.74
66681,205.04461458,-64.57655314,5.79
33914,105.57288867,15.33600809,5.78
99461,302.79974205,-36.10121213,5.32
1158,3.61511753,-7.7805321,5.13
33927,105.60325208,24.21544555,5.2
33929,105.60639395,17.75552109,5.96
1168,3.65068528,20.20670177,4.79
33937,105.63869653,16.67444721,5.86
1170,3.66006652,-18.93286561,4.44
1191,3.72714477,-9.56957107,5.77
66727,205.16862222,19.95571946,5.73
99500,302.89548025,62.0785422,5.7
66738,205.18447166,54.68163385,4.63
33971,105.72823645,-4.23923131,4.99
33977,105.75613571,-23.83329091,3.02
99518,302.94989392,26.80899041,5.51
66753,205.23116443,-85.78604339,5.56
66763,205.25978175,22.49576769,5.63
99531,303.00292293,26.47880654,5.91
34000,105.81290836,-59.17810882,5.5
34002,105.82464762,9.13835473,5.96
34017,105.876911,29.33708092,5.93
66798,205.37455173,64.82241123,5.85
34033,105.90863308,10.95181665,5.14
66803,205.40323586,-8.70298428,5.03
99572,303.10779499,-12.61749756,5.84
66821,205.43654531,-54.55942517,4.99
1288,4.03694261,-31.4463941,5.66
34059,105.97336519,-49.58391974,4.92
34065,105.98882342,-43.6080386,5.56
34081,106.01163996,-42.33727967,5.2
66849,205.50453038,-58.78707818,5.38
34086,106.02186687,-5.32397878,5.63
99631,303.30784141,-1.00933927,5.44
99639,303.32522252,46.81567507,4.8
34105,106.07637777,-56.74972437,5.14
66878,205.59622868,82.75240765,5.92
99655,303.34943986,56.56772217,4.28
1354,4.23768117,61.53318556,5.74
99663,303.36506529,60.64056887,5.81
1366,4.27290947,38.68163564,4.61
66903,205.66334481,78.06443702,5.91
66907,205.68095975,34.98902127,5.98
1372,4.28768216,47.9474053,5.86
99675,303.40794272,46.74132872,3.8
66924,205.72926046,-41.4010433,5.96
66925,205.73379181,-56.76797125,6.0
66936,205.76546779,3.53790254,5.35
34182,106.32654057,22.63745849,6.0
99738,303.56053824,28.69481733,5.19
99742,303.56924693,15.19760859,4.94
99747,303.57928141,-52.44576973,5.65
34215,106.41260736,9.18580035,5.78
66984,205.91702227,-42.06752151,5.96
99770,303.63347045,36.80630231,4.93
1493,4.65940621,31.51722681,5.88
34267,106.54829765,34.47396758,5.55
99824,303.81623086,25.59195704,4.79
67057,206.12427878,-16.17907241,5.55
99825,303.82246194,-27.03297677,5.73
34301,106.6698614,-11.29401399,5.41
99841,303.84903774,33.72908383,5.7
99853,303.87599551,23.50890567,5.18
34339,106.77949044,-40.89326813,5.8
99874,303.94222813,27.81424252,4.5
34349,106.80537383,-51.96828341,5.96
99889,304.00256183,45.57952514,5.87
34358,106.84332696,34.00928769,5.94
34360,106.84411442,-23.84072193,5.75
67143,206.40371311,-26.11600947,5.81
67153,206.42185517,-33.04372133,4.23
34387,106.95620363,7.471214,5.74
1630,5.10167651,30.93561358,5.89
67172,206.48466354,-12.42652777,5.5
1645,5.1494233,8.19027134,5.38
1647,5.16265059,-69.6249131,5.5
99951,304.196191,24.67110166,5.3
1657,5.18965919,32.91118651,5.79
67194,206.55643908,41.08874609,5.88
99968,304.2303564,40.36507501,5.27
34440,107.09183051,15.93067481,5.47
67210,206.5794252,38.50362557,5.92
1686,5.28028766,37.96860317,5.16
67231,206.64856701,54.43267937,5.68
67234,206.66407543,-51.43276572,4.64
67239,206.68051281,25.70223621,5.97
34473,107.1765478,-70.49708749,5.68
1706,5.36992048,-77.42687264,5.96
1708,5.37999249,-28.98146883,5.18
67244,206.73479883,-36.25193268,5.15
67250,206.74906154,38.54269716,5.51
100017,304.38053244,66.85368726,5.91
100027,304.41195582,-12.50821221,4.3
34495,107.21278354,-39.6556567,4.83
1728,5.44280717,-20.05802357,5.61
100044,304.4466743,38.03293038,4.77
67288,206.85579936,-17.85983898,5.41
67292,206.86516082,-50.24929064,5.92
100062,304.50582282,-21.80996026,5.86
67304,206.91058648,-50.32068238,5.46
100069,304.529117,40.7320823,5.83
34561,107.38902026,-16.23450903,6.0
100097,304.60312616,55.39709469,5.76
100108,304.61939765,36.99980266,5.58
34579,107.42926751,-25.23103424,5.69
100122,304.66279134,34.98277505,5.14
67384,207.16139965,31.19020636,5.61
34622,107.55700787,-4.23710618,4.91
34624,107.58050194,-27.49152005,5.46
100195,304.84835064,-19.11853329,5.28
34670,107.69784763,-48.93209831,5.12
100221,304.90299439,62.25747223,5.71
1921,6.06523854,52.01991398,5.58
67457,207.36133803,-34.45077587,4.19
67459,207.36933786,15.7979049,4.05
67472,207.40412075,-42.47373178,3.47
67480,207.42847143,21.26410554,4.92
67485,207.43960426,61.48931304,5.97
34722,107.84611075,26.85658754,5.75
34724,107.84839855,-0.30192779,5.44
67494,207.46784793,-18.13416784,4.96
1960,6.19793946,61.83105752,5.38
100256,305.00079007,13.54809129,5.96
100261,305.02505368,68.88031746,5.59
100276,305.08919406,17.79292755,5.82
1982,6.27671131,53.04678574,5.72
34752,107.91385722,39.32054881,4.91
34758,107.9233544,-20.88306308,5.84
2006,6.35086824,1.93969241,5.77
67545,207.60282876,5.49722353,6.0
100310,305.1659006,-12.75907959,4.77
34798,108.05089523,-25.94258852,5.91
34802,108.06586108,-40.49880847,5.3
34817,108.10759589,-36.54438135,5.94
34819,108.10990763,24.12859368,5.85
100357,305.29802056,63.98012256,5.69
34834,108.14010612,-46.75930492,4.49
67605,207.78839876,34.66439928,5.89
2072,6.55084089,-43.67982953,3.93
67627,207.85808156,64.72327175,4.58
34888,108.2799741,-11.25134106,5.77
67663,207.94673726,-46.89866634,5.77
67664,207.94762556,-69.40125831,5.73
67665,207.94781273,34.4442404,4.76
34899,108.30562723,-45.18273921,4.87
67669,207.95666818,-32.99408951,4.32
100435,305.51429481,24.44609928,5.5
100437,305.52236511,45.79499386,5.58
34909,108.34281633,16.15896615,5.07
34912,108.34750436,51.42874516,5.46
34914,108.35010498,-22.67424092,5.99
34922,108.38466128,-44.63973886,4.42
2159,6.81128534,-25.54717034,5.99
100469,305.61460531,-42.04954821,5.6
67703,208.02025807,-52.81152998,5.26
100501,305.68873297,41.02601218,5.95
34975,108.54521171,-3.9017788,5.8
2210,6.9820767,-33.00716708,4.86
34981,108.56338394,-26.35250672,4.42
34982,108.56466594,-9.94753257,5.9
2219,7.01214583,17.89312479,5.01
34987,108.58359421,3.11141396,5.36
2225,7.05689073,44.39445199,5.18
35005,108.63591859,12.11582451,5.71
100541,305.79455687,5.34298725,5.3
2240,7.11050391,-39.91500236,5.42
67782,208.29284253,28.64813144,5.91
67786,208.30224583,-31.92761234,4.75
67787,208.30387768,17.93286824,5.71
35020,108.65892,-48.27192679,4.75
35025,108.67491609,24.88498433,5.84
35029,108.69173772,-46.84967201,5.72
35037,108.70272548,-26.77266737,4.01
100574,305.93487099,37.47644863,5.87
35044,108.71317279,-27.03799562,5.58
67819,208.38650432,-35.66424831,5.53
100587,305.96508591,32.19017195,4.43
35054,108.73813756,-41.42639431,5.95
100591,305.97157577,-42.4228682,5.64
67836,208.42956174,-53.37332288,5.87
67848,208.46255863,53.72867698,5.7
35083,108.83779758,-30.68644675,5.36
35084,108.83844662,-52.49922583,5.96
67861,208.48850068,-47.12816406,5.83
35120,108.91429203,7.97774244,5.78
2353,7.50982453,-3.95733189,5.72
2355,7.53068761,29.75155669,5.2
35127,108.93017183,-10.58360531,5.95
35136,108.95891058,47.23996383,5.54
2377,7.58305272,59.97755442,5.94
35146,108.97876339,59.63746693,5.2
2381,7.59439188,-23.78768034,5.17
2383,7.60882391,-48.2149104,5.67
35152,108.98819207,27.89741878,5.75
67929,208.67561164,-1.50312472,5.16
67942,208.70462976,-67.65209986,5.74
35180,109.0606397,-15.58568903,5.46
35181,109.06447257,-46.77453309,5.64
35202,109.13271258,-38.31892835,5.81
100738,306.3617841,-28.66326948,5.86
35205,109.14580496,-27.88117875,4.66
67973,208.80059001,-52.16082189,5.66
35210,109.153474,-23.31559423,4.83
100754,306.41887268,21.40964167,5.68
35226,109.20586731,-36.59263304,5.03
2472,7.85408632,-48.80351439,4.76
2475,7.85683233,33.58164217,5.88
68009,208.91197697,-82.66619021,5.95
2487,7.88945045,-62.96556114,4.53
2497,7.9214897,52.8395265,5.59
2505,7.94316214,54.52228873,4.74
35304,109.39049869,52.13107137,5.93
68079,209.08239879,-46.59294832,5.82
2548,8.09909149,6.95546321,5.69
100859,306.75944773,49.38336663,5.73
68092,209.11615413,1.05058146,5.9
68101,209.13726652,-54.70466479,6.0
68103,209.14242131,27.49208236,5.02
2568,8.14785798,20.29431643,5.38
35341,109.50922231,40.88339251,5.87
2578,8.18293786,-63.03149984,5.07
35347,109.51770458,-43.98678606,5.86
100881,306.83004095,-18.21172075,5.08
35363,109.57663613,-36.7339621,4.65
2599,8.24996522,62.93178271,4.17
100907,306.89274082,38.44033171,5.63
2611,8.29331086,54.89498495,5.93
35384,109.63324093,49.46475569,5.0
35393,109.63963486,-39.21028511,5.24
35406,109.65910553,-36.74273501,5.11
35412,109.66824576,-24.5587011,4.88
35415,109.67702795,-24.95437538,4.37
68191,209.41201502,-63.68669582,4.71
35427,109.71364186,-26.58585449,5.29
2661,8.42101003,-29.5582782,5.55
100965,307.0607765,81.4227086,5.38
35476,109.84321184,2.74069372,5.9
2711,8.61596951,-52.37309007,5.57
35487,109.86742483,-16.39524421,5.7
101027,307.21505826,-17.8136869,4.77
68269,209.62977484,-24.97224873,5.2
68276,209.66217838,21.69621876,5.76
35509,109.9485231,7.14294749,5.91
2762,8.81199674,-3.59284649,5.2
101067,307.33496018,36.454729,5.9
101076,307.34889835,30.36855505,4.01
101082,307.36485961,81.09127721,5.96
101084,307.36296162,56.06819023,5.89
2787,8.886806,-0.50560963,5.94
35564,110.08926679,-52.31152411,5.5
68333,209.82284474,-50.36964668,5.92
101101,307.41250268,-2.88553072,4.91
2802,8.92156654,-48.00090673,5.51
101123,307.47461485,-18.58317785,5.94
35589,110.1616963,-52.08592415,5.38
101138,307.51475272,48.95156896,4.94
35611,110.22881586,-26.96383792,6.0
35615,110.2428566,-14.36048932,5.59
2854,9.03462681,54.16845015,5.08
68390,210.00050476,-25.01040286,5.77
35626,110.26805285,-25.89164338,5.87
35643,110.32290992,45.22819985,5.74
2876,9.11393972,60.32621461,5.78
2900,9.19350416,44.48858693,5.14
2903,9.19713461,15.23172547,5.89
68455,210.21852583,-66.26891031,5.96
2920,9.24285251,53.89690937,3.69
35699,110.48691986,20.44365827,5.09
2941,9.33625274,-24.76726709,5.57
2942,9.33841421,35.39950145,5.45
35710,110.51090261,36.76058415,5.12
35712,110.51449432,0.1771207,5.99
101243,307.82840129,49.22029727,5.44
101260,307.87672152,74.95461939,5.18
35727,110.55637088,-19.01660007,4.94
68498,210.33512183,8.89490635,5.98
35749,110.60578995,-5.98282858,5.83
68523,210.43122999,-45.60342079,4.34
35785,110.71687911,55.28139167,5.8
35795,110.75290455,-31.92378114,5.4
101345,308.09873181,-9.85338362,5.66
68581,210.59492286,-27.42977295,5.47
35846,110.86879684,25.05053128,5.04
35848,110.87080145,-27.83429354,5.37
3083,9.79122542,49.35458862,5.45
35855,110.88289728,-32.20206752,5.41
3093,9.84085866,21.25047245,5.88
101427,308.32351584,-80.9648625,5.76
68670,210.860439,-56.2134338,5.93
3137,9.96645783,-44.79629257,6.0
3138,9.981549,21.4384951,5.36
35907,111.03528435,40.67238935,5.23
3170,10.10695771,-59.45460432,5.89
35941,111.13938953,27.63785656,5.77
101474,308.47577758,35.25085182,4.61
101475,308.47851612,46.69386601,5.78
101477,308.47946766,-44.51604811,5.12
101483,308.48767775,13.02725466,5.39
35951,111.16744816,-16.20147272,5.18
35957,111.18272304,-31.80890499,5.35
3193,10.17655087,-4.3518407,5.9
35984,111.23786563,51.88725855,5.8
35987,111.24241421,11.6695236,5.37
35998,111.28464776,-13.75197777,5.79
3231,10.2799355,39.45866407,5.3
3245,10.33146537,-46.08500681,4.59
36024,111.35528272,-25.21776666,5.79
36039,111.4087348,-79.09418819,5.54
36041,111.41207071,9.27609733,4.99
3277,10.44332165,-56.50131553,5.72
68815,211.33282525,-76.79675222,5.69
101589,308.82723064,14.67421328,4.64
36055,111.46333436,-5.77496087,5.98
3299,10.51425676,66.14759233,5.83
3300,10.51623134,50.51252576,4.8
101612,308.89521457,-60.58174925,4.75
3330,10.61822148,-65.46803008,5.38
36114,111.59104412,-51.01848117,5.09
3352,10.67479109,-60.26280759,5.99
36143,111.67694074,-34.14069246,5.9
36156,111.73471007,20.25755681,5.94
101692,309.18180149,-2.54995715,4.91
36168,111.74784546,-23.08602346,5.65
68940,211.67843084,-9.31351525,5.46
3405,10.83849351,-57.46305996,4.36
101716,309.26947172,26.46194731,5.59
3414,10.86695727,47.02454625,4.95
36186,111.78328997,-17.86486132,5.6
3455,11.04750551,-10.60955044,4.77
3456,11.05041376,-38.42168566,5.9
36236,111.92890727,-22.85919859,5.98
36238,111.93484743,21.44524741,5.2
101773,309.39713384,-61.52991842,4.86
3478,11.10913203,47.86398376,5.66
36251,111.96525556,-11.55686729,5.79
36258,111.99650256,-29.15589616,5.55
36265,112.0086446,6.94196793,5.22
101800,309.45466616,11.37767596,5.42
69038,211.98231678,43.85445247,5.13
3504,11.1813238,48.2843641,4.48
3505,11.18498226,-22.00613523,5.22
36284,112.0408102,8.92552991,4.33
3521,11.23772103,-42.67655849,5.94
69068,212.07209419,49.45816711,5.26
101843,309.57753033,-81.28906305,5.89
101847,309.58451101,-1.10512085,4.31
3544,11.32156044,55.22139572,5.41
101867,309.63057872,21.20117361,4.81
101868,309.63297767,24.11595846,5.06
101870,309.64579597,23.68049438,5.91
3572,11.4128236,74.98807307,5.64
36345,112.213132,-31.84840087,5.95
69112,212.21219538,77.54751428,4.8
36348,112.21450945,48.18392976,5.7
101882,309.68327632,13.31512472,5.69
3583,11.4399708,-47.55198527,5.8
36362,112.27047557,-31.45621622,5.78
36363,112.27373029,-38.81206499,5.41
101899,309.74798759,30.33426539,5.68
36366,112.27799603,31.78455041,4.16
101909,309.77069661,15.83819878,5.99
3607,11.54897393,-22.52209695,5.49
36377,112.30762638,-43.30143257,3.25
101916,309.78243422,10.08620317,5.07
101923,309.81799098,-14.95476011,5.24
36388,112.32778582,-1.90532891,5.6
36393,112.33517215,28.1182752,5.07
36396,112.34211123,-10.32666364,5.75
36399,112.35683292,-7.55116823,5.86
3632,11.63732574,15.47550446,5.36
101936,309.85371476,0.48644465,5.15
69174,212.39596571,-51.50467205,5.96
69191,212.47839773,-53.4389459,4.74
36425,112.44909518,12.0065642,4.55
36429,112.45318889,27.91614658,5.01
36431,112.4642186,-23.02428723,4.85
36439,112.48315051,49.67246274,5.35
3675,11.75607711,11.97384928,5.51
36444,112.49884713,-52.65115746,5.87
101983,310.01099015,-60.54889232,5.11
101984,310.01226894,-18.13865887,5.15
101986,310.01316638,43.45887839,5.97
69226,212.59972344,25.09167693,4.82
3697,11.84846603,6.74095641,5.98
102014,310.08261887,-33.43184305,5.47
3717,11.93008447,-18.06133903,5.7
3721,11.94188855,74.84757295,5.42
102026,310.13549209,-16.12417969,5.79
36496,112.62883147,-54.39936495,5.95
69269,212.71035755,-16.30203004,4.93
3741,12.00444392,-21.72249221,5.57
36514,112.67750874,-30.96228109,4.65
3750,12.03807254,72.67448173,5.86
3760,12.07254207,7.29992806,5.92
36528,112.71956587,68.46562083,5.63
3765,12.09573817,5.28061493,5.74
102066,310.26059195,32.3072872,5.53
36547,112.76859933,82.41146587,4.92
3781,12.14757205,-74.92343763,5.09
102092,310.34857637,-31.59828927,5.75
3801,12.20842239,50.96816767,4.9
3810,12.24461788,16.94064377,5.07
3821,12.27621323,57.81518734,3.46
3834,12.30811653,-24.13667172,5.9
69373,213.01670892,69.43254834,5.18
36616,112.95165393,17.08604591,5.45
3849,12.35673214,-13.56127432,5.59
102155,310.48542073,41.71687469,5.68
69389,213.06585136,2.40943269,4.99
102157,310.48781757,-66.76068188,5.14
102162,310.51244652,-76.18059183,5.99
36640,113.02401143,-8.88132568,5.9
36641,113.02478714,1.91448091,5.24
102177,310.55261583,50.34002969,5.41
69415,213.19176791,-27.26118635,5.07
3885,12.47152416,27.71028626,5.55
69427,213.22394074,-10.2737018,4.18
102208,310.64682456,82.53115853,5.75
3909,12.53162924,-10.64432569,5.17
69462,213.31836756,-53.66567449,5.53
3949,12.6716101,-50.98681565,5.24
102253,310.795919,66.65744729,5.59
3951,12.68171635,64.24754961,5.35
36721,113.29073522,-24.71073141,5.84
36723,113.2986082,3.29037884,5.59
69493,213.41995832,-0.84546252,5.89
36732,113.3315196,-19.41252479,5.64
36760,113.40200513,15.82666172,5.27
69536,213.52158226,12.95944396,5.53
36773,113.44984673,-14.52389229,4.82
36778,113.4626803,-36.33839158,5.42
36795,113.51325205,-22.29606692,4.44
36812,113.56621747,3.37172531,5.83
36817,113.57757258,-23.47366083,5.06
102358,311.09188031,56.48840467,5.91
69598,213.67775456,-41.83749497,5.61
69612,213.7118716,10.10061034,5.29
36848,113.64497847,-27.01227499,5.78
69618,213.73807573,-57.08612636,5.03
102388,311.21877223,25.27061656,4.92
4104,13.16926991,-24.00584405,5.47
69658,213.85035467,-18.2006898,5.53
36896,113.78666663,30.96092427,5.34
102431,311.33803389,57.57972545,4.52
4147,13.2520596,-1.14426019,4.78
4151,13.267486,61.12396986,4.8
102453,311.41564037,30.71971523,4.22
36942,113.91551111,-52.53383621,4.93
69713,214.04137239,51.36723132,4.75
102487,311.54161838,-21.51403245,5.91
102497,311.58359901,-39.19926251,5.48
4200,13.40780824,-62.87135169,5.73
36981,114.016224,-14.49277108,5.66
69763,214.16131468,-66.58789366,5.72
102531,311.66193342,16.1241336,5.15
118077,359.28530288,55.70570548,5.57
37023,114.13180985,46.18028782,5.66
37031,114.14460971,5.8621715,5.89
4267,13.64677843,19.18841742,5.8
37036,114.17097385,-19.70233818,5.69
102571,311.79480064,34.37412332,4.93
37043,114.182996,-48.83016759,5.69
37046,114.19598125,55.75505996,5.93
4283,13.72122324,83.70743556,5.59
102589,311.85224078,36.49071665,4.53
4288,13.74211318,23.62833516,5.46
4292,13.75065219,58.97269767,4.83
4293,13.75130243,-69.52708424,5.45
69829,214.36854952,15.26337973,5.84
102599,311.88940388,80.55226181,5.36
37088,114.31954636,-4.11097938,5.14
102624,311.93431657,-5.02770084,4.43
37096,114.34212614,-34.96853026,4.53
102633,311.95138864,6.00820942,5.57
102635,311.95536075,47.83186951,5.6
69879,214.49924842,35.50950532,4.8
4346,13.9266673,-7.34714891,5.88
69896,214.55790024,-81.0077604,4.89
4371,14.00620874,-11.26652632,5.35
37140,114.47437424,48.77384228,5.93
102693,312.12142535,-43.9885439,5.11
69929,214.65939931,-18.71596761,5.86
37173,114.57519133,-25.36480433,4.69
37174,114.57586685,-48.60143564,5.68
102724,312.23454559,46.11413444,4.81
4422,14.1662713,59.18105564,4.62
69965,214.75372951,-25.81542581,5.87
37204,114.63692708,35.04855034,5.58
4440,14.19572198,60.3628361,5.56
69974,214.77746494,-13.37109491,4.52
69989,214.81783458,13.00429893,5.41
37223,114.68291384,-36.49682989,5.78
69995,214.84949719,-37.00290667,5.93
69996,214.85092485,-46.05809312,3.55
102772,312.32339071,-25.78123995,5.86
102773,312.32571274,-68.77652131,5.41
70012,214.88533246,-2.2655182,5.14
102790,312.37067138,-46.22682618,4.9
70027,214.93847992,16.30694777,4.84
37265,114.79137882,34.58434599,4.89
70035,214.96459799,-61.2729718,5.22
4510,14.45896617,28.99221671,5.44
70054,215.04042629,-43.0588434,5.55
37297,114.86390879,-38.30802124,4.84
37300,114.86913551,17.67451877,5.04
70069,215.08142896,-56.38649746,4.3
102843,312.52054647,44.05930376,5.06
4552,14.55924644,33.95088455,5.99
37322,114.93255319,-38.13928702,5.73
37329,114.94947842,-38.26065203,5.76
70104,215.17742387,-45.18706031,4.78
4572,14.62942551,66.35179335,5.97
37345,114.99162799,-37.57942219,5.99
4587,14.68278241,-11.37997546,5.62
102891,312.67407316,-12.54490572,5.87
37364,115.05637081,-19.66086148,5.92
37369,115.06121849,38.34453869,5.77
37379,115.09671113,-15.26392023,4.98
102916,312.75315928,-37.91333176,5.52
37391,115.12704745,87.02009108,5.05
102945,312.85728466,-5.62663276,5.99
102949,312.86765821,28.25050536,5.66
102950,312.87520711,-51.60817895,5.06
102962,312.91044918,-62.42933515,5.67
37428,115.24382617,23.0185266,5.93
37441,115.30166428,48.13153315,5.58
4675,15.01483029,44.71324291,5.69
37450,115.31588603,-38.53353213,5.41
103004,313.03199232,27.09697957,4.56
103005,313.03622452,-5.50705928,5.55
70243,215.5821617,-34.78679232,5.57
37478,115.39648077,3.62477862,5.95
70248,215.59650011,-80.10894534,5.06
70264,215.65445633,-58.45911695,4.76
37504,115.45525487,-72.60609812,3.93
37508,115.46602913,13.48045319,5.79
103045,313.16347329,-8.98331781,4.73
37521,115.51341068,14.20850345,5.55
70300,215.75932876,-39.511819,4.41
4770,15.32614858,-38.91652735,5.59
70306,215.77406205,-27.75401742,4.78
103089,313.31147699,44.38726059,4.8
70327,215.84456528,8.44661713,4.86
103094,313.32735741,45.18167264,5.48
37590,115.70063644,-26.3513258,5.64
103127,313.4174407,-39.8098646,5.34
70363,215.95242304,-53.17623291,5.99
37606,115.73790293,-45.17311793,5.04
37609,115.75173389,58.71036041,4.93
103145,313.47455043,33.43789124,5.47
70384,216.00365247,8.2439695,5.94
4852,15.61013832,-31.55200512,5.5
37623,115.79992875,-36.05008956,5.6
37629,115.82802711,28.88350961,4.23
70400,216.04726938,5.82013058,5.1
37648,115.88494423,-28.41088473,4.63
4889,15.70457184,31.8042629,5.5
4890,15.70495781,-46.39731137,5.39
37664,115.92470415,-40.93374579,5.12
103200,313.64015535,28.0576214,5.03
4903,15.7260945,41.34515741,5.95
4914,15.76056716,-4.8366006,5.4
103219,313.68479032,75.92556985,5.99
103226,313.69923442,-17.92289424,5.78
37701,116.01741347,50.43379363,5.31
37704,116.02881145,25.78415901,5.3
70469,216.20260954,-24.80631048,5.34
37710,116.04035862,-36.06250465,5.8
70492,216.27636089,-68.19533309,5.56
4962,15.90419046,61.07482263,5.92
37751,116.1423747,-24.67407915,5.62
37752,116.14242856,-37.94291724,5.89
103294,313.90287497,13.72153588,5.19
103298,313.91071599,12.56855815,5.54
4998,16.00995611,52.50216085,5.99
103312,313.9575147,47.41765633,5.68
5021,16.08104573,61.58018388,5.83
70574,216.5342661,-45.22142404,4.56
70576,216.54505337,-45.37927638,4.33
37819,116.31373311,-37.96858397,3.62
103359,314.10615482,50.72859808,5.83
103360,314.10790746,49.19584717,5.92
70602,216.61401836,19.2268998,5.4
103371,314.14490781,44.92472189,5.96
5081,16.27231523,14.94613348,5.64
37853,116.39592593,-34.17236334,5.36
103389,314.19721695,-26.29637764,5.7
103401,314.22511578,-9.69754471,5.49
70657,216.77952868,-65.82164651,5.87
37891,116.48695838,-14.563805,5.03
70663,216.80071281,-46.13425412,5.83
5131,16.42064722,21.47318139,5.33
5132,16.42379923,21.46544248,5.55
37901,116.50912585,-6.77251079,5.49
37908,116.53103014,18.51004352,4.89
37915,116.54393456,-37.93367001,5.87
37921,116.56750314,10.76825185,5.25
70692,216.88142952,75.6959929,4.25
103460,314.41935307,-16.03153935,5.89
5164,16.52145155,-9.83935413,5.58
37946,116.66367286,37.51739413,5.15
37949,116.66699442,65.45567562,5.93
103511,314.56812984,22.32590762,5.3
103519,314.58110293,44.47171065,5.55
70753,217.04344444,-29.49163763,4.97
70755,217.05057524,-2.22795719,4.81
103527,314.60806038,10.83928601,5.51
37995,116.80230684,-22.51951023,5.9
103530,314.62514404,50.46179144,5.59
103545,314.67433358,-14.48312774,5.95
38010,116.85413488,-38.51114459,5.07
38016,116.87634813,33.41569706,5.14
38020,116.8812784,-46.60849005,5.22
70791,217.15755227,49.84485149,5.58
70794,217.17384357,-6.90053627,5.42
5268,16.82776521,-61.77528929,5.36
103569,314.76865248,4.29348146,5.3
103571,314.77129385,4.29461035,5.24
38048,116.98633186,-12.19270466,5.48
103598,314.8557657,59.43859409,5.54
5296,16.94253562,-9.78555038,5.71
5300,16.94938882,-41.48691608,5.21
5310,16.98818032,20.73911258,5.56
5317,17.00353724,43.94209203,5.04
38089,117.08400369,-47.0777225,4.69
103632,314.95648555,47.52095107,4.74
5336,17.06830755,54.92033969,5.17
5346,17.09249309,5.64981907,5.51
103652,315.01659249,7.51619683,5.98
70894,217.46049471,0.828929,5.96
5361,17.13944472,58.26344926,5.77
103673,315.08950699,-51.26531189,5.76
103675,315.11536399,19.32958082,5.69
5372,17.18698865,86.25709041,4.24
38146,117.25697616,-24.91220761,5.32
70915,217.5359535,-45.32135551,5.51
38152,117.27798069,-56.41036006,5.57
38159,117.30359825,-46.85771739,5.82
38160,117.30375845,-60.28368849,5.78
70931,217.5872798,-49.51901808,5.38
38164,117.30956295,-46.37320532,4.1
38167,117.31103744,-35.24328638,5.94
103732,315.29553186,46.15577322,5.38
38200,117.39751,-33.2889499,5.61
103738,315.32275094,-32.25776727,4.67
38210,117.42080568,-66.19597444,5.78
38211,117.42167188,-17.22840779,5.17
70987,217.79516728,-38.86970844,5.99
5454,17.45500808,19.6584081,5.57
71002,217.81850707,-67.71719693,5.84
38253,117.54406886,-9.18344136,5.6
5493,17.57808507,42.08147491,5.67
5494,17.58104718,25.45776341,5.81
38267,117.5992648,-50.509468,5.89
103810,315.53752825,56.66961414,5.83
5510,17.63980105,2.44566968,5.97
5518,17.66384307,68.7786208,5.32
103836,315.61319928,-38.53097047,5.93
5542,17.77567508,55.14990064,4.34
5544,17.77819712,31.42473633,5.15
5550,17.79282306,37.72412122,5.8
71094,218.0842754,26.67728448,6.0
5566,17.85654762,64.20267697,5.56
5571,17.8634175,21.03465004,4.66
71111,218.12889827,55.39800985,5.74
103882,315.74147434,-38.63144716,5.32
71115,218.13559265,22.26005887,5.91
71121,218.15440166,-50.45715741,4.44
5589,17.92250739,65.01885377,5.57
5594,17.93128664,-2.25107885,5.93
38373,117.92495269,1.76686846,5.12
38375,117.92927178,-21.17366159,5.62
38382,117.94292754,-13.8980287,5.16
5626,18.07008876,79.67396298,5.6
38414,118.05431177,-40.57578601,3.71
71182,218.37486466,-52.67952225,5.86
71184,218.38489899,-54.9986277,5.86
103956,315.94844149,53.28590052,5.93
38423,118.06526024,-34.70544242,5.01
38427,118.07866114,-14.84617507,5.69
5661,18.18930355,-37.85647867,5.95
38438,118.12392112,-54.36716485,5.7
103981,316.01968615,-5.82306612,5.53
38455,118.1610258,-38.86281229,4.49
38474,118.19941063,-5.42825693,5.76
104019,316.10125178,-19.85499065,4.82
104031,316.14438334,5.50286154,5.63
38497,118.26461031,-36.36376945,5.44
38500,118.26514489,-49.61304388,4.63
5737,18.4328572,7.57535376,5.21
104043,316.17943562,-77.02376718,5.13
71280,218.66508564,49.36835423,5.74
71284,218.67007099,29.74512993,4.47
38518,118.32566079,-48.10293392,4.22
104060,316.23276153,43.92785207,3.72
38538,118.37422613,26.76578282,4.97
5778,18.53179007,16.13347858,5.97
104085,316.30937462,-54.72704162,5.17
104101,316.36133347,5.95819919,5.94
5799,18.60016589,-7.92282573,5.14
104105,316.37193614,78.126392,5.91
71353,218.88117124,-41.51743653,5.88
38593,118.54586884,-35.87728728,5.48
5833,18.70488336,-0.97379475,5.7
104148,316.50477267,-30.12512049,5.69
5862,18.79633762,-45.53166422,4.97
104171,316.59710199,71.43179711,5.88
38639,118.67790326,47.56459585,5.47
104174,316.60282392,-32.34161766,5.2
104177,316.606334,-41.38596515,5.55
104185,316.6260184,31.1846568,5.77
71419,219.07929375,-46.24545129,5.55
38656,118.72215755,-57.30280648,5.62
104194,316.65039071,47.64840356,4.56
5896,18.94233654,-68.87592733,4.25
104214,316.72476209,38.74941468,5.2
71453,219.18388861,-40.21157998,5.74
5926,19.04957827,71.74384251,5.87
104234,316.78194974,-25.00585337,4.49
38712,118.88097322,8.86283954,5.86
5951,19.15119996,-2.50036823,5.42
38722,118.91622954,19.88396986,5.38
71500,219.33397089,-46.13343907,5.39
71536,219.47177584,-49.42582826,4.05
38783,119.07770439,-60.52643594,5.74
71568,219.55245384,43.64213015,5.74
71571,219.55828052,18.29837944,5.9
71573,219.56342725,54.02333948,5.83
6061,19.44981588,3.61446601,5.13
104364,317.13623583,-63.92826018,5.75
104365,317.14010247,-21.19366933,5.3
38835,119.21474805,-22.88011864,4.2
104371,317.16204126,30.20563746,5.6
38846,119.24083628,-43.50041105,5.36
104382,317.19519016,-88.956499,5.45
38848,119.24771568,15.79028125,5.8
71618,219.70927445,44.40450023,5.39
38872,119.32675508,-44.10985887,5.08
38901,119.41710953,-30.33456968,4.76
38908,119.44547902,-60.30307176,5.59
104440,317.34352743,-73.17296806,5.67
71681,219.89617026,-60.83715604,1.35
38917,119.46549638,-45.5776686,5.14
104459,317.39853222,-11.37169305,4.5
38957,119.56015518,-49.24491185,4.47
38962,119.58605326,2.22476675,5.3
104516,317.56489488,53.56310053,5.75
71759,220.17663604,13.53432528,5.93
6226,19.9512302,-0.50902871,5.87
38994,119.71063123,-60.8244623,5.77
71762,220.18152847,16.41832429,4.49
6242,20.02048422,58.23161078,4.95
39014,119.75750813,-45.2158438,5.98
71783,220.25579461,-36.1348583,5.67
39023,119.77381256,-23.31039596,5.09
39061,119.86819223,-39.2969439,5.22
71832,220.41146043,8.16176401,4.86
39070,119.90642544,-60.58706118,5.19
71837,220.43133548,11.66066243,5.55
39079,119.93396866,-3.67958282,4.93
6315,20.28072053,28.73820708,5.23
39095,119.96687782,-18.39922766,4.61
71865,220.48996231,-37.79349851,4.01
104642,317.95098786,59.98661053,5.64
39117,120.04891002,73.9179192,5.37
39138,120.08319486,-63.56745578,4.81
104680,318.05713338,-40.26936174,5.83
39177,120.19711413,17.30870304,5.6
6411,20.58508262,45.52877782,4.87
39184,120.2080738,-54.15127518,5.87
39191,120.23280716,25.39283596,5.87
104738,318.26278733,-39.42492195,5.25
71974,220.80646511,-24.99775316,5.7
39211,120.30556194,-1.39260825,4.69
39213,120.30787729,4.87982358,5.65
104750,318.32221811,-27.61933263,5.41
104752,318.32900845,-36.42352722,5.97
104755,318.33545629,-70.12626669,5.06
39221,120.33656741,59.04739769,5.78
71995,220.85568013,26.52785023,4.8
39236,120.37620154,16.45530865,5.99
72010,220.91433341,-35.17365526,4.06
72012,220.93514285,40.45925391,5.72
39251,120.40635909,-37.28371993,5.9
6492,20.85395412,20.4689673,5.97
6502,20.87898961,-30.94561738,5.84
6514,20.91923378,37.7149426,5.6
39311,120.56640381,2.33457069,4.39
6564,21.08542977,-6.91465609,5.92
72104,221.24667614,-35.19182562,4.92
104887,318.69788169,38.045317,3.74
6592,21.16994358,-41.49254863,5.42
39360,120.68660072,-41.30982837,5.52
72125,221.31025043,16.96427976,4.6
72131,221.32223583,-62.87564802,5.36
39380,120.76733686,-32.46354761,5.83
72154,221.37585537,0.71727078,5.68
6631,21.2721113,-64.36947786,5.92
39424,120.87950143,27.79433226,4.94
104963,318.90791711,-20.65169596,5.17
72197,221.50033306,-25.44318067,5.15
104968,318.92688017,77.01229623,5.92
6670,21.40514554,-14.5987963,4.9
104974,318.93684412,-15.17150021,5.31
72208,221.52477447,15.13178786,5.78
72210,221.5282033,-23.15301769,5.8
104978,318.94112702,-53.2630843,5.73
6692,21.48342387,68.13001258,4.72
6706,21.56359189,19.17234565,5.35
6711,21.57785833,43.45773913,5.98
72250,221.62080664,-47.44111582,5.74
39487,121.06745731,-32.67482866,5.25
6732,21.67365999,19.24042201,5.5
6748,21.7148546,-13.05651201,5.51
72290,221.75538948,-52.38351785,5.22
39527,121.17666505,-50.59039585,5.96
72296,221.77124083,-38.29063861,5.9
39538,121.1961238,79.47961204,5.39
105080,319.30936259,55.79800103,6.0
72323,221.8439788,-25.62426687,5.61
39566,121.26545448,-53.10792109,5.52
39567,121.26870295,13.11821531,5.14
105102,319.35397027,39.39468139,4.22
6813,21.91409059,45.40668716,4.83
72357,221.93668811,-26.08750032,5.23
105138,319.47948499,34.89689785,4.41
105140,319.48451988,-32.17253927,4.71
105143,319.48869215,-17.985138,5.4
72378,221.98982299,-26.64615475,5.76
105164,319.5461371,-4.51947831,5.83
105186,319.61327221,43.94594485,5.04
39659,121.57664512,22.63548968,5.96
72432,222.15853236,-36.63469697,5.89
72438,222.18562584,-66.5935632,5.91
105224,319.71677406,11.20337297,5.97
39690,121.66808126,-45.26601555,5.04
72487,222.3277886,46.11620543,5.76
72488,222.32810468,-24.25147056,5.68
72489,222.32938051,-14.14902182,5.32
105259,319.81536654,58.62350197,5.51
6960,22.40056313,-21.62933894,5.11
39734,121.82516536,-20.55434188,5.33
105269,319.84241762,38.23747347,5.89
105268,319.84258352,64.87185522,5.19
105282,319.86979387,49.51029401,5.75
72524,222.42205614,48.72080378,5.68
6999,22.52542734,47.00727374,5.27
7007,22.5463128,6.14382046,4.84
39780,121.94106543,21.58181596,5.3
7016,22.5954381,-26.20785122,5.92
72552,222.49332864,28.61583166,5.8
72567,222.56587988,23.91184418,5.86
72573,222.58509448,82.51194418,5.63
72582,222.62352767,37.27204659,5.47
72603,222.67158849,-15.9972368,5.15
7078,22.8073171,70.26460388,5.82
39847,122.11436326,51.50667052,4.78
105382,320.19017616,-40.8094656,4.8
72631,222.75446368,-2.29915046,4.93
105411,320.2683096,23.85596652,5.58
105412,320.26799285,-4.56012531,5.87
105413,320.27010339,7.35450264,5.81
7118,22.9302024,-30.2830814,5.79
72659,222.84741061,19.10046004,4.54
72664,222.86015253,59.29398542,5.48
39903,122.25279182,-61.30242935,4.74
39906,122.25682203,-19.24501421,4.4
72683,222.90959733,-43.57535897,4.32
39919,122.28960579,-48.68441261,5.66
39943,122.36889399,-16.24892183,5.66
39957,122.39013911,-56.08538457,5.66
39961,122.39963877,-44.12277302,5.2
105497,320.50174318,49.3888481,5.68
105502,320.52166486,19.80450799,4.08
39970,122.42980871,-47.93719317,5.23
105515,320.5616509,-16.83454243,4.28
7213,23.23355086,-36.86523102,5.49
39995,122.51574231,58.24824233,5.91
72773,223.14690411,-63.8098274,5.91
7251,23.35713347,58.3273339,5.69
40023,122.61325647,25.50733395,5.73
72800,223.21280686,-37.80316007,5.02
105570,320.72338629,6.81114048,5.16
40035,122.66594192,-13.79920726,5.53
105574,320.73439675,-9.31932984,5.99
105576,320.75206151,-22.66904797,5.63
7276,23.4284875,-7.02534086,5.75
7294,23.48282037,59.23204031,4.68
72833,223.30655741,-73.19007118,5.59
40077,122.79495615,-48.46199388,5.83
72848,223.34902659,19.15279846,6.0
40084,122.81794051,-12.92699871,4.72
7321,23.56919364,37.23714649,5.9
40091,122.83955625,-39.61854551,4.44
40096,122.85788573,-42.9872777,4.73
40107,122.88751854,-7.77253904,5.36
7345,23.65741154,-15.67635919,5.62
105652,320.99511423,24.27413557,5.7
7359,23.70444113,18.46051216,5.9
105665,321.03997238,-20.85186872,5.38
105668,321.04788909,-12.87810842,5.48
40155,122.99986735,-46.64435139,5.77
72929,223.58387153,-24.64220203,5.27
105696,321.10341334,-41.00669545,5.76
72934,223.59530331,-11.89834766,5.78
40167,123.05302569,17.64777069,4.67
105703,321.14168922,26.17456032,5.67
40183,123.12830002,-46.26428551,6.0
72959,223.65797775,-33.30057489,5.85
105727,321.20646634,80.52482631,5.97
7447,23.97815181,17.43384108,5.95
40215,123.20327881,68.47407195,5.34
7450,23.99570321,-15.40018295,5.41
105761,321.30427981,-9.74855197,5.71
7463,24.03545682,-29.90731698,5.69
105767,321.32065703,-3.55674744,5.48
105769,321.33145317,46.71434148,5.59
40240,123.2869481,29.65653642,5.62
40259,123.33320023,-15.78822144,4.99
73036,223.89400205,-60.11416416,5.18
40274,123.37298829,-35.89951777,4.78
105811,321.44593834,36.66738607,5.93
7513,24.19934491,41.40545884,4.1
40282,123.39269307,-50.19607174,5.52
40285,123.4006436,-46.99162807,5.14
73049,223.93628386,-33.85578497,5.32
7535,24.27465281,12.14153479,5.54
40305,123.45906607,56.45224635,5.88
105854,321.59530626,-37.82942941,5.64
73087,224.05512632,14.44626567,5.9
40321,123.49296585,-36.32228059,5.09
40326,123.51217267,-40.34789019,4.42
73095,224.07188193,-52.80954787,5.38
73100,224.09600051,49.62844897,5.63
7568,24.36667431,-84.76959317,5.66
73111,224.13355699,-47.8791978,5.62
40344,123.55523436,-35.4900189,5.77
40357,123.5994622,-45.83452239,5.86
73129,224.18327713,-62.78101625,5.08
105898,321.71508879,48.83516845,5.29
73133,224.19213254,-11.40970065,5.48
7601,24.48151406,-82.97499539,5.88
105913,321.75676123,-42.54793048,5.5
7617,24.5315291,57.97763141,5.55
105928,321.8117469,-21.19621026,5.78
73165,224.29583149,-4.34646201,4.47
73166,224.29865735,16.38812776,5.72
105942,321.83902525,37.11679843,5.3
7643,24.61451877,-36.5282507,5.94
73184,224.36666506,-21.41547505,5.72
7650,24.62882287,73.04003987,5.28
73193,224.38854677,-0.16761171,5.51
40429,123.81633142,-62.91564338,5.16
105966,321.91690615,27.60859324,5.39
73199,224.39586336,65.9324602,4.63
105972,321.94225926,66.80909577,5.42
7679,24.71578706,-21.27538422,5.58
73223,224.47076658,-76.66265545,5.37
106003,322.03438025,32.22532973,5.75
7719,24.83750969,44.38616461,5.01
106039,322.18083418,-21.80717988,4.5
7740,24.9200752,16.40585785,5.98
106044,322.18718518,-69.505386,5.47
73284,224.66356114,-27.65731391,5.65
7751,24.94809594,-56.19640017,5.76
106062,322.24907528,22.17943574,5.84
73310,224.72325257,-11.14401377,5.88
106093,322.36229106,46.54058469,5.22
73350,224.84631414,4.56776122,5.91
7818,25.14507074,40.57704912,4.96
7825,25.16520588,43.29768692,5.63
73369,224.90394679,39.26533338,5.64
106140,322.4870633,23.63883778,4.52
40646,124.46005991,59.57113296,5.63
73415,225.04709586,-77.16055017,5.92
7906,25.41348626,30.04711962,5.97
40678,124.572482,-35.45170272,5.59
40680,124.5783617,-65.61319176,5.06
7916,25.43680768,-11.32466884,5.75
7918,25.44642903,42.613369,4.96
7921,25.44986456,-60.78933951,5.7
106227,322.74704869,60.4594321,5.53
40693,124.59978029,-12.63217344,5.95
73473,225.24311921,-8.51894314,4.91
40706,124.63880117,-36.6592883,4.44
7941,25.51247427,-36.8323048,5.7
7943,25.51454276,35.24570709,5.63
7955,25.53580826,-32.32697025,5.25
73493,225.30456864,-38.05839819,5.88
73497,225.33261122,-2.75492652,5.52
7965,25.58553014,68.04302111,5.57
73507,225.3628918,60.20445323,5.91
7978,25.62214875,-53.74083406,5.52
7981,25.62400804,20.26850445,5.24
7999,25.68129205,-3.69020048,4.98
73536,225.45382982,-0.1402952,5.71
40772,124.82149084,62.50715956,5.73
73540,225.46165236,-83.22764618,5.65
8016,25.73276503,70.6225257,5.18
106327,323.02448364,-41.17931042,5.29
40793,124.8845371,75.75690762,5.55
73566,225.52681118,-28.06061106,5.83
73568,225.52711814,25.00813833,4.8
106340,323.0607125,-33.94462275,5.97
8046,25.83230667,60.55133256,5.78
40817,124.95401564,-71.51490629,5.33
40834,125.00219375,-71.50537718,5.63
40843,125.0160844,27.21770686,5.13
73620,225.72515557,2.09130274,4.39
73624,225.74698265,-32.64329383,5.45
106393,323.23580021,49.97762947,5.77
40866,125.08738735,20.74772105,5.8
73634,225.77522944,35.20579548,5.52
40875,125.10858159,57.74327849,5.89
40881,125.13390049,24.02231363,5.92
40888,125.16058517,-77.48447728,4.34
40889,125.16800213,72.40723255,6.0
106429,323.34798914,-44.84870017,5.57
73695,225.94710009,47.65406011,4.83
40932,125.3004108,-57.97322018,5.96
40943,125.33768135,-36.48417668,5.18
40944,125.33842834,-20.07905817,5.58
40945,125.34594365,-33.05436621,4.83
106481,323.49521858,45.59183746,3.98
8209,26.41148804,-25.05260995,5.29
73745,226.11142384,26.94764882,4.52
40990,125.47752462,-17.58633432,5.71
8230,26.49691854,-5.73329912,5.37
41003,125.51857667,-73.39998555,5.28
73771,226.19550613,-83.03831141,5.65
8240,26.52485968,-50.81625558,5.49
8241,26.52609562,-53.52203715,5.04
73776,226.20077677,-64.03135005,5.16
106551,323.69401881,38.53405361,4.87
106559,323.71271277,-20.08427387,5.7
41039,125.63205471,-48.49038087,4.79
73807,226.27952355,-47.05124517,3.91
106592,323.82341967,-3.98330458,5.79
73826,226.32985804,-41.06723583,5.13
73841,226.35764399,48.15097252,5.59
41074,125.70806802,-26.34821968,5.88
41080,125.72539764,-7.54312053,5.92
41081,125.72982583,-52.12372967,5.89
106642,324.01039856,45.37459133,5.96
41117,125.84099426,18.33219975,5.94
106654,324.04572526,-26.17151618,5.73
8362,26.93681135,63.85250114,5.63
73909,226.56965189,54.55631811,5.24
41152,125.95209287,53.21971228,5.52
8387,27.04556987,16.95555079,5.86
73937,226.63832178,-30.91848265,5.97
8404,27.10841032,3.68544661,5.91
106711,324.23739955,40.41352083,5.04
73945,226.65665094,-16.25681782,5.19
8423,27.16218592,37.95287011,5.94
41191,126.08258678,-80.91420166,5.67
8433,27.17317997,32.69020977,5.78
41211,126.14589441,-3.75124022,5.61
73996,226.82527458,24.86919552,4.93
74006,226.8581374,-49.0886123,5.77
41242,126.22991517,-23.15374489,5.67
41250,126.23835815,-42.76983374,5.97
106786,324.43795564,-7.85420152,4.68
106787,324.4392911,19.31860745,5.46
41260,126.26558029,-24.04621247,5.32
8497,27.39626131,-10.68641035,4.66
106801,324.48010181,62.08193977,4.76
41296,126.38052253,-51.72741517,5.18
74066,227.050519,-40.58392988,5.75
41299,126.39807408,2.10220949,5.74
41307,126.41513455,-3.90642364,3.91
8544,27.53571352,22.27533825,5.83
41321,126.46498515,-64.60061762,5.95
74087,227.09908784,26.30115255,5.67
41323,126.46629214,-42.1530716,5.45
41325,126.4781974,7.56450563,5.13
106856,324.63308249,5.77174242,5.66
41328,126.48162496,-14.92966139,5.96
74096,227.14818205,25.10863507,5.82
74100,227.16332188,-42.86792148,5.85
74117,227.2108967,-45.27985752,4.07
106886,324.74007661,57.48903743,5.74
8588,27.71655322,11.04337823,5.92
8593,27.72681248,-50.20613758,5.94
106897,324.75495361,20.2654508,5.77
8598,27.73803109,51.93341736,5.96
41375,126.61336895,-3.98747904,5.6
41377,126.61543832,27.89358314,5.58
41395,126.67479968,-12.53460232,5.52
41400,126.68308118,12.65461215,5.56
106944,324.88860753,2.2435584,5.1
74184,227.37463952,-67.08413313,5.76
41451,126.819816,-70.09348198,5.51
74224,227.53052031,-38.79251125,5.98
106999,325.04628944,43.27383952,5.09
74239,227.57762902,-26.33262119,5.75
8704,27.99716741,55.14738474,5.53
8714,28.03904598,50.79279388,5.7
41483,126.90243786,-53.08847968,5.08
41515,126.99758622,-35.11376141,5.75
74296,227.78672678,-84.78781204,5.88
74305,227.81658484,-55.3460324,5.45
8778,28.21713684,-16.92924975,5.78
107095,325.38691422,-14.04761057,5.16
41578,127.15558089,14.21082237,5.94
8814,28.32226886,40.7297896,5.42
107119,325.48039004,71.31141661,4.55
107128,325.50290314,-23.26285769,5.24
107129,325.50451659,35.51020044,5.98
8833,28.38896,3.18753653,4.61
8837,28.41142371,-46.30266861,4.39
107136,325.52360237,51.18962197,4.69
74376,227.98364862,-48.73781871,3.88
107144,325.54213274,1.28525324,5.66
74380,227.99032525,-48.74368674,5.7
41616,127.26979746,-47.92892315,5.33
74386,228.01776005,18.97603118,5.9
107151,325.56438144,5.68013739,5.3
41621,127.28152846,-44.16041332,5.82
74392,228.05537543,-19.79171054,4.54
107162,325.59566145,41.07701915,5.73
41639,127.36451331,-44.72481215,5.03
8882,28.59180481,-42.49694992,5.12
107188,325.6646132,-18.86632305,4.72
41674,127.44013656,-46.3316928,5.98
41676,127.44248134,67.2974407,5.89
74449,228.20661659,-44.50041361,4.83
107230,325.7668441,72.32008392,5.18
8928,28.73388091,-67.6473033,4.68
107232,325.76832505,-14.39970939,5.88
107235,325.77696032,41.15497004,5.51
107253,325.85688615,38.28358862,5.69
41723,127.6192126,-32.15928517,5.61
8993,28.96266553,23.57732159,5.76
107302,326.00402165,-14.74937044,5.96
9001,28.97700236,37.27778569,5.89
74539,228.47213597,-26.19356953,5.84
107310,326.0357404,28.74263231,4.49
9009,29.00010816,68.6852418,4.97
9021,29.03901622,37.25182962,5.69
74561,228.52518177,31.78784478,5.98
107348,326.12789728,17.35001739,4.34
41816,127.87716155,24.08110505,5.71
41817,127.87884757,-19.57746178,5.42
74582,228.57989727,-70.07947569,5.75
107350,326.13054104,14.77193916,5.96
41822,127.89887525,18.09442038,5.33
9061,29.16749154,-22.52678491,4.92
74596,228.62149336,29.16429476,5.28
74604,228.65549679,-31.51912119,4.91
74605,228.65974563,67.34672247,5.15
107374,326.22199841,62.46056748,5.94
107382,326.25106066,-9.08242844,5.1
41861,128.02065464,-53.21191961,5.68
9095,29.29200196,-47.38527732,4.82
9110,29.33772674,17.81753177,5.09
74649,228.79730419,4.93936176,5.32
107418,326.36218984,61.12080591,4.25
9132,29.43226733,27.80438081,5.84
41909,128.17707063,20.44116182,5.33
9153,29.48215492,23.59606098,4.79
74689,228.95448869,0.37213871,5.62
74696,228.97360792,-48.07366118,5.96
41935,128.22907637,38.01636794,5.88
107472,326.51818465,22.94887978,5.29
74707,229.01676479,-41.49115502,5.15
107487,326.56778755,-9.27593512,6.0
74732,229.09588045,-22.39941638,5.52
74750,229.15288591,-60.90399654,5.74
107517,326.63374272,-11.36595449,5.57
9222,29.63960506,49.20435221,5.7
107533,326.6983714,49.30957028,4.23
42001,128.41012949,-38.84881464,5.92
42008,128.43115972,4.75700024,5.89
74778,229.23706622,-60.95725471,5.04
74793,229.2745357,71.82390121,5.02
42028,128.5067403,-2.15155456,5.8
107575,326.80817524,2.68612404,5.63
107586,326.85539952,60.69268916,5.53
74837,229.41204414,-63.61046557,4.85
9307,29.89868,21.05856973,5.89
9312,29.90849238,64.62160195,5.29
9313,29.91172738,-42.03053188,5.57
42080,128.65050837,65.14517019,5.47
42088,128.68165569,-49.94420335,5.01
74857,229.45766251,-30.14867319,4.35
42090,128.68285073,36.41961892,5.76
9326,29.94249789,-20.82453855,5.43
107649,327.06563094,-47.30361491,5.57
9347,30.00128317,-21.07783155,3.99
9353,30.03816572,3.09701499,5.89
42129,128.81481834,-58.22473488,5.27
74896,229.60210309,20.57277776,5.68
42134,128.83211448,-58.00922835,4.84
74901,229.60885898,-0.46123414,5.88
9372,30.11176258,-8.52387312,5.43
74911,229.63342085,-47.87527178,4.27
42146,128.86749313,-7.9822916,5.72
42147,128.86958929,-26.84348737,5.95
42172,128.96239426,6.62021974,5.91
74941,229.70476285,-60.4963344,5.43
42177,128.96677978,-50.96965154,5.79
74950,229.73489436,-40.78822169,5.59
9440,30.31134638,-30.00183025,5.34
74975,229.82832387,1.76540768,5.04
9459,30.42656778,-44.71350896,5.15
107763,327.46122788,30.17421499,5.07
107773,327.5005228,-64.71253671,5.62
9480,30.48938612,70.90702007,4.49
107788,327.53624892,17.28585144,5.34
42265,129.27404262,9.65558,5.92
9505,30.57545056,54.4875412,4.99
75043,230.0214646,51.95851498,5.65
75049,230.03565952,29.61620896,5.51
42286,129.32846902,-62.85346542,5.45
107835,327.69660058,-69.62941608,5.52
9533,30.6461575,13.47671595,5.97
107843,327.72734258,-82.7189042,5.27
42312,129.41097124,-42.98908069,4.11
9564,30.71865218,64.90146584,6.0
42334,129.46730485,-26.25499981,5.24
9570,30.74148211,33.2841351,5.5
9572,30.7440378,-15.30593206,5.87
9573,30.75078031,64.39001815,5.59
75119,230.25831675,0.71533669,5.35
107887,327.89270108,19.82668178,5.78
9589,30.79854146,0.12850681,5.42
75127,230.28170919,-5.82485335,5.54
42365,129.5790876,32.80202066,5.96
9598,30.85877233,72.42129433,3.95
42372,129.59243647,53.40153957,5.66
9621,30.91393309,25.93547132,5.64
9622,30.91870122,-4.10351629,5.61
107930,328.00434221,55.79674323,5.7
9631,30.95071386,-0.34025084,5.96
75178,230.45239658,32.93369467,5.38
75181,230.45062501,-48.31762762,5.65
42425,129.77150681,-70.38674483,5.19
42430,129.78291789,-22.66187505,5.05
42438,129.79876654,65.02090663,5.63
75206,230.53446223,-47.92779187,4.99
107975,328.1246544,28.7935384,5.52
42452,129.8234291,52.71162301,5.91
42459,129.84934731,-53.43976748,5.45
42483,129.92697375,-29.56108368,4.86
108022,328.26570223,25.92513961,5.09
75256,230.65524028,62.04707594,5.99
75257,230.65571566,39.58146272,5.56
75260,230.66006358,63.34143917,5.72
9727,31.28092264,77.28134094,5.27
108036,328.32404854,-13.55176811,5.08
42504,129.9899896,-53.05472958,5.18
42509,130.00613183,-12.47537215,4.98
108060,328.40575303,19.66843722,5.69
42527,130.05341092,64.32793601,4.59
9763,31.38145064,76.11506048,5.22
42535,130.0727674,-53.0153978,5.56
42536,130.07327243,-52.9218873,3.6
75304,230.78895891,-36.8584886,4.54
42540,130.07989324,-40.26387468,5.2
75308,230.7937661,-60.65717607,5.65
75312,230.80129685,30.2878122,4.99
42564,130.14691341,-45.19110263,5.67
108102,328.54321926,-4.27617967,5.71
42568,130.15428001,-59.76100272,4.31
42570,130.15654138,-46.64874449,3.77
75352,230.96766276,-12.36950145,5.72
9836,31.64135619,22.64831693,5.03
42604,130.25446162,45.83401001,5.35
75379,231.04953961,-10.32226578,4.92
42614,130.27216748,-48.9226802,5.9
42624,130.30471255,-47.31712459,4.74
108165,328.72147577,56.61122725,5.74
42637,130.3313009,-78.96335934,5.46
75411,231.12261592,37.37716675,4.31
108195,328.79747084,-61.88660835,5.92
42662,130.43056717,-15.94338398,4.87
75439,231.18753835,-39.71026857,5.36
42679,130.48711919,-45.4107139,5.2
108226,328.8791627,65.32080861,5.84
42712,130.56747164,-48.09909047,5.48
42715,130.57913531,-53.1000564,5.49
42726,130.60577595,-53.11398421,4.83
75501,231.33424168,-38.73362055,4.6
9977,32.12191579,37.8590773,4.78
9990,32.16908238,58.42360093,5.66
108294,329.0948743,-37.25365481,5.45
75530,231.44748616,15.42803613,5.16
108317,329.16309874,63.62555723,5.11
42795,130.80137194,12.6808759,5.62
75565,231.5613438,-68.30916685,5.89
10035,32.28871892,-43.51659586,5.84
75572,231.57243338,34.33599626,5.46
108339,329.23488271,12.07649181,5.54
10053,32.35556808,25.93989223,4.98
42834,130.91780328,-49.82280194,5.15
42835,130.91822267,-7.23373036,4.63
75647,231.82553879,-36.76755989,5.46
42884,131.09977937,-42.64927601,4.05
75665,231.88784772,-64.53150379,5.71
42917,131.18765247,10.08167029,5.63
10155,32.65665389,19.50033764,5.68
42923,131.21636195,-37.14724952,5.74
75696,231.96426286,60.67021675,5.9
75730,232.0642008,-16.71648418,5.64
108505,329.72301352,62.69798588,5.96
10212,32.83783009,8.5698049,5.64
10215,32.84261021,-10.05216202,6.0
75761,232.15932129,1.8420812,5.15
108535,329.81235875,73.1798957,5.04
10234,32.89931243,-1.82542945,5.94
108543,329.82463254,-38.39509568,5.5
43012,131.47979613,-79.50437284,5.79
43023,131.50685182,-46.04152748,3.87
43026,131.51031463,-2.04865471,5.7
10280,33.09283449,30.30306664,4.94
75828,232.35112132,-46.73270421,5.26
10296,33.15641173,24.1677783,5.96
43067,131.59390833,-13.54772006,4.32
10305,33.19809079,-2.39363722,5.65
10306,33.20035634,21.21099307,5.23
108612,330.03303161,6.7174374,6.0
43082,131.62727899,-45.91250455,5.43
10320,33.22696028,-30.72382514,5.27
10324,33.24998125,8.8467173,4.36
10326,33.25411349,-21.00013755,5.86
10328,33.26377183,15.27985954,5.72
43105,131.67728835,-56.76977618,4.5
10340,33.30551686,44.23165196,4.84
43121,131.73340873,12.10995219,5.89
108661,330.20927032,-28.45373653,5.43
10366,33.40142588,51.0658183,5.31
43142,131.81244035,-1.89703269,5.28
43148,131.82852179,-46.15541509,5.71
108691,330.27089665,0.60471529,5.6
108693,330.27228975,13.11982345,5.61
108699,330.28847931,8.25716451,5.65
75944,232.66834221,-16.6094644,5.82
10418,33.56059029,-67.84144101,5.57
75973,232.73233051,40.83304674,5.04
75974,232.73235229,64.20869349,5.74
10440,33.63310636,-41.16676458,5.91
108758,330.46078218,52.88225277,5.79
108772,330.51905044,58.00036655,5.55
76008,232.85387206,77.34935188,5.0
76013,232.87842252,-73.3895909,5.4
76041,232.94575727,40.8993325,4.98
10513,33.8692694,-67.7463659,5.67
10535,33.92823871,25.04304345,5.57
43305,132.34052593,-3.44302337,5.3
10540,33.94187534,25.78293743,5.79
108845,330.73608443,44.64986302,5.57
108849,330.76587415,-76.11842744,5.94
43325,132.41316404,-40.32015784,5.47
10559,33.98451972,33.35889507,5.25
108868,330.81858052,-6.52240596,5.55
108870,330.84023615,-56.78597558,4.69
76106,233.15292216,-19.67045969,5.5
108874,330.8285172,-2.15536296,4.74
108875,330.82930031,11.38655209,5.83
43347,132.44849184,-45.30787472,4.94
43352,132.46458217,-32.78052517,5.19
76126,233.23008838,-16.85284434,5.53
76133,233.2414075,-1.18639936,5.5
10602,34.12743894,-51.51216468,3.56
43370,132.50929616,-29.46299701,5.86
108917,330.94772431,64.62797127,4.26
108924,330.97073901,63.11992053,5.26
43392,132.58756813,-42.08979111,6.0
10642,34.24601753,-6.4221162,5.51
10644,34.26345869,34.22423111,4.84
43413,132.63942286,-46.52918681,5.09
43414,132.64507433,-66.79298096,5.34
76207,233.50711487,-40.06643242,5.82
108975,331.1531961,-26.82235879,5.97
76219,233.54458663,-10.06452866,4.61
108991,331.19759232,-0.90634341,5.29
109005,331.25207425,62.78567143,5.27
76243,233.61047272,-9.18341606,5.16
109017,331.28662119,62.27981369,5.07
10718,34.499532,57.8998206,5.75
109023,331.29722504,26.67368931,5.75
10723,34.50599949,1.75780187,5.6
76259,233.6555021,-28.04698322,5.13
43496,132.89337937,-7.17722564,5.55
10729,34.51910362,57.51632134,5.99
43499,132.90214838,-57.6335775,5.59
10732,34.53140185,19.90116354,5.58
109056,331.39447779,28.96398081,5.69
43531,132.98679585,43.72660287,5.15
109068,331.41979781,5.05853048,4.86
76307,233.81216083,39.01006717,5.14
76311,233.81749673,53.92214366,5.97
109081,331.46256902,-59.63607191,5.62
43550,133.0417708,42.00273476,5.98
43553,133.04903518,45.31281911,5.96
10793,34.73747203,28.64267401,5.29
109102,331.50813416,45.01434833,5.09
43584,133.14425694,32.47415705,5.67
10819,34.81998296,47.37997309,5.31
43587,133.14921322,28.3308187,5.96
43589,133.16085529,-48.35909718,5.92
43603,133.20007609,-38.72408636,5.79
76371,233.97186738,-44.95838909,4.55
76376,233.98766354,54.63056667,5.77
76397,234.0504158,-44.39682312,5.44
10871,34.97612918,-55.94479621,5.81
43644,133.34398961,61.96226784,5.72
76424,234.12182931,16.11908473,5.93
76425,234.12324829,10.01017604,5.26
43669,133.45273784,-60.35390883,5.78
43671,133.46081503,-47.52077781,5.31
109209,331.86913669,19.47552571,5.74
109240,331.95960134,21.70292564,5.79
10944,35.2425344,50.15146565,5.57
43721,133.56137964,30.57911508,5.4
76509,234.38336373,54.50873314,5.85
76519,234.41303496,69.2833439,5.65
109289,332.10805122,-34.04384111,4.99
76532,234.4501608,-23.14169782,5.79
76534,234.45665521,40.3534329,5.25
43783,133.76178383,-60.64460928,3.84
76552,234.51335576,-42.56734797,4.34
11021,35.48594668,0.39567548,5.29
109332,332.24579476,-18.51959165,5.8
11029,35.50638199,-10.77753362,5.43
43797,133.79909085,-54.96576824,5.7
43798,133.80179199,-18.24118931,5.75
11033,35.52076129,-17.66216933,5.89
76568,234.56761052,46.79775126,5.76
76569,234.56784142,-21.01632655,5.82
11046,35.55165239,-0.88485213,5.42
109352,332.3068075,33.17233752,5.58
43825,133.88154271,-27.68187118,4.87
76594,234.64248369,50.42328353,5.84
11060,35.58931055,55.84565348,5.16
43834,133.91532883,27.92748154,5.23
11072,35.63561159,-23.81632609,5.19
43851,133.98145066,11.62602321,5.44
76618,234.70613394,-52.37269466,5.43
11090,35.70960144,41.3962973,5.81
76628,234.72733058,-19.30189199,5.36
11095,35.71793796,-73.64579219,5.99
109400,332.4517966,72.34120687,4.79
109404,332.48209025,-34.01496677,5.37
11102,35.72781208,-51.09212882,5.9
43878,134.08025856,-52.72347522,4.68
109422,332.53658393,-32.5484068,4.94
43894,134.12714884,40.20147407,5.9
43899,134.14219398,-16.70874809,5.95
43903,134.15600822,64.60383153,5.57
76669,234.84446952,36.63581181,4.64
43908,134.17077648,-85.6631523,5.43
43923,134.20813723,45.631646,5.72
43932,134.23582185,32.91042991,5.44
109466,332.64060971,-4.26685544,5.98
109471,332.65596853,11.62453953,5.78
109472,332.6561761,-11.56493952,5.43
43937,134.24340608,-59.22933781,4.93
76705,234.94157853,-34.41192603,4.66
109474,332.6616294,70.13257265,5.52
76716,234.98560042,-59.90833817,5.95
43970,134.31229159,15.32276214,5.22
76742,235.07039743,-23.81807829,4.97
76750,235.08888668,-73.44668497,5.64
109521,332.79122113,50.82339282,5.38
11220,36.10381778,50.00654619,5.19
44001,134.39666647,15.58128073,5.68
11249,36.20440136,10.61056498,5.48
109556,332.87740018,59.41448763,5.05
44024,134.4814937,-48.57291016,5.88
11258,36.22462811,-60.31194752,5.36
109572,332.95319831,56.83935728,5.24
76810,235.24625327,16.02458817,6.0
109577,332.96387934,16.04055086,5.93
109592,333.00839859,60.75909505,5.37
76829,235.29740578,-44.66120503,4.64
109602,333.03372554,24.9506412,5.97
44075,134.68305484,-16.13272704,5.8
11313,36.40592791,50.278631,4.73
109620,333.09354262,63.29103525,5.76
44093,134.7181404,-47.2346878,5.17
76866,235.44756448,12.84752763,5.34
76877,235.47784835,-76.08195925,5.95
76878,235.47797158,18.46403679,5.8
76880,235.48665872,-19.67882804,4.75
11345,36.48752198,-12.29047964,4.88
11348,36.50145519,-15.34124674,5.88
109654,333.19926981,34.60459203,5.34
44143,134.8507614,-59.08371209,5.17
11381,36.64674012,-20.04261694,5.89
44154,134.88605804,32.41855927,5.23
109693,333.29423117,86.10795472,5.27
76939,235.6596473,-37.42493556,5.23
76945,235.67091721,-34.71040721,4.75
76957,235.71149928,52.3609026,5.48
44191,135.02253575,-41.25360521,4.45
109730,333.41124738,28.60801711,5.87
11432,36.86571544,31.80128023,5.55
109737,333.43513855,-25.18090505,5.58
109745,333.45516707,45.44061303,5.53
76996,235.82053928,-84.46527293,5.57
11477,37.00709608,-33.81103904,5.13
109786,333.57513369,-21.07456625,5.33
11486,37.041585,29.66933047,5.29
109789,333.57813081,-27.76690756,5.45
44256,135.19059047,-60.96382829,5.8
77048,235.99708548,32.51580692,5.57
44283,135.28547309,-68.68391596,5.89
77052,236.0075819,2.51517329,5.86
77060,236.01833122,-15.67283378,5.41
109831,333.6848788,42.95391034,5.72
44299,135.3369198,-41.86425439,5.56
44307,135.35053935,32.25229649,5.89
11548,37.20206105,29.93176028,5.89
77086,236.09447621,-41.8190887,5.93
11569,37.26644081,67.40247393,4.46
44337,135.4356634,-52.18868536,5.23
44356,135.49161758,-0.48267346,5.64
109908,333.90383575,-41.34670059,4.79
44390,135.63621691,67.62961897,4.74
77163,236.34784913,5.4473148,5.57
44405,135.68443911,24.45291523,5.45
44406,135.68673927,7.29826681,5.85
109972,334.11068187,57.22023845,5.88
11670,37.63480803,25.23503642,5.88
109973,334.11065824,-41.62722507,5.11
11687,37.68834619,0.25574908,6.0
77227,236.52348786,-1.80419278,5.39
110000,334.20018595,-12.83143618,5.34
110009,334.21902457,-9.04006677,5.8
110023,334.2770821,-5.3871641,5.75
77257,236.61088855,7.35307319,4.42
44504,136.00167287,54.28388682,5.74
77272,236.64482815,55.4747908,5.94
11738,37.87539846,2.26718161,5.27
77277,236.6666889,62.59955706,5.19
44511,136.03866845,-47.09773702,3.75
77286,236.68423547,-34.68245371,5.61
11757,37.91893415,-79.10938186,5.27
110078,334.46081339,-77.51155332,5.49
11783,38.02178461,-15.2446768,4.74
11784,38.02571027,36.14727125,5.15
11791,38.03925366,-1.03489611,5.36
77336,236.82216304,14.1153483,5.71
110103,334.55270577,62.80438774,5.75
110109,334.56506336,-53.6270735,5.36
44599,136.28672438,-72.60270534,4.47
77370,236.90802758,55.37662695,5.85
11840,38.21924713,34.5424097,5.84
11843,38.22558556,15.03455423,6.0
44613,136.35039948,48.53031413,5.48
77390,236.97106727,-65.44229133,5.54
44626,136.40989341,-70.5384967,4.66
11867,38.27927736,-34.64996687,5.91
110179,334.75308343,-13.30499496,5.96
77412,237.05544341,13.78907797,5.98
44659,136.49319468,5.09231573,4.99
77442,237.14339541,28.15674892,5.89
11918,38.46126669,-28.2323435,4.96
77464,237.23665667,-3.81851309,5.53
110256,335.00699236,-80.43974699,5.09
110273,335.04965231,-7.82110201,5.35
110298,335.1149036,5.78949798,5.37
12002,38.67760483,-7.85944515,5.74
77541,237.48956804,-48.91240761,5.86
77562,237.52951595,-53.2097703,5.78
44798,136.93671783,10.668191,5.23
77578,237.57311229,2.19650915,5.21
44818,137.00021065,29.65423553,5.42
44824,137.01200194,-25.85853572,4.62
110371,335.33057976,28.33052953,4.78
12072,38.91142353,37.31226284,5.72
110386,335.37947921,12.20518609,4.82
12086,38.94504727,34.68755845,5.38
110391,335.39820144,-21.5982299,5.12
44857,137.09791238,66.87323482,5.15
12093,38.96863365,5.59324631,4.87
77635,237.74477002,-25.75129544,4.63
12107,39.0002013,-7.83159717,5.53
77645,237.77835295,-55.05553281,5.74
12114,39.02039079,6.88687029,5.79
44883,137.17574809,-8.58952398,5.6
77655,237.80804817,35.65738198,4.79
12122,39.0386071,-30.04497764,5.74
44892,137.19720932,26.62911175,5.95
77660,237.81497246,-3.09049656,5.09
77661,237.81628738,20.97791921,4.74
44897,137.21279364,33.88221693,5.95
44901,137.21773434,51.60464833,4.46
77678,237.88091307,-47.06080055,6.0
12148,39.14612752,7.73002606,5.81
12153,39.15798197,12.44763871,5.64
44923,137.26754064,-18.32854841,5.73
44936,137.29797771,-12.35770604,5.76
44946,137.33972349,22.04544558,5.16
12181,39.23828169,38.73358091,5.91
12186,39.24419965,-34.57797694,5.78
44961,137.39820557,-8.78764775,5.47
77738,238.06898748,55.82671307,5.81
110506,335.78327857,-45.92848794,5.62
110529,335.87853554,-24.76266115,5.53
110532,335.8839638,-7.19442118,5.92
45001,137.48504203,-30.36540124,5.59
12239,39.40028258,65.74533624,5.8
12247,39.42416781,-3.39617474,5.65
45038,137.5981063,67.13401804,4.8
12273,39.50846272,72.81825166,5.17
77811,238.33357736,-20.16704023,5.04
110578,336.02868366,-4.83701991,5.79
12288,39.57775943,-30.19406253,5.84
110602,336.11275166,-13.52936898,5.76
77840,238.4029962,-25.32714192,4.59
45075,137.72942033,63.5136327,4.67
45080,137.74202204,-58.96689577,3.43
110618,336.15368188,-72.25541209,5.28
45085,137.76832899,-44.86790173,4.99
77853,238.45640848,-16.72929352,4.13
77858,238.47464386,-24.53315725,5.38
77859,238.4827661,-23.97809446,5.41
12332,39.7041439,21.96140834,5.45
45101,137.81966709,-62.31697715,3.96
110649,336.23496035,-57.79741534,5.31
45122,137.8890954,-46.58391088,5.78
110668,336.29418278,-70.43162205,5.78
77902,238.64421562,20.31096824,5.45
77907,238.65771031,43.13856713,5.35
77909,238.66470881,-25.24374125,5.87
12390,39.89097607,-11.87215595,4.83
45158,137.99473448,-19.74762765,5.72
12394,39.897339,-68.26694624,4.12
77939,238.7515163,-19.38292565,5.95
45189,138.12717963,-43.61326199,5.56
110725,336.50340751,70.7708984,5.47
12444,40.05175765,-9.45287501,5.79
77982,238.87332974,-68.6030014,5.11
77984,238.87533288,-26.26599348,5.63
45219,138.23179649,-59.41392852,5.54
77986,238.87746678,42.5661931,5.73
77990,238.88485665,-60.17764722,5.78
110778,336.64281397,-16.74213796,5.55
78012,238.94827874,37.94695788,5.43
110785,336.65577291,4.3937662,5.76
12489,40.17114788,27.0609427,5.3
110787,336.67668342,78.78585295,5.83
45270,138.39355741,-47.33840744,5.92
78045,239.02464218,-60.48247726,5.76
110817,336.77212619,65.13226983,5.52
45290,138.45086324,43.21782455,5.3
12530,40.30832736,-0.69565302,5.72
45314,138.53420889,-44.14582202,5.85
45328,138.57496111,-55.56962953,5.26
12562,40.39220418,-14.54927595,5.98
45333,138.58558579,61.42331762,5.18
78105,239.22290935,-33.96613398,5.14
78106,239.2254978,-33.96428074,5.59
110873,336.94273,31.84004456,6.0
45344,138.6020198,-43.2274927,5.24
110882,336.96467618,4.69566364,4.78
78132,239.31071625,14.41448012,5.54
78142,239.33885603,-36.18534387,5.78
12608,40.52752839,-38.38368632,5.99
45386,138.73820379,-37.60239609,5.85
12623,40.56214992,40.19394381,4.91
110935,337.15696604,-67.48905907,5.56
78168,239.41859712,-20.98307996,5.84
110936,337.16337454,-39.13179163,5.47
12640,40.5914154,20.0114649,5.74
45410,138.80771998,14.94150673,5.36
45412,138.80936076,34.63351605,5.98
78180,239.44767142,54.74976237,4.96
45439,138.90295253,-38.56994234,4.92
78207,239.54737034,-14.27935849,4.95
45448,138.93783179,-37.41314409,4.63
110986,337.28326255,9.1290341,5.6
12686,40.7480145,53.5261052,5.85
45455,138.95742525,56.74140659,5.28
110992,337.29261484,26.7631985,5.79
12692,40.76182552,55.10601929,5.76
45461,138.96908418,72.94632615,5.93
78246,239.64527909,-24.83148822,5.43
12719,40.86296995,27.70714655,4.65
45493,139.04719847,54.02185739,4.8
45496,139.05030102,-57.54147354,4.34
45505,139.0959805,-44.26573459,5.12
111043,337.43930587,-43.74922369,4.12
78276,239.74047384,36.64377347,5.61
111045,337.44174625,-27.10728417,5.95
78279,239.74227757,-65.03758551,5.74
111056,337.47074424,78.82428466,5.45
45526,139.17236416,-8.74475948,5.49
45527,139.1739019,-6.35314449,5.24
111062,337.49140602,4.43169004,5.51
111068,337.5075588,32.57263835,5.64
12768,41.02149903,44.29704002,5.43
45544,139.23781764,-39.40153886,5.31
78323,239.87610968,-41.74443615,4.99
45559,139.28217379,-14.5740689,5.83
12803,41.13739078,15.31186153,5.78
45571,139.32177181,-68.68964167,5.38
45581,139.35489485,-74.89431283,5.28
45585,139.36487353,-74.73459076,5.86
111123,337.66173361,-10.67795002,4.82
12821,41.20707139,67.82463015,5.95
45590,139.37990677,46.81722811,5.96
12832,41.23992306,12.44576098,5.17
45631,139.52446206,-51.05085914,5.26
78400,240.0816314,-16.5333505,5.47
12871,41.3644922,-63.70455293,5.73
12876,41.38597694,-67.61661701,4.83
111196,337.90631532,-85.96725319,5.76
45661,139.60795608,35.36407958,5.94
78436,240.19846931,-8.41135327,5.53
78442,240.21305704,4.42736313,5.82
45675,139.67648516,-51.56065139,5.83
78459,240.26108988,33.3035093,5.39
111242,338.06760858,76.2264413,5.7
78481,240.3096572,17.81839727,5.1
111259,338.10990871,39.77973355,5.88
45743,139.88805816,-15.83466291,5.79
45751,139.94325884,-11.97485258,4.77
78542,240.52315992,52.91591721,5.93
111310,338.25026381,-61.98212195,4.91
78554,240.57371658,22.80445386,4.82
45811,140.12090854,-9.55569462,4.8
13055,41.94878463,81.44847547,5.8
78592,240.69957561,46.03670491,4.72
111362,338.41937473,56.62473707,5.72
13061,41.97725287,29.24711818,4.52
45856,140.23671804,-62.40463244,4.79
111394,338.51213358,-1.57426985,5.88
13108,42.13370521,18.28379052,5.83
78649,240.83068614,36.631787,5.79
78650,240.83592905,-25.86524023,4.96
13121,42.19126771,25.18806369,5.89
78655,240.85078899,-38.60254059,4.9
78661,240.88063042,76.79393894,5.73
78662,240.88371506,-57.77506392,4.63
78665,240.89316192,-32.00053847,6.0
45902,140.37329518,-25.96543878,4.71
13141,42.25619836,-62.80652153,5.25
111449,338.67348716,-20.70821576,5.21
45915,140.43037113,56.69921955,5.79
45920,140.45851013,-55.51468559,5.61
45924,140.46244702,-42.19486035,5.56
13165,42.32316638,17.46430897,5.26
78727,241.0922274,-11.3731039,4.16
45962,140.5999687,-46.04744483,5.74
13202,42.47575765,-27.94198156,5.39
78747,241.15340077,-37.86295066,5.91
111515,338.90156579,-23.99109409,5.97
13225,42.56159976,-35.84363655,5.92
111532,338.94223205,73.64318817,5.08
111546,338.96785542,39.63433069,5.73
13244,42.61858328,-75.06694714,4.76
13254,42.64608204,38.31864364,4.22
46026,140.80104443,-28.83387303,4.71
13265,42.66836129,-35.67584879,5.48
78821,241.36064081,-19.80186007,4.9
13288,42.7596731,-21.00401932,4.76
111600,339.14767144,-31.66378886,5.82
13327,42.87327848,15.08207065,5.52
13328,42.87848975,35.05974098,4.56
78868,241.4825736,-72.40089807,5.7
46101,141.02289486,-61.64890244,5.99
13339,42.92387512,46.84193945,5.86
46107,141.03843596,-80.78687606,5.34
78877,241.52657175,-23.60631525,5.9
111643,339.24522754,-40.5910344,5.85
111660,339.30402597,75.37181088,5.8
78893,241.58198561,67.81013363,5.44
13367,42.99479856,68.88849697,5.94
111674,339.34340696,51.54512282,4.64
78918,241.64810321,-36.80228846,4.22
78933,241.70177456,-20.66919247,3.93
111710,339.43908758,-4.22805572,5.04
78970,241.8175542,-36.75567607,5.72
46221,141.35014778,-5.11739372,5.6
78990,241.8513642,-20.8687642,4.31
46225,141.36347638,-61.95047605,5.77
79005,241.90173206,-12.74541033,5.75
79007,241.90641092,9.89174292,5.63
13473,43.39332117,-38.43700368,5.93
13479,43.39717892,-22.37630756,5.93
13490,43.42755662,38.33748839,5.34
111795,339.65801295,56.79563166,5.11
111797,339.66272116,63.58447203,5.19
111809,339.71444358,-33.08134754,5.66
79043,242.01885653,17.04698022,5.0
111810,339.71912555,19.5222628,5.84
79050,242.03160775,-26.32667888,5.35
46283,141.57482518,-53.37890899,5.09
79072,242.11697935,8.5343098,5.69
111841,339.81532792,39.05026916,4.89
79098,242.18216954,-23.68541585,5.86
79119,242.24291258,36.49094417,4.73
79120,242.24533115,3.45447473,5.93
46358,141.77628651,-71.6018951,5.46
79137,242.29672854,6.37869508,5.93
46371,141.82669014,-22.3437826,4.72
79153,242.32728698,-57.93431797,5.57
111925,340.0766967,53.84592759,5.94
111934,340.09294428,-30.65887086,5.88
46404,141.9449187,-6.07118721,5.38
13654,43.95207421,18.33163983,5.76
79195,242.46049234,-3.4667292,5.39
79199,242.46912194,-33.54580488,5.5
111967,340.20382572,-57.42232207,5.98
13665,43.98716905,61.52113777,5.59
111974,340.21950989,14.54916061,5.72
13679,44.05737361,8.3815634,5.97
46454,142.11416993,9.05677773,5.4
46457,142.12157061,8.18829842,5.72
46460,142.12727921,-66.70187737,5.9
13702,44.10897867,18.02311886,5.58
46471,142.16662216,45.6014831,5.4
46482,142.19626823,-62.27313432,5.91
13717,44.15593438,-3.71231988,5.16
112031,340.36937888,40.2254488,5.25
112041,340.40021569,41.54912344,5.93
46509,142.28707376,-2.76896393,4.59
46511,142.3026759,-20.74912751,5.66
79280,242.70635509,75.87756285,5.48
112051,340.43920158,29.30764069,4.8
112067,340.48939852,14.51639289,5.92
79302,242.75862402,-29.4162203,5.09
13775,44.32201066,31.93421866,5.1
13782,44.34902489,-23.86216374,5.44
79320,242.8237751,-41.11980324,5.86
46578,142.47710045,-26.58961559,5.49
79349,242.90848202,23.49480143,5.74
112117,340.65367718,-47.21081334,5.99
79357,242.94833015,42.37456882,5.89
79358,242.95022732,36.42509439,5.62
46594,142.52129237,-51.51716414,5.45
13834,44.52175646,20.66873326,5.8
13835,44.52389062,-23.60601201,5.82
79375,242.99995237,-10.06425307,4.93
46618,142.59368039,-15.57735181,5.86
46620,142.59758877,-58.36183956,5.88
79387,243.03048126,-8.54757591,5.43
79399,243.0668317,-28.41730511,5.67
79404,243.07585385,-27.92637196,4.58
13874,44.67532015,-2.78287686,5.22
13879,44.69029205,39.66272854,4.68
46652,142.68007801,33.65571065,5.87
46657,142.69207663,-31.88922182,5.75
112203,340.87490273,-41.41434678,4.84
13905,44.76531915,35.18312827,4.94
112211,340.896805,-18.83037526,4.68
13914,44.8030237,21.34042885,4.63
46701,142.80549519,-57.03437682,3.16
112241,341.02174163,39.46534838,5.93
112242,341.02282912,41.8192347,5.11
13942,44.90076145,-25.27413271,5.69
13949,44.9161641,41.03294069,5.89
13951,44.92149906,-2.46495154,5.56
79488,243.31428933,5.02108648,5.46
79497,243.34456747,-55.54094742,5.78
13965,44.95746995,47.22069307,5.47
46734,142.88399535,-31.87183135,5.91
46735,142.8850429,35.10327265,5.39
46736,142.88769189,-35.71475041,5.86
46741,142.90113654,-73.08091272,5.46
79509,243.36970393,-54.63046753,4.95
46771,142.9864117,11.29982653,4.99
79540,243.46210399,-11.83774676,5.24
46774,142.98990553,9.7157667,5.07
46776,142.99553372,-1.18466379,4.54
14036,45.1839228,10.87038841,5.93
14043,45.21755767,52.35174424,5.24
46811,143.08032576,-40.64933489,5.35
46813,143.08503617,-19.40030353,5.74
14060,45.29176726,-7.66301153,5.75
79596,243.59318878,-33.01108784,5.91
112374,341.40784202,-53.50012101,4.84
79607,243.67022334,33.85861287,5.23
112381,341.41992749,-46.5473276,5.52
14086,45.40682262,-28.09155384,5.88
46859,143.23239248,-13.51680367,5.95
14109,45.47558905,26.46235385,5.91
14110,45.48382908,-9.96140669,5.84
46880,143.30191619,-21.11572236,5.02
112417,341.54259215,44.54605449,5.84
79653,243.81381535,-47.37202131,5.13
79664,243.85946153,-63.68568176,3.86
46897,143.35854726,-22.8638835,5.92
79666,243.86931313,18.8080866,5.72
14131,45.5643682,-71.9024567,5.51
79672,243.90529277,-8.36944168,5.49
14143,45.59382454,4.35288413,5.62
112447,341.67325244,12.17288788,4.2
46914,143.43557959,-49.00507186,5.12
79689,243.95749098,-57.9123497,5.61
46928,143.47240397,-80.94125808,5.07
14168,45.67614498,-7.68547178,5.32
46950,143.53663903,-51.25526648,5.01
14187,45.7327619,-46.97503638,5.81
46974,143.61104266,-59.22975334,4.08
46977,143.62024899,69.83034278,4.54
46982,143.63603489,-5.91494806,5.56
112519,341.87109651,83.15383033,4.77
79754,244.18032631,-53.81110927,5.45
79757,244.18661396,29.15026076,5.8
112529,341.88801764,-19.61337502,5.24
47006,143.7059716,52.05147688,4.47
112542,341.92820178,-14.05642835,5.68
47013,143.7230253,72.20567923,5.77
79790,244.2538895,-50.06812186,4.97
47029,143.76595846,39.62149337,4.81
79797,244.27255228,-67.94128543,5.95
79804,244.31394402,59.75502328,5.37
112590,342.04598204,37.41668797,5.82
14293,46.06881559,-7.60085702,5.26
47080,143.91459292,35.81013347,5.4
79881,244.57457668,-28.61402047,4.8
14376,46.3612078,25.25517451,5.45
14382,46.38504744,56.70571907,4.77
47168,144.17855027,31.16173433,5.57
79938,244.75175031,-14.87282537,5.97
47175,144.20641702,-49.35502581,4.34
14417,46.53267546,79.41853526,5.49
79953,244.796723,49.03815923,5.93
47187,144.25086356,-25.29675945,5.68
47189,144.26075135,16.4379518,5.73
47193,144.27202941,81.32638208,4.28
79963,244.82352371,-42.67396507,5.44
112731,342.44298077,55.90277673,5.43
47199,144.29121374,-32.17864643,5.62
47204,144.30271898,-53.66850826,5.44
47205,144.30278012,6.835802,5.0
14439,46.59868993,13.18725028,5.64
79980,244.88641112,-30.90671595,5.53
14456,46.63955128,-6.08855469,5.23
47224,144.3683363,-36.09599409,5.96
80008,244.97976149,39.70858437,5.48
112778,342.59072879,41.9533937,5.91
112781,342.59506056,-80.12384547,5.32
47267,144.50605592,-43.19094447,5.51
14502,46.82916106,64.05759405,5.89
80054,245.10521092,-55.13970611,5.76
14521,46.88392638,-78.9892445,5.67
80057,245.11191165,-78.66749596,5.27
112832,342.7589976,-39.15683359,5.43
112833,342.76263737,85.37373901,5.89
47300,144.59073275,40.23979335,5.28
47310,144.61370114,4.64929286,4.68
80079,245.15908631,-24.16932002,4.55
112862,342.83724717,-29.53630903,5.99
112864,342.8442826,61.69674047,5.61
112917,343.00847896,43.31241729,4.95
47391,144.83749386,-61.32806002,4.51
80161,245.4529632,69.10939138,5.26
112935,343.10031448,9.83566452,5.16
47401,144.86614459,67.27223037,5.96
80179,245.51812082,1.02903908,4.82
80181,245.52426649,30.89199596,4.86
80197,245.5892723,33.79905176,5.2
80208,245.61664599,-49.57235445,5.32
80212,245.62111283,-43.91205108,5.89
14677,47.40309339,29.07708008,5.74
80214,245.62174444,33.70347845,5.4
47452,145.07651372,-14.33229221,5.07
112997,343.25944136,16.841194,5.86
47479,145.17731003,-57.98355305,5.3
113031,343.36960354,-11.61651418,5.8
47498,145.25910511,-57.25954239,5.8
47508,145.28763669,9.892308,3.52
113048,343.41731794,44.74916327,5.79
47522,145.32086423,-23.59151405,4.76
14764,47.66164025,11.87262694,5.97
80309,245.94647297,61.69646128,5.67
47544,145.39631661,31.27781719,5.9
113084,343.5291047,40.3769066,5.82
47559,145.44969741,-55.2137617,5.99
80337,246.00537432,-39.19298028,5.37
47570,145.50142855,39.75785117,5.61
113116,343.60403032,84.34617662,4.7
80351,246.04512471,6.94820724,5.83
14817,47.82242336,39.61158237,4.61
47592,145.56006988,-23.91556899,4.93
47594,145.56176479,69.23753736,5.72
14838,47.90735613,19.72667738,4.35
80375,246.10557864,55.20509584,5.75
14844,47.9278047,81.47070965,5.92
113148,343.68945382,-16.27195737,5.53
80390,246.13231258,-37.56604406,5.42
14862,47.98445775,74.39365924,4.85
80399,246.16571952,-29.70466306,5.4
113174,343.76103611,37.07682727,5.91
113184,343.79567219,-4.98789888,5.72
113186,343.80696948,8.81616592,4.91
47654,145.73828058,72.2526183,5.15
14893,48.05935964,27.25696838,5.78
14913,48.10727749,-44.41966029,5.92
14915,48.10985486,6.66088292,5.55
113222,343.93544836,36.3513899,5.73
80460,246.35069888,37.39407916,5.53
14930,48.13816688,-57.32154906,5.71
47701,145.88858324,29.97447335,5.64
80480,246.4299329,78.96385386,5.55
47717,145.92597679,-53.89128223,5.56
14954,48.1934853,-1.19610121,5.07
47723,145.93293593,14.02169206,5.36
113281,344.0984592,41.60387594,5.6
113288,344.10832803,49.73354396,4.99
47758,146.05039686,-27.76947109,4.78
113307,344.19916346,-47.96922144,5.72
15004,48.34947111,48.17695327,5.93
113327,344.26875958,48.68406797,5.34
113357,344.36658526,20.76883227,5.45
80620,246.93106828,-7.59792904,5.24
47854,146.31171365,-62.50790315,3.69
80645,246.98893484,-64.05794176,5.28
15110,48.72540048,21.04444121,4.87
80650,246.99589024,68.76813711,4.94
80672,247.06028618,-37.17988144,5.79
80675,247.06316169,-58.59979504,5.67
80686,247.11726481,-70.08440088,4.9
15154,48.83515165,30.55668942,5.61
80693,247.14158895,0.66500201,5.41
80704,247.16061566,41.88167726,4.83
47943,146.54185087,6.70855585,5.8
47956,146.58596518,-76.77611986,5.43
15192,48.94987707,57.14062036,5.79
47959,146.59719951,11.81004306,5.67
47960,146.59837945,1.7855861,5.65
15197,48.95843559,-8.81972986,4.8
47963,146.62654282,-44.7550603,5.58
47965,146.63193451,57.12807021,5.09
15201,48.99025199,-77.38845428,5.51
113503,344.79922339,11.72884358,5.76
113521,344.86439619,0.96292709,5.43
15219,49.05084766,50.93766392,5.04
113532,344.89899254,-29.462311,5.51
48002,146.77550679,-65.0720068,2.92
15241,49.1466228,32.18401757,5.98
80782,247.42636486,-46.24322863,5.35
80793,247.44551354,-14.5508791,5.66
113561,345.02125312,56.9453738,5.1
113562,345.0241198,-25.16418002,5.66
80815,247.5519821,-25.11522381,4.79
15305,49.36081681,-47.75166403,5.84
80843,247.6397853,20.47918805,5.24
113622,345.178752,3.01180506,5.85
15330,49.44234789,-62.57532203,5.53
15334,49.44064201,39.28337316,5.97
15338,49.4473059,44.02502428,5.49
80874,247.7056645,-61.63350312,5.19
48113,147.14738081,46.02100807,5.08
113657,345.28157612,-50.95002843,5.68
15357,49.51081436,-28.79707518,5.93
80898,247.80596362,22.19545777,5.76
113669,345.33077674,-28.85396037,5.55
15371,49.55341226,-62.50636301,5.24
80911,247.84555554,-34.70436598,4.24
15382,49.59209811,-22.51111801,4.86
15383,49.5934401,-0.93028832,5.62
113686,345.38212585,-4.71146131,5.94
15404,49.65725554,50.22217425,5.16
80945,247.92403593,-41.81714466,5.31
15411,49.67145547,-18.55979384,5.72
15416,49.68260357,34.2226526,4.85
80953,247.9467837,45.59828098,5.61
48191,147.36701467,-37.18676531,5.95
80975,248.03416357,-21.46638977,4.45
15444,49.78182858,50.09496612,5.05
48224,147.48808628,-45.73273575,5.09
15457,49.84040002,3.37019788,4.84
80991,248.10700062,60.82332314,5.92
81007,248.14868862,5.52122034,5.63
15479,49.89544554,-24.12290192,5.63
113788,345.65158819,42.75779461,5.09
113801,345.68438225,-20.8707117,5.97
15514,49.98248617,27.07113436,5.91
48287,147.6747364,-46.9339226,5.72
15520,49.99696958,65.65229236,4.74
48310,147.73159411,-62.7451164,5.56
15547,50.0823276,77.73474052,5.44
15549,50.08483666,29.04845844,4.47
113860,345.87423393,-34.74941192,5.12
113864,345.88701295,67.20920976,5.25
48339,147.80027537,-59.42577425,5.79
48348,147.83216782,-46.19387149,5.62
81122,248.52091948,-44.04531483,4.86
113889,345.96922513,3.82004536,4.48
113902,345.99849674,-41.478896,5.79
81141,248.58058375,-70.98809744,5.5
48374,147.91944867,-46.54762042,4.58
113919,346.04576333,50.0520906,4.64
15619,50.27834733,3.67562031,5.7
48390,147.97099175,24.39536942,5.29
15627,50.30676875,21.1470861,5.27
48402,148.02648325,54.06433236,4.55
15643,50.35004205,-23.63513525,5.5
15648,50.36066117,43.32965082,4.96
113957,346.16511402,-53.96490515,5.37
113969,346.21758641,-68.82022566,5.53
15669,50.46888702,49.0709047,5.94
113996,346.29078154,-7.69380135,5.44
15696,50.54955583,27.60755258,5.55
81252,248.93674449,-65.49539896,5.5
15737,50.68850607,20.74206893,5.1
48519,148.42885498,5.9585733,5.9
81289,249.04667654,46.6133331,5.83
81290,249.04758462,52.90004826,5.53
81292,249.05716717,52.92442209,5.07
48527,148.45874341,-51.14671326,5.95
81300,249.08937191,-2.32458363,5.77
81304,249.09363099,-35.25532602,4.18
81305,249.09401037,-42.8588614,5.46
15770,50.80497871,49.21326943,5.32
48559,148.55133009,-25.93234458,4.87
48561,148.57355933,-45.28351642,5.72
114104,346.65340667,59.41975995,4.84
114119,346.67018938,-23.74311551,4.48
114131,346.71970652,-43.52035834,4.28
114132,346.72343754,-38.89229267,5.62
114144,346.7510826,9.40949158,4.54
48613,148.7134616,-50.24395889,5.71
48615,148.71753612,-19.00935988,4.94
114155,346.77808067,25.46825863,4.76
15861,51.07697877,24.72406291,5.5
114167,346.81155017,-50.68668135,5.81
15876,51.12375599,33.53596183,5.78
114189,346.8696459,21.13425059,5.97
15890,51.16898714,64.5859965,5.13
114200,346.91361488,46.38723089,5.3
81437,249.50194035,56.01553977,5.28
114210,346.93910045,49.29577594,5.68
48682,148.92917735,49.81984279,5.27
114222,346.97438076,75.38749619,4.41
81472,249.6095496,-43.39842591,5.83
114254,347.08778156,-28.8236966,5.6
81497,249.68685544,48.92834255,4.86
48734,149.10823479,8.93315735,5.85
15968,51.40105329,-69.33643647,5.96
114273,347.170506,2.12788289,5.42
48748,149.14789188,-33.41849626,5.83
81523,249.77177737,-37.2173701,5.93
16029,51.59385319,-27.31747919,5.93
48802,149.30671096,57.41819578,5.97
114347,347.38107089,8.67716066,5.05
114365,347.43391109,59.33269206,5.68
114366,347.43596045,-28.08857186,5.88
48833,149.4210585,41.05563358,5.11
114375,347.47874826,-22.45761141,4.71
114382,347.4890132,-42.86129195,5.83
114389,347.50608572,9.82208227,5.39
114407,347.54056645,-40.59154707,5.9
81641,250.16119545,4.21978883,5.77
16112,51.88925357,-35.68132348,5.71
48883,149.55573249,12.4448003,5.26
114421,347.58974022,-45.24671132,3.88
81660,250.22966402,64.58904622,4.84
48893,149.59488065,72.87950922,5.86
114430,347.61333692,43.54423191,5.91
16142,52.00394674,-11.28659964,5.74
114449,347.67765316,17.59437171,5.68
16147,52.01279024,49.06286627,4.99
48926,149.71781467,-35.89097265,5.23
81702,250.33506197,-48.7629566,5.57
16168,52.08624888,33.80755744,5.72
81710,250.34628426,-68.29612306,5.89
81724,250.39326259,-17.74216686,4.91
81729,250.40291252,26.91688049,5.92
81733,250.41760437,-49.65155241,5.62
81734,250.42700502,1.18123129,5.74
81741,250.43939225,-33.14575921,5.84
16210,52.21803058,49.84838373,5.58
48982,149.90089279,29.64523256,5.75
114520,347.93412317,8.72011558,5.15
81754,250.4737148,-19.92437683,5.55
49005,149.96535978,56.81180742,5.5
16244,52.34187591,49.50894827,4.67
16245,52.3444899,-62.93752748,4.71
49029,150.05336089,8.04422312,4.68
16263,52.40011329,-12.67473686,5.57
114570,348.13751419,49.40620718,4.53
16281,52.47809925,58.87874967,4.55
16285,52.479782,-42.63425613,5.76
16290,52.49538877,-78.35184991,5.68
16292,52.50076524,55.45180834,5.09
49065,150.18245134,-82.21467008,5.53
49081,150.2527358,31.92367205,5.37
81854,250.77620399,77.51397279,5.99
114622,348.32073073,57.16835504,5.57
16322,52.60195391,11.33644221,5.14
16335,52.64368152,47.99521606,4.36
114641,348.36042925,11.06500132,5.85
16339,52.6539753,-47.37512542,5.98
16340,52.65396132,48.10359644,5.82
16341,52.65440695,-5.07514548,4.74
16358,52.68924968,6.188703,5.93
16368,52.71544718,-66.48971397,5.81
16369,52.71824299,12.93667809,4.14
49164,150.500401,-60.4208902,5.93
81966,251.16559744,-53.15231311,5.96
81972,251.17747189,-40.83967511,5.64
114745,348.65460566,74.23126834,5.89
49220,150.70395978,21.94925787,5.68
81992,251.25078997,-28.50965735,5.99
16470,53.03583692,48.02347611,5.47
114775,348.74425044,-41.10539698,5.77
82020,251.32424053,56.78185727,4.84
16489,53.08385477,84.91103978,5.62
82028,251.34383238,15.74528881,5.6
16499,53.10941575,46.0568617,5.3
16509,53.14501173,-50.37864644,5.67
16511,53.14978818,9.37343822,5.76
16518,53.16673706,35.46172929,5.91
114822,348.89274024,-3.49638036,5.56
114831,348.90724193,70.88807986,5.55
82073,251.45788048,8.58261625,5.15
114855,348.97289447,-9.08773691,4.24
49339,151.08725684,-24.28553452,5.7
82110,251.58843747,-58.50359469,5.74
16591,53.39598063,39.8994785,5.79
82129,251.66663028,-67.1096907,5.1
49363,151.15134501,53.89171627,5.71
16599,53.41274961,54.97485691,5.98
82135,251.69982573,-39.37696194,5.48
114921,349.16579571,-44.48916572,5.92
114924,349.17626317,53.21347563,5.58
82171,251.83190703,-58.34144117,5.55
82172,251.8322777,42.23891803,5.86
114939,349.21224791,-7.72650369,4.93
114948,349.24036261,-62.00119795,5.64
16664,53.61093721,24.46439289,5.95
82216,251.94341033,5.24674597,5.22
49485,151.54671622,-47.36999485,5.06
115022,349.43602907,49.01529974,4.82
115054,349.54118494,-40.82436098,5.54
115065,349.59718419,41.77367574,5.98
16780,53.9902757,-11.19378202,5.56
115088,349.6562199,68.11144459,4.75
82321,252.30924348,45.98332294,4.82
49569,151.78957968,-17.141733,5.59
16803,54.07255242,-17.46706452,5.24
115115,349.74031934,-9.61074996,4.99
82350,252.39440352,13.26114073,5.91
115125,349.77733688288413,-13.455251032789445,5.19
115126,349.77778501,-13.45855162,5.2
16826,54.12241189,48.19263365,4.32
82369,252.45845321,-10.78299985,4.64
115142,349.84990507,-5.12435206,5.56
115144,349.8504498,-18.07537644,5.96
16846,54.19703978,0.58775771,5.82
115152,349.87420094,48.62532218,5.44
82402,252.58075482,7.24768345,5.48
49637,151.97612834,9.99750785,4.39
82422,252.66232689,29.80653779,5.73
115191,349.96841131,42.07804427,5.81
115227,350.08576289,5.38130731,5.05
49698,152.17811802,-65.81543788,5.26
49712,152.23433292,-51.81126063,4.85
82480,252.85386934,1.21594728,5.51
115250,350.15934413,23.74033698,4.58
82493,252.89051052,-41.23053395,5.23
82504,252.93859152,24.65643288,5.03
115271,350.20648672,30.4149211,5.58
115280,350.22193691,38.1823262,5.77
16989,54.62189008,-7.39186296,5.86
49764,152.3756997,-68.68277895,5.8
82545,253.08393309,-38.01753566,3.56
115312,350.31457565,-26.98676884,5.65
17027,54.75465745,-5.62620983,5.97
49809,152.52452658,-12.81592328,5.3
49812,152.53142041,-8.40817035,5.91
82587,253.24190757,31.70167382,5.34
115355,350.47888787,31.81246462,5.35
49844,152.65715756,-41.71524685,5.98
82611,253.32315383,47.41672553,5.99
82621,253.35508699,-20.41555487,5.86
115395,350.63555299,60.13348533,5.56
49865,152.73275506,-8.41846171,5.64
17103,54.96300949,3.05686329,5.55
115404,350.66322094,-15.03933761,5.19
82650,253.42677047,-43.05096825,5.95
49893,152.80324264,37.40190044,5.86
82671,253.49886208,-42.36202495,4.7
82672,253.50149815,-57.90950697,5.91
82673,253.5019647,10.1653591,4.39
82676,253.5076533,-41.80638905,5.46
115444,350.7690354,12.31391022,5.09
49934,152.94358379,-58.06054371,5.7
17167,55.15972166,-5.21070611,5.53
82716,253.61225757,-42.47889089,5.84
82730,253.6487242,-6.1539821,5.23
17203,55.28274194,37.58019786,5.55
82764,253.72987681,20.958488,5.39
115537,351.05525267,-51.89117428,5.75
82775,253.74377151,-41.15085779,5.78
50027,153.20151956,4.61467985,5.77
82802,253.84236363,18.43321261,5.35
82806,253.85286833,-63.26965901,5.99
115590,351.20942663,62.28280657,4.96
115591,351.2118013,32.38488166,5.56
17296,55.53885419,63.21680592,5.06
50070,153.345186,-51.23297082,5.27
17304,55.56209453,-31.93836128,4.99
17309,55.57895166,19.70025375,5.68
50078,153.36664163,-51.75578798,5.78
17313,55.59436099,33.96502633,4.97
50083,153.37763588,-66.37281136,5.15
115620,351.33110675,-56.84898545,5.6
115623,351.34493397,23.40410107,4.42
82860,254.00704079,65.1347956,4.88
50103,153.44134842,-40.34605581,5.91
17342,55.67806192,59.96939134,5.74
17351,55.70856433,-37.31351844,4.59
115669,351.51160877,-20.64201427,4.38
82902,254.11986622,-52.28374646,5.94
82925,254.20015313,-23.15034582,5.57
17395,55.89097385,-10.48566061,5.59
115713,351.65240096,-52.72160286,5.53
82960,254.29656739,-33.25949226,5.48
115746,351.75364161,87.30750398,5.56
115755,351.78083509,42.91201008,5.75
17457,56.12712547,-1.16309122,5.24
17460,56.13096594,36.46010312,5.6
115769,351.81246876,-58.47611022,5.63
115770,351.81928389,70.35978246,5.6
50241,153.88152637,-43.11236912,5.59
17489,56.20089755,24.28947018,5.45
17499,56.2189055,24.11333922,3.72
115806,351.91827729,25.16728105,5.99
17506,56.23540778,-0.29672011,5.56
83057,254.57474809,-50.64118473,5.53
17527,56.29057938,24.83926001,5.66
17529,56.29846606,42.57854862,3.77
17531,56.30206043,24.46727761,4.3
115836,352.01576252,-87.48221392,5.5
17534,56.31615242,-47.35947619,5.72
50303,154.06013222,29.31050136,5.49
50319,154.13453997,23.50309519,5.95
17563,56.41851045,6.04999111,5.34
50333,154.16973949,13.72833434,5.42
50336,154.17398571,25.37070547,5.84
17573,56.45669431,24.36774851,3.87
17579,56.47698473,24.55451103,5.76
17584,56.49691551,45.6818995,5.66
17585,56.50391351,67.20160533,5.79
17587,56.50971428,63.34504728,4.78
17595,56.53901175,6.80352052,5.91
17608,56.58155765,23.94835836,4.14
115908,352.25408607,-63.11065587,5.66
83150,254.89149665,-69.26816367,5.79
115919,352.28873314,12.76055363,4.54
50384,154.31057712,23.10621974,5.81
17618,56.61428557,-29.33815682,5.91
83176,254.99044005,-25.09219835,5.88
50414,154.40750909,-8.06891444,5.25
83187,255.02616419,-54.59717911,5.64
83196,255.03962554,-24.98907,5.74
50448,154.50844418,65.10835102,5.74
83216,255.11233462,-48.64775886,5.98
115990,352.50808479,58.54892004,4.89
50456,154.53162634,-28.99200024,5.52
83235,255.15411512,-35.93413263,5.95
17702,56.87115217,24.10513715,2.85
50480,154.61768332,-41.66849002,5.97
17717,56.91521237,-23.8746767,5.24
83254,255.24223125,22.63209529,5.69
50493,154.65795075,-56.11039337,5.8
83262,255.26500814,-4.22264365,4.82
17738,56.98350273,-30.16788223,5.52
50520,154.77113106,-64.67625789,5.66
17771,57.06778675,11.14329389,5.08
116076,352.82255801,39.23619816,5.22
17776,57.08673496,23.4212498,5.44
83313,255.40150446,33.56826983,5.27
50546,154.86161775,48.39676215,6.0
50555,154.90312561,-55.02930472,4.59
50564,154.93403308,19.47091417,4.78
17797,57.14949492,-37.62015476,4.3
17798,57.14876826,-20.90297667,5.81
83336,255.46934425,-32.143519,5.03
17805,57.16231066,0.22785663,5.91
83367,255.57790086,25.50561962,5.76
50609,155.06964665,-47.69909032,5.66
17846,57.28382126,43.9630947,5.95
17847,57.29059399,24.05341547,3.62
17851,57.29673351,24.13671205,5.05
17854,57.30724168,70.87104997,5.4
17886,57.38620754,33.09138215,5.14
17891,57.40249205,63.29696669,5.82
83430,255.78279838,14.09194666,4.97
83431,255.78629357,-53.2370277,5.27
50676,155.22831683,-56.04322039,4.5
50685,155.26391804,68.7476511,5.88
17932,57.51841774,44.96785586,5.65
83478,255.91375826,13.60534631,5.91
116247,353.31926464,-20.91450406,4.7
116250,353.33161416,-77.38532738,5.82
17954,57.57890965,25.57936194,5.24
83491,255.96225538,-38.15257189,5.91
116264,353.36705724,22.49877472,5.33
83535,256.10300501,-57.71216655,5.73
116310,353.4882817,31.32527712,4.97
50786,155.54400871,41.22952996,5.73
116323,353.5375718,-1.24756716,5.91
50799,155.58160318,-41.64996021,4.82
83574,256.20563526,-34.12293025,4.83
116354,353.65640507,40.23644119,5.55
116355,353.65918103,33.49732855,5.63
116368,353.70566996,-15.24600541,5.95
83601,256.32008022,0.70255911,6.0
83608,256.33381676,54.4700426,4.91
116380,353.74600097,71.64204313,5.86
83613,256.3445437,12.74082791,4.89
50847,155.74227211,-66.90149839,4.97
18081,57.97383088,34.35911894,5.78
116389,353.76901673,-42.61507485,4.69
18089,58.00095388,6.53490743,5.66
50860,155.77636562,33.90814466,5.89
83635,256.38441404,-0.89207004,5.63
50885,155.86032717,-4.07403481,5.93
50888,155.87206731,-38.00983938,5.34
18141,58.1735664,-5.36125893,5.48
83692,256.57519598,22.08415313,5.56
83693,256.58412216,-37.22758997,5.98
50933,156.03269271,65.56642303,4.94
50935,156.03584749,33.71853073,5.52
18170,58.29186012,17.3270832,5.97
50954,156.09877632,-74.0316119,3.99
116495,354.09702465,2.10222234,5.68
18199,58.38882879,-46.89367411,5.93
18212,58.41126409,48.65049537,5.76
18213,58.41227864,-34.73229726,5.11
18217,58.43035872,57.9751413,5.8
50993,156.2475745,-58.57630274,5.93
51008,156.31331299,8.78484459,5.61
18255,58.57292521,-2.95472986,4.46
18262,58.59650653,-40.35700883,5.7
51046,156.43446333,-7.05982902,5.6
116582,354.38351483,44.428994,5.81
116591,354.41483272,-13.06024332,5.66
116602,354.46247793,-45.49235133,4.74
83838,257.00859765,35.9351736,5.41
116611,354.4866777,18.40066705,5.49
83854,257.06189647,-17.60905169,5.98
18339,58.81719951,-12.09910485,5.99
116653,354.59954467,-76.86955231,5.99
83896,257.19807338,-30.40373008,5.93
51140,156.70383779,-54.87730218,5.58
18396,58.99238825,47.87142,5.39
116709,354.78471691,50.47173289,5.35
116714,354.79240042,75.29288242,5.95
83947,257.38853251,40.7770331,5.07
51192,156.85196232,-57.63880469,4.65
116728,354.83812151,74.0026285,5.98
51194,156.85534777,-65.7046639,6.0
83962,257.449793,-10.52330139,5.43
51200,156.86683875,41.60103526,6.0
18434,59.11954126,35.08089877,5.49
18453,59.15217692,50.69538082,5.28
116758,354.94611664,-14.2221779,4.97
51232,156.96970902,-58.73940319,3.81
116768,354.97933479,9.67729366,5.99
18471,59.21698585,22.47797113,5.62
18488,59.28453577,61.10888286,4.99
84033,257.6763468,-44.55771908,5.06
18505,59.35602208,63.07226405,4.95
116820,355.15895489,-32.07312485,5.3
51313,157.21906555,-64.17227778,5.27
116853,355.28713295,-11.6806546,5.89
84105,257.9111672,-48.87339888,5.94
116889,355.3937032,-18.02707702,5.36
51364,157.37072204,-29.66383248,5.58
116901,355.44085819,-17.816533,4.82
18606,59.71830773,-5.46994675,5.85
51376,157.39741059,-30.60706508,5.57
84150,258.06752096,-39.50694931,5.66
51384,157.42275189,84.25200905,5.52
116918,355.48620772,7.2505464,5.89
84177,258.11587226,10.58516767,5.32
18647,59.87554895,-12.57442477,5.61
84183,258.13574891,62.87433736,5.54
51420,157.52686747,38.92513177,5.79
116957,355.61592955,-15.44803278,5.27
116971,355.68060053,-14.54490474,4.49
51438,157.58386587,-71.99279296,4.72
84226,258.2439929,-32.43833214,5.95
51459,157.65658239,55.98053629,4.82
84248,258.32448896,-67.19659096,5.87
117020,355.8431642,10.33153622,5.09
18723,60.16939835,-30.49069722,5.93
51491,157.74932379,-13.58846957,5.59
51495,157.75858126,-73.22149033,4.94
51502,157.76943261,82.55858756,5.25
18735,60.20318917,18.19399995,5.89
18744,60.22419697,-62.15928428,4.48
51523,157.84092521,-53.71548368,4.89
117073,355.99785769,29.36145366,4.93
18772,60.32563108,-61.07882177,4.97
117088,356.0501899,-64.40445105,5.73
117089,356.05032979,-18.27693776,5.24
18788,60.38354244,-1.54965977,5.28
51556,157.96406552,32.37955435,5.9
51561,157.98931704,-45.0667103,5.76
18805,60.44223468,9.99801668,5.67
51585,158.04905741,14.13726962,5.43
117125,356.17019587,-78.79144185,5.74
51610,158.1400424,-44.61850771,5.91
51623,158.19920504,-58.66674498,5.98
51624,158.20279933,9.30658558,3.84
18859,60.65310384,-0.26892309,5.38
84401,258.83019728,-33.54842041,5.6
51635,158.23691737,-47.00335263,5.02
84402,258.83451723,-14.58413985,5.98
84405,258.83740933,-26.60282934,4.33
84425,258.89979588,-38.59389616,5.95
51658,158.30786815,40.4255599,4.72
84431,258.9227914,23.74276074,5.99
117218,356.50384755,-18.67834004,5.28
51685,158.37879635,34.98869458,5.57
117221,356.50852746,46.42027576,4.97
117245,356.59798525,3.48681088,4.95
51718,158.50368537,-23.74516468,5.08
18957,60.93585228,5.43562441,5.32
117265,356.65306792,66.78224457,5.95
84500,259.13214952,1.21054554,5.89
18975,60.98585128,8.19726936,5.45
84514,259.15285961,-0.44529728,4.72
18993,61.0411457,2.82694713,5.36
117299,356.757996,57.45135891,5.55
117301,356.76439475,58.65198943,4.88
51775,158.70006123,6.95374893,5.07
19009,61.09030616,24.10599281,5.46
117314,356.81630223,-11.91112638,5.74
19011,61.09464958,-12.79229521,5.62
117315,356.81664902,-50.22646074,5.18
84551,259.26519011,-32.66284013,5.53
19018,61.11317347,59.15550727,5.0
51802,158.75899566,8.65042553,5.67
19038,61.17381506,22.08192566,4.36
51808,158.77283604,75.71294767,4.86
84573,259.33153304,33.10010024,4.8
51814,158.79038688,57.08263671,5.16
51821,158.80354467,-39.5625887,5.5
117371,356.97820895,67.80680804,5.05
84606,259.41772717,37.29149825,4.64
117375,356.9855958,-2.76159766,5.49
19076,61.33440892,22.00890535,5.9
51849,158.89707431,-57.5576359,4.45
84626,259.50282784,-24.28690158,5.14
19095,61.40598316,-27.65180738,5.59
84631,259.52058199,17.31788648,6.0
84656,259.59696186,38.81139458,5.97
19129,61.51325851,68.67997255,5.88
84671,259.65412656,10.86447543,5.03
117447,357.20904741,62.21451644,5.43
51912,159.08549318,-59.56439245,5.08
84690,259.69928821,-44.12974648,5.76
84691,259.70219651,28.82296764,5.68
51933,159.13492888,-12.23012111,5.71
19171,61.651719,27.59990322,5.18
84709,259.73824381,-34.98979226,5.91
84720,259.76597408,-46.63623458,5.47
117491,357.36448143,1.0761315,5.77
84731,259.80212037,-59.69461184,5.93
117500,357.41414295,28.84238892,5.95
117503,357.42066759,36.42528092,5.86
19205,61.75189443,29.00129953,5.21
51979,159.30718553,-27.4126343,4.87
51986,159.32559015,-48.22562015,3.84
84769,259.90462538,80.13639937,5.74
52004,159.36278286,-58.73333948,5.47
117541,357.56137939,-9.97413654,5.93
52009,159.38863537,-13.3845429,4.89
117567,357.63869172,-14.40149013,5.7
52043,159.51102078,-57.25630921,5.89
19284,61.99756702,17.33989656,5.89
84821,260.04097946,25.53760288,5.36
84833,260.07862989,18.05708065,5.01
84835,260.08800741,46.24077993,5.51
52085,159.64563744,-16.87657185,4.91
117628,357.83853618,9.31335071,5.77
117629,357.83890925,-18.90916324,5.17
84862,260.1648632,32.46774334,5.38
52098,159.68005294,31.97623753,4.68
52102,159.68748435,-59.18299713,4.69
19335,62.15256811,38.03973329,5.52
84880,260.20692137,-12.84687539,4.32
84887,260.22585839,24.4994352,5.13
84893,260.2515588,-21.11293262,4.39
52127,159.74841063,-58.81685384,5.96
52136,159.77356447,53.66830017,5.55
52139,159.78180228,37.91000015,5.84
19376,62.25653961,13.39828055,5.94
117683,357.9909951,2.93038438,5.59
52154,159.82663768,-55.60326857,4.29
117689,358.02703204,-82.01881847,5.1
19388,62.29152955,19.60921676,5.51
19398,62.32431519,-16.38587484,5.45
84949,260.43173826,39.97464873,5.55
84950,260.43903528,53.42042844,5.69
117718,358.12203413,19.12028685,5.06
117722,358.12496038,-14.25121716,5.85
117730,358.15460249,10.94731984,5.3
84969,260.49782321,-67.77066851,4.76
84979,260.52448335,-70.12320813,5.39
117756,358.21053649,-8.99675595,5.76
19454,62.50682624,86.62613867,5.84
52221,160.04766406,-65.100209,5.51
117761,358.23152256,-3.15548162,5.93
19461,62.51143299,80.69868138,5.1
19483,62.59384111,-6.92385241,5.44
19511,62.69902023,-8.81981407,5.7
85048,260.72812115,-37.2207864,5.91
19513,62.70775376,26.48095174,5.39
85049,260.73009141,-58.01032712,5.86
19515,62.71078866,-41.99357326,4.93
19525,62.74592063,33.58679214,5.75
85068,260.77966858,-56.52554721,5.76
85079,260.81698005,-47.46819665,5.21
85084,260.83996314,-28.14283144,5.3
19554,62.83450749,5.5230472,5.71
117863,358.59596834,57.49938213,4.51
52338,160.45107735,68.44349962,5.74
19571,62.90084954,-20.35615701,5.8
52340,160.46466057,-79.78328811,5.97
117887,358.69426402,0.10930873,5.78
52353,160.48563182,65.71627973,5.12
52370,160.55883334,-64.46642641,4.76
85139,260.99006761,8.85257053,5.77
85147,261.00448781,-62.8641534,5.69
85157,261.02744668,22.96028529,5.7
85162,261.05452928,-44.16257561,5.1
85169,261.0783197,-60.67379907,5.76
52405,160.66902684,-59.21575905,5.36
52407,160.67994746,-32.71567343,5.63
85185,261.1314049,16.30100632,5.75
52422,160.75784148,26.3255774,5.51
52425,160.76683287,69.07621399,5.01
85207,261.1751282,-21.4414791,5.82
52452,160.83716589,4.7476695,5.77
52457,160.85398267,23.18840452,5.08
52468,160.88454015,-60.56661947,4.58
52469,160.88704747,46.20387703,5.18
52478,160.93056533,57.19920295,5.79
19719,63.38793263,7.71604492,5.29
52487,160.96330237,-64.24904192,5.74
52502,161.02881032,-63.96107161,4.8
19740,63.48493908,9.26382406,4.84
85290,261.42230897,60.04839798,5.65
85312,261.50018218,-50.63350974,5.19
19777,63.59870269,-10.25628292,4.87
118092,359.33287791,-62.95658371,5.95
19799,63.65097556,10.01140644,5.22
85340,261.59256716,-24.17530951,4.16
19805,63.70227288,-62.19181137,5.45
52577,161.26678874,67.41138405,5.95
19811,63.72215672,40.48367149,4.67
118114,359.38697921,-82.16980448,5.72
118121,359.39615753,-64.2982311,5.0
85355,261.62866808,4.14035962,4.34
52595,161.31797417,-80.46959695,5.46
85365,261.65783936,-5.08659579,4.53
118131,359.4396932,25.14140097,4.63
85379,261.68434357,48.26006484,5.83
85382,261.69227372,34.69580159,5.94
19849,63.81800057,-7.65287058,4.43
85385,261.70469724,20.080977,5.52
85389,261.71657533,-45.84302992,5.28
19860,63.88357189,8.89235703,4.27
52638,161.46622544,30.68231343,5.36
85409,261.80193124,-50.63037029,5.9
118209,359.66823972,-3.55598321,4.88
85442,261.90646538,-29.7245667,5.98
52678,161.56898752,-64.51455943,5.33
52686,161.60227135,18.89152299,5.5
52689,161.60532259,14.19464484,5.49
118234,359.73241378,-52.74580691,5.13
52701,161.623284,-64.2632416,5.23
85470,261.99000367,-52.29716773,5.72
118243,359.75224729,55.75492832,4.88
19949,64.17953476,53.6117991,5.2
19968,64.22314808,61.84998933,5.69
52736,161.71341275,-64.38347434,4.87
52737,161.71689616,-17.29687379,5.44
118277,359.86623505,-29.48516767,5.59
52742,161.73946741,-56.75719221,5.14
118281,359.87205182,33.72387779,5.81
19983,64.28374481,57.86035488,5.72
85520,262.16214482,-55.16968632,5.93
19990,64.31525283,20.57859097,4.93
19996,64.3300924,-6.47217752,5.95
85537,262.2068954,0.3306253,5.41
85543,262.23369642,-36.77828005,5.98
20020,64.41780159,-63.25540535,5.88
20049,64.49697361,-80.21403275,5.67
52827,162.02252944,-59.91916266,5.98
52841,162.05879911,-31.68785012,5.87
20075,64.56698763,-20.71525965,6.0
20087,64.59667564,21.57929684,5.64
52863,162.16898296,-1.95889567,5.92
85667,262.5991571,-1.06292171,5.31
52911,162.31429178,10.54520211,5.32
52922,162.35182191,-59.32379277,5.85
20156,64.80516403,50.04869508,5.46
20161,64.81956921,-44.26791929,5.33
85699,262.698285,86.96804735,5.78
20171,64.8587391,21.14230672,5.5
52948,162.43120269,-9.85269497,5.85
85715,262.73072367,31.15813862,5.63
20186,64.90294037,21.77349114,5.34
52965,162.48757429,-34.05818289,5.61
52980,162.57523422,-8.89776272,5.8
85749,262.83889138,2.72450684,5.57
85751,262.8470137,-56.92096415,5.99
20219,64.99043425,14.03520115,5.58
85755,262.85397499,-23.96264331,4.78
85760,262.86443667,-80.85913368,5.83
20234,65.0479698,50.92093298,5.55
20241,65.06012475,41.80806972,5.95
20250,65.0883987,27.35075361,4.97
20252,65.10265987,34.56672527,4.93
85790,262.95658059,28.40749878,5.66
20261,65.15129355,15.09545334,5.26
20264,65.16255613,-20.63962187,5.38
20266,65.16802237,65.14044145,5.26
53035,162.77253537,-3.09266719,5.95
20268,65.17185742,6.130798,5.76
20271,65.17847704,-7.59249348,5.85
85805,262.9911197,68.13502439,5.07
53043,162.79587316,56.58225004,5.66
85819,263.04404057,55.1842426,4.89
53064,162.84884839,59.32011925,5.57
20297,65.24194867,-81.57992035,5.78
20341,65.36266073,-0.09816957,5.86
85888,263.28024163,41.24344864,5.72
85889,263.28078726,-41.17306631,5.84
20354,65.38819502,46.4988779,4.8
20376,65.44854484,60.73562541,5.4
85912,263.3450992,19.25667721,5.65
20380,65.46585794,56.50631755,5.91
20384,65.47219466,-63.38639132,5.24
53154,163.12852238,-57.24040555,5.26
85922,263.37435359,-5.74480351,5.61
85930,263.41411877,16.31755321,5.68
20400,65.51465927,14.0771985,5.72
20417,65.59470757,20.82141589,5.91
20430,65.64559841,25.62931425,5.38
85998,263.65289466,9.58670003,5.8
20465,65.77363984,-24.89215684,5.81
86011,263.67705559,-32.5816618,5.69
86019,263.6931291,-11.24199905,5.54
20484,65.85442658,16.77725981,5.64
53252,163.37304867,-20.13873126,5.23
53257,163.37794438,69.85388101,5.91
20493,65.88486187,20.98204451,6.0
53261,163.393548,54.58512839,5.12
86036,263.74830845,61.87455394,5.23
53272,163.42532245,-70.72033664,5.99
53273,163.43213446,-2.12920503,5.45
20507,65.92021811,-3.74547033,5.17
20522,65.9659383,9.46096761,5.1
53295,163.49475762,43.189956,4.66
20542,66.02400423,17.44413026,4.8
53316,163.57407115,-13.75803566,5.65
86092,263.91495845,-46.5056839,4.56
53334,163.62334783,-61.82662225,5.95
20579,66.12147997,34.13075775,5.73
20591,66.1560941,33.95968652,5.77
53377,163.74241439,34.03479771,5.73
20614,66.23803343,19.04201331,5.97
20619,66.27223872,-61.23819356,5.94
53394,163.82175099,-60.51700334,5.93
86170,264.13680401,-38.63530828,4.26
20635,66.34235536,22.2938737,4.21
20641,66.35423116,22.19999802,5.27
86182,264.15689127,48.58563453,5.35
20648,66.37243249,17.92791025,4.3
53417,163.90332353,24.74971832,4.3
53423,163.9266547,0.7369224,5.91
53426,163.93493512,33.50692868,5.02
86201,264.23788371,68.75796966,4.77
53449,164.0061244,6.18537083,5.91
86219,264.2870155,72.45579421,5.87
20704,66.52629107,31.43891123,5.29
20711,66.57693136,22.81358255,4.28
86248,264.36380248,-50.05970227,5.89
20713,66.58642154,15.61826526,4.48
86254,264.37956096,24.30999148,5.76
86266,264.40085392,-15.57103812,5.94
20732,66.65155089,14.71378193,4.69
86284,264.46130363,-8.11877079,4.58
53530,164.28269699,-50.76501766,5.9
86305,264.52298502,-54.50043372,5.25
20776,66.7622583,80.82415938,5.42
86313,264.53960169,-10.92626776,5.74
20789,66.82269784,22.99633661,5.53
20804,66.86986896,11.2123,5.87
20825,66.94178419,-62.52120577,5.74
20842,67.00326498,21.61990692,5.72
20860,67.05530219,83.80779018,5.51
20873,67.09751196,14.74097429,5.9
20877,67.10987536,16.35967226,4.96
20884,67.13383172,1.38082076,5.53
20885,67.14373289,15.96218073,3.84
20892,67.16265745,-19.45887385,5.95
20901,67.20901684,13.0476024,5.02
20922,67.2788561,-13.04836956,5.61
53699,164.80725302,-33.73759504,5.7
86486,265.09927428,-49.41558665,4.76
53721,164.86655706,40.43025685,5.03
53723,164.87886586,-16.35370137,5.88
53726,164.8866143,36.09309993,5.99
20982,67.50151557,83.34037923,5.47
53762,164.99740918,-43.80711051,5.81
20995,67.53582507,15.6378405,5.58
53773,165.0385998,-42.22585865,4.37
53778,165.04872344,-14.08336831,5.86
53781,165.06126766,45.52627652,5.47
86552,265.31767035,-46.92182983,5.78
86561,265.34074301,51.81818181,6.0
21029,67.64013694,16.19401446,4.78
86565,265.35363893,-12.8753069,4.24
21036,67.65568103,13.72440227,5.4
21039,67.66204071,15.69187925,5.47
53807,165.14020255,3.61749404,4.84
86575,265.38467899,6.3131564,5.97
21042,67.66804354,-35.65350415,5.95
53824,165.1866767,6.10144936,4.98
53838,165.21008032,39.21209217,5.06
86614,265.48482361,72.14884347,4.57
86620,265.49210415,72.15691089,5.81
86623,265.49430835,15.95242979,5.54
86667,265.61817479,24.56405767,5.56
21139,67.96944698,-0.04401101,4.91
53907,165.45697703,-2.48458482,4.73
21148,68.00766596,53.91083011,5.78
86698,265.7129095,-36.94556454,5.53
53954,165.58239669,20.17984193,4.42
21192,68.15647223,-3.20954083,5.76
86731,265.83985043,24.32782154,5.73
86736,265.85747282,-21.68319399,4.86
86782,265.99656754,53.80171508,5.75
21247,68.3778275,72.52860478,5.94
21253,68.39145868,-62.82367752,5.79
86796,266.03626186,-51.83405301,5.12
54029,165.81199837,-11.30346957,5.51
21273,68.46215732,14.84442444,4.65
21278,68.47803408,-6.73890765,5.71
54049,165.90246771,-0.00083295,5.95
21295,68.53444548,5.56861606,5.67
21296,68.54845226,-8.23135239,5.2
21297,68.54904299,-8.97025763,5.24
86847,266.17504125,-42.72930245,5.87
21323,68.65829859,28.96115052,5.88
86871,266.23276494,-57.54553992,5.97
54137,166.13000481,-47.67910348,5.67
21402,68.913584,10.16078965,4.25
54173,166.22580794,-35.80467818,5.43
54182,166.25428061,7.33600733,4.62
54204,166.33294757,-27.29361236,4.92
21452,69.10082308,64.2616021,5.91
21476,69.1726226,41.26480803,4.25
21479,69.18996817,-62.07715439,5.59
54255,166.48987494,-27.28785339,5.69
87044,266.7835257,17.69701358,5.61
21515,69.30697237,0.99831413,5.32
87072,266.89010281,-27.83078848,4.53
87074,266.9032469,-14.72582391,5.93
21547,69.4005496,-2.47354823,5.22
54327,166.70787073,-70.87793034,5.58
54336,166.72586366,1.95552542,5.52
21588,69.53935407,16.03329069,5.78
21589,69.53942698,12.51083801,4.27
54360,166.81954551,-42.63868131,5.15
21594,69.54510028,-14.30401978,3.86
21604,69.56595752,20.68472222,5.85
87158,267.10320059,20.56544091,5.69
21644,69.72314537,-12.12312125,4.99
87194,267.20477802,25.62286856,5.09
21670,69.77565406,7.87097645,5.38
21673,69.7884039,15.79984564,5.08
87212,267.26785817,50.78107501,5.02
21683,69.81875764,15.91797673,4.67
87220,267.29365086,-31.70320353,4.79
21685,69.8321291,-14.35919211,5.46
54461,167.14166004,-61.94717476,5.11
87234,267.36263926,76.9628807,5.02
54477,167.18333063,-28.08067053,5.43
54487,167.20454419,24.65846458,5.7
21727,69.97783327,53.07953529,5.07
21730,69.99195325,53.47302066,5.36
21735,70.0142396,12.19760933,5.45
21743,70.02833922,-24.48236829,5.56
54522,167.32950037,36.30937897,5.71
87294,267.54630323,-40.09043487,4.78
21763,70.11046417,-19.67149284,4.32
54537,167.41041963,43.20773599,5.89
87308,267.59538584,29.32214306,5.51
87314,267.61830293,-53.61240615,5.68
54561,167.472473,-32.36752862,5.79
21819,70.33233566,28.61499392,5.73
21823,70.35053554,48.30088121,5.66
21847,70.45940195,38.28018222,5.97
87390,267.88555638,-40.77246136,5.94
87393,267.8977983,-60.16405623,5.78
21881,70.56125702,22.95692604,4.27
21914,70.69343174,-50.48133388,5.3
87460,268.05692273,-34.79919658,5.88
21928,70.72636135,43.36513795,5.3
87472,268.08234203,-34.41684225,5.84
21949,70.76651415,-70.93102736,5.53
87491,268.14768396,1.30501357,5.91
21958,70.78872184,-30.76555689,5.66
21972,70.83997399,49.97378898,5.86
54746,168.13773828,-49.10099614,5.37
21986,70.89477018,-8.79431701,5.98
54767,168.18836538,-64.16976981,5.22
87558,268.30910396,6.1014241,5.77
22024,71.02216938,-8.50357058,5.78
22028,71.03325764,-18.66658598,5.53
87563,268.32511583,40.00795947,5.17
87569,268.34780142,-34.89512471,5.58
22040,71.08813792,-59.73273311,5.28
54811,168.31118918,-44.37221614,5.77
22044,71.10761816,11.14613659,5.39
54829,168.37826033,-59.61931809,5.74
54840,168.41414038,-53.23181261,5.75
87616,268.47822244,-34.75272128,6.0
54849,168.43980008,-0.06950193,5.4
22086,71.26733841,-21.28338279,5.72
54863,168.50764182,8.0606955,5.79
22157,71.50725414,11.70559099,5.35
22176,71.57011995,18.73469274,5.99
54951,168.80095415,23.09550224,4.56
87728,268.79647083,72.00512678,5.43
87747,268.85495395,26.04999056,5.47
22220,71.68532772,40.31259017,5.99
87777,268.96171036,22.46422072,5.62
55016,168.96624936,13.30757811,5.31
22263,71.90121577,-16.93445603,5.49
87812,269.07667017,0.67035483,5.82
87813,269.07931436,-15.81252155,5.93
22287,72.00113806,56.75718336,5.29
87836,269.17433372,-28.06539356,5.76
87846,269.19759598,-44.34224611,4.85
87847,269.1989374,-4.08182342,5.44
55084,169.16542031,-3.65160104,4.45
55086,169.17437341,49.47625028,5.88
22325,72.13555403,-16.32948449,5.76
22336,72.15160693,-5.67404466,5.77
87875,269.26797863,0.06666488,5.95
22361,72.20980564,75.94121963,5.96
55137,169.32250147,2.01055585,5.18
22393,72.30352712,31.43737497,5.57
87936,269.44918828,-41.71629522,4.88
22407,72.32948838,32.58819079,5.84
22453,72.47765965,37.48827484,4.89
87998,269.6256225,30.18927677,4.41
88012,269.66270708,-28.75908869,5.99
22479,72.54840181,-16.21715883,5.03
55249,169.72899669,1.65039473,5.9
55266,169.78292083,38.18555675,4.76
88038,269.73203372,-36.85837571,5.74
55280,169.8184753,-64.58249071,5.99
88060,269.77200606,-30.25302496,5.0
22531,72.73045338,-53.46150774,5.58
22545,72.78885722,48.74068466,5.64
22565,72.84359342,18.83986122,5.08
88101,269.90318038,-4.82112631,5.86
22573,72.86756778,-34.90628652,5.82
88116,269.94813871,-23.81613352,4.74
88122,269.98419337,45.50137788,5.69
88128,270.01423371,16.75091902,4.67
88136,270.03843468,80.0040954,5.74
88149,270.06582758,4.36861526,4.79
22626,73.0217473,63.50542084,5.47
88175,270.12087728,-3.69026911,4.62
88192,270.16131566,2.93156761,3.93
22667,73.13317557,14.25064185,4.71
22678,73.15825132,36.70318691,4.79
22697,73.1963209,27.89748524,5.97
22699,73.1989863,42.58662618,5.68
22701,73.22362423,-5.45269507,4.36
22730,73.34488587,2.50822505,5.33
88267,270.3766986,21.59578242,4.26
88290,270.43832718,1.30507628,4.42
88298,270.47658613,-22.78029782,5.72
55560,170.70660064,43.48270299,4.99
88331,270.59603555,20.83363158,5.25
55581,170.78388176,-56.77935463,5.82
55588,170.80284646,-36.16476935,5.0
55597,170.83916782,-64.95471433,5.09
55598,170.84118303,-18.7799734,5.08
22833,73.69540365,11.42600649,5.18
22834,73.69908791,7.77909728,5.33
22840,73.7112843,0.46716657,5.98
88380,270.71290967,-24.28246777,5.37
22854,73.76302196,55.25910865,5.52
22860,73.77843208,-16.74066998,5.71
88404,270.77049855,-8.18034926,4.77
22871,73.79667354,-74.93685192,5.47
22881,73.82770524,-16.41776658,5.71
55650,171.00969638,1.40776545,5.39
55657,171.04636355,-72.25660787,5.55
22913,73.95897214,15.04027834,5.79
88469,270.96852033,-24.36073005,5.89
22936,74.02947644,52.86976107,5.75
55716,171.24552556,11.43029179,5.8
22958,74.10077468,-5.1713563,5.5
55756,171.372722,-36.06306236,5.21
55763,171.38790532,-37.74757549,5.87
55765,171.40155647,16.4565387,5.58
55779,171.42977593,-63.97247496,5.18
88550,271.20991532,-35.90144187,5.98
55797,171.48795635,55.85045922,5.73
88567,271.25510506,-29.5800874,4.66
23043,74.34308584,17.1536769,5.51
55831,171.64757397,-61.11516697,5.22
88601,271.36368986,2.50009948,4.03
23068,74.45269677,23.94856215,5.79
55849,171.69693753,-53.15991503,5.8
23088,74.53913863,25.05040555,5.79
88636,271.45671308,32.23067361,5.72
55874,171.7896524,-12.3567492,5.93
88657,271.50791797,22.21887928,4.96
88670,271.53083141,-8.32395567,5.84
23148,74.71235207,-82.47051254,5.84
88684,271.56332124,-4.75125187,5.74
88694,271.59883028,-36.01978856,5.94
23166,74.75568295,-16.37602687,5.65
55945,171.98433339,2.85626541,4.95
23179,74.81420672,37.89024467,4.93
88726,271.707884,-43.42521622,4.92
88745,271.75641339,30.56213958,5.05
23221,74.96021841,-10.26332504,5.39
88765,271.8265005,8.73386711,4.64
23231,74.98223836,-12.53741569,4.78
56000,172.14616551,-42.67420277,5.14
88771,271.83743427,9.56384719,3.71
88788,271.86974981,43.4618915,5.0
23261,75.07641266,39.39470095,5.95
23265,75.08633624,81.19408784,5.09
56034,172.26717462,39.33697448,5.3
56035,172.26901255,61.77836788,5.83
88816,271.95141919,-17.15415938,5.52
88817,271.95625976,26.09733957,5.79
88818,271.95650511,26.10128037,5.83
88836,272.00932674,36.40126403,5.49
88839,272.02074765,-28.45709305,4.55
56078,172.41089999,-24.46401116,5.77
56080,172.42435637,15.41326947,5.74
88886,272.18954555,20.81455696,4.37
56127,172.57872236,-3.00350053,4.77
23362,75.35658602,-20.05191838,4.91
23364,75.35976995,-7.17396548,4.8
88899,272.2202649,20.04523266,5.1
56146,172.62096155,18.40980153,5.54
56148,172.62971407,43.17324213,5.94
23408,75.45980428,0.72211174,5.91
88964,272.3912223,3.99327568,5.71
23430,75.54092425,-26.27502946,5.01
23446,75.59501962,-31.77133289,5.92
89000,272.47505626,3.11982653,5.67
89008,272.49581593,36.46628393,5.57
23474,75.68743051,-22.79505224,5.74
23475,75.68914486,-4.21012059,5.86
23482,75.70285908,-49.15140722,5.37
56250,172.95333258,-59.51564769,5.12
89020,272.52422487,-30.72866608,5.53
23497,75.7739472,21.58996241,4.62
89042,272.60901275,-62.00219747,5.47
56280,173.0683495,-29.26102254,4.93
89047,272.63183454,54.28655223,5.97
56287,173.08331792,-66.96182353,5.89
56290,173.08641605,61.08252044,5.46
89065,272.66791585,3.32425557,5.5
56318,173.19806955,-7.82752333,5.94
56319,173.20034039,-40.43619379,5.64
23554,75.97196597,-24.38815073,5.61
89099,272.77317266,-41.35911328,5.86
56332,173.22554373,-31.0872257,5.13
89115,272.81584098,-75.89150994,5.86
89153,272.93055404,-23.70123522,4.96
89156,272.93800435,33.44705699,5.98
56391,173.40499826,-40.5866374,5.39
89172,272.97565405,31.40534967,4.96
23649,76.24172658,-49.5778375,5.05
23668,76.317483,-26.15239077,5.71
56445,173.59145789,3.06016548,5.76
56452,173.62286277,-32.83133965,5.96
89234,273.14188349,-73.67241705,5.86
56473,173.67704789,16.79691495,5.95
56480,173.69023525,-54.26409123,4.62
56497,173.73687806,-49.13649014,5.5
23734,76.53521982,58.97237221,5.22
56510,173.7704493,54.78541888,5.63
56518,173.80534431,-47.37257977,5.64
89290,273.30290464,-41.33611092,5.47
23766,76.62377867,61.16975617,6.0
23783,76.66929484,51.59772034,4.98
56561,173.94535319,-63.01984158,3.11
23794,76.69021954,-4.65516319,5.12
56573,173.98160491,-47.64164272,5.26
89348,273.47430483,64.39728696,4.99
56583,174.01165125,69.32295251,5.19
23831,76.85401374,-12.4912695,5.97
56601,174.07480801,27.78135085,5.8
23835,76.8625253,18.64505209,4.91
89369,273.5662531,-21.71316395,5.49
56606,174.09318893,-61.05243308,5.84
23840,76.89178129,-63.39967892,5.19
56620,174.14560379,-33.57005728,5.71
23871,76.95165826,20.4183787,5.28
23879,76.97039079,8.49842889,5.33
56647,174.2372109,-0.82374868,4.3
23883,76.98098305,21.70482079,5.84
56656,174.25218591,-61.28344222,5.14
23900,77.02759748,24.26517479,5.5
89439,273.80378041,-20.72826976,5.29
89440,273.80404553,-20.38797398,5.96
56675,174.31514768,-75.89654386,5.64
89448,273.82115232,68.75580995,5.96
23916,77.08412539,-8.6653244,5.8
56700,174.39162786,-47.74730936,5.46
23941,77.18208035,-4.45620729,5.11
89482,273.9115711,42.15934543,5.56
89487,273.91923801,-63.05536625,5.58
56727,174.45157639,-67.62037903,5.94
89507,273.97270789,-44.20646066,5.45
23972,77.28659571,-8.75408096,4.25
23983,77.33184125,9.82957855,5.43
56754,174.53039693,-61.82656332,5.15
56770,174.58570798,43.62542859,5.56
24010,77.42481287,15.59723234,4.81
56779,174.61503182,8.13429851,5.24
24019,77.43788444,28.03046113,5.93
56802,174.66673637,-13.20194292,5.48
89587,274.22125595,-3.00740078,5.99
89605,274.28138278,-56.0233515,5.36
89609,274.29845051,-17.37388635,5.81
56862,174.87330432,-65.39776594,5.01
24109,77.67883284,46.96206999,5.67
89678,274.51329535,-27.04264123,4.66
56922,175.05328812,-34.74465977,4.7
24162,77.82990325,-2.49078242,5.89
24169,77.84529701,-11.84908878,5.6
24197,77.92318143,16.04567302,5.18
56970,175.17700623,-53.96860677,5.95
24203,77.93896231,1.03702762,5.88
56975,175.19611376,21.35272958,5.26
56986,175.22347484,-62.09010138,4.93
56997,175.26256384,34.20163549,5.31
89772,274.78973574,7.25976665,5.41
89773,274.79449984,24.44605934,5.3
24244,78.07459272,-11.86921875,4.45
57013,175.3324588,-43.09566688,5.54
24254,78.09357738,73.94667428,5.44
57029,175.39274676,31.74605794,5.73
57047,175.43311897,-32.4994036,5.2
89826,274.9654565,36.06454739,4.33
24294,78.20053766,-6.05719037,5.9
89851,275.03663632,-15.83169702,5.39
89861,275.07464419,21.96129679,4.92
24331,78.32283913,2.86126547,4.46
24340,78.35715692,38.48449794,4.82
57111,175.61817278,66.74490614,5.32
24372,78.43939254,-67.18525507,4.81
89918,275.21692964,3.37716521,4.85
89925,275.23737456,29.85892536,5.61
57165,175.86328021,-37.19015528,5.98
89935,275.25425094,28.8699538,5.12
57175,175.87996844,-62.48939579,5.0
24426,78.62019205,-35.97699618,5.75
89968,275.34577818,-18.8599994,5.76
24450,78.68353428,5.15615058,5.5
89981,275.38609675,49.12159355,5.02
90023,275.53625244,23.2851765,5.41
90037,275.57738554,-38.65689372,5.09
24504,78.85163722,32.68760021,5.01
24505,78.85155213,-26.94350871,5.06
90052,275.64716049,12.02967984,5.99
90067,275.7043339,17.82661627,5.25
90074,275.72115312,-36.66955566,5.33
24555,79.01722563,11.34135364,5.52
57328,176.32099986,8.25811933,4.84
90096,275.80067769,-12.01475532,5.71
24575,79.07562348,34.31231693,5.99
90124,275.87011093,-36.23798706,5.52
90133,275.9018684,-75.04427681,5.47
90135,275.91493522,-8.93438329,4.66
57371,176.43320334,-45.69013378,5.28
90139,275.92453998,21.76975206,3.85
90156,275.97752727,58.80073609,4.98
90191,276.0574402,39.50723875,5.11
24659,79.37120834,-34.89520756,4.81
90200,276.07600721,-44.11025611,5.24
57439,176.62842737,-61.17839852,4.11
24674,79.40162477,-6.84440942,3.59
57443,176.62946664,-40.50035391,4.89
24679,79.41767376,-13.51982564,5.48
57477,176.73176038,55.62819013,5.27
90260,276.25594139,-30.75657007,5.58
24727,79.5440374,33.37161284,4.54
24732,79.55515259,73.2680713,5.81
24738,79.56540451,42.79211104,5.55
57512,176.82975502,-57.69649852,5.42
90289,276.33766953,-20.54167899,4.81
90313,276.41166181,8.03200644,5.64
24786,79.71030085,-18.13005042,5.96
57562,176.97875158,8.24589485,5.31
57565,176.99639971,20.21893139,4.5
24799,79.75012031,33.74839374,5.38
90342,276.49494677,29.82893016,5.81
90344,276.49640884,65.56348048,4.82
24813,79.78531028,40.0990515,4.69
57581,177.06056259,-66.81491035,4.75
24817,79.79674571,2.59580646,5.34
24822,79.81917563,22.09649397,4.96
24829,79.8422288,-50.6059674,5.44
24831,79.84868696,-27.36888386,5.98
57606,177.1612854,14.28420986,5.9
57613,177.18784426,-26.74977722,5.1
24873,79.99593136,-12.31558519,5.29
24879,80.00383775,33.95805371,5.05
90414,276.72505131,-48.11724265,5.44
57669,177.42110152,-63.78847827,4.3
24902,80.06112383,41.08621224,5.46
57670,177.42381241,34.93175799,5.73
90441,276.80211842,0.19610846,5.2
24914,80.09421143,62.65371097,5.64
24927,80.11216036,-21.23976341,4.7
57696,177.48589142,-70.22579056,4.98
90485,276.95618242,-29.81686531,5.9
90497,276.9948876,6.19410386,5.71
57741,177.61365513,-62.64938114,5.68
25001,80.30286394,29.56988416,5.66
90541,277.11297411,-38.99567078,5.63
57791,177.75929723,-5.33333191,5.62
25028,80.38268143,-0.4164911,5.68
57803,177.78621542,-45.17347045,4.47
25041,80.43150113,8.4285562,5.78
25044,80.44061639,-0.38246516,4.72
25045,80.44272695,-24.77298153,5.06
25048,80.45173208,41.80457259,5.22
90606,277.33308605,-80.23270815,5.95
57841,177.92337377,-30.83480862,5.85
57851,177.96343775,-65.20591037,4.89
90637,277.39879341,23.86620171,5.87
57870,178.04283106,-56.98774142,5.56
90642,277.42074924,-1.98530781,5.38
25110,80.63971624,79.23114864,5.08
90647,277.43736664,77.54706794,5.65
90662,277.48309536,-47.22054578,5.69
90664,277.48640952,-57.52314333,5.74
25142,80.70833393,3.54445246,4.99
25143,80.70964521,41.02926041,5.54
90687,277.54943281,-18.72879424,5.63
25187,80.82712628,-8.41559518,5.99
25194,80.85010321,-39.67842334,5.73
25197,80.86601143,57.54439534,5.24
25202,80.87565198,-13.92735207,5.25
25223,80.92628878,-0.15981802,5.69
90762,277.76853518,16.92855586,5.76
90763,277.7701841,-32.98911449,5.37
25247,80.98678426,-7.80806458,4.13
90797,277.84343892,-62.27830197,4.63
90804,277.85705763,-10.79583621,5.77
90806,277.85956845,-18.4026975,5.12
25278,81.10609747,17.38353401,5.0
25280,81.11870729,-16.97578068,5.64
25282,81.1204506,-0.89132828,5.07
25291,81.16049729,31.14314791,5.94
25292,81.16309118,37.38534566,5.02
90830,277.93930374,-45.9148136,4.92
25302,81.18677733,1.84644465,4.89
90842,277.98426257,-43.50738268,5.71
90844,277.98747679,-1.00297739,5.93
58082,178.67724782,-25.71388748,5.26
90853,278.00810572,-45.75738197,5.07
25329,81.25726707,-10.32888694,5.6
58103,178.75004723,-63.27918021,5.89
58110,178.76305651,8.44394309,5.58
90887,278.08887918,-39.70400085,5.16
90905,278.1438443,57.04559904,4.77
90913,278.18050965,-14.86566249,5.47
90915,278.19231394,23.61680115,5.88
90923,278.20815801,30.55420884,5.47
58158,178.91721519,-28.47710282,5.93
58159,178.91889025,15.64681778,5.53
90930,278.23060016,-73.96559585,5.88
25397,81.49927144,-19.69539929,5.78
58181,178.99339944,56.59855974,5.83
25429,81.58028197,-58.9125204,5.14
90968,278.34638679,-38.72598555,5.67
90991,278.41258553,-14.85361449,5.74
91004,278.47285769,-24.0322826,5.49
25471,81.70334644,34.39180992,5.92
25473,81.70928488,3.09567448,4.59
91013,278.48623142,52.35351687,5.38
91014,278.49069341,-33.01655982,5.28
25488,81.77216893,-40.94350961,5.86
25492,81.78447075,30.20860309,5.69
25499,81.79205662,17.96221647,5.4
25539,81.90868809,21.93696527,4.88
25541,81.91202636,34.4758921,5.08
25555,81.94003547,15.87405219,5.52
58326,179.41669934,-62.44874839,5.59
91105,278.7599696,-10.97720631,5.12
25583,82.00671105,17.23912965,5.77
91118,278.80251074,18.20341015,5.79
91139,278.87665389,23.60553047,5.62
25608,82.0638984,-37.23076663,5.56
58379,179.56343546,-56.31731019,5.44
58427,179.69858625,-64.33956043,5.59
91217,279.11596832,9.12249123,5.38
58460,179.82307348,33.16700381,5.95
25695,82.31875058,25.15021515,5.47
91235,279.15559814,33.46903643,5.41
91237,279.16281139,6.67180528,5.43
25708,82.3486886,-3.44639371,5.8
25737,82.43325693,-1.09223896,4.71
58510,179.98713487,3.65519684,5.36
25751,82.47822515,1.78926021,5.77
25768,82.53949875,-47.07765472,5.46
25769,82.54250849,63.06722047,5.43
91315,279.38958583,62.52659062,5.74
91322,279.39983893,-0.30947231,5.76
25790,82.60902153,15.36044913,5.93
58576,180.18521444,-10.44601399,5.54
91347,279.4767753,-21.39772463,5.93
25813,82.69604907,5.94813905,4.2
25816,82.70271318,41.46199446,5.99
58587,180.21316494,-19.65898222,5.28
58590,180.21829228,6.61432243,4.65
25853,82.78177839,-20.86365911,5.53
25861,82.81055254,3.29213294,5.46
91405,279.62797972,-23.50489324,5.78
25887,82.90001691,-45.92531691,5.86
58654,180.41447124,36.04208556,5.59
91438,279.72250204,-21.05187112,5.85
58684,180.52828039,43.04560048,5.22
25918,82.97089829,-76.340964,5.18
25923,82.98274987,-7.30153704,4.62
91461,279.80955817,-47.90976745,5.84
25945,83.05312933,18.59423429,4.32
25950,83.05892516,17.05812808,5.5
58720,180.65705242,-69.19228781,5.89
91494,279.89649849,-43.18587823,5.42
25980,83.17230526,-1.59183113,5.34
25984,83.18197064,32.19202168,4.71
91525,279.97006026,52.19607551,6.0
58758,180.75625427,-63.31293012,4.32
25993,83.21422692,-38.51337151,5.45
91532,280.00161599,-7.79079854,5.82
26001,83.24820465,-64.22751731,5.34
26019,83.28078228,-35.1393761,5.75
58803,180.91487728,-42.43405656,5.15
26063,83.38102748,-1.15607281,5.36
26064,83.38179108,18.54023094,5.67
58858,181.06915879,21.45915255,5.89
26093,83.47618338,14.30557814,5.6
58867,181.08006469,-63.16571096,4.72
26108,83.51686455,-1.47025335,5.92
58884,181.16202138,-68.32891229,5.34
26126,83.56988721,3.7668951,5.32
58905,181.19362424,-76.5190609,5.04
58921,181.23840012,-60.96825207,5.95
26169,83.68659394,-73.74127669,5.79
26176,83.70515458,9.48957923,4.39
58952,181.31299084,76.90573364,5.78
26197,83.75419528,-6.00926993,5.67
26199,83.76117307,-6.00202702,4.78
26215,83.80516521,10.2400929,5.6
26219,83.81447813,-33.07972433,5.76
26220,83.81592671,-5.38731504,4.98
26221,83.81860638,-5.38969592,5.13
91755,280.65813956,55.53945722,5.03
26235,83.84542001,-5.41605966,4.98
26237,83.8465174,-4.83835783,4.58
26241,83.8582603,-5.90990135,2.75
26248,83.86304209,24.03958878,5.37
26268,83.91451758,-4.85606663,5.24
59050,181.59587791,-65.70945316,5.95
59072,181.7204145,-64.6137301,4.14
91845,280.8802198,-8.27521484,4.88
91854,280.9055771,-64.55142496,5.76
91875,280.94559142,-38.32344141,5.11
26344,84.14674026,54.42865852,5.74
26345,84.14872314,-6.06475163,5.71
91883,280.964965,31.92661292,5.68
26366,84.22661625,9.29067267,4.09
26382,84.26556585,17.04032437,5.53
59151,181.95781238,-75.36701895,5.17
91918,281.08066825,-35.64198667,4.86
26386,84.26826049,11.03500456,5.97
91926,281.09491775,39.61272155,4.59
26394,84.29121542,-80.46912192,5.65
26396,84.28685582,26.9244731,5.83
59173,182.02177064,-50.66127833,4.46
59184,182.06130175,-48.6924874,5.34
91973,281.20084994,37.59461485,5.73
91974,281.20667656,-25.01091405,5.82
91975,281.20807543,2.06003827,5.02
91989,281.23815163,-39.68618821,5.4
26460,84.43590756,-28.68969042,5.28
59229,182.22416765,-44.32598898,5.75
59232,182.22745306,-41.23160462,5.51
26487,84.50466286,7.54141958,5.87
92024,281.36208778,-64.87125918,4.78
92027,281.36818747,5.50012777,5.82
92043,281.41552259,20.54630774,4.19
59285,182.42212449,1.89788932,5.95
92056,281.4448648,74.08555278,5.25
26535,84.65822074,-6.5739587,5.96
26536,84.65868856,30.49241235,5.4
59309,182.51424147,5.80700798,5.72
26545,84.68135383,-40.70730651,5.81
26549,84.68653333,-2.60006888,3.77
92088,281.51866788,26.66212983,4.83
26563,84.72117914,-7.21282887,4.77
92111,281.58586941,-22.3921761,5.37
92112,281.5926483,75.43396413,5.37
92117,281.61914325,-0.96169252,5.89
26594,84.79644308,4.12146684,4.5
92133,281.67953324,52.98796032,5.91
92136,281.68051807,-10.12504804,5.69
26606,84.82630008,29.21521266,5.98
59384,182.74993897,81.70983258,6.0
26624,84.87979574,-3.56470434,5.99
59394,182.76599762,-23.60242256,5.45
92161,281.7553074,18.18151894,4.34
26640,84.93416238,25.89709109,5.18
26649,84.95766851,-32.62921597,5.44
92202,281.87062597,-5.70514696,5.38
92226,281.9359101,-40.40616681,5.2
59468,182.96323476,25.87028036,5.66
59501,183.03870978,20.54206383,5.6
26736,85.21131127,-1.12878734,4.95
59504,183.04975767,77.61624147,5.14
59517,183.09158267,-62.95077315,5.91
92294,282.15793838,-65.07767952,5.71
26762,85.27331504,0.33775349,5.93
92308,282.21037591,-43.68004746,5.46
92312,282.2224426,19.32872041,5.89
26777,85.323828,16.53414784,4.84
92367,282.36393445,-45.81010018,5.8
59607,183.35431963,-38.9291878,5.77
59608,183.35807694,10.26234107,5.85
92382,282.39581578,-43.43410181,5.6
92390,282.41710936,-20.32465604,5.22
92391,282.42064683,-5.91286256,5.99
92398,282.44130836,32.81282037,5.93
26865,85.55815948,-22.37371529,5.88
26868,85.56331056,-34.66781208,5.29
92405,282.47048652,32.55105772,5.22
26882,85.61019972,65.69764919,5.62
26885,85.61930036,1.47462889,4.9
59654,183.51123953,-45.72391939,5.31
26926,85.72464575,-6.79616764,5.97
92488,282.74378665,-9.77409554,5.82
59728,183.74826317,-20.8442198,5.82
26966,85.84029272,-18.55747532,5.73
92512,282.80039775,59.38835076,4.63
59746,183.78538163,70.20000795,5.72
92549,282.89557639,52.97511698,5.51
59819,184.00077619,14.89907059,5.09
59831,184.03145627,40.66018059,5.69
92614,283.0684505,21.42514188,5.43
59847,184.08557527,23.94540896,4.93
59856,184.12556927,33.0615267,4.99
92630,283.11346085,-46.59511911,5.51
92646,283.16517776,-52.10737024,5.18
59920,184.37333228,53.19133076,5.8
92689,283.30643961,50.70822149,4.92
59923,184.37739686,28.93718877,5.71
92728,283.43149845,36.97172123,5.58
27196,86.47516119,49.82625534,5.46
27204,86.49956252,-32.30643495,5.18
92747,283.5003819,-21.35984509,5.68
92761,283.54240472,-22.74483405,4.86
92768,283.55519662,27.90952818,5.64
60009,184.60936896,-64.00307078,4.06
27243,86.61405275,-46.59718043,5.31
92782,283.59939447,71.29719191,4.82
27249,86.62662742,56.11557506,5.93
27253,86.64546663,1.16819333,5.95
60030,184.66798999,-0.7871841,5.9
27265,86.68956956,15.82249706,6.0
60044,184.70826319,75.16056077,5.47
92814,283.67964103,-15.60303588,5.08
27280,86.71722823,9.52234276,5.78
92818,283.68702168,22.64507607,4.57
92822,283.69635593,48.85940109,5.84
92824,283.69640025,-87.60584353,5.29
60059,184.74898597,-55.14300207,5.01
92831,283.71740476,41.60272255,5.46
92833,283.71882028,33.96857615,5.99
92845,283.77975746,-22.67132807,5.0
27316,86.80479943,14.48832171,5.72
92862,283.83375551,43.9460885,4.08
92872,283.86435786,6.61528985,5.58
27338,86.85915063,17.72914106,5.47
92882,283.87919129,-16.37663466,5.56
60122,184.95295953,48.9841485,5.28
27364,86.92877898,13.8995995,5.28
27386,87.00097591,6.45415624,5.26
60157,185.04486704,-22.17570028,5.94
92931,284.00279892,-23.1737512,5.91
92937,284.02550531,18.10540994,5.69
60170,185.08198562,26.61948257,5.52
60172,185.08742032,3.31257412,4.97
92951,284.06101471,4.20213248,4.98
92953,284.07062977,-42.71067569,5.35
60189,185.14017317,-22.21590122,5.2
92969,284.10716122,65.25808363,5.62
60202,185.17927482,17.79286817,4.72
27435,87.14558649,-4.09464788,5.97
60212,185.21201069,57.8641181,5.54
60221,185.23213642,-13.56572406,5.14
92989,284.16873801,-37.34324095,5.36
92997,284.18771059,57.81485096,5.67
27468,87.25403003,24.5675349,4.88
93017,284.25671025,32.90127358,5.2
27483,87.29349215,39.18107112,4.51
93026,284.26529065,-5.84631367,4.83
60260,185.34003859,-60.4011467,3.59
27511,87.38721058,12.65132367,4.89
93051,284.31912766,2.53534635,5.56
27517,87.40225923,-14.48366552,5.49
93057,284.33531954,-20.65634594,5.02
27533,87.47291594,-22.97187168,5.87
27534,87.47300266,-66.90118696,5.1
60308,185.4892802,-56.37438547,5.91
27549,87.51118949,9.87121816,5.79
60320,185.53057887,-67.52210533,5.15
27560,87.55443716,4.42340597,5.96
60329,185.55012704,-68.30731574,5.73
27566,87.56993792,-79.36136262,5.46
93104,284.50790813,38.26618795,5.89
27581,87.62044257,14.30560796,5.54
60351,185.62630079,25.84616027,4.78
27588,87.62510707,2.02469995,5.97
93124,284.56144737,17.36091207,5.33
60379,185.70596323,-57.67613186,5.38
93148,284.61569332,-52.93862889,4.85
27621,87.72175357,-52.10887273,5.16
93163,284.65186652,-60.20054967,5.14
27629,87.74212407,27.96786145,5.6
93174,284.68073845,-37.107357,4.83
27639,87.76015574,37.30557296,4.72
93179,284.69551707,13.90664775,5.91
60425,185.83994174,-24.84066877,5.66
27658,87.8415992,-7.51800295,5.36
93203,284.77391889,13.6222449,5.27
27673,87.87249592,39.14848031,3.97
60449,185.89758302,-35.41267743,5.32
93225,284.84917453,-12.84051696,5.51
60463,185.93643251,-38.91138084,5.79
27713,88.03220371,-9.0419,5.95
60485,186.00622766,51.56225676,4.76
93256,284.93951837,26.2304045,5.26
27737,88.08417251,-57.15619119,5.93
27743,88.09288195,14.17178682,5.6
93279,285.00344017,32.14551421,4.94
60514,186.07717582,26.09860576,5.17
27747,88.09752371,19.86784871,5.96
27750,88.11016089,1.85513381,4.76
93287,285.01485245,-66.65361762,5.98
93299,285.05698909,50.5334665,5.39
27766,88.13827153,-37.63106312,5.62
93340,285.18106248,55.65830155,5.51
27810,88.27867158,-33.80136075,4.88
60584,186.2633683,56.77782798,5.82
60595,186.29902391,-11.61059019,5.95
27830,88.33185862,27.61226208,4.56
60610,186.34056213,-35.18641672,5.71
93393,285.32231951,26.29141121,5.69
93408,285.35988044,46.93481248,5.0
60646,186.46224376,39.01861603,5.01
60697,186.60026679,27.26823745,4.92
27938,88.68179395,-11.77419216,5.62
27939,88.68348643,0.96861501,5.99
60710,186.63232972,-51.45063539,4.82
27947,88.70871631,-52.63548078,5.29
27949,88.71159201,55.70694671,4.96
27955,88.71868455,-39.95785707,5.55
93498,285.61531735,-24.84682615,5.63
27965,88.73619497,19.74961403,5.92
60735,186.71537614,-32.83012078,5.56
27971,88.74094771,59.88836722,5.2
27973,88.7457895,31.70149565,5.9
60746,186.7470688,26.82569917,4.98
93526,285.7270772,-3.69898666,5.4
93537,285.7658545,-19.24568605,5.96
93542,285.7786518,-42.09510461,4.74
28010,88.87465485,-37.12066784,4.97
28011,88.87571393,-4.61654589,5.87
60781,186.87024708,-58.99175634,5.38
93552,285.82373455,-38.253147,5.73
60795,186.89626721,55.71272447,5.68
93574,285.87353914,-68.75554374,5.89
93580,285.88438672,1.81876786,5.82
28085,89.05946171,-22.83997545,5.95
60855,187.09360135,-39.04117207,5.45
93624,285.98982982,-51.01860365,5.93
28098,89.08726573,-31.38244043,5.52
28110,89.11681575,9.50939554,5.97
93667,286.10440461,-31.04707914,5.49
60904,187.22793616,25.91285158,5.29
28139,89.20604403,11.52105788,5.89
60941,187.36267581,24.10892524,5.47
93713,286.22985643,53.39665426,5.4
93717,286.24029862,-4.03142002,5.4
93718,286.24114646,31.74407174,5.63
60957,187.43016297,20.89610891,5.68
60969,187.47583446,-56.52494028,5.78
60978,187.48885262,58.40574231,5.37
60979,187.49119643,-41.73590066,6.0
93763,286.42158277,-15.66041861,5.93
60998,187.52773994,69.20112359,5.01
28237,89.49856601,25.95391186,4.81
61015,187.57269048,-23.69641863,5.63
28271,89.60184444,1.83710839,5.89
93815,286.58314114,-52.34091012,5.17
28287,89.65644542,-44.03456251,5.81
28296,89.70654952,0.55297945,5.21
28302,89.72181858,12.80826431,5.7
61071,187.75233513,24.56716768,5.47
93843,286.65722711,28.62859481,5.53
93845,286.65999241,24.25079305,5.78
93855,286.71715464,-16.22927621,6.0
28325,89.76796934,-9.55825019,5.04
93862,286.73169353,-48.29914452,5.95
93867,286.74417987,11.07122852,5.07
28343,89.84074839,49.92453993,5.9
93903,286.82553765,36.10015714,5.25
61136,187.91804071,-59.42392246,5.49
93917,286.85658637,32.50173824,5.2
61158,187.98381286,-63.50583787,5.96
28404,89.98374741,45.93673567,4.3
61174,188.01761238,-16.19600753,4.3
28413,90.0139559,-3.07425354,4.53
61181,188.04156822,-73.00105593,5.88
61212,188.14999363,-13.85910505,5.74
93996,287.06959389,-19.29028892,5.56
94013,287.10745233,52.42573068,5.88
28484,90.20487606,-51.21631955,5.65
28499,90.24400567,47.90192321,5.71
28524,90.31790806,-33.91183545,5.54
61296,188.39274515,-12.8302028,5.58
94068,287.24963402,6.07320675,5.23
61309,188.41216417,33.24758364,5.42
94083,287.29115861,76.56050217,5.11
61318,188.44478604,-9.45207741,5.48
28562,90.42941253,48.95944511,5.98
28574,90.46009056,-10.59793045,4.92
61379,188.67664301,-44.6730178,5.76
94150,287.47028378,-68.42444775,5.31
61384,188.68338897,70.02176987,4.95
94157,287.49022434,-41.89225602,5.86
61394,188.71283963,22.62925895,4.8
61418,188.78233209,18.37705781,5.03
61420,188.78403184,21.8813839,5.86
28675,90.81501733,-26.28454444,5.03
28691,90.86402644,19.69056101,5.14
61468,188.9397151,-41.02194474,5.12
61498,189.00429823,-39.86950517,5.78
28744,91.05625597,-6.7089414,5.19
28756,91.08444067,-32.17243044,5.65
94302,287.91905142,56.85921261,5.13
94311,287.94170374,31.28345592,5.93
28790,91.16708728,-45.07893163,5.93
61558,189.19731092,-5.8318984,5.88
94336,288.02095855,49.85575554,5.85
61571,189.24305134,17.08953595,5.7
28812,91.24242852,5.41996961,5.67
28814,91.24316696,4.15867108,5.63
28816,91.24637164,-16.48443483,4.92
28823,91.26410243,42.98163501,5.9
94385,288.16962975,-7.93951793,5.35
61621,189.42616117,-27.13888769,5.41
28854,91.36263451,-10.24259585,5.88
28855,91.36324523,-35.5136474,5.8
61622,189.42568082,-48.54130384,3.85
61658,189.59335693,1.8546621,5.68
94434,288.3069513,-25.90678623,5.79
28899,91.52307925,-29.7586236,5.79
94437,288.31468051,-12.28258372,5.51
28909,91.53909025,-66.03962084,5.72
61688,189.68588064,-18.25010005,6.0
94477,288.4279287,2.29370743,5.14
28943,91.63373588,-23.11084588,5.46
94481,288.43953147,39.1459682,4.43
28946,91.64624042,38.48264424,5.35
28949,91.66140133,-4.1938361,5.37
61720,189.76441026,-30.4223871,5.86
94490,288.47977509,57.70510165,5.0
61724,189.78045524,21.06255941,5.49
61740,189.81152882,-7.99556433,4.66
28984,91.73963818,-21.81229937,5.74
28991,91.76412331,-62.15458059,5.04
28992,91.7652938,-34.31202064,5.82
94556,288.66483987,-45.19352706,5.91
29034,91.88180321,-37.25292041,5.0
29048,91.92349197,-19.16586629,5.28
29064,91.97024538,-42.15404352,5.5
94620,288.82234138,21.23211845,5.65
94624,288.83370972,15.08365149,5.58
94630,288.85358237,30.52638144,5.88
94643,288.88511604,-25.25668251,4.86
94648,288.88773438,73.35546795,4.45
29134,92.18442446,-68.84340934,5.06
61910,190.3164699,-13.01390113,5.17
61916,190.34577184,-46.14558151,5.84
29150,92.24110369,-22.42741193,5.49
29151,92.24126418,2.49969231,5.7
94703,289.05433347,21.3904279,4.76
94712,289.09059277,-45.46603326,5.38
94713,289.09206275,38.13373077,4.35
94720,289.11161726,14.54461562,5.65
94727,289.12929845,4.83479546,5.59
61960,190.47106888,10.23562538,4.88
29196,92.3851548,22.19026207,5.93
61966,190.48570106,-59.68581953,4.91
61968,190.48798996,6.80661706,5.57
29205,92.3938511,-14.58461863,5.56
29225,92.43326963,23.11346618,5.75
29234,92.44984116,-22.77434294,5.71
62012,190.64771642,-48.81310872,4.66
29246,92.49589396,58.93569426,5.35
94789,289.30097111,-66.66104808,5.52
62027,190.70944006,-63.05862443,5.27
29263,92.54334962,-40.35379216,5.54
29276,92.5746206,-54.9686447,4.72
94820,289.40866411,-18.95290801,4.88
62058,190.78824797,-56.17622414,5.99
94827,289.43181759,23.02554007,5.46
29294,92.64450198,-27.15434319,5.72
94834,289.45416076,11.59542193,5.28
62103,190.9085423,-1.57699586,5.91
94885,289.63539751,1.08512891,5.1
29353,92.81242757,-65.58941744,5.01
62131,191.00221141,-28.32395681,5.46
29379,92.88460768,24.42025265,5.83
29388,92.90246332,48.71098893,5.78
29417,92.96589212,-6.55028721,5.06
29433,93.00558404,19.79054282,5.76
29434,93.01366463,16.13040608,4.95
62207,191.24752141,39.27891628,5.95
94982,289.91395036,12.37467975,5.53
29451,93.08384984,32.69337964,5.78
94986,289.91664181,-35.42145195,5.59
62223,191.28261241,45.44025619,5.42
29490,93.21276259,65.71842205,5.36
62267,191.40440814,7.67332578,5.22
62268,191.40854807,-60.98131821,4.69
95038,290.06681226,57.64512944,5.91
95066,290.13710279,-5.41576593,4.98
95073,290.14869363,-0.89216101,5.46
95077,290.15895532,-22.40253523,5.59
95081,290.16704983,65.71453144,4.6
62325,191.59393546,9.53968362,5.65
62327,191.59464379,-56.4888152,4.62
29575,93.4759737,-3.74137366,5.83
62356,191.66150388,16.57769139,5.12
62360,191.69261956,-33.3154827,5.87
29616,93.61909677,17.90635258,5.86
29629,93.65292854,-4.56845744,5.83
62402,191.82896234,62.78115465,5.88
95176,290.43176295,-15.95501757,4.52
29650,93.71198632,19.15644813,5.2
95188,290.46206487,-18.30838831,5.84
62423,191.89309904,66.79030428,5.43
29678,93.78529977,13.8510985,5.91
29679,93.78501077,-20.27218585,5.88
95222,290.58977124,-0.2523446,5.81
29692,93.82384512,-18.47716263,5.99
29696,93.84453777,29.49807609,4.32
29704,93.85469975,16.14317514,5.34
95241,290.65955207,-44.45896465,3.96
29711,93.87363793,-4.91471938,5.99
29716,93.8927712,-0.51218939,5.62
95260,290.71201613,26.26240313,5.22
95261,290.71335928,-54.42393063,5.03
29730,93.91892108,59.99897555,5.37
62500,192.10940847,-27.5973841,5.65
29735,93.93702565,-13.71841389,5.0
29736,93.93735132,12.55106693,5.44
62512,192.16443179,60.31982229,5.83
95294,290.80473701,-44.79977847,4.27
29771,94.0320452,-16.61800646,5.97
62541,192.22588987,14.1225838,5.71
62561,192.27782925,83.41783215,5.92
29800,94.11091508,12.27216306,5.04
62572,192.30690555,83.41290084,5.38
29807,94.13806515,-35.1405187,4.37
29808,94.14828215,-39.26439442,6.0
62576,192.32271347,27.55237893,5.76
95347,290.97156872,-40.61593993,3.96
95352,290.98542386,43.3881706,5.85
95372,291.03157856,29.62133757,4.99
62608,192.43737256,-71.98625969,5.55
29842,94.25512924,-37.73744555,5.54
29850,94.27758229,9.94239049,5.39
29852,94.28986852,-37.25349784,5.88
29860,94.31724025,5.10011184,5.7
62641,192.54475209,37.51693752,5.87
29895,94.42384802,-16.81590822,5.15
95447,291.24250148,11.94441552,5.17
62683,192.67152704,-33.99930252,4.9
29919,94.4784176,61.51528645,5.01
95456,291.26684251,-29.30935898,5.91
62703,192.74115564,-52.78742442,5.7
29941,94.55720049,-19.96697434,5.51
95477,291.31871418,-24.50857507,5.02
95485,291.33997436,-13.89713,5.72
95498,291.36918107,19.79836536,5.14
62732,192.82489801,-60.32978876,5.71
95503,291.37358265,-23.96245662,5.45
62763,192.92467322,27.54071249,4.93
29996,94.71076247,-9.39001835,5.36
30011,94.74573027,-20.92561099,5.79
62786,192.98720661,-39.6804307,5.99
95556,291.53802894,36.31789626,5.17
95557,291.54600857,-15.05325139,5.71
95560,291.55519226,20.09773254,5.6
95564,291.57981827,-21.77669291,5.57
95572,291.60056239,13.02380156,5.76
95582,291.61952947,19.89149302,5.84
95585,291.6295382,0.33857007,4.64
30069,94.92065172,-34.3965909,5.76
30073,94.92832662,-7.82290853,5.27
95619,291.73534181,-29.74322524,5.66
30093,94.99833381,-2.94449271,4.91
62861,193.2673581,-54.95247272,5.91
30099,95.01760007,14.65112701,5.67
62867,193.27877606,-48.94331472,4.33
62886,193.32393435,21.2449428,4.89
95656,291.85815829,52.3204356,5.73
30122,95.07830229,-30.0633673,3.02
62894,193.34122882,-60.32848863,5.75
62896,193.35916313,-40.17887163,4.25
30143,95.15099808,-34.14414448,5.55
95690,291.95048755,-54.32527229,5.7
62931,193.45383292,-60.3762445,5.89
95732,292.08665952,2.93003016,5.84
30214,95.35298026,-11.77323796,5.48
62983,193.57774768,-11.64857,6.0
62985,193.58818053,-9.5389944,4.77
63003,193.64843683,-57.17792409,4.03
63005,193.65369363,-57.16867044,5.08
63007,193.66325877,-59.14670123,4.62
30247,95.44220782,53.45217905,5.34
95785,292.2378462,24.7687227,5.82
63024,193.73550521,47.19672191,5.75
95793,292.25411763,1.95044755,5.79
63031,193.74504475,-85.12336863,5.45
63033,193.74380562,-44.1519678,5.89
95822,292.34231135,14.59601906,5.57
95823,292.34935701,-43.44519498,5.7
63066,193.83096436,-42.91573222,5.46
63076,193.86895263,65.43847359,5.23
30318,95.65163423,12.57023753,6.0
30321,95.65947681,-69.98404327,5.56
95865,292.46744547,-26.98561504,5.46
30342,95.73260958,-56.36996941,5.6
63117,193.98805953,-56.83580619,5.34
63121,194.00188427,38.31491242,5.61
63143,194.07318496,54.09948923,5.84
63165,194.13204023,-72.18521185,5.93
95937,292.66598928,-2.78888694,5.03
95951,292.68914756,27.96527652,5.12
30436,95.98298405,-25.57762938,5.61
63210,194.26813759,-51.19875207,5.17
30444,96.00420692,-36.70776389,5.62
30457,96.04300064,-11.53008787,5.21
30463,96.05767977,-60.28132508,5.78
95999,292.79570948,-68.43391975,5.98
96014,292.83054813,50.30670588,5.55
96016,292.84009004,26.61717129,5.89
96052,292.94300748,34.45296837,4.74
30520,96.22459464,49.287893,4.92
30545,96.31894142,-0.94588261,5.88
30565,96.36928656,-69.69029879,5.37
96100,293.08996173,69.6611754,4.67
63340,194.69722361,75.47250849,6.0
63355,194.73100938,17.40944558,4.76
30591,96.43188386,-48.17689832,5.76
96141,293.22425881,-53.18561773,5.76
96178,293.3400867,-45.27174848,5.59
63414,194.91465526,-3.81192582,5.79
30651,96.60765486,56.28509613,5.53
96198,293.42336159,49.26231871,6.0
63432,194.97946112,66.59727196,5.37
30666,96.66493823,-1.5073359,5.87
30679,96.70363786,58.41740916,5.21
96229,293.52230372,7.3789415,4.45
63462,195.06862833,30.78502125,4.88
96234,293.53535663,-40.03463823,5.89
30703,96.7671931,-58.00211606,5.82
30717,96.80733912,0.29924627,5.19
30720,96.81496414,-0.27599945,5.55
96258,293.58245908,51.23661978,5.71
63494,195.14977993,-3.36848778,5.99
30728,96.83521215,2.90828786,5.55
63503,195.18208282,56.36633783,4.93
96275,293.64540118,19.77340282,5.0
96288,293.6719137,42.41250862,5.34
63533,195.2900611,17.12314667,5.97
96302,293.71220307,29.4629544,5.39
30772,96.98987304,-4.7621544,5.06
30788,97.04253297,-32.58007055,4.47
96327,293.78023887,-10.56044383,5.12
96341,293.80411512,-48.09920159,4.88
30827,97.14203732,30.49303359,5.75
30836,97.15591533,-17.46600893,5.76
30840,97.16351262,-32.37127903,5.74
96406,294.00688893,-24.71908146,5.64
96441,294.11056248,50.22110266,4.49
63688,195.77224962,-71.47572908,5.93
96459,294.1582377,44.69493598,5.17
96465,294.17680514,-24.883623,4.59
30932,97.36874595,-56.85276588,5.2
96481,294.21855197,11.27320595,5.98
96483,294.22270556,-7.02747723,4.93
30953,97.45443845,-50.2390848,5.28
63724,195.88877523,-49.52726359,4.83
96496,294.26392119,-18.2310521,5.66
63738,195.94214718,-20.58349715,5.58
30972,97.51239348,46.68555384,5.88
96516,294.32247373,16.46280251,5.67
30986,97.54698363,-10.08151141,5.92
96536,294.39339105,-14.30180083,5.46
96556,294.44715718,-4.64763991,5.45
31037,97.69286783,-27.76957483,5.92
31039,97.69628396,58.16263323,5.86
31072,97.80456464,-35.25884033,5.82
31079,97.82631681,-51.82595295,5.58
31084,97.84602021,-12.39195265,5.16
96620,294.67159857,54.97379334,5.89
31119,97.95124549,11.54441184,5.22
31121,97.95859188,-8.15823501,5.43
31125,97.96402713,-23.41842159,4.34
96665,294.79850601,5.39777322,5.18
63901,196.43514992,35.79889865,5.2
31137,97.9929621,-58.75383492,5.69
63916,196.46778037,45.26854974,5.64
96683,294.84419004,30.15332117,4.68
96693,294.86035556,42.81827784,5.41
31159,98.08002204,4.85599911,5.88
31165,98.08911314,-37.69670193,5.25
31167,98.09637147,-5.86881988,5.6
31173,98.11326881,32.45489801,5.82
63945,196.569601,-48.46328926,4.71
63948,196.58849943,21.15339688,6.0
63950,196.59417918,22.61618682,5.53
31190,98.16240194,-32.0304468,5.73
63972,196.64617462,-41.58844273,5.59
96760,295.02985753,-23.42908567,5.97
64003,196.72605922,-35.86203319,5.63
64004,196.72766365,-49.90624607,4.27
64022,196.79470733,27.62474093,4.8
64033,196.85123488,-59.8605097,5.98
96807,295.18050094,-0.62123323,5.64
96808,295.18076475,-16.29326756,5.3
31277,98.40068469,14.15516326,5.57
31278,98.40800834,-1.22015351,5.09
64053,196.90951823,-53.45976424,5.7
96825,295.20909781,45.52494199,5.06
31299,98.45616772,-36.23202924,5.42
96840,295.27303453,13.81568165,5.98
64078,196.97421837,-10.74040808,5.15
64094,197.02979779,-65.30602283,5.44
64122,197.13527764,-8.98438514,5.57
96895,295.45397281,50.52506025,5.99
31362,98.64721326,-32.71625457,5.62
64166,197.26362639,-23.11806973,4.94
31407,98.74408309,-52.975607,4.35
64179,197.30181613,10.0224683,5.79
96950,295.62972399,-16.12399635,5.06
31416,98.76411763,-22.96479303,4.54
96957,295.64170549,11.8265829,5.28
31434,98.80025638,28.02231371,5.26
96977,295.6858584,32.42674142,5.93
31446,98.81594789,0.89021638,5.78
31448,98.82331955,9.98833531,5.93
64224,197.43866437,-10.32932661,5.95
31457,98.85090914,-36.77987945,5.59
64226,197.44936467,16.84861149,5.91
64246,197.51339861,38.49898127,5.91
97063,295.88970937,-15.47010548,5.49
97077,295.92885488,25.77192859,5.5
97081,295.93790338,41.77310845,5.86
31564,99.09521,-18.65990366,5.71
64332,197.78700265,-42.23289129,5.78
31579,99.13681827,38.44550006,5.4
64348,197.84673181,-43.36855307,5.24
97118,296.06918701,37.35435508,4.89
31583,99.14721669,-5.21114314,5.52
97122,296.07673388,69.33706468,5.9
31599,99.19416295,-13.32103582,5.95
64390,197.96433787,-69.94201668,5.92
31637,99.30764436,-36.99065085,5.72
64407,198.01476264,-16.19860153,5.04
64408,198.0132685,-37.80302179,4.85
64425,198.07331699,-59.92057895,4.58
31665,99.40995432,56.85753098,5.87
31676,99.42244098,61.48123297,5.94
64445,198.13717226,11.55609605,5.76
31688,99.44841227,-32.33973479,5.25
97229,296.41644774,7.61315808,5.89
64466,198.20334548,-66.22674699,5.91
31700,99.47259046,-18.23747772,4.42
97260,296.50507059,-31.9085714,5.51
31737,99.59586146,28.98435357,5.76
64515,198.34729859,-50.69982887,5.9
97290,296.59058063,-19.76111311,4.87
97295,296.60666696,33.72759764,5.0
31765,99.65681639,-48.22018309,5.05
31771,99.66473993,39.39085404,5.7
64540,198.42892358,40.15288533,4.94
31789,99.70491759,39.90255877,5.34
64577,198.54539617,-19.93094659,5.31
64580,198.55036527,-58.68393657,5.91
64583,198.56310217,-59.10323522,4.9
64587,198.57221676,-78.44745396,5.84
31827,99.81966316,-14.14576374,4.82
31832,99.83260944,42.48887688,4.8
64607,198.63034859,11.33165633,5.64
97376,296.86574821,38.40761389,5.83
64623,198.68027747,-48.9570225,5.84
97402,296.95225356,25.38405839,6.0
31870,99.92775298,-30.47049071,5.7
31876,99.9488183,12.98276822,5.99
97421,297.00499561,-56.36261151,5.33
64661,198.81225236,-67.89458914,4.79
31897,100.01204212,-80.81359263,5.61
64692,198.88313472,40.85519935,5.77
97473,297.17523982,11.81589634,5.75
31940,100.12032172,77.99578247,5.75
31946,100.13438247,71.74878589,5.88
64725,198.9948806,-19.94310297,5.21
97496,297.24441613,19.1420424,5.01
97499,297.25918329,-10.87076339,6.0
31992,100.27266964,0.49532315,5.79
97534,297.3554428,-72.50337842,5.39
64792,199.19381485,9.42415651,5.19
64803,199.22139531,-31.50619645,5.1
64820,199.30421831,-66.78343804,4.86
64822,199.30799895,-43.97947958,5.82
64823,199.31511763,13.67575121,5.33
97598,297.55858176,-47.5573919,5.91
32064,100.48494554,-9.16753661,5.21
64844,199.38558588,40.57260759,4.72
64852,199.4011779,5.46986933,4.78
97630,297.6416496,38.72241938,5.18
97634,297.65553123,40.59975936,5.68
97635,297.65718237,52.98800132,5.03
32104,100.6013618,17.64530307,5.2
97646,297.6866796,-59.19366683,5.41
97650,297.69493251,-10.76351163,5.38
64906,199.56045992,49.68206239,5.14
97675,297.75684431,10.41572697,5.12
97679,297.76711829,22.61004629,4.9
64924,199.60131085,-18.31119618,4.74
64927,199.61553346,34.09830367,5.81
32173,100.77071436,44.52444991,5.04
97749,297.96085286,-39.87436734,5.32
97757,297.99612216,47.02733897,5.6
32226,100.91102307,3.93252783,5.88
97765,298.00664168,24.99216201,5.54
97774,298.02985867,47.93179472,5.91
97783,298.05001477,-19.04499128,5.88
32249,100.99705285,13.22801729,4.49
97816,298.15717895,-54.9710258,5.76
32292,101.11861215,-31.0705227,5.23
65072,200.07896443,40.15054794,5.6
32311,101.18941202,28.97093164,5.42
97870,298.3224057,57.52348186,5.14
97871,298.32806575,-3.11446372,5.63
65112,200.15760353,-52.74782498,5.47
65129,200.20141301,-55.80068826,6.0
32366,101.34558198,-31.79366094,5.92
65144,200.24041545,-46.88000771,5.76
32385,101.3799528,-30.94898055,5.62
97928,298.53448838,-8.574211,5.76
32402,101.47382449,-52.40969129,5.81
97938,298.5620066,8.46145271,4.71
32411,101.49747737,-14.79612726,5.3
97961,298.62948485,24.31938849,5.56
65198,200.42351235,2.08724324,5.69
97966,298.65688499,-8.22728863,5.7
32438,101.55888293,59.44167001,4.86
32439,101.55896087,79.56481097,5.44
97980,298.68665422,0.27362751,5.6
97985,298.70104514,36.99567607,5.79
32463,101.63506596,8.58715267,5.92
65241,200.54037208,5.15476433,5.89
32474,101.66256946,-10.10736009,5.66
65247,200.5678565,-52.18295639,5.81
32480,101.68474499,43.57742706,5.24
32489,101.70628931,57.16917622,5.34
32492,101.71288292,-14.4259708,5.28
32494,101.7194718,-51.26566708,5.39
98032,298.81540582,-41.86828808,4.12
65271,200.65807108,-60.988393,4.52
98055,298.90744681,52.43894787,4.91
98066,298.95982398,-26.29950635,4.7
32531,101.82795433,-55.53998822,5.6
98068,298.96567625,38.48670538,4.95
32533,101.83262738,8.03725399,4.77
65301,200.75464431,-17.7352737,5.36
32537,101.83916434,-37.92969815,5.27
98073,298.98074231,58.84596912,4.98
98085,299.00526654,16.63479915,5.71
65323,200.82872415,-4.92442737,5.88
32558,101.90508797,-8.99850257,5.08
32562,101.91490037,48.78947643,5.22
98103,299.05938319,11.42372089,5.28
98110,299.0765497,35.08342371,3.89
32609,102.051217,55.70419499,5.54
32617,102.07944127,-1.31892245,5.75
65387,201.00201188,-64.53566793,4.52
98162,299.23679661,-27.16989884,4.54
98174,299.27629174,-58.90135155,5.24
65420,201.13845338,-5.1640102,5.76
98194,299.30778315,40.36782391,5.46
32677,102.24057487,-15.14472559,5.39
32698,102.31837083,-2.27203835,5.75
65466,201.27782704,23.85441857,5.75
65468,201.27965886,-74.88781838,5.04
98234,299.43935674,16.78916315,5.54
65477,201.30640816,54.98795767,3.99
65479,201.3080283,-64.48514427,5.32
98258,299.48762968,-15.4914902,5.01
32740,102.42212909,32.60675579,5.72
32753,102.45765123,16.2028878,5.87
65522,201.4595884,-70.62724814,5.65
32759,102.46024639,-32.5084777,3.5
32761,102.46380782,-53.62244951,4.41
32765,102.47756897,-46.61456012,5.14
65535,201.5323613,-39.75510736,5.11
"""
