import os
import os.path

from ..patch.patch import create_monkey_patches
from .telemetry_service import TelemetryService, TelemetryLevel
from .log_init import logging, init_logging
from .ssl_utils import add_custom_certificate
from .web import Web
from ..core.playbooks.playbooks_event_handler_impl import PlaybooksEventHandlerImpl
from .. import api as robusta_api
from .config_loader import ConfigLoader
from ..model.config import Registry
from ..core.model.env_vars import ROBUSTA_TELEMETRY_ENDPOINT, SEND_ADDITIONAL_TELEMETRY, \
 ENABLE_TELEMETRY, TELEMETRY_PERIODIC_SEC


def main():
    init_logging()
    if add_custom_certificate(os.environ.get("CERTIFICATE", "")):
        logging.info("added custom certificate")

    create_monkey_patches()
    registry = Registry()
    event_handler = PlaybooksEventHandlerImpl(registry)
    loader = ConfigLoader(registry, event_handler)

    if ENABLE_TELEMETRY:    
        telemetry_service = TelemetryService(
            telemetry_level= TelemetryLevel.ERROR if SEND_ADDITIONAL_TELEMETRY else TelemetryLevel.USAGE,
            endpoint=ROBUSTA_TELEMETRY_ENDPOINT,
            periodic_time_sec= TELEMETRY_PERIODIC_SEC,
            registry= registry,
            )
    else:
        logging.info(f"Telemetry is disabled.")

    Web.init(event_handler, loader)
    Web.run()  # blocking
    loader.close()



if __name__ == "__main__":
    main()
