/**
 * \file
 * \brief TNG TLS signer certificate definition
 *
 * \copyright (c) 2015-2020 Microchip Technology Inc. and its subsidiaries.
 *
 * \page License
 *
 * Subject to your compliance with these terms, you may use Microchip software
 * and any derivatives exclusively with Microchip products. It is your
 * responsibility to comply with third party license terms applicable to your
 * use of third party software (including open source software) that may
 * accompany Microchip software.
 *
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
 * PARTICULAR PURPOSE. IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT,
 * SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE
 * OF ANY KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF
 * MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE
 * FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL
 * LIABILITY ON ALL CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED
 * THE AMOUNT OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR
 * THIS SOFTWARE.
 */

#include "atcacert/atcacert_def.h"
#include "tngtls_cert_def_1_signer.h"

SHARED_LIB_EXPORT const uint8_t g_tngtls_cert_template_1_signer[TNGTLS_CERT_TEMPLATE_1_SIGNER_SIZE] = {
    0x30, 0x82, 0x02, 0x04, 0x30, 0x82, 0x01, 0xaa, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x44,
    0x0e, 0xe4, 0x17, 0x0c, 0xb5, 0x45, 0xce, 0x59, 0x69, 0x8e, 0x30, 0x56, 0x99, 0x0a, 0x5d, 0x30,
    0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x4f, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x63, 0x68, 0x69,
    0x70, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x20, 0x49, 0x6e, 0x63,
    0x31, 0x2a, 0x30, 0x28, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x21, 0x43, 0x72, 0x79, 0x70, 0x74,
    0x6f, 0x20, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
    0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41, 0x20, 0x30, 0x30, 0x32, 0x30, 0x20, 0x17, 0x0d,
    0x31, 0x38, 0x31, 0x31, 0x30, 0x38, 0x30, 0x34, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x32,
    0x30, 0x34, 0x39, 0x31, 0x31, 0x30, 0x38, 0x30, 0x34, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x4f,
    0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x4d, 0x69, 0x63, 0x72, 0x6f,
    0x63, 0x68, 0x69, 0x70, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x20,
    0x49, 0x6e, 0x63, 0x31, 0x2a, 0x30, 0x28, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x21, 0x43, 0x72,
    0x79, 0x70, 0x74, 0x6f, 0x20, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
    0x69, 0x6f, 0x6e, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x20, 0x46, 0x46, 0x46, 0x46, 0x30,
    0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x84, 0x98, 0x44, 0x0a, 0x31, 0x9b,
    0x3f, 0x71, 0xe2, 0x5d, 0x52, 0x26, 0x00, 0x90, 0x00, 0xc7, 0x56, 0xbd, 0x5c, 0x0f, 0xae, 0x4a,
    0x1b, 0x84, 0x1a, 0xd4, 0xa3, 0x3f, 0x21, 0xab, 0xa0, 0x9a, 0x48, 0x10, 0x1c, 0x75, 0xc8, 0x28,
    0x24, 0x90, 0xb3, 0xb6, 0x5a, 0x52, 0x80, 0x27, 0x29, 0xbd, 0x3a, 0x75, 0x2c, 0x3d, 0xf0, 0xdd,
    0x1b, 0x04, 0xa2, 0xa1, 0xb5, 0x7e, 0x0c, 0x92, 0x24, 0x47, 0xa3, 0x66, 0x30, 0x64, 0x30, 0x0e,
    0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, 0x12,
    0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02,
    0x01, 0x00, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xbc, 0xd4, 0xfd,
    0xe8, 0x80, 0x8a, 0x2d, 0xc9, 0x0b, 0x6d, 0x01, 0xa8, 0xc5, 0xb9, 0xb2, 0x47, 0x33, 0x7e, 0xbd,
    0xda, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x7a, 0xed,
    0x7d, 0x6d, 0xc6, 0xb7, 0x78, 0x9d, 0xb2, 0x38, 0x01, 0xa5, 0xe8, 0x4a, 0x8c, 0xb0, 0xa4, 0x0e,
    0x2a, 0x8c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xc5, 0x07, 0xb8, 0x2a, 0x7b, 0xf9, 0xa3, 0x3a, 0x1b, 0x78,
    0xdc, 0xeb, 0x01, 0xc9, 0x26, 0x92, 0x9e, 0xf3, 0x78, 0x3d, 0x46, 0x8e, 0x69, 0xa2, 0x84, 0xd3,
    0x6a, 0xba, 0xb9, 0x25, 0x1b, 0xef, 0x02, 0x20, 0x0e, 0x6d, 0x7f, 0x76, 0x8d, 0x65, 0xa7, 0x49,
    0xfa, 0x71, 0x2d, 0xda, 0x2b, 0x69, 0x25, 0x35, 0xcd, 0x57, 0x7d, 0x65, 0x01, 0x96, 0xa3, 0xd2,
    0xbf, 0x3b, 0x22, 0x78, 0x8e, 0x75, 0x41, 0x86
};

SHARED_LIB_EXPORT const atcacert_cert_element_t g_tngtls_cert_elements_1_signer[] = {
    {
        .id = "subject",
        .device_loc ={
            .zone      = DEVZONE_NONE,
        },
        .cert_loc ={
            .offset = 158,
            .count  = 81
        }
    }
};

SHARED_LIB_EXPORT const atcacert_def_t g_tngtls_cert_def_1_signer = {
    .type                = CERTTYPE_X509,
    .template_id         = 1,
    .chain_id            = 0,
    .private_key_slot    = 0,
    .sn_source           = SNSRC_PUB_KEY_HASH,
    .cert_sn_dev_loc     = {
        .zone            = DEVZONE_NONE,
        .slot            = 0,
        .is_genkey       = 0,
        .offset          = 0,
        .count           = 0
    },
    .issue_date_format   = DATEFMT_RFC5280_UTC,
    .expire_date_format  = DATEFMT_RFC5280_GEN,
    .tbs_cert_loc        = {
        .offset          = 4,
        .count           = 430
    },
    .expire_years        = 31,
    .public_key_dev_loc  = {
        .zone            = DEVZONE_DATA,
        .slot            = 11,
        .is_genkey       = 0,
        .offset          = 0,
        .count           = 72
    },
    .comp_cert_dev_loc   = {
        .zone            = DEVZONE_DATA,
        .slot            = 12,
        .is_genkey       = 0,
        .offset          = 0,
        .count           = 72
    },
    .std_cert_elements   = {
        {   // STDCERT_PUBLIC_KEY
            .offset      = 266,
            .count       = 64
        },
        {   // STDCERT_SIGNATURE
            .offset      = 446,
            .count       = 64
        },
        {   // STDCERT_ISSUE_DATE
            .offset      = 128,
            .count       = 13
        },
        {   // STDCERT_EXPIRE_DATE
            .offset      = 143,
            .count       = 15
        },
        {   // STDCERT_SIGNER_ID
            .offset      = 235,
            .count       = 4
        },
        {   // STDCERT_CERT_SN
            .offset      = 15,
            .count       = 16
        },
        {   // STDCERT_AUTH_KEY_ID
            .offset      = 414,
            .count       = 20
        },
        {   // STDCERT_SUBJ_KEY_ID
            .offset      = 381,
            .count       = 20
        }
    },
    .cert_elements       = g_tngtls_cert_elements_1_signer,
    .cert_elements_count = 1,
    .cert_template       = g_tngtls_cert_template_1_signer,
    .cert_template_size  = sizeof(g_tngtls_cert_template_1_signer),
    .ca_cert_def         = NULL
};
