import os
import socket
import multiprocessing
import subprocess
import os
import logging

logger = logging.getLogger(__name__)


def pinger(job_q, results_q):
    """
    Do Ping
    :param job_q:
    :param results_q:
    :return:
    """
    DEVNULL = open(os.devnull, 'w')
    while True:

        ip = job_q.get()

        if ip is None:
            break

        try:
            print(str(ip))
            subprocess.check_call(['ping', '-c', '1', '-W', '0.3', '-w', '0.3', ip],
                                  stdout=DEVNULL, timeout=0.3)
            logger.debug('added: ' + str(ip))
            results_q.put(ip)
        except:
            pass


def get_my_ip():
    """
    Find my IP address
    :return:
    """
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(("8.8.8.8", 80))
    ip = s.getsockname()[0]
    s.close()
    return ip


def map_network(pool_size=4):
    """
    Maps the network
    :param pool_size: amount of parallel ping processes
    :return: list of valid ip addresses
    """

    ip_list = list()

    # get my IP and compose a base like 192.168.1.xxx
    ip_parts = get_my_ip().split('.')
    base_ip = ip_parts[0] + '.' + ip_parts[1] + '.' + ip_parts[2] + '.'

    # prepare the jobs queue
    jobs = multiprocessing.Queue()
    results = multiprocessing.Queue()

    pool = [multiprocessing.Process(target=pinger, args=(jobs, results)) for i in range(pool_size)]

    for p in pool:
        p.start()

    # cue hte ping processes
    for i in range(1, 255):
        jobs.put(base_ip + '{0}'.format(i))

    for p in pool:
        jobs.put(None)

    for p in pool:
        p.join()

    # collect he results
    while not results.empty():
        ip = results.get()
        ip_list.append(ip)

    return ip_list


import socket


def get_ip():
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        # doesn't even have to be reachable
        s.connect(('10.255.255.255', 1))
        IP = s.getsockname()[0]
    except Exception:
        IP = '127.0.0.1'
    finally:
        s.close()
    return IP


def non_multiprocessing():
    ip_parts = get_my_ip().split('.')
    base_ip = ip_parts[0] + '.' + ip_parts[1] + '.' + ip_parts[2] + '.'
    base_ip = '192.168.3.'
    DEVNULL = open(os.devnull, 'w')

    ips = []
    for i in range(1, 255):
        ip = base_ip + '{0}'.format(i)
        print(str(ip))

        try:
            subprocess.check_call(['ping', '-c', '1', '-W', '0.1', '-w', '0.1', ip],
                                  stdout=DEVNULL, timeout=0.1)
            ips.append(ip)
        except Exception as a:
            print(a)
    print(str(ips))


if __name__ == '__main__':
    print('Mapping...')
    lst = map_network()
    print(lst)
