# Three60Cube

A Package to project a 360 x 180 image onto a cube.

## Installation

```
pip install three60cube
```

## Usage

Creation of projection template
```
from three30cube import Three60Cube

proj = Three60Cube('source.JPG')
```
This will write a `npy` file to your working directory. To get the projection on a certain cube pane:

```
new_img = proj.get_projected_pane(pane=1, dim=500)
new_img
```

Panes 0 through 3 are taken from the left to right side of the 360 image. Pane 4 is the top of the cube and pane 5 is the bottom part. The `dim` parameter refers to dimension of the output image; a `dim` of 500 will produce a 500 x 500px image.

After you have generated the npy-template you can process images with the same dimensions of the initial 360 image:

```
# use the generated template if you have one and haven't 
# initialized a Three60Cube object already 
proj = Three60Cube(template='three60cube_template.npy')

# open an image
proj.open_image('trees.JPG')

# project
new_img = proj.get_projected_pane(pane=0, dim=500)
```
