"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const extensions = require("./extensions");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'demo-stack');
        // prepare the `modify resonse header` extension
        // const modifyRespHeader = new extensions.ModifyResponseHeader(stack, 'ModifyResp');
        // prepare the `anti-hotlinking` extension
        const antiHotlinking = new extensions.AntiHotlinking(stack, 'AntiHotlink', {
            referer: [
                'example.com',
                'exa?ple.*',
            ],
        });
        // prepare the security headers extension
        const securityHeaders = new extensions.SecurtyHeaders(stack, 'SecurityHeaders');
        // create the cloudfront distribution with extension(s)
        new _1.Distribution(stack, 'dist', {
            defaultBehavior: {
                origin: new origins.HttpOrigin('aws.amazon.com'),
                edgeLambdas: [
                    // modifyRespHeader,
                    // viewer request
                    antiHotlinking,
                    // origin response
                    securityHeaders,
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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