"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleLambdaEdge = exports.DefaultDirIndex = exports.Custom = exports.SecurtyHeaders = exports.AntiHotlinking = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.1.16" };
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_b = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_b] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.1.16" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_c = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_c] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.1.16" };
/**
 * Custom extension sample.
 *
 * @stability stable
 */
class Custom extends cdk.NestedStack {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _g, _h, _j, _k, _l, _m;
        super(scope, id, props);
        this.props = props;
        const func = (_g = props === null || props === void 0 ? void 0 : props.func) !== null && _g !== void 0 ? _g : new lambda.Function(this, 'CustomFunc', {
            code: (_h = props === null || props === void 0 ? void 0 : props.code) !== null && _h !== void 0 ? _h : lambda.Code.fromAsset(path.join(__dirname, '../lambda/function')),
            runtime: (_j = props === null || props === void 0 ? void 0 : props.runtime) !== null && _j !== void 0 ? _j : lambda.Runtime.PYTHON_3_8,
            handler: (_k = props === null || props === void 0 ? void 0 : props.handler) !== null && _k !== void 0 ? _k : 'index.lambda_handler',
            timeout: (_l = props === null || props === void 0 ? void 0 : props.timeout) !== null && _l !== void 0 ? _l : cdk.Duration.seconds(5),
        });
        this.functionArn = func.functionArn;
        this.functionVersion = func.currentVersion;
        this.eventType = (_m = props === null || props === void 0 ? void 0 : props.eventType) !== null && _m !== void 0 ? _m : cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
        this._addDescription();
        this._outputSolutionId();
    }
    _addDescription() {
        this.templateOptions.description = `(${this.props.solutionId}) ${this.props.templateDescription}`;
    }
    _outputSolutionId() {
        if (this.props.solutionId) {
            new cdk.CfnOutput(this, 'SolutionId', {
                value: this.props.solutionId,
                description: 'Solution ID',
            });
        }
    }
}
exports.Custom = Custom;
_d = JSII_RTTI_SYMBOL_1;
Custom[_d] = { fqn: "cdk-cloudfront-plus.Custom", version: "0.1.16" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_e = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_e] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.1.16" };
;
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_f = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_f] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.1.16" };
;
//# sourceMappingURL=data:application/json;base64,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