import * as cf from '@aws-cdk/aws-cloudfront';
import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { ServerlessApp } from './';
/**
 * The Extension interface.
 *
 * @stability stable
 */
export interface IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
}
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
export declare class ModifyResponseHeader extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * Construct properties for AntiHotlinking.
 *
 * @stability stable
 */
export interface AntiHotlinkingProps {
    /**
     * Referer allow list with wildcard(* and ?) support i.e. `example.com` or `exa?ple.*`.
     *
     * @stability stable
     */
    readonly referer: string[];
}
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
export declare class AntiHotlinking extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AntiHotlinkingProps);
}
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
export declare class SecurtyHeaders extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * @stability stable
 */
export interface CustomProps {
    /**
     * Specify your Lambda function.
     *
     * You can specify your Lamba function
     * It's implement by lambda.Function, ex: NodejsFunction / PythonFunction or CustomFunction
     *
     * @stability stable
     */
    readonly func?: lambda.Function;
    /**
     * The source code of your Lambda function.
     *
     * You can point to a file in an
     * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
     * code as inline text.
     *
     * @default Code.fromAsset(path.join(__dirname, '../lambda/function'))
     * @stability stable
     */
    readonly code?: lambda.AssetCode;
    /**
     * The runtime environment for the Lambda function that you are uploading.
     *
     * For valid values, see the Runtime property in the AWS Lambda Developer
     * Guide.
     *
     * Use `Runtime.FROM_IMAGE` when when defining a function from a Docker image.
     *
     * @default Runtime.PYTHON_3_8
     * @stability stable
     */
    readonly runtime?: lambda.Runtime;
    /**
     * The name of the method within your code that Lambda calls to execute your function.
     *
     * The format includes the file name. It can also include
     * namespaces and other qualifiers, depending on the runtime.
     * For more information, see https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html#gettingstarted-features-programmingmodel.
     *
     * Use `Handler.FROM_IMAGE` when defining a function from a Docker image.
     *
     * NOTE: If you specify your source code as inline text by specifying the
     * ZipFile property within the Code property, specify index.function_name as
     * the handler.
     *
     * @default index.lambda_handler
     * @stability stable
     */
    readonly handler?: string;
    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     *
     * Because the execution time affects cost, set this value
     * based on the function's expected execution time.
     *
     * @default Duration.seconds(5)
     * @stability stable
     */
    readonly timeout?: cdk.Duration;
    /**
     * The type of event in response to which should the function be invoked.
     *
     * @default LambdaEdgeEventType.ORIGIN_RESPONSE
     * @stability stable
     */
    readonly eventType?: cf.LambdaEdgeEventType;
    /**
     * The solution identifier.
     *
     * @default - no identifier
     * @stability stable
     */
    readonly solutionId?: string;
    /**
     * The template description.
     *
     * @default ''
     * @stability stable
     */
    readonly templateDescription?: string;
}
/**
 * Custom extension sample.
 *
 * @stability stable
 */
export declare class Custom extends cdk.NestedStack implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    readonly props: CustomProps;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: CustomProps);
    private _addDescription;
    private _outputSolutionId;
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
export declare class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
export declare class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
