"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'default-dir-index-demo');
// create the cloudfront distribution with extension(s)
const defaultDirIndex = new extensions.DefaultDirIndex(stack, 'DefaultDirIndexDemo');
// create Demo S3 Bucket.
const bucket = new s3.Bucket(defaultDirIndex, 'demoBucket', {
    autoDeleteObjects: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    websiteIndexDocument: 'index.html',
    websiteErrorDocument: 'index.html',
});
// create index.html in the demo folder
fs.mkdirSync(path.join(__dirname, 'a/b/c'), {
    recursive: true,
});
fs.writeFileSync(path.join(__dirname, 'a/b/c/index.html'), '<h1>Hello CDK!</h1>');
fs.writeFileSync(path.join(__dirname, 'index.html'), '<h1>Hello CDK!!! From root directory </h1>');
// Put demo Object to Bucket.
new aws_s3_deployment_1.BucketDeployment(defaultDirIndex, 'Deployment', {
    sources: [aws_s3_deployment_1.Source.asset(path.join(__dirname, './'))],
    destinationBucket: bucket,
    retainOnDelete: false,
});
// CloudFront OriginAccessIdentity for Bucket
const originAccessIdentity = new cf.OriginAccessIdentity(defaultDirIndex, 'OriginAccessIdentity', {
    comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
});
// CloudfrontWebDistribution
const cloudfrontWebDistribution = new cf.CloudFrontWebDistribution(stack, 'CloudFrontWebDistribution', {
    originConfigs: [
        {
            s3OriginSource: {
                originAccessIdentity,
                s3BucketSource: bucket,
            },
            behaviors: [{
                    isDefaultBehavior: true,
                    lambdaFunctionAssociations: [defaultDirIndex],
                }],
        },
    ],
});
new cdk.CfnOutput(stack, 'distributionDomainName', {
    value: cloudfrontWebDistribution.distributionDomainName,
});
//# sourceMappingURL=data:application/json;base64,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