from nlu.universe.feature_node_ids import NLP_NODE_IDS, NLP_HC_NODE_IDS, OCR_NODE_IDS


class Spellbook:
    trainable_models = {
        # map NLU references to NLP approaches
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,  # classifier DL alias
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,  # ner DL alias
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,  # sent DL alias
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

        # 'train.sentence_detector': '',  # deep sentence detector alias
        # 'train.symmetric_spell': '',
        # 'train.context_spell': '',
        # 'train.spell': '',  ## context spell alias
        # 'train.norvig_spell': '',
        # 'train.unlabeled_dependency_parser': '',
        # 'train.labeled_dependency_parser': '',
        # 'train.vivekn_sentiment': '',

    }

    # Reference to all datasets for which we have pretrained models
    datasets = []
    chunk_embeddings = ['embed_sentence']
    # The vocabulary of the nlu Namespace. Any of this references give you a model_anno_obj
    # keys inside a language dict are NLU references and value is the name in SparkNLP

    component_alias_references = {
        # references for SparkNLPAnnotators without pretrained models.
        #  These are names for NLU components that can be created withouth a language prefix

        # multi lang pipes
        'lang': ('detect_language_375', 'component_list'),  # multi lang alias

        # Aliases
        'classify.lang': ('detect_language_375', 'component_list'),  # multi lang detector default

        # eng pipes
        'classify': ('analyze_sentiment', 'component_list'),  # default classifier
        'explain': ('explain_document_ml', 'component_list'),  # default explain
        'explain.ml': ('explain_document_ml', 'component_list'),
        'explain.dl': ('explain_document_dl', 'component_list'),
        'ner.conll': ('recognize_entities_dl', 'component_list'),  # default ner
        'ner.dl': ('recognize_entities_dl', 'component_list'),
        'ner.bert': ('recognize_entities_bert', 'component_list'),
        'ner': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto.sm': ('onto_recognize_entities_sm', 'component_list'),

        # 'match.text': ('text_matcher', 'model_anno_obj'),
        # 'match.regex': ('regex_matcher', 'model_anno_obj'),
        # 'match.date': ('date_matcher', 'model_anno_obj'),
        # 'match.context': ('context_parser', 'model_anno_obj'),
        # 'context_parser': ('context_parser', 'model_anno_obj'),

        'match.chunks': ('match_chunks', 'component_list'),
        'clean.stop': ('clean_stop', 'component_list'),
        # 'clean.pattern': ('clean_pattern', 'component_list'),
        'clean.slang': ('clean_slang', 'component_list'),
        # 'spell': ('check_spelling','component_list'),  # bad spell_checker,
        'spell': ('spellcheck_dl', 'model_anno_obj'),  # default spell
        'sentiment': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # default emotion model_anno_obj

        'sentiment.imdb': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.imdb.use': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.twitter.use': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'sentiment.twitter': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'dependency': ('dependency_conllu', 'model_anno_obj'),

        'tokenize': ('spark_nlp_tokenizer', 'model_anno_obj'),  # tokenizer rule based model_anno_obj
        'stem': ('stemmer', 'model_anno_obj'),  # stem rule based model_anno_obj
        'norm': ('normalizer', 'model_anno_obj'),  # rule based model_anno_obj
        'norm_document': ('document_normalizer', 'model_anno_obj'),  # rule based model_anno_obj

        'chunk': ('default_chunker', 'model_anno_obj'),  # rule based model_anno_obj
        'embed_chunk': ('chunk_embeddings', 'model_anno_obj'),  # rule based model_anno_obj
        'ngram': ('ngram', 'model_anno_obj'),  # rule based model_anno_obj

        'lemma': ('lemma_antbnc', 'model_anno_obj'),  # lemma default en
        'lemma.antbnc': ('lemma_antbnc', 'model_anno_obj'),
        'pos': ('pos_anc', 'model_anno_obj'),  # pos default en
        'pos.anc': ('pos_anc', 'model_anno_obj'),
        'pos.ud_ewt': ('pos_ud_ewt', 'model_anno_obj'),
        # 'ner.crf' :'ner_crf', # crf not supported in NLU
        'ner.dl.glove.6B_100d': ('ner_dl', 'model_anno_obj'),
        'ner.dl.bert': ('ner_dl_bert', 'model_anno_obj'),  # points ner bert
        'ner.onto.glove.6B_100d': ('onto_100', 'model_anno_obj'),
        'ner.onto.glove.6B_300d': ('onto_300', 'model_anno_obj'),  # this uses multi lang embeds!
        'sentence_detector': ('sentence_detector_dl', 'model_anno_obj'),
        'sentence_detector.deep': ('sentence_detector_dl', 'model_anno_obj'),  # ALIAS

        'sentence_detector.pragmatic': ('pragmatic_sentence_detector', 'model_anno_obj'),

        'spell.symmetric': ('spellcheck_sd', 'model_anno_obj'),  # TODO erronous
        'spell.norivg': ('spellcheck_norvig', 'model_anno_obj'),
        'sentiment.vivekn': ('sentiment_vivekn', 'model_anno_obj'),
        'dep.untyped.conllu': ('dependency_conllu', 'model_anno_obj'),
        'dep.untyped': ('dependency_conllu', 'model_anno_obj'),  # default untyped dependency
        'dep': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency
        'dep.typed': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency dataset
        'dep.typed.conllu': ('dependency_typed_conllu', 'model_anno_obj'),
        'stopwords': ('stopwords_en', 'model_anno_obj'),

        # embeddings models
        'embed': ('glove_100d', 'model_anno_obj'),  # default overall embed
        'glove': ('glove_100d', 'model_anno_obj'),  # default glove
        'embed.glove': ('glove_100d', 'model_anno_obj'),  # default glove en
        'embed.glove.100d': ('glove_100d', 'model_anno_obj'),
        'bert': ('small_bert_L2_128', 'model_anno_obj'),  # default bert
        'covidbert': ('covidbert_large_uncased', 'model_anno_obj'),

        'embed.bert': ('bert_base_uncased', 'model_anno_obj'),  # default bert
        'embed.bert_base_uncased': ('bert_base_uncased', 'model_anno_obj'),
        'embed.bert_base_cased': ('bert_base_cased', 'model_anno_obj'),
        'embed.bert_large_uncased': ('bert_large_uncased', 'model_anno_obj'),
        'embed.bert_large_cased': ('bert_large_cased', 'model_anno_obj'),
        'biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # alias
        'embed.biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # default bio bert
        'embed.biobert_pubmed_base_cased': ('biobert_pubmed_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_large_cased': ('biobert_pubmed_large_cased', 'model_anno_obj'),
        'embed.biobert_pmc_base_cased': ('biobert_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_pmc_base_cased': ('biobert_pubmed_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_clinical_base_cased': ('biobert_clinical_base_cased', 'model_anno_obj'),
        'embed.biobert_discharge_base_cased': ('biobert_discharge_base_cased', 'model_anno_obj'),
        'elmo': ('elmo', 'model_anno_obj'),

        'embed.electra': ('electra_small_uncased', 'model_anno_obj'),
        'electra': ('electra_small_uncased', 'model_anno_obj'),
        'e2e': ('multiclassifierdl_use_e2e', 'model_anno_obj'),

        'embed.elmo': ('elmo', 'model_anno_obj'),
        'embed_sentence': ('tfhub_use', 'model_anno_obj'),  # default use
        'embed_sentence.small_bert_L2_128': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.bert': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.electra': ('sent_electra_small_uncased', 'model_anno_obj'),

        'embed_sentence.use': ('tfhub_use', 'model_anno_obj'),  # default use
        'use': ('tfhub_use', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use': ('tfhub_use', 'model_anno_obj'),
        'embed_sentence.use_lg': ('tfhub_use_lg', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use_lg': ('tfhub_use_lg', 'model_anno_obj'),
        'albert': ('albert_base_uncased', 'model_anno_obj'),  # albert alias en
        'embed.albert_base_uncased': ('albert_base_uncased', 'model_anno_obj'),
        'embed.albert_large_uncased': ('albert_large_uncased', 'model_anno_obj'),
        'embed.albert_xlarge_uncased': ('albert_xlarge_uncased', 'model_anno_obj'),
        'embed.albert_xxlarge_uncased': ('albert_xxlarge_uncased', 'model_anno_obj'),
        'embed.xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet default en
        'xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet alias
        'embed.xlnet_base_cased': ('xlnet_base_cased', 'model_anno_obj'),
        'embed.xlnet_large_cased': ('xlnet_large_cased', 'model_anno_obj'),

        # classifiers and sentiment models
        'classify.trec6.use': ('classifierdl_use_trec6', 'model_anno_obj'),
        'classify.trec50.use': ('classifierdl_use_trec50', 'model_anno_obj'),
        'classify.questions': ('classifierdl_use_trec50', 'model_anno_obj'),
        'questions': ('classifierdl_use_trec50', 'model_anno_obj'),

        'classify.spam.use': ('classifierdl_use_spam', 'model_anno_obj'),
        'classify.fakenews.use': ('classifierdl_use_fakenews', 'model_anno_obj'),
        'classify.emotion.use': ('classifierdl_use_emotion', 'model_anno_obj'),
        'classify.cyberbullying.use': ('classifierdl_use_cyberbullying', 'model_anno_obj'),
        'classify.sarcasm.use': ('classifierdl_use_sarcasm', 'model_anno_obj'),
        'sentiment.imdb.glove': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'classify.trec6': ('classifierdl_use_trec6', 'model_anno_obj'),  # Alias withouth embedding
        'classify.trec50': ('classifierdl_use_trec50', 'model_anno_obj'),  # Alias withouth embedding
        'classify.spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'toxic': ('multiclassifierdl_use_toxic', 'model_anno_obj'),

        'classify.fakenews': ('classifierdl_use_fakenews', 'model_anno_obj'),  # Alias withouth embedding
        'classify.emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # Alias withouth embedding
        'classify.cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding
        'cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding

        'classify.sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding
        'sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding

        'embed.glove.840B_300': ('glove_840B_300', 'model_anno_obj'),
        'yake': ('yake', 'model_anno_obj'),

        # # 2.7.0 new aliases
        't5': ('t5_base', 'model_anno_obj'),
        'summarize': ('t5_base', 'model_anno_obj', {'setTask': '"summarize: "'}),
        'grammar_correctness': ('t5_base', 'model_anno_obj', {'setTask': '"cola sentence: "'}),
        'answer_question': ('t5_base', 'model_anno_obj', {'setTask': '"question: "'}),
        'classify.sentiment_t5': ('t5_base', 'model_anno_obj', {'setTask': '"sst2 sentence: "'}),

    }
    # multi lang models
    pretrained_pipe_references = {

        'da': {
            'da.explain': 'explain_document_sm',
            'da.explain.sm': 'explain_document_sm',
            'da.explain.md': 'explain_document_md',
            'da.explain.lg': 'explain_document_lg',
            'da.ner': 'entity_recognizer_sm',
            'da.ner.sm': 'entity_recognizer_sm',
            'da.ner.md': 'entity_recognizer_md',
            'da.ner.lg': 'entity_recognizer_lg'},

        'nl': {
            'nl.explain': 'explain_document_sm',  # default
            'nl.explain.sm': 'explain_document_sm',
            'nl.explain.md': 'explain_document_md',
            'nl.explain.lg': 'explain_document_lg',
            'nl.ner': 'entity_recognizer_sm',
            # default,calling it nl.ner this makes creating actual NER object impossible!
            'nl.ner.sm': 'entity_recognizer_sm',
            'nl.ner.md': 'entity_recognizer_md',
            'nl.ner.lg': 'entity_recognizer_lg',
        },
        'en': {

            'en.classify': 'analyze_sentiment',  # default classifier
            'en.explain': 'explain_document_ml',  # default explain
            'en.explain.ml': 'explain_document_ml',
            'en.explain.dl': 'explain_document_dl',
            'en.ner': 'recognize_entities_dl',  # default ner
            'en.ner.conll': 'recognize_entities_dl',  # default ner

            'en.ner.dl': 'recognize_entities_dl',
            'en.ner.bert': 'recognize_entities_bert',
            # 'en.ner.onto': 'onto_recognize_entities_sm',  # default  ner.onto
            'en.ner.onto.sm': 'onto_recognize_entities_sm',
            'en.ner.onto.lg': 'onto_recognize_entities_lg',
            # 'en.match.datetime': 'match_datetime',
            'en.match.chunks': 'match_chunks',
            'en.clean.stop': 'clean_stop',
            # 'en.clean.pattern': 'clean_pattern',
            'en.clean.slang': 'clean_slang',
            'en.spell': 'check_spelling_dl',  # dfault spell

            'en.spell.dl': 'check_spelling_dl',
            'en.spell.context': 'check_spelling_dl',
            'en.sentiment': 'analyze_sentiment',
            'en.classify.sentiment': 'analyze_sentiment',

            'en.sentiment.imdb': 'analyze_sentimentdl_use_imdb',
            'en.sentiment.imdb.use': 'analyze_sentimentdl_use_imdb',
            # 'en.sentiment.twitter.use': 'analyze_sentimentdl_use_twitter',
            'en.sentiment.twitter': 'analyze_sentimentdl_use_twitter',
            # 'en.dependency': 'dependency_parse',

            # 2.7
            'en.ner.onto.bert.base': 'onto_recognize_entities_bert_base',
            'en.ner.onto.bert.large': 'onto_recognize_entities_bert_large',
            'en.ner.onto.bert.medium': 'onto_recognize_entities_bert_medium',
            'en.ner.onto.bert.mini': 'onto_recognize_entities_bert_mini',
            'en.ner.onto.bert.small': 'onto_recognize_entities_bert_small',
            'en.ner.onto.bert.tiny': 'onto_recognize_entities_bert_tiny',
            'en.ner.onto.electra.base': 'onto_recognize_entities_electra_base',
            'en.ner.onto.electra.small': 'onto_recognize_entities_electra_small',

            # 2.7.1 and 2.7.2
            "en.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.classify.trec50.component_list": "classifierdl_use_trec50_pipeline",
            "en.ner.onto.large": "onto_recognize_entities_electra_large",

        },
        'fa': {
            'fa.ner.dl': 'recognize_entities_dl',
        },
        'he': {
            'he.explain_document': 'explain_document_lg',
            'he.explain_document.lg': 'explain_document_lg',
        },
        'ko': {
            'ko.explain_document': 'explain_document_lg',
            'ko.explain_document.lg': 'explain_document_lg',

        },
        'sv': {
            'sv.explain': 'explain_document_sm',
            'sv.explain.sm': 'explain_document_sm',
            'sv.explain.md': 'explain_document_md',
            'sv.explain.lg': 'explain_document_lg',
            'sv.ner': 'entity_recognizer_sm',
            'sv.ner.sm': 'entity_recognizer_sm',
            'sv.ner.md': 'entity_recognizer_md',
            'sv.ner.lg': 'entity_recognizer_lg'},

        'fi': {
            'fi.explain': 'explain_document_sm',
            'fi.explain.sm': 'explain_document_sm',
            'fi.explain.md': 'explain_document_md',
            'fi.explain.lg': 'explain_document_lg',
            'fi.ner': 'entity_recognizer_sm',
            'fi.ner.sm': 'entity_recognizer_sm',
            'fi.ner.md': 'entity_recognizer_md',
            'fi.ner.lg': 'entity_recognizer_lg'},

        'fr': {
            'fr.explain': 'explain_document_lg',  # default fr explain
            'fr.explain.lg': 'explain_document_lg',
            'fr.explain.md': 'explain_document_md',
            'fr.ner': 'entity_recognizer_lg',  # default fr ner component_list
            'fr.ner.lg': 'entity_recognizer_lg',
            'fr.ner.md': 'entity_recognizer_md',
        },
        'de': {
            'de.explain.document': 'explain_document_md',  # default de explain
            'de.explain.document.md': 'explain_document_md',
            'de.explain.document.lg': 'explain_document_lg',
            'de.ner.recognizer': 'entity_recognizer_md',  # default de ner
            'de.ner.recognizer.md': 'entity_recognizer_md',
            'de.ner.recognizer.lg': 'entity_recognizer_lg',
        },
        'it': {
            'it.explain.document': 'explain_document_md',  # it default explain
            'it.explain.document.md': 'explain_document_md',
            'it.explain.document.lg': 'explain_document_lg',
            'it.ner': 'entity_recognizer_md',  # it default ner
            'it.ner.md': 'entity_recognizer_md',
            'it.ner.lg': 'entity_recognizer_lg',

        },
        'no': {
            'no.explain': 'explain_document_sm',  # default no explain
            'no.explain.sm': 'explain_document_sm',
            'no.explain.md': 'explain_document_md',
            'no.explain.lg': 'explain_document_lg',
            'no.ner': 'entity_recognizer_sm',  # default no ner
            'no.ner.sm': 'entity_recognizer_sm',
            'no.ner.md': 'entity_recognizer_md',
            'no.ner.lg': 'entity_recognizer_lg',
        },
        'pl': {
            'pl.explain': 'explain_document_sm',  # defaul pl explain
            'pl.explain.sm': 'explain_document_sm',
            'pl.explain.md': 'explain_document_md',
            'pl.explain.lg': 'explain_document_lg',
            'pl.ner': 'entity_recognizer_sm',  # default pl ner
            'pl.ner.sm': 'entity_recognizer_sm',
            'pl.ner.md': 'entity_recognizer_md',
            'pl.ner.lg': 'entity_recognizer_lg',
        },
        'pt': {
            'pt.explain': 'explain_document_sm',  # default explain pt
            'pt.explain.sm': 'explain_document_sm',
            'pt.explain.md': 'explain_document_md',
            'pt.explain.lg': 'explain_document_lg',
            'pt.ner': 'entity_recognizer_sm',  # default ner pt
            'pt.ner.sm': 'entity_recognizer_sm',
            'pt.ner.md': 'entity_recognizer_md',
            'pt.ner.lg': 'entity_recognizer_lg',

        },
        'ru': {
            'ru.explain': 'explain_document_sm',  # default ru explain
            'ru.explain.sm': 'explain_document_sm',
            'ru.explain.md': 'explain_document_md',
            'ru.explain.lg': 'explain_document_lg',
            'ru.ner': 'entity_recognizer_sm',  # default ru ner
            'ru.ner.sm': 'entity_recognizer_sm',
            'ru.ner.md': 'entity_recognizer_md',
            'ru.ner.lg': 'entity_recognizer_lg',
        },
        'es': {
            'es.explain': 'explain_document_sm',  # es expplain deflaut
            'es.explain.sm': 'explain_document_sm',
            'es.explain.md': 'explain_document_md',
            'es.explain.lg': 'explain_document_lg',
            'es.ner': 'entity_recognizer_sm',  # es ner default
            'es.ner.sm': 'entity_recognizer_sm',
            'es.ner.md': 'entity_recognizer_md',
            'es.ner.lg': 'entity_recognizer_lg',
        },
        'xx': {
            'lang': 'detect_language_375',  # default lang classifer
            'lang.7': 'detect_language_7',  # multi lang detector alias
            'lang.20': 'detect_language_20',  # multi lang detector alias
            'xx.classify.lang': 'detect_language_20',  # multi lang detector default
            'xx.classify.lang.20': 'detect_language_20',  # multi lang detector default
            'xx.classify.lang.7': 'detect_language_7',

            # 2.7 lang classifiers

            'xx.classify.lang': 'detect_language_375',  # default lang classifer
            'xx.classify.lang.21': 'detect_language_21',
            'xx.classify.lang.43': 'detect_language_43',
            'xx.classify.lang.95': 'detect_language_95',
            'xx.classify.lang.99': 'detect_language_99',
            'xx.classify.lang.220': 'detect_language_220',
            'xx.classify.lang.231': 'detect_language_231',
            'xx.classify.lang.bigru': 'detect_language_bigru_21',
            'lang.21': 'detect_language_21',
            'lang.43': 'detect_language_43',
            'lang.95': 'detect_language_95',
            'lang.99': 'detect_language_99',
            'lang.220': 'detect_language_220',
            'lang.231': 'detect_language_231',
            'lang.bigru': 'detect_language_bigru_21',

            # 2.7 marian translate component_list references
            "xx.zlw.translate_to.en": "translate_zlw_en",
            "xx.en.translate_to.ti": "translate_en_ti",
            "xx.bem.translate_to.en": "translate_bem_en",
            "xx.ny.translate_to.en": "translate_ny_en",
            "xx.en.translate_to.lu": "translate_en_lu",
            "xx.taw.translate_to.en": "translate_taw_en",
            "xx.en.translate_to.ga": "translate_en_ga",
            "xx.en.translate_to.sw": "translate_en_sw",
            "xx.war.translate_to.en": "translate_war_en",
            "xx.en.translate_to.hu": "translate_en_hu",
            "xx.pqe.translate_to.en": "translate_pqe_en",
            "xx.en.translate_to.bem": "translate_en_bem",
            "xx.en.translate_to.tiv": "translate_en_tiv",
            "xx.en.translate_to.tll": "translate_en_tll",
            "xx.en.translate_to.cpp": "translate_en_cpp",
            "xx.efi.translate_to.en": "translate_efi_en",
            "xx.en.translate_to.itc": "translate_en_itc",
            "xx.uk.translate_to.en": "translate_uk_en",
            "xx.ee.translate_to.en": "translate_ee_en",
            "xx.nso.translate_to.en": "translate_nso_en",
            "xx.urj.translate_to.en": "translate_urj_en",
            "xx.sv.translate_to.en": "translate_sv_en",
            "xx.en.translate_to.rn": "translate_en_rn",
            "xx.nic.translate_to.en": "translate_nic_en",
            "xx.en.translate_to.bcl": "translate_en_bcl",
            "xx.en.translate_to.lg": "translate_en_lg",
            "xx.kwy.translate_to.en": "translate_kwy_en",
            "xx.en.translate_to.gmq": "translate_en_gmq",
            "xx.en.translate_to.ts": "translate_en_ts",
            "xx.bnt.translate_to.en": "translate_bnt_en",
            "xx.en.translate_to.pis": "translate_en_pis",
            "xx.kwn.translate_to.en": "translate_kwn_en",
            "xx.fi.translate_to.en": "translate_fi_en",
            "xx.en.translate_to.gaa": "translate_en_gaa",
            "xx.afa.translate_to.en": "translate_afa_en",
            "xx.itc.translate_to.en": "translate_itc_en",
            "xx.mh.translate_to.en": "translate_mh_en",
            "xx.en.translate_to.ln": "translate_en_ln",
            "xx.en.translate_to.zls": "translate_en_zls",
            "xx.en.translate_to.cy": "translate_en_cy",
            "xx.et.translate_to.en": "translate_et_en",
            "xx.en.translate_to.dra": "translate_en_dra",
            "xx.en.translate_to.sn": "translate_en_sn",
            "xx.lua.translate_to.en": "translate_lua_en",
            "xx.ln.translate_to.en": "translate_ln_en",
            "xx.ja.translate_to.en": "translate_ja_en",
            "xx.loz.translate_to.en": "translate_loz_en",
            "xx.en.translate_to.bi": "translate_en_bi",
            "xx.mg.translate_to.en": "translate_mg_en",
            "xx.vi.translate_to.en": "translate_vi_en",
            "xx.en.translate_to.vi": "translate_en_vi",
            "xx.hy.translate_to.en": "translate_hy_en",
            "xx.en.translate_to.mt": "translate_en_mt",
            "xx.ng.translate_to.en": "translate_ng_en",
            "xx.mkh.translate_to.en": "translate_mkh_en",
            "xx.en.translate_to.cpf": "translate_en_cpf",
            "xx.wal.translate_to.en": "translate_wal_en",
            "xx.en.translate_to.crs": "translate_en_crs",
            "xx.en.translate_to.zle": "translate_en_zle",
            "xx.en.translate_to.phi": "translate_en_phi",
            "xx.ine.translate_to.en": "translate_ine_en",
            "xx.en.translate_to.pap": "translate_en_pap",
            "xx.en.translate_to.sit": "translate_en_sit",
            "xx.bg.translate_to.en": "translate_bg_en",
            "xx.en.translate_to.ml": "translate_en_ml",
            "xx.en.translate_to.ss": "translate_en_ss",
            "xx.en.translate_to.tw": "translate_en_tw",
            "xx.en.translate_to.gv": "translate_en_gv",
            "xx.ca.translate_to.en": "translate_ca_en",
            "xx.umb.translate_to.en": "translate_umb_en",
            "xx.alv.translate_to.en": "translate_alv_en",
            "xx.gem.translate_to.en": "translate_gem_en",
            "xx.chk.translate_to.en": "translate_chk_en",
            "xx.kqn.translate_to.en": "translate_kqn_en",
            "xx.en.translate_to.afa": "translate_en_afa",
            "xx.gl.translate_to.en": "translate_gl_en",
            "xx.en.translate_to.ber": "translate_en_ber",
            "xx.en.translate_to.ig": "translate_en_ig",
            "xx.ase.translate_to.en": "translate_ase_en",
            "xx.en.translate_to.cs": "translate_en_cs",
            "xx.en.translate_to.pag": "translate_en_pag",
            "xx.en.translate_to.nic": "translate_en_nic",
            "xx.en.translate_to.hil": "translate_en_hil",
            "xx.en.translate_to.cel": "translate_en_cel",
            "xx.nl.translate_to.en": "translate_nl_en",
            "xx.en.translate_to.ho": "translate_en_ho",
            "xx.en.translate_to.inc": "translate_en_inc",
            "xx.ts.translate_to.en": "translate_ts_en",
            "xx.en.translate_to.tl": "translate_en_tl",
            "xx.ve.translate_to.en": "translate_ve_en",
            "xx.ceb.translate_to.en": "translate_ceb_en",
            "xx.en.translate_to.iir": "translate_en_iir",
            "xx.en.translate_to.aav": "translate_en_aav",
            "xx.en.translate_to.bat": "translate_en_bat",
            "xx.en.translate_to.alv": "translate_en_alv",
            "xx.ar.translate_to.en": "translate_ar_en",
            "xx.fiu.translate_to.en": "translate_fiu_en",
            "xx.en.translate_to.eu": "translate_en_eu",
            "xx.is.translate_to.en": "translate_is_en",
            "xx.wa.translate_to.en": "translate_wa_en",
            "xx.en.translate_to.tn": "translate_en_tn",
            "xx.ig.translate_to.en": "translate_ig_en",
            "xx.luo.translate_to.en": "translate_luo_en",
            "xx.en.translate_to.kwn": "translate_en_kwn",
            "xx.niu.translate_to.en": "translate_niu_en",
            "xx.en.translate_to.gl": "translate_en_gl",
            "xx.en.translate_to.ilo": "translate_en_ilo",
            "xx.en.translate_to.ur": "translate_en_ur",
            "xx.cus.translate_to.en": "translate_cus_en",
            "xx.phi.translate_to.en": "translate_phi_en",
            "xx.en.translate_to.loz": "translate_en_loz",
            "xx.tiv.translate_to.en": "translate_tiv_en",
            "xx.en.translate_to.id": "translate_en_id",
            "xx.zle.translate_to.en": "translate_zle_en",
            "xx.en.translate_to.mfe": "translate_en_mfe",
            "xx.id.translate_to.en": "translate_id_en",
            "xx.lv.translate_to.en": "translate_lv_en",
            "xx.en.translate_to.pon": "translate_en_pon",
            "xx.en.translate_to.sq": "translate_en_sq",
            "xx.tum.translate_to.en": "translate_tum_en",
            "xx.pl.translate_to.en": "translate_pl_en",
            "xx.xh.translate_to.en": "translate_xh_en",
            "xx.kab.translate_to.en": "translate_kab_en",
            "xx.tvl.translate_to.en": "translate_tvl_en",
            "xx.pa.translate_to.en": "translate_pa_en",
            "xx.iso.translate_to.en": "translate_iso_en",
            "xx.ho.translate_to.en": "translate_ho_en",
            "xx.cel.translate_to.en": "translate_cel_en",
            "xx.en.translate_to.om": "translate_en_om",
            "xx.kg.translate_to.en": "translate_kg_en",
            "xx.en.translate_to.lus": "translate_en_lus",
            "xx.om.translate_to.en": "translate_om_en",
            "xx.lun.translate_to.en": "translate_lun_en",
            "xx.crs.translate_to.en": "translate_crs_en",
            "xx.cy.translate_to.en": "translate_cy_en",
            "xx.tll.translate_to.en": "translate_tll_en",
            "xx.gil.translate_to.en": "translate_gil_en",
            "xx.en.translate_to.mkh": "translate_en_mkh",
            "xx.en.translate_to.euq": "translate_en_euq",
            "xx.en.translate_to.sem": "translate_en_sem",
            "xx.cs.translate_to.en": "translate_cs_en",
            "xx.en.translate_to.sk": "translate_en_sk",
            "xx.en.translate_to.bzs": "translate_en_bzs",
            "xx.en.translate_to.trk": "translate_en_trk",
            "xx.cpf.translate_to.en": "translate_cpf_en",
            "xx.bi.translate_to.en": "translate_bi_en",
            "xx.en.translate_to.mul": "translate_en_mul",
            "xx.en.translate_to.gmw": "translate_en_gmw",
            "xx.en.translate_to.fi": "translate_en_fi",
            "xx.en.translate_to.zlw": "translate_en_zlw",
            "xx.lg.translate_to.en": "translate_lg_en",
            "xx.en.translate_to.pqe": "translate_en_pqe",
            "xx.en.translate_to.xh": "translate_en_xh",
            "xx.en.translate_to.hi": "translate_en_hi",
            "xx.en.translate_to.nyk": "translate_en_nyk",
            "xx.th.translate_to.en": "translate_th_en",
            "xx.en.translate_to.umb": "translate_en_umb",
            "xx.en.translate_to.af": "translate_en_af",
            "xx.tpi.translate_to.en": "translate_tpi_en",
            "xx.ti.translate_to.en": "translate_ti_en",
            "xx.en.translate_to.chk": "translate_en_chk",
            "xx.mos.translate_to.en": "translate_mos_en",
            "xx.en.translate_to.sm": "translate_en_sm",
            "xx.pon.translate_to.en": "translate_pon_en",
            "xx.en.translate_to.bg": "translate_en_bg",
            "xx.en.translate_to.ny": "translate_en_ny",
            "xx.kl.translate_to.en": "translate_kl_en",
            "xx.en.translate_to.hy": "translate_en_hy",
            "xx.nyk.translate_to.en": "translate_nyk_en",
            "xx.it.translate_to.en": "translate_it_en",
            "xx.mt.translate_to.en": "translate_mt_en",
            "xx.pap.translate_to.en": "translate_pap_en",
            "xx.srn.translate_to.en": "translate_srn_en",
            "xx.da.translate_to.en": "translate_da_en",
            "xx.en.translate_to.lue": "translate_en_lue",
            "xx.rn.translate_to.en": "translate_rn_en",
            "xx.en.translate_to.tut": "translate_en_tut",
            "xx.lu.translate_to.en": "translate_lu_en",
            "xx.ru.translate_to.en": "translate_ru_en",
            "xx.en.translate_to.toi": "translate_en_toi",
            "xx.ccs.translate_to.en": "translate_ccs_en",
            "xx.aav.translate_to.en": "translate_aav_en",
            "xx.en.translate_to.ha": "translate_en_ha",
            "xx.rnd.translate_to.en": "translate_rnd_en",
            "xx.de.translate_to.en": "translate_de_en",
            "xx.en.translate_to.luo": "translate_en_luo",
            "xx.fr.translate_to.en": "translate_fr_en",
            "xx.bcl.translate_to.en": "translate_bcl_en",
            "xx.ilo.translate_to.en": "translate_ilo_en",
            "xx.en.translate_to.jap": "translate_en_jap",
            "xx.en.translate_to.fj": "translate_en_fj",
            "xx.sk.translate_to.en": "translate_sk_en",
            "xx.bzs.translate_to.en": "translate_bzs_en",
            "xx.ka.translate_to.en": "translate_ka_en",
            "xx.ko.translate_to.en": "translate_ko_en",
            "xx.sq.translate_to.en": "translate_sq_en",
            "xx.mul.translate_to.en": "translate_mul_en",
            "xx.en.translate_to.run": "translate_en_run",
            "xx.sn.translate_to.en": "translate_sn_en",
            "xx.en.translate_to.pqw": "translate_en_pqw",
            "xx.ss.translate_to.en": "translate_ss_en",
            "xx.sm.translate_to.en": "translate_sm_en",
            "xx.en.translate_to.kwy": "translate_en_kwy",
            "xx.jap.translate_to.en": "translate_jap_en",
            "xx.en.translate_to.kqn": "translate_en_kqn",
            "xx.mk.translate_to.en": "translate_mk_en",
            "xx.hu.translate_to.en": "translate_hu_en",
            "xx.en.translate_to.map": "translate_en_map",
            "xx.yo.translate_to.en": "translate_yo_en",
            "xx.hi.translate_to.en": "translate_hi_en",
            "xx.iir.translate_to.en": "translate_iir_en",
            "xx.en.translate_to.guw": "translate_en_guw",
            "xx.en.translate_to.es": "translate_en_es",
            "xx.en.translate_to.gem": "translate_en_gem",
            "xx.en.translate_to.ht": "translate_en_ht",
            "xx.zls.translate_to.en": "translate_zls_en",
            "xx.sg.translate_to.en": "translate_sg_en",
            "xx.en.translate_to.ty": "translate_en_ty",
            "xx.en.translate_to.lun": "translate_en_lun",
            "xx.guw.translate_to.en": "translate_guw_en",
            "xx.trk.translate_to.en": "translate_trk_en",
            "xx.mfe.translate_to.en": "translate_mfe_en",
            "xx.en.translate_to.nl": "translate_en_nl",
            "xx.en.translate_to.sv": "translate_en_sv",
            "xx.ber.translate_to.en": "translate_ber_en",
            "xx.to.translate_to.en": "translate_to_en",
            "xx.en.translate_to.da": "translate_en_da",
            "xx.en.translate_to.urj": "translate_en_urj",
            "xx.inc.translate_to.en": "translate_inc_en",
            "xx.wls.translate_to.en": "translate_wls_en",
            "xx.pis.translate_to.en": "translate_pis_en",
            "xx.en.translate_to.mh": "translate_en_mh",
            "xx.en.translate_to.iso": "translate_en_iso",
            "xx.en.translate_to.ru": "translate_en_ru",
            "xx.swc.translate_to.en": "translate_swc_en",
            "xx.en.translate_to.rnd": "translate_en_rnd",
            "xx.en.translate_to.nso": "translate_en_nso",
            "xx.en.translate_to.swc": "translate_en_swc",
            "xx.ur.translate_to.en": "translate_ur_en",
            "xx.en.translate_to.ro": "translate_en_ro",
            "xx.ml.translate_to.en": "translate_ml_en",
            "xx.grk.translate_to.en": "translate_grk_en",
            "xx.rw.translate_to.en": "translate_rw_en",
            "xx.tr.translate_to.en": "translate_tr_en",
            "xx.gmq.translate_to.en": "translate_gmq_en",
            "xx.euq.translate_to.en": "translate_euq_en",
            "xx.en.translate_to.tdt": "translate_en_tdt",
            "xx.eo.translate_to.en": "translate_eo_en",
            "xx.cau.translate_to.en": "translate_cau_en",
            "xx.en.translate_to.mk": "translate_en_mk",
            "xx.en.translate_to.mr": "translate_en_mr",
            "xx.af.translate_to.en": "translate_af_en",
            "xx.run.translate_to.en": "translate_run_en",
            "xx.en.translate_to.ng": "translate_en_ng",
            "xx.en.translate_to.mg": "translate_en_mg",
            "xx.en.translate_to.bnt": "translate_en_bnt",
            "xx.en.translate_to.kj": "translate_en_kj",
            "xx.en.translate_to.he": "translate_en_he",
            "xx.en.translate_to.sla": "translate_en_sla",
            "xx.en.translate_to.el": "translate_en_el",
            "xx.ht.translate_to.en": "translate_ht_en",
            "xx.en.translate_to.et": "translate_en_et",
            "xx.en.translate_to.poz": "translate_en_poz",
            "xx.roa.translate_to.en": "translate_roa_en",
            "xx.en.translate_to.de": "translate_en_de",
            "xx.fj.translate_to.en": "translate_fj_en",
            "xx.en.translate_to.lua": "translate_en_lua",
            "xx.en.translate_to.kg": "translate_en_kg",
            "xx.en.translate_to.fiu": "translate_en_fiu",
            "xx.gv.translate_to.en": "translate_gv_en",
            "xx.cpp.translate_to.en": "translate_cpp_en",
            "xx.en.translate_to.tpi": "translate_en_tpi",
            "xx.en.translate_to.grk": "translate_en_grk",
            "xx.en.translate_to.sal": "translate_en_sal",
            "xx.en.translate_to.niu": "translate_en_niu",
            "xx.en.translate_to.ca": "translate_en_ca",
            "xx.en.translate_to.roa": "translate_en_roa",
            "xx.sal.translate_to.en": "translate_sal_en",
            "xx.ha.translate_to.en": "translate_ha_en",
            "xx.sem.translate_to.en": "translate_sem_en",
            "xx.tn.translate_to.en": "translate_tn_en",
            "xx.gaa.translate_to.en": "translate_gaa_en",
            "xx.en.translate_to.to": "translate_en_to",
            "xx.en.translate_to.ee": "translate_en_ee",
            "xx.toi.translate_to.en": "translate_toi_en",
            "xx.lue.translate_to.en": "translate_lue_en",
            "xx.en.translate_to.rw": "translate_en_rw",
            "xx.st.translate_to.en": "translate_st_en",
            "xx.dra.translate_to.en": "translate_dra_en",
            "xx.en.translate_to.mos": "translate_en_mos",
            "xx.eu.translate_to.en": "translate_eu_en",
            "xx.lus.translate_to.en": "translate_lus_en",
            "xx.sla.translate_to.en": "translate_sla_en",
            "xx.en.translate_to.ceb": "translate_en_ceb",
            "xx.art.translate_to.en": "translate_art_en",
            "xx.bat.translate_to.en": "translate_bat_en",
            "xx.az.translate_to.en": "translate_az_en",
            "xx.en.translate_to.ine": "translate_en_ine",
            "xx.pag.translate_to.en": "translate_pag_en",
            "xx.yap.translate_to.en": "translate_yap_en",
            "xx.en.translate_to.eo": "translate_en_eo",
            "xx.en.translate_to.tvl": "translate_en_tvl",
            "xx.kj.translate_to.en": "translate_kj_en",
            "xx.en.translate_to.st": "translate_en_st",
            "xx.gmw.translate_to.en": "translate_gmw_en",
            "xx.mr.translate_to.en": "translate_mr_en",
            "xx.es.translate_to.en": "translate_es_en",
            "xx.en.translate_to.sg": "translate_en_sg",
            "xx.en.translate_to.cus": "translate_en_cus",
            "xx.en.translate_to.it": "translate_en_it",
            "xx.ga.translate_to.en": "translate_ga_en",
            "xx.bn.translate_to.en": "translate_bn_en",
            "xx.en.translate_to.efi": "translate_en_efi",
            "xx.en.translate_to.az": "translate_en_az",
            "xx.en.translate_to.zh": "translate_en_zh",
            "xx.en.translate_to.is": "translate_en_is",
            "xx.zh.translate_to.en": "translate_zh_en",
            "xx.hil.translate_to.en": "translate_hil_en",
            "xx.en.translate_to.ar": "translate_en_ar",
            "xx.tl.translate_to.en": "translate_tl_en",
            "xx.en.translate_to.gil": "translate_en_gil",
            "xx.en.translate_to.uk": "translate_en_uk",
            "xx.en.translate_to.fr": "translate_en_fr",
            # 3.1 Translator Pipe references

            "xx.es.translate_to.af": "translate_af_es",
            "xx.nl.translate_to.af": "translate_af_nl",
            "xx.eo.translate_to.af": "translate_af_eo",
            "xx.afa.translate_to.afa": "translate_afa_afa",
            "xx.sv.translate_to.af": "translate_af_sv",
            "xx.es.translate_to.aed": "translate_aed_es",
            "xx.fr.translate_to.af": "translate_af_fr",
            "xx.fi.translate_to.af": "translate_af_fi",
            "xx.de.translate_to.af": "translate_af_de",
            "xx.ru.translate_to.af": "translate_af_ru",
            "xx.es.translate_to.az": "translate_az_es",
            "xx.de.translate_to.bcl": "translate_bcl_de",
            "xx.sv.translate_to.bem": "translate_bem_sv",
            "xx.tr.translate_to.az": "translate_az_tr",
            "xx.sv.translate_to.bcl": "translate_bcl_sv",
            "xx.es.translate_to.ar": "translate_ar_es",
            "xx.es.translate_to.bem": "translate_bem_es",
            "xx.ru.translate_to.ar": "translate_ar_ru",
            "xx.es.translate_to.be": "translate_be_es",
            "xx.fr.translate_to.bem": "translate_bem_fr",
            "xx.he.translate_to.ar": "translate_ar_he",
            "xx.es.translate_to.bcl": "translate_bcl_es",
            "xx.es.translate_to.ase": "translate_ase_es",
            "xx.de.translate_to.ar": "translate_ar_de",
            "xx.pl.translate_to.ar": "translate_ar_pl",
            "xx.tr.translate_to.ar": "translate_ar_tr",
            "xx.sv.translate_to.ase": "translate_ase_sv",
            "xx.fi.translate_to.bcl": "translate_bcl_fi",
            "xx.el.translate_to.ar": "translate_ar_el",
            "xx.fr.translate_to.bcl": "translate_bcl_fr",
            "xx.fi.translate_to.bem": "translate_bem_fi",
            "xx.fr.translate_to.ase": "translate_ase_fr",
            "xx.fr.translate_to.ar": "translate_ar_fr",
            "xx.eo.translate_to.ar": "translate_ar_eo",
            "xx.it.translate_to.ar": "translate_ar_it",
            "xx.sv.translate_to.am": "translate_am_sv",
            "xx.de.translate_to.ase": "translate_ase_de",
            "xx.uk.translate_to.bg": "translate_bg_uk",
            "xx.it.translate_to.bg": "translate_bg_it",
            "xx.sv.translate_to.bzs": "translate_bzs_sv",
            "xx.pt.translate_to.ca": "translate_ca_pt",
            "xx.es.translate_to.ber": "translate_ber_es",
            "xx.it.translate_to.ca": "translate_ca_it",
            "xx.eo.translate_to.bg": "translate_bg_eo",
            "xx.sv.translate_to.ceb": "translate_ceb_sv",
            "xx.fr.translate_to.bi": "translate_bi_fr",
            "xx.sv.translate_to.bg": "translate_bg_sv",
            "xx.fr.translate_to.ca": "translate_ca_fr",
            "xx.tr.translate_to.bg": "translate_bg_tr",
            "xx.es.translate_to.ceb": "translate_ceb_es",
            "xx.de.translate_to.ca": "translate_ca_de",
            "xx.fi.translate_to.ceb": "translate_ceb_fi",
            "xx.es.translate_to.ca": "translate_ca_es",
            "xx.es.translate_to.bg": "translate_bg_es",
            "xx.uk.translate_to.ca": "translate_ca_uk",
            "xx.sv.translate_to.bi": "translate_bi_sv",
            "xx.sv.translate_to.chk": "translate_chk_sv",
            "xx.fr.translate_to.ceb": "translate_ceb_fr",
            "xx.es.translate_to.bzs": "translate_bzs_es",
            "xx.de.translate_to.crs": "translate_crs_de",
            "xx.nl.translate_to.ca": "translate_ca_nl",
            "xx.es.translate_to.chk": "translate_chk_es",
            "xx.fr.translate_to.ber": "translate_ber_fr",
            "xx.fi.translate_to.bzs": "translate_bzs_fi",
            "xx.es.translate_to.crs": "translate_crs_es",
            "xx.fi.translate_to.bg": "translate_bg_fi",
            "xx.cpp.translate_to.cpp": "translate_cpp_cpp",
            "xx.de.translate_to.bg": "translate_bg_de",
            "xx.es.translate_to.bi": "translate_bi_es",
            "xx.fr.translate_to.bzs": "translate_bzs_fr",
            "xx.fr.translate_to.bg": "translate_bg_fr",
            "xx.fr.translate_to.chk": "translate_chk_fr",
            "xx.ru.translate_to.bg": "translate_bg_ru",
            "xx.fi.translate_to.cs": "translate_cs_fi",
            "xx.ha.translate_to.de": "translate_de_ha",
            "xx.ee.translate_to.de": "translate_de_ee",
            "xx.eo.translate_to.de": "translate_de_eo",
            "xx.gil.translate_to.de": "translate_de_gil",
            "xx.fj.translate_to.de": "translate_de_fj",
            "xx.fr.translate_to.de": "translate_de_fr",
            "xx.sv.translate_to.cs": "translate_cs_sv",
            "xx.es.translate_to.csn": "translate_csn_es",
            "xx.ru.translate_to.da": "translate_da_ru",
            "xx.no.translate_to.da": "translate_da_no",
            "xx.iso.translate_to.de": "translate_de_iso",
            "xx.eu.translate_to.de": "translate_de_eu",
            "xx.nl.translate_to.de": "translate_de_nl",
            "xx.ilo.translate_to.de": "translate_de_ilo",
            "xx.hr.translate_to.de": "translate_de_hr",
            "xx.mt.translate_to.de": "translate_de_mt",
            "xx.es.translate_to.da": "translate_da_es",
            "xx.ar.translate_to.de": "translate_de_ar",
            "xx.is.translate_to.de": "translate_de_is",
            "xx.sv.translate_to.crs": "translate_crs_sv",
            "xx.fr.translate_to.da": "translate_da_fr",
            "xx.gaa.translate_to.de": "translate_de_gaa",
            "xx.niu.translate_to.de": "translate_de_niu",
            "xx.da.translate_to.de": "translate_de_da",
            "xx.de.translate_to.da": "translate_da_de",
            "xx.ase.translate_to.de": "translate_de_ase",
            "xx.ig.translate_to.de": "translate_de_ig",
            "xx.lua.translate_to.de": "translate_de_lua",
            "xx.de.translate_to.de": "translate_de_de",
            "xx.bi.translate_to.de": "translate_de_bi",
            "xx.fr.translate_to.cs": "translate_cs_fr",
            "xx.ms.translate_to.de": "translate_de_ms",
            "xx.fi.translate_to.crs": "translate_crs_fi",
            "xx.eo.translate_to.da": "translate_da_eo",
            "xx.af.translate_to.de": "translate_de_af",
            "xx.uk.translate_to.cs": "translate_cs_uk",
            "xx.bg.translate_to.de": "translate_de_bg",
            "xx.no.translate_to.de": "translate_de_no",
            "xx.de.translate_to.cs": "translate_cs_de",
            "xx.it.translate_to.de": "translate_de_it",
            "xx.ho.translate_to.de": "translate_de_ho",
            "xx.ln.translate_to.de": "translate_de_ln",
            "xx.guw.translate_to.de": "translate_de_guw",
            "xx.efi.translate_to.de": "translate_de_efi",
            "xx.hil.translate_to.de": "translate_de_hil",
            "xx.cs.translate_to.de": "translate_de_cs",
            "xx.es.translate_to.csg": "translate_csg_es",
            "xx.es.translate_to.de": "translate_de_es",
            "xx.bcl.translate_to.de": "translate_de_bcl",
            "xx.ht.translate_to.de": "translate_de_ht",
            "xx.loz.translate_to.de": "translate_de_loz",
            "xx.kg.translate_to.de": "translate_de_kg",
            "xx.eo.translate_to.cs": "translate_cs_eo",
            "xx.el.translate_to.de": "translate_de_el",
            "xx.fi.translate_to.de": "translate_de_fi",
            "xx.he.translate_to.de": "translate_de_he",
            "xx.bzs.translate_to.de": "translate_de_bzs",
            "xx.fr.translate_to.crs": "translate_crs_fr",
            "xx.crs.translate_to.de": "translate_de_crs",
            "xx.fi.translate_to.da": "translate_da_fi",
            "xx.hu.translate_to.de": "translate_de_hu",
            "xx.et.translate_to.de": "translate_de_et",
            "xx.lt.translate_to.de": "translate_de_lt",
            "xx.ca.translate_to.de": "translate_de_ca",
            "xx.pl.translate_to.de": "translate_de_pl",
            "xx.sv.translate_to.el": "translate_el_sv",
            "xx.de.translate_to.ee": "translate_ee_de",
            "xx.pag.translate_to.de": "translate_de_pag",
            "xx.ar.translate_to.el": "translate_el_ar",
            "xx.nso.translate_to.de": "translate_de_nso",
            "xx.pon.translate_to.de": "translate_de_pon",
            "xx.pap.translate_to.de": "translate_de_pap",
            "xx.fr.translate_to.efi": "translate_efi_fr",
            "xx.pis.translate_to.de": "translate_de_pis",
            "xx.de.translate_to.efi": "translate_efi_de",
            "xx.eo.translate_to.el": "translate_el_eo",
            "xx.fi.translate_to.ee": "translate_ee_fi",
            "xx.es.translate_to.ee": "translate_ee_es",
            "xx.fr.translate_to.ee": "translate_ee_fr",
            "xx.fi.translate_to.efi": "translate_efi_fi",
            "xx.fr.translate_to.el": "translate_el_fr",
            "xx.tl.translate_to.de": "translate_de_tl",
            "xx.ny.translate_to.de": "translate_de_ny",
            "xx.uk.translate_to.de": "translate_de_uk",
            "xx.sv.translate_to.efi": "translate_efi_sv",
            "xx.sv.translate_to.ee": "translate_ee_sv",
            "xx.vi.translate_to.de": "translate_de_vi",
            "xx.fi.translate_to.el": "translate_el_fi",
            "xx.cs.translate_to.eo": "translate_eo_cs",
            "xx.bzs.translate_to.es": "translate_es_bzs",
            "xx.he.translate_to.eo": "translate_eo_he",
            "xx.hu.translate_to.eo": "translate_eo_hu",
            "xx.ro.translate_to.eo": "translate_eo_ro",
            "xx.ber.translate_to.es": "translate_es_ber",
            "xx.ca.translate_to.es": "translate_es_ca",
            "xx.bcl.translate_to.es": "translate_es_bcl",
            "xx.ceb.translate_to.es": "translate_es_ceb",
            "xx.da.translate_to.eo": "translate_eo_da",
            "xx.bi.translate_to.es": "translate_es_bi",
            "xx.ee.translate_to.es": "translate_es_ee",
            "xx.ru.translate_to.eo": "translate_eo_ru",
            "xx.csg.translate_to.es": "translate_es_csg",
            "xx.fi.translate_to.eo": "translate_eo_fi",
            "xx.it.translate_to.eo": "translate_eo_it",
            "xx.nl.translate_to.eo": "translate_eo_nl",
            "xx.et.translate_to.es": "translate_es_et",
            "xx.bg.translate_to.es": "translate_es_bg",
            "xx.de.translate_to.eo": "translate_eo_de",
            "xx.ar.translate_to.es": "translate_es_ar",
            "xx.cs.translate_to.es": "translate_es_cs",
            "xx.aed.translate_to.es": "translate_es_aed",
            "xx.ase.translate_to.es": "translate_es_ase",
            "xx.el.translate_to.es": "translate_es_el",
            "xx.eo.translate_to.es": "translate_es_eo",
            "xx.af.translate_to.eo": "translate_eo_af",
            "xx.af.translate_to.es": "translate_es_af",
            "xx.pl.translate_to.eo": "translate_eo_pl",
            "xx.de.translate_to.es": "translate_es_de",
            "xx.es.translate_to.eo": "translate_eo_es",
            "xx.da.translate_to.es": "translate_es_da",
            "xx.crs.translate_to.es": "translate_es_crs",
            "xx.pt.translate_to.eo": "translate_eo_pt",
            "xx.eu.translate_to.es": "translate_es_eu",
            "xx.es.translate_to.es": "translate_es_es",
            "xx.csn.translate_to.es": "translate_es_csn",
            "xx.sv.translate_to.eo": "translate_eo_sv",
            "xx.efi.translate_to.es": "translate_es_efi",
            "xx.sh.translate_to.eo": "translate_eo_sh",
            "xx.bg.translate_to.eo": "translate_eo_bg",
            "xx.fr.translate_to.eo": "translate_eo_fr",
            "xx.el.translate_to.eo": "translate_eo_el",
            "xx.pl.translate_to.es": "translate_es_pl",
            "xx.ro.translate_to.es": "translate_es_ro",
            "xx.is.translate_to.es": "translate_es_is",
            "xx.ln.translate_to.es": "translate_es_ln",
            "xx.to.translate_to.es": "translate_es_to",
            "xx.no.translate_to.es": "translate_es_no",
            "xx.nl.translate_to.es": "translate_es_nl",
            "xx.pag.translate_to.es": "translate_es_pag",
            "xx.tvl.translate_to.es": "translate_es_tvl",
            "xx.fr.translate_to.es": "translate_es_fr",
            "xx.he.translate_to.es": "translate_es_he",
            "xx.lus.translate_to.es": "translate_es_lus",
            "xx.hil.translate_to.es": "translate_es_hil",
            "xx.ny.translate_to.es": "translate_es_ny",
            "xx.pap.translate_to.es": "translate_es_pap",
            "xx.id.translate_to.es": "translate_es_id",
            "xx.wls.translate_to.es": "translate_es_wls",
            "xx.gaa.translate_to.es": "translate_es_gaa",
            "xx.nso.translate_to.es": "translate_es_nso",
            "xx.mk.translate_to.es": "translate_es_mk",
            "xx.mt.translate_to.es": "translate_es_mt",
            "xx.pis.translate_to.es": "translate_es_pis",
            "xx.gl.translate_to.es": "translate_es_gl",
            "xx.sn.translate_to.es": "translate_es_sn",
            "xx.hr.translate_to.es": "translate_es_hr",
            "xx.swc.translate_to.es": "translate_es_swc",
            "xx.lua.translate_to.es": "translate_es_lua",
            "xx.it.translate_to.es": "translate_es_it",
            "xx.fj.translate_to.es": "translate_es_fj",
            "xx.gil.translate_to.es": "translate_es_gil",
            "xx.sm.translate_to.es": "translate_es_sm",
            "xx.guw.translate_to.es": "translate_es_guw",
            "xx.kg.translate_to.es": "translate_es_kg",
            "xx.tl.translate_to.es": "translate_es_tl",
            "xx.rn.translate_to.es": "translate_es_rn",
            "xx.mfs.translate_to.es": "translate_es_mfs",
            "xx.iso.translate_to.es": "translate_es_iso",
            "xx.loz.translate_to.es": "translate_es_loz",
            "xx.tpi.translate_to.es": "translate_es_tpi",
            "xx.ha.translate_to.es": "translate_es_ha",
            "xx.ht.translate_to.es": "translate_es_ht",
            "xx.uk.translate_to.es": "translate_es_uk",
            "xx.tw.translate_to.es": "translate_es_tw",
            "xx.st.translate_to.es": "translate_es_st",
            "xx.sg.translate_to.es": "translate_es_sg",
            "xx.ilo.translate_to.es": "translate_es_ilo",
            "xx.ru.translate_to.es": "translate_es_ru",
            "xx.yo.translate_to.es": "translate_es_yo",
            "xx.pon.translate_to.es": "translate_es_pon",
            "xx.niu.translate_to.es": "translate_es_niu",
            "xx.lt.translate_to.es": "translate_es_lt",
            "xx.ty.translate_to.es": "translate_es_ty",
            "xx.ig.translate_to.es": "translate_es_ig",
            "xx.tzo.translate_to.es": "translate_es_tzo",
            "xx.rw.translate_to.es": "translate_es_rw",
            "xx.war.translate_to.es": "translate_es_war",
            "xx.tll.translate_to.es": "translate_es_tll",
            "xx.prl.translate_to.es": "translate_es_prl",
            "xx.xh.translate_to.es": "translate_es_xh",
            "xx.yua.translate_to.es": "translate_es_yua",
            "xx.ho.translate_to.es": "translate_es_ho",
            "xx.ve.translate_to.es": "translate_es_ve",
            "xx.sl.translate_to.es": "translate_es_sl",
            "xx.tn.translate_to.es": "translate_es_tn",
            "xx.vi.translate_to.es": "translate_es_vi",
            "xx.srn.translate_to.es": "translate_es_srn",
            "xx.fi.translate_to.es": "translate_es_fi",
            "xx.lua.translate_to.fi": "translate_fi_lua",
            "xx.ny.translate_to.fi": "translate_fi_ny",
            "xx.pon.translate_to.fi": "translate_fi_pon",
            "xx.crs.translate_to.fi": "translate_fi_crs",
            "xx.nso.translate_to.fi": "translate_fi_nso",
            "xx.iso.translate_to.fi": "translate_fi_iso",
            "xx.kqn.translate_to.fi": "translate_fi_kqn",
            "xx.gaa.translate_to.fi": "translate_fi_gaa",
            "xx.ru.translate_to.eu": "translate_eu_ru",
            "xx.eo.translate_to.fi": "translate_fi_eo",
            "xx.ig.translate_to.fi": "translate_fi_ig",
            "xx.bem.translate_to.fi": "translate_fi_bem",
            "xx.es.translate_to.et": "translate_et_es",
            "xx.fj.translate_to.fi": "translate_fi_fj",
            "xx.et.translate_to.fi": "translate_fi_et",
            "xx.bcl.translate_to.fi": "translate_fi_bcl",
            "xx.fi.translate_to.fi": "translate_fi_fi",
            "xx.el.translate_to.fi": "translate_fi_el",
            "xx.efi.translate_to.fi": "translate_fi_efi",
            "xx.ht.translate_to.fi": "translate_fi_ht",
            "xx.ceb.translate_to.fi": "translate_fi_ceb",
            "xx.lg.translate_to.fi": "translate_fi_lg",
            "xx.pap.translate_to.fi": "translate_fi_pap",
            "xx.kg.translate_to.fi": "translate_fi_kg",
            "xx.ee.translate_to.fi": "translate_fi_ee",
            "xx.lv.translate_to.fi": "translate_fi_lv",
            "xx.fr.translate_to.et": "translate_et_fr",
            "xx.de.translate_to.et": "translate_et_de",
            "xx.bzs.translate_to.fi": "translate_fi_bzs",
            "xx.mos.translate_to.fi": "translate_fi_mos",
            "xx.zh.translate_to.es": "translate_es_zh",
            "xx.id.translate_to.fi": "translate_fi_id",
            "xx.gil.translate_to.fi": "translate_fi_gil",
            "xx.pis.translate_to.fi": "translate_fi_pis",
            "xx.no.translate_to.fi": "translate_fi_no",
            "xx.it.translate_to.fi": "translate_fi_it",
            "xx.es.translate_to.fi": "translate_fi_es",
            "xx.ha.translate_to.fi": "translate_fi_ha",
            "xx.fr.translate_to.fi": "translate_fi_fr",
            "xx.de.translate_to.fi": "translate_fi_de",
            "xx.bg.translate_to.fi": "translate_fi_bg",
            "xx.zai.translate_to.es": "translate_es_zai",
            "xx.hil.translate_to.fi": "translate_fi_hil",
            "xx.cs.translate_to.fi": "translate_fi_cs",
            "xx.es.translate_to.eu": "translate_eu_es",
            "xx.ilo.translate_to.fi": "translate_fi_ilo",
            "xx.pag.translate_to.fi": "translate_fi_pag",
            "xx.ln.translate_to.fi": "translate_fi_ln",
            "xx.sv.translate_to.et": "translate_et_sv",
            "xx.niu.translate_to.fi": "translate_fi_niu",
            "xx.hr.translate_to.fi": "translate_fi_hr",
            "xx.de.translate_to.eu": "translate_eu_de",
            "xx.lus.translate_to.fi": "translate_fi_lus",
            "xx.ru.translate_to.et": "translate_et_ru",
            "xx.af.translate_to.fi": "translate_fi_af",
            "xx.mh.translate_to.fi": "translate_fi_mh",
            "xx.guw.translate_to.fi": "translate_fi_guw",
            "xx.mfe.translate_to.fi": "translate_fi_mfe",
            "xx.ho.translate_to.fi": "translate_fi_ho",
            "xx.fse.translate_to.fi": "translate_fi_fse",
            "xx.lu.translate_to.fi": "translate_fi_lu",
            "xx.hu.translate_to.fi": "translate_fi_hu",
            "xx.mk.translate_to.fi": "translate_fi_mk",
            "xx.nl.translate_to.fi": "translate_fi_nl",
            "xx.mg.translate_to.fi": "translate_fi_mg",
            "xx.mt.translate_to.fi": "translate_fi_mt",
            "xx.he.translate_to.fi": "translate_fi_he",
            "xx.fi.translate_to.et": "translate_et_fi",
            "xx.is.translate_to.fi": "translate_fi_is",
            "xx.lue.translate_to.fi": "translate_fi_lue",
            "xx.guw.translate_to.fr": "translate_fr_guw",
            "xx.ber.translate_to.fr": "translate_fr_ber",
            "xx.uk.translate_to.fi": "translate_fi_uk",
            "xx.efi.translate_to.fr": "translate_fr_efi",
            "xx.tr.translate_to.fi": "translate_fi_tr",
            "xx.tn.translate_to.fi": "translate_fi_tn",
            "xx.es.translate_to.fr": "translate_fr_es",
            "xx.srn.translate_to.fi": "translate_fi_srn",
            "xx.bcl.translate_to.fr": "translate_fr_bcl",
            "xx.sl.translate_to.fi": "translate_fi_sl",
            "xx.ht.translate_to.fr": "translate_fr_ht",
            "xx.zne.translate_to.fi": "translate_fi_zne",
            "xx.de.translate_to.fr": "translate_fr_de",
            "xx.war.translate_to.fi": "translate_fi_war",
            "xx.tpi.translate_to.fi": "translate_fi_tpi",
            "xx.ca.translate_to.fr": "translate_fr_ca",
            "xx.yap.translate_to.fi": "translate_fi_yap",
            "xx.sn.translate_to.fi": "translate_fi_sn",
            "xx.hr.translate_to.fr": "translate_fr_hr",
            "xx.gil.translate_to.fr": "translate_fr_gil",
            "xx.id.translate_to.fr": "translate_fr_id",
            "xx.sv.translate_to.fi": "translate_fi_sv",
            "xx.toi.translate_to.fi": "translate_fi_toi",
            "xx.sk.translate_to.fi": "translate_fi_sk",
            "xx.he.translate_to.fr": "translate_fr_he",
            "xx.sq.translate_to.fi": "translate_fi_sq",
            "xx.ve.translate_to.fi": "translate_fi_ve",
            "xx.tw.translate_to.fi": "translate_fi_tw",
            "xx.tvl.translate_to.fi": "translate_fi_tvl",
            "xx.hil.translate_to.fr": "translate_fr_hil",
            "xx.sw.translate_to.fi": "translate_fi_sw",
            "xx.eo.translate_to.fr": "translate_fr_eo",
            "xx.xh.translate_to.fi": "translate_fi_xh",
            "xx.bi.translate_to.fr": "translate_fr_bi",
            "xx.ru.translate_to.fi": "translate_fi_ru",
            "xx.ceb.translate_to.fr": "translate_fr_ceb",
            "xx.ig.translate_to.fr": "translate_fr_ig",
            "xx.el.translate_to.fr": "translate_fr_el",
            "xx.sm.translate_to.fi": "translate_fi_sm",
            "xx.to.translate_to.fi": "translate_fi_to",
            "xx.ase.translate_to.fr": "translate_fr_ase",
            "xx.yo.translate_to.fi": "translate_fi_yo",
            "xx.sg.translate_to.fi": "translate_fi_sg",
            "xx.rw.translate_to.fi": "translate_fi_rw",
            "xx.ts.translate_to.fi": "translate_fi_ts",
            "xx.wls.translate_to.fi": "translate_fi_wls",
            "xx.ho.translate_to.fr": "translate_fr_ho",
            "xx.tll.translate_to.fi": "translate_fi_tll",
            "xx.st.translate_to.fi": "translate_fi_st",
            "xx.fiu.translate_to.fiu": "translate_fiu_fiu",
            "xx.ro.translate_to.fi": "translate_fi_ro",
            "xx.tiv.translate_to.fi": "translate_fi_tiv",
            "xx.ha.translate_to.fr": "translate_fr_ha",
            "xx.ee.translate_to.fr": "translate_fr_ee",
            "xx.gaa.translate_to.fr": "translate_fr_gaa",
            "xx.hu.translate_to.fr": "translate_fr_hu",
            "xx.ty.translate_to.fi": "translate_fi_ty",
            "xx.fr.translate_to.fj": "translate_fj_fr",
            "xx.run.translate_to.fi": "translate_fi_run",
            "xx.bem.translate_to.fr": "translate_fr_bem",
            "xx.bzs.translate_to.fr": "translate_fr_bzs",
            "xx.fj.translate_to.fr": "translate_fr_fj",
            "xx.ar.translate_to.fr": "translate_fr_ar",
            "xx.swc.translate_to.fi": "translate_fi_swc",
            "xx.crs.translate_to.fr": "translate_fr_crs",
            "xx.bg.translate_to.fr": "translate_fr_bg",
            "xx.af.translate_to.fr": "translate_fr_af",
            "xx.loz.translate_to.fr": "translate_fr_loz",
            "xx.st.translate_to.fr": "translate_fr_st",
            "xx.tn.translate_to.fr": "translate_fr_tn",
            "xx.srn.translate_to.fr": "translate_fr_srn",
            "xx.to.translate_to.fr": "translate_fr_to",
            "xx.sk.translate_to.fr": "translate_fr_sk",
            "xx.tum.translate_to.fr": "translate_fr_tum",
            "xx.ts.translate_to.fr": "translate_fr_ts",
            "xx.iso.translate_to.fr": "translate_fr_iso",
            "xx.sv.translate_to.fr": "translate_fr_sv",
            "xx.mt.translate_to.fr": "translate_fr_mt",
            "xx.pap.translate_to.fr": "translate_fr_pap",
            "xx.wls.translate_to.fr": "translate_fr_wls",
            "xx.lua.translate_to.fr": "translate_fr_lua",
            "xx.ro.translate_to.fr": "translate_fr_ro",
            "xx.tll.translate_to.fr": "translate_fr_tll",
            "xx.ilo.translate_to.fr": "translate_fr_ilo",
            "xx.ve.translate_to.fr": "translate_fr_ve",
            "xx.ny.translate_to.fr": "translate_fr_ny",
            "xx.tpi.translate_to.fr": "translate_fr_tpi",
            "xx.uk.translate_to.fr": "translate_fr_uk",
            "xx.ln.translate_to.fr": "translate_fr_ln",
            "xx.mfe.translate_to.fr": "translate_fr_mfe",
            "xx.lue.translate_to.fr": "translate_fr_lue",
            "xx.mos.translate_to.fr": "translate_fr_mos",
            "xx.pon.translate_to.fr": "translate_fr_pon",
            "xx.tvl.translate_to.fr": "translate_fr_tvl",
            "xx.run.translate_to.fr": "translate_fr_run",
            "xx.pag.translate_to.fr": "translate_fr_pag",
            "xx.sg.translate_to.fr": "translate_fr_sg",
            "xx.no.translate_to.fr": "translate_fr_no",
            "xx.ty.translate_to.fr": "translate_fr_ty",
            "xx.tl.translate_to.fr": "translate_fr_tl",
            "xx.sl.translate_to.fr": "translate_fr_sl",
            "xx.tiv.translate_to.fr": "translate_fr_tiv",
            "xx.rw.translate_to.fr": "translate_fr_rw",
            "xx.lus.translate_to.fr": "translate_fr_lus",
            "xx.swc.translate_to.fr": "translate_fr_swc",
            "xx.sm.translate_to.fr": "translate_fr_sm",
            "xx.pl.translate_to.fr": "translate_fr_pl",
            "xx.kg.translate_to.fr": "translate_fr_kg",
            "xx.niu.translate_to.fr": "translate_fr_niu",
            "xx.lg.translate_to.fr": "translate_fr_lg",
            "xx.ms.translate_to.fr": "translate_fr_ms",
            "xx.nso.translate_to.fr": "translate_fr_nso",
            "xx.war.translate_to.fr": "translate_fr_war",
            "xx.xh.translate_to.fr": "translate_fr_xh",
            "xx.pis.translate_to.fr": "translate_fr_pis",
            "xx.tw.translate_to.fr": "translate_fr_tw",
            "xx.kwy.translate_to.fr": "translate_fr_kwy",
            "xx.rnd.translate_to.fr": "translate_fr_rnd",
            "xx.vi.translate_to.fr": "translate_fr_vi",
            "xx.lu.translate_to.fr": "translate_fr_lu",
            "xx.mh.translate_to.fr": "translate_fr_mh",
            "xx.ru.translate_to.fr": "translate_fr_ru",
            "xx.sn.translate_to.fr": "translate_fr_sn",
            "xx.kqn.translate_to.fr": "translate_fr_kqn",
            "xx.ar.translate_to.he": "translate_he_ar",
            "xx.de.translate_to.he": "translate_he_de",
            "xx.es.translate_to.gil": "translate_gil_es",
            "xx.de.translate_to.gaa": "translate_gaa_de",
            "xx.fr.translate_to.hu": "translate_hu_fr",
            "xx.fr.translate_to.gil": "translate_gil_fr",
            "xx.de.translate_to.guw": "translate_guw_de",
            "xx.fr.translate_to.ht": "translate_ht_fr",
            "xx.uk.translate_to.he": "translate_he_uk",
            "xx.fi.translate_to.hu": "translate_hu_fi",
            "xx.uk.translate_to.hu": "translate_hu_uk",
            "xx.zne.translate_to.fr": "translate_fr_zne",
            "xx.sv.translate_to.gaa": "translate_gaa_sv",
            "xx.es.translate_to.guw": "translate_guw_es",
            "xx.gmq.translate_to.gmq": "translate_gmq_gmq",
            "xx.fi.translate_to.hil": "translate_hil_fi",
            "xx.fi.translate_to.guw": "translate_guw_fi",
            "xx.es.translate_to.he": "translate_he_es",
            "xx.ur.translate_to.hi": "translate_hi_ur",
            "xx.de.translate_to.hil": "translate_hil_de",
            "xx.gmw.translate_to.gmw": "translate_gmw_gmw",
            "xx.fi.translate_to.gaa": "translate_gaa_fi",
            "xx.fi.translate_to.he": "translate_he_fi",
            "xx.eo.translate_to.hu": "translate_hu_eo",
            "xx.fi.translate_to.ht": "translate_ht_fi",
            "xx.yo.translate_to.fr": "translate_fr_yo",
            "xx.sv.translate_to.hr": "translate_hr_sv",
            "xx.fr.translate_to.ha": "translate_ha_fr",
            "xx.fi.translate_to.ha": "translate_ha_fi",
            "xx.sv.translate_to.ha": "translate_ha_sv",
            "xx.pt.translate_to.gl": "translate_gl_pt",
            "xx.fr.translate_to.guw": "translate_guw_fr",
            "xx.es.translate_to.ht": "translate_ht_es",
            "xx.de.translate_to.hu": "translate_hu_de",
            "xx.sv.translate_to.ht": "translate_ht_sv",
            "xx.es.translate_to.hr": "translate_hr_es",
            "xx.fr.translate_to.gaa": "translate_gaa_fr",
            "xx.ru.translate_to.he": "translate_he_ru",
            "xx.es.translate_to.gl": "translate_gl_es",
            "xx.ru.translate_to.hy": "translate_hy_ru",
            "xx.fi.translate_to.gil": "translate_gil_fi",
            "xx.sv.translate_to.hu": "translate_hu_sv",
            "xx.sv.translate_to.gil": "translate_gil_sv",
            "xx.fi.translate_to.fse": "translate_fse_fi",
            "xx.gem.translate_to.gem": "translate_gem_gem",
            "xx.es.translate_to.ha": "translate_ha_es",
            "xx.it.translate_to.he": "translate_he_it",
            "xx.sv.translate_to.guw": "translate_guw_sv",
            "xx.sv.translate_to.he": "translate_he_sv",
            "xx.yap.translate_to.fr": "translate_fr_yap",
            "xx.fr.translate_to.hr": "translate_hr_fr",
            "xx.eo.translate_to.he": "translate_he_eo",
            "xx.es.translate_to.gaa": "translate_gaa_es",
            "xx.fi.translate_to.hr": "translate_hr_fi",
            "xx.fr.translate_to.he": "translate_he_fr",
            "xx.fi.translate_to.ilo": "translate_ilo_fi",
            "xx.sv.translate_to.iso": "translate_iso_sv",
            "xx.he.translate_to.ja": "translate_ja_he",
            "xx.fi.translate_to.id": "translate_id_fi",
            "xx.de.translate_to.ja": "translate_ja_de",
            "xx.he.translate_to.it": "translate_it_he",
            "xx.it.translate_to.ja": "translate_ja_it",
            "xx.is.translate_to.it": "translate_it_is",
            "xx.bg.translate_to.ja": "translate_ja_bg",
            "xx.de.translate_to.ig": "translate_ig_de",
            "xx.bg.translate_to.it": "translate_it_bg",
            "xx.es.translate_to.id": "translate_id_es",
            "xx.fr.translate_to.id": "translate_id_fr",
            "xx.es.translate_to.ja": "translate_ja_es",
            "xx.sv.translate_to.ja": "translate_ja_sv",
            "xx.es.translate_to.iso": "translate_iso_es",
            "xx.es.translate_to.ilo": "translate_ilo_es",
            "xx.it.translate_to.is": "translate_is_it",
            "xx.sv.translate_to.it": "translate_it_sv",
            "xx.sv.translate_to.is": "translate_is_sv",
            "xx.ru.translate_to.ja": "translate_ja_ru",
            "xx.es.translate_to.kg": "translate_kg_es",
            "xx.fi.translate_to.ig": "translate_ig_fi",
            "xx.fr.translate_to.iso": "translate_iso_fr",
            "xx.de.translate_to.ko": "translate_ko_de",
            "xx.sv.translate_to.ilo": "translate_ilo_sv",
            "xx.es.translate_to.is": "translate_is_es",
            "xx.da.translate_to.ja": "translate_ja_da",
            "xx.nl.translate_to.ja": "translate_ja_nl",
            "xx.inc.translate_to.inc": "translate_inc_inc",
            "xx.de.translate_to.is": "translate_is_de",
            "xx.fr.translate_to.is": "translate_is_fr",
            "xx.lt.translate_to.it": "translate_it_lt",
            "xx.sv.translate_to.ig": "translate_ig_sv",
            "xx.de.translate_to.ilo": "translate_ilo_de",
            "xx.ar.translate_to.it": "translate_it_ar",
            "xx.fr.translate_to.kg": "translate_kg_fr",
            "xx.vi.translate_to.ja": "translate_ja_vi",
            "xx.ru.translate_to.ka": "translate_ka_ru",
            "xx.uk.translate_to.it": "translate_it_uk",
            "xx.vi.translate_to.it": "translate_it_vi",
            "xx.ms.translate_to.it": "translate_it_ms",
            "xx.ar.translate_to.ja": "translate_ja_ar",
            "xx.eo.translate_to.is": "translate_is_eo",
            "xx.ca.translate_to.it": "translate_it_ca",
            "xx.sh.translate_to.ja": "translate_ja_sh",
            "xx.fi.translate_to.ja": "translate_ja_fi",
            "xx.iir.translate_to.iir": "translate_iir_iir",
            "xx.itc.translate_to.itc": "translate_itc_itc",
            "xx.ms.translate_to.ja": "translate_ja_ms",
            "xx.fr.translate_to.it": "translate_it_fr",
            "xx.fr.translate_to.ja": "translate_ja_fr",
            "xx.pt.translate_to.ja": "translate_ja_pt",
            "xx.eo.translate_to.it": "translate_it_eo",
            "xx.fi.translate_to.iso": "translate_iso_fi",
            "xx.pl.translate_to.ja": "translate_ja_pl",
            "xx.tr.translate_to.ja": "translate_ja_tr",
            "xx.es.translate_to.ig": "translate_ig_es",
            "xx.fr.translate_to.ig": "translate_ig_fr",
            "xx.sv.translate_to.id": "translate_id_sv",
            "xx.hu.translate_to.ja": "translate_ja_hu",
            "xx.sv.translate_to.kg": "translate_kg_sv",
            "xx.es.translate_to.it": "translate_it_es",
            "xx.ine.translate_to.ine": "translate_ine_ine",
            "xx.de.translate_to.it": "translate_it_de",
            "xx.fi.translate_to.is": "translate_is_fi",
            "xx.es.translate_to.mk": "translate_mk_es",
            "xx.es.translate_to.lue": "translate_lue_es",
            "xx.es.translate_to.lv": "translate_lv_es",
            "xx.fi.translate_to.lue": "translate_lue_fi",
            "xx.es.translate_to.ln": "translate_ln_es",
            "xx.fr.translate_to.loz": "translate_loz_fr",
            "xx.sv.translate_to.kwy": "translate_kwy_sv",
            "xx.es.translate_to.lus": "translate_lus_es",
            "xx.fr.translate_to.lv": "translate_lv_fr",
            "xx.fr.translate_to.lu": "translate_lu_fr",
            "xx.de.translate_to.lt": "translate_lt_de",
            "xx.tr.translate_to.lt": "translate_lt_tr",
            "xx.fr.translate_to.lus": "translate_lus_fr",
            "xx.es.translate_to.mg": "translate_mg_es",
            "xx.sv.translate_to.lua": "translate_lua_sv",
            "xx.fr.translate_to.lg": "translate_lg_fr",
            "xx.fr.translate_to.kwy": "translate_kwy_fr",
            "xx.es.translate_to.lt": "translate_lt_es",
            "xx.sv.translate_to.ko": "translate_ko_sv",
            "xx.es.translate_to.kqn": "translate_kqn_es",
            "xx.fr.translate_to.ko": "translate_ko_fr",
            "xx.sv.translate_to.kqn": "translate_kqn_sv",
            "xx.fi.translate_to.ko": "translate_ko_fi",
            "xx.es.translate_to.mh": "translate_mh_es",
            "xx.fr.translate_to.lua": "translate_lua_fr",
            "xx.it.translate_to.lt": "translate_lt_it",
            "xx.sv.translate_to.lt": "translate_lt_sv",
            "xx.es.translate_to.lu": "translate_lu_es",
            "xx.fi.translate_to.lua": "translate_lua_fi",
            "xx.fr.translate_to.kqn": "translate_kqn_fr",
            "xx.de.translate_to.loz": "translate_loz_de",
            "xx.fr.translate_to.ms": "translate_ms_fr",
            "xx.fr.translate_to.lt": "translate_lt_fr",
            "xx.ru.translate_to.lv": "translate_lv_ru",
            "xx.ms.translate_to.ms": "translate_ms_ms",
            "xx.sv.translate_to.lus": "translate_lus_sv",
            "xx.fr.translate_to.lue": "translate_lue_fr",
            "xx.fi.translate_to.lu": "translate_lu_fi",
            "xx.eo.translate_to.lt": "translate_lt_eo",
            "xx.fi.translate_to.mk": "translate_mk_fi",
            "xx.es.translate_to.ko": "translate_ko_es",
            "xx.sv.translate_to.lue": "translate_lue_sv",
            "xx.pl.translate_to.lt": "translate_lt_pl",
            "xx.es.translate_to.mfe": "translate_mfe_es",
            "xx.fi.translate_to.loz": "translate_loz_fi",
            "xx.sv.translate_to.loz": "translate_loz_sv",
            "xx.ru.translate_to.ko": "translate_ko_ru",
            "xx.fi.translate_to.lg": "translate_lg_fi",
            "xx.fi.translate_to.mh": "translate_mh_fi",
            "xx.sv.translate_to.lv": "translate_lv_sv",
            "xx.hu.translate_to.ko": "translate_ko_hu",
            "xx.es.translate_to.lua": "translate_lua_es",
            "xx.fi.translate_to.lv": "translate_lv_fi",
            "xx.ru.translate_to.lt": "translate_lt_ru",
            "xx.de.translate_to.ms": "translate_ms_de",
            "xx.fi.translate_to.lus": "translate_lus_fi",
            "xx.es.translate_to.lg": "translate_lg_es",
            "xx.de.translate_to.ln": "translate_ln_de",
            "xx.es.translate_to.mfs": "translate_mfs_es",
            "xx.fr.translate_to.mk": "translate_mk_fr",
            "xx.fr.translate_to.ln": "translate_ln_fr",
            "xx.es.translate_to.loz": "translate_loz_es",
            "xx.sv.translate_to.lu": "translate_lu_sv",
            "xx.it.translate_to.ms": "translate_ms_it",
            "xx.sv.translate_to.lg": "translate_lg_sv",
            "xx.ar.translate_to.pl": "translate_pl_ar",
            "xx.fr.translate_to.ro": "translate_ro_fr",
            "xx.sv.translate_to.niu": "translate_niu_sv",
            "xx.eo.translate_to.pl": "translate_pl_eo",
            "xx.nl.translate_to.no": "translate_no_nl",
            "xx.es.translate_to.no": "translate_no_es",
            "xx.es.translate_to.pag": "translate_pag_es",
            "xx.ru.translate_to.rn": "translate_rn_ru",
            "xx.sv.translate_to.pag": "translate_pag_sv",
            "xx.uk.translate_to.pt": "translate_pt_uk",
            "xx.uk.translate_to.pl": "translate_pl_uk",
            "xx.de.translate_to.pl": "translate_pl_de",
            "xx.sv.translate_to.nl": "translate_nl_sv",
            "xx.fr.translate_to.no": "translate_no_fr",
            "xx.es.translate_to.niu": "translate_niu_es",
            "xx.uk.translate_to.no": "translate_no_uk",
            "xx.lt.translate_to.pl": "translate_pl_lt",
            "xx.tl.translate_to.pt": "translate_pt_tl",
            "xx.gl.translate_to.pt": "translate_pt_gl",
            "xx.da.translate_to.ru": "translate_ru_da",
            "xx.da.translate_to.no": "translate_no_da",
            "xx.uk.translate_to.nl": "translate_nl_uk",
            "xx.sv.translate_to.pon": "translate_pon_sv",
            "xx.fr.translate_to.pis": "translate_pis_fr",
            "xx.fr.translate_to.niu": "translate_niu_fr",
            "xx.af.translate_to.nl": "translate_nl_af",
            "xx.fi.translate_to.nso": "translate_nso_fi",
            "xx.fi.translate_to.pon": "translate_pon_fi",
            "xx.de.translate_to.pap": "translate_pap_de",
            "xx.de.translate_to.rn": "translate_rn_de",
            "xx.es.translate_to.pon": "translate_pon_es",
            "xx.es.translate_to.pis": "translate_pis_es",
            "xx.ca.translate_to.pt": "translate_pt_ca",
            "xx.sv.translate_to.rnd": "translate_rnd_sv",
            "xx.sv.translate_to.pl": "translate_pl_sv",
            "xx.ru.translate_to.no": "translate_no_ru",
            "xx.fi.translate_to.niu": "translate_niu_fi",
            "xx.de.translate_to.pag": "translate_pag_de",
            "xx.fr.translate_to.pl": "translate_pl_fr",
            "xx.fi.translate_to.no": "translate_no_fi",
            "xx.pl.translate_to.no": "translate_no_pl",
            "xx.de.translate_to.nso": "translate_nso_de",
            "xx.fr.translate_to.rn": "translate_rn_fr",
            "xx.sv.translate_to.nso": "translate_nso_sv",
            "xx.sv.translate_to.ro": "translate_ro_sv",
            "xx.no.translate_to.pl": "translate_pl_no",
            "xx.fr.translate_to.nl": "translate_nl_fr",
            "xx.es.translate_to.nso": "translate_nso_es",
            "xx.no.translate_to.nl": "translate_nl_no",
            "xx.fi.translate_to.pis": "translate_pis_fi",
            "xx.ca.translate_to.nl": "translate_nl_ca",
            "xx.es.translate_to.nl": "translate_nl_es",
            "xx.es.translate_to.ny": "translate_ny_es",
            "xx.fr.translate_to.pap": "translate_pap_fr",
            "xx.fi.translate_to.nl": "translate_nl_fi",
            "xx.sv.translate_to.no": "translate_no_sv",
            "xx.fr.translate_to.pon": "translate_pon_fr",
            "xx.fr.translate_to.rnd": "translate_rnd_fr",
            "xx.es.translate_to.pap": "translate_pap_es",
            "xx.es.translate_to.prl": "translate_prl_es",
            "xx.eo.translate_to.ro": "translate_ro_eo",
            "xx.sv.translate_to.pis": "translate_pis_sv",
            "xx.af.translate_to.ru": "translate_ru_af",
            "xx.fr.translate_to.nso": "translate_nso_fr",
            "xx.eo.translate_to.pt": "translate_pt_eo",
            "xx.ar.translate_to.ru": "translate_ru_ar",
            "xx.fr.translate_to.mt": "translate_mt_fr",
            "xx.es.translate_to.rn": "translate_rn_es",
            "xx.sv.translate_to.mt": "translate_mt_sv",
            "xx.de.translate_to.niu": "translate_niu_de",
            "xx.es.translate_to.mt": "translate_mt_es",
            "xx.es.translate_to.pl": "translate_pl_es",
            "xx.fi.translate_to.pag": "translate_pag_fi",
            "xx.de.translate_to.no": "translate_no_de",
            "xx.de.translate_to.ny": "translate_ny_de",
            "xx.fi.translate_to.mt": "translate_mt_fi",
            "xx.no.translate_to.no": "translate_no_no",
            "xx.eo.translate_to.nl": "translate_nl_eo",
            "xx.bg.translate_to.ru": "translate_ru_bg",
            "xx.fi.translate_to.pap": "translate_pap_fi",
            "xx.fi.translate_to.ro": "translate_ro_fi",
            "xx.sv.translate_to.st": "translate_st_sv",
            "xx.kg.translate_to.sv": "translate_sv_kg",
            "xx.sv.translate_to.sq": "translate_sq_sv",
            "xx.ee.translate_to.sv": "translate_sv_ee",
            "xx.es.translate_to.srn": "translate_srn_es",
            "xx.lv.translate_to.ru": "translate_ru_lv",
            "xx.cs.translate_to.sv": "translate_sv_cs",
            "xx.ha.translate_to.sv": "translate_sv_ha",
            "xx.kqn.translate_to.sv": "translate_sv_kqn",
            "xx.fr.translate_to.rw": "translate_rw_fr",
            "xx.fr.translate_to.sn": "translate_sn_fr",
            "xx.eu.translate_to.ru": "translate_ru_eu",
            "xx.fi.translate_to.st": "translate_st_fi",
            "xx.efi.translate_to.sv": "translate_sv_efi",
            "xx.ho.translate_to.sv": "translate_sv_ho",
            "xx.id.translate_to.sv": "translate_sv_id",
            "xx.eo.translate_to.sv": "translate_sv_eo",
            "xx.guw.translate_to.sv": "translate_sv_guw",
            "xx.sv.translate_to.sk": "translate_sk_sv",
            "xx.fr.translate_to.srn": "translate_srn_fr",
            "xx.ceb.translate_to.sv": "translate_sv_ceb",
            "xx.es.translate_to.sq": "translate_sq_es",
            "xx.sv.translate_to.rw": "translate_rw_sv",
            "xx.is.translate_to.sv": "translate_sv_is",
            "xx.es.translate_to.sm": "translate_sm_es",
            "xx.bcl.translate_to.sv": "translate_sv_bcl",
            "xx.kwy.translate_to.sv": "translate_sv_kwy",
            "xx.es.translate_to.run": "translate_run_es",
            "xx.el.translate_to.sv": "translate_sv_el",
            "xx.es.translate_to.sk": "translate_sk_es",
            "xx.iso.translate_to.sv": "translate_sv_iso",
            "xx.lu.translate_to.sv": "translate_sv_lu",
            "xx.af.translate_to.sv": "translate_sv_af",
            "xx.bg.translate_to.sv": "translate_sv_bg",
            "xx.fr.translate_to.sm": "translate_sm_fr",
            "xx.hr.translate_to.sv": "translate_sv_hr",
            "xx.sv.translate_to.sn": "translate_sn_sv",
            "xx.no.translate_to.ru": "translate_ru_no",
            "xx.fr.translate_to.sg": "translate_sg_fr",
            "xx.es.translate_to.sl": "translate_sl_es",
            "xx.bzs.translate_to.sv": "translate_sv_bzs",
            "xx.fr.translate_to.st": "translate_st_fr",
            "xx.hu.translate_to.sv": "translate_sv_hu",
            "xx.sv.translate_to.sg": "translate_sg_sv",
            "xx.sem.translate_to.sem": "translate_sem_sem",
            "xx.uk.translate_to.sh": "translate_sh_uk",
            "xx.ln.translate_to.sv": "translate_sv_ln",
            "xx.fi.translate_to.sk": "translate_sk_fi",
            "xx.ht.translate_to.sv": "translate_sv_ht",
            "xx.es.translate_to.st": "translate_st_es",
            "xx.fr.translate_to.ru": "translate_ru_fr",
            "xx.chk.translate_to.sv": "translate_sv_chk",
            "xx.fr.translate_to.sk": "translate_sk_fr",
            "xx.lg.translate_to.sv": "translate_sv_lg",
            "xx.sv.translate_to.srn": "translate_srn_sv",
            "xx.crs.translate_to.sv": "translate_sv_crs",
            "xx.uk.translate_to.ru": "translate_ru_uk",
            "xx.et.translate_to.ru": "translate_ru_et",
            "xx.et.translate_to.sv": "translate_sv_et",
            "xx.es.translate_to.rw": "translate_rw_es",
            "xx.sla.translate_to.sla": "translate_sla_sla",
            "xx.ru.translate_to.sl": "translate_sl_ru",
            "xx.fj.translate_to.sv": "translate_sv_fj",
            "xx.es.translate_to.sn": "translate_sn_es",
            "xx.lua.translate_to.sv": "translate_sv_lua",
            "xx.hil.translate_to.sv": "translate_sv_hil",
            "xx.es.translate_to.ru": "translate_ru_es",
            "xx.lue.translate_to.sv": "translate_sv_lue",
            "xx.gaa.translate_to.sv": "translate_sv_gaa",
            "xx.hy.translate_to.ru": "translate_ru_hy",
            "xx.bem.translate_to.sv": "translate_sv_bem",
            "xx.sv.translate_to.run": "translate_run_sv",
            "xx.gil.translate_to.sv": "translate_sv_gil",
            "xx.lus.translate_to.sv": "translate_sv_lus",
            "xx.he.translate_to.ru": "translate_ru_he",
            "xx.vi.translate_to.ru": "translate_ru_vi",
            "xx.he.translate_to.sv": "translate_sv_he",
            "xx.sv.translate_to.ru": "translate_ru_sv",
            "xx.fi.translate_to.ru": "translate_ru_fi",
            "xx.es.translate_to.sv": "translate_sv_es",
            "xx.es.translate_to.sg": "translate_sg_es",
            "xx.eo.translate_to.ru": "translate_ru_eo",
            "xx.lv.translate_to.sv": "translate_sv_lv",
            "xx.fi.translate_to.sg": "translate_sg_fi",
            "xx.es.translate_to.ssp": "translate_ssp_es",
            "xx.ilo.translate_to.sv": "translate_sv_ilo",
            "xx.fi.translate_to.sv": "translate_sv_fi",
            "xx.lt.translate_to.ru": "translate_ru_lt",
            "xx.bi.translate_to.sv": "translate_sv_bi",
            "xx.sv.translate_to.sl": "translate_sl_sv",
            "xx.fr.translate_to.sv": "translate_sv_fr",
            "xx.uk.translate_to.sl": "translate_sl_uk",
            "xx.fi.translate_to.sl": "translate_sl_fi",
            "xx.sl.translate_to.ru": "translate_ru_sl",
            "xx.ig.translate_to.sv": "translate_sv_ig",
            "xx.ase.translate_to.sv": "translate_sv_ase",
            "xx.eo.translate_to.sh": "translate_sh_eo",
            "xx.fr.translate_to.sl": "translate_sl_fr",
            "xx.es.translate_to.tl": "translate_tl_es",
            "xx.sv.translate_to.tw": "translate_tw_sv",
            "xx.lt.translate_to.tr": "translate_tr_lt",
            "xx.fi.translate_to.tll": "translate_tll_fi",
            "xx.sn.translate_to.sv": "translate_sv_sn",
            "xx.tn.translate_to.sv": "translate_sv_tn",
            "xx.sv.translate_to.toi": "translate_toi_sv",
            "xx.uk.translate_to.sv": "translate_sv_uk",
            "xx.tiv.translate_to.sv": "translate_sv_tiv",
            "xx.sk.translate_to.sv": "translate_sv_sk",
            "xx.ty.translate_to.sv": "translate_sv_ty",
            "xx.es.translate_to.toi": "translate_toi_es",
            "xx.rw.translate_to.sv": "translate_sv_rw",
            "xx.ny.translate_to.sv": "translate_sv_ny",
            "xx.rnd.translate_to.sv": "translate_sv_rnd",
            "xx.es.translate_to.tn": "translate_tn_es",
            "xx.sv.translate_to.tn": "translate_tn_sv",
            "xx.es.translate_to.tvl": "translate_tvl_es",
            "xx.pon.translate_to.sv": "translate_sv_pon",
            "xx.ve.translate_to.sv": "translate_sv_ve",
            "xx.fr.translate_to.tvl": "translate_tvl_fr",
            "xx.es.translate_to.tum": "translate_tum_es",
            "xx.run.translate_to.sv": "translate_sv_run",
            "xx.de.translate_to.tl": "translate_tl_de",
            "xx.fi.translate_to.tw": "translate_tw_fi",
            "xx.es.translate_to.ty": "translate_ty_es",
            "xx.fr.translate_to.toi": "translate_toi_fr",
            "xx.sv.translate_to.tll": "translate_tll_sv",
            "xx.sg.translate_to.sv": "translate_sv_sg",
            "xx.az.translate_to.tr": "translate_tr_az",
            "xx.es.translate_to.ts": "translate_ts_es",
            "xx.fr.translate_to.ts": "translate_ts_fr",
            "xx.fr.translate_to.th": "translate_th_fr",
            "xx.zne.translate_to.sv": "translate_sv_zne",
            "xx.tw.translate_to.sv": "translate_sv_tw",
            "xx.mh.translate_to.sv": "translate_sv_mh",
            "xx.pag.translate_to.sv": "translate_sv_pag",
            "xx.fr.translate_to.tum": "translate_tum_fr",
            "xx.no.translate_to.sv": "translate_sv_no",
            "xx.ts.translate_to.sv": "translate_sv_ts",
            "xx.mt.translate_to.sv": "translate_sv_mt",
            "xx.yo.translate_to.sv": "translate_sv_yo",
            "xx.fr.translate_to.to": "translate_to_fr",
            "xx.sv.translate_to.sv": "translate_sv_sv",
            "xx.fi.translate_to.toi": "translate_toi_fi",
            "xx.ro.translate_to.sv": "translate_sv_ro",
            "xx.es.translate_to.tw": "translate_tw_es",
            "xx.niu.translate_to.sv": "translate_sv_niu",
            "xx.uk.translate_to.tr": "translate_tr_uk",
            "xx.to.translate_to.sv": "translate_sv_to",
            "xx.fi.translate_to.ts": "translate_ts_fi",
            "xx.tll.translate_to.sv": "translate_sv_tll",
            "xx.fr.translate_to.tll": "translate_tll_fr",
            "xx.pt.translate_to.tl": "translate_tl_pt",
            "xx.nso.translate_to.sv": "translate_sv_nso",
            "xx.sq.translate_to.sv": "translate_sv_sq",
            "xx.sv.translate_to.tpi": "translate_tpi_sv",
            "xx.yap.translate_to.sv": "translate_sv_yap",
            "xx.sv.translate_to.tr": "translate_tr_sv",
            "xx.fr.translate_to.swc": "translate_swc_fr",
            "xx.nl.translate_to.sv": "translate_sv_nl",
            "xx.fi.translate_to.ty": "translate_ty_fi",
            "xx.fr.translate_to.tr": "translate_tr_fr",
            "xx.sv.translate_to.tum": "translate_tum_sv",
            "xx.swc.translate_to.sv": "translate_sv_swc",
            "xx.fi.translate_to.swc": "translate_swc_fi",
            "xx.eo.translate_to.tr": "translate_tr_eo",
            "xx.xh.translate_to.sv": "translate_sv_xh",
            "xx.sv.translate_to.tvl": "translate_tvl_sv",
            "xx.sl.translate_to.sv": "translate_sv_sl",
            "xx.tum.translate_to.sv": "translate_sv_tum",
            "xx.es.translate_to.to": "translate_to_es",
            "xx.fr.translate_to.tn": "translate_tn_fr",
            "xx.sv.translate_to.ty": "translate_ty_sv",
            "xx.sv.translate_to.swc": "translate_swc_sv",
            "xx.mos.translate_to.sv": "translate_sv_mos",
            "xx.ar.translate_to.tr": "translate_tr_ar",
            "xx.ru.translate_to.sv": "translate_sv_ru",
            "xx.srn.translate_to.sv": "translate_sv_srn",
            "xx.pis.translate_to.sv": "translate_sv_pis",
            "xx.pap.translate_to.sv": "translate_sv_pap",
            "xx.tvl.translate_to.sv": "translate_sv_tvl",
            "xx.sv.translate_to.to": "translate_to_sv",
            "xx.th.translate_to.sv": "translate_sv_th",
            "xx.war.translate_to.sv": "translate_sv_war",
            "xx.sv.translate_to.ts": "translate_ts_sv",
            "xx.fr.translate_to.tw": "translate_tw_fr",
            "xx.st.translate_to.sv": "translate_sv_st",
            "xx.fr.translate_to.tiv": "translate_tiv_fr",
            "xx.tpi.translate_to.sv": "translate_sv_tpi",
            "xx.fi.translate_to.tvl": "translate_tvl_fi",
            "xx.fr.translate_to.ty": "translate_ty_fr",
            "xx.sm.translate_to.sv": "translate_sv_sm",
            "xx.es.translate_to.swc": "translate_swc_es",
            "xx.sv.translate_to.tiv": "translate_tiv_sv",
            "xx.toi.translate_to.sv": "translate_sv_toi",
            "xx.mfe.translate_to.sv": "translate_sv_mfe",
            "xx.wls.translate_to.sv": "translate_sv_wls",
            "xx.umb.translate_to.sv": "translate_sv_umb",
            "xx.es.translate_to.tr": "translate_tr_es",
            "xx.es.translate_to.tll": "translate_tll_es",
            "xx.pt.translate_to.uk": "translate_uk_pt",
            "xx.it.translate_to.zh": "translate_zh_it",
            "xx.no.translate_to.uk": "translate_uk_no",
            "xx.sh.translate_to.uk": "translate_uk_sh",
            "xx.sv.translate_to.wls": "translate_wls_sv",
            "xx.pl.translate_to.uk": "translate_uk_pl",
            "xx.es.translate_to.yo": "translate_yo_es",
            "xx.es.translate_to.war": "translate_war_es",
            "xx.sv.translate_to.zh": "translate_zh_sv",
            "xx.tr.translate_to.uk": "translate_uk_tr",
            "xx.fi.translate_to.war": "translate_war_fi",
            "xx.de.translate_to.zh": "translate_zh_de",
            "xx.uk.translate_to.zh": "translate_zh_uk",
            "xx.eo.translate_to.vi": "translate_vi_eo",
            "xx.bg.translate_to.zh": "translate_zh_bg",
            "xx.es.translate_to.zne": "translate_zne_es",
            "xx.fr.translate_to.uk": "translate_uk_fr",
            "xx.zls.translate_to.zls": "translate_zls_zls",
            "xx.fr.translate_to.yo": "translate_yo_fr",
            "xx.bg.translate_to.uk": "translate_uk_bg",
            "xx.fr.translate_to.xh": "translate_xh_fr",
            "xx.ca.translate_to.uk": "translate_uk_ca",
            "xx.fi.translate_to.zh": "translate_zh_fi",
            "xx.es.translate_to.zai": "translate_zai_es",
            "xx.es.translate_to.uk": "translate_uk_es",
            "xx.nl.translate_to.uk": "translate_uk_nl",
            "xx.sv.translate_to.yap": "translate_yap_sv",
            "xx.he.translate_to.uk": "translate_uk_he",
            "xx.sl.translate_to.uk": "translate_uk_sl",
            "xx.es.translate_to.ve": "translate_ve_es",
            "xx.zlw.translate_to.zlw": "translate_zlw_zlw",
            "xx.es.translate_to.tzo": "translate_tzo_es",
            "xx.hu.translate_to.uk": "translate_uk_hu",
            "xx.de.translate_to.vi": "translate_vi_de",
            "xx.fi.translate_to.yo": "translate_yo_fi",
            "xx.ru.translate_to.uk": "translate_uk_ru",
            "xx.ms.translate_to.zh": "translate_zh_ms",
            "xx.urj.translate_to.urj": "translate_urj_urj",
            "xx.it.translate_to.uk": "translate_uk_it",
            "xx.sv.translate_to.war": "translate_war_sv",
            "xx.fr.translate_to.wls": "translate_wls_fr",
            "xx.zle.translate_to.zle": "translate_zle_zle",
            "xx.vi.translate_to.zh": "translate_zh_vi",
            "xx.es.translate_to.vsl": "translate_vsl_es",
            "xx.fi.translate_to.zne": "translate_zne_fi",
            "xx.fi.translate_to.uk": "translate_uk_fi",
            "xx.ru.translate_to.vi": "translate_vi_ru",
            "xx.nl.translate_to.zh": "translate_zh_nl",
            "xx.sv.translate_to.xh": "translate_xh_sv",
            "xx.es.translate_to.xh": "translate_xh_es",
            "xx.he.translate_to.zh": "translate_zh_he",
            "xx.fr.translate_to.war": "translate_war_fr",
            "xx.fr.translate_to.zne": "translate_zne_fr",
            "xx.sv.translate_to.yo": "translate_yo_sv",
            "xx.fr.translate_to.vi": "translate_vi_fr",
            "xx.it.translate_to.vi": "translate_vi_it",
            "xx.sv.translate_to.zne": "translate_zne_sv",
            "xx.fr.translate_to.yap": "translate_yap_fr",
            "xx.cs.translate_to.uk": "translate_uk_cs",
            "xx.es.translate_to.vi": "translate_vi_es",
            "xx.de.translate_to.uk": "translate_uk_de",
            "xx.sv.translate_to.uk": "translate_uk_sv",

        },

    }
    pretrained_models_references = {'af': {'af.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'af.lemma': 'lemma',
                                           'af.lemma.afribooms': 'lemma_afribooms',
                                           'af.pos': 'pos_afribooms',
                                           'af.stopwords': 'stopwords_iso',
                                           'af.stopwords.iso': 'stopwords_iso'},
                                    'als': {'als.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'am': {'am.embed.am_roberta': 'roberta_embeddings_am_roberta',
                                           'am.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'am.embed.xlm_roberta': 'xlm_roberta_base_finetuned_amharic',
                                           'am.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_amharic',
                                           'am.lemma': 'lemma',
                                           'am.pos': 'pos_ud_att',
                                           'am.stopwords': 'stopwords_iso'},
                                    'an': {'an.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ar': {'ar.answer_question.bert': 'bert_qa_arap_qa_bert',
                                           'ar.answer_question.bert.large_v2': 'bert_qa_arap_qa_bert_large_v2',
                                           'ar.answer_question.bert.v2': 'bert_qa_arap_qa_bert_v2',
                                           'ar.answer_question.electra': 'electra_qa_AraELECTRA_discriminator_SOQAL',
                                           'ar.answer_question.squad_arcd.electra': 'electra_qa_araElectra_SQUAD_ARCD',
                                           'ar.answer_question.squad_arcd.electra.768d': 'electra_qa_araElectra_SQUAD_ARCD_768',
                                           'ar.answer_question.squad_arcd.electra.base': 'electra_qa_AraElectra_base_finetuned_ARCD',
                                           'ar.answer_question.tydiqa.electra.base': 'electra_qa_ara_base_artydiqa',
                                           'ar.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_arabic',
                                           'ar.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_arabic_qa',
                                           'ar.embed': 'arabic_w2v_cc_300d',
                                           'ar.embed.AraBertMo_base_V1': 'bert_embeddings_AraBertMo_base_V1',
                                           'ar.embed.Ara_DialectBERT': 'bert_embeddings_Ara_DialectBERT',
                                           'ar.embed.DarijaBERT': 'bert_embeddings_DarijaBERT',
                                           'ar.embed.MARBERT': 'bert_embeddings_MARBERT',
                                           'ar.embed.MARBERTv2': 'bert_embeddings_MARBERTv2',
                                           'ar.embed.albert': 'albert_embeddings_albert_base_arabic',
                                           'ar.embed.albert_large_arabic': 'albert_embeddings_albert_large_arabic',
                                           'ar.embed.albert_xlarge_arabic': 'albert_embeddings_albert_xlarge_arabic',
                                           'ar.embed.aner': 'arabic_w2v_cc_300d',
                                           'ar.embed.aner.300d': 'arabic_w2v_cc_300d',
                                           'ar.embed.arabert_c19': 'bert_embeddings_arabert_c19',
                                           'ar.embed.arbert': 'bert_embeddings_ARBERT',
                                           'ar.embed.bert_base_arabert': 'bert_embeddings_bert_base_arabert',
                                           'ar.embed.bert_base_arabertv01': 'bert_embeddings_bert_base_arabertv01',
                                           'ar.embed.bert_base_arabertv02': 'bert_embeddings_bert_base_arabertv02',
                                           'ar.embed.bert_base_arabertv02_twitter': 'bert_embeddings_bert_base_arabertv02_twitter',
                                           'ar.embed.bert_base_arabertv2': 'bert_embeddings_bert_base_arabertv2',
                                           'ar.embed.bert_base_arabic': 'bert_embeddings_bert_base_arabic',
                                           'ar.embed.bert_base_arabic_camelbert_mix': 'bert_embeddings_bert_base_arabic_camelbert_mix',
                                           'ar.embed.bert_base_arabic_camelbert_msa': 'bert_embeddings_bert_base_arabic_camelbert_msa',
                                           'ar.embed.bert_base_arabic_camelbert_msa_eighth': 'bert_embeddings_bert_base_arabic_camelbert_msa_eighth',
                                           'ar.embed.bert_base_arabic_camelbert_msa_half': 'bert_embeddings_bert_base_arabic_camelbert_msa_half',
                                           'ar.embed.bert_base_arabic_camelbert_msa_quarter': 'bert_embeddings_bert_base_arabic_camelbert_msa_quarter',
                                           'ar.embed.bert_base_arabic_camelbert_msa_sixteenth': 'bert_embeddings_bert_base_arabic_camelbert_msa_sixteenth',
                                           'ar.embed.bert_base_qarib': 'bert_embeddings_bert_base_qarib',
                                           'ar.embed.bert_base_qarib60_1790k': 'bert_embeddings_bert_base_qarib60_1790k',
                                           'ar.embed.bert_base_qarib60_860k': 'bert_embeddings_bert_base_qarib60_860k',
                                           'ar.embed.bert_large_arabertv02': 'bert_embeddings_bert_large_arabertv02',
                                           'ar.embed.bert_large_arabertv02_twitter': 'bert_embeddings_bert_large_arabertv02_twitter',
                                           'ar.embed.bert_large_arabertv2': 'bert_embeddings_bert_large_arabertv2',
                                           'ar.embed.bert_large_arabic': 'bert_embeddings_bert_large_arabic',
                                           'ar.embed.bert_medium_arabic': 'bert_embeddings_bert_medium_arabic',
                                           'ar.embed.bert_mini_arabic': 'bert_embeddings_bert_mini_arabic',
                                           'ar.embed.cbow': 'arabic_w2v_cc_300d',
                                           'ar.embed.cbow.300d': 'arabic_w2v_cc_300d',
                                           'ar.embed.distilbert': 'distilbert_embeddings_distilbert_base_ar_cased',
                                           'ar.embed.dziribert': 'bert_embeddings_dziribert',
                                           'ar.embed.glove': 'arabic_w2v_cc_300d',
                                           'ar.embed.mbert_ar_c19': 'bert_embeddings_mbert_ar_c19',
                                           'ar.embed.multi_dialect_bert_base_arabic': 'bert_embeddings_multi_dialect_bert_base_arabic',
                                           'ar.lemma': 'lemma_padt',
                                           'ar.lemma.padt': 'lemma_padt',
                                           'ar.ner': 'aner_cc_300d',
                                           'ar.ner.ANER': 'bert_ner_ANER',
                                           'ar.ner.aner': 'aner_cc_300d',
                                           'ar.ner.arabert_ner': 'bert_ner_arabert_ner',
                                           'ar.ner.arabic_camelbert_da_ner': 'bert_ner_bert_base_arabic_camelbert_da_ner',
                                           'ar.ner.arabic_camelbert_mix_ner': 'bert_ner_bert_base_arabic_camelbert_mix_ner',
                                           'ar.ner.arabic_camelbert_msa_ner': 'bert_ner_bert_base_arabic_camelbert_msa_ner',
                                           'ar.ner.multilingual_cased_ner_hrl': 'bert_ner_bert_base_multilingual_cased_ner_hrl',
                                           'ar.pos': 'pos_padt',
                                           'ar.pos.arabic_camelbert_ca_pos_egy': 'bert_pos_bert_base_arabic_camelbert_ca_pos_egy',
                                           'ar.pos.arabic_camelbert_ca_pos_glf': 'bert_pos_bert_base_arabic_camelbert_ca_pos_glf',
                                           'ar.pos.arabic_camelbert_da_pos_egy': 'bert_pos_bert_base_arabic_camelbert_da_pos_egy',
                                           'ar.pos.arabic_camelbert_da_pos_glf': 'bert_pos_bert_base_arabic_camelbert_da_pos_glf',
                                           'ar.pos.arabic_camelbert_da_pos_msa': 'bert_pos_bert_base_arabic_camelbert_da_pos_msa',
                                           'ar.pos.arabic_camelbert_mix_pos_egy': 'bert_pos_bert_base_arabic_camelbert_mix_pos_egy',
                                           'ar.pos.arabic_camelbert_mix_pos_glf': 'bert_pos_bert_base_arabic_camelbert_mix_pos_glf',
                                           'ar.pos.arabic_camelbert_mix_pos_msa': 'bert_pos_bert_base_arabic_camelbert_mix_pos_msa',
                                           'ar.pos.arabic_camelbert_msa_pos_egy': 'bert_pos_bert_base_arabic_camelbert_msa_pos_egy',
                                           'ar.pos.arabic_camelbert_msa_pos_glf': 'bert_pos_bert_base_arabic_camelbert_msa_pos_glf',
                                           'ar.pos.arabic_camelbert_msa_pos_msa': 'bert_pos_bert_base_arabic_camelbert_msa_pos_msa',
                                           'ar.pos.padt': 'pos_padt',
                                           'ar.stopwords': 'stopwords_iso',
                                           'ar.stopwords.iso': 'stopwords_iso'},
                                    'arz': {'arz.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'as': {'as.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ast': {'ast.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'az': {'az.embed.w2v_cc_300d': 'w2v_cc_300d', 'az.stopwords': 'stopwords_iso'},
                                    'azb': {'azb.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ba': {'ba.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'bar': {'bar.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'bcl': {'bcl.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'be': {'be.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'be.lemma': 'lemma_hse',
                                           'be.pos': 'pos_hse',
                                           'be.pos.hse': 'pos_hse'},
                                    'bg': {'bg.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'bg.lemma': 'lemma',
                                           'bg.lemma.btb': 'lemma_btb',
                                           'bg.pos': 'pos_btb',
                                           'bg.pos.ud_btb': 'pos_ud_btb',
                                           'bg.stopwords': 'stopwords_iso',
                                           'bg.stopwords.iso': 'stopwords_iso'},
                                    'bh': {'bh.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'bh.lemma': 'lemma',
                                           'bh.pos': 'pos_ud_bhtb'},
                                    'bn': {
                                        'bn.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_mbert_bengali_tydiqa_qa',
                                        'bn.embed': 'bengali_cc_300d',
                                        'bn.embed.bangala_bert': 'bert_embeddings_bangla_bert_base',
                                        'bn.embed.bangla_bert': 'bert_embeddings_bangla_bert',
                                        'bn.embed.glove': 'bengali_cc_300d',
                                        'bn.embed.indic_transformers_bn_bert': 'bert_embeddings_indic_transformers_bn_bert',
                                        'bn.embed.indic_transformers_bn_distilbert': 'distilbert_embeddings_indic_transformers_bn_distilbert',
                                        'bn.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                        'bn.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'bn.lemma': 'lemma',
                                        'bn.ner': 'bengaliner_cc_300d',
                                        'bn.ner.glove': 'ner_jifs_glove_840B_300d',
                                        'bn.ner.jifs': 'ner_jifs_glove_840B_300d',
                                        'bn.pos': 'pos_msri',
                                        'bn.stopwords': 'stopwords_iso',
                                        'bn.stopwords.iso': 'stopwords_iso'},
                                    'bo': {'bo.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'bpy': {'bpy.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'br': {'br.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'br.lemma': 'lemma',
                                           'br.pos': 'pos_ud_keb',
                                           'br.stopwords': 'stopwords_br'},
                                    'bs': {'bs.detect_sentence': 'sentence_detector_dl',
                                           'bs.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ca': {
                                        'ca.answer_question.roberta.base_cased': 'roberta_qa_roberta_base_ca_cased_qa',
                                        'ca.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'ca.lemma': 'lemma_spacylookup',
                                        'ca.lemma.ancora': 'lemma_ancora',
                                        'ca.lemma.spacylookup': 'lemma_spacylookup',
                                        'ca.pos': 'pos_ud_ancora',
                                        'ca.pos.ancora': 'pos_ancora',
                                        'ca.stopwords': 'stopwords_iso',
                                        'ca.stopwords.iso': 'stopwords_iso'},
                                    'ce': {'ce.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ceb': {'ceb.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ch': {'ch.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_CH_XLM_R'},
                                    'ckb': {},
                                    'co': {'co.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'cop': {'cop.lemma': 'lemma_scriptorium',
                                            'cop.lemma.scriptorium': 'lemma_scriptorium',
                                            'cop.pos': 'pos_scriptorium'},
                                    'cs': {'cs.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'cs.lemma': 'lemma_cltt',
                                           'cs.lemma.cac': 'lemma_cac',
                                           'cs.lemma.cltt': 'lemma_cltt',
                                           'cs.lemma.fictree': 'lemma_fictree',
                                           'cs.lemma.pdt': 'lemma_pdt',
                                           'cs.lemma.spacylookup': 'lemma_spacylookup',
                                           'cs.pos': 'pos_fictree',
                                           'cs.pos.cac': 'pos_cac',
                                           'cs.pos.cltt': 'pos_cltt',
                                           'cs.pos.fictree': 'pos_fictree',
                                           'cs.pos.pdt': 'pos_pdt',
                                           'cs.pos.ud_pdt': 'pos_ud_pdt',
                                           'cs.stopwords': 'stopwords_iso',
                                           'cs.stopwords.iso': 'stopwords_iso'},
                                    'cu': {'cu.lemma': 'lemma_proiel',
                                           'cu.lemma.proiel': 'lemma_proiel',
                                           'cu.pos': 'pos_proiel'},
                                    'cv': {'cv.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'cy': {'cy.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'cy.lemma': 'lemma',
                                           'cy.lemma.ccg': 'lemma_ccg',
                                           'cy.pos.ccg': 'pos_ccg'},
                                    'da': {'da.answer_question.squad.bert': 'bert_qa_danish_bert_botxo_qa_squad',
                                           'da.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_da_da_saattrupdan',
                                           'da.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'da.lemma': 'lemma_spacylookup',
                                           'da.lemma.ddt': 'lemma_ddt',
                                           'da.lemma.spacylookup': 'lemma_spacylookup',
                                           'da.ner': 'dane_ner_6B_100',
                                           'da.ner.6B_100D': 'dane_ner_6B_100',
                                           'da.ner.6B_300D': 'dane_ner_6B_300',
                                           'da.ner.840B_300D': 'dane_ner_840B_300',
                                           'da.pos': 'pos_ud_ddt',
                                           'da.pos.ddt': 'pos_ddt',
                                           'da.stopwords': 'stopwords_iso'},
                                    'de': {'de.answer_question.bert': 'bert_qa_GBERTQnA',
                                           'de.answer_question.electra': 'electra_qa_German_question_answer',
                                           'de.answer_question.electra.base': 'electra_qa_g_base_germanquad',
                                           'de.answer_question.electra.distilled_base': 'electra_qa_g_base_germanquad_distilled',
                                           'de.answer_question.electra.large': 'electra_qa_g_large_germanquad',
                                           'de.answer_question.squad_de_tuned.xlmr_roberta.base.by_saattrupdan': 'xlm_roberta_qa_xlmr_base_texas_squad_de_de_saattrupdan',
                                           'de.answer_question.squad_spanish_tuned.xlmr_roberta.base.by_saattrupdan': 'xlm_roberta_qa_xlmr_base_texas_squad_es_es_saattrupdan',
                                           'de.answer_question.squadv2.bert': 'bert_qa_bert_multi_english_german_squad2',
                                           'de.answer_question.squadv2.electra.base': 'electra_qa_base_squad2',
                                           'de.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_DE_XLM_R',
                                           'de.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_german',
                                           'de.classify.news': 'classifierdl_bert_news',
                                           'de.classify.news_sentiment.bert': 'bert_sequence_classifier_news_sentiment',
                                           'de.classify.sentiment.bert': 'classifierdl_bert_sentiment',
                                           'de.embed.albert_german_ner': 'albert_embeddings_albert_german_ner',
                                           'de.embed.bert': 'bert_base_german_cased',
                                           'de.embed.bert.uncased': 'bert_base_german_uncased',
                                           'de.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                           'de.embed.bert_base_de_cased': 'bert_embeddings_bert_base_de_cased',
                                           'de.embed.bert_base_german_cased_oldvocab': 'bert_embeddings_bert_base_german_cased_oldvocab',
                                           'de.embed.bert_base_german_dbmdz_cased': 'bert_embeddings_bert_base_german_dbmdz_cased',
                                           'de.embed.bert_base_german_dbmdz_uncased': 'bert_embeddings_bert_base_german_dbmdz_uncased',
                                           'de.embed.bert_base_german_uncased': 'bert_embeddings_bert_base_german_uncased',
                                           'de.embed.bert_base_historical_german_rw_cased': 'bert_embeddings_bert_base_historical_german_rw_cased',
                                           'de.embed.distilbert_base_de_cased': 'distilbert_embeddings_distilbert_base_de_cased',
                                           'de.embed.distilbert_base_german_cased': 'distilbert_embeddings_distilbert_base_german_cased',
                                           'de.embed.gbert_base': 'bert_embeddings_gbert_base',
                                           'de.embed.gbert_large': 'bert_embeddings_gbert_large',
                                           'de.embed.german_financial_statements_bert': 'bert_embeddings_german_financial_statements_bert',
                                           'de.embed.medbert': 'bert_embeddings_German_MedBERT',
                                           'de.embed.roberta_base_wechsel_german': 'roberta_embeddings_roberta_base_wechsel_german',
                                           'de.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'de.lemma': 'lemma_spacylookup',
                                           'de.lemma.gsd': 'lemma_gsd',
                                           'de.lemma.hdt': 'lemma_hdt',
                                           'de.lemma.spacylookup': 'lemma_spacylookup',
                                           'de.ner': 'wikiner_840B_300',
                                           'de.ner.wikiner': 'wikiner_840B_300',
                                           'de.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'de.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'de.ner.xlm': 'xlm_roberta_large_token_classifier_conll03',
                                           'de.pos': 'pos_ud_hdt',
                                           'de.pos.gsd': 'pos_gsd',
                                           'de.pos.hdt': 'pos_hdt',
                                           'de.pos.ud_hdt': 'pos_ud_hdt',
                                           'de.stopwords': 'stopwords_iso',
                                           'de.stopwords.iso': 'stopwords_iso'},
                                    'diq': {'diq.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'dv': {'dv.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'el': {'el.answer_question.bert': 'bert_qa_qacombination_bert_el_Danastos',
                                           'el.embed.bert.base_uncased': 'bert_base_uncased',
                                           'el.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
                                           'el.lemma': 'lemma',
                                           'el.lemma.gdt': 'lemma_gdt',
                                           'el.pos': 'pos_ud_gdt',
                                           'el.pos.gdt': 'pos_gdt',
                                           'el.pos.ud_gdt': 'pos_ud_gdt',
                                           'el.stopwords': 'stopwords_iso',
                                           'el.stopwords.iso': 'stopwords_iso'},
                                    'eml': {'eml.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'en': {

                                        'en.coreference.spanbert': 'spanbert_base_coref',

                                        'en.albert': 'albert_base_uncased',
                                        'en.answer_qu estion.mqa_cls.bert.by_xraychen': 'bert_qa_mqa_cls',
                                        'en.answer_question.albert': 'albert_qa_generic',
                                        'en.answer_question.albert.by_AyushPJ': 'albert_qa_ai_club_inductions_21_nlp',
                                        'en.answer_question.albert.by_SalmanMo': 'albert_qa_QA_1e',
                                        'en.answer_question.albert.by_nlpunibo': 'albert_qa_nlpunibo',
                                        'en.answer_question.albert.by_rowan1224': 'albert_qa_slp',
                                        'en.answer_question.albert.by_saburbutt': 'albert_qa_generic',
                                        'en.answer_question.albert.xl': 'albert_qa_xlarge_finetuned',
                                        'en.answer_question.bert': 'bert_qa_no_need_to_name_this',
                                        'en.answer_question.bert.32d': 'bert_qa_bert_set_date_1_lr_2e_5_bs_32_ep_4',
                                        'en.answer_question.bert.augmented': 'bert_qa_augmented',
                                        'en.answer_question.bert.base': 'bert_qa_bert_base_faquad',
                                        'en.answer_question.bert.base.by_peggyhuang': 'bert_qa_finetune_bert_base_v1',
                                        'en.answer_question.bert.base.by_ricardo-filho': 'bert_qa_bert_base_faquad',
                                        'en.answer_question.bert.base.by_xraychen': 'bert_qa_mqa_baseline',
                                        'en.answer_question.bert.base_cased': 'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3',
                                        'en.answer_question.bert.base_cased.by_CenIA': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_tar',
                                        'en.answer_question.bert.base_cased.by_husnu': 'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3',
                                        'en.answer_question.bert.base_cased.by_nntadotzip': 'bert_qa_bert_base_cased_IUChatbot_ontologyDts',
                                        'en.answer_question.bert.base_uncased': 'bert_qa_bert_base_uncased_coqa',
                                        'en.answer_question.bert.base_uncased.by_CenIA': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_tar',
                                        'en.answer_question.bert.base_uncased.by_machine2049': 'bert_qa_bert_base_uncased_finetuned_duorc_bert',
                                        'en.answer_question.bert.base_uncased.by_peggyhuang': 'bert_qa_bert_base_uncased_coqa',
                                        'en.answer_question.bert.base_uncased.by_vanadhi': 'bert_qa_bert_base_uncased_fiqa_flm_sq_flit',
                                        'en.answer_question.bert.base_v2': 'bert_qa_finetune_bert_base_v2',
                                        'en.answer_question.bert.base_v3.by_peggyhuang': 'bert_qa_finetune_bert_base_v3',
                                        'en.answer_question.bert.by_Danastos': 'bert_qa_nq_bert_el_Danastos',
                                        'en.answer_question.bert.by_ForutanRad': 'bert_qa_bert_fa_QA_v1',
                                        'en.answer_question.bert.by_HankyStyle': 'bert_qa_Multi_ling_BERT',
                                        'en.answer_question.bert.by_LenaSchmidt': 'bert_qa_no_need_to_name_this',
                                        'en.answer_question.bert.by_Rocketknight1': 'bert_qa_bert_finetuned_qa',
                                        'en.answer_question.bert.by_SanayCo': 'bert_qa_model_output',
                                        'en.answer_question.bert.by_aymanm419': 'bert_qa_araSpeedest',
                                        'en.answer_question.bert.by_ericRosello': 'bert_qa_results',
                                        'en.answer_question.bert.by_internetoftim': 'bert_qa_demo',
                                        'en.answer_question.bert.by_jackh1995': 'bert_qa_bert_finetuned_jackh1995',
                                        'en.answer_question.bert.by_krinal214': 'bert_qa_bert_all_translated',
                                        'en.answer_question.bert.by_manav': 'bert_qa_causal_qa',
                                        'en.answer_question.bert.by_mezes': 'bert_qa_eauction_section_parsing_from_pretrained',
                                        'en.answer_question.bert.by_motiondew': 'bert_qa_bert_finetuned_lr2_e5_b16_ep2',
                                        'en.answer_question.bert.by_mrm8488': 'bert_qa_ManuERT_for_xqua',
                                        'en.answer_question.bert.by_nlpunibo': 'bert_qa_bert',
                                        'en.answer_question.bert.by_nvkha': 'bert_qa_bert_qa_vi_nvkha',
                                        'en.answer_question.bert.by_piEsposito': 'bert_qa_braquad_bert_qna',
                                        'en.answer_question.bert.by_voidful': 'bert_qa_question_answering_zh_voidful',
                                        'en.answer_question.bert.by_z-uo': 'bert_qa_bert_qasper',
                                        'en.answer_question.bert.distilled_base_uncased': 'bert_qa_distilbert_base_uncased_finetuned_custom',
                                        'en.answer_question.bert.docvqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_docvqa',
                                        'en.answer_question.bert.infovqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_infovqa',
                                        'en.answer_question.bert.large': 'bert_qa_bert_large_question_answering_finetuned_legal',
                                        'en.answer_question.bert.large.by_Sounak': 'bert_qa_bert_large_finetuned',
                                        'en.answer_question.bert.large.by_atharvamundada99': 'bert_qa_bert_large_question_answering_finetuned_legal',
                                        'en.answer_question.bert.large.by_ricardo-filho': 'bert_qa_bert_large_faquad',
                                        'en.answer_question.bert.large_cased': 'bert_qa_muril_large_cased_hita_qa',
                                        'en.answer_question.bert.large_uncased': 'bert_qa_bert_large_uncased_finetuned_docvqa',
                                        'en.answer_question.bert.multilingual_arabic_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_arabic',
                                        'en.answer_question.bert.multilingual_english_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_english',
                                        'en.answer_question.bert.multilingual_german_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_german',
                                        'en.answer_question.bert.multilingual_hindi_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_hindi',
                                        'en.answer_question.bert.multilingual_spanish_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_spanish',
                                        'en.answer_question.bert.multilingual_vietnamese_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_vietnamese',
                                        'en.answer_question.bert.sim.by_xraychen': 'bert_qa_mqa_sim',
                                        'en.answer_question.bert.unsupsim.by_xraychen': 'bert_qa_mqa_unsupsim',
                                        'en.answer_question.bert.vi_infovqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_vi_infovqa',
                                        'en.answer_question.bert.xtremedistiled_uncased_lr_2e_05_epochs_3.by_husnu': 'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_3',
                                        'en.answer_question.bert.xtremedistiled_uncased_lr_2e_05_epochs_6.by_husnu': 'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_6',
                                        'en.answer_question.bert.zero_shot': 'bert_qa_fewrel_zero_shot',
                                        'en.answer_question.bert.zero_shot.by_fractalego': 'bert_qa_fewrel_zero_shot',
                                        'en.answer_question.bert.zero_shot.by_krinal214': 'bert_qa_zero_shot',
                                        'en.answer_question.bio_clinical.bert': 'bert_qa_sagemaker_BioclinicalBERT_ADR',
                                        'en.answer_question.bio_medical.bert.base': 'bert_qa_biomedical_slot_filling_reader_base',
                                        'en.answer_question.bio_medical.bert.large': 'bert_qa_biomedical_slot_filling_reader_large',
                                        'en.answer_question.biobert': 'bert_qa_biobert_bioasq',
                                        'en.answer_question.chaii.bert.base_cased': 'bert_qa_bert_base_cased_chaii',
                                        'en.answer_question.chaii.bert.cased': 'bert_qa_bert_multi_cased_finetuned_chaii',
                                        'en.answer_question.chaii.bert.large_uncased_uncased_whole_word_masking.by_SauravMaheshkar': 'bert_qa_bert_large_uncased_whole_word_masking_chaii',
                                        'en.answer_question.chaii.bert.large_uncased_uncased_whole_word_masking_finetuned.by_SauravMaheshkar': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_chaii',
                                        'en.answer_question.chaii.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_chaii',
                                        'en.answer_question.chaii.bert.uncased': 'bert_qa_bert_multi_uncased_finetuned_chaii',
                                        'en.answer_question.chaii.distil_bert': 'distilbert_qa_multi_finetuned_for_xqua_on_chaii',
                                        'en.answer_question.chaii.distil_bert.base_cased': 'distilbert_qa_base_cased_distilled_chaii',
                                        'en.answer_question.chaii.distil_bert.base_uncased': 'distilbert_qa_base_uncased_distilled_chaii',
                                        'en.answer_question.chaii.electra.base': 'electra_qa_base_chaii',
                                        'en.answer_question.chaii.roberta.base': 'roberta_qa_roberta_base_chaii',
                                        'en.answer_question.chaii.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_finetuned_chaii',
                                        'en.answer_question.chaii.xlm_roberta.base.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_roberta_base_chaii',
                                        'en.answer_question.chaii.xlm_roberta.base.by_tyqiangz': 'xlm_roberta_qa_xlm_roberta_base_finetuned_chaii',
                                        'en.answer_question.chaii.xlm_roberta.large.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_roberta_large_chaii',
                                        'en.answer_question.chaii.xlm_roberta.large_multi.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_multi_roberta_large_chaii',
                                        'en.answer_question.clinical.distil_bert': 'distilbert_qa_BERT_ClinicalQA',
                                        'en.answer_question.conll.distil_bert.base_uncased': 'distilbert_qa_base_uncased_qa_with_ner',
                                        'en.answer_question.cord19.bert.by_JAlexis': 'bert_qa_Bertv1_fine',
                                        'en.answer_question.cord19.bert.small': 'bert_qa_bert_small_cord19qa',
                                        'en.answer_question.cord19.prueba_bert.by_JAlexis': 'bert_qa_PruebaBert',
                                        'en.answer_question.covid.distil_bert.a.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTa',
                                        'en.answer_question.covid.distil_bert.b.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTb',
                                        'en.answer_question.covid.distil_bert.c.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTc',
                                        'en.answer_question.covid.longformer': 'longformer_qa_covid',
                                        'en.answer_question.covid_bert.a.by_rahulkuruvilla': 'bert_qa_COVID_BERTa',
                                        'en.answer_question.covid_bert.b.by_rahulkuruvilla': 'bert_qa_COVID_BERTb',
                                        'en.answer_question.covid_bert.c.by_rahulkuruvilla': 'bert_qa_COVID_BERTc',
                                        'en.answer_question.cuad.roberta.base': 'roberta_qa_marshmellow77_roberta_base_cuad',
                                        'en.answer_question.cuad.roberta.base.by_Gam': 'roberta_qa_roberta_base_finetuned_cuad',
                                        'en.answer_question.cuad.roberta.base.by_Rakib': 'roberta_qa_roberta_base_on_cuad',
                                        'en.answer_question.cuad.roberta.base.by_akdeniz27': 'roberta_qa_akdeniz27_roberta_base_cuad',
                                        'en.answer_question.cuad.roberta.base.by_marshmellow77': 'roberta_qa_marshmellow77_roberta_base_cuad',
                                        'en.answer_question.cuad.roberta.large': 'roberta_qa_roberta_large_cuad',
                                        'en.answer_question.cuad_gam.roberta.base.by_Gam': 'roberta_qa_roberta_base_finetuned_cuad_gam',
                                        'en.answer_question.distil_bert': 'distilbert_qa_projectmodel_bert',
                                        'en.answer_question.distil_bert.base': 'distilbert_qa_robustqa_baseline_02',
                                        'en.answer_question.distil_bert.base.by_leemii18': 'distilbert_qa_robustqa_baseline_02',
                                        'en.answer_question.distil_bert.base.by_minhdang241': 'distilbert_qa_robustqa_baseline_01',
                                        'en.answer_question.distil_bert.base_cased': 'distilbert_qa_bert_base_cased_finetuned_log_parser_winlogbeat',
                                        'en.answer_question.distil_bert.base_cased.by_Slavka': 'distilbert_qa_bert_base_cased_finetuned_log_parser_winlogbeat',
                                        'en.answer_question.distil_bert.base_cased.by_adamlin': 'distilbert_qa_base_cased_sgd_qa_step5000',
                                        'en.answer_question.distil_bert.base_config1.by_nlpunibo': 'distilbert_qa_base_config1',
                                        'en.answer_question.distil_bert.base_config2.by_nlpunibo': 'distilbert_qa_base_config2',
                                        'en.answer_question.distil_bert.base_config3.by_nlpunibo': 'distilbert_qa_base_config3',
                                        'en.answer_question.distil_bert.base_uncased': 'distilbert_qa_base_uncased_finetuned_advers',
                                        'en.answer_question.distil_bert.base_uncased.by_T-qualizer': 'distilbert_qa_base_uncased_finetuned_advers',
                                        'en.answer_question.distil_bert.base_uncased.by_charlieoneill': 'distilbert_qa_base_uncased_gradient_clinic',
                                        'en.answer_question.distil_bert.base_uncased.by_datarpit': 'distilbert_qa_base_uncased_finetuned_natural_questions',
                                        'en.answer_question.distil_bert.base_uncased.by_machine2049': 'distilbert_qa_base_uncased_finetuned_duorc_',
                                        'en.answer_question.distil_bert.base_uncased.by_tiennvcs': 'distilbert_qa_base_uncased_finetuned_infovqa',
                                        'en.answer_question.distil_bert.by_Ifenna': 'distilbert_qa_dbert_3epoch',
                                        'en.answer_question.distil_bert.by_LucasS': 'distilbert_qa_distilBertABSA',
                                        'en.answer_question.distil_bert.by_Sarmad': 'distilbert_qa_projectmodel_bert',
                                        'en.answer_question.distil_bert.by_Sounak': 'distilbert_qa_finetuned',
                                        'en.answer_question.distil_bert.by_ajaypyatha': 'distilbert_qa_sdsqna',
                                        'en.answer_question.distil_bert.by_alinemati': 'distilbert_qa_BERT',
                                        'en.answer_question.distil_bert.by_keras-io': 'distilbert_qa_transformers_qa',
                                        'en.answer_question.distil_bert.by_minhdang241': 'distilbert_qa_robustqa_tapt',
                                        'en.answer_question.distil_bert.by_pakupoko': 'distilbert_qa_bizlin_distil_model',
                                        'en.answer_question.distil_bert.by_poom-sci': 'distilbert_qa_qa',
                                        'en.answer_question.distil_bert.custom.by_aszidon': 'distilbert_qa_custom',
                                        'en.answer_question.distil_bert.custom3.by_aszidon': 'distilbert_qa_custom3',
                                        'en.answer_question.distil_bert.custom4.by_aszidon': 'distilbert_qa_custom4',
                                        'en.answer_question.distil_bert.custom5.by_aszidon': 'distilbert_qa_custom5',
                                        'en.answer_question.distil_bert.flat_n_max.by_mcurmei': 'distilbert_qa_flat_N_max',
                                        'en.answer_question.distil_bert.log_parser.by_Slavka': 'distilbert_qa_distil_bert_finetuned_log_parser_1',
                                        'en.answer_question.distil_bert.log_parser_winlogbeat.by_Slavka': 'distilbert_qa_distil_bert_finetuned_log_parser_winlogbeat',
                                        'en.answer_question.distil_bert.single_label_n_max.by_mcurmei': 'distilbert_qa_single_label_N_max',
                                        'en.answer_question.distil_bert.single_label_n_max_long_training.by_mcurmei': 'distilbert_qa_single_label_N_max_long_training',
                                        'en.answer_question.distil_bert.unique_n_max.by_mcurmei': 'distilbert_qa_unique_N_max',
                                        'en.answer_question.electra': 'electra_qa_TestQA2',
                                        'en.answer_question.electra.by_Andranik': 'electra_qa_TestQA2',
                                        'en.answer_question.electra.by_carlosserquen': 'electra_qa_elctrafp',
                                        'en.answer_question.electra.by_rowan1224': 'electra_qa_slp',
                                        'en.answer_question.electra.finetuning_1': 'electra_qa_DSPFirst_Finetuning_1',
                                        'en.answer_question.electra.finetuning_2': 'electra_qa_DSPFirst_Finetuning_2',
                                        'en.answer_question.electra.finetuning_3': 'electra_qa_DSPFirst_Finetuning_3',
                                        'en.answer_question.electra.finetuning_4': 'electra_qa_DSPFirst_Finetuning_4',
                                        'en.answer_question.electra.finetuning_5': 'electra_qa_DSPFirst_Finetuning_5',
                                        'en.answer_question.klue.bert': 'bert_qa_Klue_CommonSense_model',
                                        'en.answer_question.klue.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_klue',
                                        'en.answer_question.klue.xlm_roberta.base': 'xlm_roberta_qa_klue_mrc_roberta_base',
                                        'en.answer_question.korquad.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_korquad_v1',
                                        'en.answer_question.korquad.bert.multilingual_base_cased.by_eliza-dukim': 'bert_qa_bert_base_multilingual_cased_korquad_v1',
                                        'en.answer_question.korquad.bert.multilingual_base_cased.by_sangrimlee': 'bert_qa_bert_base_multilingual_cased_korquad',
                                        'en.answer_question.korquad.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_korquad_mask',
                                        'en.answer_question.longformer': 'longformer_qa_ponmari',
                                        'en.answer_question.longformer.by_Nomi97': 'longformer_qa_Chatbot',
                                        'en.answer_question.longformer.by_manishiitg': 'longformer_qa_recruit',
                                        'en.answer_question.longformer.by_ponmari': 'longformer_qa_ponmari',
                                        'en.answer_question.longformer.large': 'longformer_qa_recruit_large',
                                        'en.answer_question.longformer.v2': 'longformer_qa_recruit_v2',
                                        'en.answer_question.mitmovie_squad.roberta.by_thatdramebaazguy': 'roberta_qa_movie_roberta_MITmovie_squad',
                                        'en.answer_question.mlqa.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_mlqa',
                                        'en.answer_question.mlqa.bert.base_uncased': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_mlqa',
                                        'en.answer_question.movie_squad.roberta.base': 'roberta_qa_roberta_base_MITmovie_squad',
                                        'en.answer_question.movie_squad.roberta.by_thatdramebaazguy': 'roberta_qa_movie_roberta_squad',
                                        'en.answer_question.movie_squadv2.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_movie_with_neg_with_repeat',
                                        'en.answer_question.mqa_cls.bert.by_xraychen': 'bert_qa_mqa_cls',
                                        'en.answer_question.multi_lingual_bert': 'bert_qa_mBERT_all_ty_SQen_SQ20_1',
                                        'en.answer_question.multi_lingual_bert.by_horsbug98': 'bert_qa_Part_1_mBERT_Model_E2',
                                        'en.answer_question.multi_lingual_bert.by_krinal214': 'bert_qa_mBERT_all_ty_SQen_SQ20_1',
                                        'en.answer_question.news.bert': 'bert_qa_newsqa_bert_el_Danastos',
                                        'en.answer_question.news.bert.base_uncased': 'bert_qa_unqover_bert_base_uncased_newsqa',
                                        'en.answer_question.news.bert.base_uncased.by_mirbostani': 'bert_qa_bert_base_uncased_finetuned_newsqa',
                                        'en.answer_question.news.bert.base_uncased.by_tli8hf': 'bert_qa_unqover_bert_base_uncased_newsqa',
                                        'en.answer_question.news.bert.by_AnonymousSub': 'bert_qa_news_pretrain_bert_FT_newsqa',
                                        'en.answer_question.news.bert.by_Danastos': 'bert_qa_newsqa_bert_el_Danastos',
                                        'en.answer_question.news.bert.fpdm_ft.by_AnonymousSub': 'bert_qa_fpdm_bert_FT_newsqa',
                                        'en.answer_question.news.bert.fpdm_ft_new.by_AnonymousSub': 'bert_qa_fpdm_bert_FT_new_newsqa',
                                        'en.answer_question.news.bert.fpdm_hier_ft.by_AnonymousSub': 'bert_qa_fpdm_hier_bert_FT_newsqa',
                                        'en.answer_question.news.bert.fpdm_hier_ft_by_AnonymousSub': 'bert_qa_fpdm_hier_bert_FT_new_newsqa',
                                        'en.answer_question.news.bert.ft.by_AnonymousSub': 'bert_qa_bert_FT_newsqa',
                                        'en.answer_question.news.bert.ft_new.by_AnonymousSub': 'bert_qa_bert_FT_new_newsqa',
                                        'en.answer_question.news.bert.new.by_AnonymousSub': 'bert_qa_news_pretrain_bert_FT_new_newsqa',
                                        'en.answer_question.news.bert.qa_fpdm_triplet_ft.by_AnonymousSub': 'bert_qa_fpdm_triplet_bert_FT_newsqa',
                                        'en.answer_question.news.bert.qa_fpdm_triplet_ft_new.by_AnonymousSub': 'bert_qa_fpdm_triplet_bert_FT_new_newsqa',
                                        'en.answer_question.news.distil_bert.base_uncased': 'distilbert_qa_unqover_base_uncased_newsqa',
                                        'en.answer_question.news.roberta.base': 'roberta_qa_unqover_roberta_base_newsqa',
                                        'en.answer_question.news.roberta.large': 'roberta_qa_unqover_roberta_large_newsqa',
                                        'en.answer_question.news.roberta.qa_fpdm_hier_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_hier_roberta_FT_new_newsqa',
                                        'en.answer_question.news.roberta.qa_fpdm_hier_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_hier_roberta_FT_newsqa',
                                        'en.answer_question.news.roberta.qa_fpdm_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_roberta_FT_newsqa',
                                        'en.answer_question.news.roberta.qa_fpdm_triplet_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_triplet_roberta_FT_new_newsqa',
                                        'en.answer_question.news.roberta.qa_fpdm_triplet_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_triplet_roberta_FT_newsqa',
                                        'en.answer_question.news.roberta.qa_ft.by_AnonymousSub': 'roberta_qa_news_pretrain_roberta_FT_newsqa',
                                        'en.answer_question.news.roberta.qa_ft_new.by_AnonymousSub': 'roberta_qa_news_pretrain_roberta_FT_new_newsqa',
                                        'en.answer_question.news.roberta.qa_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_roberta_FT_new_newsqa',
                                        'en.answer_question.news.roberta.qa_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_roberta_FT_newsqa',
                                        'en.answer_question.output_files.bert.by_sunitha': 'bert_qa_output_files',
                                        'en.answer_question.pubmed.bert.base_uncased': 'bert_qa_Sotireas_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
                                        'en.answer_question.pubmed.bert.base_uncased.by_Shushant': 'bert_qa_Shushant_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
                                        'en.answer_question.pubmed.bert.base_uncased.by_Sotireas': 'bert_qa_Sotireas_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
                                        'en.answer_question.roberta': 'roberta_qa_robertaBaseABSA',
                                        'en.answer_question.roberta.756523213.by_AlirezaBaneshi': 'roberta_qa_autotrain_test2_756523213',
                                        'en.answer_question.roberta.756523214.by_AlirezaBaneshi': 'roberta_qa_autotrain_test2_756523214',
                                        'en.answer_question.roberta.augmented': 'roberta_qa_roberta_unaugmentedv3',
                                        'en.answer_question.roberta.base': 'roberta_qa_roberta_base_custom_QA',
                                        'en.answer_question.roberta.base.by_123tarunanand': 'roberta_qa_roberta_base_finetuned',
                                        'en.answer_question.roberta.base.by_eAsyle': 'roberta_qa_roberta_base_custom_QA',
                                        'en.answer_question.roberta.base.by_emr-se-miniproject': 'roberta_qa_roberta_base_emr',
                                        'en.answer_question.roberta.base.by_nlpconnect': 'roberta_qa_dpr_nq_reader_roberta_base',
                                        'en.answer_question.roberta.base.by_rsvp-ai': 'roberta_qa_bertserini_roberta_base',
                                        'en.answer_question.roberta.base_v2': 'roberta_qa_dpr_nq_reader_roberta_base_v2',
                                        'en.answer_question.roberta.by_AmazonScience': 'roberta_qa_qanlu',
                                        'en.answer_question.roberta.by_Andranik': 'roberta_qa_TestQaV1',
                                        'en.answer_question.roberta.by_AyushPJ': 'roberta_qa_ai_club_inductions_21_nlp_roBERTa',
                                        'en.answer_question.roberta.by_Beri': 'roberta_qa_legal_qa',
                                        'en.answer_question.roberta.by_CNT-UPenn': 'roberta_qa_RoBERTa_for_seizureFrequency_QA',
                                        'en.answer_question.roberta.by_Ching': 'roberta_qa_negation_detector',
                                        'en.answer_question.roberta.by_LucasS': 'roberta_qa_robertaBaseABSA',
                                        'en.answer_question.roberta.by_Mr-Wick': 'roberta_qa_Roberta',
                                        'en.answer_question.roberta.by_Nakul24': 'roberta_qa_RoBERTa_emotion_extraction',
                                        'en.answer_question.roberta.by_aravind-812': 'roberta_qa_roberta_train_json',
                                        'en.answer_question.roberta.by_arjunth2001': 'roberta_qa_priv_qna',
                                        'en.answer_question.roberta.by_billfrench': 'roberta_qa_cyberlandr_door',
                                        'en.answer_question.roberta.by_nlpunibo': 'roberta_qa_nlpunibo_roberta',
                                        'en.answer_question.roberta.by_pierrerappolt': 'roberta_qa_cart',
                                        'en.answer_question.roberta.by_shmuelamar': 'roberta_qa_REQA_RoBERTa',
                                        'en.answer_question.roberta.by_stevemobs': 'roberta_qa_quales_iberlef',
                                        'en.answer_question.roberta.by_sunitha': 'roberta_qa_roberta_customds_finetune',
                                        'en.answer_question.roberta.by_veronica320': 'roberta_qa_QA_for_Event_Extraction',
                                        'en.answer_question.roberta.by_vesteinn': 'roberta_qa_IceBERT_QA',
                                        'en.answer_question.roberta.by_z-uo': 'roberta_qa_roberta_qasper',
                                        'en.answer_question.roberta.ch_tuned.by_Gantenbein': 'roberta_qa_ADDI_CH_RoBERTa',
                                        'en.answer_question.roberta.cv_custom_ds.by_sunitha': 'roberta_qa_CV_Custom_DS',
                                        'en.answer_question.roberta.cv_merge_ds.by_sunitha': 'roberta_qa_CV_Merge_DS',
                                        'en.answer_question.roberta.de_tuned.by_Gantenbein': 'roberta_qa_ADDI_DE_RoBERTa',
                                        'en.answer_question.roberta.eda_and_parav3.by_comacrae': 'roberta_qa_roberta_eda_and_parav3',
                                        'en.answer_question.roberta.edav3.by_comacrae': 'roberta_qa_roberta_edav3',
                                        'en.answer_question.roberta.fi_tuned.by_Gantenbein': 'roberta_qa_ADDI_FI_RoBERTa',
                                        'en.answer_question.roberta.fr_tuned.by_Gantenbein': 'roberta_qa_ADDI_FR_RoBERTa',
                                        'en.answer_question.roberta.it_tuned.by_Gantenbein': 'roberta_qa_ADDI_IT_RoBERTa',
                                        'en.answer_question.roberta.large_init_large_seed_0.by_anas-awadalla': 'roberta_qa_roberta_large_initialization_seed_0',
                                        'en.answer_question.roberta.large_seed_0.by_anas-awadalla': 'roberta_qa_roberta_large_data_seed_0',
                                        'en.answer_question.roberta.large_seed_4': 'roberta_qa_roberta_large_data_seed_4',
                                        'en.answer_question.roberta.paraphrasev3.by_comacrae': 'roberta_qa_roberta_paraphrasev3',
                                        'en.answer_question.roberta.techqa_cline.by_AnonymousSub': 'roberta_qa_cline_techqa',
                                        'en.answer_question.roberta.techqa_cline_emanuals.by_AnonymousSub': 'roberta_qa_cline_emanuals_techqa',
                                        'en.answer_question.roberta.techqa_declutr.by_AnonymousSub': 'roberta_qa_declutr_techqa',
                                        'en.answer_question.roberta.techqa_declutr_emanuals.by_AnonymousSub': 'roberta_qa_declutr_emanuals_techqa',
                                        'en.answer_question.roberta.testabsa.by_eAsyle': 'roberta_qa_testABSA',
                                        'en.answer_question.roberta.testabsa3.by_eAsyle': 'roberta_qa_testABSA3',
                                        'en.answer_question.roberta.tiny_768d': 'roberta_qa_tinyroberta_6l_768d',
                                        'en.answer_question.roberta.unaugv3.by_comacrae': 'roberta_qa_roberta_unaugv3',
                                        'en.answer_question.roberta_absa': 'roberta_qa_robertaABSA',
                                        'en.answer_question.scibert.v2': 'bert_qa_nolog_SciBert_v2',
                                        'en.answer_question.span_bert': 'bert_qa_Spanbert_emotion_extraction',
                                        'en.answer_question.span_bert.by_Nakul24': 'bert_qa_Spanbert_emotion_extraction',
                                        'en.answer_question.span_bert.by_manishiitg': 'bert_qa_spanbert_recruit_qa',
                                        'en.answer_question.span_bert.large': 'bert_qa_spanbert_large_recruit_qa',
                                        'en.answer_question.sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_sqac',
                                        'en.answer_question.sqac.bert.base_uncased': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_sqac',
                                        'en.answer_question.squad.albert': 'albert_qa_squad_2.0',
                                        'en.answer_question.squad.albert.base_v2': 'albert_qa_base_v2_squad',
                                        'en.answer_question.squad.albert.by_SS8': 'albert_qa_squad_2.0',
                                        'en.answer_question.squad.albert.by_rowan1224': 'albert_qa_squad_slp',
                                        'en.answer_question.squad.albert.xl': 'albert_qa_xlarge_finetuned_squad',
                                        'en.answer_question.squad.albert.xxl': 'albert_qa_xxlarge_finetuned_squad',
                                        'en.answer_question.squad.bert': 'bert_qa_neuralmagic_bert_squad_12layer_0sparse',
                                        'en.answer_question.squad.bert.accelerate.by_KevinChoi': 'bert_qa_KevinChoi_bert_finetuned_squad_accelerate',
                                        'en.answer_question.squad.bert.accelerate.by_huggingface-course': 'bert_qa_huggingface_course_bert_finetuned_squad_accelerate',
                                        'en.answer_question.squad.bert.accelerate.by_peterhsu': 'bert_qa_peterhsu_bert_finetuned_squad_accelerate',
                                        'en.answer_question.squad.bert.accelerate.by_youngjae': 'bert_qa_youngjae_bert_finetuned_squad_accelerate',
                                        'en.answer_question.squad.bert.augmented': 'bert_qa_augmented_Squad_Translated',
                                        'en.answer_question.squad.bert.base': 'bert_qa_bert_mini_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.base.by_mrm8488': 'bert_qa_bert_mini_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.base.by_rsvp-ai': 'bert_qa_bertserini_bert_base_squad',
                                        'en.answer_question.squad.bert.base.by_vuiseng9': 'bert_qa_bert_base_squadv1',
                                        'en.answer_question.squad.bert.base.by_xraychen': 'bert_qa_squad_baseline',
                                        'en.answer_question.squad.bert.base.by_zhufy': 'bert_qa_squad_en_bert_base',
                                        'en.answer_question.squad.bert.base_cased': 'bert_qa_andresestevez_bert_base_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_cased.by_KB': 'bert_qa_bert_base_swedish_cased_squad_experimental',
                                        'en.answer_question.squad.bert.base_cased.by_Seongkyu': 'bert_qa_Seongkyu_bert_base_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_cased.by_SreyanG-NVIDIA': 'bert_qa_SreyanG_NVIDIA_bert_base_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_cased.by_andresestevez': 'bert_qa_andresestevez_bert_base_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_cased.by_batterydata': 'bert_qa_bert_base_cased_squad_v1',
                                        'en.answer_question.squad.bert.base_cased.by_ncduy': 'bert_qa_bert_base_cased_finetuned_squad_test',
                                        'en.answer_question.squad.bert.base_uncased': 'bert_qa_SreyanG_NVIDIA_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.1.1_block_sparse_0.32_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.32_v1',
                                        'en.answer_question.squad.bert.base_uncased.by_HomayounSadri': 'bert_qa_HomayounSadri_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_Intel': 'bert_qa_bert_base_uncased_squadv1.1_sparse_80_1x4_block_pruneofa',
                                        'en.answer_question.squad.bert.base_uncased.by_SreyanG-NVIDIA': 'bert_qa_SreyanG_NVIDIA_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_SupriyaArun': 'bert_qa_SupriyaArun_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_Tianle': 'bert_qa_Tianle_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_bdickson': 'bert_qa_bdickson_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_csarron': 'bert_qa_csarron_bert_base_uncased_squad_v1',
                                        'en.answer_question.squad.bert.base_uncased.by_jgammack': 'bert_qa_MTL_bert_base_uncased_ww_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_jimypbr': 'bert_qa_jimypbr_bert_base_uncased_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_kaporter': 'bert_qa_kaporter_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_lewtun': 'bert_qa_bert_base_uncased_finetuned_squad_v1',
                                        'en.answer_question.squad.bert.base_uncased.by_madlag': 'bert_qa_bert_base_uncased_squad_v1_sparse0.25',
                                        'en.answer_question.squad.bert.base_uncased.by_srmukundb': 'bert_qa_srmukundb_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_tli8hf': 'bert_qa_unqover_bert_base_uncased_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_victoraavila': 'bert_qa_victoraavila_bert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.base_uncased.by_vuiseng9': 'bert_qa_vuiseng9_bert_base_uncased_squad',
                                        'en.answer_question.squad.bert.base_uncased.x1.16_f88.1_d8_unstruct.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.16_f88.1_d8_unstruct_v1',
                                        'en.answer_question.squad.bert.base_uncased_1024d_seed_42': 'bert_qa_bert_base_uncased_few_shot_k_1024_finetuned_squad_seed_42',
                                        'en.answer_question.squad.bert.base_uncased_128d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_128_finetuned_squad_seed_0',
                                        'en.answer_question.squad.bert.base_uncased_1_block_sparse_0.13_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.84_f88.7_d36_hybrid_filled_v1',
                                        'en.answer_question.squad.bert.base_uncased_1_block_sparse_0.20_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.13_v1',
                                        'en.answer_question.squad.bert.base_uncased_256d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_256_finetuned_squad_seed_0',
                                        'en.answer_question.squad.bert.base_uncased_32d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_32_finetuned_squad_seed_0',
                                        'en.answer_question.squad.bert.base_uncased_512d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_512_finetuned_squad_seed_0',
                                        'en.answer_question.squad.bert.base_uncased_64d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_64_finetuned_squad_seed_0',
                                        'en.answer_question.squad.bert.base_uncased_l3.by_howey': 'bert_qa_bert_base_uncased_squad_L3',
                                        'en.answer_question.squad.bert.base_uncased_l6.by_howey': 'bert_qa_bert_base_uncased_squad_L6',
                                        'en.answer_question.squad.bert.base_uncased_seed_42': 'bert_qa_bert_base_uncased_few_shot_k_16_finetuned_squad_seed_42',
                                        'en.answer_question.squad.bert.base_uncased_v2': 'bert_qa_bert_base_uncased_squad1.1_pruned_x3.2_v2',
                                        'en.answer_question.squad.bert.base_uncased_v2.by_ericRosello': 'bert_qa_bert_base_uncased_finetuned_squad_frozen_v2',
                                        'en.answer_question.squad.bert.base_uncased_v2.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_pruned_x3.2_v2',
                                        'en.answer_question.squad.bert.base_uncased_x1.16_f88.1_d8_unstruct_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.20_v1',
                                        'en.answer_question.squad.bert.base_uncased_x1.84_f88.7_d36_hybrid_filled_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.96_f88.3_d27_hybrid_filled_opt_v1',
                                        'en.answer_question.squad.bert.base_uncased_x1.96_f88.3_d27_hybrid_filled_opt_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.01_f89.2_d30_hybrid_rewind_opt_v1',
                                        'en.answer_question.squad.bert.base_uncased_x2.01_f89.2_d30_hybrid_rewind_opt_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.32_f86.6_d15_hybrid_v1',
                                        'en.answer_question.squad.bert.base_uncased_x2.32_f86.6_d15_hybrid_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.44_f87.7_d26_hybrid_filled_v1',
                                        'en.answer_question.squad.bert.base_uncased_x2.44_f87.7_d26_hybrid_filled_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.07_v1',
                                        'en.answer_question.squad.bert.by_Alexander-Learn': 'bert_qa_Alexander_Learn_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_ArpanZS': 'bert_qa_debug_squad',
                                        'en.answer_question.squad.bert.by_DaisyMak': 'bert_qa_bert_finetuned_squad_accelerate_10epoch_transformerfrozen',
                                        'en.answer_question.squad.bert.by_Danastos': 'bert_qa_squad_bert_el_Danastos',
                                        'en.answer_question.squad.bert.by_FardinSaboori': 'bert_qa_FardinSaboori_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_Ghost1': 'bert_qa_bert_finetuned_squad1',
                                        'en.answer_question.squad.bert.by_Harsit': 'bert_qa_Harsit_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_KevinChoi': 'bert_qa_KevinChoi_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_Kutay': 'bert_qa_fine_tuned_squad_aip',
                                        'en.answer_question.squad.bert.by_Laikokwei': 'bert_qa_Laikokwei_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_Neulvo': 'bert_qa_Neulvo_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_andresestevez': 'bert_qa_andresestevez_bert_finetuned_squad_accelerate',
                                        'en.answer_question.squad.bert.by_ankitkupadhyay': 'bert_qa_ankitkupadhyay_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_datauma': 'bert_qa_datauma_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_hendrixcosta': 'bert_qa_bertimbau_squad1.1',
                                        'en.answer_question.squad.bert.by_huggingface-course': 'bert_qa_huggingface_course_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_jatinshah': 'bert_qa_jatinshah_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_maroo93': 'bert_qa_squad1.1',
                                        'en.answer_question.squad.bert.by_mrbalazs5': 'bert_qa_mrbalazs5_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_mrp': 'bert_qa_mrp_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_nickmuchi': 'bert_qa_nickmuchi_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_peterhsu': 'bert_qa_tf_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.by_ruselkomp': 'bert_qa_tests_finetuned_squad_test_bert',
                                        'en.answer_question.squad.bert.by_spacemanidol': 'bert_qa_neuralmagic_bert_squad_12layer_0sparse',
                                        'en.answer_question.squad.bert.by_stevemobs': 'bert_qa_bert_finetuned_squad_pytorch',
                                        'en.answer_question.squad.bert.by_vanichandna': 'bert_qa_muril_finetuned_squad',
                                        'en.answer_question.squad.bert.by_youngjae': 'bert_qa_youngjae_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.cased': 'bert_qa_bert_multi_cased_squad_sv_marbogusz',
                                        'en.answer_question.squad.bert.distilled_base_uncased': 'bert_qa_kamilali_distilbert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.distilled_base_uncased.by_huggingface': 'bert_qa_prunebert_base_uncased_6_finepruned_w_distil_squad',
                                        'en.answer_question.squad.bert.distilled_base_uncased.by_juliusco': 'bert_qa_juliusco_distilbert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.distilled_base_uncased.by_kamilali': 'bert_qa_kamilali_distilbert_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.large': 'bert_qa_sbert_large_nlu_ru_finetuned_squad',
                                        'en.answer_question.squad.bert.large.by_rsvp-ai': 'bert_qa_bertserini_bert_large_squad',
                                        'en.answer_question.squad.bert.large.by_ruselkomp': 'bert_qa_sbert_large_nlu_ru_finetuned_squad',
                                        'en.answer_question.squad.bert.large_cased': 'bert_qa_bert_large_cased_whole_word_masking_finetuned_squad',
                                        'en.answer_question.squad.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_Graphcore': 'bert_qa_Graphcore_bert_large_uncased_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_haddadalwi': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad_finetuned_islamic_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_howey': 'bert_qa_howey_bert_large_uncased_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_internetoftim': 'bert_qa_internetoftim_bert_large_uncased_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_ofirzaf': 'bert_qa_ofirzaf_bert_large_uncased_squad',
                                        'en.answer_question.squad.bert.large_uncased.by_uploaded by huggingface': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad',
                                        'en.answer_question.squad.bert.large_uncased_sparse_80_1x4_block_pruneofa.by_Intel': 'bert_qa_bert_large_uncased_squadv1.1_sparse_80_1x4_block_pruneofa',
                                        'en.answer_question.squad.bert.large_uncased_sparse_90_unstructured.by_Intel': 'bert_qa_bert_large_uncased_squadv1.1_sparse_90_unstructured',
                                        'en.answer_question.squad.bert.medium': 'bert_qa_bert_medium_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.medium.by_anas-awadalla': 'bert_qa_bert_medium_finetuned_squad',
                                        'en.answer_question.squad.bert.medium.by_mrm8488': 'bert_qa_bert_medium_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.medium_finetuned.by_anas-awadalla': 'bert_qa_bert_medium_pretrained_finetuned_squad',
                                        'en.answer_question.squad.bert.mini_lm_base_uncased': 'bert_qa_MiniLM_L12_H384_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.ms_tuned.base.by_zhufy': 'bert_qa_squad_ms_bert_base',
                                        'en.answer_question.squad.bert.multilingual_base_cased': 'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.multilingual_base_cased.by_Paul-Vinh': 'bert_qa_Paul_Vinh_bert_base_multilingual_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.multilingual_base_cased.by_salti': 'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad',
                                        'en.answer_question.squad.bert.multilingual_base_cased.by_vanichandna': 'bert_qa_bert_base_multilingual_cased_finetuned_squadv1',
                                        'en.answer_question.squad.bert.multilingual_base_uncased': 'bert_qa_bert_base_multilingual_uncased_finetuned_squad',
                                        'en.answer_question.squad.bert.sl256.by_vuiseng9': 'bert_qa_bert_l_squadv1.1_sl256',
                                        'en.answer_question.squad.bert.sl384.by_vuiseng9': 'bert_qa_bert_l_squadv1.1_sl384',
                                        'en.answer_question.squad.bert.small': 'bert_qa_bert_small_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.small.by_anas-awadalla': 'bert_qa_bert_small_finetuned_squad',
                                        'en.answer_question.squad.bert.small.by_mrm8488': 'bert_qa_bert_small_wrslb_finetuned_squadv1',
                                        'en.answer_question.squad.bert.small_finetuned.by_anas-awadalla': 'bert_qa_bert_small_pretrained_finetuned_squad',
                                        'en.answer_question.squad.bert.tiny': 'bert_qa_bert_tiny_finetuned_squad',
                                        'en.answer_question.squad.bert.v1.1.by_maroo93': 'bert_qa_squad1.1_1',
                                        'en.answer_question.squad.bert.v1.by_vanichandna': 'bert_qa_muril_finetuned_squadv1',
                                        'en.answer_question.squad.bert.v2.by_peterhsu': 'bert_qa_peterhsu_bert_finetuned_squad',
                                        'en.answer_question.squad.bert.v2.by_ruselkomp': 'bert_qa_tests_finetuned_squad_test_bert_2',
                                        'en.answer_question.squad.biobert.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_biobert',
                                        'en.answer_question.squad.biobert.base_cased.by_dmis-lab': 'bert_qa_biobert_base_cased_v1.1_squad',
                                        'en.answer_question.squad.biobert.base_cased.by_juliusco': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_biobert',
                                        'en.answer_question.squad.bioformer.cased': 'bert_qa_bioformer_cased_v1.0_squad1',
                                        'en.answer_question.squad.covid_bert': 'bert_qa_covidbert_squad',
                                        'en.answer_question.squad.covid_biobert.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covbiobert',
                                        'en.answer_question.squad.covid_roberta.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covdrobert',
                                        'en.answer_question.squad.distil_bert': 'distilbert_qa_checkpoint_500_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base': 'distilbert_qa_base_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_cased': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_test',
                                        'en.answer_question.squad.distil_bert.base_cased.by_ncduy': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_test',
                                        'en.answer_question.squad.distil_bert.base_cased.by_uploaded by huggingface': 'distilbert_qa_base_cased_distilled_squad',
                                        'en.answer_question.squad.distil_bert.base_small_cased': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_small',
                                        'en.answer_question.squad.distil_bert.base_tiny_cased': 'distilbert_qa_tiny_base_cased_distilled_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased': 'distilbert_qa_MYX4567_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_21iridescent': 'distilbert_qa_21iridescent_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Adrian': 'distilbert_qa_Adrian_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Ayoola': 'distilbert_qa_Ayoola_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_FOFer': 'distilbert_qa_FOFer_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Firat': 'distilbert_qa_Firat_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Gayathri': 'distilbert_qa_Gayathri_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Hoang': 'distilbert_qa_Hoang_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_HomayounSadri': 'distilbert_qa_HomayounSadri_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_MYX4567': 'distilbert_qa_MYX4567_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Nadhiya': 'distilbert_qa_Nadhiya_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_ParulChaudhari': 'distilbert_qa_ParulChaudhari_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Plimpton': 'distilbert_qa_Plimpton_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Raphaelg9': 'distilbert_qa_Raphaelg9_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Rocketknight1': 'distilbert_qa_Rocketknight1_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_SEISHIN': 'distilbert_qa_SEISHIN_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Shashidhar': 'distilbert_qa_Shashidhar_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Sourabh714': 'distilbert_qa_Sourabh714_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_SupriyaArun': 'distilbert_qa_SupriyaArun_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Thitaree': 'distilbert_qa_Thitaree_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Tianle': 'distilbert_qa_Tianle_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_V3RX2000': 'distilbert_qa_V3RX2000_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_Wiam': 'distilbert_qa_Wiam_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_aaraki': 'distilbert_qa_aaraki_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_abhinavkulkarni': 'distilbert_qa_abhinavkulkarni_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_akr': 'distilbert_qa_akr_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_andi611': 'distilbert_qa_andi611_base_uncased_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_anurag0077': 'distilbert_qa_base_uncased_finetuned_squad3',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_arvalinno': 'distilbert_qa_arvalinno_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_avioo1': 'distilbert_qa_avioo1_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_bdickson': 'distilbert_qa_bdickson_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_caiosantillo': 'distilbert_qa_caiosantillo_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_deepakvk': 'distilbert_qa_base_uncased_distilled_squad_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_emre': 'distilbert_qa_emre_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_en': 'distilbert_qa_en_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_fadhilarkan': 'distilbert_qa_fadhilarkan_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_gokulkarthik': 'distilbert_qa_gokulkarthik_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_graviraja': 'distilbert_qa_graviraja_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_guhuawuli': 'distilbert_qa_guhuawuli_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_hark99': 'distilbert_qa_hark99_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_hcy11': 'distilbert_qa_hcy11_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_hiiii23': 'distilbert_qa_hiiii23_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_holtin': 'distilbert_qa_base_uncased_holtin_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_huggingfaceepita': 'distilbert_qa_huggingfaceepita_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_huxxx657': 'distilbert_qa_huxxx657_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_jgammack': 'distilbert_qa_jgammack_base_uncased_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_jhoonk': 'distilbert_qa_jhoonk_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_jsunster': 'distilbert_qa_jsunster_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_kaggleodin': 'distilbert_qa_kaggleodin_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_lewtun': 'distilbert_qa_base_uncased_finetuned_squad_v1',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_machine2049': 'distilbert_qa_base_uncased_finetuned_squad_',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_manudotc': 'distilbert_qa_transformers_base_uncased_finetuneQA_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_sunitha': 'distilbert_qa_base_uncased_3feb_2022_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_tli8hf': 'distilbert_qa_unqover_base_uncased_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_tucan9389': 'distilbert_qa_tucan9389_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_uploaded by huggingface': 'distilbert_qa_base_uncased_distilled_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_usami': 'distilbert_qa_usami_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_vitusya': 'distilbert_qa_vitusya_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_vkmr': 'distilbert_qa_vkmr_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased.by_vkrishnamoorthy': 'distilbert_qa_vkrishnamoorthy_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased_colab.by_Adrian': 'distilbert_qa_base_uncased_finetuned_squad_colab',
                                        'en.answer_question.squad.distil_bert.base_uncased_full.by_holtin': 'distilbert_qa_base_uncased_holtin_finetuned_full_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased_mtl.by_jgammack': 'distilbert_qa_MTL_base_uncased_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased_sae.by_jgammack': 'distilbert_qa_SAE_base_uncased_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased_v2': 'distilbert_qa_base_uncased_finetuned_indosquad_v2',
                                        'en.answer_question.squad.distil_bert.base_uncased_v2.by_arvalinno': 'distilbert_qa_base_uncased_finetuned_indosquad_v2',
                                        'en.answer_question.squad.distil_bert.base_uncased_v2.by_ericRosello': 'distilbert_qa_base_uncased_finetuned_squad_frozen_v2',
                                        'en.answer_question.squad.distil_bert.base_uncased_v2.by_holtin': 'distilbert_qa_holtin_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.base_uncased_v2.by_huxxx657': 'distilbert_qa_base_uncased_finetuned_jumbling_squad_15',
                                        'en.answer_question.squad.distil_bert.base_uncased_v3.by_anurag0077': 'distilbert_qa_anurag0077_base_uncased_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.by_AyushPJ': 'distilbert_qa_test_squad_trained_finetuned_squad',
                                        'en.answer_question.squad.distil_bert.by_ZYW': 'distilbert_qa_test_squad_trained',
                                        'en.answer_question.squad.distil_bert.by_abhilash1910': 'distilbert_qa_squadv1',
                                        'en.answer_question.squad.distil_bert.by_rowan1224': 'distilbert_qa_squad_slp',
                                        'en.answer_question.squad.distil_bert.by_sunitha': 'distilbert_qa_AQG_CV_Squad',
                                        'en.answer_question.squad.distil_bert.by_tabo': 'distilbert_qa_checkpoint_500_finetuned_squad',
                                        'en.answer_question.squad.electra': 'electra_qa_squad_slp',
                                        'en.answer_question.squad.electra.base': 'electra_qa_base_discriminator_finetuned_squad',
                                        'en.answer_question.squad.electra.base.by_Palak': 'electra_qa_google_base_discriminator_squad',
                                        'en.answer_question.squad.electra.base.by_mrm8488': 'electra_qa_base_finetuned_squadv1',
                                        'en.answer_question.squad.electra.base.by_usami': 'electra_qa_base_discriminator_finetuned_squad',
                                        'en.answer_question.squad.electra.base.by_valhalla': 'electra_qa_base_discriminator_finetuned_squadv1',
                                        'en.answer_question.squad.electra.large': 'electra_qa_large_squad',
                                        'en.answer_question.squad.electra.large.by_howey': 'electra_qa_large_squad',
                                        'en.answer_question.squad.electra.large.by_mrm8488': 'electra_qa_large_finetuned_squadv1',
                                        'en.answer_question.squad.electra.small': 'electra_qa_small_finetuned_squadv1',
                                        'en.answer_question.squad.electra.small.by_Palak': 'electra_qa_google_small_discriminator_squad',
                                        'en.answer_question.squad.electra.small.by_bdickson': 'electra_qa_small_discriminator_finetuned_squad_1',
                                        'en.answer_question.squad.electra.small.by_hankzhong': 'electra_qa_hankzhong_small_discriminator_finetuned_squad',
                                        'en.answer_question.squad.electra.small.by_mrm8488': 'electra_qa_small_finetuned_squadv1',
                                        'en.answer_question.squad.electra.small_v2.by_bdickson': 'electra_qa_small_discriminator_finetuned_squad_2',
                                        'en.answer_question.squad.ixam_bert.by_MarcBrun': 'bert_qa_ixambert_finetuned_squad',
                                        'en.answer_question.squad.ixam_bert.eu_en_tunedby_MarcBrun': 'bert_qa_ixambert_finetuned_squad_eu_en_MarcBrun',
                                        'en.answer_question.squad.ixam_bert.eu_tuned.by_MarcBrun': 'bert_qa_ixambert_finetuned_squad_eu_MarcBrun',
                                        'en.answer_question.squad.link_bert.large': 'bert_qa_linkbert_large_finetuned_squad',
                                        'en.answer_question.squad.multi_lingual_bert.by_ZYW': 'bert_qa_squad_mbert_model',
                                        'en.answer_question.squad.multi_lingual_bert.en_de_es.by_ZYW': 'bert_qa_squad_mbert_en_de_es_model',
                                        'en.answer_question.squad.multi_lingual_bert.en_de_es_vi_zh.by_ZYW': 'bert_qa_squad_mbert_en_de_es_vi_zh_model',
                                        'en.answer_question.squad.multi_lingual_bert.v2.by_ZYW': 'bert_qa_squad_mbert_model_2',
                                        'en.answer_question.squad.roberta': 'roberta_qa_roberta_l_squadv1.1',
                                        'en.answer_question.squad.roberta.base': 'roberta_qa_roberta_base_1B_1_finetuned_squadv1',
                                        'en.answer_question.squad.roberta.base.by_Firat': 'roberta_qa_Firat_roberta_base_finetuned_squad',
                                        'en.answer_question.squad.roberta.base.by_ahmedattia143': 'roberta_qa_roberta_squadv1_base',
                                        'en.answer_question.squad.roberta.base.by_csarron': 'roberta_qa_roberta_base_squad_v1',
                                        'en.answer_question.squad.roberta.base.by_huxxx657': 'roberta_qa_huxxx657_roberta_base_finetuned_squad',
                                        'en.answer_question.squad.roberta.base.by_jgammack': 'roberta_qa_roberta_base_squad',
                                        'en.answer_question.squad.roberta.base.by_mrm8488': 'roberta_qa_roberta_base_1B_1_finetuned_squadv1',
                                        'en.answer_question.squad.roberta.base.by_rahulchakwate': 'roberta_qa_rahulchakwate_roberta_base_finetuned_squad',
                                        'en.answer_question.squad.roberta.base.by_tli8hf': 'roberta_qa_unqover_roberta_base_squad',
                                        'en.answer_question.squad.roberta.base_1024d_seed_0': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_1024d_seed_10': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_1024d_seed_2': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_1024d_seed_4': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_1024d_seed_42': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_42',
                                        'en.answer_question.squad.roberta.base_1024d_seed_6': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_1024d_seed_8': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_128d_seed_0': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_128d_seed_10': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_128d_seed_2': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_128d_seed_4': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_128d_seed_42': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_42',
                                        'en.answer_question.squad.roberta.base_128d_seed_6': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_128d_seed_8': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_256d_seed_0': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_256d_seed_10': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_256d_seed_2': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_256d_seed_4': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_256d_seed_6': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_256d_seed_8': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_32d_seed_0': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_32d_seed_10': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_32d_seed_2': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_32d_seed_4': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_32d_seed_6': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_32d_seed_8': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_512d_seed_0': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_512d_seed_10': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_512d_seed_2': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_512d_seed_4': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_512d_seed_6': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_512d_seed_8': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_64d_seed_0': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_64d_seed_10': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_64d_seed_2': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_64d_seed_4': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_64d_seed_6': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_64d_seed_8': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_deletion_10.by_huxxx657': 'roberta_qa_roberta_base_finetuned_deletion_squad_10',
                                        'en.answer_question.squad.roberta.base_deletion_15.by_huxxx657': 'roberta_qa_roberta_base_finetuned_deletion_squad_15',
                                        'en.answer_question.squad.roberta.base_sae.by_jgammack': 'roberta_qa_SAE_roberta_base_squad',
                                        'en.answer_question.squad.roberta.base_scrambled_10.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_10',
                                        'en.answer_question.squad.roberta.base_scrambled_10_new.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_10_new',
                                        'en.answer_question.squad.roberta.base_scrambled_15.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_15',
                                        'en.answer_question.squad.roberta.base_scrambled_15_v2.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_15_new',
                                        'en.answer_question.squad.roberta.base_scrambled_5.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_5',
                                        'en.answer_question.squad.roberta.base_scrambled_sq.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_5_new',
                                        'en.answer_question.squad.roberta.base_seed_0': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_0',
                                        'en.answer_question.squad.roberta.base_seed_10': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_10',
                                        'en.answer_question.squad.roberta.base_seed_2': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_2',
                                        'en.answer_question.squad.roberta.base_seed_4': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_4',
                                        'en.answer_question.squad.roberta.base_seed_42': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_42',
                                        'en.answer_question.squad.roberta.base_seed_6': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_6',
                                        'en.answer_question.squad.roberta.base_seed_8': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_8',
                                        'en.answer_question.squad.roberta.base_v1.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_1',
                                        'en.answer_question.squad.roberta.base_v2.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_2',
                                        'en.answer_question.squad.roberta.base_v3.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_3',
                                        'en.answer_question.squad.roberta.by_cgou': 'roberta_qa_fin_RoBERTa_v1_finetuned_squad',
                                        'en.answer_question.squad.roberta.by_sunitha': 'roberta_qa_Roberta_Custom_Squad_DS',
                                        'en.answer_question.squad.roberta.by_vuiseng9': 'roberta_qa_roberta_l_squadv1.1',
                                        'en.answer_question.squad.roberta.distilled': 'roberta_qa_distilroberta_finetuned_squadv1',
                                        'en.answer_question.squad.roberta.distilled_base': 'roberta_qa_distilroberta_base_squad',
                                        'en.answer_question.squad.roberta.large': 'roberta_qa_roberta_large_squad_v1',
                                        'en.answer_question.squad.roberta.large.by_csarron': 'roberta_qa_roberta_large_squad_v1',
                                        'en.answer_question.squad.roberta.large.by_rahulchakwate': 'roberta_qa_roberta_large_finetuned_squad',
                                        'en.answer_question.squad.scibert': 'bert_qa_scibert_nli_squad',
                                        'en.answer_question.squad.scibert.by_amoux': 'bert_qa_scibert_nli_squad',
                                        'en.answer_question.squad.scibert.by_ixa-ehu': 'bert_qa_SciBERT_SQuAD_QuAC',
                                        'en.answer_question.squad.scibert.uncased': 'bert_qa_scibert_scivocab_uncased_squad',
                                        'en.answer_question.squad.span_bert': 'bert_qa_spanbert_finetuned_squadv1',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_0',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_2',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_4',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_42': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_42',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_6',
                                        'en.answer_question.squad.span_bert.base_cased_1024d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_8',
                                        'en.answer_question.squad.span_bert.base_cased_128d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_128d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_4',
                                        'en.answer_question.squad.span_bert.base_cased_128d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_6',
                                        'en.answer_question.squad.span_bert.base_cased_128d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_8',
                                        'en.answer_question.squad.span_bert.base_cased_256d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_32d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_0',
                                        'en.answer_question.squad.span_bert.base_cased_32d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_32d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_2',
                                        'en.answer_question.squad.span_bert.base_cased_32d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_6',
                                        'en.answer_question.squad.span_bert.base_cased_512d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_0',
                                        'en.answer_question.squad.span_bert.base_cased_512d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_512d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_6',
                                        'en.answer_question.squad.span_bert.base_cased_512d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_8',
                                        'en.answer_question.squad.span_bert.base_cased_64d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_0',
                                        'en.answer_question.squad.span_bert.base_cased_64d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_10',
                                        'en.answer_question.squad.span_bert.base_cased_64d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_2',
                                        'en.answer_question.squad.span_bert.base_cased_64d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_4',
                                        'en.answer_question.squad.span_bert.base_cased_64d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_6',
                                        'en.answer_question.squad.span_bert.base_cased_seed_42': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_42',
                                        'en.answer_question.squad.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_squad_v1.1',
                                        'en.answer_question.squad.xlm_roberta.by_jakobwes': 'xlm_roberta_qa_xlm_roberta_squad_v1.1',
                                        'en.answer_question.squad.xlm_roberta.by_meghana': 'xlm_roberta_qa_hitalmqa_finetuned_squad',
                                        'en.answer_question.squad_battery.bert.base_uncased': 'bert_qa_batterydata_bert_base_uncased_squad_v1',
                                        'en.answer_question.squad_battery.bert.cased.by_batterydata': 'bert_qa_batterybert_cased_squad_v1',
                                        'en.answer_question.squad_battery.bert.cased_only_bert.by_batterydata': 'bert_qa_batteryonlybert_cased_squad_v1',
                                        'en.answer_question.squad_battery.bert.uncased.by_batterydata': 'bert_qa_batterybert_uncased_squad_v1',
                                        'en.answer_question.squad_battery.bert.uncased_only_bert.by_batterydata': 'bert_qa_batteryonlybert_uncased_squad_v1',
                                        'en.answer_question.squad_battery.scibert.cased': 'bert_qa_batteryscibert_cased_squad_v1',
                                        'en.answer_question.squad_battery.scibert.uncased': 'bert_qa_batteryscibert_uncased_squad_v1',
                                        'en.answer_question.squad_ben_tel.bert.by_krinal214': 'bert_qa_bert_all_squad_ben_tel_context',
                                        'en.answer_question.squad_covid.bert': 'bert_qa_covid_squad',
                                        'en.answer_question.squad_pubmed.biobert': 'bert_qa_biobert_v1.1_pubmed_finetuned_squad',
                                        'en.answer_question.squad_translated.bert.by_krinal214': 'bert_qa_bert_all_squad_all_translated',
                                        'en.answer_question.squad_translated.bert.que.by_krinal214': 'bert_qa_bert_all_squad_que_translated',
                                        'en.answer_question.squadv2.albert.base_v2': 'albert_qa_vumichien_base_v2_squad2',
                                        'en.answer_question.squadv2.albert.base_v2.by_elgeish': 'albert_qa_cs224n_squad2.0_base_v2',
                                        'en.answer_question.squadv2.albert.base_v2.by_vumichien': 'albert_qa_vumichien_base_v2_squad2',
                                        'en.answer_question.squadv2.albert.large_v2': 'albert_qa_cs224n_squad2.0_large_v2',
                                        'en.answer_question.squadv2.albert.xl_v2': 'albert_qa_xlarge_v2_squad_v2',
                                        'en.answer_question.squadv2.albert.xxl': 'albert_qa_xxlarge_v1_finetuned_squad2',
                                        'en.answer_question.squadv2.albert.xxl.by_elgeish': 'albert_qa_cs224n_squad2.0_xxlarge_v1',
                                        'en.answer_question.squadv2.albert.xxl.by_replydotai': 'albert_qa_xxlarge_v1_finetuned_squad2',
                                        'en.answer_question.squadv2.albert.xxl.by_sultan': 'albert_qa_BioM_xxlarge_SQuAD2',
                                        'en.answer_question.squadv2.albert.xxl_512d': 'albert_qa_xxlargev1_squad2_512',
                                        'en.answer_question.squadv2.albert.xxl_v2': 'albert_qa_xxlarge_v2_squad2',
                                        'en.answer_question.squadv2.bert': 'bert_qa_squad2.0',
                                        'en.answer_question.squadv2.bert.base': 'bert_qa_bert_base_finetuned_squad2',
                                        'en.answer_question.squadv2.bert.base_cased': 'bert_qa_tf_bert_base_cased_squad2',
                                        'en.answer_question.squadv2.bert.base_cased.by_deepset': 'bert_base_cased_qa_squad2',
                                        'en.answer_question.squadv2.bert.base_cased.by_vumichien': 'bert_qa_tf_bert_base_cased_squad2',
                                        'en.answer_question.squadv2.bert.base_cased.by_ydshieh': 'bert_qa_ydshieh_bert_base_cased_squad2',
                                        'en.answer_question.squadv2.bert.base_uncased': 'bert_qa_deepset_bert_base_uncased_squad2',
                                        'en.answer_question.squadv2.bert.base_uncased.by_Vasanth': 'bert_qa_bert_base_uncased_qa_squad2',
                                        'en.answer_question.squadv2.bert.base_uncased.by_deepset': 'bert_qa_deepset_bert_base_uncased_squad2',
                                        'en.answer_question.squadv2.bert.base_uncased.by_twmkn9': 'bert_qa_twmkn9_bert_base_uncased_squad2',
                                        'en.answer_question.squadv2.bert.base_uncased_v2': 'bert_qa_bert_base_uncased_finetuned_squad_v2',
                                        'en.answer_question.squadv2.bert.base_v2.by_mrm8488': 'bert_qa_bert_mini_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.base_v2_5.by_mrm8488': 'bert_qa_bert_mini_5_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.by_augustoortiz': 'bert_qa_bert_finetuned_squad2',
                                        'en.answer_question.squadv2.bert.by_maroo93': 'bert_qa_squad2.0',
                                        'en.answer_question.squadv2.bert.by_pinecone': 'bert_qa_bert_reader_squad2',
                                        'en.answer_question.squadv2.bert.distilled': 'bert_qa_xdistil_l12_h384_squad2',
                                        'en.answer_question.squadv2.bert.distilled_medium': 'bert_qa_bert_medium_squad2_distilled',
                                        'en.answer_question.squadv2.bert.large': 'bert_qa_muril_large_squad2',
                                        'en.answer_question.squadv2.bert.large.by_Sindhu': 'bert_qa_muril_large_squad2',
                                        'en.answer_question.squadv2.bert.large.by_phiyodr': 'bert_qa_bert_large_finetuned_squad2',
                                        'en.answer_question.squadv2.bert.large_tiny_768d.by_MichelBartels': 'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned',
                                        'en.answer_question.squadv2.bert.large_tiny_768d_v2.by_MichelBartels': 'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned_step1',
                                        'en.answer_question.squadv2.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
                                        'en.answer_question.squadv2.bert.large_uncased.by_Salesforce': 'bert_qa_qaconv_bert_large_uncased_whole_word_masking_squad2',
                                        'en.answer_question.squadv2.bert.large_uncased.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
                                        'en.answer_question.squadv2.bert.large_uncased.by_deepset': 'bert_qa_bert_large_uncased_whole_word_masking_squad2',
                                        'en.answer_question.squadv2.bert.large_uncased_v2.by_madlag': 'bert_qa_bert_large_uncased_squadv2',
                                        'en.answer_question.squadv2.bert.large_uncased_v2_x2.15_f83.2_d25_hybrid.by_madlag': 'bert_qa_bert_large_uncased_wwm_squadv2_x2.15_f83.2_d25_hybrid_v1',
                                        'en.answer_question.squadv2.bert.large_uncased_v2_x2.63_f82.6_d16_hybrid.by_madlag': 'bert_qa_bert_large_uncased_wwm_squadv2_x2.63_f82.6_d16_hybrid_v1',
                                        'en.answer_question.squadv2.bert.large_uncased_whole_word_masking_v2.by_madlag': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.medium_v2': 'bert_qa_bert_medium_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.mini_lm_base_uncased': 'bert_qa_minilm_uncased_squad2',
                                        'en.answer_question.squadv2.bert.small.by_mrm8488': 'bert_qa_bert_small_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.small_v2.by_mrm8488': 'bert_qa_bert_small_2_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.tiny_.by_mrm8488': 'bert_qa_bert_tiny_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.tiny_768d': 'bert_qa_tinybert_6l_768d_squad2',
                                        'en.answer_question.squadv2.bert.tiny_v2.by_mrm8488': 'bert_qa_bert_tiny_2_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.tiny_v3.by_mrm8488': 'bert_qa_bert_tiny_3_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.tiny_v4.by_mrm8488': 'bert_qa_bert_tiny_4_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.tiny_v5.by_mrm8488': 'bert_qa_bert_tiny_5_finetuned_squadv2',
                                        'en.answer_question.squadv2.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_squad2',
                                        'en.answer_question.squadv2.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_squad2',
                                        'en.answer_question.squadv2.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_squad2',
                                        'en.answer_question.squadv2.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_squad2',
                                        'en.answer_question.squadv2.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_squad2',
                                        'en.answer_question.squadv2.bert.uncased_6l_128d_a2a_128d': 'bert_qa_bert_uncased_L_6_H_128_A_2_squad2',
                                        'en.answer_question.squadv2.biobert.cased': 'bert_qa_biobert_squad2_cased',
                                        'en.answer_question.squadv2.biobert.cased.by_clagator': 'bert_qa_biobert_squad2_cased',
                                        'en.answer_question.squadv2.biobert.cased.by_ptnv-s': 'bert_qa_biobert_squad2_cased_finetuned_squad',
                                        'en.answer_question.squadv2.deberta': 'deberta_v3_xsmall_qa_squad2',
                                        'en.answer_question.squadv2.distil_bert.base': 'distilbert_qa_base_squad2_custom_dataset',
                                        'en.answer_question.squadv2.distil_bert.base_cased': 'distilbert_base_cased_qa_squad2',
                                        'en.answer_question.squadv2.distil_bert.base_uncased': 'distilbert_qa_mvonwyl_base_uncased_finetuned_squad2',
                                        'en.answer_question.squadv2.distil_bert.base_uncased.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
                                        'en.answer_question.squadv2.distil_bert.base_uncased.by_anurag0077': 'distilbert_qa_anurag0077_base_uncased_finetuned_squad2',
                                        'en.answer_question.squadv2.distil_bert.base_uncased.by_mvonwyl': 'distilbert_qa_mvonwyl_base_uncased_finetuned_squad2',
                                        'en.answer_question.squadv2.distil_bert.base_uncased.by_tabo': 'distilbert_qa_tabo_base_uncased_finetuned_squad2',
                                        'en.answer_question.squadv2.distil_bert.base_uncased.by_twmkn9': 'distilbert_qa_base_uncased_squad2',
                                        'en.answer_question.squadv2.distil_bert.by_threem': 'distilbert_qa_mysquadv2_finetuned_squad',
                                        'en.answer_question.squadv2.distil_bert.v2.by_threem': 'distilbert_qa_mysquadv2_8Jan22_finetuned_squad',
                                        'en.answer_question.squadv2.electra.base': 'electra_qa_base_best_squad2',
                                        'en.answer_question.squadv2.electra.base.by_PremalMatalia': 'electra_qa_base_best_squad2',
                                        'en.answer_question.squadv2.electra.base.by_navteca': 'electra_qa_base_squad2',
                                        'en.answer_question.squadv2.electra.base.by_sultan': 'electra_qa_BioM_Base_SQuAD2',
                                        'en.answer_question.squadv2.electra.base_v2': 'electra_qa_base_finetuned_squadv2',
                                        'en.answer_question.squadv2.electra.large': 'electra_qa_BioM_Large_SQuAD2',
                                        'en.answer_question.squadv2.electra.large.by_sultan': 'electra_qa_BioM_Large_SQuAD2',
                                        'en.answer_question.squadv2.electra.large.by_superspray': 'electra_qa_large_discriminator_squad2_custom_dataset',
                                        'en.answer_question.squadv2.electra.large_512d': 'electra_qa_large_discriminator_squad2_512',
                                        'en.answer_question.squadv2.electra.small_v2': 'electra_qa_small_finetuned_squadv2',
                                        'en.answer_question.squadv2.longformer.base': 'longformer_base_base_qa_squad2',
                                        'en.answer_question.squadv2.longformer.base_v2': 'longformer_qa_base_4096_finetuned_squadv2',
                                        'en.answer_question.squadv2.roberta.base': 'roberta_qa_navteca_roberta_base_squad2',
                                        'en.answer_question.squadv2.roberta.base.by_21iridescent': 'roberta_qa_RoBERTa_base_finetuned_squad2_lwt',
                                        'en.answer_question.squadv2.roberta.base.by_AnonymousSub': 'roberta_qa_roberta_base_squad2.0',
                                        'en.answer_question.squadv2.roberta.base.by_PremalMatalia': 'roberta_qa_roberta_base_best_squad2',
                                        'en.answer_question.squadv2.roberta.base.by_Shappey': 'roberta_qa_roberta_base_QnA_squad2_trained',
                                        'en.answer_question.squadv2.roberta.base.by_Teepika': 'roberta_qa_roberta_base_squad2_finetuned_selqa',
                                        'en.answer_question.squadv2.roberta.base.by_avioo1': 'roberta_qa_avioo1_roberta_base_squad2_finetuned_squad',
                                        'en.answer_question.squadv2.roberta.base.by_deepakvk': 'roberta_qa_deepakvk_roberta_base_squad2_finetuned_squad',
                                        'en.answer_question.squadv2.roberta.base.by_deepset': 'roberta_base_qa_squad2',
                                        'en.answer_question.squadv2.roberta.base.by_mvonwyl': 'roberta_qa_roberta_base_finetuned_squad2',
                                        'en.answer_question.squadv2.roberta.base.by_navteca': 'roberta_qa_navteca_roberta_base_squad2',
                                        'en.answer_question.squadv2.roberta.base.by_nlpconnect': 'roberta_qa_roberta_base_squad2_nq',
                                        'en.answer_question.squadv2.roberta.base.by_prk': 'roberta_qa_prk_roberta_base_squad2_finetuned_squad',
                                        'en.answer_question.squadv2.roberta.base.by_shahrukhx01': 'roberta_qa_roberta_base_squad2_boolq_baseline',
                                        'en.answer_question.squadv2.roberta.base.by_sumba': 'roberta_qa_sumba_roberta_base_squad2_finetuned_squad',
                                        'en.answer_question.squadv2.roberta.base.by_ydshieh': 'roberta_qa_ydshieh_roberta_base_squad2',
                                        'en.answer_question.squadv2.roberta.base_rule_based_hier_quadruplet_0.1_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_quadruplet_0.1_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_hier_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_quadruplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_hier_triplet_0.1_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_triplet_0.1_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_hier_triplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_triplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_only_classfn_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_only_classfn_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_only_classfn_twostage_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_only_classfn_twostage_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_bert_quadruplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_twostage_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostage_quadruplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_twostagequadruplet_hier_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagequadruplet_hier_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_twostagetriplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagetriplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_rule_based_twostagetriplet_hier_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagetriplet_hier_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_ruletriplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_bert_triplet_epochs_1_shard_1_squad2.0',
                                        'en.answer_question.squadv2.roberta.base_v2': 'roberta_qa_roberta_base_1B_1_finetuned_squadv2',
                                        'en.answer_question.squadv2.roberta.base_v2.by_AyushPJ': 'roberta_qa_ai_club_inductions_21_nlp_roBERTa_base_squad_v2',
                                        'en.answer_question.squadv2.roberta.base_v2.by_mrm8488': 'roberta_qa_roberta_base_1B_1_finetuned_squadv2',
                                        'en.answer_question.squadv2.roberta.cline.by_AnonymousSub': 'roberta_qa_cline_squad2.0',
                                        'en.answer_question.squadv2.roberta.declutr.by_AnonymousSub': 'roberta_qa_declutr_model_squad2.0',
                                        'en.answer_question.squadv2.roberta.distilled_base': 'roberta_qa_distilroberta_base_finetuned_squad2_lwt',
                                        'en.answer_question.squadv2.roberta.distilled_base.by_21iridescent': 'roberta_qa_distilroberta_base_finetuned_squad2_lwt',
                                        'en.answer_question.squadv2.roberta.distilled_base.by_deepset': 'roberta_qa_roberta_base_squad2_distilled',
                                        'en.answer_question.squadv2.roberta.distilled_base.by_twmkn9': 'roberta_qa_distilroberta_base_squad2',
                                        'en.answer_question.squadv2.roberta.distilled_base_128d_32d_v2': 'roberta_qa_distilrobert_base_squadv2_328seq_128stride_test',
                                        'en.answer_question.squadv2.roberta.distilled_base_v2': 'roberta_qa_distilroberta_base_squad_v2',
                                        'en.answer_question.squadv2.roberta.emanuals.by_AnonymousSub': 'roberta_qa_EManuals_RoBERTa_squad2.0',
                                        'en.answer_question.squadv2.roberta.large': 'roberta_qa_roberta_large_squad2',
                                        'en.answer_question.squadv2.roberta.large.by_Salesforce': 'roberta_qa_qaconv_roberta_large_squad2',
                                        'en.answer_question.squadv2.roberta.large.by_deepset': 'roberta_qa_roberta_large_squad2_hp',
                                        'en.answer_question.squadv2.roberta.large.by_navteca': 'roberta_qa_roberta_large_squad2',
                                        'en.answer_question.squadv2.roberta.large.by_phiyodr': 'roberta_qa_roberta_large_finetuned_squad2',
                                        'en.answer_question.squadv2.roberta.tiny.by_deepset': 'roberta_qa_tinyroberta_squad2',
                                        'en.answer_question.squadv2.roberta.tiny.v2.by_deepset': 'roberta_qa_tinyroberta_squad2_step1',
                                        'en.answer_question.squadv2.scibert.uncased_v2': 'bert_qa_scibert_scivocab_uncased_squad_v2',
                                        'en.answer_question.squadv2.span_bert.v2': 'bert_qa_spanbert_finetuned_squadv2',
                                        'en.answer_question.squadv2.xlm_roberta.base': 'xlm_roberta_base_qa_squad2',
                                        'en.answer_question.squadv2.xlm_roberta.base.by_deepset': 'xlm_roberta_base_qa_squad2',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465514.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465514',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465515.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465515',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465516.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465516',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465517.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465517',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465518.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465518',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465519.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465519',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465520.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465520',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465521.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465521',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465522.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465522',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465523.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465523',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465524.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465524',
                                        'en.answer_question.squadv2.xlm_roberta.base_24465525.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465525',
                                        'en.answer_question.squadv2.xlm_roberta.base_v2': 'xlm_roberta_qa_squadv2_xlm_roberta_base',
                                        'en.answer_question.squadv2.xlm_roberta.distilled_base': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled',
                                        'en.answer_question.squadv2.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_squad2',
                                        'en.answer_question.squadv2_bioasq8b.electra.base': 'electra_qa_BioM_Base_SQuAD2_BioASQ8B',
                                        'en.answer_question.squadv2_bioasq8b.electra.large': 'electra_qa_BioM_Large_SQuAD2_BioASQ8B',
                                        'en.answer_question.squadv2_chaii.xlm_roberta.distilled_base': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii',
                                        'en.answer_question.squadv2_chaii.xlm_roberta.distilled_base_small': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii_small',
                                        'en.answer_question.squadv2_chemical.bert.uncased': 'bert_qa_chemical_bert_uncased_squad2',
                                        'en.answer_question.squadv2_conll.bert.large_uncased.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_conll2003_with_neg_with_repeat',
                                        'en.answer_question.squadv2_conll.bert.large_uncased_pistherea.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pistherea_conll2003_with_neg_with_repeat',
                                        'en.answer_question.squadv2_conll.bert.large_uncased_pwhatisthe.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pwhatisthe_conll2003_with_neg_with_repeat',
                                        'en.answer_question.squadv2_conll.distil_bert.base_uncased.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner',
                                        'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg',
                                        'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_multi.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi',
                                        'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_multi_with_repeat.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi_with_repeat',
                                        'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_repeat.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_repeat',
                                        'en.answer_question.squadv2_cord19.bert.small': 'bert_qa_bert_small_cord19_squad2',
                                        'en.answer_question.squadv2_cord19.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2',
                                        'en.answer_question.squadv2_cord19.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_cord19_200616_squad2',
                                        'en.answer_question.squadv2_cord19.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2',
                                        'en.answer_question.squadv2_cord19.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2',
                                        'en.answer_question.squadv2_cord19.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2',
                                        'en.answer_question.squadv2_covid.albert.xxl_v2': 'albert_qa_xxlarge_v2_squad2_covid_deepset',
                                        'en.answer_question.squadv2_covid.bert.base_uncased': 'bert_qa_bert_base_uncased_squad2_covid_qa_deepset',
                                        'en.answer_question.squadv2_covid.bert.large_uncased': 'bert_qa_bert_large_uncased_squad2_covid_qa_deepset',
                                        'en.answer_question.squadv2_covid.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.bert.uncased_6l_128d_a2a_128d': 'bert_qa_bert_uncased_L_6_H_128_A_2_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid.distil_bert.base_uncased': 'distilbert_qa_base_uncased_squad2_covid_qa_deepset',
                                        'en.answer_question.squadv2_covid.electra.base': 'electra_qa_base_squad2_covid_deepset',
                                        'en.answer_question.squadv2_covid.roberta.base': 'roberta_qa_roberta_base_squad2_covid',
                                        'en.answer_question.squadv2_covid.roberta.base.by_armageddon': 'roberta_qa_roberta_base_squad2_covid_qa_deepset',
                                        'en.answer_question.squadv2_covid.roberta.base.by_deepset': 'roberta_qa_roberta_base_squad2_covid',
                                        'en.answer_question.squadv2_covid.roberta.large': 'roberta_qa_roberta_large_squad2_covid_qa_deepset',
                                        'en.answer_question.squadv2_covid_cord19.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2_covid_qna',
                                        'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2_covid_qna',
                                        'en.answer_question.squadv2_pubmed.bert.v2': 'bert_qa_pubmed_bert_squadv2',
                                        'en.answer_question.squadv2_pubmed.biobert.v2': 'bert_qa_biobert_v1.1_pubmed_squad_v2',
                                        'en.answer_question.squadv2_pubmed.sapbert': 'bert_qa_sapbert_from_pubmedbert_squad2',
                                        'en.answer_question.synqa.electra.large': 'electra_qa_large_synqa',
                                        'en.answer_question.synqa.roberta.large.by_mbartolo': 'roberta_qa_roberta_large_synqa',
                                        'en.answer_question.synqa_ext.roberta.large.by_mbartolo': 'roberta_qa_roberta_large_synqa_ext',
                                        'en.answer_question.tquad.bert.xtremedistiled_uncased': 'bert_qa_xtremedistil_l6_h256_uncased_TQUAD_finetuned_lr_2e_05_epochs_9',
                                        'en.answer_question.trial.bert.by_sunitha': 'bert_qa_Trial_3_Results',
                                        'en.answer_question.trivia.albert.xxl': 'albert_qa_xxlarge_tweetqa',
                                        'en.answer_question.trivia.bert': 'bert_qa_fine_tuned_tweetqa_aip',
                                        'en.answer_question.trivia.bert.base_1024d': 'bert_qa_bert_base_1024_full_trivia_copied_embeddings',
                                        'en.answer_question.trivia.bert.base_2048.by_MrAnderson': 'bert_qa_bert_base_2048_full_trivia_copied_embeddings',
                                        'en.answer_question.trivia.bert.base_4096.by_MrAnderson': 'bert_qa_bert_base_4096_full_trivia_copied_embeddings',
                                        'en.answer_question.trivia.bert.base_512d': 'bert_qa_bert_base_512_full_trivia',
                                        'en.answer_question.trivia.bert.by_Danastos': 'bert_qa_triviaqa_bert_el_Danastos',
                                        'en.answer_question.trivia.bert.by_Kutay': 'bert_qa_fine_tuned_tweetqa_aip',
                                        'en.answer_question.trivia.distil_bert.base_uncased': 'distilbert_qa_base_uncased_finetuned_triviaqa',
                                        'en.answer_question.trivia.longformer.large': 'longformer_qa_large_4096_finetuned_triviaqa',
                                        'en.answer_question.trivia.roberta': 'roberta_qa_roberta_fine_tuned_tweet_sentiment_extractor',
                                        'en.answer_question.trivia.roberta.base': 'roberta_qa_roberta_base_tweetqa_model',
                                        'en.answer_question.trivia.roberta.large': 'roberta_qa_roberta_large_tweetqa',
                                        'en.answer_question.trivia.xlmr_roberta.large': 'xlm_roberta_qa_xlmroberta_large_tweetqa',
                                        'en.answer_question.tydiqa.bert': 'bert_qa_bert_all',
                                        'en.answer_question.tydiqa.bert.multilingual': 'bert_qa_Part_2_BERT_Multilingual_Dutch_Model_E1',
                                        'en.answer_question.tydiqa.distil_bert': 'distilbert_qa_multi_finetuned_for_xqua_on_tydiqa',
                                        'en.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_Part_2_mBERT_Model_E2',
                                        'en.answer_question.tydiqa.roberta': 'roberta_qa_roberta_tydiqa',
                                        'en.answer_question.tydiqa.xlm_roberta': 'xlm_roberta_qa_xlm_all',
                                        'en.answer_question.tydiqa.xlm_roberta.3lang': 'xlm_roberta_qa_xlm_3lang',
                                        'en.answer_question.tydiqa.xlm_roberta.by_horsbug98': 'xlm_roberta_qa_Part_1_XLM_Model_E1',
                                        'en.answer_question.tydiqa.xlm_roberta.by_krinal214': 'xlm_roberta_qa_xlm_all',
                                        'en.answer_question.tydiqa.xlm_roberta.v2.by_horsbug98': 'xlm_roberta_qa_Part_2_XLM_Model_E1',
                                        'en.answer_question.xlm_roberta': 'xlm_roberta_qa_mrc2reader',
                                        'en.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_finetune_qa',
                                        'en.answer_question.xlm_roberta.by_Dongjae': 'xlm_roberta_qa_mrc2reader',
                                        'en.answer_question.xlm_roberta.by_Srini99': 'xlm_roberta_qa_TQA',
                                        'en.answer_question.xlm_roberta.by_anukaver': 'xlm_roberta_qa_xlm_roberta_est_qa',
                                        'en.answer_question.xlm_roberta.by_jeew': 'xlm_roberta_qa_xlm_roberta_ckpt_95000',
                                        'en.answer_question.xlm_roberta.by_laifuchicago': 'xlm_roberta_qa_farm2tran',
                                        'en.answer_question.xlm_roberta.by_ncthuan': 'xlm_roberta_qa_xlm_l_uetqa',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265897': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265897',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265898': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265898',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265899': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265899',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265900': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265900',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265901': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265901',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265902': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265902',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265903': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265903',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265904': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265904',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265905': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265905',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265906': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265906',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265907': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265907',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265908': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265908',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265909': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265909',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265910': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265910',
                                        'en.answer_question.xlm_roberta.fine_tune_24465520_26265911': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265911',
                                        'en.answer_question.xlm_roberta.fr_tuned.by_Gantenbein': 'roberta_qa_ADDI_FR_XLM_R',
                                        'en.answer_question.xlmr_roberta': 'xlm_roberta_qa_XLMr_ENIS_QA_IsQ_EnA',
                                        'en.answer_question.xquad.bert.multilingual_base': 'bert_qa_bert_base_multilingual_xquad',
                                        'en.answer_question.xquad.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_xquad',
                                        'en.answer_question.xquad.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_xquad',
                                        'en.answer_question.xquad_chaii.bert.cased': 'bert_qa_bert_multi_cased_finedtuned_xquad_chaii',
                                        'en.answer_question.xquad_squad.bert.cased': 'bert_qa_bert_multi_cased_finetuned_xquadv1_finetuned_squad_colab',
                                        'en.bert': 'bert_base_uncased',
                                        'en.chunk': 'default_chunker',
                                        'en.classify.ag_news.longformer': 'longformer_base_sequence_classifier_ag_news',
                                        'en.classify.ag_news.xlnet': 'xlnet_base_sequence_classifier_ag_news',
                                        'en.classify.albert.ag_news': 'albert_base_sequence_classifier_ag_news',
                                        'en.classify.albert.imdb': 'albert_base_sequence_classifier_imdb',
                                        'en.classify.bert_sequence.ag_news': 'bert_base_sequence_classifier_ag_news',
                                        'en.classify.bert_sequence.dbpedia_14': 'bert_base_sequence_classifier_dbpedia_14',
                                        'en.classify.bert_sequence.dehatebert_mono': 'bert_sequence_classifier_dehatebert_mono',
                                        'en.classify.bert_sequence.finbert': 'bert_sequence_classifier_finbert',
                                        'en.classify.bert_sequence.imdb': 'bert_base_sequence_classifier_imdb',
                                        'en.classify.bert_sequence.imdb_large': 'bert_large_sequence_classifier_imdb',
                                        'en.classify.cyberbullying': 'classifierdl_use_cyberbullying',
                                        'en.classify.cyberbullying.use': 'classifierdl_use_cyberbullying',
                                        'en.classify.dbpedia': 'deberta_v3_small_sequence_classifier_dbpedia_14',
                                        'en.classify.distilbert_sequence.ag_news': 'distilbert_base_sequence_classifier_ag_news',
                                        'en.classify.distilbert_sequence.amazon_polarity': 'distilbert_base_sequence_classifier_amazon_polarity',
                                        'en.classify.distilbert_sequence.banking77': 'distilbert_sequence_classifier_banking77',
                                        'en.classify.distilbert_sequence.emotion': 'distilbert_sequence_classifier_emotion',
                                        'en.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
                                        'en.classify.distilbert_sequence.industry': 'distilbert_sequence_classifier_industry',
                                        'en.classify.distilbert_sequence.policy': 'distilbert_sequence_classifier_policy',
                                        'en.classify.distilbert_sequence.sst2': 'distilbert_sequence_classifier_sst2',
                                        'en.classify.e2e': 'multiclassifierdl_use_e2e',
                                        'en.classify.emotion': 'classifierdl_use_emotion',
                                        'en.classify.emotion.bert': 'bert_sequence_classifier_emotion',
                                        'en.classify.emotion.use': 'classifierdl_use_emotion',
                                        'en.classify.fakenews': 'classifierdl_use_fakenews',
                                        'en.classify.fakenews.use': 'classifierdl_use_fakenews',
                                        'en.classify.finance_sentiment': 'bert_sequence_classifier_finbert_tone',
                                        'en.classify.imdb.longformer': 'longformer_base_sequence_classifier_imdb',
                                        'en.classify.imdb.xlnet': 'xlnet_base_sequence_classifier_imdb',
                                        'en.classify.intent.airline': 'classifierdl_use_atis',
                                        'en.classify.intent.atis': 'classifierdl_use_atis',
                                        'en.classify.news.deberta': 'deberta_v3_xsmall_sequence_classifier_ag_news',
                                        'en.classify.news.deberta.small': 'deberta_v3_small_sequence_classifier_ag_news',
                                        'en.classify.question': 'classifierdl_use_trec50',
                                        'en.classify.question_vs_statement': 'bert_sequence_classifier_question_statement',
                                        'en.classify.questionpair': 'classifierdl_electra_questionpair',
                                        'en.classify.questions': 'classifierdl_use_trec50',
                                        'en.classify.questions.airline': 'classifierdl_use_atis',
                                        'en.classify.questions.atis': 'classifierdl_use_atis',
                                        'en.classify.roberta.ag_news': 'roberta_base_sequence_classifier_ag_news',
                                        'en.classify.roberta.imdb': 'roberta_base_sequence_classifier_imdb',
                                        'en.classify.sarcasm': 'classifierdl_use_sarcasm',
                                        'en.classify.sarcasm.use': 'classifierdl_use_sarcasm',
                                        'en.classify.sentiment.imdb.deberta': 'deberta_v3_xsmall_sequence_classifier_imdb',
                                        'en.classify.sentiment.imdb.deberta.base': 'deberta_v3_base_sequence_classifier_imdb',
                                        'en.classify.sentiment.imdb.deberta.large': 'deberta_v3_large_sequence_classifier_imdb',
                                        'en.classify.sentiment.imdb.deberta.small': 'deberta_v3_small_sequence_classifier_imdb',
                                        'en.classify.snips': 'nerdl_snips_100d',
                                        'en.classify.song_lyrics': 'bert_sequence_classifier_song_lyrics',
                                        'en.classify.spam': 'classifierdl_use_spam',
                                        'en.classify.spam.use': 'classifierdl_use_spam',
                                        'en.classify.token_albert.xlarge_token_classifier_conll03': 'albert_xlarge_token_classifier_conll03',
                                        'en.classify.token_albert_base_token_classifier_conll03': 'albert_base_token_classifier_conll03',
                                        'en.classify.token_albert_large_token_classifier_conll03': 'albert_large_token_classifier_conll03',
                                        'en.classify.token_bert.classifier_ner_btc': 'bert_token_classifier_ner_btc',
                                        'en.classify.token_bert.conll03': 'bert_base_token_classifier_conll03',
                                        'en.classify.token_bert.few_nerd': 'bert_base_token_classifier_few_nerd',
                                        'en.classify.token_bert.large_conll03': 'bert_large_token_classifier_conll03',
                                        'en.classify.token_bert.large_ontonote': 'bert_large_token_classifier_ontonote',
                                        'en.classify.token_bert.ontonote': 'bert_base_token_classifier_ontonote',
                                        'en.classify.token_distilroberta_base_token_classifier_ontonotes': 'distilroberta_base_token_classifier_ontonotes',
                                        'en.classify.token_longformer.base_token_classifier_conll03': 'longformer_base_token_classifier_conll03',
                                        'en.classify.token_roberta.large_token_classifier_ontonotes': 'roberta_large_token_classifier_ontonotes',
                                        'en.classify.token_roberta_base_token_classifier_conll03': 'roberta_base_token_classifier_conll03',
                                        'en.classify.token_roberta_base_token_classifier_ontonotes': 'roberta_base_token_classifier_ontonotes',
                                        'en.classify.token_roberta_large_token_classifier_conll03': 'roberta_large_token_classifier_conll03',
                                        'en.classify.token_xlnet.large_token_classifier_conll03': 'xlnet_large_token_classifier_conll03',
                                        'en.classify.token_xlnet_base_token_classifier_conll03': 'xlnet_base_token_classifier_conll03',
                                        'en.classify.toxic': 'multiclassifierdl_use_toxic',
                                        'en.classify.toxic.sm': 'multiclassifierdl_use_toxic_sm',
                                        'en.classify.trec50': 'classifierdl_use_trec50',
                                        'en.classify.trec50.use': 'classifierdl_use_trec50',
                                        'en.classify.trec6': 'classifierdl_use_trec6',
                                        'en.classify.trec6.use': 'classifierdl_use_trec6',
                                        'en.classify.typos.distilbert': 'distilbert_token_classifier_typo_detector',
                                        'en.classify.xlm_roberta.ag_news': 'xlm_roberta_base_sequence_classifier_ag_news',
                                        'en.classify.xlm_roberta.imdb': 'xlm_roberta_base_sequence_classifier_imdb',
                                        'en.dep': 'dependency_typed_conllu',
                                        'en.dep.typed': 'dependency_typed_conllu',
                                        'en.dep.typed.conllu': 'dependency_typed_conllu',
                                        'en.dep.untyped': 'dependency_conllu',
                                        'en.dep.untyped.conllu': 'dependency_conllu',
                                        'en.e2e': 'multiclassifierdl_use_e2e',
                                        'en.embed': 'glove_100d',
                                        'en.embed.Bible_roberta_base': 'roberta_embeddings_Bible_roberta_base',
                                        'en.embed.COVID_SciBERT': 'bert_embeddings_COVID_SciBERT',
                                        'en.embed.DiLBERT': 'bert_embeddings_DiLBERT',
                                        'en.embed.FinancialBERT': 'bert_embeddings_FinancialBERT',
                                        'en.embed.SecBERT': 'bert_embeddings_SecBERT',
                                        'en.embed.SecRoBERTa': 'roberta_embeddings_SecRoBERTa',
                                        'en.embed.agriculture_bert_uncased': 'bert_embeddings_agriculture_bert_uncased',
                                        'en.embed.albert': 'albert_base_uncased',
                                        'en.embed.albert.base_uncased': 'albert_base_uncased',
                                        'en.embed.albert.large_uncased': 'albert_large_uncased',
                                        'en.embed.albert.xlarge_uncased': 'albert_xlarge_uncased',
                                        'en.embed.albert.xxlarge_uncased': 'albert_xxlarge_uncased',
                                        'en.embed.albert_base_v1': 'albert_embeddings_albert_base_v1',
                                        'en.embed.albert_xlarge_v1': 'albert_embeddings_albert_xlarge_v1',
                                        'en.embed.albert_xxlarge_v1': 'albert_embeddings_albert_xxlarge_v1',
                                        'en.embed.bert': 'bert_base_uncased',
                                        'en.embed.bert.base_cased': 'bert_base_cased',
                                        'en.embed.bert.base_uncased': 'bert_base_uncased',
                                        'en.embed.bert.base_uncased_legal': 'bert_base_uncased_legal',
                                        'en.embed.bert.large_cased': 'bert_large_cased',
                                        'en.embed.bert.large_uncased': 'bert_large_uncased',
                                        'en.embed.bert.pubmed': 'bert_pubmed',
                                        'en.embed.bert.pubmed_squad2': 'bert_pubmed_squad2',
                                        'en.embed.bert.small_L10_128': 'small_bert_L10_128',
                                        'en.embed.bert.small_L10_256': 'small_bert_L10_256',
                                        'en.embed.bert.small_L10_512': 'small_bert_L10_512',
                                        'en.embed.bert.small_L10_768': 'small_bert_L10_768',
                                        'en.embed.bert.small_L12_128': 'small_bert_L12_128',
                                        'en.embed.bert.small_L12_256': 'small_bert_L12_256',
                                        'en.embed.bert.small_L12_512': 'small_bert_L12_512',
                                        'en.embed.bert.small_L12_768': 'small_bert_L12_768',
                                        'en.embed.bert.small_L2_128': 'small_bert_L2_128',
                                        'en.embed.bert.small_L2_256': 'small_bert_L2_256',
                                        'en.embed.bert.small_L2_512': 'small_bert_L2_512',
                                        'en.embed.bert.small_L2_768': 'small_bert_L2_768',
                                        'en.embed.bert.small_L4_128': 'small_bert_L4_128',
                                        'en.embed.bert.small_L4_256': 'small_bert_L4_256',
                                        'en.embed.bert.small_L4_512': 'small_bert_L4_512',
                                        'en.embed.bert.small_L4_768': 'small_bert_L4_768',
                                        'en.embed.bert.small_L6_128': 'small_bert_L6_128',
                                        'en.embed.bert.small_L6_256': 'small_bert_L6_256',
                                        'en.embed.bert.small_L6_512': 'small_bert_L6_512',
                                        'en.embed.bert.small_L6_768': 'small_bert_L6_768',
                                        'en.embed.bert.small_L8_128': 'small_bert_L8_128',
                                        'en.embed.bert.small_L8_256': 'small_bert_L8_256',
                                        'en.embed.bert.small_L8_512': 'small_bert_L8_512',
                                        'en.embed.bert.small_L8_768': 'small_bert_L8_768',
                                        'en.embed.bert.wiki_books': 'bert_wiki_books',
                                        'en.embed.bert.wiki_books_mnli': 'bert_wiki_books_mnli',
                                        'en.embed.bert.wiki_books_qnli': 'bert_wiki_books_qnli',
                                        'en.embed.bert.wiki_books_qqp': 'bert_wiki_books_qqp',
                                        'en.embed.bert.wiki_books_squad2': 'bert_wiki_books_squad2',
                                        'en.embed.bert.wiki_books_sst2': 'bert_wiki_books_sst2',
                                        'en.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                        'en.embed.bert_base_en_cased': 'bert_embeddings_bert_base_en_cased',
                                        'en.embed.bert_base_uncased_dstc9': 'bert_embeddings_bert_base_uncased_dstc9',
                                        'en.embed.bert_base_uncased_mnli_sparse_70_unstructured_no_classifier': 'bert_embeddings_bert_base_uncased_mnli_sparse_70_unstructured_no_classifier',
                                        'en.embed.bert_base_uncased_sparse_70_unstructured': 'bert_embeddings_bert_base_uncased_sparse_70_unstructured',
                                        'en.embed.bert_for_patents': 'bert_embeddings_bert_for_patents',
                                        'en.embed.bert_large_cased_whole_word_masking': 'bert_embeddings_bert_large_cased_whole_word_masking',
                                        'en.embed.bert_large_uncased_whole_word_masking': 'bert_embeddings_bert_large_uncased_whole_word_masking',
                                        'en.embed.bert_political_election2020_twitter_mlm': 'bert_embeddings_bert_political_election2020_twitter_mlm',
                                        'en.embed.biobert': 'biobert_pubmed_base_cased',
                                        'en.embed.biobert.clinical_base_cased': 'biobert_clinical_base_cased',
                                        'en.embed.biobert.discharge_base_cased': 'biobert_discharge_base_cased',
                                        'en.embed.biobert.pmc_base_cased': 'biobert_pmc_base_cased',
                                        'en.embed.biobert.pubmed_base_cased': 'biobert_pubmed_base_cased',
                                        'en.embed.biobert.pubmed_large_cased': 'biobert_pubmed_large_cased',
                                        'en.embed.biobert.pubmed_pmc_base_cased': 'biobert_pubmed_pmc_base_cased',
                                        'en.embed.chEMBL26_smiles_v2': 'roberta_embeddings_chEMBL26_smiles_v2',
                                        'en.embed.chEMBL_smiles_v1': 'roberta_embeddings_chEMBL_smiles_v1',
                                        'en.embed.chemical_bert_uncased': 'bert_embeddings_chemical_bert_uncased',
                                        'en.embed.childes_bert': 'bert_embeddings_childes_bert',
                                        'en.embed.clinical_pubmed_bert_base_128': 'bert_embeddings_clinical_pubmed_bert_base_128',
                                        'en.embed.clinical_pubmed_bert_base_512': 'bert_embeddings_clinical_pubmed_bert_base_512',
                                        'en.embed.covidbert': 'covidbert_large_uncased',
                                        'en.embed.covidbert.large_uncased': 'covidbert_large_uncased',
                                        'en.embed.crosloengual_bert': 'bert_embeddings_crosloengual_bert',
                                        'en.embed.danbert_small_cased': 'bert_embeddings_danbert_small_cased',
                                        'en.embed.deberta_base_uncased': 'bert_embeddings_deberta_base_uncased',
                                        'en.embed.deberta_v3_base': 'deberta_v3_base',
                                        'en.embed.deberta_v3_large': 'deberta_v3_large',
                                        'en.embed.deberta_v3_small': 'deberta_v3_small',
                                        'en.embed.deberta_v3_xsmall': 'deberta_v3_xsmall',
                                        'en.embed.distilbert': 'distilbert_base_cased',
                                        'en.embed.distilbert.base': 'distilbert_base_cased',
                                        'en.embed.distilbert.base.uncased': 'distilbert_base_uncased',
                                        'en.embed.distilbert_base_en_cased': 'distilbert_embeddings_distilbert_base_en_cased',
                                        'en.embed.distilbert_base_uncased_sparse_85_unstructured_pruneofa': 'distilbert_embeddings_distilbert_base_uncased_sparse_85_unstructured_pruneofa',
                                        'en.embed.distilbert_base_uncased_sparse_90_unstructured_pruneofa': 'distilbert_embeddings_distilbert_base_uncased_sparse_90_unstructured_pruneofa',
                                        'en.embed.distilroberta': 'distilroberta_base',
                                        'en.embed.distilroberta_base': 'roberta_embeddings_distilroberta_base',
                                        'en.embed.distilroberta_base_climate_d': 'roberta_embeddings_distilroberta_base_climate_d',
                                        'en.embed.distilroberta_base_climate_d_s': 'roberta_embeddings_distilroberta_base_climate_d_s',
                                        'en.embed.distilroberta_base_climate_f': 'roberta_embeddings_distilroberta_base_climate_f',
                                        'en.embed.distilroberta_base_finetuned_jira_qt_issue_title': 'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_title',
                                        'en.embed.distilroberta_base_finetuned_jira_qt_issue_titles_and_bodies': 'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_titles_and_bodies',
                                        'en.embed.e': 'bert_biolink_base',
                                        'en.embed.electra': 'electra_small_uncased',
                                        'en.embed.electra.base_uncased': 'electra_base_uncased',
                                        'en.embed.electra.large_uncased': 'electra_large_uncased',
                                        'en.embed.electra.medical': 'electra_medal_acronym',
                                        'en.embed.electra.small_uncased': 'electra_small_uncased',
                                        'en.embed.elmo': 'elmo',
                                        'en.embed.fairlex_ecthr_minilm': 'roberta_embeddings_fairlex_ecthr_minilm',
                                        'en.embed.fairlex_scotus_minilm': 'roberta_embeddings_fairlex_scotus_minilm',
                                        'en.embed.false_positives_scancode_bert_base_uncased_L8_1': 'bert_embeddings_false_positives_scancode_bert_base_uncased_L8_1',
                                        'en.embed.finbert_pretrain_yiyanghkust': 'bert_embeddings_finbert_pretrain_yiyanghkust',
                                        'en.embed.finest_bert': 'bert_embeddings_finest_bert',
                                        'en.embed.ge': 'bert_biolink_large',
                                        'en.embed.glove': 'glove_100d',
                                        'en.embed.glove.100d': 'glove_100d',
                                        'en.embed.hateBERT': 'bert_embeddings_hateBERT',
                                        'en.embed.legal_bert_base_uncased': 'bert_embeddings_legal_bert_base_uncased',
                                        'en.embed.legal_bert_small_uncased': 'bert_embeddings_legal_bert_small_uncased',
                                        'en.embed.legal_roberta_base': 'roberta_embeddings_legal_roberta_base',
                                        'en.embed.lic_class_scancode_bert_base_cased_L32_1': 'bert_embeddings_lic_class_scancode_bert_base_cased_L32_1',
                                        'en.embed.longformer': 'longformer_base_4096',
                                        'en.embed.longformer.clinical': 'clinical_longformer',
                                        'en.embed.longformer.large': 'longformer_large_4096',
                                        'en.embed.muppet_roberta_base': 'roberta_embeddings_muppet_roberta_base',
                                        'en.embed.muppet_roberta_large': 'roberta_embeddings_muppet_roberta_large',
                                        'en.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                        'en.embed.netbert': 'bert_embeddings_netbert',
                                        'en.embed.pmc_med_bio_mlm_roberta_large': 'roberta_embeddings_pmc_med_bio_mlm_roberta_large',
                                        'en.embed.psych_search': 'bert_embeddings_psych_search',
                                        'en.embed.roberta': 'roberta_base',
                                        'en.embed.roberta.base': 'roberta_base',
                                        'en.embed.roberta.large': 'roberta_large',
                                        'en.embed.roberta_pubmed': 'roberta_embeddings_roberta_pubmed',
                                        'en.embed.sec_bert_base': 'bert_embeddings_sec_bert_base',
                                        'en.embed.sec_bert_num': 'bert_embeddings_sec_bert_num',
                                        'en.embed.sec_bert_sh': 'bert_embeddings_sec_bert_sh',
                                        'en.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'en.embed.word2vec.gigaword': 'word2vec_gigaword_300',
                                        'en.embed.word2vec.gigaword_wiki': 'word2vec_gigaword_wiki_300',
                                        'en.embed.xlnet': 'xlnet_base_cased',
                                        'en.embed.xlnet_base_cased': 'xlnet_base_cased',
                                        'en.embed.xlnet_large_cased': 'xlnet_large_cased',
                                        'en.embed_chunk': 'chunk_embeddings',
                                        'en.embed_sentence': 'tfhub_use',
                                        'en.embed_sentence.albert': 'albert_base_uncased',
                                        'en.embed_sentence.bert': 'sent_bert_base_uncased',
                                        'en.embed_sentence.bert.base_uncased_legal': 'sent_bert_base_uncased_legal',
                                        'en.embed_sentence.bert.pubmed': 'sent_bert_pubmed',
                                        'en.embed_sentence.bert.pubmed_squad2': 'sent_bert_pubmed_squad2',
                                        'en.embed_sentence.bert.wiki_books': 'sent_bert_wiki_books',
                                        'en.embed_sentence.bert.wiki_books_mnli': 'sent_bert_wiki_books_mnli',
                                        'en.embed_sentence.bert.wiki_books_qnli': 'sent_bert_wiki_books_qnli',
                                        'en.embed_sentence.bert.wiki_books_qqp': 'sent_bert_wiki_books_qqp',
                                        'en.embed_sentence.bert.wiki_books_squad2': 'sent_bert_wiki_books_squad2',
                                        'en.embed_sentence.bert.wiki_books_sst2': 'sent_bert_wiki_books_sst2',
                                        'en.embed_sentence.bert_base_cased': 'sent_bert_base_cased',
                                        'en.embed_sentence.bert_base_uncased': 'sent_bert_base_uncased',
                                        'en.embed_sentence.bert_large_cased': 'sent_bert_large_cased',
                                        'en.embed_sentence.bert_large_uncased': 'sent_bert_large_uncased',
                                        'en.embed_sentence.bert_use_cmlm_en_base': 'sent_bert_use_cmlm_en_base',
                                        'en.embed_sentence.bert_use_cmlm_en_large': 'sent_bert_use_cmlm_en_large',
                                        'en.embed_sentence.biobert.clinical_base_cased': 'sent_biobert_clinical_base_cased',
                                        'en.embed_sentence.biobert.discharge_base_cased': 'sent_biobert_discharge_base_cased',
                                        'en.embed_sentence.biobert.pmc_base_cased': 'sent_biobert_pmc_base_cased',
                                        'en.embed_sentence.biobert.pubmed_base_cased': 'sent_biobert_pubmed_base_cased',
                                        'en.embed_sentence.biobert.pubmed_large_cased': 'sent_biobert_pubmed_large_cased',
                                        'en.embed_sentence.biobert.pubmed_pmc_base_cased': 'sent_biobert_pubmed_pmc_base_cased',
                                        'en.embed_sentence.covidbert.large_uncased': 'sent_covidbert_large_uncased',
                                        'en.embed_sentence.doc2vec': 'doc2vec_gigaword_300',
                                        'en.embed_sentence.doc2vec.gigaword_300': 'doc2vec_gigaword_300',
                                        'en.embed_sentence.doc2vec.gigaword_wiki_300': 'doc2vec_gigaword_wiki_300',
                                        'en.embed_sentence.electra': 'sent_electra_small_uncased',
                                        'en.embed_sentence.electra_base_uncased': 'sent_electra_base_uncased',
                                        'en.embed_sentence.electra_large_uncased': 'sent_electra_large_uncased',
                                        'en.embed_sentence.electra_small_uncased': 'sent_electra_small_uncased',
                                        'en.embed_sentence.small_bert_L10_128': 'sent_small_bert_L10_128',
                                        'en.embed_sentence.small_bert_L10_256': 'sent_small_bert_L10_256',
                                        'en.embed_sentence.small_bert_L10_512': 'sent_small_bert_L10_512',
                                        'en.embed_sentence.small_bert_L10_768': 'sent_small_bert_L10_768',
                                        'en.embed_sentence.small_bert_L12_128': 'sent_small_bert_L12_128',
                                        'en.embed_sentence.small_bert_L12_256': 'sent_small_bert_L12_256',
                                        'en.embed_sentence.small_bert_L12_512': 'sent_small_bert_L12_512',
                                        'en.embed_sentence.small_bert_L12_768': 'sent_small_bert_L12_768',
                                        'en.embed_sentence.small_bert_L2_128': 'sent_small_bert_L2_128',
                                        'en.embed_sentence.small_bert_L2_256': 'sent_small_bert_L2_256',
                                        'en.embed_sentence.small_bert_L2_512': 'sent_small_bert_L2_512',
                                        'en.embed_sentence.small_bert_L2_768': 'sent_small_bert_L2_768',
                                        'en.embed_sentence.small_bert_L4_128': 'sent_small_bert_L4_128',
                                        'en.embed_sentence.small_bert_L4_256': 'sent_small_bert_L4_256',
                                        'en.embed_sentence.small_bert_L4_512': 'sent_small_bert_L4_512',
                                        'en.embed_sentence.small_bert_L4_768': 'sent_small_bert_L4_768',
                                        'en.embed_sentence.small_bert_L6_128': 'sent_small_bert_L6_128',
                                        'en.embed_sentence.small_bert_L6_256': 'sent_small_bert_L6_256',
                                        'en.embed_sentence.small_bert_L6_512': 'sent_small_bert_L6_512',
                                        'en.embed_sentence.small_bert_L6_768': 'sent_small_bert_L6_768',
                                        'en.embed_sentence.small_bert_L8_128': 'sent_small_bert_L8_128',
                                        'en.embed_sentence.small_bert_L8_256': 'sent_small_bert_L8_256',
                                        'en.embed_sentence.small_bert_L8_512': 'sent_small_bert_L8_512',
                                        'en.embed_sentence.small_bert_L8_768': 'sent_small_bert_L8_768',
                                        'en.embed_sentence.tfhub_use': 'tfhub_use',
                                        'en.embed_sentence.tfhub_use.lg': 'tfhub_use_lg',
                                        'en.embed_sentence.use': 'tfhub_use',
                                        'en.embed_sentence.use.lg': 'tfhub_use_lg',
                                        'en.glove': 'glove_100d',
                                        'en.gpt2': 'gpt2',
                                        'en.gpt2.distilled': 'gpt2_distilled',
                                        'en.gpt2.large': 'gpt_large',
                                        'en.gpt2.medium': 'gpt2_medium',
                                        'en.lemma': 'lemma_lines',
                                        'en.lemma.antbnc': 'lemma_antbnc',
                                        'en.lemma.atis': 'lemma_atis',
                                        'en.lemma.esl': 'lemma_esl',
                                        'en.lemma.ewt': 'lemma_ewt',
                                        'en.lemma.gum': 'lemma_gum',
                                        'en.lemma.lines': 'lemma_lines',
                                        'en.lemma.partut': 'lemma_partut',
                                        'en.lemma.spacylookup': 'lemma_spacylookup',
                                        'en.ner.airline': 'nerdl_atis_840b_300d',
                                        'en.ner.aspect.airline': 'nerdl_atis_840b_300d',
                                        'en.ner.aspect.atis': 'nerdl_atis_840b_300d',
                                        'en.ner.atis': 'nerdl_atis_840b_300d',
                                        'en.ner.bert_base_cased': 'ner_dl_bert_base_cased',
                                        'en.ner.conll_albert_base_uncased': 'ner_conll_albert_base_uncased',
                                        'en.ner.conll_albert_large_uncased': 'ner_conll_albert_large_uncased',
                                        'en.ner.conll_bert_base_cased': 'ner_conll_bert_base_cased',
                                        'en.ner.conll_distilbert_base_cased': 'ner_conll_distilbert_base_cased',
                                        'en.ner.conll_longformer_large_4096': 'ner_conll_longformer_large_4096',
                                        'en.ner.conll_roberta_base': 'ner_conll_roberta_base',
                                        'en.ner.conll_roberta_large': 'ner_conll_roberta_large',
                                        'en.ner.conll_xlm_roberta_base': 'ner_conll_xlm_roberta_base',
                                        'en.ner.conll_xlnet_base_cased': 'ner_conll_xlnet_base_cased',
                                        'en.ner.debertav3_base.conll03': 'deberta_v3_base_token_classifier_conll03',
                                        'en.ner.debertav3_base.ontonotes': 'deberta_v3_base_token_classifier_ontonotes',
                                        'en.ner.debertav3_large.conll03': 'deberta_v3_large_token_classifier_conll03',
                                        'en.ner.debertav3_large.ontonotes': 'deberta_v3_large_token_classifier_ontonotes',
                                        'en.ner.debertav3_small.conll03': 'deberta_v3_small_token_classifier_conll03',
                                        'en.ner.debertav3_small.ontonotes': 'deberta_v3_small_token_classifier_ontonotes',
                                        'en.ner.debertav3_xsmall.conll03': 'deberta_v3_xsmall_token_classifier_conll03',
                                        'en.ner.debertav3_xsmall.ontonotes': 'deberta_v3_xsmall_token_classifier_ontonotes',
                                        'en.ner.dl': 'ner_dl',
                                        'en.ner.dl.bert': 'ner_dl_bert',
                                        'en.ner.fewnerd': 'nerdl_fewnerd_100d',
                                        'en.ner.fewnerd_subentity': 'nerdl_fewnerd_subentity_100d',
                                        'en.ner.glove': 'ner_dl_sentence',
                                        'en.ner.glove.100d': 'ner_dl_sentence',
                                        'en.ner.mit_movie_complex_bert': 'ner_mit_movie_complex_bert_base_cased',
                                        'en.ner.mit_movie_complex_distilbert': 'ner_mit_movie_complex_distilbert_base_cased',
                                        'en.ner.mit_movie_simple': 'ner_mit_movie_simple_distilbert_base_cased',
                                        'en.ner.movie': 'ner_mit_movie_complex_bert_base_cased',
                                        'en.ner.movie_complex': 'ner_mit_movie_complex_bert_base_cased',
                                        'en.ner.movie_simple': 'ner_mit_movie_complex_bert_base_cased',
                                        'en.ner.ner_chemical_bionlp_bc5cdr_pubmed': 'roberta_ner_ner_chemical_bionlp_bc5cdr_pubmed',
                                        'en.ner.ner_disease_ncbi_bionlp_bc5cdr_pubmed': 'roberta_ner_ner_disease_ncbi_bionlp_bc5cdr_pubmed',
                                        'en.ner.ner_gene_dna_rna_jnlpba_pubmed': 'roberta_ner_ner_gene_dna_rna_jnlpba_pubmed',
                                        'en.ner.onto': 'onto_100',
                                        'en.ner.onto.bert.cased_base': 'onto_bert_base_cased',
                                        'en.ner.onto.bert.cased_large': 'onto_bert_large_cased',
                                        'en.ner.onto.bert.small_l2_128': 'onto_small_bert_L2_128',
                                        'en.ner.onto.bert.small_l4_256': 'onto_small_bert_L4_256',
                                        'en.ner.onto.bert.small_l4_512': 'onto_small_bert_L4_512',
                                        'en.ner.onto.bert.small_l8_512': 'onto_small_bert_L8_512',
                                        'en.ner.onto.electra.uncased_base': 'onto_electra_base_uncased',
                                        'en.ner.onto.electra.uncased_large': 'onto_electra_large_uncased',
                                        'en.ner.onto.electra.uncased_small': 'onto_electra_small_uncased',
                                        'en.ner.onto.glove.6B_100d': 'onto_100',
                                        'en.ner.onto.glove.840B_300d': 'onto_300',
                                        'en.ner.ontonotes_distilbert_base_cased': 'ner_ontonotes_distilbert_base_cased',
                                        'en.ner.ontonotes_roberta_base': 'ner_ontonotes_roberta_base',
                                        'en.ner.ontonotes_roberta_large': 'ner_ontonotes_roberta_large',
                                        'en.ner.restaurant': 'nerdl_restaurant_100d',
                                        'en.ner.roberta_classics_ner': 'roberta_ner_roberta_classics_ner',
                                        'en.ner.roberta_large_finetuned_abbr': 'roberta_ner_roberta_large_finetuned_abbr',
                                        'en.ner.roberta_large_ner_english': 'roberta_ner_roberta_large_ner_english',
                                        'en.ner.roberta_ticker': 'roberta_ner_roberta_ticker',
                                        'en.ner.snips': 'classifierdl_use_snips',
                                        'en.ner.stocks_ticker': 'roberta_token_classifier_ticker',
                                        'en.ner.time': 'roberta_token_classifier_timex_semeval',
                                        'en.ngram': 'ngram',
                                        'en.norm': 'norm',
                                        'en.pos': 'pos_atis',
                                        'en.pos.anc': 'pos_anc',
                                        'en.pos.atis': 'pos_atis',
                                        'en.pos.ewt': 'pos_ewt',
                                        'en.pos.gum': 'pos_gum',
                                        'en.pos.lines': 'pos_lines',
                                        'en.pos.partut': 'pos_partut',
                                        'en.pos.roberta_base_english_upos': 'roberta_pos_roberta_base_english_upos',
                                        'en.pos.roberta_large_english_upos': 'roberta_pos_roberta_large_english_upos',
                                        'en.pos.ud_ewt': 'pos_ud_ewt',
                                        'en.sentiment.imdb.glove': 'sentimentdl_glove_imdb',
                                        'en.sentiment.imdb.use.dl': 'sentimentdl_use_imdb',
                                        'en.sentiment.twitter.dl': 'sentimentdl_use_twitter',
                                        'en.sentiment.twitter.use.dl': 'sentimentdl_use_twitter',
                                        'en.sentiment.vivekn': 'sentiment_vivekn',
                                        'en.span_question.albert': 'albert_base_qa_squad2',
                                        'en.spell.norvig': 'spellcheck_norvig',
                                        'en.stem': 'stemmer',
                                        'en.stopwords': 'stopwords_iso',
                                        'en.stopwords.iso': 'stopwords_iso',
                                        'en.t5': 'google_t5_small_ssm_nq',
                                        'en.t5.active_to_passive_styletransfer': 't5_active_to_passive_styletransfer',
                                        'en.t5.base': 't5_base',
                                        'en.t5.formal_to_informal_styletransfer': 't5_formal_to_informal_styletransfer',
                                        'en.t5.grammar_error_corrector': 't5_grammar_error_corrector',
                                        'en.t5.informal_to_formal_styletransfer': 't5_informal_to_formal_styletransfer',
                                        'en.t5.passive_to_active_styletransfer': 't5_passive_to_active_styletransfer',
                                        'en.t5.small': 't5_small',
                                        'en.t5.wikiSQL': 't5_small_wikiSQL',
                                        'en.tokenize': 'spark_nlp_tokenizer',
                                        'en.toxic': 'multiclassifierdl_use_toxic',
                                        'en.use': 'tfhub_use',
                                        'en.xlnet': 'xlnet_base_cased',
                                        'en.yake': 'yake',
                                        'roberta': 'distilroberta_base'},
                                    'eo': {'eo.embed.w2v_cc_300d': 'w2v_cc_300d', 'eo.stopwords': 'stopwords_eo'},
                                    'es': {
                                        'es.answer_question.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_tar',
                                        'es.answer_question.mlqa.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_mlqa',
                                        'es.answer_question.sqac.bert.base': 'bert_qa_beto_base_spanish_sqac',
                                        'es.answer_question.sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac',
                                        'es.answer_question.sqac.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_sqac',
                                        'es.answer_question.sqac.roberta.base': 'roberta_qa_PlanTL_GOB_ES_roberta_base_bne_sqac',
                                        'es.answer_question.sqac.roberta.base.by_BSC-TeMU': 'roberta_qa_BSC_TeMU_roberta_base_bne_sqac',
                                        'es.answer_question.sqac.roberta.base.by_IIC': 'roberta_qa_roberta_base_spanish_sqac',
                                        'es.answer_question.sqac.roberta.base.by_PlanTL-GOB-ES': 'roberta_qa_PlanTL_GOB_ES_roberta_base_bne_sqac',
                                        'es.answer_question.sqac.roberta.base.by_mrm8488': 'roberta_qa_mrm8488_roberta_base_bne_finetuned_sqac',
                                        'es.answer_question.sqac.roberta.base.by_nlp-en-es': 'roberta_qa_nlp_en_es_roberta_base_bne_finetuned_sqac',
                                        'es.answer_question.sqac.roberta.large': 'roberta_qa_BSC_TeMU_roberta_large_bne_sqac',
                                        'es.answer_question.sqac.roberta.large.by_BSC-TeMU': 'roberta_qa_BSC_TeMU_roberta_large_bne_sqac',
                                        'es.answer_question.sqac.roberta.large.by_PlanTL-GOB-ES': 'roberta_qa_PlanTL_GOB_ES_roberta_large_bne_sqac',
                                        'es.answer_question.sqac.roberta.large.by_nlp-en-es': 'roberta_qa_bertin_large_finetuned_sqac',
                                        'es.answer_question.squad.electra.small': 'electra_qa_electricidad_small_finetuned_squadv1',
                                        'es.answer_question.squad.roberta.base': 'roberta_qa_roberta_base_spanish_squades',
                                        'es.answer_question.squad.roberta.base.by_IIC': 'roberta_qa_roberta_base_spanish_squades',
                                        'es.answer_question.squad.roberta.base.by_jamarju': 'roberta_qa_roberta_base_bne_squad_2.0_es_jamarju',
                                        'es.answer_question.squad.roberta.base_4096.by_mrm8488': 'roberta_qa_longformer_base_4096_spanish_finetuned_squad',
                                        'es.answer_question.squad.roberta.large': 'roberta_qa_roberta_large_fine_tuned_squad_es_stevemobs',
                                        'es.answer_question.squad.roberta.large.by_jamarju': 'roberta_qa_roberta_large_bne_squad_2.0_es_jamarju',
                                        'es.answer_question.squad.roberta.large.by_stevemobs': 'roberta_qa_roberta_large_fine_tuned_squad_es_stevemobs',
                                        'es.answer_question.squad.ruperta.base.by_mrm8488': 'roberta_qa_RuPERTa_base_finetuned_squadv1',
                                        'es.answer_question.squad_sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad',
                                        'es.answer_question.squadv2.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_MMG',
                                        'es.answer_question.squadv2.bert.base_cased.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_MMG',
                                        'es.answer_question.squadv2.bert.base_cased.by_mrm8488': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488',
                                        'es.answer_question.squadv2.bert.distilled_base_cased': 'bert_qa_distill_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488',
                                        'es.answer_question.squadv2.electra.small': 'electra_qa_biomedtra_small_es_squad2',
                                        'es.answer_question.squadv2.roberta.base': 'roberta_qa_roberta_base_bne_squad2_hackathon_pln',
                                        'es.answer_question.squadv2.roberta.base_v2': 'roberta_qa_RuPERTa_base_finetuned_squadv2',
                                        'es.answer_question.squadv2_bio_medical.roberta.base': 'roberta_qa_roberta_base_biomedical_es_squad2_hackathon_pln',
                                        'es.answer_question.squadv2_clinical_bio_medical.roberta.base': 'roberta_qa_roberta_base_biomedical_clinical_es_squad2_hackathon_pln',
                                        'es.answer_question.squadv2_sqac.bert.base_cased.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad2_es_MMG',
                                        'es.answer_question.squadv2_sqac.bert.base_cased_spa.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_finetuned_sqac',
                                        'es.answer_question.squadv2_sqac.bert.base_cased_v2.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_finetuned_sqac',
                                        'es.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_spanish',
                                        'es.answer_question.xlm_roberta.multilingual_large': 'xlm_roberta_qa_xlm_roberta_large_qa_multilingual_finedtuned_ru_ru_AlexKay',
                                        'es.classify.token_bert.spanish_ner': 'bert_token_classifier_spanish_ner',
                                        'es.embed.RoBERTalex': 'roberta_embeddings_RoBERTalex',
                                        'es.embed.RuPERTa_base': 'roberta_embeddings_RuPERTa_base',
                                        'es.embed.alberti_bert_base_multilingual_cased': 'bert_embeddings_alberti_bert_base_multilingual_cased',
                                        'es.embed.bert.base_cased': 'bert_base_cased',
                                        'es.embed.bert.base_uncased': 'bert_base_uncased',
                                        'es.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                        'es.embed.bert_base_es_cased': 'bert_embeddings_bert_base_es_cased',
                                        'es.embed.bertin_base_gaussian': 'roberta_embeddings_bertin_base_gaussian',
                                        'es.embed.bertin_base_gaussian_exp_512seqlen': 'roberta_embeddings_bertin_base_gaussian_exp_512seqlen',
                                        'es.embed.bertin_base_random': 'roberta_embeddings_bertin_base_random',
                                        'es.embed.bertin_base_random_exp_512seqlen': 'roberta_embeddings_bertin_base_random_exp_512seqlen',
                                        'es.embed.bertin_base_stepwise': 'roberta_embeddings_bertin_base_stepwise',
                                        'es.embed.bertin_base_stepwise_exp_512seqlen': 'roberta_embeddings_bertin_base_stepwise_exp_512seqlen',
                                        'es.embed.bertin_roberta_base_spanish': 'roberta_embeddings_bertin_roberta_base_spanish',
                                        'es.embed.bertin_roberta_large_spanish': 'roberta_embeddings_bertin_roberta_large_spanish',
                                        'es.embed.beto_gn_base_cased': 'bert_embeddings_beto_gn_base_cased',
                                        'es.embed.distilbert_base_es_cased': 'distilbert_embeddings_distilbert_base_es_cased',
                                        'es.embed.distilbert_base_es_multilingual_cased': 'distilbert_embeddings_distilbert_base_es_multilingual_cased',
                                        'es.embed.dpr_spanish_passage_encoder_allqa_base': 'bert_embeddings_dpr_spanish_passage_encoder_allqa_base',
                                        'es.embed.dpr_spanish_passage_encoder_squades_base': 'bert_embeddings_dpr_spanish_passage_encoder_squades_base',
                                        'es.embed.dpr_spanish_question_encoder_allqa_base': 'bert_embeddings_dpr_spanish_question_encoder_allqa_base',
                                        'es.embed.dpr_spanish_question_encoder_squades_base': 'bert_embeddings_dpr_spanish_question_encoder_squades_base',
                                        'es.embed.jurisbert': 'roberta_embeddings_jurisbert',
                                        'es.embed.mlm_spanish_roberta_base': 'roberta_embeddings_mlm_spanish_roberta_base',
                                        'es.embed.roberta_base_bne': 'roberta_embeddings_roberta_base_bne',
                                        'es.embed.roberta_large_bne': 'roberta_embeddings_roberta_large_bne',
                                        'es.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'es.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                        'es.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
                                        'es.lemma': 'lemma_spacylookup',
                                        'es.lemma.ancora': 'lemma_ancora',
                                        'es.lemma.gsd': 'lemma_gsd',
                                        'es.lemma.spacylookup': 'lemma_spacylookup',
                                        'es.ner': 'wikiner_6B_100',
                                        'es.ner.NER_LAW_MONEY4': 'roberta_ner_NER_LAW_MONEY4',
                                        'es.ner.RuPERTa_base_finetuned_ner': 'roberta_ner_RuPERTa_base_finetuned_ner',
                                        'es.ner.bsc_bio_ehr_es_cantemist': 'roberta_ner_bsc_bio_ehr_es_cantemist',
                                        'es.ner.bsc_bio_ehr_es_pharmaconer': 'roberta_ner_bsc_bio_ehr_es_pharmaconer',
                                        'es.ner.roberta_base_bne_capitel_ner': 'roberta_ner_roberta_base_bne_capitel_ner',
                                        'es.ner.roberta_base_bne_capitel_ner_plus': 'roberta_ner_roberta_base_bne_capitel_ner_plus',
                                        'es.ner.roberta_large_bne_capitel_ner': 'roberta_ner_roberta_large_bne_capitel_ner',
                                        'es.ner.wikiner': 'wikiner_6B_100',
                                        'es.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                        'es.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'es.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                        'es.pos': 'pos_ancora',
                                        'es.pos.RuPERTa_base_finetuned_pos': 'roberta_pos_RuPERTa_base_finetuned_pos',
                                        'es.pos.ancora': 'pos_ancora',
                                        'es.pos.gsd': 'pos_gsd',
                                        'es.pos.roberta_base_bne_capitel_pos': 'roberta_pos_roberta_base_bne_capitel_pos',
                                        'es.pos.roberta_large_bne_capitel_pos': 'roberta_pos_roberta_large_bne_capitel_pos',
                                        'es.pos.ud_gsd': 'pos_ud_gsd',
                                        'es.stopwords': 'stopwords_iso',
                                        'es.stopwords_es': 'stopwords_es'},
                                    'et': {'et.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'et.lemma': 'lemma_ewt',
                                           'et.lemma.edt': 'lemma_edt',
                                           'et.lemma.ewt': 'lemma_ewt',
                                           'et.pos': 'pos_edt',
                                           'et.pos.ewt': 'pos_ewt',
                                           'et.stopwords': 'stopwords_iso'},
                                    'eu': {'eu.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'eu.lemma': 'lemma_bdt',
                                           'eu.lemma.bdt': 'lemma_bdt',
                                           'eu.pos': 'pos_ud_bdt',
                                           'eu.pos.bdt': 'pos_bdt',
                                           'eu.stopwords': 'stopwords_iso',
                                           'eu.stopwords.iso': 'stopwords_iso'},
                                    'fa': {'fa.answer_question.bert.base': 'bert_qa_bert_base_fa_qa',
                                           'fa.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_fa_qa',
                                           'fa.answer_question.xlmr_roberta.large': 'xlmroberta_qa_xlmr_large',
                                           'fa.classify.token_bert.parsbert_armanner': 'bert_token_classifier_parsbert_armanner',
                                           'fa.classify.token_bert.parsbert_ner': 'bert_token_classifier_parsbert_ner',
                                           'fa.classify.token_bert.parsbert_peymaner': 'bert_token_classifier_parsbert_peymaner',
                                           'fa.classify.token_roberta_token_classifier_zwnj_base_ner': 'roberta_token_classifier_zwnj_base_ner',
                                           'fa.embed': 'persian_w2v_cc_300d',
                                           'fa.embed.albert': 'albert_embeddings_albert_fa_base_v2',
                                           'fa.embed.albert_fa_zwnj_base_v2': 'albert_embeddings_albert_fa_zwnj_base_v2',
                                           'fa.embed.distilbert_fa_zwnj_base': 'distilbert_embeddings_distilbert_fa_zwnj_base',
                                           'fa.embed.roberta_fa_zwnj_base': 'roberta_embeddings_roberta_fa_zwnj_base',
                                           'fa.embed.word2vec': 'persian_w2v_cc_300d',
                                           'fa.embed.word2vec.300d': 'persian_w2v_cc_300d',
                                           'fa.lemma': 'lemma',
                                           'fa.lemma.perdt': 'lemma_perdt',
                                           'fa.lemma.seraji': 'lemma_seraji',
                                           'fa.ner': 'personer_cc_300d',
                                           'fa.ner.person': 'personer_cc_300d',
                                           'fa.ner.person.cc_300d': 'personer_cc_300d',
                                           'fa.ner.roberta_fa_zwnj_base_ner': 'roberta_ner_roberta_fa_zwnj_base_ner',
                                           'fa.pos': 'pos_perdt',
                                           'fa.pos.perdt': 'pos_perdt',
                                           'fa.pos.seraji': 'pos_seraji',
                                           'fa.stopwords': 'stopwords_iso',
                                           'fa.stopwords.iso': 'stopwords_iso'},
                                    'fi': {'fi.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_FI_XLM_R',
                                           'fi.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'fi.embed_sentence.bert': 'bert_base_finnish_uncased',
                                           'fi.embed_sentence.bert.cased': 'bert_base_finnish_cased',
                                           'fi.embed_sentence.bert.uncased': 'bert_base_finnish_uncased',
                                           'fi.lemma': 'lemma_tdt',
                                           'fi.lemma.ftb': 'lemma_ftb',
                                           'fi.lemma.tdt': 'lemma_tdt',
                                           'fi.ner': 'wikiner_6B_100',
                                           'fi.ner.6B_100d': 'finnish_ner_6B_100',
                                           'fi.ner.6B_300d': 'finnish_ner_6B_300',
                                           'fi.ner.840B_300d': 'finnish_ner_840B_300',
                                           'fi.pos': 'pos_tdt',
                                           'fi.pos.ftb': 'pos_ftb',
                                           'fi.pos.tdt': 'pos_tdt',
                                           'fi.pos.ud_tdt': 'pos_ud_tdt',
                                           'fi.stopwords': 'stopwords_iso',
                                           'fi.stopwords.iso': 'stopwords_iso'},
                                    'fo': {'fo.lemma': 'lemma_farpahc',
                                           'fo.lemma.farpahc': 'lemma_farpahc',
                                           'fo.pos': 'pos_farpahc'},
                                    'fr': {
                                        'fr.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_fr_fr_saattrupdan',
                                        'fr.classify.allocine': 'mdeberta_v3_base_sequence_classifier_allocine',
                                        'fr.classify.distilbert_sequence.allocine': 'distilbert_multilingual_sequence_classifier_allocine',
                                        'fr.classify.sentiment.bert': 'classifierdl_bert_sentiment',
                                        'fr.classify.xlm_roberta.allocine': 'xlm_roberta_base_sequence_classifier_allocine',
                                        'fr.embed.albert': 'albert_embeddings_fralbert_base',
                                        'fr.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                        'fr.embed.bert_base_fr_cased': 'bert_embeddings_bert_base_fr_cased',
                                        'fr.embed.camembert_base': 'camembert_base',
                                        'fr.embed.camembert_base_ccnet': 'camembert_base_ccnet',
                                        'fr.embed.camembert_ccnet4g': 'camembert_base_ccnet_4gb',
                                        'fr.embed.camembert_large': 'camembert_large',
                                        'fr.embed.camembert_oscar_4g': 'camembert_base_oscar_4gb',
                                        'fr.embed.camembert_wiki_4g': 'camembert_base_wikipedia_4gb',
                                        'fr.embed.distilbert': 'distilbert_embeddings_distilbert_base_fr_cased',
                                        'fr.embed.french_roberta': 'roberta_embeddings_french_roberta',
                                        'fr.embed.roberta_base_wechsel_french': 'roberta_embeddings_roberta_base_wechsel_french',
                                        'fr.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'fr.embed.word2vec_wac_200': 'word2vec_wac_200',
                                        'fr.embed.word2vec_wiki_1000': 'word2vec_wiki_1000',
                                        'fr.lemma': 'lemma_ftb',
                                        'fr.lemma.ftb': 'lemma_ftb',
                                        'fr.lemma.gsd': 'lemma_gsd',
                                        'fr.lemma.parisstories': 'lemma_parisstories',
                                        'fr.lemma.partut': 'lemma_partut',
                                        'fr.lemma.rhapsodie': 'lemma_rhapsodie',
                                        'fr.lemma.sequoia': 'lemma_sequoia',
                                        'fr.lemma.spacylookup': 'lemma_spacylookup',
                                        'fr.ner': 'wikiner_840B_300',
                                        'fr.ner.wikiner': 'wikiner_840B_300',
                                        'fr.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'fr.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                        'fr.pos': 'pos_sequoia',
                                        'fr.pos.gsd': 'pos_gsd',
                                        'fr.pos.parisstories': 'pos_parisstories',
                                        'fr.pos.partut': 'pos_partut',
                                        'fr.pos.rhapsodie': 'pos_rhapsodie',
                                        'fr.pos.sequoia': 'pos_sequoia',
                                        'fr.pos.ud_gsd': 'pos_ud_gsd',
                                        'fr.stopwords': 'stopwords_iso',
                                        'fr.stopwords.iso': 'stopwords_iso'},
                                    'fro': {'fro.lemma': 'lemma_srcmf',
                                            'fro.lemma.srcmf': 'lemma_srcmf',
                                            'fro.pos.srcmf': 'pos_srcmf'},
                                    'frr': {'frr.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'fy': {'fy.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ga': {'ga.lemma': 'lemma',
                                           'ga.lemma.idt': 'lemma_idt',
                                           'ga.pos': 'pos_idt',
                                           'ga.pos.idt': 'pos_idt',
                                           'ga.stopwords': 'stopwords_iso',
                                           'ga.stopwords.iso': 'stopwords_iso'},
                                    'gd': {'gd.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'gd.lemma': 'lemma_arcosg',
                                           'gd.pos.arcosg': 'pos_arcosg'},
                                    'gl': {'gl.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'gl.lemma': 'lemma_treegal',
                                           'gl.lemma.ctg': 'lemma_ctg',
                                           'gl.lemma.treegal': 'lemma_treegal',
                                           'gl.pos': 'pos_ud_treegal',
                                           'gl.pos.ctg': 'pos_ctg',
                                           'gl.pos.treegal': 'pos_treegal',
                                           'gl.stopwords': 'stopwords_gl'},
                                    'gom': {'gom.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'got': {'got.lemma': 'lemma_proiel',
                                            'got.lemma.proiel': 'lemma_proiel',
                                            'got.pos.proiel': 'pos_proiel'},
                                    'grc': {'grc.lemma': 'lemma_proiel',
                                            'grc.lemma.perseus': 'lemma_perseus',
                                            'grc.lemma.proiel': 'lemma_proiel',
                                            'grc.lemma.spacylookup': 'lemma_spacylookup',
                                            'grc.pos': 'pos_proiel',
                                            'grc.pos.perseus': 'pos_perseus',
                                            'grc.stopwords': 'stopwords_iso'},
                                    'gu': {'gu.detect_sentence': 'sentence_detector_dl',
                                           'gu.embed.RoBERTa_hindi_guj_san': 'roberta_embeddings_RoBERTa_hindi_guj_san',
                                           'gu.stopwords': 'stopwords_iso'},
                                    'gv': {'gv.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ha': {'ha.embed.xlm_roberta': 'xlm_roberta_base_finetuned_hausa',
                                           'ha.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_hausa',
                                           'ha.stopwords': 'stopwords_ha'},
                                    'he': {'he.answer_question.squad.bert': 'bert_qa_hebert_finetuned_hebrew_squad',
                                           'he.embed': 'hebrew_cc_300d',
                                           'he.embed.cbow_300d': 'hebrew_cc_300d',
                                           'he.embed.glove': 'hebrew_cc_300d',
                                           'he.lemma': 'lemma',
                                           'he.lemma.htb': 'lemma_htb',
                                           'he.ner': 'hebrewner_cc_300d',
                                           'he.ner.cc_300d': 'hebrewner_cc_300d',
                                           'he.pos': 'pos_ud_htb',
                                           'he.pos.htb': 'pos_htb',
                                           'he.pos.ud_htb': 'pos_ud_htb',
                                           'he.stopwords': 'stopwords_iso',
                                           'he.stopwords.iso': 'stopwords_iso'},
                                    'hi': {
                                        'hi.answer_question.xlm_roberta': 'xlm_roberta_qa_autonlp_hindi_question_answering_23865268',
                                        'hi.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_hindi',
                                        'hi.embed': 'hindi_cc_300d',
                                        'hi.embed.RoBERTa_hindi_guj_san': 'roberta_embeddings_RoBERTa_hindi_guj_san',
                                        'hi.embed.bert_hi_cased': 'bert_embeddings_bert_base_hi_cased',
                                        'hi.embed.distilbert_base_hi_cased': 'distilbert_embeddings_distilbert_base_hi_cased',
                                        'hi.embed.indic_transformers_hi_bert': 'bert_embeddings_indic_transformers_hi_bert',
                                        'hi.embed.indic_transformers_hi_distilbert': 'distilbert_embeddings_indic_transformers_hi_distilbert',
                                        'hi.embed.indic_transformers_hi_roberta': 'roberta_embeddings_indic_transformers_hi_roberta',
                                        'hi.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                        'hi.lemma': 'lemma',
                                        'hi.lemma.hdtb': 'lemma_hdtb',
                                        'hi.ner': 'bert_hi_en_ner',
                                        'hi.ner.bert': 'bert_token_classifier_hi_en_ner',
                                        'hi.pos': 'pos_ud_hdtb',
                                        'hi.pos.hdtb': 'pos_hdtb',
                                        'hi.stopwords': 'stopwords_iso',
                                        'hi.stopwords.iso': 'stopwords_iso'},
                                    'hif': {'hif.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'hr': {'hr.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'hr.lemma': 'lemma_spacylookup',
                                           'hr.lemma.set': 'lemma_set',
                                           'hr.lemma.spacylookup': 'lemma_spacylookup',
                                           'hr.pos.set': 'pos_set',
                                           'hr.stopwords': 'stopwords_iso'},
                                    'hsb': {'hsb.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'hu': {
                                        'hu.answer_question.squad.bert': 'bert_qa_huBert_fine_tuned_hungarian_squadv1',
                                        'hu.lemma': 'lemma_spacylookup',
                                        'hu.lemma.spacylookup': 'lemma_spacylookup',
                                        'hu.lemma.szeged': 'lemma_szeged',
                                        'hu.pos': 'pos_ud_szeged',
                                        'hu.pos.szeged': 'pos_szeged',
                                        'hu.pos.ud_szeged': 'pos_ud_szeged',
                                        'hu.stopwords': 'stopwords_iso',
                                        'hu.stopwords.iso': 'stopwords_iso'},
                                    'hy': {'hy.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'hy.lemma': 'lemma_armtdp',
                                           'hy.lemma.armtdp': 'lemma_armtdp',
                                           'hy.pos': 'pos_ud_armtdp',
                                           'hy.pos.armtdp': 'pos_armtdp',
                                           'hy.stopwords': 'stopwords_iso',
                                           'hy.stopwords.iso': 'stopwords_iso'},
                                    'hyw': {'hyw.lemma': 'lemma_armtdp', 'hyw.pos': 'pos_armtdp'},
                                    'id': {'id.answer_question.indo_bert': 'bert_qa_Indobert_QA',
                                           'id.detect_sentence': 'sentence_detector_dl',
                                           'id.embed.distilbert': 'distilbert_embeddings_distilbert_base_indonesian',
                                           'id.embed.indo_roberta_small': 'roberta_embeddings_indo_roberta_small',
                                           'id.embed.indonesian_roberta_base': 'roberta_embeddings_indonesian_roberta_base',
                                           'id.embed.indonesian_roberta_large': 'roberta_embeddings_indonesian_roberta_large',
                                           'id.embed.roberta_base_indonesian_522M': 'roberta_embeddings_roberta_base_indonesian_522M',
                                           'id.lemma': 'lemma_gsd',
                                           'id.lemma.csui': 'lemma_csui',
                                           'id.lemma.gsd': 'lemma_gsd',
                                           'id.lemma.spacylookup': 'lemma_spacylookup',
                                           'id.ner': 'xlm_roberta_large_token_classification_ner',
                                           'id.pos': 'pos_csui',
                                           'id.pos.csui': 'pos_csui',
                                           'id.pos.gsd': 'pos_gsd',
                                           'id.pos.indonesian_roberta_base_posp_tagger': 'roberta_pos_indonesian_roberta_base_posp_tagger',
                                           'id.stopwords': 'stopwords_iso',
                                           'id.stopwords.iso': 'stopwords_iso'},
                                    'ig': {'ig.embed.xlm_roberta': 'xlm_roberta_base_finetuned_igbo',
                                           'ig.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_igbo'},
                                    'is': {
                                        'is.answer_question.squad.roberta': 'roberta_qa_icebert_texas_squad_is_saattrupdan',
                                        'is.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_is_is_saattrupdan',
                                        'is.answer_question.xlmr_roberta': 'xlm_roberta_qa_XLMr_ENIS_QA_Is',
                                        'is.lemma': 'lemma_icepahc',
                                        'is.lemma.modern': 'lemma_modern',
                                        'is.ner': 'roberta_token_classifier_icelandic_ner',
                                        'is.pos.modern': 'pos_modern',
                                        'is.stopwords': 'stopwords_iso'},
                                    'it': {
                                        'it.answer_question.squad.bert': 'bert_qa_bert_italian_finedtuned_squadv1_it_alfa',
                                        'it.answer_question.squad.bert.base_uncased': 'bert_qa_bert_base_italian_uncased_squad_it_antoniocappiello',
                                        'it.answer_question.squad.bert.xxl_cased': 'bert_qa_squad_xxl_cased_hub1',
                                        'it.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_IT_XLM_R',
                                        'it.classify.sentiment': 'bert_sequence_classifier_sentiment',
                                        'it.embed.BERTino': 'distilbert_embeddings_BERTino',
                                        'it.embed.bert': 'bert_base_italian_cased',
                                        'it.embed.bert.uncased': 'bert_base_italian_uncased',
                                        'it.embed.bert_base_italian_xxl_cased': 'bert_embeddings_bert_base_italian_xxl_cased',
                                        'it.embed.bert_base_italian_xxl_uncased': 'bert_embeddings_bert_base_italian_xxl_uncased',
                                        'it.embed.bert_it_cased': 'bert_embeddings_bert_base_it_cased',
                                        'it.embed.chefberto_italian_cased': 'bert_embeddings_chefberto_italian_cased',
                                        'it.embed.distilbert_base_it_cased': 'distilbert_embeddings_distilbert_base_it_cased',
                                        'it.embed.hseBert_it_cased': 'bert_embeddings_hseBert_it_cased',
                                        'it.embed.wineberto_italian_cased': 'bert_embeddings_wineberto_italian_cased',
                                        'it.embed.word2vec': 'w2v_cc_300d',
                                        'it.lemma': 'lemma_twittiro',
                                        'it.lemma.dxc': 'lemma_dxc',
                                        'it.lemma.isdt': 'lemma_isdt',
                                        'it.lemma.partut': 'lemma_partut',
                                        'it.lemma.postwita': 'lemma_postwita',
                                        'it.lemma.spacylookup': 'lemma_spacylookup',
                                        'it.lemma.twittiro': 'lemma_twittiro',
                                        'it.lemma.vit': 'lemma_vit',
                                        'it.ner': 'wikiner_840B_300',
                                        'it.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'it.pos': 'pos_partut',
                                        'it.pos.isdt': 'pos_isdt',
                                        'it.pos.partut': 'pos_partut',
                                        'it.pos.postwita': 'pos_postwita',
                                        'it.pos.twittiro': 'pos_twittiro',
                                        'it.pos.ud_isdt': 'pos_ud_isdt',
                                        'it.pos.vit': 'pos_vit',
                                        'it.stopwords': 'stopwords_iso',
                                        'it.stopwords.iso': 'stopwords_iso'},
                                    'ja': {
                                        'ja.answer_question.wikipedia.bert.base': 'bert_qa_base_japanese_wikipedia_ud_head',
                                        'ja.answer_question.wikipedia.bert.large': 'bert_qa_large_japanese_wikipedia_ud_head',
                                        'ja.classify.token_bert.classifier_ner_ud_gsd': 'bert_token_classifier_ner_ud_gsd',
                                        'ja.embed.albert_base_japanese_v1': 'albert_embeddings_albert_base_japanese_v1',
                                        'ja.embed.bert_base_ja_cased': 'bert_embeddings_bert_base_ja_cased',
                                        'ja.embed.bert_base_japanese_basic_char_v2': 'bert_embeddings_bert_base_japanese_basic_char_v2',
                                        'ja.embed.bert_base_japanese_char': 'bert_embeddings_bert_base_japanese_char',
                                        'ja.embed.bert_base_japanese_char_extended': 'bert_embeddings_bert_base_japanese_char_extended',
                                        'ja.embed.bert_base_japanese_char_v2': 'bert_embeddings_bert_base_japanese_char_v2',
                                        'ja.embed.bert_base_japanese_char_whole_word_masking': 'bert_embeddings_bert_base_japanese_char_whole_word_masking',
                                        'ja.embed.bert_base_japanese_v2': 'bert_embeddings_bert_base_japanese_v2',
                                        'ja.embed.bert_base_japanese_whole_word_masking': 'bert_embeddings_bert_base_japanese_whole_word_masking',
                                        'ja.embed.bert_large_japanese': 'bert_embeddings_bert_large_japanese',
                                        'ja.embed.bert_large_japanese_char': 'bert_embeddings_bert_large_japanese_char',
                                        'ja.embed.bert_large_japanese_char_extended': 'bert_embeddings_bert_large_japanese_char_extended',
                                        'ja.embed.bert_small_japanese': 'bert_embeddings_bert_small_japanese',
                                        'ja.embed.bert_small_japanese_fin': 'bert_embeddings_bert_small_japanese_fin',
                                        'ja.embed.distilbert_base_ja_cased': 'distilbert_embeddings_distilbert_base_ja_cased',
                                        'ja.embed.glove.cc_300d': 'japanese_cc_300d',
                                        'ja.lemma': 'lemma',
                                        'ja.lemma.gsd': 'lemma_gsd',
                                        'ja.lemma.gsdluw': 'lemma_gsdluw',
                                        'ja.ner': 'ner_ud_gsd_glove_840B_300d',
                                        'ja.ner.ud_gsd': 'ner_ud_gsd_glove_840B_300d',
                                        'ja.ner.ud_gsd.glove_840B_300D': 'ner_ud_gsd_glove_840B_300d',
                                        'ja.ner.ud_gsd_cc_300d': 'ner_ud_gsd_cc_300d',
                                        'ja.ner.ud_gsd_xlm_roberta_base': 'ner_ud_gsd_xlm_roberta_base',
                                        'ja.pos': 'pos_gsd',
                                        'ja.pos.gsd': 'pos_gsd',
                                        'ja.pos.gsdluw': 'pos_gsdluw',
                                        'ja.pos.ud_gsd': 'pos_ud_gsd',
                                        'ja.segment_words': 'wordseg_gsd_ud',
                                        'ja.stopwords': 'stopwords_iso',
                                        'ja.stopwords.iso': 'stopwords_iso'},
                                    'jv': {'jv.embed.distilbert': 'distilbert_embeddings_javanese_distilbert_small',
                                           'jv.embed.javanese_bert_small': 'bert_embeddings_javanese_bert_small',
                                           'jv.embed.javanese_bert_small_imdb': 'bert_embeddings_javanese_bert_small_imdb',
                                           'jv.embed.javanese_distilbert_small_imdb': 'distilbert_embeddings_javanese_distilbert_small_imdb',
                                           'jv.embed.javanese_roberta_small': 'roberta_embeddings_javanese_roberta_small',
                                           'jv.embed.javanese_roberta_small_imdb': 'roberta_embeddings_javanese_roberta_small_imdb'},
                                    'ka': {'ka.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'kn': {'kn.embed.KNUBert': 'roberta_embeddings_KNUBert',
                                           'kn.embed.KanBERTo': 'roberta_embeddings_KanBERTo',
                                           'kn.stopwords': 'stopwords_iso',
                                           'ml.detect_sentence': 'sentence_detector_dl'},
                                    'ko': {'ko.answer_question.electra': 'electra_qa_long',
                                           'ko.answer_question.klue.bert.base': 'bert_qa_ainize_klue_bert_base_mrc',
                                           'ko.answer_question.klue.bert.base.by_ainize': 'bert_qa_ainize_klue_bert_base_mrc',
                                           'ko.answer_question.klue.bert.base.by_bespin-global': 'bert_qa_bespin_global_klue_bert_base_mrc',
                                           'ko.answer_question.klue.bert.base_aihub.by_bespin-global': 'bert_qa_klue_bert_base_aihub_mrc',
                                           'ko.answer_question.klue.electra.base': 'electra_qa_klue_mrc_base',
                                           'ko.answer_question.klue.electra.base.by_obokkkk': 'electra_qa_base_v3_discriminator_finetuned_klue_v4',
                                           'ko.answer_question.klue.electra.base.by_seongju': 'electra_qa_klue_mrc_base',
                                           'ko.answer_question.korquad.electra.base': 'electra_qa_base_v3_finetuned_korquad',
                                           'ko.answer_question.korquad.electra.base_v2.by_monologg': 'electra_qa_base_v2_finetuned_korquad',
                                           'ko.answer_question.korquad.electra.base_v2_384.by_monologg': 'electra_qa_base_v2_finetuned_korquad_384',
                                           'ko.answer_question.korquad.electra.small': 'electra_qa_small_v3_finetuned_korquad',
                                           'ko.embed.KR_FinBert': 'bert_embeddings_KR_FinBert',
                                           'ko.embed.bert': 'bert_embeddings_bert_base',
                                           'ko.embed.bert_base_v1_sports': 'bert_embeddings_bert_base_v1_sports',
                                           'ko.embed.bert_kor_base': 'bert_embeddings_bert_kor_base',
                                           'ko.embed.dbert': 'bert_embeddings_dbert',
                                           'ko.embed.roberta_ko_small': 'roberta_embeddings_roberta_ko_small',
                                           'ko.lemma': 'lemma_gsd',
                                           'ko.lemma.gsd': 'lemma_gsd',
                                           'ko.lemma.kaist': 'lemma_kaist',
                                           'ko.ner': 'ner_kmou_glove_840B_300d',
                                           'ko.ner.kmou': 'ner_kmou_glove_840B_300d',
                                           'ko.ner.kmou.glove_840B_300d': 'ner_kmou_glove_840B_300d',
                                           'ko.pos': 'pos_gsd',
                                           'ko.pos.gsd': 'pos_gsd',
                                           'ko.pos.kaist': 'pos_kaist',
                                           'ko.pos.ud_kaist': 'pos_ud_kaist',
                                           'ko.segment_words': 'wordseg_kaist_ud',
                                           'ko.stopwords': 'stopwords_iso'},
                                    'ky': {'ky.stopwords': 'stopwords_iso'},
                                    'la': {'la.lemma': 'lemma_proiel',
                                           'la.lemma.ittb': 'lemma_ittb',
                                           'la.lemma.llct': 'lemma_llct',
                                           'la.lemma.perseus': 'lemma_perseus',
                                           'la.lemma.proiel': 'lemma_proiel',
                                           'la.lemma.udante': 'lemma_udante',
                                           'la.pos': 'pos_perseus',
                                           'la.pos.ittb': 'pos_ittb',
                                           'la.pos.llct': 'pos_llct',
                                           'la.pos.perseus': 'pos_perseus',
                                           'la.pos.proiel': 'pos_proiel',
                                           'la.pos.udante': 'pos_udante',
                                           'la.stopwords': 'stopwords_la'},
                                    'lb': {'lb.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'lb.lemma': 'lemma_spacylookup',
                                           'lb.stopwords': 'stopwords_iso'},
                                    'lg': {'lg.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luganda',
                                           'lg.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_luganda'},
                                    'lij': {'lij.stopwords': 'stopwords_iso'},
                                    'lmo': {'lmo.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'lou': {'lou.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luo'},
                                    'lt': {'lt.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'lt.lemma': 'lemma_spacylookup',
                                           'lt.lemma.spacylookup': 'lemma_spacylookup',
                                           'lt.pos.alksnis': 'pos_alksnis',
                                           'lt.stopwords': 'stopwords_iso'},
                                    'lv': {'lv.lemma': 'lemma',
                                           'lv.lemma.lvtb': 'lemma_lvtb',
                                           'lv.pos': 'pos_lvtb',
                                           'lv.pos.lvtb': 'pos_lvtb',
                                           'lv.stopwords': 'stopwords_iso',
                                           'lv.stopwords.iso': 'stopwords_iso'},
                                    'lzh': {'lzh.lemma': 'lemma_kyoto',
                                            'lzh.lemma.kyoto': 'lemma_kyoto',
                                            'lzh.pos.kyoto': 'pos_kyoto'},
                                    'mai': {'mai.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'mg': {'mg.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'min': {'min.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'mk': {'mk.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'mk.lemma': 'lemma_spacylookup',
                                           'mk.stopwords': 'stopwords_iso'},
                                    'ml': {'ml.detect_sentence': 'sentence_detector_dl',
                                           'ml.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'ml.stopwords': 'stopwords_iso'},
                                    'mn': {'mn.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'mr': {'mr.detect_sentence': 'sentence_detector_dl',
                                           'mr.embed.albert': 'albert_embeddings_marathi_albert',
                                           'mr.embed.albert_v2': 'albert_embeddings_marathi_albert_v2',
                                           'mr.embed.distilbert': 'distilbert_embeddings_marathi_distilbert',
                                           'mr.embed.marathi_bert': 'bert_embeddings_marathi_bert',
                                           'mr.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                           'mr.lemma': 'lemma_ufal',
                                           'mr.lemma.ufal': 'lemma_ufal',
                                           'mr.pos': 'pos_ufal',
                                           'mr.pos.ufal': 'pos_ufal',
                                           'mr.stopwords': 'stopwords_iso',
                                           'mr.stopwords.iso': 'stopwords_iso'},
                                    'ms': {'ms.embed.albert': 'albert_embeddings_albert_large_bahasa_cased',
                                           'ms.embed.albert_base_bahasa_cased': 'albert_embeddings_albert_base_bahasa_cased',
                                           'ms.embed.albert_tiny_bahasa_cased': 'albert_embeddings_albert_tiny_bahasa_cased',
                                           'ms.embed.distilbert': 'distilbert_embeddings_malaysian_distilbert_small',
                                           'ms.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'mt': {'mt.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'mt.lemma': 'lemma_mudt',
                                           'mt.lemma.mudt': 'lemma_mudt',
                                           'mt.pos': 'pos_mudt'},
                                    'mwl': {'mwl.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'my': {'my.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'myv': {'myv.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'mzn': {'mzn.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'nah': {'nah.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'nap': {'nap.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'nb': {'nb.lemma': 'lemma_spacylookup',
                                           'nb.lemma.spacylookup': 'lemma_spacylookup',
                                           'nb.stopwords': 'stopwords_iso'},
                                    'nds': {'nds.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ne': {'ne.detect_sentence': 'sentence_detector_dl',
                                           'ne.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'ne.stopwords': 'stopwords_iso'},
                                    'new': {'new.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'nl': {
                                        'nl.answer_question.squadv2.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_dutch_squad2',
                                        'nl.embed.bert': 'bert_base_dutch_cased',
                                        'nl.embed.bert.base_cased': 'bert_base_cased',
                                        'nl.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_nl_cased',
                                        'nl.embed.robbert_v2_dutch_base': 'roberta_embeddings_robbert_v2_dutch_base',
                                        'nl.embed.robbertje_1_gb_bort': 'roberta_embeddings_robbertje_1_gb_bort',
                                        'nl.embed.robbertje_1_gb_merged': 'roberta_embeddings_robbertje_1_gb_merged',
                                        'nl.embed.robbertje_1_gb_non_shuffled': 'roberta_embeddings_robbertje_1_gb_non_shuffled',
                                        'nl.embed.robbertje_1_gb_shuffled': 'roberta_embeddings_robbertje_1_gb_shuffled',
                                        'nl.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'nl.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                        'nl.lemma': 'lemma_spacylookup',
                                        'nl.lemma.lassysmall': 'lemma_lassysmall',
                                        'nl.lemma.spacylookup': 'lemma_spacylookup',
                                        'nl.lemma_alpino': 'lemma_alpino',
                                        'nl.ner': 'wikiner_6B_100',
                                        'nl.ner.bert': 'bert_token_classifier_dutch_udlassy_ner',
                                        'nl.ner.wikiner': 'wikiner_6B_300',
                                        'nl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'nl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                        'nl.pos': 'pos_ud_alpino',
                                        'nl.pos.alpino': 'pos_alpino',
                                        'nl.pos.fullstop_dutch_punctuation_prediction': 'roberta_pos_fullstop_dutch_punctuation_prediction',
                                        'nl.pos.lassysmall': 'pos_lassysmall',
                                        'nl.pos.ud_alpino': 'pos_ud_alpino',
                                        'nl.stopwords': 'stopwords_iso'},
                                    'nn': {'nn.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'nn.pos': 'pos_ud_nynorsk',
                                           'nn.pos.ud_nynorsk': 'pos_ud_nynorsk'},
                                    'no': {'no.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'no.lemma': 'lemma_nynorsk',
                                           'no.lemma.nynorsk': 'lemma_nynorsk',
                                           'no.lemma.nynorsklia': 'lemma_nynorsklia',
                                           'no.ner.norne': 'norne_6B_100',
                                           'no.ner.norne.100d': 'norne_6B_100',
                                           'no.ner.norne.glove.6B_300': 'norne_6B_300',
                                           'no.ner.norne.glove.840B_300': 'norne_840B_300',
                                           'no.pos': 'pos_bokmaal',
                                           'no.pos.bokmaal': 'pos_bokmaal',
                                           'no.pos.nynorsk': 'pos_nynorsk'},
                                    'nso': {'nso.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'oc': {'oc.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'or': {'or.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'orv': {'orv.lemma': 'lemma_torot',
                                            'orv.lemma.rnc': 'lemma_rnc',
                                            'orv.lemma.torot': 'lemma_torot',
                                            'orv.pos.rnc': 'pos_rnc',
                                            'orv.pos.torot': 'pos_torot'},
                                    'os': {'os.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'pa': {'pa.detect_sentence': 'sentence_detector_dl',
                                           'pa.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                           'pa.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'pcm': {'pcm.embed.xlm_roberta': 'xlm_roberta_base_finetuned_naija',
                                            'pcm.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_naija',
                                            'pcm.lemma.nsc': 'lemma_nsc',
                                            'pcm.pos.nsc': 'pos_nsc'},
                                    'pfl': {'pfl.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'pl': {
                                        'pl.answer_question.squad.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad1',
                                        'pl.answer_question.squadv2.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad2',
                                        'pl.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_pl_cased',
                                        'pl.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'pl.lemma': 'lemma_lfg',
                                        'pl.lemma.lfg': 'lemma_lfg',
                                        'pl.lemma.pdb': 'lemma_pdb',
                                        'pl.ner': 'wikiner_6B_100',
                                        'pl.ner.wikiner': 'wikiner_6B_100',
                                        'pl.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                        'pl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'pl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                        'pl.pos': 'pos_ud_lfg',
                                        'pl.pos.pdb': 'pos_pdb',
                                        'pl.pos.ud_lfg': 'pos_ud_lfg',
                                        'pl.stopwords': 'stopwords_iso',
                                        'pl.stopwords.iso': 'stopwords_iso'},
                                    'pms': {'pms.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'pnb': {'pnb.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ps': {'ps.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'pt': {
                                        'pt.answer_question.squad.bert.base_cased': 'bert_qa_bert_base_portuguese_cased_finetuned_squad_v1_pt_mrm8488',
                                        'pt.answer_question.squad.bert.base_cased.by_mrm8488': 'bert_qa_bert_base_portuguese_cased_finetuned_squad_v1_pt_mrm8488',
                                        'pt.answer_question.squad.bert.base_cased.by_pierreguillou': 'bert_qa_bert_base_cased_squad_v1.1_portuguese',
                                        'pt.answer_question.squad.bert.large_cased': 'bert_qa_bert_large_cased_squad_v1.1_portuguese',
                                        'pt.answer_question.squad.biobert': 'bert_qa_bioBERTpt_squad_v1.1_portuguese',
                                        'pt.answer_question.squad.distil_bert': 'distilbert_qa_multi_finedtuned_squad',
                                        'pt.bert': 'bert_portuguese_base_cased',
                                        'pt.bert.cased': 'bert_portuguese_base_cased',
                                        'pt.bert.cased.large': 'bert_portuguese_large_cased',
                                        'pt.embed.BR_BERTo': 'roberta_embeddings_BR_BERTo',
                                        'pt.embed.bert_base_cased_pt_lenerbr': 'bert_embeddings_bert_base_cased_pt_lenerbr',
                                        'pt.embed.bert_base_gl_cased': 'bert_embeddings_bert_base_gl_cased',
                                        'pt.embed.bert_base_portuguese_cased': 'bert_embeddings_bert_base_portuguese_cased',
                                        'pt.embed.bert_base_portuguese_cased_finetuned_peticoes': 'bert_embeddings_bert_base_portuguese_cased_finetuned_peticoes',
                                        'pt.embed.bert_base_portuguese_cased_finetuned_tcu_acordaos': 'bert_embeddings_bert_base_portuguese_cased_finetuned_tcu_acordaos',
                                        'pt.embed.bert_base_pt_cased': 'bert_embeddings_bert_base_pt_cased',
                                        'pt.embed.bert_large_cased_pt_lenerbr': 'bert_embeddings_bert_large_cased_pt_lenerbr',
                                        'pt.embed.bert_large_portuguese_cased': 'bert_embeddings_bert_large_portuguese_cased',
                                        'pt.embed.bert_small_gl_cased': 'bert_embeddings_bert_small_gl_cased',
                                        'pt.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_pt_cased',
                                        'pt.embed.gs_all': 'biobert_embeddings_all',
                                        'pt.embed.gs_biomedical': 'biobert_embeddings_biomedical',
                                        'pt.embed.gs_clinical': 'biobert_embeddings_clinical',
                                        'pt.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'pt.lemma': 'lemma_bosque',
                                        'pt.lemma.bosque': 'lemma_bosque',
                                        'pt.lemma.gsd': 'lemma_gsd',
                                        'pt.lemma.spacylookup': 'lemma_spacylookup',
                                        'pt.ner': 'wikiner_6B_100',
                                        'pt.ner.satellite_instrument_roberta_NER': 'roberta_ner_satellite_instrument_roberta_NER',
                                        'pt.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                        'pt.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                        'pt.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                        'pt.pos': 'pos_ud_bosque',
                                        'pt.pos.bosque': 'pos_bosque',
                                        'pt.pos.gsd': 'pos_gsd',
                                        'pt.pos.ud_bosque': 'pos_ud_bosque',
                                        'pt.stopwords': 'stopwords_iso',
                                        'pt.stopwords.iso': 'stopwords_iso'},
                                    'qhe': {'qhe.lemma': 'lemma_hiencs',
                                            'qhe.pos': 'pos_hiencs',
                                            'qhe.pos.hiencs': 'pos_hiencs'},
                                    'qtd': {'qtd.lemma': 'lemma_sagt',
                                            'qtd.lemma.sagt': 'lemma_sagt',
                                            'qtd.pos': 'pos_sagt'},
                                    'qu': {'qu.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'rm': {'rm.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ro': {'ro.embed.ALR_BERT': 'albert_embeddings_ALR_BERT',
                                           'ro.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ro_cased',
                                           'ro.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'ro.lemma': 'lemma_spacylookup',
                                           'ro.lemma.nonstandard': 'lemma_nonstandard',
                                           'ro.lemma.rrt': 'lemma_rrt',
                                           'ro.lemma.simonero': 'lemma_simonero',
                                           'ro.lemma.spacylookup': 'lemma_spacylookup',
                                           'ro.pos': 'pos_nonstandard',
                                           'ro.pos.nonstandard': 'pos_nonstandard',
                                           'ro.pos.rrt': 'pos_rrt',
                                           'ro.pos.simonero': 'pos_simonero',
                                           'ro.pos.ud_rrt': 'pos_ud_rrt',
                                           'ro.stopwords': 'stopwords_iso',
                                           'ro.stopwords.iso': 'stopwords_iso'},
                                    'ru': {'ru.answer_question.distil_bert': 'distilbert_qa_model_QA_5_epoch_RU',
                                           'ru.classify.toxic': 'bert_sequence_classifier_toxicity',
                                           'ru.detect_sentence': 'sentence_detector_dl',
                                           'ru.embed.bert_base_ru_cased': 'bert_embeddings_bert_base_ru_cased',
                                           'ru.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ru_cased',
                                           'ru.embed.roberta_base_russian_v0': 'roberta_embeddings_roberta_base_russian_v0',
                                           'ru.embed.ruRoberta_large': 'roberta_embeddings_ruRoberta_large',
                                           'ru.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'ru.lemma': 'lemma_gsd',
                                           'ru.lemma.gsd': 'lemma_gsd',
                                           'ru.lemma.spacylookup': 'lemma_spacylookup',
                                           'ru.lemma.syntagrus': 'lemma_syntagrus',
                                           'ru.lemma.taiga': 'lemma_taiga',
                                           'ru.ner': 'wikiner_6B_100',
                                           'ru.ner.wikiner': 'wikiner_6B_100',
                                           'ru.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                           'ru.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'ru.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'ru.pos': 'pos_syntagrus',
                                           'ru.pos.gsd': 'pos_gsd',
                                           'ru.pos.syntagrus': 'pos_syntagrus',
                                           'ru.pos.taiga': 'pos_taiga',
                                           'ru.pos.ud_gsd': 'pos_ud_gsd',
                                           'ru.stopwords': 'stopwords_iso',
                                           'ru.stopwords.iso': 'stopwords_iso'},
                                    'rw': {'rw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_kinyarwanda',
                                           'rw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_kinyarwanda'},
                                    'sa': {'sa.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'sa.lemma': 'lemma_vedic',
                                           'sa.pos': 'pos_vedic',
                                           'sa.stopwords': 'stopwords_iso'},
                                    'sah': {'sah.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'sc': {'sc.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'scn': {'scn.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'sco': {'sco.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'sd': {'sd.detect_sentence': 'sentence_detector_dl',
                                           'sd.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'sh': {'sh.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'si': {'si.answer_question.bert.base': 'bert_qa_bert_base_sinhala_qa',
                                           'si.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'si.stopwords': 'stopwords_iso'},
                                    'sk': {'sk.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'sk.lemma': 'lemma_snk',
                                           'sk.lemma.snk': 'lemma_snk',
                                           'sk.pos': 'pos_ud_snk',
                                           'sk.pos.snk': 'pos_snk',
                                           'sk.pos.ud_snk': 'pos_ud_snk',
                                           'sk.stopwords': 'stopwords_iso',
                                           'sk.stopwords.iso': 'stopwords_iso'},
                                    'sl': {'sl.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'sl.lemma': 'lemma_sst',
                                           'sl.lemma.ssj': 'lemma_ssj',
                                           'sl.lemma.sst': 'lemma_sst',
                                           'sl.pos': 'pos_sst',
                                           'sl.pos.ssj': 'pos_ssj',
                                           'sl.pos.sst': 'pos_sst',
                                           'sl.stopwords': 'stopwords_iso',
                                           'sl.stopwords.iso': 'stopwords_iso'},
                                    'sme': {'sme.lemma': 'lemma_giella', 'sme.pos': 'pos_giella'},
                                    'so': {'so.detect_sentence': 'sentence_detector_dl',
                                           'so.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'so.stopwords': 'stopwords_so'},
                                    'sq': {'sq.embed.w2v_cc_300d': 'w2v_cc_300d', 'sq.stopwords': 'stopwords_iso'},
                                    'sr': {'sr.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'sr.lemma': 'lemma_spacylookup',
                                           'sr.lemma.set': 'lemma_set',
                                           'sr.lemma.spacylookup': 'lemma_spacylookup',
                                           'sr.pos': 'pos_set',
                                           'sr.pos.set': 'pos_set',
                                           'sr.stopwords': 'stopwords_iso',
                                           'sr.stopwords.iso': 'stopwords_iso'},
                                    'st': {'st.stopwords': 'stopwords_st'},
                                    'su': {
                                        'su.embed.sundanese_roberta_base': 'roberta_embeddings_sundanese_roberta_base',
                                        'su.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'sv': {'sv.answer_question.squadv2.bert.base': 'bert_qa_bert_base_swedish_squad2',
                                           'sv.answer_question.xlmr_roberta.large': 'xlm_roberta_qa_xlmr_large_qa_sv_sv_m3hrdadfi',
                                           'sv.classify.token_bert.swedish_ner': 'bert_token_classifier_swedish_ner',
                                           'sv.embed.bert.base_cased': 'bert_base_cased',
                                           'sv.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'sv.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'sv.lemma': 'lemma_lines',
                                           'sv.lemma.lines': 'lemma_lines',
                                           'sv.lemma.spacylookup': 'lemma_spacylookup',
                                           'sv.lemma.talbanken': 'lemma_talbanken',
                                           'sv.ner': 'swedish_ner_6B_100',
                                           'sv.ner.6B_100': 'swedish_ner_6B_100',
                                           'sv.ner.6B_300': 'swedish_ner_6B_300',
                                           'sv.ner.840B_300': 'swedish_ner_840B_300',
                                           'sv.pos': 'pos_ud_tal',
                                           'sv.pos.lines': 'pos_lines',
                                           'sv.pos.talbanken': 'pos_talbanken',
                                           'sv.pos.ud_tal': 'pos_ud_tal',
                                           'sv.stopwords': 'stopwords_iso',
                                           'sv.stopwords.iso': 'stopwords_iso'},
                                    'sw': {
                                        'sw.answer_question.tydiqa.xlm_roberta.base': 'xlm_roberta_qa_afriberta_base_finetuned_tydiqa',
                                        'sw.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'sw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_swahili',
                                        'sw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_swahili',
                                        'sw.stopwords': 'stopwords_sw'},
                                    'ta': {
                                        'ta.answer_question.squad.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_squad_tamil',
                                        'ta.detect_sentence': 'sentence_detector_dl',
                                        'ta.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                        'ta.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'ta.lemma': 'lemma',
                                        'ta.lemma.ttb': 'lemma_ttb',
                                        'ta.pos': 'pos_ttb',
                                        'ta.stopwords': 'stopwords_iso'},
                                    'te': {'te.detect_sentence': 'sentence_detector_dl',
                                           'te.embed.distilbert': 'distilbert_uncased',
                                           'te.embed.indic_transformers_te_bert': 'bert_embeddings_indic_transformers_te_bert',
                                           'te.embed.indic_transformers_te_roberta': 'roberta_embeddings_indic_transformers_te_roberta',
                                           'te.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                           'te.embed.telugu_bertu': 'bert_embeddings_telugu_bertu',
                                           'te.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'te.lemma': 'lemma_mtg',
                                           'te.pos': 'pos_mtg',
                                           'te.stopwords': 'stopwords_iso'},
                                    'tg': {'tg.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'th': {
                                        'th.answer_question.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetune_qa',
                                        'th.answer_question.squadv2.xlm_roberta.base': 'xlm_roberta_qa_thai_xlm_roberta_base_squad2',
                                        'th.answer_question.xquad.multi_lingual_bert.base': 'bert_qa_xquad_th_mbert_base',
                                        'th.answer_question.xquad_squad.bert.cased': 'bert_qa_thai_bert_multi_cased_finetuned_xquadv1_finetuned_squad',
                                        'th.classify.sentiment': 'sentiment_jager_use',
                                        'th.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_th_cased',
                                        'th.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'th.ner.lst20.glove_840B_300D': 'ner_lst20_glove_840B_300d',
                                        'th.pos': 'pos_lst20',
                                        'th.segment_words': 'wordseg_best',
                                        'th.sentiment': 'sentiment_jager_use',
                                        'th.stopwords': 'stopwords_iso',
                                        'th.stopwords.iso': 'stopwords_iso'},
                                    'ti': {'ti.stopwords': 'stopwords_iso'},
                                    'tk': {'tk.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'tl': {'tl.embed.roberta_tagalog_base': 'roberta_embeddings_roberta_tagalog_base',
                                           'tl.embed.roberta_tagalog_large': 'roberta_embeddings_roberta_tagalog_large',
                                           'tl.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'tl.lemma': 'lemma_spacylookup',
                                           'tl.stopwords': 'stopwords_iso'},
                                    'tn': {'tn.stopwords': 'stopwords_iso'},
                                    'tr': {'tr.answer_question.bert': 'bert_qa_bert_turkish_question_answering',
                                           'tr.answer_question.bert.base_uncased': 'bert_qa_loodos_bert_base_uncased_QA_fine_tuned',
                                           'tr.answer_question.bert.by_lserinol': 'bert_qa_bert_turkish_question_answering',
                                           'tr.answer_question.bert.by_yunusemreemik': 'bert_qa_logo_qna_model',
                                           'tr.answer_question.bert.distilled': 'bert_qa_distilbert_tr_q_a',
                                           'tr.answer_question.electra': 'electra_qa_turkish',
                                           'tr.answer_question.electra.small_uncased': 'electra_qa_small_turkish_uncased_discriminator_finetuned',
                                           'tr.answer_question.squad.bert.base': 'bert_qa_bert_base_turkish_squad',
                                           'tr.answer_question.squad.electra': 'electra_qa_enelpi_squad',
                                           'tr.answer_question.squad.electra.base': 'electra_qa_base_discriminator_finetuned_squadv1',
                                           'tr.answer_question.squadv2.electra.base_v2': 'electra_qa_base_discriminator_finetuned_squadv2',
                                           'tr.answer_question.xlm_roberta': 'xlm_roberta_qa_XLM_Turkish',
                                           'tr.classify.cyberbullying': 'classifierdl_berturk_cyberbullying',
                                           'tr.classify.news': 'classifierdl_bert_news',
                                           'tr.classify.token_bert.turkish_ner': 'bert_token_classifier_turkish_ner',
                                           'tr.embed.bert': 'bert_base_turkish_cased',
                                           'tr.embed.bert.uncased': 'bert_base_turkish_uncased',
                                           'tr.embed.bert_cased': 'bert_embeddings_bert_base_tr_cased',
                                           'tr.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_tr_cased',
                                           'tr.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'tr.lemma': 'lemma_penn',
                                           'tr.lemma.atis': 'lemma_atis',
                                           'tr.lemma.boun': 'lemma_boun',
                                           'tr.lemma.framenet': 'lemma_framenet',
                                           'tr.lemma.imst': 'lemma_imst',
                                           'tr.lemma.kenet': 'lemma_kenet',
                                           'tr.lemma.penn': 'lemma_penn',
                                           'tr.lemma.spacylookup': 'lemma_spacylookup',
                                           'tr.lemma.tourism': 'lemma_tourism',
                                           'tr.ner': 'turkish_ner_840B_300',
                                           'tr.ner.bert': 'turkish_ner_bert',
                                           'tr.ner.xlm_roberta': 'xlm_roberta_base_token_classifier_ner',
                                           'tr.pos': 'pos_boun',
                                           'tr.pos.atis': 'pos_atis',
                                           'tr.pos.boun': 'pos_boun',
                                           'tr.pos.framenet': 'pos_framenet',
                                           'tr.pos.imst': 'pos_imst',
                                           'tr.pos.kenet': 'pos_kenet',
                                           'tr.pos.penn': 'pos_penn',
                                           'tr.pos.tourism': 'pos_tourism',
                                           'tr.pos.ud_imst': 'pos_ud_imst',
                                           'tr.stopwords': 'stopwords_iso',
                                           'tr.stopwords.iso': 'stopwords_iso'},
                                    'tt': {'tt.embed.w2v_cc_300d': 'w2v_cc_300d', 'tt.stopwords': 'stopwords_iso'},
                                    'ug': {'ug.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'ug.lemma': 'lemma_udt',
                                           'ug.lemma.udt': 'lemma_udt',
                                           'ug.pos.udt': 'pos_udt'},
                                    'uk': {'uk.answer_question.xlmr_roberta': 'xlmroberta_qa_ukrainian',
                                           'uk.detect_sentence': 'sentence_detector_dl',
                                           'uk.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_uk_cased',
                                           'uk.embed.ukr_roberta_base': 'roberta_embeddings_ukr_roberta_base',
                                           'uk.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'uk.lemma': 'lemma',
                                           'uk.lemma.iu': 'lemma_iu',
                                           'uk.pos': 'pos_ud_iu',
                                           'uk.pos.bert_base_slavic_cyrillic_upos': 'bert_pos_bert_base_slavic_cyrillic_upos',
                                           'uk.pos.bert_large_slavic_cyrillic_upos': 'bert_pos_bert_large_slavic_cyrillic_upos',
                                           'uk.pos.iu': 'pos_iu',
                                           'uk.pos.ud_iu': 'pos_ud_iu',
                                           'uk.stopwords': 'stopwords_iso'},
                                    'ur': {
                                        'ur.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
                                        'ur.classify.fakenews': 'classifierdl_urduvec_fakenews',
                                        'ur.classify.news': 'classifierdl_bert_news',
                                        'ur.classify.sentiment.imdb': 'mdeberta_v3_base_sequence_classifier_imdb',
                                        'ur.embed': 'urduvec_140M_300d',
                                        'ur.embed.bert_cased': 'bert_embeddings_bert_base_ur_cased',
                                        'ur.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ur_cased',
                                        'ur.embed.glove.300d': 'urduvec_140M_300d',
                                        'ur.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
                                        'ur.embed.roberta_urdu_small': 'roberta_embeddings_roberta_urdu_small',
                                        'ur.embed.urdu_vec_140M_300d': 'urduvec_140M_300d',
                                        'ur.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'ur.lemma': 'lemma_udtb',
                                        'ur.lemma.spacylookup': 'lemma_spacylookup',
                                        'ur.lemma.udtb': 'lemma_udtb',
                                        'ur.ner': 'uner_mk_140M_300d',
                                        'ur.ner.mk_140M_300d': 'uner_mk_140M_300d',
                                        'ur.pos': 'pos_udtb',
                                        'ur.pos.ud_udtb': 'pos_ud_udtb',
                                        'ur.pos.udtb': 'pos_udtb',
                                        'ur.sentiment': 'sentimentdl_urduvec_imdb',
                                        'ur.stopwords': 'stopwords_iso'},
                                    'uz': {'uz.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'vec': {'vec.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'vi': {
                                        'vi.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_vi_qa',
                                        'vi.embed.bert_cased': 'bert_embeddings_bert_base_vi_cased',
                                        'vi.embed.distilbert.cased': 'distilbert_base_cased',
                                        'vi.embed.w2v_cc_300d': 'w2v_cc_300d',
                                        'vi.lemma': 'lemma',
                                        'vi.lemma.vtb': 'lemma_vtb',
                                        'vi.stopwords': 'stopwords_iso'},
                                    'vls': {'vls.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'vn': {
                                        'vn.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_vietnamese'},
                                    'vo': {'vo.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'wa': {'wa.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'war': {'war.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'wo': {'wo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_wolof',
                                           'wo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_wolof',
                                           'wo.lemma.wtb': 'lemma_wtb',
                                           'wo.pos': 'pos_wtb'},
                                    'xmf': {'xmf.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'xx': {'xx.aav.marian.translate_to.en': 'opus_mt_aav_en',
                                           'xx.aed.marian.translate_to.es': 'opus_mt_es_aed',
                                           'xx.af.marian.translate_to.de': 'opus_mt_de_af',
                                           'xx.af.marian.translate_to.en': 'opus_mt_af_en',
                                           'xx.af.marian.translate_to.eo': 'opus_mt_eo_af',
                                           'xx.af.marian.translate_to.es': 'opus_mt_es_af',
                                           'xx.af.marian.translate_to.fi': 'opus_mt_fi_af',
                                           'xx.af.marian.translate_to.fr': 'opus_mt_fr_af',
                                           'xx.af.marian.translate_to.nl': 'opus_mt_nl_af',
                                           'xx.af.marian.translate_to.ru': 'opus_mt_ru_af',
                                           'xx.af.marian.translate_to.sv': 'opus_mt_sv_af',
                                           'xx.af.translate_to.ru': 'opus_tatoeba_af_ru',
                                           'xx.afa.marian.translate_to.afa': 'opus_mt_afa_afa',
                                           'xx.afa.marian.translate_to.en': 'opus_mt_afa_en',
                                           'xx.alv.marian.translate_to.en': 'opus_mt_alv_en',
                                           'xx.answer_question.chaii.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_qa_chaii',
                                           'xx.answer_question.distil_bert.en_de_es_tuned.by_ZYW': 'distilbert_qa_en_de_es_model',
                                           'xx.answer_question.distil_bert.en_de_tuned.by_ZYW': 'distilbert_qa_en_de_model',
                                           'xx.answer_question.distil_bert.vi_zh_es_tuned.by_ZYW': 'distilbert_qa_en_de_vi_zh_es_model',
                                           'xx.answer_question.roberta': 'roberta_qa_ft_lr_cu_leolin12345',
                                           'xx.answer_question.squad.distil_bert._en_de_es_vi_zh_tuned.by_ZYW': 'distilbert_qa_squad_en_de_es_vi_zh_model',
                                           'xx.answer_question.squad.distil_bert.en_de_es_tuned.by_ZYW': 'distilbert_qa_squad_en_de_es_model',
                                           'xx.answer_question.tydiqa.bert': 'bert_qa_telugu_bertu_tydiqa',
                                           'xx.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_Part_1_mBERT_Model_E1',
                                           'xx.answer_question.xlm_roberta.distilled': 'xlm_roberta_qa_distill_xlm_mrc',
                                           'xx.answer_question.xquad.bert.cased': 'bert_qa_bert_multi_cased_finetuned_xquadv1',
                                           'xx.answer_question.xquad.bert.uncased': 'bert_qa_bert_multi_uncased_finetuned_xquadv1',
                                           'xx.answer_question.xquad_tydiqa.bert.cased': 'bert_qa_bert_multi_cased_finedtuned_xquad_tydiqa_goldp',
                                           'xx.ar.marian.translate_to.de': 'opus_mt_de_ar',
                                           'xx.ar.marian.translate_to.el': 'opus_mt_el_ar',
                                           'xx.ar.marian.translate_to.en': 'opus_mt_ar_en',
                                           'xx.ar.marian.translate_to.es': 'opus_mt_es_ar',
                                           'xx.ar.marian.translate_to.fr': 'opus_mt_fr_ar',
                                           'xx.ar.marian.translate_to.he': 'opus_mt_he_ar',
                                           'xx.ar.marian.translate_to.it': 'opus_mt_it_ar',
                                           'xx.ar.marian.translate_to.ja': 'opus_mt_ja_ar',
                                           'xx.ar.marian.translate_to.pl': 'opus_mt_pl_ar',
                                           'xx.ar.marian.translate_to.ru': 'opus_mt_ru_ar',
                                           'xx.ar.marian.translate_to.tr': 'opus_mt_tr_ar',
                                           'xx.art.marian.translate_to.en': 'opus_mt_art_en',
                                           'xx.ase.marian.translate_to.de': 'opus_mt_de_ase',
                                           'xx.ase.marian.translate_to.en': 'opus_mt_ase_en',
                                           'xx.ase.marian.translate_to.es': 'opus_mt_es_ase',
                                           'xx.ase.marian.translate_to.fr': 'opus_mt_fr_ase',
                                           'xx.ase.marian.translate_to.sv': 'opus_mt_sv_ase',
                                           'xx.az.marian.translate_to.en': 'opus_mt_az_en',
                                           'xx.az.marian.translate_to.tr': 'opus_mt_tr_az',
                                           'xx.bat.marian.translate_to.en': 'opus_mt_bat_en',
                                           'xx.bcl.marian.translate_to.de': 'opus_mt_de_bcl',
                                           'xx.bcl.marian.translate_to.en': 'opus_mt_bcl_en',
                                           'xx.bcl.marian.translate_to.es': 'opus_mt_es_bcl',
                                           'xx.bcl.marian.translate_to.fi': 'opus_mt_fi_bcl',
                                           'xx.bcl.marian.translate_to.fr': 'opus_mt_fr_bcl',
                                           'xx.bcl.marian.translate_to.sv': 'opus_mt_sv_bcl',
                                           'xx.bem.marian.translate_to.en': 'opus_mt_bem_en',
                                           'xx.bem.marian.translate_to.fi': 'opus_mt_fi_bem',
                                           'xx.bem.marian.translate_to.fr': 'opus_mt_fr_bem',
                                           'xx.bem.marian.translate_to.sv': 'opus_mt_sv_bem',
                                           'xx.ber.marian.translate_to.en': 'opus_mt_ber_en',
                                           'xx.ber.marian.translate_to.es': 'opus_mt_es_ber',
                                           'xx.ber.marian.translate_to.fr': 'opus_mt_fr_ber',
                                           'xx.bg.marian.translate_to.de': 'opus_mt_de_bg',
                                           'xx.bg.marian.translate_to.en': 'opus_mt_bg_en',
                                           'xx.bg.marian.translate_to.eo': 'opus_mt_eo_bg',
                                           'xx.bg.marian.translate_to.es': 'opus_mt_es_bg',
                                           'xx.bg.marian.translate_to.fi': 'opus_mt_fi_bg',
                                           'xx.bg.marian.translate_to.fr': 'opus_mt_fr_bg',
                                           'xx.bg.marian.translate_to.it': 'opus_mt_it_bg',
                                           'xx.bg.marian.translate_to.ja': 'opus_mt_ja_bg',
                                           'xx.bg.marian.translate_to.ru': 'opus_mt_ru_bg',
                                           'xx.bg.marian.translate_to.sv': 'opus_mt_sv_bg',
                                           'xx.bg.marian.translate_to.uk': 'opus_mt_uk_bg',
                                           'xx.bg.marian.translate_to.zh': 'opus_mt_zh_bg',
                                           'xx.bi.marian.translate_to.de': 'opus_mt_de_bi',
                                           'xx.bi.marian.translate_to.en': 'opus_mt_bi_en',
                                           'xx.bi.marian.translate_to.es': 'opus_mt_es_bi',
                                           'xx.bi.marian.translate_to.fr': 'opus_mt_fr_bi',
                                           'xx.bi.marian.translate_to.sv': 'opus_mt_sv_bi',
                                           'xx.bn.marian.translate_to.en': 'opus_mt_bn_en',
                                           'xx.bnt.marian.translate_to.en': 'opus_mt_bnt_en',
                                           'xx.bzs.marian.translate_to.de': 'opus_mt_de_bzs',
                                           'xx.bzs.marian.translate_to.en': 'opus_mt_bzs_en',
                                           'xx.bzs.marian.translate_to.es': 'opus_mt_es_bzs',
                                           'xx.bzs.marian.translate_to.fi': 'opus_mt_fi_bzs',
                                           'xx.bzs.marian.translate_to.fr': 'opus_mt_fr_bzs',
                                           'xx.bzs.marian.translate_to.sv': 'opus_mt_sv_bzs',
                                           'xx.ca.marian.translate_to.de': 'opus_mt_de_ca',
                                           'xx.ca.marian.translate_to.en': 'opus_mt_ca_en',
                                           'xx.ca.marian.translate_to.es': 'opus_mt_es_ca',
                                           'xx.ca.marian.translate_to.fr': 'opus_mt_fr_ca',
                                           'xx.ca.marian.translate_to.it': 'opus_mt_it_ca',
                                           'xx.ca.marian.translate_to.nl': 'opus_mt_nl_ca',
                                           'xx.ca.marian.translate_to.pt': 'opus_mt_pt_ca',
                                           'xx.ca.marian.translate_to.uk': 'opus_mt_uk_ca',
                                           'xx.cau.marian.translate_to.en': 'opus_mt_cau_en',
                                           'xx.ccs.marian.translate_to.en': 'opus_mt_ccs_en',
                                           'xx.ceb.marian.translate_to.en': 'opus_mt_ceb_en',
                                           'xx.ceb.marian.translate_to.es': 'opus_mt_es_ceb',
                                           'xx.ceb.marian.translate_to.fi': 'opus_mt_fi_ceb',
                                           'xx.ceb.marian.translate_to.fr': 'opus_mt_fr_ceb',
                                           'xx.ceb.marian.translate_to.sv': 'opus_mt_sv_ceb',
                                           'xx.cel.marian.translate_to.en': 'opus_mt_cel_en',
                                           'xx.chk.marian.translate_to.en': 'opus_mt_chk_en',
                                           'xx.chk.marian.translate_to.sv': 'opus_mt_sv_chk',
                                           'xx.classify.token_xlm_roberta.token_classifier_ner_40_lang': 'xlm_roberta_token_classifier_ner_40_lang',
                                           'xx.classify.wiki_21': 'ld_wiki_tatoeba_cnn_21',
                                           'xx.classify.wiki_21.bigru': 'ld_tatoeba_bigru_21',
                                           'xx.classify.wiki_220': 'ld_wiki_tatoeba_cnn_220',
                                           'xx.classify.wiki_231': 'ld_wiki_cnn_231',
                                           'xx.classify.wiki_375': 'ld_wiki_tatoeba_cnn_375',
                                           'xx.classify.wiki_43': 'ld_wiki_tatoeba_cnn_43',
                                           'xx.classify.wiki_95': 'ld_wiki_tatoeba_cnn_95',
                                           'xx.classify.wiki_99': 'ld_tatoeba_cnn_99',
                                           'xx.cpf.marian.translate_to.en': 'opus_mt_cpf_en',
                                           'xx.cpp.marian.translate_to.cpp': 'opus_mt_cpp_cpp',
                                           'xx.cpp.marian.translate_to.en': 'opus_mt_cpp_en',
                                           'xx.crs.marian.translate_to.de': 'opus_mt_de_crs',
                                           'xx.crs.marian.translate_to.en': 'opus_mt_crs_en',
                                           'xx.crs.marian.translate_to.es': 'opus_mt_es_crs',
                                           'xx.crs.marian.translate_to.fi': 'opus_mt_fi_crs',
                                           'xx.crs.marian.translate_to.fr': 'opus_mt_fr_crs',
                                           'xx.crs.marian.translate_to.sv': 'opus_mt_sv_crs',
                                           'xx.cs.marian.translate_to.de': 'opus_mt_de_cs',
                                           'xx.cs.marian.translate_to.en': 'opus_mt_cs_en',
                                           'xx.cs.marian.translate_to.eo': 'opus_mt_eo_cs',
                                           'xx.cs.marian.translate_to.es': 'opus_mt_es_cs',
                                           'xx.cs.marian.translate_to.fi': 'opus_mt_fi_cs',
                                           'xx.cs.marian.translate_to.sv': 'opus_mt_sv_cs',
                                           'xx.cs.marian.translate_to.uk': 'opus_mt_uk_cs',
                                           'xx.cs.translate_to.sv': 'opus_mt_cs_sv',
                                           'xx.csg.marian.translate_to.es': 'opus_mt_es_csg',
                                           'xx.csn.marian.translate_to.es': 'opus_mt_es_csn',
                                           'xx.cus.marian.translate_to.en': 'opus_mt_cus_en',
                                           'xx.cy.marian.translate_to.en': 'opus_mt_cy_en',
                                           'xx.da.marian.translate_to.de': 'opus_mt_de_da',
                                           'xx.da.marian.translate_to.en': 'opus_mt_da_en',
                                           'xx.da.marian.translate_to.eo': 'opus_mt_eo_da',
                                           'xx.da.marian.translate_to.es': 'opus_mt_es_da',
                                           'xx.da.marian.translate_to.ja': 'opus_mt_ja_da',
                                           'xx.da.marian.translate_to.no': 'opus_mt_no_da',
                                           'xx.da.marian.translate_to.ru': 'opus_mt_ru_da',
                                           'xx.de.marian.translate_to.af': 'opus_mt_af_de',
                                           'xx.de.marian.translate_to.ar': 'opus_mt_ar_de',
                                           'xx.de.marian.translate_to.ase': 'opus_mt_ase_de',
                                           'xx.de.marian.translate_to.bcl': 'opus_mt_bcl_de',
                                           'xx.de.marian.translate_to.bg': 'opus_mt_bg_de',
                                           'xx.de.marian.translate_to.ca': 'opus_mt_ca_de',
                                           'xx.de.marian.translate_to.crs': 'opus_mt_crs_de',
                                           'xx.de.marian.translate_to.cs': 'opus_mt_cs_de',
                                           'xx.de.marian.translate_to.da': 'opus_mt_da_de',
                                           'xx.de.marian.translate_to.de': 'opus_mt_de_de',
                                           'xx.de.marian.translate_to.ee': 'opus_mt_ee_de',
                                           'xx.de.marian.translate_to.efi': 'opus_mt_efi_de',
                                           'xx.de.marian.translate_to.en': 'opus_mt_de_en',
                                           'xx.de.marian.translate_to.eo': 'opus_mt_eo_de',
                                           'xx.de.marian.translate_to.es': 'opus_mt_es_de',
                                           'xx.de.marian.translate_to.et': 'opus_mt_et_de',
                                           'xx.de.marian.translate_to.eu': 'opus_mt_eu_de',
                                           'xx.de.marian.translate_to.fi': 'opus_mt_fi_de',
                                           'xx.de.marian.translate_to.fr': 'opus_mt_fr_de',
                                           'xx.de.marian.translate_to.gaa': 'opus_mt_gaa_de',
                                           'xx.de.marian.translate_to.guw': 'opus_mt_guw_de',
                                           'xx.de.marian.translate_to.he': 'opus_mt_he_de',
                                           'xx.de.marian.translate_to.hil': 'opus_mt_hil_de',
                                           'xx.de.marian.translate_to.hu': 'opus_mt_hu_de',
                                           'xx.de.marian.translate_to.ig': 'opus_mt_ig_de',
                                           'xx.de.marian.translate_to.ilo': 'opus_mt_ilo_de',
                                           'xx.de.marian.translate_to.is': 'opus_mt_is_de',
                                           'xx.de.marian.translate_to.it': 'opus_mt_it_de',
                                           'xx.de.marian.translate_to.ja': 'opus_mt_ja_de',
                                           'xx.de.marian.translate_to.ko': 'opus_mt_ko_de',
                                           'xx.de.marian.translate_to.ln': 'opus_mt_ln_de',
                                           'xx.de.marian.translate_to.loz': 'opus_mt_loz_de',
                                           'xx.de.marian.translate_to.lt': 'opus_mt_lt_de',
                                           'xx.de.marian.translate_to.ms': 'opus_mt_ms_de',
                                           'xx.de.marian.translate_to.niu': 'opus_mt_niu_de',
                                           'xx.de.marian.translate_to.no': 'opus_mt_no_de',
                                           'xx.de.marian.translate_to.nso': 'opus_mt_nso_de',
                                           'xx.de.marian.translate_to.ny': 'opus_mt_ny_de',
                                           'xx.de.marian.translate_to.pag': 'opus_mt_pag_de',
                                           'xx.de.marian.translate_to.pap': 'opus_mt_pap_de',
                                           'xx.de.marian.translate_to.pl': 'opus_mt_pl_de',
                                           'xx.de.marian.translate_to.rn': 'opus_mt_rn_de',
                                           'xx.de.marian.translate_to.tl': 'opus_mt_tl_de',
                                           'xx.de.marian.translate_to.uk': 'opus_mt_uk_de',
                                           'xx.de.marian.translate_to.vi': 'opus_mt_vi_de',
                                           'xx.de.marian.translate_to.zh': 'opus_mt_zh_de',
                                           'xx.dra.marian.translate_to.en': 'opus_mt_dra_en',
                                           'xx.ee.marian.translate_to.de': 'opus_mt_de_ee',
                                           'xx.ee.marian.translate_to.en': 'opus_mt_ee_en',
                                           'xx.ee.marian.translate_to.es': 'opus_mt_es_ee',
                                           'xx.ee.marian.translate_to.fi': 'opus_mt_fi_ee',
                                           'xx.ee.marian.translate_to.fr': 'opus_mt_fr_ee',
                                           'xx.ee.marian.translate_to.sv': 'opus_mt_sv_ee',
                                           'xx.efi.marian.translate_to.de': 'opus_mt_de_efi',
                                           'xx.efi.marian.translate_to.en': 'opus_mt_efi_en',
                                           'xx.efi.marian.translate_to.es': 'opus_mt_es_efi',
                                           'xx.efi.marian.translate_to.fi': 'opus_mt_fi_efi',
                                           'xx.efi.marian.translate_to.fr': 'opus_mt_fr_efi',
                                           'xx.efi.marian.translate_to.sv': 'opus_mt_sv_efi',
                                           'xx.el.marian.translate_to.ar': 'opus_mt_ar_el',
                                           'xx.el.marian.translate_to.de': 'opus_mt_de_el',
                                           'xx.el.marian.translate_to.eo': 'opus_mt_eo_el',
                                           'xx.el.marian.translate_to.es': 'opus_mt_es_el',
                                           'xx.el.marian.translate_to.fi': 'opus_mt_fi_el',
                                           'xx.el.marian.translate_to.fr': 'opus_mt_fr_el',
                                           'xx.el.marian.translate_to.sv': 'opus_mt_sv_el',
                                           'xx.embed': 'glove_840B_300',
                                           'xx.embed.albert.indic': 'albert_indic',
                                           'xx.embed.bert': 'bert_multi_cased',
                                           'xx.embed.bert.muril': 'bert_muril',
                                           'xx.embed.bert_base_multilingual_cased': 'bert_base_multilingual_cased',
                                           'xx.embed.bert_base_multilingual_uncased': 'bert_base_multilingual_uncased',
                                           'xx.embed.bert_multi_cased': 'bert_multi_cased',
                                           'xx.embed.distilbert': 'distilbert_base_multilingual_cased',
                                           'xx.embed.glove.6B_300': 'glove_6B_300',
                                           'xx.embed.glove.840B_300': 'glove_840B_300',
                                           'xx.embed.glove.glove_6B_100': 'glove_6B_100',
                                           'xx.embed.mdeberta_v3_base': 'mdeberta_v3_base',
                                           'xx.embed.xlm': 'xlm_roberta_base',
                                           'xx.embed.xlm.base': 'xlm_roberta_base',
                                           'xx.embed.xlm.twitter': 'twitter_xlm_roberta_base',
                                           'xx.embed.xlm_roberta_large': 'xlm_roberta_large',
                                           'xx.embed.xlm_roberta_xtreme_base': 'xlm_roberta_xtreme_base',
                                           'xx.embed_sentence': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.bert': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.bert.cased': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.bert.muril': 'sent_bert_muril',
                                           'xx.embed_sentence.bert_use_cmlm_multi_base': 'sent_bert_use_cmlm_multi_base',
                                           'xx.embed_sentence.bert_use_cmlm_multi_base_br': 'sent_bert_use_cmlm_multi_base_br',
                                           'xx.embed_sentence.labse': 'labse',
                                           'xx.en.marian.translate_to.aav': 'opus_mt_en_aav',
                                           'xx.en.marian.translate_to.af': 'opus_mt_en_af',
                                           'xx.en.marian.translate_to.afa': 'opus_mt_en_afa',
                                           'xx.en.marian.translate_to.alv': 'opus_mt_en_alv',
                                           'xx.en.marian.translate_to.ar': 'opus_mt_en_ar',
                                           'xx.en.marian.translate_to.az': 'opus_mt_en_az',
                                           'xx.en.marian.translate_to.bat': 'opus_mt_en_bat',
                                           'xx.en.marian.translate_to.bcl': 'opus_mt_en_bcl',
                                           'xx.en.marian.translate_to.bem': 'opus_mt_en_bem',
                                           'xx.en.marian.translate_to.ber': 'opus_mt_en_ber',
                                           'xx.en.marian.translate_to.bg': 'opus_mt_en_bg',
                                           'xx.en.marian.translate_to.bi': 'opus_mt_en_bi',
                                           'xx.en.marian.translate_to.bnt': 'opus_mt_en_bnt',
                                           'xx.en.marian.translate_to.bzs': 'opus_mt_en_bzs',
                                           'xx.en.marian.translate_to.ca': 'opus_mt_en_ca',
                                           'xx.en.marian.translate_to.ceb': 'opus_mt_en_ceb',
                                           'xx.en.marian.translate_to.cel': 'opus_mt_en_cel',
                                           'xx.en.marian.translate_to.chk': 'opus_mt_en_chk',
                                           'xx.en.marian.translate_to.cpf': 'opus_mt_en_cpf',
                                           'xx.en.marian.translate_to.cpp': 'opus_mt_en_cpp',
                                           'xx.en.marian.translate_to.crs': 'opus_mt_en_crs',
                                           'xx.en.marian.translate_to.cs': 'opus_mt_en_cs',
                                           'xx.en.marian.translate_to.cus': 'opus_mt_en_cus',
                                           'xx.en.marian.translate_to.cy': 'opus_mt_en_cy',
                                           'xx.en.marian.translate_to.da': 'opus_mt_en_da',
                                           'xx.en.marian.translate_to.de': 'opus_mt_en_de',
                                           'xx.en.marian.translate_to.dra': 'opus_mt_en_dra',
                                           'xx.en.marian.translate_to.ee': 'opus_mt_en_ee',
                                           'xx.en.marian.translate_to.efi': 'opus_mt_en_efi',
                                           'xx.en.marian.translate_to.el': 'opus_mt_en_el',
                                           'xx.en.marian.translate_to.eo': 'opus_mt_en_eo',
                                           'xx.en.marian.translate_to.es': 'opus_mt_en_es',
                                           'xx.en.marian.translate_to.et': 'opus_mt_en_et',
                                           'xx.en.marian.translate_to.eu': 'opus_mt_en_eu',
                                           'xx.en.marian.translate_to.euq': 'opus_mt_en_euq',
                                           'xx.en.marian.translate_to.fi': 'opus_mt_en_fi',
                                           'xx.en.marian.translate_to.fiu': 'opus_mt_en_fiu',
                                           'xx.en.marian.translate_to.fj': 'opus_mt_en_fj',
                                           'xx.en.marian.translate_to.fr': 'opus_mt_en_fr',
                                           'xx.en.marian.translate_to.ga': 'opus_mt_en_ga',
                                           'xx.en.marian.translate_to.gaa': 'opus_mt_en_gaa',
                                           'xx.en.marian.translate_to.gem': 'opus_mt_en_gem',
                                           'xx.en.marian.translate_to.gil': 'opus_mt_en_gil',
                                           'xx.en.marian.translate_to.gl': 'opus_mt_en_gl',
                                           'xx.en.marian.translate_to.gmq': 'opus_mt_en_gmq',
                                           'xx.en.marian.translate_to.gmw': 'opus_mt_en_gmw',
                                           'xx.en.marian.translate_to.grk': 'opus_mt_en_grk',
                                           'xx.en.marian.translate_to.guw': 'opus_mt_en_guw',
                                           'xx.en.marian.translate_to.gv': 'opus_mt_en_gv',
                                           'xx.en.marian.translate_to.ha': 'opus_mt_en_ha',
                                           'xx.en.marian.translate_to.he': 'opus_mt_en_he',
                                           'xx.en.marian.translate_to.hi': 'opus_mt_en_hi',
                                           'xx.en.marian.translate_to.hil': 'opus_mt_en_hil',
                                           'xx.en.marian.translate_to.ho': 'opus_mt_en_ho',
                                           'xx.en.marian.translate_to.ht': 'opus_mt_en_ht',
                                           'xx.en.marian.translate_to.hu': 'opus_mt_en_hu',
                                           'xx.en.marian.translate_to.hy': 'opus_mt_en_hy',
                                           'xx.en.marian.translate_to.id': 'opus_mt_en_id',
                                           'xx.en.marian.translate_to.ig': 'opus_mt_en_ig',
                                           'xx.en.marian.translate_to.iir': 'opus_mt_en_iir',
                                           'xx.en.marian.translate_to.ilo': 'opus_mt_en_ilo',
                                           'xx.en.marian.translate_to.inc': 'opus_mt_en_inc',
                                           'xx.en.marian.translate_to.ine': 'opus_mt_en_ine',
                                           'xx.en.marian.translate_to.is': 'opus_mt_en_is',
                                           'xx.en.marian.translate_to.iso': 'opus_mt_en_iso',
                                           'xx.en.marian.translate_to.it': 'opus_mt_en_it',
                                           'xx.en.marian.translate_to.itc': 'opus_mt_en_itc',
                                           'xx.en.marian.translate_to.jap': 'opus_mt_en_jap',
                                           'xx.en.marian.translate_to.kg': 'opus_mt_en_kg',
                                           'xx.en.marian.translate_to.kj': 'opus_mt_en_kj',
                                           'xx.en.marian.translate_to.kqn': 'opus_mt_en_kqn',
                                           'xx.en.marian.translate_to.kwn': 'opus_mt_en_kwn',
                                           'xx.en.marian.translate_to.kwy': 'opus_mt_en_kwy',
                                           'xx.en.marian.translate_to.lg': 'opus_mt_en_lg',
                                           'xx.en.marian.translate_to.ln': 'opus_mt_en_ln',
                                           'xx.en.marian.translate_to.loz': 'opus_mt_en_loz',
                                           'xx.en.marian.translate_to.lu': 'opus_mt_en_lu',
                                           'xx.en.marian.translate_to.lua': 'opus_mt_en_lua',
                                           'xx.en.marian.translate_to.lue': 'opus_mt_en_lue',
                                           'xx.en.marian.translate_to.lun': 'opus_mt_en_lun',
                                           'xx.en.marian.translate_to.luo': 'opus_mt_en_luo',
                                           'xx.en.marian.translate_to.lus': 'opus_mt_en_lus',
                                           'xx.en.marian.translate_to.map': 'opus_mt_en_map',
                                           'xx.en.marian.translate_to.mfe': 'opus_mt_en_mfe',
                                           'xx.en.marian.translate_to.mg': 'opus_mt_en_mg',
                                           'xx.en.marian.translate_to.mh': 'opus_mt_en_mh',
                                           'xx.en.marian.translate_to.mk': 'opus_mt_en_mk',
                                           'xx.en.marian.translate_to.mkh': 'opus_mt_en_mkh',
                                           'xx.en.marian.translate_to.ml': 'opus_mt_en_ml',
                                           'xx.en.marian.translate_to.mos': 'opus_mt_en_mos',
                                           'xx.en.marian.translate_to.mr': 'opus_mt_en_mr',
                                           'xx.en.marian.translate_to.mt': 'opus_mt_en_mt',
                                           'xx.en.marian.translate_to.mul': 'opus_mt_en_mul',
                                           'xx.en.marian.translate_to.ng': 'opus_mt_en_ng',
                                           'xx.en.marian.translate_to.nic': 'opus_mt_en_nic',
                                           'xx.en.marian.translate_to.niu': 'opus_mt_en_niu',
                                           'xx.en.marian.translate_to.nl': 'opus_mt_en_nl',
                                           'xx.en.marian.translate_to.nso': 'opus_mt_en_nso',
                                           'xx.en.marian.translate_to.ny': 'opus_mt_en_ny',
                                           'xx.en.marian.translate_to.nyk': 'opus_mt_en_nyk',
                                           'xx.en.marian.translate_to.om': 'opus_mt_en_om',
                                           'xx.en.marian.translate_to.pag': 'opus_mt_en_pag',
                                           'xx.en.marian.translate_to.pap': 'opus_mt_en_pap',
                                           'xx.en.marian.translate_to.phi': 'opus_mt_en_phi',
                                           'xx.en.marian.translate_to.pis': 'opus_mt_en_pis',
                                           'xx.en.marian.translate_to.pon': 'opus_mt_en_pon',
                                           'xx.en.marian.translate_to.poz': 'opus_mt_en_poz',
                                           'xx.en.marian.translate_to.pqe': 'opus_mt_en_pqe',
                                           'xx.en.marian.translate_to.pqw': 'opus_mt_en_pqw',
                                           'xx.en.marian.translate_to.rn': 'opus_mt_en_rn',
                                           'xx.en.marian.translate_to.rnd': 'opus_mt_en_rnd',
                                           'xx.en.marian.translate_to.ro': 'opus_mt_en_ro',
                                           'xx.en.marian.translate_to.roa': 'opus_mt_en_roa',
                                           'xx.en.marian.translate_to.ru': 'opus_mt_en_ru',
                                           'xx.en.marian.translate_to.run': 'opus_mt_en_run',
                                           'xx.en.marian.translate_to.rw': 'opus_mt_en_rw',
                                           'xx.en.marian.translate_to.sal': 'opus_mt_en_sal',
                                           'xx.en.marian.translate_to.sem': 'opus_mt_en_sem',
                                           'xx.en.marian.translate_to.sg': 'opus_mt_en_sg',
                                           'xx.en.marian.translate_to.sit': 'opus_mt_en_sit',
                                           'xx.en.marian.translate_to.sk': 'opus_mt_en_sk',
                                           'xx.en.marian.translate_to.sla': 'opus_mt_en_sla',
                                           'xx.en.marian.translate_to.sm': 'opus_mt_en_sm',
                                           'xx.en.marian.translate_to.sn': 'opus_mt_en_sn',
                                           'xx.en.marian.translate_to.sq': 'opus_mt_en_sq',
                                           'xx.en.marian.translate_to.ss': 'opus_mt_en_ss',
                                           'xx.en.marian.translate_to.st': 'opus_mt_en_st',
                                           'xx.en.marian.translate_to.sv': 'opus_mt_en_sv',
                                           'xx.en.marian.translate_to.sw': 'opus_mt_en_sw',
                                           'xx.en.marian.translate_to.swc': 'opus_mt_en_swc',
                                           'xx.en.marian.translate_to.tdt': 'opus_mt_en_tdt',
                                           'xx.en.marian.translate_to.ti': 'opus_mt_en_ti',
                                           'xx.en.marian.translate_to.tiv': 'opus_mt_en_tiv',
                                           'xx.en.marian.translate_to.tl': 'opus_mt_en_tl',
                                           'xx.en.marian.translate_to.tll': 'opus_mt_en_tll',
                                           'xx.en.marian.translate_to.tn': 'opus_mt_en_tn',
                                           'xx.en.marian.translate_to.to': 'opus_mt_en_to',
                                           'xx.en.marian.translate_to.toi': 'opus_mt_en_toi',
                                           'xx.en.marian.translate_to.tpi': 'opus_mt_en_tpi',
                                           'xx.en.marian.translate_to.trk': 'opus_mt_en_trk',
                                           'xx.en.marian.translate_to.ts': 'opus_mt_en_ts',
                                           'xx.en.marian.translate_to.tut': 'opus_mt_en_tut',
                                           'xx.en.marian.translate_to.tvl': 'opus_mt_en_tvl',
                                           'xx.en.marian.translate_to.tw': 'opus_mt_en_tw',
                                           'xx.en.marian.translate_to.ty': 'opus_mt_en_ty',
                                           'xx.en.marian.translate_to.uk': 'opus_mt_en_uk',
                                           'xx.en.marian.translate_to.umb': 'opus_mt_en_umb',
                                           'xx.en.marian.translate_to.ur': 'opus_mt_en_ur',
                                           'xx.en.marian.translate_to.urj': 'opus_mt_en_urj',
                                           'xx.en.marian.translate_to.vi': 'opus_mt_en_vi',
                                           'xx.en.marian.translate_to.xh': 'opus_mt_en_xh',
                                           'xx.en.marian.translate_to.zh': 'opus_mt_en_zh',
                                           'xx.en.marian.translate_to.zle': 'opus_mt_en_zle',
                                           'xx.en.marian.translate_to.zls': 'opus_mt_en_zls',
                                           'xx.en.marian.translate_to.zlw': 'opus_mt_en_zlw',
                                           'xx.eo.marian.translate_to.af': 'opus_mt_af_eo',
                                           'xx.eo.marian.translate_to.ar': 'opus_mt_ar_eo',
                                           'xx.eo.marian.translate_to.bg': 'opus_mt_bg_eo',
                                           'xx.eo.marian.translate_to.cs': 'opus_mt_cs_eo',
                                           'xx.eo.marian.translate_to.da': 'opus_mt_da_eo',
                                           'xx.eo.marian.translate_to.de': 'opus_mt_de_eo',
                                           'xx.eo.marian.translate_to.el': 'opus_mt_el_eo',
                                           'xx.eo.marian.translate_to.en': 'opus_mt_eo_en',
                                           'xx.eo.marian.translate_to.es': 'opus_mt_es_eo',
                                           'xx.eo.marian.translate_to.fi': 'opus_mt_fi_eo',
                                           'xx.eo.marian.translate_to.fr': 'opus_mt_fr_eo',
                                           'xx.eo.marian.translate_to.he': 'opus_mt_he_eo',
                                           'xx.eo.marian.translate_to.hu': 'opus_mt_hu_eo',
                                           'xx.eo.marian.translate_to.is': 'opus_mt_is_eo',
                                           'xx.eo.marian.translate_to.it': 'opus_mt_it_eo',
                                           'xx.eo.marian.translate_to.lt': 'opus_mt_lt_eo',
                                           'xx.eo.marian.translate_to.nl': 'opus_mt_nl_eo',
                                           'xx.eo.marian.translate_to.pl': 'opus_mt_pl_eo',
                                           'xx.eo.marian.translate_to.pt': 'opus_mt_pt_eo',
                                           'xx.eo.marian.translate_to.ro': 'opus_mt_ro_eo',
                                           'xx.eo.marian.translate_to.ru': 'opus_mt_ru_eo',
                                           'xx.eo.marian.translate_to.sh': 'opus_mt_sh_eo',
                                           'xx.eo.marian.translate_to.sv': 'opus_mt_sv_eo',
                                           'xx.eo.marian.translate_to.tr': 'opus_mt_tr_eo',
                                           'xx.eo.marian.translate_to.vi': 'opus_mt_vi_eo',
                                           'xx.es.marian.translate_to.aed': 'opus_mt_aed_es',
                                           'xx.es.marian.translate_to.af': 'opus_mt_af_es',
                                           'xx.es.marian.translate_to.ar': 'opus_mt_ar_es',
                                           'xx.es.marian.translate_to.ase': 'opus_mt_ase_es',
                                           'xx.es.marian.translate_to.az': 'opus_mt_az_es',
                                           'xx.es.marian.translate_to.bcl': 'opus_mt_bcl_es',
                                           'xx.es.marian.translate_to.be': 'opus_mt_be_es',
                                           'xx.es.marian.translate_to.bem': 'opus_mt_bem_es',
                                           'xx.es.marian.translate_to.ber': 'opus_mt_ber_es',
                                           'xx.es.marian.translate_to.bg': 'opus_mt_bg_es',
                                           'xx.es.marian.translate_to.bi': 'opus_mt_bi_es',
                                           'xx.es.marian.translate_to.bzs': 'opus_mt_bzs_es',
                                           'xx.es.marian.translate_to.ca': 'opus_mt_ca_es',
                                           'xx.es.marian.translate_to.ceb': 'opus_mt_ceb_es',
                                           'xx.es.marian.translate_to.chk': 'opus_mt_chk_es',
                                           'xx.es.marian.translate_to.crs': 'opus_mt_crs_es',
                                           'xx.es.marian.translate_to.csg': 'opus_mt_csg_es',
                                           'xx.es.marian.translate_to.csn': 'opus_mt_csn_es',
                                           'xx.es.marian.translate_to.da': 'opus_mt_da_es',
                                           'xx.es.marian.translate_to.de': 'opus_mt_de_es',
                                           'xx.es.marian.translate_to.ee': 'opus_mt_ee_es',
                                           'xx.es.marian.translate_to.en': 'opus_mt_es_en',
                                           'xx.es.marian.translate_to.eo': 'opus_mt_eo_es',
                                           'xx.es.marian.translate_to.es': 'opus_mt_es_es',
                                           'xx.es.marian.translate_to.et': 'opus_mt_et_es',
                                           'xx.es.marian.translate_to.eu': 'opus_mt_eu_es',
                                           'xx.es.marian.translate_to.fi': 'opus_mt_fi_es',
                                           'xx.es.marian.translate_to.fr': 'opus_mt_fr_es',
                                           'xx.es.marian.translate_to.gaa': 'opus_mt_gaa_es',
                                           'xx.es.marian.translate_to.gil': 'opus_mt_gil_es',
                                           'xx.es.marian.translate_to.gl': 'opus_mt_gl_es',
                                           'xx.es.marian.translate_to.guw': 'opus_mt_guw_es',
                                           'xx.es.marian.translate_to.ha': 'opus_mt_ha_es',
                                           'xx.es.marian.translate_to.he': 'opus_mt_he_es',
                                           'xx.es.marian.translate_to.hr': 'opus_mt_hr_es',
                                           'xx.es.marian.translate_to.ht': 'opus_mt_ht_es',
                                           'xx.es.marian.translate_to.id': 'opus_mt_id_es',
                                           'xx.es.marian.translate_to.ig': 'opus_mt_ig_es',
                                           'xx.es.marian.translate_to.ilo': 'opus_mt_ilo_es',
                                           'xx.es.marian.translate_to.is': 'opus_mt_is_es',
                                           'xx.es.marian.translate_to.iso': 'opus_mt_iso_es',
                                           'xx.es.marian.translate_to.it': 'opus_mt_it_es',
                                           'xx.es.marian.translate_to.ja': 'opus_mt_ja_es',
                                           'xx.es.marian.translate_to.kg': 'opus_mt_kg_es',
                                           'xx.es.marian.translate_to.ko': 'opus_mt_ko_es',
                                           'xx.es.marian.translate_to.kqn': 'opus_mt_kqn_es',
                                           'xx.es.marian.translate_to.lg': 'opus_mt_lg_es',
                                           'xx.es.marian.translate_to.ln': 'opus_mt_ln_es',
                                           'xx.es.marian.translate_to.loz': 'opus_mt_loz_es',
                                           'xx.es.marian.translate_to.lt': 'opus_mt_lt_es',
                                           'xx.es.marian.translate_to.lu': 'opus_mt_lu_es',
                                           'xx.es.marian.translate_to.lua': 'opus_mt_lua_es',
                                           'xx.es.marian.translate_to.lue': 'opus_mt_lue_es',
                                           'xx.es.marian.translate_to.lus': 'opus_mt_lus_es',
                                           'xx.es.marian.translate_to.lv': 'opus_mt_lv_es',
                                           'xx.es.marian.translate_to.mfe': 'opus_mt_mfe_es',
                                           'xx.es.marian.translate_to.mfs': 'opus_mt_mfs_es',
                                           'xx.es.marian.translate_to.mg': 'opus_mt_mg_es',
                                           'xx.es.marian.translate_to.mh': 'opus_mt_mh_es',
                                           'xx.es.marian.translate_to.mk': 'opus_mt_mk_es',
                                           'xx.es.marian.translate_to.mt': 'opus_mt_mt_es',
                                           'xx.es.marian.translate_to.niu': 'opus_mt_niu_es',
                                           'xx.es.marian.translate_to.nl': 'opus_mt_nl_es',
                                           'xx.es.marian.translate_to.no': 'opus_mt_no_es',
                                           'xx.es.marian.translate_to.nso': 'opus_mt_nso_es',
                                           'xx.es.marian.translate_to.ny': 'opus_mt_ny_es',
                                           'xx.es.marian.translate_to.pag': 'opus_mt_pag_es',
                                           'xx.es.marian.translate_to.pap': 'opus_mt_pap_es',
                                           'xx.es.marian.translate_to.pis': 'opus_mt_pis_es',
                                           'xx.es.marian.translate_to.pl': 'opus_mt_pl_es',
                                           'xx.es.marian.translate_to.pon': 'opus_mt_pon_es',
                                           'xx.es.marian.translate_to.prl': 'opus_mt_prl_es',
                                           'xx.es.marian.translate_to.rn': 'opus_mt_rn_es',
                                           'xx.es.marian.translate_to.ru': 'opus_mt_ru_es',
                                           'xx.es.marian.translate_to.run': 'opus_mt_run_es',
                                           'xx.es.marian.translate_to.rw': 'opus_mt_rw_es',
                                           'xx.es.marian.translate_to.sg': 'opus_mt_sg_es',
                                           'xx.es.marian.translate_to.sk': 'opus_mt_sk_es',
                                           'xx.es.marian.translate_to.sl': 'opus_mt_sl_es',
                                           'xx.es.marian.translate_to.sm': 'opus_mt_sm_es',
                                           'xx.es.marian.translate_to.sn': 'opus_mt_sn_es',
                                           'xx.es.marian.translate_to.sq': 'opus_mt_sq_es',
                                           'xx.es.marian.translate_to.srn': 'opus_mt_srn_es',
                                           'xx.es.marian.translate_to.ssp': 'opus_mt_ssp_es',
                                           'xx.es.marian.translate_to.st': 'opus_mt_st_es',
                                           'xx.es.marian.translate_to.sv': 'opus_mt_sv_es',
                                           'xx.es.marian.translate_to.swc': 'opus_mt_swc_es',
                                           'xx.es.marian.translate_to.tl': 'opus_mt_tl_es',
                                           'xx.es.marian.translate_to.tll': 'opus_mt_tll_es',
                                           'xx.es.marian.translate_to.tn': 'opus_mt_tn_es',
                                           'xx.es.marian.translate_to.to': 'opus_mt_to_es',
                                           'xx.es.marian.translate_to.toi': 'opus_mt_toi_es',
                                           'xx.es.marian.translate_to.tr': 'opus_mt_tr_es',
                                           'xx.es.marian.translate_to.ts': 'opus_mt_ts_es',
                                           'xx.es.marian.translate_to.tum': 'opus_mt_tum_es',
                                           'xx.es.marian.translate_to.tvl': 'opus_mt_tvl_es',
                                           'xx.es.marian.translate_to.tw': 'opus_mt_tw_es',
                                           'xx.es.marian.translate_to.ty': 'opus_mt_ty_es',
                                           'xx.es.marian.translate_to.tzo': 'opus_mt_tzo_es',
                                           'xx.es.marian.translate_to.uk': 'opus_mt_uk_es',
                                           'xx.es.marian.translate_to.ve': 'opus_mt_ve_es',
                                           'xx.es.marian.translate_to.vi': 'opus_mt_vi_es',
                                           'xx.es.marian.translate_to.vsl': 'opus_mt_vsl_es',
                                           'xx.es.marian.translate_to.war': 'opus_mt_war_es',
                                           'xx.es.marian.translate_to.xh': 'opus_mt_xh_es',
                                           'xx.es.marian.translate_to.yo': 'opus_mt_yo_es',
                                           'xx.es.marian.translate_to.zai': 'opus_mt_zai_es',
                                           'xx.es.marian.translate_to.zh': 'opus_tatoeba_es_zh',
                                           'xx.es.marian.translate_to.zne': 'opus_mt_zne_es',
                                           'xx.et.marian.translate_to.de': 'opus_mt_de_et',
                                           'xx.et.marian.translate_to.en': 'opus_mt_et_en',
                                           'xx.et.marian.translate_to.es': 'opus_mt_es_et',
                                           'xx.et.marian.translate_to.fi': 'opus_mt_fi_et',
                                           'xx.et.marian.translate_to.ru': 'opus_mt_ru_et',
                                           'xx.et.marian.translate_to.sv': 'opus_mt_sv_et',
                                           'xx.eu.marian.translate_to.de': 'opus_mt_de_eu',
                                           'xx.eu.marian.translate_to.en': 'opus_mt_eu_en',
                                           'xx.eu.marian.translate_to.es': 'opus_mt_es_eu',
                                           'xx.eu.marian.translate_to.ru': 'opus_mt_ru_eu',
                                           'xx.euq.marian.translate_to.en': 'opus_mt_euq_en',
                                           'xx.fi.marian.translate_to.af': 'opus_mt_af_fi',
                                           'xx.fi.marian.translate_to.bcl': 'opus_mt_bcl_fi',
                                           'xx.fi.marian.translate_to.bem': 'opus_mt_bem_fi',
                                           'xx.fi.marian.translate_to.bg': 'opus_mt_bg_fi',
                                           'xx.fi.marian.translate_to.bzs': 'opus_mt_bzs_fi',
                                           'xx.fi.marian.translate_to.ceb': 'opus_mt_ceb_fi',
                                           'xx.fi.marian.translate_to.crs': 'opus_mt_crs_fi',
                                           'xx.fi.marian.translate_to.cs': 'opus_mt_cs_fi',
                                           'xx.fi.marian.translate_to.da': 'opus_mt_da_fi',
                                           'xx.fi.marian.translate_to.de': 'opus_mt_de_fi',
                                           'xx.fi.marian.translate_to.ee': 'opus_mt_ee_fi',
                                           'xx.fi.marian.translate_to.efi': 'opus_mt_efi_fi',
                                           'xx.fi.marian.translate_to.el': 'opus_mt_el_fi',
                                           'xx.fi.marian.translate_to.en': 'opus_mt_fi_en',
                                           'xx.fi.marian.translate_to.eo': 'opus_mt_eo_fi',
                                           'xx.fi.marian.translate_to.es': 'opus_mt_es_fi',
                                           'xx.fi.marian.translate_to.et': 'opus_mt_et_fi',
                                           'xx.fi.marian.translate_to.fi': 'opus_mt_fi_fi',
                                           'xx.fi.marian.translate_to.fse': 'opus_mt_fse_fi',
                                           'xx.fi.marian.translate_to.gaa': 'opus_mt_gaa_fi',
                                           'xx.fi.marian.translate_to.gil': 'opus_mt_gil_fi',
                                           'xx.fi.marian.translate_to.guw': 'opus_mt_guw_fi',
                                           'xx.fi.marian.translate_to.ha': 'opus_mt_ha_fi',
                                           'xx.fi.marian.translate_to.he': 'opus_mt_he_fi',
                                           'xx.fi.marian.translate_to.hil': 'opus_mt_hil_fi',
                                           'xx.fi.marian.translate_to.hr': 'opus_mt_hr_fi',
                                           'xx.fi.marian.translate_to.ht': 'opus_mt_ht_fi',
                                           'xx.fi.marian.translate_to.hu': 'opus_mt_hu_fi',
                                           'xx.fi.marian.translate_to.id': 'opus_mt_id_fi',
                                           'xx.fi.marian.translate_to.ig': 'opus_mt_ig_fi',
                                           'xx.fi.marian.translate_to.ilo': 'opus_mt_ilo_fi',
                                           'xx.fi.marian.translate_to.is': 'opus_mt_is_fi',
                                           'xx.fi.marian.translate_to.iso': 'opus_mt_iso_fi',
                                           'xx.fi.marian.translate_to.ja': 'opus_mt_ja_fi',
                                           'xx.fi.marian.translate_to.ko': 'opus_mt_ko_fi',
                                           'xx.fi.marian.translate_to.lg': 'opus_mt_lg_fi',
                                           'xx.fi.marian.translate_to.loz': 'opus_mt_loz_fi',
                                           'xx.fi.marian.translate_to.lu': 'opus_mt_lu_fi',
                                           'xx.fi.marian.translate_to.lua': 'opus_mt_lua_fi',
                                           'xx.fi.marian.translate_to.lue': 'opus_mt_lue_fi',
                                           'xx.fi.marian.translate_to.lus': 'opus_mt_lus_fi',
                                           'xx.fi.marian.translate_to.lv': 'opus_mt_lv_fi',
                                           'xx.fi.marian.translate_to.mh': 'opus_mt_mh_fi',
                                           'xx.fi.marian.translate_to.mk': 'opus_mt_mk_fi',
                                           'xx.fi.marian.translate_to.mt': 'opus_mt_mt_fi',
                                           'xx.fi.marian.translate_to.niu': 'opus_mt_niu_fi',
                                           'xx.fi.marian.translate_to.nl': 'opus_mt_nl_fi',
                                           'xx.fi.marian.translate_to.no': 'opus_mt_no_fi',
                                           'xx.fi.marian.translate_to.nso': 'opus_mt_nso_fi',
                                           'xx.fi.marian.translate_to.pag': 'opus_mt_pag_fi',
                                           'xx.fi.marian.translate_to.pap': 'opus_mt_pap_fi',
                                           'xx.fi.marian.translate_to.pis': 'opus_mt_pis_fi',
                                           'xx.fi.marian.translate_to.pon': 'opus_mt_pon_fi',
                                           'xx.fi.marian.translate_to.ro': 'opus_mt_ro_fi',
                                           'xx.fi.marian.translate_to.ru': 'opus_mt_ru_fi',
                                           'xx.fi.marian.translate_to.sg': 'opus_mt_sg_fi',
                                           'xx.fi.marian.translate_to.sk': 'opus_mt_sk_fi',
                                           'xx.fi.marian.translate_to.sl': 'opus_mt_sl_fi',
                                           'xx.fi.marian.translate_to.st': 'opus_mt_st_fi',
                                           'xx.fi.marian.translate_to.sv': 'opus_mt_sv_fi',
                                           'xx.fi.marian.translate_to.swc': 'opus_mt_swc_fi',
                                           'xx.fi.marian.translate_to.tll': 'opus_mt_tll_fi',
                                           'xx.fi.marian.translate_to.toi': 'opus_mt_toi_fi',
                                           'xx.fi.marian.translate_to.ts': 'opus_mt_ts_fi',
                                           'xx.fi.marian.translate_to.tvl': 'opus_mt_tvl_fi',
                                           'xx.fi.marian.translate_to.tw': 'opus_mt_tw_fi',
                                           'xx.fi.marian.translate_to.ty': 'opus_mt_ty_fi',
                                           'xx.fi.marian.translate_to.uk': 'opus_mt_uk_fi',
                                           'xx.fi.marian.translate_to.war': 'opus_mt_war_fi',
                                           'xx.fi.marian.translate_to.yo': 'opus_mt_yo_fi',
                                           'xx.fi.marian.translate_to.zh': 'opus_mt_zh_fi',
                                           'xx.fi.marian.translate_to.zne': 'opus_mt_zne_fi',
                                           'xx.fiu.marian.translate_to.en': 'opus_mt_fiu_en',
                                           'xx.fiu.marian.translate_to.fiu': 'opus_mt_fiu_fiu',
                                           'xx.fj.marian.translate_to.de': 'opus_mt_de_fj',
                                           'xx.fj.marian.translate_to.en': 'opus_mt_fj_en',
                                           'xx.fj.marian.translate_to.es': 'opus_mt_es_fj',
                                           'xx.fj.marian.translate_to.fi': 'opus_mt_fi_fj',
                                           'xx.fj.marian.translate_to.fr': 'opus_mt_fr_fj',
                                           'xx.fj.marian.translate_to.sv': 'opus_mt_sv_fj',
                                           'xx.fr.marian.translate_to.af': 'opus_mt_af_fr',
                                           'xx.fr.marian.translate_to.ar': 'opus_mt_ar_fr',
                                           'xx.fr.marian.translate_to.ase': 'opus_mt_ase_fr',
                                           'xx.fr.marian.translate_to.bcl': 'opus_mt_bcl_fr',
                                           'xx.fr.marian.translate_to.bem': 'opus_mt_bem_fr',
                                           'xx.fr.marian.translate_to.ber': 'opus_mt_ber_fr',
                                           'xx.fr.marian.translate_to.bg': 'opus_mt_bg_fr',
                                           'xx.fr.marian.translate_to.bi': 'opus_mt_bi_fr',
                                           'xx.fr.marian.translate_to.bzs': 'opus_mt_bzs_fr',
                                           'xx.fr.marian.translate_to.ca': 'opus_mt_ca_fr',
                                           'xx.fr.marian.translate_to.ceb': 'opus_mt_ceb_fr',
                                           'xx.fr.marian.translate_to.chk': 'opus_mt_chk_fr',
                                           'xx.fr.marian.translate_to.crs': 'opus_mt_crs_fr',
                                           'xx.fr.marian.translate_to.cs': 'opus_mt_cs_fr',
                                           'xx.fr.marian.translate_to.da': 'opus_mt_da_fr',
                                           'xx.fr.marian.translate_to.de': 'opus_mt_de_fr',
                                           'xx.fr.marian.translate_to.ee': 'opus_mt_ee_fr',
                                           'xx.fr.marian.translate_to.efi': 'opus_mt_efi_fr',
                                           'xx.fr.marian.translate_to.el': 'opus_mt_el_fr',
                                           'xx.fr.marian.translate_to.en': 'opus_mt_fr_en',
                                           'xx.fr.marian.translate_to.eo': 'opus_mt_eo_fr',
                                           'xx.fr.marian.translate_to.es': 'opus_mt_es_fr',
                                           'xx.fr.marian.translate_to.et': 'opus_mt_et_fr',
                                           'xx.fr.marian.translate_to.fi': 'opus_mt_fi_fr',
                                           'xx.fr.marian.translate_to.fj': 'opus_mt_fj_fr',
                                           'xx.fr.marian.translate_to.gaa': 'opus_mt_gaa_fr',
                                           'xx.fr.marian.translate_to.gil': 'opus_mt_gil_fr',
                                           'xx.fr.marian.translate_to.guw': 'opus_mt_guw_fr',
                                           'xx.fr.marian.translate_to.ha': 'opus_mt_ha_fr',
                                           'xx.fr.marian.translate_to.hr': 'opus_mt_hr_fr',
                                           'xx.fr.marian.translate_to.ht': 'opus_mt_ht_fr',
                                           'xx.fr.marian.translate_to.hu': 'opus_mt_hu_fr',
                                           'xx.fr.marian.translate_to.id': 'opus_mt_id_fr',
                                           'xx.fr.marian.translate_to.ig': 'opus_mt_ig_fr',
                                           'xx.fr.marian.translate_to.is': 'opus_mt_is_fr',
                                           'xx.fr.marian.translate_to.iso': 'opus_mt_iso_fr',
                                           'xx.fr.marian.translate_to.it': 'opus_mt_it_fr',
                                           'xx.fr.marian.translate_to.ja': 'opus_mt_ja_fr',
                                           'xx.fr.marian.translate_to.kg': 'opus_mt_kg_fr',
                                           'xx.fr.marian.translate_to.ko': 'opus_mt_ko_fr',
                                           'xx.fr.marian.translate_to.kqn': 'opus_mt_kqn_fr',
                                           'xx.fr.marian.translate_to.kwy': 'opus_mt_kwy_fr',
                                           'xx.fr.marian.translate_to.lg': 'opus_mt_lg_fr',
                                           'xx.fr.marian.translate_to.ln': 'opus_mt_ln_fr',
                                           'xx.fr.marian.translate_to.loz': 'opus_mt_loz_fr',
                                           'xx.fr.marian.translate_to.lt': 'opus_mt_lt_fr',
                                           'xx.fr.marian.translate_to.lu': 'opus_mt_lu_fr',
                                           'xx.fr.marian.translate_to.lua': 'opus_mt_lua_fr',
                                           'xx.fr.marian.translate_to.lue': 'opus_mt_lue_fr',
                                           'xx.fr.marian.translate_to.lus': 'opus_mt_lus_fr',
                                           'xx.fr.marian.translate_to.lv': 'opus_mt_lv_fr',
                                           'xx.fr.marian.translate_to.mk': 'opus_mt_mk_fr',
                                           'xx.fr.marian.translate_to.ms': 'opus_mt_ms_fr',
                                           'xx.fr.marian.translate_to.mt': 'opus_mt_mt_fr',
                                           'xx.fr.marian.translate_to.niu': 'opus_mt_niu_fr',
                                           'xx.fr.marian.translate_to.nl': 'opus_mt_nl_fr',
                                           'xx.fr.marian.translate_to.no': 'opus_mt_no_fr',
                                           'xx.fr.marian.translate_to.nso': 'opus_mt_nso_fr',
                                           'xx.fr.marian.translate_to.pap': 'opus_mt_pap_fr',
                                           'xx.fr.marian.translate_to.pis': 'opus_mt_pis_fr',
                                           'xx.fr.marian.translate_to.pl': 'opus_mt_pl_fr',
                                           'xx.fr.marian.translate_to.pon': 'opus_mt_pon_fr',
                                           'xx.fr.marian.translate_to.rn': 'opus_mt_rn_fr',
                                           'xx.fr.marian.translate_to.rnd': 'opus_mt_rnd_fr',
                                           'xx.fr.marian.translate_to.ro': 'opus_mt_ro_fr',
                                           'xx.fr.marian.translate_to.ru': 'opus_mt_ru_fr',
                                           'xx.fr.marian.translate_to.rw': 'opus_mt_rw_fr',
                                           'xx.fr.marian.translate_to.sg': 'opus_mt_sg_fr',
                                           'xx.fr.marian.translate_to.sk': 'opus_mt_sk_fr',
                                           'xx.fr.marian.translate_to.sl': 'opus_mt_sl_fr',
                                           'xx.fr.marian.translate_to.sm': 'opus_mt_sm_fr',
                                           'xx.fr.marian.translate_to.sn': 'opus_mt_sn_fr',
                                           'xx.fr.marian.translate_to.srn': 'opus_mt_srn_fr',
                                           'xx.fr.marian.translate_to.st': 'opus_mt_st_fr',
                                           'xx.fr.marian.translate_to.sv': 'opus_mt_sv_fr',
                                           'xx.fr.marian.translate_to.swc': 'opus_mt_swc_fr',
                                           'xx.fr.marian.translate_to.th': 'opus_mt_th_fr',
                                           'xx.fr.marian.translate_to.tiv': 'opus_mt_tiv_fr',
                                           'xx.fr.marian.translate_to.tll': 'opus_mt_tll_fr',
                                           'xx.fr.marian.translate_to.tn': 'opus_mt_tn_fr',
                                           'xx.fr.marian.translate_to.to': 'opus_mt_to_fr',
                                           'xx.fr.marian.translate_to.toi': 'opus_mt_toi_fr',
                                           'xx.fr.marian.translate_to.tr': 'opus_mt_tr_fr',
                                           'xx.fr.marian.translate_to.ts': 'opus_mt_ts_fr',
                                           'xx.fr.marian.translate_to.tum': 'opus_mt_tum_fr',
                                           'xx.fr.marian.translate_to.tvl': 'opus_mt_tvl_fr',
                                           'xx.fr.marian.translate_to.tw': 'opus_mt_tw_fr',
                                           'xx.fr.marian.translate_to.ty': 'opus_mt_ty_fr',
                                           'xx.fr.marian.translate_to.uk': 'opus_mt_uk_fr',
                                           'xx.fr.marian.translate_to.vi': 'opus_mt_vi_fr',
                                           'xx.fr.marian.translate_to.war': 'opus_mt_war_fr',
                                           'xx.fr.marian.translate_to.wls': 'opus_mt_wls_fr',
                                           'xx.fr.marian.translate_to.xh': 'opus_mt_xh_fr',
                                           'xx.fr.marian.translate_to.yap': 'opus_mt_yap_fr',
                                           'xx.fr.marian.translate_to.yo': 'opus_mt_yo_fr',
                                           'xx.fr.marian.translate_to.zne': 'opus_mt_zne_fr',
                                           'xx.fse.marian.translate_to.fi': 'opus_mt_fi_fse',
                                           'xx.ga.marian.translate_to.en': 'opus_mt_ga_en',
                                           'xx.gaa.marian.translate_to.de': 'opus_mt_de_gaa',
                                           'xx.gaa.marian.translate_to.en': 'opus_mt_gaa_en',
                                           'xx.gaa.marian.translate_to.es': 'opus_mt_es_gaa',
                                           'xx.gaa.marian.translate_to.fi': 'opus_mt_fi_gaa',
                                           'xx.gaa.marian.translate_to.fr': 'opus_mt_fr_gaa',
                                           'xx.gaa.marian.translate_to.sv': 'opus_mt_sv_gaa',
                                           'xx.gem.marian.translate_to.en': 'opus_mt_gem_en',
                                           'xx.gem.marian.translate_to.gem': 'opus_mt_gem_gem',
                                           'xx.gil.marian.translate_to.de': 'opus_mt_de_gil',
                                           'xx.gil.marian.translate_to.en': 'opus_mt_gil_en',
                                           'xx.gil.marian.translate_to.es': 'opus_mt_es_gil',
                                           'xx.gil.marian.translate_to.fi': 'opus_mt_fi_gil',
                                           'xx.gil.marian.translate_to.fr': 'opus_mt_fr_gil',
                                           'xx.gil.marian.translate_to.sv': 'opus_mt_sv_gil',
                                           'xx.gl.marian.translate_to.en': 'opus_mt_gl_en',
                                           'xx.gl.marian.translate_to.es': 'opus_mt_es_gl',
                                           'xx.gl.marian.translate_to.pt': 'opus_mt_pt_gl',
                                           'xx.gmq.marian.translate_to.en': 'opus_mt_gmq_en',
                                           'xx.gmq.marian.translate_to.gmq': 'opus_mt_gmq_gmq',
                                           'xx.gmw.marian.translate_to.en': 'opus_mt_gmw_en',
                                           'xx.gmw.marian.translate_to.gmw': 'opus_mt_gmw_gmw',
                                           'xx.grk.marian.translate_to.en': 'opus_mt_grk_en',
                                           'xx.guw.marian.translate_to.de': 'opus_mt_de_guw',
                                           'xx.guw.marian.translate_to.en': 'opus_mt_guw_en',
                                           'xx.guw.marian.translate_to.es': 'opus_mt_es_guw',
                                           'xx.guw.marian.translate_to.fi': 'opus_mt_fi_guw',
                                           'xx.guw.marian.translate_to.fr': 'opus_mt_fr_guw',
                                           'xx.guw.marian.translate_to.sv': 'opus_mt_sv_guw',
                                           'xx.gv.marian.translate_to.en': 'opus_mt_gv_en',
                                           'xx.ha.marian.translate_to.de': 'opus_mt_de_ha',
                                           'xx.ha.marian.translate_to.en': 'opus_mt_ha_en',
                                           'xx.ha.marian.translate_to.es': 'opus_mt_es_ha',
                                           'xx.ha.marian.translate_to.fi': 'opus_mt_fi_ha',
                                           'xx.ha.marian.translate_to.fr': 'opus_mt_fr_ha',
                                           'xx.ha.marian.translate_to.sv': 'opus_mt_sv_ha',
                                           'xx.he.marian.translate_to.ar': 'opus_mt_ar_he',
                                           'xx.he.marian.translate_to.de': 'opus_mt_de_he',
                                           'xx.he.marian.translate_to.eo': 'opus_mt_eo_he',
                                           'xx.he.marian.translate_to.es': 'opus_mt_es_he',
                                           'xx.he.marian.translate_to.fi': 'opus_mt_fi_he',
                                           'xx.he.marian.translate_to.fr': 'opus_mt_fr_he',
                                           'xx.he.marian.translate_to.it': 'opus_tatoeba_he_it',
                                           'xx.he.marian.translate_to.ja': 'opus_mt_ja_he',
                                           'xx.he.marian.translate_to.ru': 'opus_mt_ru_he',
                                           'xx.he.marian.translate_to.sv': 'opus_mt_sv_he',
                                           'xx.he.marian.translate_to.uk': 'opus_mt_uk_he',
                                           'xx.he.marian.translate_to.zh': 'opus_mt_zh_he',
                                           'xx.he.translate_to.fr': 'opus_tatoeba_he_fr',
                                           'xx.hi.marian.translate_to.en': 'opus_mt_hi_en',
                                           'xx.hil.marian.translate_to.de': 'opus_mt_de_hil',
                                           'xx.hil.marian.translate_to.en': 'opus_mt_hil_en',
                                           'xx.hil.marian.translate_to.es': 'opus_mt_es_hil',
                                           'xx.hil.marian.translate_to.fi': 'opus_mt_fi_hil',
                                           'xx.hil.marian.translate_to.fr': 'opus_mt_fr_hil',
                                           'xx.hil.marian.translate_to.sv': 'opus_mt_sv_hil',
                                           'xx.ho.marian.translate_to.de': 'opus_mt_de_ho',
                                           'xx.ho.marian.translate_to.en': 'opus_mt_ho_en',
                                           'xx.ho.marian.translate_to.es': 'opus_mt_es_ho',
                                           'xx.ho.marian.translate_to.fi': 'opus_mt_fi_ho',
                                           'xx.ho.marian.translate_to.fr': 'opus_mt_fr_ho',
                                           'xx.ho.marian.translate_to.sv': 'opus_mt_sv_ho',
                                           'xx.hr.marian.translate_to.de': 'opus_mt_de_hr',
                                           'xx.hr.marian.translate_to.es': 'opus_mt_es_hr',
                                           'xx.hr.marian.translate_to.fi': 'opus_mt_fi_hr',
                                           'xx.hr.marian.translate_to.fr': 'opus_mt_fr_hr',
                                           'xx.hr.marian.translate_to.sv': 'opus_mt_sv_hr',
                                           'xx.ht.marian.translate_to.de': 'opus_mt_de_ht',
                                           'xx.ht.marian.translate_to.en': 'opus_mt_ht_en',
                                           'xx.ht.marian.translate_to.es': 'opus_mt_es_ht',
                                           'xx.ht.marian.translate_to.fi': 'opus_mt_fi_ht',
                                           'xx.ht.marian.translate_to.fr': 'opus_mt_fr_ht',
                                           'xx.ht.marian.translate_to.sv': 'opus_mt_sv_ht',
                                           'xx.hu.marian.translate_to.de': 'opus_mt_de_hu',
                                           'xx.hu.marian.translate_to.en': 'opus_mt_hu_en',
                                           'xx.hu.marian.translate_to.eo': 'opus_mt_eo_hu',
                                           'xx.hu.marian.translate_to.fi': 'opus_mt_fi_hu',
                                           'xx.hu.marian.translate_to.fr': 'opus_mt_fr_hu',
                                           'xx.hu.marian.translate_to.ja': 'opus_mt_ja_hu',
                                           'xx.hu.marian.translate_to.ko': 'opus_mt_ko_hu',
                                           'xx.hu.marian.translate_to.sv': 'opus_mt_sv_hu',
                                           'xx.hu.marian.translate_to.uk': 'opus_mt_uk_hu',
                                           'xx.hy.marian.translate_to.en': 'opus_mt_hy_en',
                                           'xx.hy.marian.translate_to.ru': 'opus_mt_ru_hy',
                                           'xx.id.marian.translate_to.en': 'opus_mt_id_en',
                                           'xx.id.marian.translate_to.es': 'opus_mt_es_id',
                                           'xx.id.marian.translate_to.fi': 'opus_mt_fi_id',
                                           'xx.id.marian.translate_to.fr': 'opus_mt_fr_id',
                                           'xx.id.marian.translate_to.sv': 'opus_mt_sv_id',
                                           'xx.ig.marian.translate_to.de': 'opus_mt_de_ig',
                                           'xx.ig.marian.translate_to.en': 'opus_mt_ig_en',
                                           'xx.ig.marian.translate_to.es': 'opus_mt_es_ig',
                                           'xx.ig.marian.translate_to.fi': 'opus_mt_fi_ig',
                                           'xx.ig.marian.translate_to.fr': 'opus_mt_fr_ig',
                                           'xx.ig.marian.translate_to.sv': 'opus_mt_sv_ig',
                                           'xx.iir.marian.translate_to.en': 'opus_mt_iir_en',
                                           'xx.iir.marian.translate_to.iir': 'opus_mt_iir_iir',
                                           'xx.ilo.marian.translate_to.de': 'opus_mt_de_ilo',
                                           'xx.ilo.marian.translate_to.en': 'opus_mt_ilo_en',
                                           'xx.ilo.marian.translate_to.es': 'opus_mt_es_ilo',
                                           'xx.ilo.marian.translate_to.fi': 'opus_mt_fi_ilo',
                                           'xx.ilo.marian.translate_to.fr': 'opus_mt_fr_ilo',
                                           'xx.ilo.marian.translate_to.sv': 'opus_mt_sv_ilo',
                                           'xx.inc.marian.translate_to.en': 'opus_mt_inc_en',
                                           'xx.inc.marian.translate_to.inc': 'opus_mt_inc_inc',
                                           'xx.ine.marian.translate_to.en': 'opus_mt_ine_en',
                                           'xx.ine.marian.translate_to.ine': 'opus_mt_ine_ine',
                                           'xx.is.marian.translate_to.de': 'opus_mt_de_is',
                                           'xx.is.marian.translate_to.en': 'opus_mt_is_en',
                                           'xx.is.marian.translate_to.es': 'opus_mt_es_is',
                                           'xx.is.marian.translate_to.fi': 'opus_mt_fi_is',
                                           'xx.is.marian.translate_to.it': 'opus_mt_it_is',
                                           'xx.is.marian.translate_to.sv': 'opus_mt_sv_is',
                                           'xx.iso.marian.translate_to.de': 'opus_mt_de_iso',
                                           'xx.iso.marian.translate_to.en': 'opus_mt_iso_en',
                                           'xx.iso.marian.translate_to.es': 'opus_mt_es_iso',
                                           'xx.iso.marian.translate_to.fi': 'opus_mt_fi_iso',
                                           'xx.iso.marian.translate_to.fr': 'opus_mt_fr_iso',
                                           'xx.iso.marian.translate_to.sv': 'opus_mt_sv_iso',
                                           'xx.it.marian.translate_to.ar': 'opus_mt_ar_it',
                                           'xx.it.marian.translate_to.bg': 'opus_mt_bg_it',
                                           'xx.it.marian.translate_to.ca': 'opus_mt_ca_it',
                                           'xx.it.marian.translate_to.de': 'opus_mt_de_it',
                                           'xx.it.marian.translate_to.en': 'opus_mt_it_en',
                                           'xx.it.marian.translate_to.eo': 'opus_mt_eo_it',
                                           'xx.it.marian.translate_to.es': 'opus_mt_es_it',
                                           'xx.it.marian.translate_to.fi': 'opus_mt_fi_it',
                                           'xx.it.marian.translate_to.he': 'opus_mt_he_it',
                                           'xx.it.marian.translate_to.is': 'opus_mt_is_it',
                                           'xx.it.marian.translate_to.ja': 'opus_mt_ja_it',
                                           'xx.it.marian.translate_to.lt': 'opus_mt_lt_it',
                                           'xx.it.marian.translate_to.ms': 'opus_mt_ms_it',
                                           'xx.it.marian.translate_to.uk': 'opus_mt_uk_it',
                                           'xx.it.marian.translate_to.vi': 'opus_mt_vi_it',
                                           'xx.it.marian.translate_to.zh': 'opus_mt_zh_it',
                                           'xx.it.translate_to.he': 'opus_tatoeba_it_he',
                                           'xx.itc.marian.translate_to.en': 'opus_mt_itc_en',
                                           'xx.itc.marian.translate_to.itc': 'opus_mt_itc_itc',
                                           'xx.ja.marian.translate_to.en': 'opus_mt_ja_en',
                                           'xx.jap.marian.translate_to.en': 'opus_mt_jap_en',
                                           'xx.ka.marian.translate_to.en': 'opus_mt_ka_en',
                                           'xx.kab.marian.translate_to.en': 'opus_mt_kab_en',
                                           'xx.kg.marian.translate_to.de': 'opus_mt_de_kg',
                                           'xx.kg.marian.translate_to.en': 'opus_mt_kg_en',
                                           'xx.kg.marian.translate_to.es': 'opus_mt_es_kg',
                                           'xx.kg.marian.translate_to.fi': 'opus_mt_fi_kg',
                                           'xx.kg.marian.translate_to.fr': 'opus_mt_fr_kg',
                                           'xx.kg.marian.translate_to.sv': 'opus_mt_sv_kg',
                                           'xx.kj.marian.translate_to.en': 'opus_mt_kj_en',
                                           'xx.kl.marian.translate_to.en': 'opus_mt_kl_en',
                                           'xx.ko.marian.translate_to.en': 'opus_mt_ko_en',
                                           'xx.kqn.marian.translate_to.en': 'opus_mt_kqn_en',
                                           'xx.kqn.marian.translate_to.fi': 'opus_mt_fi_kqn',
                                           'xx.kqn.marian.translate_to.fr': 'opus_mt_fr_kqn',
                                           'xx.kqn.marian.translate_to.sv': 'opus_mt_sv_kqn',
                                           'xx.kwn.marian.translate_to.en': 'opus_mt_kwn_en',
                                           'xx.kwy.marian.translate_to.en': 'opus_mt_kwy_en',
                                           'xx.kwy.marian.translate_to.fr': 'opus_mt_fr_kwy',
                                           'xx.kwy.marian.translate_to.sv': 'opus_mt_sv_kwy',
                                           'xx.lg.marian.translate_to.en': 'opus_mt_lg_en',
                                           'xx.lg.marian.translate_to.fi': 'opus_mt_fi_lg',
                                           'xx.lg.marian.translate_to.fr': 'opus_mt_fr_lg',
                                           'xx.lg.marian.translate_to.sv': 'opus_mt_sv_lg',
                                           'xx.ln.marian.translate_to.de': 'opus_mt_de_ln',
                                           'xx.ln.marian.translate_to.en': 'opus_mt_ln_en',
                                           'xx.ln.marian.translate_to.es': 'opus_mt_es_ln',
                                           'xx.ln.marian.translate_to.fi': 'opus_mt_fi_ln',
                                           'xx.ln.marian.translate_to.fr': 'opus_mt_fr_ln',
                                           'xx.ln.marian.translate_to.sv': 'opus_mt_sv_ln',
                                           'xx.loz.marian.translate_to.de': 'opus_mt_de_loz',
                                           'xx.loz.marian.translate_to.en': 'opus_mt_loz_en',
                                           'xx.loz.marian.translate_to.es': 'opus_mt_es_loz',
                                           'xx.loz.marian.translate_to.fr': 'opus_mt_fr_loz',
                                           'xx.lt.marian.translate_to.de': 'opus_mt_de_lt',
                                           'xx.lt.marian.translate_to.es': 'opus_mt_es_lt',
                                           'xx.lt.marian.translate_to.it': 'opus_mt_it_lt',
                                           'xx.lt.marian.translate_to.pl': 'opus_mt_pl_lt',
                                           'xx.lt.marian.translate_to.ru': 'opus_mt_ru_lt',
                                           'xx.lt.marian.translate_to.tr': 'opus_mt_tr_lt',
                                           'xx.lu.marian.translate_to.en': 'opus_mt_lu_en',
                                           'xx.lu.marian.translate_to.fi': 'opus_mt_fi_lu',
                                           'xx.lu.marian.translate_to.fr': 'opus_mt_fr_lu',
                                           'xx.lu.marian.translate_to.sv': 'opus_mt_sv_lu',
                                           'xx.lua.marian.translate_to.de': 'opus_mt_de_lua',
                                           'xx.lua.marian.translate_to.en': 'opus_mt_lua_en',
                                           'xx.lua.marian.translate_to.es': 'opus_mt_es_lua',
                                           'xx.lua.marian.translate_to.fi': 'opus_mt_fi_lua',
                                           'xx.lua.marian.translate_to.fr': 'opus_mt_fr_lua',
                                           'xx.lua.marian.translate_to.sv': 'opus_mt_sv_lua',
                                           'xx.lue.marian.translate_to.en': 'opus_mt_lue_en',
                                           'xx.lue.marian.translate_to.fi': 'opus_mt_fi_lue',
                                           'xx.lue.marian.translate_to.fr': 'opus_mt_fr_lue',
                                           'xx.lue.marian.translate_to.sv': 'opus_mt_sv_lue',
                                           'xx.lun.marian.translate_to.en': 'opus_mt_lun_en',
                                           'xx.luo.marian.translate_to.en': 'opus_mt_luo_en',
                                           'xx.lus.marian.translate_to.en': 'opus_mt_lus_en',
                                           'xx.lus.marian.translate_to.es': 'opus_mt_es_lus',
                                           'xx.lus.marian.translate_to.fi': 'opus_mt_fi_lus',
                                           'xx.lus.marian.translate_to.fr': 'opus_mt_fr_lus',
                                           'xx.lus.marian.translate_to.sv': 'opus_mt_sv_lus',
                                           'xx.lv.marian.translate_to.en': 'opus_mt_lv_en',
                                           'xx.lv.marian.translate_to.fi': 'opus_mt_fi_lv',
                                           'xx.lv.marian.translate_to.ru': 'opus_mt_ru_lv',
                                           'xx.lv.marian.translate_to.sv': 'opus_mt_sv_lv',
                                           'xx.marian': 'opus_mt_en_fr',
                                           'xx.mfe.marian.translate_to.en': 'opus_mt_mfe_en',
                                           'xx.mfe.marian.translate_to.fi': 'opus_mt_fi_mfe',
                                           'xx.mfe.marian.translate_to.fr': 'opus_mt_fr_mfe',
                                           'xx.mfe.marian.translate_to.sv': 'opus_mt_sv_mfe',
                                           'xx.mfs.marian.translate_to.es': 'opus_mt_es_mfs',
                                           'xx.mg.marian.translate_to.en': 'opus_mt_mg_en',
                                           'xx.mg.marian.translate_to.fi': 'opus_mt_fi_mg',
                                           'xx.mh.marian.translate_to.en': 'opus_mt_mh_en',
                                           'xx.mh.marian.translate_to.fi': 'opus_mt_fi_mh',
                                           'xx.mh.marian.translate_to.fr': 'opus_mt_fr_mh',
                                           'xx.mh.marian.translate_to.sv': 'opus_mt_sv_mh',
                                           'xx.mk.marian.translate_to.en': 'opus_mt_mk_en',
                                           'xx.mk.marian.translate_to.es': 'opus_mt_es_mk',
                                           'xx.mk.marian.translate_to.fi': 'opus_mt_fi_mk',
                                           'xx.mkh.marian.translate_to.en': 'opus_mt_mkh_en',
                                           'xx.ml.marian.translate_to.en': 'opus_mt_ml_en',
                                           'xx.mos.marian.translate_to.en': 'opus_mt_mos_en',
                                           'xx.mos.marian.translate_to.fi': 'opus_mt_fi_mos',
                                           'xx.mos.marian.translate_to.fr': 'opus_mt_fr_mos',
                                           'xx.mos.marian.translate_to.sv': 'opus_mt_sv_mos',
                                           'xx.mr.marian.translate_to.en': 'opus_mt_mr_en',
                                           'xx.ms.marian.translate_to.de': 'opus_mt_de_ms',
                                           'xx.ms.marian.translate_to.fr': 'opus_mt_fr_ms',
                                           'xx.ms.marian.translate_to.it': 'opus_mt_it_ms',
                                           'xx.ms.marian.translate_to.ja': 'opus_mt_ja_ms',
                                           'xx.ms.marian.translate_to.ms': 'opus_mt_ms_ms',
                                           'xx.ms.marian.translate_to.zh': 'opus_mt_zh_ms',
                                           'xx.mt.marian.translate_to.de': 'opus_mt_de_mt',
                                           'xx.mt.marian.translate_to.en': 'opus_mt_mt_en',
                                           'xx.mt.marian.translate_to.es': 'opus_mt_es_mt',
                                           'xx.mt.marian.translate_to.fi': 'opus_mt_fi_mt',
                                           'xx.mt.marian.translate_to.fr': 'opus_mt_fr_mt',
                                           'xx.mt.marian.translate_to.sv': 'opus_mt_sv_mt',
                                           'xx.mul.marian.translate_to.en': 'opus_mt_mul_en',
                                           'xx.ner.high_resourced_lang': 'xlm_roberta_large_token_classifier_hrl',
                                           'xx.ner.masakhaner': 'xlm_roberta_large_token_classifier_masakhaner',
                                           'xx.ner.masakhaner.distilbert': 'distilbert_base_token_classifier_masakhaner',
                                           'xx.ner.masakhaner.xlm_roberta': 'xlm_roberta_large_token_classifier_masakhaner',
                                           'xx.ner.scandinavian': 'bert_token_classifier_scandi_ner',
                                           'xx.ner.wikiner_glove_840B_300': 'ner_wikiner_glove_840B_300',
                                           'xx.ner.wikiner_xlm_roberta_base': 'ner_wikiner_xlm_roberta_base',
                                           'xx.ner.xtreme_glove_840B_300': 'ner_xtreme_glove_840B_300',
                                           'xx.ner.xtreme_xlm_roberta_xtreme_base': 'ner_xtreme_xlm_roberta_xtreme_base',
                                           'xx.ng.marian.translate_to.en': 'opus_mt_ng_en',
                                           'xx.nic.marian.translate_to.en': 'opus_mt_nic_en',
                                           'xx.niu.marian.translate_to.de': 'opus_mt_de_niu',
                                           'xx.niu.marian.translate_to.en': 'opus_mt_niu_en',
                                           'xx.niu.marian.translate_to.es': 'opus_mt_es_niu',
                                           'xx.niu.marian.translate_to.fi': 'opus_mt_fi_niu',
                                           'xx.niu.marian.translate_to.fr': 'opus_mt_fr_niu',
                                           'xx.niu.marian.translate_to.sv': 'opus_mt_sv_niu',
                                           'xx.nl.marian.translate_to.af': 'opus_mt_af_nl',
                                           'xx.nl.marian.translate_to.ca': 'opus_mt_ca_nl',
                                           'xx.nl.marian.translate_to.de': 'opus_mt_de_nl',
                                           'xx.nl.marian.translate_to.en': 'opus_mt_nl_en',
                                           'xx.nl.marian.translate_to.eo': 'opus_mt_eo_nl',
                                           'xx.nl.marian.translate_to.es': 'opus_mt_es_nl',
                                           'xx.nl.marian.translate_to.fi': 'opus_mt_fi_nl',
                                           'xx.nl.marian.translate_to.ja': 'opus_mt_ja_nl',
                                           'xx.nl.marian.translate_to.no': 'opus_mt_no_nl',
                                           'xx.nl.marian.translate_to.sv': 'opus_mt_sv_nl',
                                           'xx.nl.marian.translate_to.uk': 'opus_mt_uk_nl',
                                           'xx.nl.marian.translate_to.zh': 'opus_mt_zh_nl',
                                           'xx.no.marian.translate_to.da': 'opus_mt_da_no',
                                           'xx.no.marian.translate_to.de': 'opus_mt_de_no',
                                           'xx.no.marian.translate_to.es': 'opus_mt_es_no',
                                           'xx.no.marian.translate_to.fi': 'opus_mt_fi_no',
                                           'xx.no.marian.translate_to.fr': 'opus_mt_fr_no',
                                           'xx.no.marian.translate_to.nl': 'opus_mt_nl_no',
                                           'xx.no.marian.translate_to.no': 'opus_mt_no_no',
                                           'xx.no.marian.translate_to.pl': 'opus_mt_pl_no',
                                           'xx.no.marian.translate_to.ru': 'opus_mt_ru_no',
                                           'xx.no.marian.translate_to.sv': 'opus_mt_sv_no',
                                           'xx.no.marian.translate_to.uk': 'opus_mt_uk_no',
                                           'xx.nso.marian.translate_to.de': 'opus_mt_de_nso',
                                           'xx.nso.marian.translate_to.en': 'opus_mt_nso_en',
                                           'xx.nso.marian.translate_to.es': 'opus_mt_es_nso',
                                           'xx.nso.marian.translate_to.fi': 'opus_mt_fi_nso',
                                           'xx.nso.marian.translate_to.fr': 'opus_mt_fr_nso',
                                           'xx.nso.marian.translate_to.sv': 'opus_mt_sv_nso',
                                           'xx.ny.marian.translate_to.de': 'opus_mt_de_ny',
                                           'xx.ny.marian.translate_to.en': 'opus_mt_ny_en',
                                           'xx.ny.marian.translate_to.es': 'opus_mt_es_ny',
                                           'xx.ny.marian.translate_to.fi': 'opus_mt_fi_ny',
                                           'xx.ny.marian.translate_to.fr': 'opus_mt_fr_ny',
                                           'xx.ny.marian.translate_to.sv': 'opus_mt_sv_ny',
                                           'xx.nyk.marian.translate_to.en': 'opus_mt_nyk_en',
                                           'xx.om.marian.translate_to.en': 'opus_mt_om_en',
                                           'xx.pa.marian.translate_to.en': 'opus_mt_pa_en',
                                           'xx.pag.marian.translate_to.de': 'opus_mt_de_pag',
                                           'xx.pag.marian.translate_to.en': 'opus_mt_pag_en',
                                           'xx.pag.marian.translate_to.es': 'opus_mt_es_pag',
                                           'xx.pag.marian.translate_to.fi': 'opus_mt_fi_pag',
                                           'xx.pag.marian.translate_to.fr': 'opus_mt_fr_pag',
                                           'xx.pag.marian.translate_to.sv': 'opus_mt_sv_pag',
                                           'xx.pap.marian.translate_to.de': 'opus_mt_de_pap',
                                           'xx.pap.marian.translate_to.en': 'opus_mt_pap_en',
                                           'xx.pap.marian.translate_to.es': 'opus_mt_es_pap',
                                           'xx.pap.marian.translate_to.fi': 'opus_mt_fi_pap',
                                           'xx.pap.marian.translate_to.fr': 'opus_mt_fr_pap',
                                           'xx.pap.marian.translate_to.sv': 'opus_mt_sv_pap',
                                           'xx.phi.marian.translate_to.en': 'opus_mt_phi_en',
                                           'xx.pis.marian.translate_to.de': 'opus_mt_de_pis',
                                           'xx.pis.marian.translate_to.en': 'opus_mt_pis_en',
                                           'xx.pis.marian.translate_to.es': 'opus_mt_es_pis',
                                           'xx.pis.marian.translate_to.fi': 'opus_mt_fi_pis',
                                           'xx.pis.marian.translate_to.fr': 'opus_mt_fr_pis',
                                           'xx.pis.marian.translate_to.sv': 'opus_mt_sv_pis',
                                           'xx.pl.marian.translate_to.ar': 'opus_mt_ar_pl',
                                           'xx.pl.marian.translate_to.de': 'opus_mt_de_pl',
                                           'xx.pl.marian.translate_to.en': 'opus_mt_pl_en',
                                           'xx.pl.marian.translate_to.eo': 'opus_mt_eo_pl',
                                           'xx.pl.marian.translate_to.es': 'opus_mt_es_pl',
                                           'xx.pl.marian.translate_to.fr': 'opus_mt_fr_pl',
                                           'xx.pl.marian.translate_to.ja': 'opus_mt_ja_pl',
                                           'xx.pl.marian.translate_to.lt': 'opus_mt_lt_pl',
                                           'xx.pl.marian.translate_to.no': 'opus_mt_no_pl',
                                           'xx.pl.marian.translate_to.uk': 'opus_mt_uk_pl',
                                           'xx.pon.marian.translate_to.de': 'opus_mt_de_pon',
                                           'xx.pon.marian.translate_to.en': 'opus_mt_pon_en',
                                           'xx.pon.marian.translate_to.es': 'opus_mt_es_pon',
                                           'xx.pon.marian.translate_to.fi': 'opus_mt_fi_pon',
                                           'xx.pon.marian.translate_to.fr': 'opus_mt_fr_pon',
                                           'xx.pon.marian.translate_to.sv': 'opus_mt_sv_pon',
                                           'xx.pqe.marian.translate_to.en': 'opus_mt_pqe_en',
                                           'xx.prl.marian.translate_to.es': 'opus_mt_es_prl',
                                           'xx.pt.marian.translate_to.ca': 'opus_mt_ca_pt',
                                           'xx.pt.marian.translate_to.eo': 'opus_mt_eo_pt',
                                           'xx.pt.marian.translate_to.gl': 'opus_mt_gl_pt',
                                           'xx.pt.marian.translate_to.ja': 'opus_mt_ja_pt',
                                           'xx.pt.marian.translate_to.tl': 'opus_mt_tl_pt',
                                           'xx.pt.marian.translate_to.uk': 'opus_mt_uk_pt',
                                           'xx.rn.marian.translate_to.en': 'opus_mt_rn_en',
                                           'xx.rn.marian.translate_to.es': 'opus_mt_es_rn',
                                           'xx.rnd.marian.translate_to.en': 'opus_mt_rnd_en',
                                           'xx.rnd.marian.translate_to.fr': 'opus_mt_fr_rnd',
                                           'xx.rnd.marian.translate_to.sv': 'opus_mt_sv_rnd',
                                           'xx.ro.marian.translate_to.eo': 'opus_mt_eo_ro',
                                           'xx.ro.marian.translate_to.es': 'opus_mt_es_ro',
                                           'xx.ro.marian.translate_to.fi': 'opus_mt_fi_ro',
                                           'xx.ro.marian.translate_to.fr': 'opus_mt_fr_ro',
                                           'xx.ro.marian.translate_to.sv': 'opus_mt_sv_ro',
                                           'xx.roa.marian.translate_to.en': 'opus_mt_roa_en',
                                           'xx.ru.marian.translate_to.af': 'opus_mt_af_ru',
                                           'xx.ru.marian.translate_to.ar': 'opus_mt_ar_ru',
                                           'xx.ru.marian.translate_to.bg': 'opus_mt_bg_ru',
                                           'xx.ru.marian.translate_to.da': 'opus_mt_da_ru',
                                           'xx.ru.marian.translate_to.en': 'opus_mt_ru_en',
                                           'xx.ru.marian.translate_to.eo': 'opus_mt_eo_ru',
                                           'xx.ru.marian.translate_to.es': 'opus_mt_es_ru',
                                           'xx.ru.marian.translate_to.et': 'opus_mt_et_ru',
                                           'xx.ru.marian.translate_to.eu': 'opus_mt_eu_ru',
                                           'xx.ru.marian.translate_to.fi': 'opus_mt_fi_ru',
                                           'xx.ru.marian.translate_to.fr': 'opus_mt_fr_ru',
                                           'xx.ru.marian.translate_to.he': 'opus_mt_he_ru',
                                           'xx.ru.marian.translate_to.hy': 'opus_mt_hy_ru',
                                           'xx.ru.marian.translate_to.ja': 'opus_mt_ja_ru',
                                           'xx.ru.marian.translate_to.ka': 'opus_mt_ka_ru',
                                           'xx.ru.marian.translate_to.ko': 'opus_mt_ko_ru',
                                           'xx.ru.marian.translate_to.lt': 'opus_mt_lt_ru',
                                           'xx.ru.marian.translate_to.lv': 'opus_mt_lv_ru',
                                           'xx.ru.marian.translate_to.no': 'opus_mt_no_ru',
                                           'xx.ru.marian.translate_to.rn': 'opus_mt_rn_ru',
                                           'xx.ru.marian.translate_to.sl': 'opus_mt_sl_ru',
                                           'xx.ru.marian.translate_to.sv': 'opus_mt_sv_ru',
                                           'xx.ru.marian.translate_to.uk': 'opus_mt_uk_ru',
                                           'xx.ru.marian.translate_to.vi': 'opus_mt_vi_ru',
                                           'xx.run.marian.translate_to.en': 'opus_mt_run_en',
                                           'xx.run.marian.translate_to.fi': 'opus_mt_fi_run',
                                           'xx.run.marian.translate_to.fr': 'opus_mt_fr_run',
                                           'xx.run.marian.translate_to.sv': 'opus_mt_sv_run',
                                           'xx.rw.marian.translate_to.en': 'opus_mt_rw_en',
                                           'xx.rw.marian.translate_to.es': 'opus_mt_es_rw',
                                           'xx.rw.marian.translate_to.fi': 'opus_mt_fi_rw',
                                           'xx.rw.marian.translate_to.fr': 'opus_mt_fr_rw',
                                           'xx.rw.marian.translate_to.sv': 'opus_mt_sv_rw',
                                           'xx.sal.marian.translate_to.en': 'opus_mt_sal_en',
                                           'xx.sem.marian.translate_to.en': 'opus_mt_sem_en',
                                           'xx.sem.marian.translate_to.sem': 'opus_mt_sem_sem',
                                           'xx.sentence_detector': 'sentence_detector_dl',
                                           'xx.sg.marian.translate_to.en': 'opus_mt_sg_en',
                                           'xx.sg.marian.translate_to.es': 'opus_mt_es_sg',
                                           'xx.sg.marian.translate_to.fi': 'opus_mt_fi_sg',
                                           'xx.sg.marian.translate_to.fr': 'opus_mt_fr_sg',
                                           'xx.sg.marian.translate_to.sv': 'opus_mt_sv_sg',
                                           'xx.sh.marian.translate_to.eo': 'opus_mt_eo_sh',
                                           'xx.sh.marian.translate_to.ja': 'opus_mt_ja_sh',
                                           'xx.sh.marian.translate_to.uk': 'opus_mt_uk_sh',
                                           'xx.sk.marian.translate_to.en': 'opus_mt_sk_en',
                                           'xx.sk.marian.translate_to.fi': 'opus_mt_fi_sk',
                                           'xx.sk.marian.translate_to.fr': 'opus_mt_fr_sk',
                                           'xx.sk.marian.translate_to.sv': 'opus_mt_sv_sk',
                                           'xx.sl.marian.translate_to.es': 'opus_mt_es_sl',
                                           'xx.sl.marian.translate_to.fi': 'opus_mt_fi_sl',
                                           'xx.sl.marian.translate_to.fr': 'opus_mt_fr_sl',
                                           'xx.sl.marian.translate_to.ru': 'opus_mt_ru_sl',
                                           'xx.sl.marian.translate_to.sv': 'opus_mt_sv_sl',
                                           'xx.sl.marian.translate_to.uk': 'opus_mt_uk_sl',
                                           'xx.sla.marian.translate_to.en': 'opus_mt_sla_en',
                                           'xx.sla.marian.translate_to.sla': 'opus_mt_sla_sla',
                                           'xx.sm.marian.translate_to.en': 'opus_mt_sm_en',
                                           'xx.sm.marian.translate_to.es': 'opus_mt_es_sm',
                                           'xx.sm.marian.translate_to.fi': 'opus_mt_fi_sm',
                                           'xx.sm.marian.translate_to.fr': 'opus_mt_fr_sm',
                                           'xx.sm.marian.translate_to.sv': 'opus_mt_sv_sm',
                                           'xx.sn.marian.translate_to.en': 'opus_mt_sn_en',
                                           'xx.sn.marian.translate_to.es': 'opus_mt_es_sn',
                                           'xx.sn.marian.translate_to.fi': 'opus_mt_fi_sn',
                                           'xx.sn.marian.translate_to.fr': 'opus_mt_fr_sn',
                                           'xx.sn.marian.translate_to.sv': 'opus_mt_sv_sn',
                                           'xx.sq.marian.translate_to.en': 'opus_mt_sq_en',
                                           'xx.sq.marian.translate_to.fi': 'opus_mt_fi_sq',
                                           'xx.sq.marian.translate_to.sv': 'opus_mt_sv_sq',
                                           'xx.srn.marian.translate_to.en': 'opus_mt_srn_en',
                                           'xx.srn.marian.translate_to.es': 'opus_mt_es_srn',
                                           'xx.srn.marian.translate_to.fi': 'opus_mt_fi_srn',
                                           'xx.srn.marian.translate_to.fr': 'opus_mt_fr_srn',
                                           'xx.srn.marian.translate_to.sv': 'opus_mt_sv_srn',
                                           'xx.ss.marian.translate_to.en': 'opus_mt_ss_en',
                                           'xx.st.marian.translate_to.en': 'opus_mt_st_en',
                                           'xx.st.marian.translate_to.es': 'opus_mt_es_st',
                                           'xx.st.marian.translate_to.fi': 'opus_mt_fi_st',
                                           'xx.st.marian.translate_to.fr': 'opus_mt_fr_st',
                                           'xx.st.marian.translate_to.sv': 'opus_mt_sv_st',
                                           'xx.sv.marian.translate_to.af': 'opus_mt_af_sv',
                                           'xx.sv.marian.translate_to.am': 'opus_mt_am_sv',
                                           'xx.sv.marian.translate_to.ase': 'opus_mt_ase_sv',
                                           'xx.sv.marian.translate_to.bcl': 'opus_mt_bcl_sv',
                                           'xx.sv.marian.translate_to.bem': 'opus_mt_bem_sv',
                                           'xx.sv.marian.translate_to.bg': 'opus_mt_bg_sv',
                                           'xx.sv.marian.translate_to.bi': 'opus_mt_bi_sv',
                                           'xx.sv.marian.translate_to.bzs': 'opus_mt_bzs_sv',
                                           'xx.sv.marian.translate_to.ceb': 'opus_mt_ceb_sv',
                                           'xx.sv.marian.translate_to.chk': 'opus_mt_chk_sv',
                                           'xx.sv.marian.translate_to.crs': 'opus_mt_crs_sv',
                                           'xx.sv.marian.translate_to.ee': 'opus_mt_ee_sv',
                                           'xx.sv.marian.translate_to.efi': 'opus_mt_efi_sv',
                                           'xx.sv.marian.translate_to.el': 'opus_mt_el_sv',
                                           'xx.sv.marian.translate_to.en': 'opus_mt_sv_en',
                                           'xx.sv.marian.translate_to.eo': 'opus_mt_eo_sv',
                                           'xx.sv.marian.translate_to.et': 'opus_mt_et_sv',
                                           'xx.sv.marian.translate_to.fi': 'opus_mt_fi_sv',
                                           'xx.sv.marian.translate_to.fr': 'opus_mt_fr_sv',
                                           'xx.sv.marian.translate_to.gaa': 'opus_mt_gaa_sv',
                                           'xx.sv.marian.translate_to.gil': 'opus_mt_gil_sv',
                                           'xx.sv.marian.translate_to.guw': 'opus_mt_guw_sv',
                                           'xx.sv.marian.translate_to.ha': 'opus_mt_ha_sv',
                                           'xx.sv.marian.translate_to.he': 'opus_mt_he_sv',
                                           'xx.sv.marian.translate_to.hr': 'opus_mt_hr_sv',
                                           'xx.sv.marian.translate_to.ht': 'opus_mt_ht_sv',
                                           'xx.sv.marian.translate_to.hu': 'opus_mt_hu_sv',
                                           'xx.sv.marian.translate_to.id': 'opus_mt_id_sv',
                                           'xx.sv.marian.translate_to.ig': 'opus_mt_ig_sv',
                                           'xx.sv.marian.translate_to.ilo': 'opus_mt_ilo_sv',
                                           'xx.sv.marian.translate_to.is': 'opus_mt_is_sv',
                                           'xx.sv.marian.translate_to.iso': 'opus_mt_iso_sv',
                                           'xx.sv.marian.translate_to.it': 'opus_mt_it_sv',
                                           'xx.sv.marian.translate_to.ja': 'opus_mt_ja_sv',
                                           'xx.sv.marian.translate_to.kg': 'opus_mt_kg_sv',
                                           'xx.sv.marian.translate_to.ko': 'opus_mt_ko_sv',
                                           'xx.sv.marian.translate_to.kqn': 'opus_mt_kqn_sv',
                                           'xx.sv.marian.translate_to.kwy': 'opus_mt_kwy_sv',
                                           'xx.sv.marian.translate_to.lg': 'opus_mt_lg_sv',
                                           'xx.sv.marian.translate_to.loz': 'opus_mt_loz_sv',
                                           'xx.sv.marian.translate_to.lt': 'opus_mt_lt_sv',
                                           'xx.sv.marian.translate_to.lu': 'opus_mt_lu_sv',
                                           'xx.sv.marian.translate_to.lua': 'opus_mt_lua_sv',
                                           'xx.sv.marian.translate_to.lue': 'opus_mt_lue_sv',
                                           'xx.sv.marian.translate_to.lus': 'opus_mt_lus_sv',
                                           'xx.sv.marian.translate_to.lv': 'opus_mt_lv_sv',
                                           'xx.sv.marian.translate_to.mt': 'opus_mt_mt_sv',
                                           'xx.sv.marian.translate_to.niu': 'opus_mt_niu_sv',
                                           'xx.sv.marian.translate_to.nl': 'opus_mt_nl_sv',
                                           'xx.sv.marian.translate_to.no': 'opus_mt_no_sv',
                                           'xx.sv.marian.translate_to.nso': 'opus_mt_nso_sv',
                                           'xx.sv.marian.translate_to.pag': 'opus_mt_pag_sv',
                                           'xx.sv.marian.translate_to.pis': 'opus_mt_pis_sv',
                                           'xx.sv.marian.translate_to.pl': 'opus_mt_pl_sv',
                                           'xx.sv.marian.translate_to.pon': 'opus_mt_pon_sv',
                                           'xx.sv.marian.translate_to.rnd': 'opus_mt_rnd_sv',
                                           'xx.sv.marian.translate_to.ro': 'opus_mt_ro_sv',
                                           'xx.sv.marian.translate_to.ru': 'opus_mt_ru_sv',
                                           'xx.sv.marian.translate_to.run': 'opus_mt_run_sv',
                                           'xx.sv.marian.translate_to.rw': 'opus_mt_rw_sv',
                                           'xx.sv.marian.translate_to.sg': 'opus_mt_sg_sv',
                                           'xx.sv.marian.translate_to.sk': 'opus_mt_sk_sv',
                                           'xx.sv.marian.translate_to.sl': 'opus_mt_sl_sv',
                                           'xx.sv.marian.translate_to.sn': 'opus_mt_sn_sv',
                                           'xx.sv.marian.translate_to.sq': 'opus_mt_sq_sv',
                                           'xx.sv.marian.translate_to.srn': 'opus_mt_srn_sv',
                                           'xx.sv.marian.translate_to.st': 'opus_mt_st_sv',
                                           'xx.sv.marian.translate_to.sv': 'opus_mt_sv_sv',
                                           'xx.sv.marian.translate_to.swc': 'opus_mt_swc_sv',
                                           'xx.sv.marian.translate_to.tiv': 'opus_mt_tiv_sv',
                                           'xx.sv.marian.translate_to.tll': 'opus_mt_tll_sv',
                                           'xx.sv.marian.translate_to.tn': 'opus_mt_tn_sv',
                                           'xx.sv.marian.translate_to.to': 'opus_mt_to_sv',
                                           'xx.sv.marian.translate_to.toi': 'opus_mt_toi_sv',
                                           'xx.sv.marian.translate_to.tpi': 'opus_mt_tpi_sv',
                                           'xx.sv.marian.translate_to.tr': 'opus_mt_tr_sv',
                                           'xx.sv.marian.translate_to.ts': 'opus_mt_ts_sv',
                                           'xx.sv.marian.translate_to.tum': 'opus_mt_tum_sv',
                                           'xx.sv.marian.translate_to.tvl': 'opus_mt_tvl_sv',
                                           'xx.sv.marian.translate_to.tw': 'opus_mt_tw_sv',
                                           'xx.sv.marian.translate_to.ty': 'opus_mt_ty_sv',
                                           'xx.sv.marian.translate_to.uk': 'opus_mt_uk_sv',
                                           'xx.sv.marian.translate_to.war': 'opus_mt_war_sv',
                                           'xx.sv.marian.translate_to.wls': 'opus_mt_wls_sv',
                                           'xx.sv.marian.translate_to.xh': 'opus_mt_xh_sv',
                                           'xx.sv.marian.translate_to.yap': 'opus_mt_yap_sv',
                                           'xx.sv.marian.translate_to.yo': 'opus_mt_yo_sv',
                                           'xx.sv.marian.translate_to.zh': 'opus_mt_zh_sv',
                                           'xx.sv.marian.translate_to.zne': 'opus_mt_zne_sv',
                                           'xx.sw.marian.translate_to.fi': 'opus_mt_fi_sw',
                                           'xx.swc.marian.translate_to.en': 'opus_mt_swc_en',
                                           'xx.swc.marian.translate_to.es': 'opus_mt_es_swc',
                                           'xx.swc.marian.translate_to.fi': 'opus_mt_fi_swc',
                                           'xx.swc.marian.translate_to.fr': 'opus_mt_fr_swc',
                                           'xx.swc.marian.translate_to.sv': 'opus_mt_sv_swc',
                                           'xx.taw.marian.translate_to.en': 'opus_mt_taw_en',
                                           'xx.th.marian.translate_to.en': 'opus_mt_th_en',
                                           'xx.th.marian.translate_to.sv': 'opus_mt_sv_th',
                                           'xx.ti.marian.translate_to.en': 'opus_mt_ti_en',
                                           'xx.tiv.marian.translate_to.en': 'opus_mt_tiv_en',
                                           'xx.tiv.marian.translate_to.fi': 'opus_mt_fi_tiv',
                                           'xx.tiv.marian.translate_to.fr': 'opus_mt_fr_tiv',
                                           'xx.tiv.marian.translate_to.sv': 'opus_mt_sv_tiv',
                                           'xx.tl.marian.translate_to.de': 'opus_mt_de_tl',
                                           'xx.tl.marian.translate_to.en': 'opus_mt_tl_en',
                                           'xx.tl.marian.translate_to.es': 'opus_mt_es_tl',
                                           'xx.tl.marian.translate_to.fr': 'opus_mt_fr_tl',
                                           'xx.tl.marian.translate_to.pt': 'opus_mt_pt_tl',
                                           'xx.tll.marian.translate_to.en': 'opus_mt_tll_en',
                                           'xx.tll.marian.translate_to.es': 'opus_mt_es_tll',
                                           'xx.tll.marian.translate_to.fi': 'opus_mt_fi_tll',
                                           'xx.tll.marian.translate_to.fr': 'opus_mt_fr_tll',
                                           'xx.tll.marian.translate_to.sv': 'opus_mt_sv_tll',
                                           'xx.tn.marian.translate_to.en': 'opus_mt_tn_en',
                                           'xx.tn.marian.translate_to.es': 'opus_mt_es_tn',
                                           'xx.tn.marian.translate_to.fi': 'opus_mt_fi_tn',
                                           'xx.tn.marian.translate_to.fr': 'opus_mt_fr_tn',
                                           'xx.tn.marian.translate_to.sv': 'opus_mt_sv_tn',
                                           'xx.to.marian.translate_to.en': 'opus_mt_to_en',
                                           'xx.to.marian.translate_to.es': 'opus_mt_es_to',
                                           'xx.to.marian.translate_to.fi': 'opus_mt_fi_to',
                                           'xx.to.marian.translate_to.fr': 'opus_mt_fr_to',
                                           'xx.to.marian.translate_to.sv': 'opus_mt_sv_to',
                                           'xx.toi.marian.translate_to.en': 'opus_mt_toi_en',
                                           'xx.toi.marian.translate_to.fi': 'opus_mt_fi_toi',
                                           'xx.toi.marian.translate_to.sv': 'opus_mt_sv_toi',
                                           'xx.tpi.marian.translate_to.en': 'opus_mt_tpi_en',
                                           'xx.tpi.marian.translate_to.es': 'opus_mt_es_tpi',
                                           'xx.tpi.marian.translate_to.fi': 'opus_mt_fi_tpi',
                                           'xx.tpi.marian.translate_to.fr': 'opus_mt_fr_tpi',
                                           'xx.tpi.marian.translate_to.sv': 'opus_mt_sv_tpi',
                                           'xx.tr.marian.translate_to.ar': 'opus_mt_ar_tr',
                                           'xx.tr.marian.translate_to.az': 'opus_mt_az_tr',
                                           'xx.tr.marian.translate_to.bg': 'opus_mt_bg_tr',
                                           'xx.tr.marian.translate_to.en': 'opus_mt_tr_en',
                                           'xx.tr.marian.translate_to.fi': 'opus_mt_fi_tr',
                                           'xx.tr.marian.translate_to.ja': 'opus_mt_ja_tr',
                                           'xx.tr.marian.translate_to.lt': 'opus_mt_lt_tr',
                                           'xx.tr.marian.translate_to.uk': 'opus_mt_uk_tr',
                                           'xx.trk.marian.translate_to.en': 'opus_mt_trk_en',
                                           'xx.ts.marian.translate_to.en': 'opus_mt_ts_en',
                                           'xx.ts.marian.translate_to.fi': 'opus_mt_fi_ts',
                                           'xx.ts.marian.translate_to.fr': 'opus_mt_fr_ts',
                                           'xx.ts.marian.translate_to.sv': 'opus_mt_sv_ts',
                                           'xx.tum.marian.translate_to.en': 'opus_mt_tum_en',
                                           'xx.tum.marian.translate_to.fr': 'opus_mt_fr_tum',
                                           'xx.tum.marian.translate_to.sv': 'opus_mt_sv_tum',
                                           'xx.tvl.marian.translate_to.en': 'opus_mt_tvl_en',
                                           'xx.tvl.marian.translate_to.es': 'opus_mt_es_tvl',
                                           'xx.tvl.marian.translate_to.fi': 'opus_mt_fi_tvl',
                                           'xx.tvl.marian.translate_to.fr': 'opus_mt_fr_tvl',
                                           'xx.tvl.marian.translate_to.sv': 'opus_mt_sv_tvl',
                                           'xx.tw.marian.translate_to.es': 'opus_mt_es_tw',
                                           'xx.tw.marian.translate_to.fi': 'opus_mt_fi_tw',
                                           'xx.tw.marian.translate_to.fr': 'opus_mt_fr_tw',
                                           'xx.tw.marian.translate_to.sv': 'opus_mt_sv_tw',
                                           'xx.ty.marian.translate_to.es': 'opus_mt_es_ty',
                                           'xx.ty.marian.translate_to.fi': 'opus_mt_fi_ty',
                                           'xx.ty.marian.translate_to.fr': 'opus_mt_fr_ty',
                                           'xx.ty.marian.translate_to.sv': 'opus_mt_sv_ty',
                                           'xx.tzo.marian.translate_to.es': 'opus_mt_es_tzo',
                                           'xx.uk.marian.translate_to.bg': 'opus_mt_bg_uk',
                                           'xx.uk.marian.translate_to.ca': 'opus_mt_ca_uk',
                                           'xx.uk.marian.translate_to.cs': 'opus_mt_cs_uk',
                                           'xx.uk.marian.translate_to.de': 'opus_mt_de_uk',
                                           'xx.uk.marian.translate_to.en': 'opus_mt_uk_en',
                                           'xx.uk.marian.translate_to.es': 'opus_mt_es_uk',
                                           'xx.uk.marian.translate_to.fi': 'opus_mt_fi_uk',
                                           'xx.uk.marian.translate_to.fr': 'opus_mt_fr_uk',
                                           'xx.uk.marian.translate_to.he': 'opus_mt_he_uk',
                                           'xx.uk.marian.translate_to.hu': 'opus_mt_hu_uk',
                                           'xx.uk.marian.translate_to.it': 'opus_mt_it_uk',
                                           'xx.uk.marian.translate_to.nl': 'opus_mt_nl_uk',
                                           'xx.uk.marian.translate_to.no': 'opus_mt_no_uk',
                                           'xx.uk.marian.translate_to.pl': 'opus_mt_pl_uk',
                                           'xx.uk.marian.translate_to.pt': 'opus_mt_pt_uk',
                                           'xx.uk.marian.translate_to.ru': 'opus_mt_ru_uk',
                                           'xx.uk.marian.translate_to.sh': 'opus_mt_sh_uk',
                                           'xx.uk.marian.translate_to.sl': 'opus_mt_sl_uk',
                                           'xx.uk.marian.translate_to.sv': 'opus_mt_sv_uk',
                                           'xx.uk.marian.translate_to.tr': 'opus_mt_tr_uk',
                                           'xx.uk.marian.translate_to.zh': 'opus_mt_zh_uk',
                                           'xx.umb.marian.translate_to.en': 'opus_mt_umb_en',
                                           'xx.umb.marian.translate_to.sv': 'opus_mt_sv_umb',
                                           'xx.ur.marian.translate_to.en': 'opus_mt_ur_en',
                                           'xx.ur.marian.translate_to.hi': 'opus_mt_hi_ur',
                                           'xx.urj.marian.translate_to.en': 'opus_mt_urj_en',
                                           'xx.urj.marian.translate_to.urj': 'opus_mt_urj_urj',
                                           'xx.use.multi': 'tfhub_use_multi',
                                           'xx.use.multi_lg': 'tfhub_use_multi_lg',
                                           'xx.ve.marian.translate_to.en': 'opus_mt_ve_en',
                                           'xx.ve.marian.translate_to.es': 'opus_mt_es_ve',
                                           'xx.ve.marian.translate_to.fi': 'opus_mt_fi_ve',
                                           'xx.ve.marian.translate_to.fr': 'opus_mt_fr_ve',
                                           'xx.ve.marian.translate_to.sv': 'opus_mt_sv_ve',
                                           'xx.vi.marian.translate_to.de': 'opus_mt_de_vi',
                                           'xx.vi.marian.translate_to.en': 'opus_mt_vi_en',
                                           'xx.vi.marian.translate_to.es': 'opus_mt_es_vi',
                                           'xx.vi.marian.translate_to.fr': 'opus_mt_fr_vi',
                                           'xx.vi.marian.translate_to.it': 'opus_mt_it_vi',
                                           'xx.vi.marian.translate_to.ja': 'opus_mt_ja_vi',
                                           'xx.vi.marian.translate_to.ru': 'opus_mt_ru_vi',
                                           'xx.vi.marian.translate_to.zh': 'opus_mt_zh_vi',
                                           'xx.wa.marian.translate_to.en': 'opus_mt_wa_en',
                                           'xx.wal.marian.translate_to.en': 'opus_mt_wal_en',
                                           'xx.war.marian.translate_to.en': 'opus_mt_war_en',
                                           'xx.war.marian.translate_to.es': 'opus_mt_es_war',
                                           'xx.war.marian.translate_to.fi': 'opus_mt_fi_war',
                                           'xx.war.marian.translate_to.fr': 'opus_mt_fr_war',
                                           'xx.war.marian.translate_to.sv': 'opus_mt_sv_war',
                                           'xx.wls.marian.translate_to.en': 'opus_mt_wls_en',
                                           'xx.wls.marian.translate_to.es': 'opus_mt_es_wls',
                                           'xx.wls.marian.translate_to.fi': 'opus_mt_fi_wls',
                                           'xx.wls.marian.translate_to.fr': 'opus_mt_fr_wls',
                                           'xx.wls.marian.translate_to.sv': 'opus_mt_sv_wls',
                                           'xx.xh.marian.translate_to.en': 'opus_mt_xh_en',
                                           'xx.xh.marian.translate_to.es': 'opus_mt_es_xh',
                                           'xx.xh.marian.translate_to.fi': 'opus_mt_fi_xh',
                                           'xx.xh.marian.translate_to.fr': 'opus_mt_fr_xh',
                                           'xx.xh.marian.translate_to.sv': 'opus_mt_sv_xh',
                                           'xx.yap.marian.translate_to.en': 'opus_mt_yap_en',
                                           'xx.yap.marian.translate_to.fi': 'opus_mt_fi_yap',
                                           'xx.yap.marian.translate_to.fr': 'opus_mt_fr_yap',
                                           'xx.yap.marian.translate_to.sv': 'opus_mt_sv_yap',
                                           'xx.yo.marian.translate_to.en': 'opus_mt_yo_en',
                                           'xx.yo.marian.translate_to.es': 'opus_mt_es_yo',
                                           'xx.yo.marian.translate_to.fi': 'opus_mt_fi_yo',
                                           'xx.yo.marian.translate_to.fr': 'opus_mt_fr_yo',
                                           'xx.yo.marian.translate_to.sv': 'opus_mt_sv_yo',
                                           'xx.yua.marian.translate_to.es': 'opus_mt_es_yua',
                                           'xx.zai.marian.translate_to.es': 'opus_mt_es_zai',
                                           'xx.zh.marian.translate_to.en': 'opus_mt_zh_en',
                                           'xx.zle.marian.translate_to.en': 'opus_mt_zle_en',
                                           'xx.zle.marian.translate_to.zle': 'opus_mt_zle_zle',
                                           'xx.zls.marian.translate_to.en': 'opus_mt_zls_en',
                                           'xx.zls.marian.translate_to.zls': 'opus_mt_zls_zls',
                                           'xx.zlw.marian.translate_to.en': 'opus_mt_zlw_en',
                                           'xx.zlw.marian.translate_to.zlw': 'opus_mt_zlw_zlw',
                                           'xx.zne.marian.translate_to.fi': 'opus_mt_fi_zne',
                                           'xx.zne.marian.translate_to.fr': 'opus_mt_fr_zne',
                                           'xx.zne.marian.translate_to.sv': 'opus_mt_sv_zne'},
                                    'yi': {'yi.detect_sentence': 'sentence_detector_dl',
                                           'yi.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'yo': {'yo.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'yo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_yoruba',
                                           'yo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_yoruba',
                                           'yo.lemma': 'lemma',
                                           'yo.pos': 'pos_ud_ytb',
                                           'yo.stopwords': 'stopwords_yo'},
                                    'zea': {'zea.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'zh': {'zh.answer_question.bert': 'bert_qa_question_answering_chinese',
                                           'zh.answer_question.bert.base': 'bert_qa_chinese_pert_base_mrc',
                                           'zh.answer_question.bert.base.by_hfl': 'bert_qa_chinese_pert_base_mrc',
                                           'zh.answer_question.bert.base.by_jackh1995': 'bert_qa_roberta_base_chinese_extractive_qa_scratch',
                                           'zh.answer_question.bert.base.by_liam168': 'bert_qa_qa_roberta_base_chinese_extractive',
                                           'zh.answer_question.bert.base.by_uer': 'bert_qa_roberta_base_chinese_extractive_qa',
                                           'zh.answer_question.bert.by_jackh1995': 'bert_qa_bert_chinese_finetuned',
                                           'zh.answer_question.bert.by_yechen': 'bert_qa_question_answering_chinese',
                                           'zh.answer_question.bert.large': 'bert_qa_chinese_pert_large_open_domain_mrc',
                                           'zh.answer_question.bert.large.by_hfl': 'bert_qa_chinese_pert_large_mrc',
                                           'zh.answer_question.bert.large.by_luhua': 'bert_qa_chinese_pretrain_mrc_roberta_wwm_ext_large',
                                           'zh.answer_question.bert.large.by_qalover': 'bert_qa_chinese_pert_large_open_domain_mrc',
                                           'zh.answer_question.bert.multilingual_base_cased': 'bert_qa_multilingual_bert_base_cased_chinese',
                                           'zh.answer_question.mac_bert.large': 'bert_qa_chinese_pretrain_mrc_macbert_large',
                                           'zh.answer_question.squad.bert.base': 'bert_qa_bert_base_chinese_finetuned_squad_colab',
                                           'zh.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_chinese',
                                           'zh.embed': 'bert_base_chinese',
                                           'zh.embed.bert': 'bert_base_chinese',
                                           'zh.embed.bert.wwm': 'chinese_bert_wwm',
                                           'zh.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                           'zh.embed.bert_base_chinese_jinyong': 'bert_embeddings_bert_base_chinese_jinyong',
                                           'zh.embed.bert_base_zh_cased': 'bert_embeddings_bert_base_zh_cased',
                                           'zh.embed.bert_large_chinese': 'bert_embeddings_bert_large_chinese',
                                           'zh.embed.chinese_bert_wwm_ext': 'bert_embeddings_chinese_bert_wwm_ext',
                                           'zh.embed.chinese_macbert_base': 'bert_embeddings_chinese_macbert_base',
                                           'zh.embed.chinese_macbert_large': 'bert_embeddings_chinese_macbert_large',
                                           'zh.embed.chinese_roberta_wwm_ext': 'bert_embeddings_chinese_roberta_wwm_ext',
                                           'zh.embed.chinese_roberta_wwm_ext_large': 'bert_embeddings_chinese_roberta_wwm_ext_large',
                                           'zh.embed.chinese_roberta_wwm_large_ext_fix_mlm': 'bert_embeddings_chinese_roberta_wwm_large_ext_fix_mlm',
                                           'zh.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_zh_cased',
                                           'zh.embed.env_bert_chinese': 'bert_embeddings_env_bert_chinese',
                                           'zh.embed.jdt_fin_roberta_wwm': 'bert_embeddings_jdt_fin_roberta_wwm',
                                           'zh.embed.jdt_fin_roberta_wwm_large': 'bert_embeddings_jdt_fin_roberta_wwm_large',
                                           'zh.embed.macbert4csc_base_chinese': 'bert_embeddings_macbert4csc_base_chinese',
                                           'zh.embed.mengzi_bert_base': 'bert_embeddings_mengzi_bert_base',
                                           'zh.embed.mengzi_bert_base_fin': 'bert_embeddings_mengzi_bert_base_fin',
                                           'zh.embed.mengzi_oscar_base': 'bert_embeddings_mengzi_oscar_base',
                                           'zh.embed.mengzi_oscar_base_caption': 'bert_embeddings_mengzi_oscar_base_caption',
                                           'zh.embed.mengzi_oscar_base_retrieval': 'bert_embeddings_mengzi_oscar_base_retrieval',
                                           'zh.embed.rbt3': 'bert_embeddings_rbt3',
                                           'zh.embed.rbt4': 'bert_embeddings_rbt4',
                                           'zh.embed.rbt6': 'bert_embeddings_rbt6',
                                           'zh.embed.rbtl3': 'bert_embeddings_rbtl3',
                                           'zh.embed.roberta_base_wechsel_chinese': 'roberta_embeddings_roberta_base_wechsel_chinese',
                                           'zh.embed.sikubert': 'bert_embeddings_sikubert',
                                           'zh.embed.sikuroberta': 'bert_embeddings_sikuroberta',
                                           'zh.embed.uer_large': 'bert_embeddings_uer_large',
                                           'zh.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'zh.embed.wobert_chinese_base': 'bert_embeddings_wobert_chinese_base',
                                           'zh.embed.wobert_chinese_plus': 'bert_embeddings_wobert_chinese_plus',
                                           'zh.embed.wobert_chinese_plus_base': 'bert_embeddings_wobert_chinese_plus_base',
                                           'zh.embed.xlnet': 'chinese_xlnet_base',
                                           'zh.lemma': 'lemma',
                                           'zh.lemma.gsd': 'lemma_gsd',
                                           'zh.lemma.gsdsimp': 'lemma_gsdsimp',
                                           'zh.ner': 'ner_msra_bert_768d',
                                           'zh.ner.bert': 'ner_msra_bert_768d',
                                           'zh.ner.bert_token': 'bert_token_classifier_chinese_ner',
                                           'zh.ner.msra.bert_768D': 'ner_msra_bert_768d',
                                           'zh.ner.weibo.bert_768d': 'ner_weibo_bert_768d',
                                           'zh.pos': 'pos_gsdsimp',
                                           'zh.pos.bert_base_chinese_pos': 'bert_pos_bert_base_chinese_pos',
                                           'zh.pos.chinese_bert_wwm_ext_upos': 'bert_pos_chinese_bert_wwm_ext_upos',
                                           'zh.pos.chinese_roberta_base_upos': 'bert_pos_chinese_roberta_base_upos',
                                           'zh.pos.chinese_roberta_large_upos': 'bert_pos_chinese_roberta_large_upos',
                                           'zh.pos.gsd': 'pos_gsd',
                                           'zh.pos.gsdsimp': 'pos_gsdsimp',
                                           'zh.pos.ud_gsd': 'pos_ud_gsd',
                                           'zh.pos.ud_gsd_trad': 'pos_ud_gsd_trad',
                                           'zh.segment_words': 'wordseg_weibo',
                                           'zh.segment_words.ctb9': 'wordseg_ctb9',
                                           'zh.segment_words.gsd': 'wordseg_gsd_ud_trad',
                                           'zh.segment_words.large': 'wordseg_large',
                                           'zh.segment_words.msra': 'wordseg_msra',
                                           'zh.segment_words.pku': 'wordseg_pku',
                                           'zh.segment_words.weibo': 'wordseg_weibo',
                                           'zh.stopwords': 'stopwords_iso',
                                           'zh.tokenize': 'wordseg_weibo'},
                                    'zu': {'zu.stopwords': 'stopwords_zu'}}

    healthcare_component_alias_references = {}
    pretrained_healthcare_pipe_references = {
        'en': {
            'en.med_ner.profiling_clinical': 'ner_profiling_clinical',
            'en.med_ner.profiling_biobert': 'ner_profiling_biobert',
            'en.icd10cm.umls.mapping': 'icd10cm_umls_mapping',
            'en.mesh.umls.mapping': 'mesh_umls_mapping',
            'en.rxnorm.umls.mapping': 'rxnorm_umls_mapping',
            'en.snomed.umls.mapping': 'snomed_umls_mapping',

            'en.map_entity.icd10cm_to_snomed.pipe': 'icd10cm_snomed_mapping',
            'en.map_entity.snomed_to_icd10cm.pipe': 'snomed_icd10cm_mapping',
            'en.map_entity.icdo_to_snomed.pipe': 'icdo_snomed_mapping',
            'en.map_entity.snomed_to_icdo.pipe': 'snomed_icdo_mapping',
            'en.map_entity.rxnorm_to_ndc.pipe': 'rxnorm_ndc_mapping',

            # '' :'clinical_analysis', # Not 3+ compatible
            # '' :'clinical_deidentification', # todo to big ner consumer stack for NLU to handle..
            # '' :'clinical_ner_assertion', Not 3+ compatible
            'en.med_ner.pathogen.pipeline': 'ner_pathogen_pipeline',
            'en.med_ner.biomedical_bc2gm.pipeline': 'ner_biomedical_bc2gm_pipeline',
            'en.med_ner.clinical_trials_abstracts.pipe': 'ner_clinical_trials_abstracts_pipeline',

            # Explain Pipes
            'en.explain_doc.carp': 'explain_clinical_doc_carp',
            'en.explain_doc.era': 'explain_clinical_doc_era',
            # 'en.explain_doc.ade':'explain_clinical_doc_ade', # todo wierd 2x Converter 1x NER component_list, messes up component_list logic

            'en.recognize_entities.posology': 'recognize_entities_posology',  # PIPE

        },
        'fr': {
            'fr.deid_obfuscated': 'clinical_deidentification'  # need finisher support first

        },
        'ro':
            {
                'ro.deid.clinical': 'clinical_deidentification',

            }
    }
    pretrained_healthcare_model_references = {
        'fr': {
            'fr.med_ner.deid_generic': 'ner_deid_generic',
            'fr.med_ner.deid_subentity': 'ner_deid_subentity',
            # 4.0.0
            'fr.med_ner.living_species': 'ner_living_species',
            'fr.med_ner.living_species.bert': 'ner_living_species_bert'

        },
        'it':
            {
                'it.med_ner.deid_generic': 'ner_deid_generic',
                'it.med_ner.deid_subentity': 'ner_deid_subentity',

                # 4.0.0
                'it.med_ner.living_species': 'bert_token_classifier_ner_living_species',
                'it.med_ner.living_species.bert': 'ner_living_species_bert',
                'it.med_ner.living_species': 'ner_living_species'

            },
        'en':
            {

                # 4.0.0

                'en.map_entity.snomed_to_icd10cm': 'snomed_icd10cm_mapper',
                'en.map_entity.icd10cm_to_snomed': 'icd10cm_snomed_mapper',
                'en.map_entity.snomed_to_icdo': 'snomed_icdo_mapper',
                'en.map_entity.icdo_to_snomed': 'icdo_snomed_mapper',
                'en.map_entity.rxnorm_to_umls': 'rxnorm_umls_mapper',
                'en.map_entity.icd10cm_to_umls': 'icd10cm_umls_mapper',
                'en.map_entity.mesh_to_umls': 'mesh_umls_mapper',
                'en.map_entity.snomed_to_umls': 'snomed_umls_mapper',

                'en.ner.clinical_trials_abstracts': 'ner_clinical_trials_abstracts',
                'en.med_ner.clinical_trials_abstracts': 'bert_token_classifier_ner_clinical_trials_abstracts',
                'en.med_ner.pathogen': 'ner_pathogen',
                'en.med_ner.living_species.token_bert': 'bert_token_classifier_ner_living_species',
                'en.med_ner.living_species': 'ner_living_species',
                'en.med_ner.living_species.biobert': 'ner_living_species_biobert',
                'en.classify.stress': 'bert_sequence_classifier_stress',
                # 3.4.3
                'en.relation.zeroshot_biobert': 're_zeroshot_biobert',

                # 3.4.2
                'en.med_ner.clinical_trials': 'bert_sequence_classifier_rct_biobert',

                # 3.4.1
                'en.med_ner.supplement_clinical': 'ner_supplement_clinical',
                'en.resolve.rxnorm.augmented_re': 'sbiobertresolve_rxnorm_augmented_re',
                'en.classify.ade.seq_biobert': 'bert_sequence_classifier_ade',
                'en.classify.gender.seq_biobert': 'bert_sequence_classifier_gender_biobert',
                'en.classify.pico.seq_biobert': 'bert_sequence_classifier_pico_biobert',
                'en.classify.ade.seq_distilbert': 'distilbert_sequence_classifier_ade',
                'en.relation.temporal_events_clinical': 're_temporal_events_clinical',
                'en.relation.adverse_drug_events.clinical': 're_ade_clinical',
                'en.relation.adverse_drug_events.clinical.biobert': 'redl_ade_biobert',

                # 3.4.0
                'en.med_ner.abbreviation_clinical': 'ner_abbreviation_clinical',
                'en.med_ner.drugprot_clinical': 'ner_drugprot_clinical',
                'en.ner.drug_development_trials': 'bert_token_classifier_drug_development_trials',
                'en.med_ner.chemprot.bert': 'bert_token_classifier_ner_chemprot',
                'en.relation.drugprot': 'redl_drugprot_biobert',
                'en.relation.drugprot.clinical': 're_drugprot_clinical',
                'en.resolve.clinical_abbreviation_acronym': 'sbiobertresolve_clinical_abbreviation_acronym',
                'en.resolve.umls_drug_substance': 'sbiobertresolve_umls_drug_substance',
                'en.resolve.loinc_cased': 'sbiobertresolve_loinc_cased',
                'en.resolve.loinc_uncased': 'sbluebertresolve_loinc_uncased',
                'en.embed_sentence.biobert.rxnorm': 'sbiobert_jsl_rxnorm_cased',
                'en.embed_sentence.bert_uncased.rxnorm': 'sbert_jsl_medium_rxnorm_uncased',
                'en.resolve.snomed_drug': 'sbiobertresolve_snomed_drug',

                # clinical spellchecker
                'en.spell.clinical': 'spellcheck_clinical',  # todo crashing
                # 'en.spell.med':        'context_spell_med', #todo crashing
                # 'en.spell.context.med':'context_spell_med', #todo crashing Byteerror

                # 3.3.0 Healthcare
                'en.spell.drug_norvig': 'spellcheck_drug_norvig',
                'en.classify.token_bert.ner_bacteria': 'bert_token_classifier_ner_bacteria',
                'en.classify.token_bert.ner_anatomy': 'bert_token_classifier_ner_anatomy',
                'en.classify.token_bert.ner_drugs': 'bert_token_classifier_ner_drugs',
                'en.classify.token_bert.ner_jsl_slim': 'bert_token_classifier_ner_jsl_slim',
                'en.classify.token_bert.ner_ade': 'bert_token_classifier_ner_ade',
                'en.resolve.rxnorm_ndc': 'sbiobertresolve_rxnorm_ndc',
                'en.resolve.icd10cm_generalised': 'sbiobertresolve_icd10cm_generalised',
                'en.resolve.hcpcs': 'sbiobertresolve_hcpcs',
                'en.med_ner.chexpert': 'ner_chexpert',

                # 3.2.3 Healthcare
                'en.classify.token_bert.ner_deid': 'bert_token_classifier_ner_deid',

                'en.detect_sentence.clinical': 'sentence_detector_dl_healthcare',
                'en.norm_drugs': 'drug_normalizer',  # TODO!?!??!
                # T5
                'en.t5.mediqa': 't5_base_mediqa_mnli',

                # AssertionDLModel
                'en.assert': 'assertion_dl',
                'en.assert.biobert': 'assertion_dl_biobert',
                'en.assert.healthcare': 'assertion_dl_healthcare',
                'en.assert.large': 'assertion_dl_large',

                # 2.7.6
                'en.assert.radiology': 'assertion_dl_radiology',

                # WordEmbedding Model Glove Embeddings
                'en.embed.glove.clinical': 'embeddings_clinical',
                'en.embed.glove.biovec': 'embeddings_biovec',
                'en.embed.glove.healthcare': 'embeddings_healthcare',
                'en.embed.glove.healthcare_100d': 'embeddings_healthcare_100d',
                # 'en.embed.glove.icd10': 'embeddings_icd10_base', # Broken in JSL
                'en.embed.glove.icdoem': 'embeddings_icdoem',
                'en.embed.glove.icdoem_2ng': 'embeddings_icdoem_2ng',

                # 3.1.1
                'en.embed_sentence.biobert.jsl_cased': 'sbiobert_jsl_cased',
                'en.embed_sentence.biobert.jsl_umls_cased': 'sbiobert_jsl_umls_cased',
                'en.embed_sentence.bert.jsl_medium_uncased': 'sbert_jsl_medium_uncased',
                'en.embed_sentence.bert.jsl_medium_umls_uncased': 'sbert_jsl_medium_umls_uncased',
                'en.embed_sentence.bert.jsl_mini_uncased': 'sbert_jsl_mini_uncased',
                'en.embed_sentence.bert.jsl_mini_umlsuncased': 'sbert_jsl_mini_umls_uncased',
                'en.embed_sentence.bert.jsl_tiny_uncased': 'sbert_jsl_tiny_uncased',
                'en.embed_sentence.bert.jsl_tiny_umls_uncased': 'sbert_jsl_tiny_umls_uncased',

                # BIOBERT embeddings

                # Todo errors with biobert embeds
                # 'en.embed.biobert.clinical': 'biobert_clinical_base_cased', # broken
                # 'en.embed.biobert.discharge': 'biobert_discharge_base_cased',# broken
                # 'en.embed.biobert.pmc': 'biobert_pmc_base_cased', Broken
                # 'en.embed.biobert.pubmed': 'biobert_pubmed_base_cased', # broken
                # 'en.embed.biobert.pubmed_large': 'biobert_pubmed_large_cased', # broken
                # 'en.embed.biobert.pubmed_pmc': 'biobert_pubmed_pmc_base_cased', # broken

                # Sentence Entity resolvers

                # BertSEntenceEmbeddings MLI
                'en.embed_sentence.biobert.mli': 'sbiobert_base_cased_mli',
                'en.embed_sentence.bluebert.mli': 'sbluebert_base_uncased_mli',  # Broken

                # 'en.embed_sentence.bluebert.mednli': 'sent_bluebert_base_uncased_mednli', # broken  : java.util.NoSuchElementException: Param isSBert does not exist.
                # 'en.embed_sentence.biobert.mednli': 'sent_biobert_base_uncased_mednli',  # broken

                # resolve sentence cpt
                'en.resolve': 'sbiobertresolve_cpt',
                'en.resolve.cpt': 'sbiobertresolve_cpt',
                'en.resolve.cpt.augmented': 'sbiobertresolve_cpt_augmented',
                'en.resolve.cpt.procedures_augmented': 'sbiobertresolve_cpt_procedures_augmented',
                # resolve sentence hcc
                'en.resolve.hcc': 'sbiobertresolve_hcc_augmented',
                'en.resolve.hcc.augmented': 'sbiobertresolve_hcc_augmented',
                # resolve sentence icdf
                'en.resolve.icd10cm': 'sbiobertresolve_icd10cm',
                'en.resolve.icd10cm.augmented': 'sbiobertresolve_icd10cm_augmented',
                'en.resolve.icd10cm.augmented_billable': 'sbiobertresolve_icd10cm_augmented_billable_hcc',
                'en.resolve.icd10pcs': 'sbiobertresolve_icd10pcs',
                'en.resolve.icdo': 'sbiobertresolve_icdo',
                # rewsolve sentence rx
                'en.resolve.rxcui': 'sbiobertresolve_rxcui',
                'en.resolve.rxnorm': 'sbiobertresolve_rxnorm',
                # resolve sentence snomed s
                'en.resolve.snomed': 'sbiobertresolve_snomed_auxConcepts',  # alias
                'en.resolve.snomed.aux_concepts': 'sbiobertresolve_snomed_auxConcepts',
                'en.resolve.snomed.aux_concepts_int': 'sbiobertresolve_snomed_auxConcepts_int',
                'en.resolve.snomed.findings': 'sbiobertresolve_snomed_findings',
                'en.resolve.snomed.findings_int': 'sbiobertresolve_snomed_findings_int',
                'en.resolve.cpt.procedures_measurements': 'sbiobertresolve_cpt_procedures_measurements_augmented',
                'en.resolve.icdo.base': 'sbiobertresolve_icdo_base',
                'en.resolve.rxnorm.disposition': 'sbertresolve_rxnorm_disposition',
                'en.resolve.rxnorm.disposition.sbert': 'sbertresolve_rxnorm_disposition',

                # 3.1.1
                'en.resolve.snomed_body_structure_med': 'sbertresolve_snomed_bodyStructure_med',
                'en.resolve.snomed_body_structure': 'sbiobertresolve_snomed_bodyStructure',
                'en.resolve.icdo_augmented': 'sbiobertresolve_icdo_augmented',

                'en.resolve.icd10cm.slim_billable_hcc': 'sbiobertresolve_icd10cm_slim_billable_hcc',
                'en.resolve.icd10cm.slim_billable_hcc_med': 'sbertresolve_icd10cm_slim_billable_hcc_med',

                # Greedy Relation extracction
                # 'en.relation.posology': 'posology_re',  # TODo OCRASHES SOME STRINGS!

                # RelationExtractionModel

                # These biobert analogus models which are better or some are broken
                # 'en.relation':'re_clinical',
                # 'en.relation.bodypart.direction':'re_bodypart_directions',
                # 'en.relation.bodypart.problem':'re_bodypart_problem',
                # 'en.relation.bodypart.proceduretest':'re_bodypart_proceduretest',
                # 'en.relation.chemprot':'re_chemprot_clinical',
                # 'en.relation.clinical':'re_clinical',
                # 'en.relation.date_clinical':'re_date_clinical',
                # 'en.relation.drug_drug_interaction':'re_drug_drug_interaction_clinical',
                # 'en.relation.human_phenotype_gene':'re_human_phenotype_gene_clinical',
                # 'en.relation.temporal_events':'re_temporal_events_clinical',
                # 'en.relation.temporal_events.enriched':'re_temporal_events_enriched_clinical',
                # RelationExtractionDL

                'en.relation': 'redl_bodypart_direction_biobert',
                'en.relation.bodypart.direction': 'redl_bodypart_direction_biobert',
                'en.relation.bodypart.problem': 'redl_bodypart_problem_biobert',
                'en.relation.bodypart.procedure': 'redl_bodypart_procedure_test_biobert',
                'en.relation.chemprot': 'redl_chemprot_biobert',
                'en.relation.clinical': 'redl_clinical_biobert',
                'en.relation.date': 'redl_date_clinical_biobert',
                'en.relation.drug_drug_interaction': 'redl_drug_drug_interaction_biobert',
                'en.relation.humen_phenotype_gene': 'redl_human_phenotype_gene_biobert',
                'en.relation.temporal_events': 'redl_temporal_events_biobert',

                # 2.7.5
                'en.relation.test_result_date': 're_test_result_date',
                # 2.7.3
                # 'en.relation.chemport'   :'re_chemprot',

                # PartOfSpeechModels
                'en.pos.clinical': 'pos_clinical',  # DEFAULT POS HC|| RELATION EXTRACTION TRAIN ON THIS!

                # NERDLModels
                # 'en.med_ner.ade.biobert':'ner_ade_biobert', # Todo error param pooling layer does not exist
                'en.med_ner': 'jsl_ner_wip_clinical',
                'en.med_ner.ade.clinical': 'ner_ade_clinical',
                'en.med_ner.ade.clinical_bert': 'ner_ade_clinicalbert',
                'en.med_ner.ade.ade_healthcare': 'ner_ade_healthcare',
                'en.med_ner.anatomy': 'ner_anatomy',
                'en.med_ner.anatomy.biobert': 'ner_anatomy_biobert',
                'en.med_ner.anatomy.coarse': 'ner_anatomy_coarse',
                'en.med_ner.anatomy.coarse_biobert': 'ner_anatomy_coarse_biobert',
                'en.med_ner.aspect_sentiment': 'ner_aspect_based_sentiment',
                'en.med_ner.bacterial_species': 'ner_bacterial_species',
                'en.med_ner.bionlp': 'ner_bionlp',
                'en.med_ner.bionlp.biobert': 'ner_bionlp_biobert',
                'en.med_ner.cancer': 'ner_cancer_genetics',
                'en.med_ner.cellular': 'ner_cellular',
                'en.med_ner.cellular.biobert': 'ner_cellular_biobert',
                'en.med_ner.chemicals': 'ner_chemicals',
                'en.med_ner.genetic_variants': 'ner_genetic_variants',
                'en.med_ner.chemprot': 'ner_chemprot_biobert',
                'en.med_ner.chemprot.clinical': 'ner_chemprot_clinical',
                'en.med_ner.clinical': 'ner_clinical',
                'en.med_ner.clinical.biobert': 'ner_clinical_biobert',
                # 'en.med_ner.clinical.noncontrib': 'ner_clinical_noncontrib', # outtaded, NER model_anno_obj it is not MedNER
                'en.med_ner.diseases': 'ner_diseases',
                'en.med_ner.diseases.biobert': 'ner_diseases_biobert',
                'en.med_ner.diseases.large': 'ner_diseases_large',
                'en.med_ner.drugs': 'ner_drugs',
                'en.med_ner.drugsgreedy': 'ner_drugs_greedy',
                'en.med_ner.drugs.large': 'ner_drugs_large',
                'en.med_ner.events_biobert': 'ner_events_biobert',
                'en.med_ner.events_clinical': 'ner_events_clinical',
                'en.med_ner.events_healthcre': 'ner_events_healthcare',
                'en.med_ner.financial_contract': 'ner_financial_contract',
                'en.med_ner.healthcare': 'ner_healthcare',
                'en.med_ner.human_phenotype.gene_biobert': 'ner_human_phenotype_gene_biobert',
                'en.med_ner.human_phenotype.gene_clinical': 'ner_human_phenotype_gene_clinical',
                'en.med_ner.human_phenotype.go_biobert': 'ner_human_phenotype_go_biobert',
                'en.med_ner.human_phenotype.go_clinical': 'ner_human_phenotype_go_clinical',
                'en.med_ner.jsl': 'ner_jsl',
                'en.med_ner.jsl.biobert': 'ner_jsl_biobert',
                'en.med_ner.jsl.enriched': 'ner_jsl_enriched',
                'en.med_ner.jsl.enriched_biobert': 'ner_jsl_enriched_biobert',
                'en.med_ner.measurements': 'ner_measurements_clinical',
                'en.med_ner.medmentions': 'ner_medmentions_coarse',
                'en.med_ner.posology': 'ner_posology',
                'en.med_ner.posology.biobert': 'ner_posology_biobert',
                'en.med_ner.posology.greedy': 'ner_posology_greedy',
                'en.med_ner.posology.healthcare': 'ner_posology_healthcare',
                'en.med_ner.posology.large': 'ner_posology_large',
                'en.med_ner.posology.large_biobert': 'ner_posology_large_biobert',
                'en.med_ner.posology.small': 'ner_posology_small',
                'en.med_ner.radiology': 'ner_radiology',
                'en.med_ner.radiology.wip_clinical': 'ner_radiology_wip_clinical',
                'en.med_ner.risk_factors': 'ner_risk_factors',
                'en.med_ner.risk_factors.biobert': 'ner_risk_factors_biobert',
                'en.med_ner.posology.experimental': 'ner_posology_experimental',
                'en.med_ner.radiology.wip_greedy_biobert': 'jsl_rd_ner_wip_greedy_biobert',

                # 'en.med_ner.i2b2': 'nerdl_i2b2', #  broken
                'en.med_ner.tumour': 'nerdl_tumour_demo',
                'en.med_ner.jsl.wip.clinical': 'jsl_ner_wip_clinical',
                'en.med_ner.jsl.wip.clinical.greedy': 'jsl_ner_wip_greedy_clinical',
                'en.med_ner.jsl.wip.clinical.modifier': 'jsl_ner_wip_modifier_clinical',
                'en.med_ner.jsl.wip.clinical.rd': 'jsl_rd_ner_wip_greedy_clinical',
                'en.med_ner.deid.augmented': 'ner_deid_augmented',
                'en.med_ner.deid.biobert': 'ner_deid_biobert',
                'en.med_ner.deid.enriched': 'ner_deid_enriched',
                'en.med_ner.deid.enriched_biobert': 'ner_deid_enriched_biobert',
                'en.med_ner.deid.large': 'ner_deid_large',
                'en.med_ner.deid.sd': 'ner_deid_sd',
                'en.med_ner.deid.sd_large': 'ner_deid_sd_large',
                'en.med_ner.deid.synthetic': 'ner_deid_synthetic',
                'en.med_ner.deid': 'ner_deidentify_dl',
                # 2.7.5
                'en.med_ner.admission_events': 'ner_events_admission_clinical',

                # 3.1.1

                'en.med_ner.deid.generic_augmented': 'ner_deid_generic_augmented',
                'en.med_ner.deid.subentity_augmented': 'ner_deid_subentity_augmented',
                # 'med_ner.deid.generic_glove':'ner_deid_generic_glove',
                # 'med_ner.deid.subentity_glove':'ner_deid_subentity_glove',

                # 'en.med_ner.clinical.icdem': 'ner_clinical_icdem', # TODO UNRESOLVable storageref
                # 'en.med_ner.clinical.large': 'ner_clinical_large',# TODO URNESOLVED, PIPE?

                # NLU 3.1.2

                'en.med_ner.ade_biobert': 'ner_ade_biobert',
                'en.classify.ade.clinicalbert': 'classifierdl_ade_clinicalbert',
                # 'en.med_ner.large': 'ner_large_clinical', # Deprecated

                # DeIdentificationModel

                # 'en.de_identify':'deidentify_dl', # todo ????    lOAD AS ner moadel??? THIS ENEDS EMEBDDINGS??
                'en.de_identify': 'deidentify_rb',
                'en.de_identify.rules': 'deid_rules',
                'en.de_identify.clinical': 'deidentify_enriched_clinical',
                'en.de_identify.large': 'deidentify_large',
                'en.de_identify.rb': 'deidentify_rb',
                'en.de_identify.rb_no_regex': 'deidentify_rb_no_regex',

                # 'en.classify.icd10.clinical':'classifier_icd10cm_hcc_clinical',      #  WHCIH CLASS? # TODO NOT LAODING
                # 'en.classify.icd10.healthcare':'classifier_icd10cm_hcc_healthcare', # TODO NOT LOADING CORRECt
                'en.classify.ade.biobert': 'classifierdl_ade_biobert',
                'en.classify.ade.clinical': 'classifierdl_ade_clinicalbert',
                'en.classify.ade.conversational': 'classifierdl_ade_conversational_biobert',
                'en.classify.gender.biobert': 'classifierdl_gender_biobert',
                'en.classify.gender.sbert': 'classifierdl_gender_sbert',  # ok!
                'en.classify.pico': 'classifierdl_pico_biobert',
                # 'en.classify.icd10.use':'useclassifier_icd10cm_hcc', buggy

                # 3.0.3 healthcare
                'en.resolve.umls': 'sbiobertresolve_umls_major_concepts',
                'en.resolve.umls.findings': 'sbiobertresolve_umls_findings',
                'en.resolve.loinc': 'sbiobertresolve_loinc',
                'en.resolve.loinc.biobert': 'sbiobertresolve_loinc',
                'en.resolve.HPO': 'sbiobertresolve_HPO',
                'en.resolve.snomed_conditions': 'sbertresolve_snomed_conditions',

                # Healthcare 3.1.2 to 3.2.0
                'en.relation.ade': 'redl_ade_biobert',
                'en.relation.ade_clinical': 're_ade_clinical',
                'en.relation.ade_biobert': 're_ade_biobert',
                'en.assert.jsl': 'assertion_jsl',
                'en.assert.jsl_large': 'assertion_jsl_large',
                # 'en.resolve.snomed_findings_aux_concepts': 'sbiobertresolve_snomed_findings_aux_concepts', # bad storage  sbiobert_base_cased_mli, but the model_anno_obj does not have that ref
                'en.resolve.rxnorm_disposition': 'sbiobertresolve_rxnorm_disposition',
                'en.resolve.rxnorm_disposition.sbert': 'sbertresolve_rxnorm_disposition',

                'en.med_ner.jsl_slim': 'ner_jsl_slim',
                'en.med_ner.jsl_greedy_biobert': 'ner_jsl_greedy_biobert',
                'en.classify.token_bert.ner_clinical': 'bert_token_classifier_ner_clinical',
                'en.classify.token_bert.ner_jsl': 'bert_token_classifier_ner_jsl',

                # 3.3.1 healthcare
                'en.classify.token_bert.ner_chemical': 'bert_token_classifier_ner_chemicals',

                ## 3.3.3 HC
                'en.med_ner.deid_subentity_augmented_i2b2': 'ner_deid_subentity_augmented_i2b2',
                'en.med_ner.biomarker': 'ner_biomarker',
                'en.med_ner.nihss': 'ner_nihss',
                'en.extract_relation.nihss': 'redl_nihss_biobert',
                'en.resolve.mesh': 'sbiobertresolve_mesh',
                'en.resolve.ndc': 'sbiobertresolve_ndc',
                'en.resolve.loinc.augmented': 'sbiobertresolve_loinc_augmented',
                'en.resolve.clinical_snomed_procedures_measurements': 'sbiobertresolve_clinical_snomed_procedures_measurements',
                'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
                'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
                'es.resolve.snomed': 'robertaresolve_snomed',
                'en.med_ner.covid_trials': 'ner_covid_trials',
                'en.med_ner.chemd': 'ner_chemd_clinical',
                'en.classify.token_bert.bionlp': 'bert_token_classifier_ner_bionlp',
                'en.classify.token_bert.cellular': 'bert_token_classifier_ner_cellular',
                'en.classify.token_bert.chemicals': 'bert_token_classifier_ner_chemicals',
                'en.resolve.rxnen.med_ner.deid_subentityorm_augmented': 'sbiobertresolve_rxnorm_augmented',
                'en.resolve.umls_disease_syndrome': 'sbiobertresolve_umls_disease_syndrome',
                'en.resolve.umls_clinical_drugs': 'sbiobertresolve_umls_clinical_drugs',
                'en.classify.bert_sequence.question_statement_clinical': 'bert_sequence_classifier_question_statement_clinical',

                'en.med_ner.biomedical_bc2gm': 'ner_biomedical_bc2gm',
                'en.resolve.rxnorm_action_treatment': 'sbiobertresolve_rxnorm_action_treatment',
                # 'en.classify.rct_binary.use':'rct_binary_classifier_use',
                # 'en.classify.rct_binary.biobert':'rct_binary_classifier_biobert',

            },

        'de':
            {

                'de.med_ner.deid_subentity': 'ner_deid_subentity',
                'de.med_ner.deid_generic': 'ner_deid_generic',
                'de.embed.w2v': 'w2v_cc_300d',
                'de.embed': 'w2v_cc_300d',
                'de.med_ner.legal': 'ner_legal',
                # 'de.med_ner' :'ner_healthcare', # BAD NER TRAINED ON STORAGE_REF embeddings_healthcare_100d which only exist in EN
                #  'de.med_ner.healthcare' :'ner_healthcare', # BAD NER TRAINED ON STORAGE_REF embeddings_healthcare_100d which only exist in EN
                'de.med_ner': 'ner_healthcare_slim',
                'de.med_ner.traffic': 'ner_traffic',
                'de.resolve.icd10gm': 'sbertresolve_icd10gm',
                'de.resolve.snomed': 'sbertresolve_snomed',

            },

        'es': {

            # 4.0.0
            'es.med_ner.living_species': 'bert_token_classifier_ner_living_species',
            'es.med_ner.living_species.bert': 'ner_living_species_bert',
            'es.med_ner.living_species.roberta': 'ner_living_species_roberta',
            'es.med_ner.living_species.300': 'ner_living_species_300',
            'es.med_ner.living_species': 'ner_living_species',
            'es.embed.scielo300d': 'embeddings_scielo_300d',

            # 3.4.2
            'es.med_ner.deid.generic.roberta': 'ner_deid_generic_roberta_augmented',
            'es.med_ner.deid.subentity.roberta': 'ner_deid_subentity_roberta_augmented',

            # 3.4.1
            'es.embed.sciwiki_300d': 'embeddings_sciwiki_300d',
            'es.med_ner.deid.generic': 'ner_deid_generic',
            'es.med_ner.deid.subentity': 'ner_deid_subentity',

            'es.embed.scielo.150d': 'embeddings_scielo_150d',
            'es.embed.scielo.300d': 'embeddings_scielo_300d',
            'es.embed.scielo.50d': 'embeddings_scielo_50d',
            'es.embed.scielowiki.150d': 'embeddings_scielowiki_150d',
            'es.embed.scielowiki.300d': 'embeddings_scielowiki_300d',
            'es.embed.scielowiki.50d': 'embeddings_scielowiki_50d',
            'es.embed.sciwiki.150d': 'embeddings_sciwiki_150d',
            'es.embed.sciwiki.300d': 'embeddings_sciwiki_300d',
            'es.embed.sciwiki.50d': 'embeddings_sciwiki_50d',
            'es.med_ner': 'ner_diag_proc',
            'es.med_ner.neoplasm': 'ner_neoplasms',
            'es.med_ner.diag_proc': 'ner_diag_proc',

            'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
            'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
            'es.resolve.snomed': 'robertaresolve_snomed',
        },

        'pt': {
            'pt.med_ner.deid.subentity': 'ner_deid_subentity',
            'pt.med_ner.deid.generic': 'ner_deid_generic',
            'pt.med_ner.deid': 'ner_deid_generic',

            # 4.0.0
            'pt.med_ner.living_species.token_bert': 'bert_token_classifier_ner_living_species',
            'pt.med_ner.living_species': 'ner_living_species',
            'pt.med_ner.living_species.roberta': 'ner_living_species_roberta',
            'pt.med_ner.living_species.bert': 'ner_living_species_bert'
        },
        'ro': {
            # 4.0.0
            'ro.med_ner.living_species.bert': 'ner_living_species_bert',
            'ro.med_ner.clinical': 'ner_clinical',
            'ro.embed.clinical.bert.base_cased': 'ner_clinical_bert',
            'ro.med_ner.deid.subentity': 'ner_deid_subentity',
            'ro.med_ner.deid.subentity.bert': 'ner_deid_subentity_bert'

        },
        'gl': {
            # 4.0.0
            'gl.med_ner.living_species': 'ner_living_species'
        },
        'ca': {
            # 4.0.0
            'ca.med_ner.living_species': 'ner_living_species'

        }
    }

    ocr_model_references = {
        'img2text': OCR_NODE_IDS.IMAGE2TEXT,
        'png2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'jpg2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'pdf2text': OCR_NODE_IDS.PDF2TEXT,
        'doc2text': OCR_NODE_IDS.DOC2TEXT,

        'pdf2table': OCR_NODE_IDS.PDF2TEXT_TABLE,
        'doc2table': OCR_NODE_IDS.DOC2TEXT_TABLE,
        'ppt2table': OCR_NODE_IDS.PPT2TEXT_TABLE,
        'classify.image': OCR_NODE_IDS.VISUAL_DOCUMENT_CLASSIFIER,
        'en.classify_image.tabacco': 'visual_document_classifier_tobacco3482'
    }
    # map storage ref to nlu refner_jsl
    storage_ref_2_nlu_ref = {
        'it': {
            'glove_6B_300': 'xx.embed.glove.6B_300',

        },

        'nl': {
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',

        },

        'en': {
            'tfhub_use': 'en.embed_sentence.use',
            'glove_100d': 'en.embed.glove.100d',
            'xlm_roberta_base': 'xx.embed.xlm',
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',
            'bert_large_cased': "en.embed.bert.large_cased",
            'albert_base_uncased': 'en.embed_sentence.albert',
            'small_bert_L2_128': 'en.embed.bert.small_L2_128',
            'elmo': 'en.embed.elmo',
            'distilbert_base_cased': 'en.embed.distilbert.base',
            'electra_base_uncased': 'en.embed.electra.base_uncased',

            'roberta_large': 'en.embed.roberta.large',
            'roberta_base': 'en.embed.roberta.base',

            'small_bert_L4_256': 'en.embed.bert.small_L4_256',
            'small_bert_L4_512': 'en.embed.bert.small_L4_512',
            'small_bert_L8_512': 'en.embed.bert.small_L8_512',

            'albert_large_uncased': 'en.embed.albert.large_uncased',

            'electra_small_uncased': 'en.embed.electra.small_uncased',
            'xlnet_base_cased': 'en.embed.xlnet_base_cased',

            'longformer_large_4096': 'en.embed.longformer.large',
            'electra_large_uncased': 'en.embed.electra.large_uncased',
            'xlm_roberta_xtreme_base': 'xx.embed.xlm_roberta_xtreme_base',

        },
        'zh': {
            'bert_base_chinese': 'zh.embed',
            'glove_6B_300': 'xx.embed.glove.6B_300',
        },
        'th': {
            'tfhub_use_multi_lg': 'xx.use.multi',
            'labse': 'xx.embed_sentence.labse',

        },
        'ur': {
            'glove_300d': 'ur.embed',
            'labse': 'xx.embed_sentence.labse',
        },
        'fr':
            {
                'labse': 'xx.embed_sentence.labse',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'tr':
            {'bert_multi_cased': 'xx.embed.bert',
             'labse': 'xx.embed_sentence.labse',
             'glove_840B_300': 'xx.embed.glove.840B_300',
             'bert_base_turkish_uncased': 'tr.embed.bert.uncased',
             },
        'sv':
            {
                'glove_100d': 'xx.embed.glove.glove_6B_100',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'fa':
            {'glove_300d': 'fa.embed',
             },
        'he':
            {'glove_300d': 'he.embed',
             },
        'fi':
            {

                'glove_100d': 'xx.embed.glove.glove_6B_100',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'bn':
            {
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'bengali_cc_300d': 'bn.embed.glove',
            },
        'ar':
            {'glove_300d': 'ar.embed',
             },
        'de':
            {
                'sent_bert_multi_cased': 'xx.embed_sentence',
                'labse': 'xx.embed_sentence.labse',
                'clinical': 'de.embed_sentence.bert.base_cased',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',
                'w2v_cc_300d': 'de.embed.w2v',
                'sent_bert_base_cased': 'de.embed_sentence.bert.base_cased',

            },
        'ja':
            {
                'fasttext_300_ja': 'ja.embed.glove.cc_300d',
                'xlm_roberta_base': 'xx.embed.xlm',
                'glove_840B_300': 'xx.embed.glove.840B_300',

            },
        'no': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',
        },
        'pl': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',

        },
        'pt': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_840B_300': 'xx.embed.glove.840B_300',

        },
        'ru': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_840B_300': 'xx.embed.glove.840B_300',

        },
        'es': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'es.ner': 'roberta_token_classifier_bne_capitel_ner',
            'glove_840B_300': 'xx.embed.glove.840B_300',
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'embeddings_scielo300': 'es.embed.scielo300',
            'w2v_cc_300d_es': 'es.embed.w2v_cc_300d',

        },

        'da': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
        },

    }  #

    bad_storage_refs = [

        'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5',
        'RelationExtractionModel_ce79d77d1bf1',
        'RelationExtractionModel_1fb1dfa024c7',
        'RelationExtractionModel_6a65c9992836',
        'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc',
        'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4',
        'RelationExtractionModel_3ab4750ad5b6',
        'RelationExtractionModel_6b61602c8303',
        'RelationExtractionModel_9c255241fec3',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',
        'RelationExtractionModel_14b00157fc1a',
        'RelationExtractionModel_53a12cc975cb',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',

    ]
    licensed_storage_ref_2_nlu_ref = {
        'en': {
            'clinical': 'en.embed.glove.clinical',
            'biobert_pubmed_base_cased': 'en.embed.biobert',
            'embeddings_healthcare100': 'en.embed.glove.healthcare_100d',
            'bert_base_cased': 'en.embed.bert.base_cased',
            'sent_bluebert_base_uncased_mednli': 'en.embed_sentence.bluebert.mli',

            'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5': 'en.embed_sentence.bert.jsl_medium_uncased',
            'RelationExtractionModel_ce79d77d1bf1': 'en.embed.glove.clinical',
            'RelationExtractionModel_1fb1dfa024c7': 'en.embed.glove.clinical',
            'RelationExtractionModel_6a65c9992836': 'en.embed.biobert',
            'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc': 'en.embed_sentence.biobert.mli',
            'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4': 'en.embed_sentence.bluebert.mli',
            'RelationExtractionModel_3ab4750ad5b6': 'en.embed.glove.clinical',
            'RelationExtractionModel_6b61602c8303': 'en.embed.glove.clinical',
            'RelationExtractionModel_9c255241fec3': 'en.embed.glove.clinical',
            'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'en.embed_sentence.biobert.clinical_base_cased',
            'RelationExtractionModel_14b00157fc1a': 'en.embed.glove.clinical',
            'RelationExtractionModel_53a12cc975cb': 'en.embed.glove.clinical',
            'biobert_clinical_base_cased': 'en.embed.biobert.clinical_base_cased',
            'sent_biobert_clinical_base_cased': 'en.embed_sentence.biobert.clinical_base_cased',

        },
        'es': {
            'embeddings_scielowiki300': 'es.embed.scielowiki.300d',
            'embeddings_wiki300': 'es.embed.sciwiki_300d',
            'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'es.embed.roberta_base_biomedical',
            'clinical': 'es.embed.roberta_base_biomedical',
            'bert_base_cased_es': 'es.embed.bert.base_cased',
            'embeddings_scielo300': 'es.embed.scielo300',
            # 'clinical' : 'es.embed.roberta_base_biomedical',

        },
        'de': {
            'clinical': 'de.embed_sentence.bert.base_cased',

        },
        'fr': {
            'WordEmbeddings_b266d1e5126a': 'fr.embed.w2v_cc_300d',
            'bert_embeddings_bert_base_fr_cased_fr': 'fr.embed.bert_base_fr_cased'

        },
        'it': {
            'w2v_cc_300d_it': 'it.embed.word2vec',
            'bert_embeddings_bert_base_italian_xxl_cased_it': 'it.embed.bert_base_italian_xxl_cased',

        },

        'pt': {
            'w2v_cc_300d_pt': 'pt.embed.w2v_cc_300d',
            'biobert_embeddings_biomedical_pt': 'pt.embed.gs_biomedical',
            'roberta_embeddings_BR_BERTo_pt': 'pt.embed.BR_BERTo'

        },
        'ro': {

            'bert_base_cased_v1': 'ro.embed.bert.base_cased',
            'w2v_cc_300d_ro': 'ro.embed.w2v_cc_300d'
        },
        'ca': {
            'w2v_cc_300d_ca': 'ca.embed.w2v_cc_300d'
        },

        'gl': {
            'w2v_cc_300d_gl': 'gl.embed.w2v_cc_300d'
        }

    }

    # Map NLU train references to JSL Anno IDs
    traianble_nlu_ref_to_jsl_anno_id = {
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.word_seg': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.word_segmenter': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

    }

    # Map every nlp_ref to an Annotator class. Language Agnostic and includes HC+OS
    # For models with no pretrained weight, i.e. most OCR annotators, it maps AnnoId to Class

    nlp_ref_to_anno_class = {
        # HC
        # NLP_HC_NODE_IDS.DE_IDENTIFICATION: 'DeIdentification',
        # # OCR
        'spanbert_base_coref': 'SpanBertCorefModel',

        'albert_base_qa_squad2': 'AlbertForQuestionAnswering',

        'visual_document_classifier_tobacco3482': 'VisualDocumentClassifier',
        OCR_NODE_IDS.IMAGE2TEXT: 'ImageToText',
        OCR_NODE_IDS.PDF2TEXT: 'PdfToText',
        OCR_NODE_IDS.DOC2TEXT: 'DocToText',
        OCR_NODE_IDS.BINARY2IMAGE: 'BinaryToImage',
        OCR_NODE_IDS.PDF2TEXT_TABLE: 'PdfToTextTable',
        OCR_NODE_IDS.PPT2TEXT_TABLE: 'PptToTextTable',
        OCR_NODE_IDS.DOC2TEXT_TABLE: 'DocToTextTable',
        OCR_NODE_IDS.VISUAL_DOCUMENT_CLASSIFIER: 'VisualDocumentClassifier',
        'roberta_embeddings_MedRoBERTa.nl': 'RoBertaEmbeddings',

        'snomed_icd10cm_mapper': 'ChunkMapperModel',
        'icd10cm_snomed_mapper': 'ChunkMapperModel',
        'snomed_icdo_mapper': 'ChunkMapperModel',
        'icdo_snomed_mapper': 'ChunkMapperModel',
        'rxnorm_umls_mapper': 'ChunkMapperModel',
        'icd10cm_umls_mapper': 'ChunkMapperModel',
        'mesh_umls_mapper': 'ChunkMapperModel',
        'snomed_umls_mapper': 'ChunkMapperModel',

        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_am_roberta': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_pos_bert_base_arabic_camelbert_msa_pos_msa': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_mix_pos_egy': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_da_pos_glf': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_ca_pos_glf': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_msa_pos_egy': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_ca_pos_egy': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_msa_pos_glf': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_mix_pos_glf': 'BertForTokenClassification',
        'bert_pos_bert_base_arabic_camelbert_da_pos_egy': 'BertForTokenClassification',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_embeddings_multi_dialect_bert_base_arabic': 'BertEmbeddings',
        'bert_ner_bert_base_arabic_camelbert_da_ner': 'BertForTokenClassification',
        'bert_ner_bert_base_arabic_camelbert_mix_ner': 'BertForTokenClassification',
        'pos_padt': 'PerceptronModel',
        'bert_ner_bert_base_multilingual_cased_ner_hrl': 'BertForTokenClassification',
        'bert_ner_bert_base_arabic_camelbert_msa_ner': 'BertForTokenClassification',
        'bert_ner_ANER': 'BertForTokenClassification',
        'bert_ner_arabert_ner': 'BertForTokenClassification',
        'lemma_padt': 'LemmatizerModel',
        'bert_pos_bert_base_arabic_camelbert_mix_pos_msa': 'BertForTokenClassification',
        'bert_embeddings_mbert_ar_c19': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_msa_half': 'BertEmbeddings',
        'bert_embeddings_bert_large_arabertv02': 'BertEmbeddings',
        'bert_embeddings_AraBertMo_base_V1': 'BertEmbeddings',
        'bert_embeddings_DarijaBERT': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabertv02': 'BertEmbeddings',
        'bert_embeddings_arabert_c19': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_msa': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabertv2': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic': 'BertEmbeddings',
        'bert_embeddings_Ara_DialectBERT': 'BertEmbeddings',
        'bert_embeddings_MARBERT': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_msa_eighth': 'BertEmbeddings',
        'bert_embeddings_MARBERTv2': 'BertEmbeddings',
        'bert_embeddings_bert_large_arabertv2': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabert': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabertv01': 'BertEmbeddings',
        'bert_embeddings_bert_mini_arabic': 'BertEmbeddings',
        'bert_embeddings_bert_large_arabic': 'BertEmbeddings',
        'bert_embeddings_bert_large_arabertv02_twitter': 'BertEmbeddings',
        'bert_embeddings_dziribert': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabertv02_twitter': 'BertEmbeddings',
        'bert_embeddings_bert_medium_arabic': 'BertEmbeddings',
        'bert_pos_bert_base_arabic_camelbert_da_pos_msa': 'BertForTokenClassification',
        'bert_embeddings_bert_base_qarib': 'BertEmbeddings',
        'bert_embeddings_bert_base_qarib60_860k': 'BertEmbeddings',
        'bert_embeddings_bert_base_qarib60_1790k': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_msa_sixteenth': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_mix': 'BertEmbeddings',
        'bert_embeddings_bert_base_arabic_camelbert_msa_quarter': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_hse': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_embeddings_indic_transformers_bn_bert': 'BertEmbeddings',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'bert_embeddings_bangla_bert': 'BertEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_scriptorium': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_fictree': 'PerceptronModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_fictree': 'LemmatizerModel',
        'lemma_cltt': 'LemmatizerModel',
        'pos_proiel': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_embeddings_bert_base_historical_german_rw_cased': 'BertEmbeddings',
        'bert_embeddings_gbert_base': 'BertEmbeddings',
        'bert_embeddings_german_financial_statements_bert': 'BertEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'bert_embeddings_bert_base_german_dbmdz_uncased': 'BertEmbeddings',
        'roberta_embeddings_roberta_base_wechsel_german': 'RoBertaEmbeddings',
        'bert_embeddings_gbert_large': 'BertEmbeddings',
        'bert_embeddings_bert_base_5lang_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_german_cased_oldvocab': 'BertEmbeddings',
        'bert_embeddings_bert_base_de_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_german_uncased': 'BertEmbeddings',
        'bert_embeddings_bert_base_german_dbmdz_cased': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_muppet_roberta_base': 'RoBertaEmbeddings',
        'roberta_embeddings_muppet_roberta_large': 'RoBertaEmbeddings',
        'roberta_embeddings_fairlex_ecthr_minilm': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_titles_and_bodies': 'RoBertaEmbeddings',
        'roberta_embeddings_legal_roberta_base': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base': 'RoBertaEmbeddings',
        'roberta_embeddings_pmc_med_bio_mlm_roberta_large': 'RoBertaEmbeddings',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_ewt': 'LemmatizerModel',
        'lemma_lines': 'LemmatizerModel',
        'roberta_embeddings_roberta_pubmed': 'RoBertaEmbeddings',
        'roberta_embeddings_fairlex_scotus_minilm': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_title': 'RoBertaEmbeddings',
        'roberta_embeddings_chEMBL26_smiles_v2': 'RoBertaEmbeddings',
        'roberta_embeddings_SecRoBERTa': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base_climate_d_s': 'RoBertaEmbeddings',
        'roberta_embeddings_chEMBL_smiles_v1': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base_climate_f': 'RoBertaEmbeddings',
        'roberta_embeddings_distilroberta_base_climate_d': 'RoBertaEmbeddings',
        'roberta_embeddings_Bible_roberta_base': 'RoBertaEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_atis': 'PerceptronModel',
        'roberta_ner_ner_chemical_bionlp_bc5cdr_pubmed': 'RoBertaForTokenClassification',
        'roberta_pos_roberta_large_english_upos': 'RoBertaForTokenClassification',
        'roberta_ner_roberta_ticker': 'RoBertaForTokenClassification',
        'bert_embeddings_bert_political_election2020_twitter_mlm': 'BertEmbeddings',
        'bert_embeddings_bert_base_uncased_mnli_sparse_70_unstructured_no_classifier': 'BertEmbeddings',
        'bert_embeddings_crosloengual_bert': 'BertEmbeddings',
        'bert_embeddings_chemical_bert_uncased': 'BertEmbeddings',
        'bert_embeddings_deberta_base_uncased': 'BertEmbeddings',
        'bert_embeddings_bert_base_en_cased': 'BertEmbeddings',
        'bert_embeddings_bert_for_patents': 'BertEmbeddings',
        'bert_embeddings_SecBERT': 'BertEmbeddings',
        'bert_embeddings_bert_base_5lang_cased': 'BertEmbeddings',
        'bert_embeddings_DiLBERT': 'BertEmbeddings',
        'bert_embeddings_FinancialBERT': 'BertEmbeddings',
        'bert_embeddings_false_positives_scancode_bert_base_uncased_L8_1': 'BertEmbeddings',
        'bert_embeddings_legal_bert_small_uncased': 'BertEmbeddings',
        'bert_embeddings_legal_bert_base_uncased': 'BertEmbeddings',
        'bert_embeddings_COVID_SciBERT': 'BertEmbeddings',
        'bert_biolink_base': 'BertEmbeddings',
        'bert_embeddings_danbert_small_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_uncased_dstc9': 'BertEmbeddings',
        'bert_embeddings_hateBERT': 'BertEmbeddings',
        'bert_embeddings_childes_bert': 'BertEmbeddings',
        'bert_embeddings_clinical_pubmed_bert_base_512': 'BertEmbeddings',
        'bert_embeddings_netbert': 'BertEmbeddings',
        'bert_embeddings_psych_search': 'BertEmbeddings',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'bert_embeddings_finbert_pretrain_yiyanghkust': 'BertEmbeddings',
        'bert_embeddings_lic_class_scancode_bert_base_cased_L32_1': 'BertEmbeddings',
        'bert_embeddings_sec_bert_sh': 'BertEmbeddings',
        'bert_embeddings_sec_bert_num': 'BertEmbeddings',
        'bert_embeddings_finest_bert': 'BertEmbeddings',
        'bert_embeddings_bert_large_cased_whole_word_masking': 'BertEmbeddings',
        'bert_embeddings_clinical_pubmed_bert_base_128': 'BertEmbeddings',
        'bert_embeddings_bert_base_uncased_sparse_70_unstructured': 'BertEmbeddings',
        'bert_embeddings_sec_bert_base': 'BertEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_embeddings_agriculture_bert_uncased': 'BertEmbeddings',
        'bert_embeddings_bert_large_uncased_whole_word_masking': 'BertEmbeddings',
        'bert_biolink_large': 'BertEmbeddings',
        'roberta_ner_roberta_large_finetuned_abbr': 'RoBertaForTokenClassification',
        'roberta_ner_roberta_classics_ner': 'RoBertaForTokenClassification',
        'roberta_pos_roberta_base_english_upos': 'RoBertaForTokenClassification',
        'roberta_ner_roberta_large_ner_english': 'RoBertaForTokenClassification',
        'roberta_ner_ner_gene_dna_rna_jnlpba_pubmed': 'RoBertaForTokenClassification',
        'roberta_ner_ner_disease_ncbi_bionlp_bc5cdr_pubmed': 'RoBertaForTokenClassification',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_bertin_base_gaussian': 'RoBertaEmbeddings',
        'roberta_embeddings_bertin_roberta_base_spanish': 'RoBertaEmbeddings',
        'roberta_embeddings_bertin_roberta_large_spanish': 'RoBertaEmbeddings',
        'roberta_embeddings_bertin_base_stepwise': 'RoBertaEmbeddings',
        'bert_embeddings_dpr_spanish_passage_encoder_allqa_base': 'BertEmbeddings',
        'bert_embeddings_dpr_spanish_question_encoder_allqa_base': 'BertEmbeddings',
        'bert_embeddings_beto_gn_base_cased': 'BertEmbeddings',
        'bert_embeddings_dpr_spanish_passage_encoder_squades_base': 'BertEmbeddings',
        'bert_embeddings_dpr_spanish_question_encoder_squades_base': 'BertEmbeddings',
        'bert_embeddings_bert_base_es_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_5lang_cased': 'BertEmbeddings',
        'bert_embeddings_alberti_bert_base_multilingual_cased': 'BertEmbeddings',
        'roberta_embeddings_roberta_base_bne': 'RoBertaEmbeddings',
        'roberta_embeddings_jurisbert': 'RoBertaEmbeddings',
        'roberta_embeddings_mlm_spanish_roberta_base': 'RoBertaEmbeddings',
        'roberta_embeddings_roberta_large_bne': 'RoBertaEmbeddings',
        'pos_ancora': 'PerceptronModel',
        'roberta_embeddings_bertin_base_random_exp_512seqlen': 'RoBertaEmbeddings',
        'roberta_embeddings_bertin_base_gaussian_exp_512seqlen': 'RoBertaEmbeddings',
        'roberta_ner_roberta_base_bne_capitel_ner_plus': 'RoBertaForTokenClassification',
        'roberta_ner_roberta_base_bne_capitel_ner': 'RoBertaForTokenClassification',
        'roberta_ner_RuPERTa_base_finetuned_ner': 'RoBertaForTokenClassification',
        'roberta_pos_roberta_base_bne_capitel_pos': 'RoBertaForTokenClassification',
        'roberta_ner_NER_LAW_MONEY4': 'RoBertaForTokenClassification',
        'roberta_pos_roberta_large_bne_capitel_pos': 'RoBertaForTokenClassification',
        'roberta_ner_bsc_bio_ehr_es_pharmaconer': 'RoBertaForTokenClassification',
        'roberta_embeddings_RoBERTalex': 'RoBertaEmbeddings',
        'roberta_ner_roberta_large_bne_capitel_ner': 'RoBertaForTokenClassification',
        'roberta_embeddings_RuPERTa_base': 'RoBertaEmbeddings',
        'roberta_embeddings_bertin_base_random': 'RoBertaEmbeddings',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_pos_RuPERTa_base_finetuned_pos': 'RoBertaForTokenClassification',
        'roberta_embeddings_bertin_base_stepwise_exp_512seqlen': 'RoBertaEmbeddings',
        'roberta_ner_bsc_bio_ehr_es_cantemist': 'RoBertaForTokenClassification',
        'stopwords_iso': 'StopWordsCleaner',
        'pos_edt': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_edt': 'LemmatizerModel',
        'lemma_ewt': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_bdt': 'LemmatizerModel',
        'roberta_embeddings_roberta_fa_zwnj_base': 'RoBertaEmbeddings',
        'roberta_ner_roberta_fa_zwnj_base_ner': 'RoBertaForTokenClassification',
        'pos_perdt': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_tdt': 'PerceptronModel',
        'lemma_tdt': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_ftb': 'LemmatizerModel',
        'pos_farpahc': 'PerceptronModel',
        'bert_embeddings_bert_base_fr_cased': 'BertEmbeddings',
        'pos_rhapsodie': 'PerceptronModel',
        'pos_sequoia': 'PerceptronModel',
        'roberta_embeddings_french_roberta': 'RoBertaEmbeddings',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_ftb': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_roberta_base_wechsel_french': 'RoBertaEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_idt': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_treegal': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_proiel': 'LemmatizerModel',
        'pos_proiel': 'PerceptronModel',
        'roberta_embeddings_RoBERTa_hindi_guj_san': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_RoBERTa_hindi_guj_san': 'RoBertaEmbeddings',
        'roberta_embeddings_indic_transformers_hi_roberta': 'RoBertaEmbeddings',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'bert_embeddings_indic_transformers_hi_bert': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_armtdp': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_armtdp': 'PerceptronModel',
        'lemma_armtdp': 'LemmatizerModel',
        'pos_csui': 'PerceptronModel',
        'roberta_embeddings_indo_roberta_small': 'RoBertaEmbeddings',
        'roberta_embeddings_indonesian_roberta_base': 'RoBertaEmbeddings',
        'roberta_pos_indonesian_roberta_base_posp_tagger': 'RoBertaForTokenClassification',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_gsd': 'LemmatizerModel',
        'roberta_embeddings_roberta_base_indonesian_522M': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_indonesian_roberta_large': 'RoBertaEmbeddings',
        'lemma_icepahc': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'stopwords_iso': 'StopWordsCleaner',
        'pos_twittiro': 'PerceptronModel',
        'bert_embeddings_bert_base_italian_xxl_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_italian_xxl_uncased': 'BertEmbeddings',
        'bert_embeddings_chefberto_italian_cased': 'BertEmbeddings',
        'bert_embeddings_hseBert_it_cased': 'BertEmbeddings',
        'bert_embeddings_wineberto_italian_cased': 'BertEmbeddings',
        'pos_partut': 'PerceptronModel',
        'lemma_postwita': 'LemmatizerModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_twittiro': 'LemmatizerModel',
        'bert_embeddings_bert_base_ja_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_char_v2': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_char_extended': 'BertEmbeddings',
        'bert_embeddings_bert_large_japanese_char': 'BertEmbeddings',
        'bert_embeddings_bert_large_japanese': 'BertEmbeddings',
        'bert_embeddings_bert_small_japanese': 'BertEmbeddings',
        'bert_embeddings_bert_large_japanese_char_extended': 'BertEmbeddings',
        'pos_gsd': 'PerceptronModel',
        'bert_embeddings_bert_small_japanese_fin': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_basic_char_v2': 'BertEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_embeddings_bert_base_japanese_char_whole_word_masking': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_char': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_whole_word_masking': 'BertEmbeddings',
        'bert_embeddings_bert_base_japanese_v2': 'BertEmbeddings',
        'roberta_embeddings_javanese_roberta_small': 'RoBertaEmbeddings',
        'roberta_embeddings_javanese_roberta_small_imdb': 'RoBertaEmbeddings',
        'bert_embeddings_javanese_bert_small_imdb': 'BertEmbeddings',
        'bert_embeddings_javanese_bert_small': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_KNUBert': 'RoBertaEmbeddings',
        'roberta_embeddings_KanBERTo': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_kaist': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_roberta_ko_small': 'RoBertaEmbeddings',
        'pos_gsd': 'PerceptronModel',
        'bert_embeddings_bert_kor_base': 'BertEmbeddings',
        'bert_embeddings_dbert': 'BertEmbeddings',
        'bert_embeddings_KR_FinBert': 'BertEmbeddings',
        'bert_embeddings_bert_base_v1_sports': 'BertEmbeddings',
        'lemma_gsd': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_proiel': 'LemmatizerModel',
        'lemma_llct': 'LemmatizerModel',
        'pos_udante': 'PerceptronModel',
        'pos_perseus': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'stopwords_iso': 'StopWordsCleaner',
        'pos_lvtb': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_ufal': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_embeddings_marathi_bert': 'BertEmbeddings',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'pos_ufal': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_mudt': 'LemmatizerModel',
        'pos_mudt': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_pos_fullstop_dutch_punctuation_prediction': 'RoBertaForTokenClassification',
        'nl': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_robbert_v2_dutch_base': 'RoBertaEmbeddings',
        'roberta_embeddings_robbertje_1_gb_bort': 'RoBertaEmbeddings',
        'roberta_embeddings_robbertje_1_gb_shuffled': 'RoBertaEmbeddings',
        'roberta_embeddings_robbertje_1_gb_non_shuffled': 'RoBertaEmbeddings',
        'roberta_embeddings_robbertje_1_gb_merged': 'RoBertaEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_nynorsk': 'LemmatizerModel',
        'pos_bokmaal': 'PerceptronModel',
        'pos_nynorsk': 'PerceptronModel',
        'pos_nynorsklia': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_bokmaal': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_torot': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_lfg': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_BR_BERTo': 'RoBertaEmbeddings',
        'biobert_embeddings_all': 'BertEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'biobert_embeddings_clinical': 'BertEmbeddings',
        'biobert_embeddings_biomedical': 'BertEmbeddings',
        'lemma_bosque': 'LemmatizerModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'bert_embeddings_bert_base_portuguese_cased_finetuned_tcu_acordaos': 'BertEmbeddings',
        'roberta_ner_satellite_instrument_roberta_NER': 'RoBertaForTokenClassification',
        'bert_embeddings_bert_small_gl_cased': 'BertEmbeddings',
        'bert_embeddings_bert_large_cased_pt_lenerbr': 'BertEmbeddings',
        'bert_embeddings_bert_large_portuguese_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_cased_pt_lenerbr': 'BertEmbeddings',
        'bert_embeddings_bert_base_portuguese_cased_finetuned_peticoes': 'BertEmbeddings',
        'bert_embeddings_bert_base_portuguese_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_pt_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_gl_cased': 'BertEmbeddings',
        'lemma_hiencs': 'LemmatizerModel',
        'pos_sagt': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'pos_nonstandard': 'PerceptronModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'pos_gsd': 'PerceptronModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'lemma_gsd': 'LemmatizerModel',
        'roberta_embeddings_ruRoberta_large': 'RoBertaEmbeddings',
        'pos_syntagrus': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_roberta_base_russian_v0': 'RoBertaEmbeddings',
        'bert_embeddings_bert_base_ru_cased': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_vedic': 'LemmatizerModel',
        'pos_vedic': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_snk': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_sst': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'pos_sst': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_giella': 'LemmatizerModel',
        'pos_giella': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_set': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_sundanese_roberta_base': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_lines': 'LemmatizerModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'bert_embeddings_indic_transformers_te_bert': 'BertEmbeddings',
        'bert_embeddings_telugu_bertu': 'BertEmbeddings',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'roberta_embeddings_indic_transformers_te_roberta': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_mtg': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'roberta_embeddings_roberta_tagalog_large': 'RoBertaEmbeddings',
        'roberta_embeddings_roberta_tagalog_base': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_spacylookup': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'lemma_penn': 'LemmatizerModel',
        'pos_tourism': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'lemma_imst': 'LemmatizerModel',
        'pos_boun': 'PerceptronModel',
        'pos_imst': 'PerceptronModel',
        'lemma_kenet': 'LemmatizerModel',
        'lemma_framenet': 'LemmatizerModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'roberta_embeddings_ukr_roberta_base': 'RoBertaEmbeddings',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_pos_bert_large_slavic_cyrillic_upos': 'BertForTokenClassification',
        'bert_pos_bert_base_slavic_cyrillic_upos': 'BertForTokenClassification',
        'bert_embeddings_muril_adapted_local': 'BertEmbeddings',
        'roberta_embeddings_roberta_urdu_small': 'RoBertaEmbeddings',
        'lemma_udtb': 'LemmatizerModel',
        'lemma_spacylookup': 'LemmatizerModel',
        'pos_udtb': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'stopwords_iso': 'StopWordsCleaner',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'pos_wtb': 'PerceptronModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'bert_embeddings_wobert_chinese_plus_base': 'BertEmbeddings',
        'bert_embeddings_bert_base_chinese_jinyong': 'BertEmbeddings',
        'bert_embeddings_rbt3': 'BertEmbeddings',
        'bert_embeddings_jdt_fin_roberta_wwm': 'BertEmbeddings',
        'bert_embeddings_mengzi_oscar_base': 'BertEmbeddings',
        'roberta_embeddings_roberta_base_wechsel_chinese': 'RoBertaEmbeddings',
        'bert_embeddings_sikubert': 'BertEmbeddings',
        'bert_embeddings_jdt_fin_roberta_wwm_large': 'BertEmbeddings',
        'bert_embeddings_rbtl3': 'BertEmbeddings',
        'bert_embeddings_macbert4csc_base_chinese': 'BertEmbeddings',
        'bert_pos_chinese_roberta_large_upos': 'BertForTokenClassification',
        'bert_pos_chinese_roberta_base_upos': 'BertForTokenClassification',
        'bert_pos_chinese_bert_wwm_ext_upos': 'BertForTokenClassification',
        'pos_gsd': 'PerceptronModel',
        'pos_gsdsimp': 'PerceptronModel',
        'stopwords_iso': 'StopWordsCleaner',
        'bert_pos_bert_base_chinese_pos': 'BertForTokenClassification',
        'bert_embeddings_rbt6': 'BertEmbeddings',
        'bert_embeddings_sikuroberta': 'BertEmbeddings',
        'bert_embeddings_uer_large': 'BertEmbeddings',
        'bert_embeddings_env_bert_chinese': 'BertEmbeddings',
        'bert_embeddings_chinese_roberta_wwm_ext': 'BertEmbeddings',
        'bert_embeddings_chinese_macbert_base': 'BertEmbeddings',
        'bert_embeddings_bert_base_zh_cased': 'BertEmbeddings',
        'bert_embeddings_bert_large_chinese': 'BertEmbeddings',
        'bert_embeddings_chinese_roberta_wwm_large_ext_fix_mlm': 'BertEmbeddings',
        'bert_embeddings_chinese_roberta_wwm_ext_large': 'BertEmbeddings',
        'bert_embeddings_chinese_bert_wwm_ext': 'BertEmbeddings',
        'bert_embeddings_chinese_macbert_large': 'BertEmbeddings',
        'bert_embeddings_mengzi_oscar_base_retrieval': 'BertEmbeddings',
        'bert_embeddings_mengzi_bert_base_fin': 'BertEmbeddings',
        'bert_embeddings_wobert_chinese_base': 'BertEmbeddings',
        'bert_embeddings_wobert_chinese_plus': 'BertEmbeddings',
        'bert_embeddings_rbt4': 'BertEmbeddings',
        'bert_embeddings_mengzi_oscar_base_caption': 'BertEmbeddings',
        'bert_embeddings_mengzi_bert_base': 'BertEmbeddings',
        'w2v_cc_300d': 'WordEmbeddingsModel',

        'classifierdl_electra_questionpair': 'ClassifierDLModel',
        'bert_sequence_classifier_question_statement': 'BertForSequenceClassification',
        'bert_sequence_classifier_song_lyrics': 'BertForSequenceClassification',

        'distilbert_embeddings_indic_transformers_bn_distilbert': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_de_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_german_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_en_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_uncased_sparse_90_unstructured_pruneofa': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_uncased_sparse_85_unstructured_pruneofa': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_es_multilingual_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_es_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_fa_zwnj_base': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_hi_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_indic_transformers_hi_distilbert': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_it_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_BERTino': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_ja_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_javanese_distilbert_small_imdb': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_nl_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_pl_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_pt_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_ro_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_ru_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_th_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_tr_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_uk_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_ur_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_zh_cased': 'DistilBertEmbeddings',
        'albert_embeddings_albert_xlarge_arabic': 'AlbertEmbeddings',
        'albert_embeddings_albert_large_arabic': 'AlbertEmbeddings',
        'albert_embeddings_albert_german_ner': 'AlbertEmbeddings',
        'albert_embeddings_albert_xlarge_v1': 'AlbertEmbeddings',
        'albert_embeddings_albert_base_v1': 'AlbertEmbeddings',
        'albert_embeddings_albert_xxlarge_v1': 'AlbertEmbeddings',
        'albert_embeddings_albert_fa_zwnj_base_v2': 'AlbertEmbeddings',
        'albert_embeddings_albert_base_japanese_v1': 'AlbertEmbeddings',
        'albert_embeddings_marathi_albert_v2': 'AlbertEmbeddings',
        'albert_embeddings_albert_tiny_bahasa_cased': 'AlbertEmbeddings',
        'albert_embeddings_albert_base_bahasa_cased': 'AlbertEmbeddings',
        'albert_embeddings_ALR_BERT': 'AlbertEmbeddings',

        'ner_biomedical_bc2gm': 'MedicalNerModel',
        'sbiobertresolve_rxnorm_action_treatment': 'SentenceEntityResolverModel',
        'rct_binary_classifier_use': 'ClassifierDLModel',
        'rct_binary_classifier_biobert': 'ClassifierDLModel',

        'deberta_v3_large_token_classifier_conll03': 'DeBertaForTokenClassification',
        'deberta_v3_base_token_classifier_conll03': 'DeBertaForTokenClassification',
        'deberta_v3_small_token_classifier_conll03': 'DeBertaForTokenClassification',
        'deberta_v3_xsmall_token_classifier_conll03': 'DeBertaForTokenClassification',
        'deberta_v3_large_token_classifier_ontonotes': 'DeBertaForTokenClassification',
        'deberta_v3_base_token_classifier_ontonotes': 'DeBertaForTokenClassification',
        'deberta_v3_small_token_classifier_ontonotes': 'DeBertaForTokenClassification',
        'deberta_v3_xsmall_token_classifier_ontonotes': 'DeBertaForTokenClassification',
        'camembert_large': 'CamemBertEmbeddings',
        'camembert_base': 'CamemBertEmbeddings',
        'camembert_base_ccnet_4gb': 'CamemBertEmbeddings',
        'camembert_base_ccnet': 'CamemBertEmbeddings',
        'camembert_base_oscar_4gb': 'CamemBertEmbeddings',
        'camembert_base_wikipedia_4gb': 'CamemBertEmbeddings',
        'albert_embeddings_fralbert_base': 'AlbertEmbeddings',
        'distilbert_embeddings_distilbert_base_fr_cased': 'DistilBertEmbeddings',
        'distilbert_embeddings_marathi_distilbert': 'DistilBertEmbeddings',
        'albert_embeddings_marathi_albert_v2': 'AlbertEmbeddings',
        'albert_embeddings_albert_large_bahasa_cased': 'AlbertEmbeddings',
        'distilbert_embeddings_malaysian_distilbert_small': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_indonesian': 'DistilBertEmbeddings',
        'distilbert_embeddings_javanese_distilbert_small': 'DistilBertEmbeddings',
        'distilbert_embeddings_distilbert_base_ar_cased': 'DistilBertEmbeddings',
        'albert_embeddings_albert_base_arabic': 'AlbertEmbeddings',
        'albert_embeddings_albert_fa_base_v2': 'AlbertEmbeddings',
        'albert_embeddings_marathi_albert': 'AlbertEmbeddings',

        'w2v_cc_300d': 'WordEmbeddingsModel',
        'albert_base_sequence_classifier_ag_news': 'AlbertForSequenceClassification',
        'albert_base_sequence_classifier_imdb': 'AlbertForSequenceClassification',
        'albert_base_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_base_uncased': 'AlbertEmbeddings',
        'albert_indic': 'AlbertEmbeddings',
        'albert_large_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_large_uncased': 'AlbertEmbeddings',
        'albert_xlarge_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_xlarge_uncased': 'AlbertEmbeddings',
        'albert_xxlarge_uncased': 'AlbertEmbeddings',
        'aner_cc_300d': 'NerDLModel',
        'arabic_w2v_cc_300d': 'WordEmbeddingsModel',
        'assertion_dl': 'AssertionDLModel',
        'assertion_dl_biobert': 'AssertionDLModel',
        'assertion_dl_healthcare': 'AssertionDLModel',
        'assertion_dl_large': 'AssertionDLModel',
        'assertion_dl_radiology': 'AssertionDLModel',
        'assertion_jsl': 'AssertionDLModel',
        'assertion_jsl_large': 'AssertionDLModel',
        'bengali_cc_300d': 'WordEmbeddingsModel',
        'bengaliner_cc_300d': 'NerDLModel',
        'bert_base_cased': 'BertEmbeddings',
        'bert_base_chinese': 'BertEmbeddings',
        'bert_base_dutch_cased': 'BertEmbeddings',
        'bert_base_finnish_cased': 'BertSentenceEmbeddings',
        'bert_base_finnish_uncased': 'BertSentenceEmbeddings',
        'bert_base_german_cased': 'BertEmbeddings',
        'bert_base_german_uncased': 'BertEmbeddings',
        'bert_base_italian_cased': 'BertEmbeddings',
        'bert_base_italian_uncased': 'BertEmbeddings',
        'bert_base_multilingual_cased': 'BertEmbeddings',
        'bert_base_multilingual_uncased': 'BertEmbeddings',
        'bert_base_sequence_classifier_ag_news': 'BertForSequenceClassification',
        'bert_base_sequence_classifier_dbpedia_14': 'BertForSequenceClassification',
        'bert_base_sequence_classifier_imdb': 'BertForSequenceClassification',
        'bert_base_token_classifier_conll03': 'BertForTokenClassification',
        'bert_base_token_classifier_few_nerd': 'BertForTokenClassification',
        'bert_base_token_classifier_ontonote': 'BertForTokenClassification',
        'bert_base_turkish_cased': 'BertEmbeddings',
        'bert_base_turkish_uncased': 'BertEmbeddings',
        'bert_base_uncased': 'BertEmbeddings',
        'bert_base_uncased_legal': 'BertEmbeddings',
        'bert_embeddings_ARBERT': 'BertEmbeddings',
        'bert_embeddings_German_MedBERT': 'BertEmbeddings',
        'bert_embeddings_bangla_bert_base': 'BertEmbeddings',
        'bert_embeddings_bert_base': 'BertEmbeddings',
        'bert_embeddings_bert_base_5lang_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_hi_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_it_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_tr_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_ur_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_vi_cased': 'BertEmbeddings',
        'bert_finnish_cased': 'BertEmbeddings',
        'bert_finnish_uncased': 'BertEmbeddings',
        'bert_hi_en_ner': 'BertForTokenClassification',
        'bert_large_cased': 'BertEmbeddings',
        'bert_large_sequence_classifier_imdb': 'BertForSequenceClassification',
        'bert_large_token_classifier_conll03': 'BertForTokenClassification',
        'bert_large_token_classifier_ontonote': 'BertForTokenClassification',
        'bert_large_uncased': 'BertEmbeddings',
        'bert_multi_cased': 'BertEmbeddings',
        'bert_muril': 'BertEmbeddings',
        'bert_portuguese_base_cased': 'BertEmbeddings',
        'bert_portuguese_large_cased': 'BertEmbeddings',
        'bert_pubmed': 'BertEmbeddings',
        'bert_pubmed_squad2': 'BertEmbeddings',
        'bert_sequence_classifier_stress': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_ade': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_dehatebert_mono': 'BertForSequenceClassification',
        'bert_sequence_classifier_emotion': 'BertForSequenceClassification',
        'bert_sequence_classifier_finbert': 'BertForSequenceClassification',
        'bert_sequence_classifier_finbert_tone': 'BertForSequenceClassification',
        'bert_sequence_classifier_gender_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_news_sentiment': 'BertForSequenceClassification',
        'bert_sequence_classifier_pico_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_question_statement_clinical': 'BertForSequenceClassification',
        'bert_sequence_classifier_rct_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_sentiment': 'BertForSequenceClassification',
        'bert_sequence_classifier_toxicity': 'BertForSequenceClassification',
        'bert_token_classifier_chinese_ner': 'BertForTokenClassification',
        'bert_token_classifier_drug_development_trials': 'BertForTokenClassification',
        'bert_token_classifier_dutch_udlassy_ner': 'BertForTokenClassification',
        'bert_token_classifier_hi_en_ner': 'BertForTokenClassification',
        'bert_token_classifier_ner_living_species': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_clinical_trials_abstracts': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_ade': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_anatomy': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_bacteria': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_bionlp': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_btc': 'BertForTokenClassification',
        'bert_token_classifier_ner_cellular': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_chemicals': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_chemprot': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_clinical': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_deid': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_drugs': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_jsl': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_jsl_slim': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_ud_gsd': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_armanner': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_ner': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_peymaner': 'BertForTokenClassification',
        'bert_token_classifier_scandi_ner': 'BertForTokenClassification',
        'bert_token_classifier_spanish_ner': 'BertForTokenClassification',
        'bert_token_classifier_swedish_ner': 'BertForTokenClassification',
        'bert_token_classifier_turkish_ner': 'BertForTokenClassification',
        'bert_wiki_books': 'BertEmbeddings',
        'bert_wiki_books_mnli': 'BertEmbeddings',
        'bert_wiki_books_qnli': 'BertEmbeddings',
        'bert_wiki_books_qqp': 'BertEmbeddings',
        'bert_wiki_books_squad2': 'BertEmbeddings',
        'bert_wiki_books_sst2': 'BertEmbeddings',
        'biobert_clinical_base_cased': 'BertEmbeddings',
        'biobert_discharge_base_cased': 'BertEmbeddings',
        'biobert_pmc_base_cased': 'BertEmbeddings',
        'biobert_pubmed_base_cased': 'BertEmbeddings',
        'biobert_pubmed_large_cased': 'BertEmbeddings',
        'biobert_pubmed_pmc_base_cased': 'BertEmbeddings',
        'chinese_bert_wwm': 'BertEmbeddings',
        'chinese_xlnet_base': 'XlnetEmbeddings',
        'chunk_embeddings': 'ChunkEmbeddings',
        'classifierdl_ade_biobert': 'ClassifierDLModel',
        'classifierdl_ade_clinicalbert': 'ClassifierDLModel',
        'classifierdl_ade_conversational_biobert': 'ClassifierDLModel',
        'classifierdl_bert_news': 'ClassifierDLModel',
        'classifierdl_bert_sentiment': 'ClassifierDLModel',
        'classifierdl_berturk_cyberbullying': 'ClassifierDLModel',
        'classifierdl_gender_biobert': 'ClassifierDLModel',
        'classifierdl_gender_sbert': 'ClassifierDLModel',
        'classifierdl_pico_biobert': 'ClassifierDLModel',
        'classifierdl_urduvec_fakenews': 'ClassifierDLModel',
        'classifierdl_use_atis': 'ClassifierDLModel',
        'classifierdl_use_cyberbullying': 'ClassifierDLModel',
        'classifierdl_use_emotion': 'ClassifierDLModel',
        'classifierdl_use_fakenews': 'ClassifierDLModel',
        'classifierdl_use_sarcasm': 'ClassifierDLModel',
        'classifierdl_use_snips': 'ClassifierDLModel',
        'classifierdl_use_spam': 'ClassifierDLModel',
        'classifierdl_use_trec50': 'ClassifierDLModel',
        'classifierdl_use_trec6': 'ClassifierDLModel',
        'clinical_longformer': 'LongformerEmbeddings',
        'context_parser': 'ContextualParserModel',
        'covidbert_large_uncased': 'BertEmbeddings',
        'dane_ner_6B_100': 'NerDLModel',
        'dane_ner_6B_300': 'NerDLModel',
        'dane_ner_840B_300': 'NerDLModel',
        'date_matcher': 'DateMatcher',
        'deberta_v3_base': 'DeBertaEmbeddings',
        'deberta_v3_base_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_large': 'DeBertaEmbeddings',
        'deberta_v3_large_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_small': 'DeBertaEmbeddings',
        'deberta_v3_small_sequence_classifier_ag_news': 'DeBertaForSequenceClassification',
        'deberta_v3_small_sequence_classifier_dbpedia_14': 'DeBertaForSequenceClassification',
        'deberta_v3_small_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_xsmall': 'DeBertaEmbeddings',
        'deberta_v3_xsmall_sequence_classifier_ag_news': 'DeBertaForSequenceClassification',
        'deberta_v3_xsmall_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'defaen.resolve.loinc.bluebertult_chunker': 'Chunker',
        'default_chunker': 'Chunker',
        'deid_rules': 'DeIdentificationModel',
        'deidentify_enriched_clinical': 'DeIdentificationModel',
        'deidentify_large': 'DeIdentificationModel',
        'deidentify_rb': 'DeIdentificationModel',
        'deidentify_rb_no_regex': 'DeIdentificationModel',
        'dependency_conllu': 'DependencyParserModel',
        'dependency_conllu.untyped': 'DependencyParserModel',
        'dependency_typed_conllu': 'TypedDependencyParserModel',
        'distilbert_base_cased': 'DistilBertEmbeddings',
        'distilbert_base_multilingual_cased': 'DistilBertEmbeddings',
        'distilbert_base_sequence_classifier_ag_news': 'DistilBertForSequenceClassification',
        'distilbert_base_sequence_classifier_amazon_polarity': 'DistilBertForSequenceClassification',
        'distilbert_base_sequence_classifier_imdb': 'DistilBertForSequenceClassification',
        'distilbert_base_token_classifier_masakhaner': 'DistilBertForTokenClassification',
        'distilbert_base_uncased': 'DistilBertEmbeddings',
        'distilbert_multilingual_sequence_classifier_allocine': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_ade': 'MedicalDistilBertForSequenceClassification',
        'distilbert_sequence_classifier_banking77': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_emotion': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_industry': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_policy': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_sst2': 'DistilBertForSequenceClassification',
        'distilbert_token_classifier_typo_detector': 'DistilBertForTokenClassification',
        'distilbert_uncased': 'DistilBertEmbeddings',
        'distilroberta_base': 'RoBertaEmbeddings',
        'distilroberta_base_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'doc2vec_gigaword_300': 'Doc2VecModel',
        'doc2vec_gigaword_wiki_300': 'Doc2VecModel',
        'drug_normalizer': 'NormalizerModel',
        'electra_base_uncased': 'BertEmbeddings',
        'electra_large_uncased': 'BertEmbeddings',
        'electra_medal_acronym': 'BertEmbeddings',
        'electra_small_uncased': 'BertEmbeddings',
        'elmo': 'ElmoEmbeddings',
        'embeddings_biovec': 'WordEmbeddingsModel',
        'embeddings_clinical': 'WordEmbeddingsModel',
        'embeddings_healthcare': 'WordEmbeddingsModel',
        'embeddings_healthcare_100d': 'WordEmbeddingsModel',
        'embeddings_icdoem': 'WordEmbeddingsModel',
        'embeddings_icdoem_2ng': 'WordEmbeddingsModel',
        'embeddings_scielo_150d': 'WordEmbeddingsModel',
        'embeddings_scielo_300d': 'WordEmbeddingsModel',
        'embeddings_scielo_50d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_150d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_300d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_50d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_150d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_300d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_50d': 'WordEmbeddingsModel',
        'finnish_ner_6B_100': 'NerDLModel',
        'finnish_ner_6B_300': 'NerDLModel',
        'finnish_ner_840B_300': 'NerDLModel',
        'glove_100d': 'WordEmbeddingsModel',
        'glove_6B_100': 'WordEmbeddingsModel',
        'glove_6B_300': 'WordEmbeddingsModel',
        'glove_840B_300': 'WordEmbeddingsModel',
        'google_t5_small_ssm_nq': 'T5Transformer',
        'gpt2': 'GPT2Transformer',
        'gpt2_distilled': 'GPT2Transformer',
        'gpt2_medium': 'GPT2Transformer',
        'gpt_large': 'GPT2Transformer',
        'hebrew_cc_300d': 'WordEmbeddingsModel',
        'hebrewner_cc_300d': 'NerDLModel',
        'hindi_cc_300d': 'WordEmbeddingsModel',
        'japanese_cc_300d': 'WordEmbeddingsModel',
        'jsl_ner_wip_clinical': 'MedicalNerModel',
        'jsl_ner_wip_greedy_clinical': 'MedicalNerModel',
        'jsl_ner_wip_modifier_clinical': 'MedicalNerModel',
        'jsl_rd_ner_wip_greedy_biobert': 'MedicalNerModel',
        'jsl_rd_ner_wip_greedy_clinical': 'MedicalNerModel',
        'labse': 'BertSentenceEmbeddings',
        'ld_tatoeba_bigru_21': 'LanguageDetectorDL',
        'ld_tatoeba_cnn_99': 'LanguageDetectorDL',
        'ld_wiki_20': 'LanguageDetectorDL',
        'ld_wiki_7': 'LanguageDetectorDL',
        'ld_wiki_cnn_231': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_21': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_220': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_375': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_43': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_95': 'LanguageDetectorDL',
        'lemma': 'LemmatizerModel',
        'lemma_afribooms': 'LemmatizerModel',
        'lemma_alksnis': 'LemmatizerModel',
        'lemma_alpino': 'LemmatizerModel',
        'lemma_ancora': 'LemmatizerModel',
        'lemma_antbnc': 'LemmatizerModel',
        'lemma_arcosg': 'LemmatizerModel',
        'lemma_atis': 'LemmatizerModel',
        'lemma_boun': 'LemmatizerModel',
        'lemma_btb': 'LemmatizerModel',
        'lemma_cac': 'LemmatizerModel',
        'lemma_ccg': 'LemmatizerModel',
        'lemma_csui': 'LemmatizerModel',
        'lemma_ctg': 'LemmatizerModel',
        'lemma_ddt': 'LemmatizerModel',
        'lemma_dxc': 'LemmatizerModel',
        'lemma_esl': 'LemmatizerModel',
        'lemma_farpahc': 'LemmatizerModel',
        'lemma_gdt': 'LemmatizerModel',
        'lemma_gsd': 'LemmatizerModel',
        'lemma_gsdluw': 'LemmatizerModel',
        'lemma_gsdsimp': 'LemmatizerModel',
        'lemma_gum': 'LemmatizerModel',
        'lemma_hdt': 'LemmatizerModel',
        'lemma_hdtb': 'LemmatizerModel',
        'lemma_htb': 'LemmatizerModel',
        'lemma_idt': 'LemmatizerModel',
        'lemma_isdt': 'LemmatizerModel',
        'lemma_ittb': 'LemmatizerModel',
        'lemma_iu': 'LemmatizerModel',
        'lemma_kyoto': 'LemmatizerModel',
        'lemma_lassysmall': 'LemmatizerModel',
        'lemma_lvtb': 'LemmatizerModel',
        'lemma_modern': 'LemmatizerModel',
        'lemma_nonstandard': 'LemmatizerModel',
        'lemma_nsc': 'LemmatizerModel',
        'lemma_nynorsklia': 'LemmatizerModel',
        'lemma_parisstories': 'LemmatizerModel',
        'lemma_partut': 'LemmatizerModel',
        'lemma_pdb': 'LemmatizerModel',
        'lemma_pdt': 'LemmatizerModel',
        'lemma_perdt': 'LemmatizerModel',
        'lemma_perseus': 'LemmatizerModel',
        'lemma_proiel': 'LemmatizerModel',
        'lemma_rhapsodie': 'LemmatizerModel',
        'lemma_rnc': 'LemmatizerModel',
        'lemma_rrt': 'LemmatizerModel',
        'lemma_sagt': 'LemmatizerModel',
        'lemma_scriptorium': 'LemmatizerModel',
        'lemma_sequoia': 'LemmatizerModel',
        'lemma_seraji': 'LemmatizerModel',
        'lemma_set': 'LemmatizerModel',
        'lemma_simonero': 'LemmatizerModel',
        'lemma_srcmf': 'LemmatizerModel',
        'lemma_ssj': 'LemmatizerModel',
        'lemma_syntagrus': 'LemmatizerModel',
        'lemma_szeged': 'LemmatizerModel',
        'lemma_taiga': 'LemmatizerModel',
        'lemma_talbanken': 'LemmatizerModel',
        'lemma_tourism': 'LemmatizerModel',
        'lemma_ttb': 'LemmatizerModel',
        'lemma_udante': 'LemmatizerModel',
        'lemma_udt': 'LemmatizerModel',
        'lemma_vit': 'LemmatizerModel',
        'lemma_vtb': 'LemmatizerModel',
        'lemma_wtb': 'LemmatizerModel',
        'longformer_base_4096': 'LongformerEmbeddings',
        'longformer_base_sequence_classifier_ag_news': 'LongformerForSequenceClassification',
        'longformer_base_sequence_classifier_imdb': 'LongformerForSequenceClassification',
        'longformer_base_token_classifier_conll03': 'LongformerForTokenClassification',
        'longformer_large_4096': 'LongformerEmbeddings',
        'mdeberta_v3_base': 'DeBertaEmbeddings',
        'mdeberta_v3_base_sequence_classifier_allocine': 'DeBertaForSequenceClassification',
        'mdeberta_v3_base_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'multiclassifierdl_use_e2e': 'MultiClassifierDLModel',
        'multiclassifierdl_use_toxic': 'MultiClassifierDLModel',
        'multiclassifierdl_use_toxic_sm': 'MultiClassifierDLModel',
        'ner_clinical_bert': 'MedicalNerModel',
        'ner_deid_subentity_bert': 'MedicalNerModel',
        'clinical_deidentification': 'MedicalNerModel',
        'ner_living_species_biobert': 'MedicalNerModel',
        'ner_living_species_300': 'MedicalNerModel',
        'ner_living_species': 'MedicalNerModel',
        'ner_living_species_roberta': 'MedicalNerModel',
        'ner_living_species_bert': 'MedicalNerModel',
        'ner_pathogen': 'MedicalNerModel',
        'ner_clinical_trials_abstracts': 'MedicalNerModel',
        'ner_abbreviation_clinical': 'MedicalNerModel',
        'ner_ade_biobert': 'MedicalNerModel',
        'ner_ade_clinical': 'MedicalNerModel',
        'ner_ade_clinicalbert': 'MedicalNerModel',
        'ner_ade_healthcare': 'MedicalNerModel',
        'ner_anatomy': 'MedicalNerModel',
        'ner_anatomy_biobert': 'MedicalNerModel',
        'ner_anatomy_coarse': 'MedicalNerModel',
        'ner_anatomy_coarse_biobert': 'MedicalNerModel',
        'ner_aspect_based_sentiment': 'MedicalNerModel',
        'ner_bacterial_species': 'MedicalNerModel',
        'ner_biomarker': 'MedicalNerModel',
        'ner_bionlp': 'MedicalNerModel',
        'ner_bionlp_biobert': 'MedicalNerModel',
        'ner_cancer_genetics': 'MedicalNerModel',
        'ner_cellular': 'MedicalNerModel',
        'ner_cellular_biobert': 'MedicalNerModel',
        'ner_chemd_clinical': 'MedicalNerModel',
        'ner_chemicals': 'MedicalNerModel',
        'ner_chemprot_biobert': 'MedicalNerModel',
        'ner_chemprot_clinical': 'MedicalNerModel',
        'ner_chexpert': 'MedicalNerModel',
        'ner_clinical': 'MedicalNerModel',
        'ner_clinical_biobert': 'MedicalNerModel',
        'ner_conll_albert_base_uncased': 'NerDLModel',
        'ner_conll_albert_large_uncased': 'NerDLModel',
        'ner_conll_bert_base_cased': 'NerDLModel',
        'ner_conll_distilbert_base_cased': 'NerDLModel',
        'ner_conll_longformer_large_4096': 'NerDLModel',
        'ner_conll_roberta_base': 'NerDLModel',
        'ner_conll_roberta_large': 'NerDLModel',
        'ner_conll_xlm_roberta_base': 'NerDLModel',
        'ner_conll_xlnet_base_cased': 'NerDLModel',
        'ner_covid_trials': 'MedicalNerModel',
        'ner_deid_augmented': 'MedicalNerModel',
        'ner_deid_biobert': 'MedicalNerModel',
        'ner_deid_enriched': 'MedicalNerModel',
        'ner_deid_enriched_biobert': 'MedicalNerModel',
        'ner_deid_generic': 'MedicalNerModel',
        'ner_deid_generic_augmented': 'MedicalNerModel',
        'ner_deid_generic_roberta_augmented': 'MedicalNerModel',
        'ner_deid_large': 'MedicalNerModel',
        'ner_deid_sd': 'MedicalNerModel',
        'ner_deid_sd_large': 'MedicalNerModel',
        'ner_deid_subentity': 'MedicalNerModel',
        'ner_deid_subentity_augmented': 'MedicalNerModel',
        'ner_deid_subentity_augmented_i2b2': 'MedicalNerModel',
        'ner_deid_subentity_roberta_augmented': 'MedicalNerModel',
        'ner_deid_synthetic': 'MedicalNerModel',
        'ner_deidentify_dl': 'MedicalNerModel',
        'ner_diag_proc': 'MedicalNerModel',
        'ner_diseases': 'MedicalNerModel',
        'ner_diseases_biobert': 'MedicalNerModel',
        'ner_diseases_large': 'MedicalNerModel',
        'ner_dl': 'NerDLModel',
        'ner_dl_bert': 'NerDLModel',
        'ner_dl_bert_base_cased': 'NerDLModel',
        'ner_dl_sentence': 'NerDLModel',
        'ner_drugprot_clinical': 'MedicalNerModel',
        'ner_drugs': 'MedicalNerModel',
        'ner_drugs_greedy': 'MedicalNerModel',
        'ner_drugs_large': 'MedicalNerModel',
        'ner_events_admission_clinical': 'MedicalNerModel',
        'ner_events_biobert': 'MedicalNerModel',
        'ner_events_clinical': 'MedicalNerModel',
        'ner_events_healthcare': 'MedicalNerModel',
        'ner_financial_contract': 'MedicalNerModel',
        'ner_genetic_variants': 'MedicalNerModel',
        'ner_healthcare': 'MedicalNerModel',
        'ner_healthcare_slim': 'MedicalNerModel',
        'ner_human_phenotype_gene_biobert': 'MedicalNerModel',
        'ner_human_phenotype_gene_clinical': 'MedicalNerModel',
        'ner_human_phenotype_go_biobert': 'MedicalNerModel',
        'ner_human_phenotype_go_clinical': 'MedicalNerModel',
        'ner_jifs_glove_840B_300d': 'NerDLModel',
        'ner_jsl': 'MedicalNerModel',
        'ner_jsl_biobert': 'MedicalNerModel',
        'ner_jsl_enriched': 'MedicalNerModel',
        'ner_jsl_enriched_biobert': 'MedicalNerModel',
        'ner_jsl_greedy_biobert': 'MedicalNerModel',
        'ner_jsl_slim': 'MedicalNerModel',
        'ner_kmou_glove_840B_300d': 'NerDLModel',
        'ner_legal': 'MedicalNerModel',
        'ner_lst20_glove_840B_300d': 'NerDLModel',
        'ner_measurements_clinical': 'MedicalNerModel',
        'ner_medmentions_coarse': 'MedicalNerModel',
        'ner_mit_movie_complex_bert_base_cased': 'NerDLModel',
        'ner_mit_movie_complex_distilbert_base_cased': 'NerDLModel',
        'ner_mit_movie_simple_distilbert_base_cased': 'NerDLModel',
        'ner_msra_bert_768d': 'NerDLModel',
        'ner_neoplasms': 'NerDLModel',
        'ner_nihss': 'MedicalNerModel',
        'ner_ontonotes_distilbert_base_cased': 'NerDLModel',
        'ner_ontonotes_roberta_base': 'NerDLModel',
        'ner_ontonotes_roberta_large': 'NerDLModel',
        'ner_posology': 'MedicalNerModel',
        'ner_posology_biobert': 'MedicalNerModel',
        'ner_posology_experimental': 'MedicalNerModel',
        'ner_posology_greedy': 'MedicalNerModel',
        'ner_posology_healthcare': 'MedicalNerModel',
        'ner_posology_large': 'MedicalNerModel',
        'ner_posology_large_biobert': 'MedicalNerModel',
        'ner_posology_small': 'MedicalNerModel',
        'ner_radiology': 'MedicalNerModel',
        'ner_radiology_wip_clinical': 'MedicalNerModel',
        'ner_risk_factors': 'MedicalNerModel',
        'ner_risk_factors_biobert': 'MedicalNerModel',
        'ner_supplement_clinical': 'MedicalNerModel',
        'ner_traffic': 'MedicalNerModel',
        'ner_ud_gsd_cc_300d': 'NerDLModel',
        'ner_ud_gsd_glove_840B_300d': 'NerDLModel',
        'ner_ud_gsd_xlm_roberta_base': 'NerDLModel',
        'ner_weibo_bert_768d': 'NerDLModel',
        'ner_wikiner_glove_840B_300': 'NerDLModel',
        'ner_wikiner_xlm_roberta_base': 'NerDLModel',
        'ner_xtreme_glove_840B_300': 'NerDLModel',
        'ner_xtreme_xlm_roberta_xtreme_base': 'NerDLModel',
        'nerdl_atis_840b_300d': 'NerDLModel',
        'nerdl_fewnerd_100d': 'NerDLModel',
        'nerdl_fewnerd_subentity_100d': 'NerDLModel',
        'nerdl_restaurant_100d': 'NerDLModel',
        'nerdl_snips_100d': 'NerDLModel',
        'nerdl_tumour_demo': 'MedicalNerModel',
        'ngram': 'NGramGenerator',
        'norm': 'NormalizerModel',
        'normalizer': 'NormalizerModel',
        'document_normalizer': 'DocumentNormalizer',
        'norne_6B_100': 'NerDLModel',
        'norne_6B_300': 'NerDLModel',
        'norne_840B_300': 'NerDLModel',
        'onto_100': 'NerDLModel',
        'onto_300': 'NerDLModel',
        'onto_bert_base_cased': 'NerDLModel',
        'onto_bert_large_cased': 'NerDLModel',
        'onto_electra_base_uncased': 'NerDLModel',
        'onto_electra_large_uncased': 'NerDLModel',
        'onto_electra_small_uncased': 'NerDLModel',
        'onto_small_bert_L2_128': 'NerDLModel',
        'onto_small_bert_L4_256': 'NerDLModel',
        'onto_small_bert_L4_512': 'NerDLModel',
        'onto_small_bert_L8_512': 'NerDLModel',
        'opus_mt_aav_en': 'MarianTransformer',
        'opus_mt_aed_es': 'MarianTransformer',
        'opus_mt_af_de': 'MarianTransformer',
        'opus_mt_af_en': 'MarianTransformer',
        'opus_mt_af_eo': 'MarianTransformer',
        'opus_mt_af_es': 'MarianTransformer',
        'opus_mt_af_fi': 'MarianTransformer',
        'opus_mt_af_fr': 'MarianTransformer',
        'opus_mt_af_nl': 'MarianTransformer',
        'opus_mt_af_ru': 'MarianTransformer',
        'opus_mt_af_sv': 'MarianTransformer',
        'opus_mt_afa_afa': 'MarianTransformer',
        'opus_mt_afa_en': 'MarianTransformer',
        'opus_mt_alv_en': 'MarianTransformer',
        'opus_mt_am_sv': 'MarianTransformer',
        'opus_mt_ar_de': 'MarianTransformer',
        'opus_mt_ar_el': 'MarianTransformer',
        'opus_mt_ar_en': 'MarianTransformer',
        'opus_mt_ar_eo': 'MarianTransformer',
        'opus_mt_ar_es': 'MarianTransformer',
        'opus_mt_ar_fr': 'MarianTransformer',
        'opus_mt_ar_he': 'MarianTransformer',
        'opus_mt_ar_it': 'MarianTransformer',
        'opus_mt_ar_pl': 'MarianTransformer',
        'opus_mt_ar_ru': 'MarianTransformer',
        'opus_mt_ar_tr': 'MarianTransformer',
        'opus_mt_art_en': 'MarianTransformer',
        'opus_mt_ase_de': 'MarianTransformer',
        'opus_mt_ase_en': 'MarianTransformer',
        'opus_mt_ase_es': 'MarianTransformer',
        'opus_mt_ase_fr': 'MarianTransformer',
        'opus_mt_ase_sv': 'MarianTransformer',
        'opus_mt_az_en': 'MarianTransformer',
        'opus_mt_az_es': 'MarianTransformer',
        'opus_mt_az_tr': 'MarianTransformer',
        'opus_mt_bat_en': 'MarianTransformer',
        'opus_mt_bcl_de': 'MarianTransformer',
        'opus_mt_bcl_en': 'MarianTransformer',
        'opus_mt_bcl_es': 'MarianTransformer',
        'opus_mt_bcl_fi': 'MarianTransformer',
        'opus_mt_bcl_fr': 'MarianTransformer',
        'opus_mt_bcl_sv': 'MarianTransformer',
        'opus_mt_be_es': 'MarianTransformer',
        'opus_mt_bem_en': 'MarianTransformer',
        'opus_mt_bem_es': 'MarianTransformer',
        'opus_mt_bem_fi': 'MarianTransformer',
        'opus_mt_bem_fr': 'MarianTransformer',
        'opus_mt_bem_sv': 'MarianTransformer',
        'opus_mt_ber_en': 'MarianTransformer',
        'opus_mt_ber_es': 'MarianTransformer',
        'opus_mt_ber_fr': 'MarianTransformer',
        'opus_mt_bg_de': 'MarianTransformer',
        'opus_mt_bg_en': 'MarianTransformer',
        'opus_mt_bg_eo': 'MarianTransformer',
        'opus_mt_bg_es': 'MarianTransformer',
        'opus_mt_bg_fi': 'MarianTransformer',
        'opus_mt_bg_fr': 'MarianTransformer',
        'opus_mt_bg_it': 'MarianTransformer',
        'opus_mt_bg_ru': 'MarianTransformer',
        'opus_mt_bg_sv': 'MarianTransformer',
        'opus_mt_bg_tr': 'MarianTransformer',
        'opus_mt_bg_uk': 'MarianTransformer',
        'opus_mt_bi_en': 'MarianTransformer',
        'opus_mt_bi_es': 'MarianTransformer',
        'opus_mt_bi_fr': 'MarianTransformer',
        'opus_mt_bi_sv': 'MarianTransformer',
        'opus_mt_bn_en': 'MarianTransformer',
        'opus_mt_bnt_en': 'MarianTransformer',
        'opus_mt_bzs_en': 'MarianTransformer',
        'opus_mt_bzs_es': 'MarianTransformer',
        'opus_mt_bzs_fi': 'MarianTransformer',
        'opus_mt_bzs_fr': 'MarianTransformer',
        'opus_mt_bzs_sv': 'MarianTransformer',
        'opus_mt_ca_de': 'MarianTransformer',
        'opus_mt_ca_en': 'MarianTransformer',
        'opus_mt_ca_es': 'MarianTransformer',
        'opus_mt_ca_fr': 'MarianTransformer',
        'opus_mt_ca_it': 'MarianTransformer',
        'opus_mt_ca_nl': 'MarianTransformer',
        'opus_mt_ca_pt': 'MarianTransformer',
        'opus_mt_ca_uk': 'MarianTransformer',
        'opus_mt_cau_en': 'MarianTransformer',
        'opus_mt_ccs_en': 'MarianTransformer',
        'opus_mt_ceb_en': 'MarianTransformer',
        'opus_mt_ceb_es': 'MarianTransformer',
        'opus_mt_ceb_fi': 'MarianTransformer',
        'opus_mt_ceb_fr': 'MarianTransformer',
        'opus_mt_ceb_sv': 'MarianTransformer',
        'opus_mt_cel_en': 'MarianTransformer',
        'opus_mt_chk_en': 'MarianTransformer',
        'opus_mt_chk_es': 'MarianTransformer',
        'opus_mt_chk_fr': 'MarianTransformer',
        'opus_mt_chk_sv': 'MarianTransformer',
        'opus_mt_cpf_en': 'MarianTransformer',
        'opus_mt_cpp_cpp': 'MarianTransformer',
        'opus_mt_cpp_en': 'MarianTransformer',
        'opus_mt_crs_de': 'MarianTransformer',
        'opus_mt_crs_en': 'MarianTransformer',
        'opus_mt_crs_es': 'MarianTransformer',
        'opus_mt_crs_fi': 'MarianTransformer',
        'opus_mt_crs_fr': 'MarianTransformer',
        'opus_mt_crs_sv': 'MarianTransformer',
        'opus_mt_cs_de': 'MarianTransformer',
        'opus_mt_cs_en': 'MarianTransformer',
        'opus_mt_cs_eo': 'MarianTransformer',
        'opus_mt_cs_fi': 'MarianTransformer',
        'opus_mt_cs_fr': 'MarianTransformer',
        'opus_mt_cs_sv': 'MarianTransformer',
        'opus_mt_cs_uk': 'MarianTransformer',
        'opus_mt_csg_es': 'MarianTransformer',
        'opus_mt_csn_es': 'MarianTransformer',
        'opus_mt_cus_en': 'MarianTransformer',
        'opus_mt_cy_en': 'MarianTransformer',
        'opus_mt_da_de': 'MarianTransformer',
        'opus_mt_da_en': 'MarianTransformer',
        'opus_mt_da_eo': 'MarianTransformer',
        'opus_mt_da_es': 'MarianTransformer',
        'opus_mt_da_fi': 'MarianTransformer',
        'opus_mt_da_fr': 'MarianTransformer',
        'opus_mt_da_no': 'MarianTransformer',
        'opus_mt_da_ru': 'MarianTransformer',
        'opus_mt_de_af': 'MarianTransformer',
        'opus_mt_de_ar': 'MarianTransformer',
        'opus_mt_de_ase': 'MarianTransformer',
        'opus_mt_de_bcl': 'MarianTransformer',
        'opus_mt_de_bg': 'MarianTransformer',
        'opus_mt_de_bi': 'MarianTransformer',
        'opus_mt_de_bzs': 'MarianTransformer',
        'opus_mt_de_ca': 'MarianTransformer',
        'opus_mt_de_crs': 'MarianTransformer',
        'opus_mt_de_cs': 'MarianTransformer',
        'opus_mt_de_da': 'MarianTransformer',
        'opus_mt_de_de': 'MarianTransformer',
        'opus_mt_de_ee': 'MarianTransformer',
        'opus_mt_de_efi': 'MarianTransformer',
        'opus_mt_de_el': 'MarianTransformer',
        'opus_mt_de_en': 'MarianTransformer',
        'opus_mt_de_eo': 'MarianTransformer',
        'opus_mt_de_es': 'MarianTransformer',
        'opus_mt_de_et': 'MarianTransformer',
        'opus_mt_de_eu': 'MarianTransformer',
        'opus_mt_de_fi': 'MarianTransformer',
        'opus_mt_de_fj': 'MarianTransformer',
        'opus_mt_de_fr': 'MarianTransformer',
        'opus_mt_de_gaa': 'MarianTransformer',
        'opus_mt_de_gil': 'MarianTransformer',
        'opus_mt_de_guw': 'MarianTransformer',
        'opus_mt_de_ha': 'MarianTransformer',
        'opus_mt_de_he': 'MarianTransformer',
        'opus_mt_de_hil': 'MarianTransformer',
        'opus_mt_de_ho': 'MarianTransformer',
        'opus_mt_de_hr': 'MarianTransformer',
        'opus_mt_de_ht': 'MarianTransformer',
        'opus_mt_de_hu': 'MarianTransformer',
        'opus_mt_de_ig': 'MarianTransformer',
        'opus_mt_de_ilo': 'MarianTransformer',
        'opus_mt_de_is': 'MarianTransformer',
        'opus_mt_de_iso': 'MarianTransformer',
        'opus_mt_de_it': 'MarianTransformer',
        'opus_mt_de_kg': 'MarianTransformer',
        'opus_mt_de_ln': 'MarianTransformer',
        'opus_mt_de_loz': 'MarianTransformer',
        'opus_mt_de_lt': 'MarianTransformer',
        'opus_mt_de_lua': 'MarianTransformer',
        'opus_mt_de_ms': 'MarianTransformer',
        'opus_mt_de_mt': 'MarianTransformer',
        'opus_mt_de_niu': 'MarianTransformer',
        'opus_mt_de_nl': 'MarianTransformer',
        'opus_mt_de_no': 'MarianTransformer',
        'opus_mt_de_nso': 'MarianTransformer',
        'opus_mt_de_ny': 'MarianTransformer',
        'opus_mt_de_pag': 'MarianTransformer',
        'opus_mt_de_pap': 'MarianTransformer',
        'opus_mt_de_pis': 'MarianTransformer',
        'opus_mt_de_pl': 'MarianTransformer',
        'opus_mt_de_pon': 'MarianTransformer',
        'opus_mt_de_tl': 'MarianTransformer',
        'opus_mt_de_uk': 'MarianTransformer',
        'opus_mt_de_vi': 'MarianTransformer',
        'opus_mt_dra_en': 'MarianTransformer',
        'opus_mt_ee_de': 'MarianTransformer',
        'opus_mt_ee_en': 'MarianTransformer',
        'opus_mt_ee_es': 'MarianTransformer',
        'opus_mt_ee_fi': 'MarianTransformer',
        'opus_mt_ee_fr': 'MarianTransformer',
        'opus_mt_ee_sv': 'MarianTransformer',
        'opus_mt_efi_de': 'MarianTransformer',
        'opus_mt_efi_en': 'MarianTransformer',
        'opus_mt_efi_fi': 'MarianTransformer',
        'opus_mt_efi_fr': 'MarianTransformer',
        'opus_mt_efi_sv': 'MarianTransformer',
        'opus_mt_el_ar': 'MarianTransformer',
        'opus_mt_el_eo': 'MarianTransformer',
        'opus_mt_el_fi': 'MarianTransformer',
        'opus_mt_el_fr': 'MarianTransformer',
        'opus_mt_el_sv': 'MarianTransformer',
        'opus_mt_en_aav': 'MarianTransformer',
        'opus_mt_en_af': 'MarianTransformer',
        'opus_mt_en_afa': 'MarianTransformer',
        'opus_mt_en_alv': 'MarianTransformer',
        'opus_mt_en_ar': 'MarianTransformer',
        'opus_mt_en_az': 'MarianTransformer',
        'opus_mt_en_bat': 'MarianTransformer',
        'opus_mt_en_bcl': 'MarianTransformer',
        'opus_mt_en_bem': 'MarianTransformer',
        'opus_mt_en_ber': 'MarianTransformer',
        'opus_mt_en_bg': 'MarianTransformer',
        'opus_mt_en_bi': 'MarianTransformer',
        'opus_mt_en_bnt': 'MarianTransformer',
        'opus_mt_en_bzs': 'MarianTransformer',
        'opus_mt_en_ca': 'MarianTransformer',
        'opus_mt_en_ceb': 'MarianTransformer',
        'opus_mt_en_cel': 'MarianTransformer',
        'opus_mt_en_chk': 'MarianTransformer',
        'opus_mt_en_cpf': 'MarianTransformer',
        'opus_mt_en_cpp': 'MarianTransformer',
        'opus_mt_en_crs': 'MarianTransformer',
        'opus_mt_en_cs': 'MarianTransformer',
        'opus_mt_en_cus': 'MarianTransformer',
        'opus_mt_en_cy': 'MarianTransformer',
        'opus_mt_en_da': 'MarianTransformer',
        'opus_mt_en_de': 'MarianTransformer',
        'opus_mt_en_dra': 'MarianTransformer',
        'opus_mt_en_ee': 'MarianTransformer',
        'opus_mt_en_efi': 'MarianTransformer',
        'opus_mt_en_el': 'MarianTransformer',
        'opus_mt_en_eo': 'MarianTransformer',
        'opus_mt_en_es': 'MarianTransformer',
        'opus_mt_en_et': 'MarianTransformer',
        'opus_mt_en_eu': 'MarianTransformer',
        'opus_mt_en_euq': 'MarianTransformer',
        'opus_mt_en_fi': 'MarianTransformer',
        'opus_mt_en_fiu': 'MarianTransformer',
        'opus_mt_en_fj': 'MarianTransformer',
        'opus_mt_en_fr': 'MarianTransformer',
        'opus_mt_en_ga': 'MarianTransformer',
        'opus_mt_en_gaa': 'MarianTransformer',
        'opus_mt_en_gem': 'MarianTransformer',
        'opus_mt_en_gil': 'MarianTransformer',
        'opus_mt_en_gl': 'MarianTransformer',
        'opus_mt_en_gmq': 'MarianTransformer',
        'opus_mt_en_gmw': 'MarianTransformer',
        'opus_mt_en_grk': 'MarianTransformer',
        'opus_mt_en_guw': 'MarianTransformer',
        'opus_mt_en_gv': 'MarianTransformer',
        'opus_mt_en_ha': 'MarianTransformer',
        'opus_mt_en_he': 'MarianTransformer',
        'opus_mt_en_hi': 'MarianTransformer',
        'opus_mt_en_hil': 'MarianTransformer',
        'opus_mt_en_ho': 'MarianTransformer',
        'opus_mt_en_ht': 'MarianTransformer',
        'opus_mt_en_hu': 'MarianTransformer',
        'opus_mt_en_hy': 'MarianTransformer',
        'opus_mt_en_id': 'MarianTransformer',
        'opus_mt_en_ig': 'MarianTransformer',
        'opus_mt_en_iir': 'MarianTransformer',
        'opus_mt_en_ilo': 'MarianTransformer',
        'opus_mt_en_inc': 'MarianTransformer',
        'opus_mt_en_ine': 'MarianTransformer',
        'opus_mt_en_is': 'MarianTransformer',
        'opus_mt_en_iso': 'MarianTransformer',
        'opus_mt_en_it': 'MarianTransformer',
        'opus_mt_en_itc': 'MarianTransformer',
        'opus_mt_en_jap': 'MarianTransformer',
        'opus_mt_en_kg': 'MarianTransformer',
        'opus_mt_en_kj': 'MarianTransformer',
        'opus_mt_en_kqn': 'MarianTransformer',
        'opus_mt_en_kwn': 'MarianTransformer',
        'opus_mt_en_kwy': 'MarianTransformer',
        'opus_mt_en_lg': 'MarianTransformer',
        'opus_mt_en_ln': 'MarianTransformer',
        'opus_mt_en_loz': 'MarianTransformer',
        'opus_mt_en_lu': 'MarianTransformer',
        'opus_mt_en_lua': 'MarianTransformer',
        'opus_mt_en_lue': 'MarianTransformer',
        'opus_mt_en_lun': 'MarianTransformer',
        'opus_mt_en_luo': 'MarianTransformer',
        'opus_mt_en_lus': 'MarianTransformer',
        'opus_mt_en_map': 'MarianTransformer',
        'opus_mt_en_mfe': 'MarianTransformer',
        'opus_mt_en_mg': 'MarianTransformer',
        'opus_mt_en_mh': 'MarianTransformer',
        'opus_mt_en_mk': 'MarianTransformer',
        'opus_mt_en_mkh': 'MarianTransformer',
        'opus_mt_en_ml': 'MarianTransformer',
        'opus_mt_en_mos': 'MarianTransformer',
        'opus_mt_en_mr': 'MarianTransformer',
        'opus_mt_en_mt': 'MarianTransformer',
        'opus_mt_en_mul': 'MarianTransformer',
        'opus_mt_en_ng': 'MarianTransformer',
        'opus_mt_en_nic': 'MarianTransformer',
        'opus_mt_en_niu': 'MarianTransformer',
        'opus_mt_en_nl': 'MarianTransformer',
        'opus_mt_en_nso': 'MarianTransformer',
        'opus_mt_en_ny': 'MarianTransformer',
        'opus_mt_en_nyk': 'MarianTransformer',
        'opus_mt_en_om': 'MarianTransformer',
        'opus_mt_en_pag': 'MarianTransformer',
        'opus_mt_en_pap': 'MarianTransformer',
        'opus_mt_en_phi': 'MarianTransformer',
        'opus_mt_en_pis': 'MarianTransformer',
        'opus_mt_en_pon': 'MarianTransformer',
        'opus_mt_en_poz': 'MarianTransformer',
        'opus_mt_en_pqe': 'MarianTransformer',
        'opus_mt_en_pqw': 'MarianTransformer',
        'opus_mt_en_rn': 'MarianTransformer',
        'opus_mt_en_rnd': 'MarianTransformer',
        'opus_mt_en_ro': 'MarianTransformer',
        'opus_mt_en_roa': 'MarianTransformer',
        'opus_mt_en_ru': 'MarianTransformer',
        'opus_mt_en_run': 'MarianTransformer',
        'opus_mt_en_rw': 'MarianTransformer',
        'opus_mt_en_sal': 'MarianTransformer',
        'opus_mt_en_sem': 'MarianTransformer',
        'opus_mt_en_sg': 'MarianTransformer',
        'opus_mt_en_sit': 'MarianTransformer',
        'opus_mt_en_sk': 'MarianTransformer',
        'opus_mt_en_sla': 'MarianTransformer',
        'opus_mt_en_sm': 'MarianTransformer',
        'opus_mt_en_sn': 'MarianTransformer',
        'opus_mt_en_sq': 'MarianTransformer',
        'opus_mt_en_ss': 'MarianTransformer',
        'opus_mt_en_st': 'MarianTransformer',
        'opus_mt_en_sv': 'MarianTransformer',
        'opus_mt_en_sw': 'MarianTransformer',
        'opus_mt_en_swc': 'MarianTransformer',
        'opus_mt_en_tdt': 'MarianTransformer',
        'opus_mt_en_ti': 'MarianTransformer',
        'opus_mt_en_tiv': 'MarianTransformer',
        'opus_mt_en_tl': 'MarianTransformer',
        'opus_mt_en_tll': 'MarianTransformer',
        'opus_mt_en_tn': 'MarianTransformer',
        'opus_mt_en_to': 'MarianTransformer',
        'opus_mt_en_toi': 'MarianTransformer',
        'opus_mt_en_tpi': 'MarianTransformer',
        'opus_mt_en_trk': 'MarianTransformer',
        'opus_mt_en_ts': 'MarianTransformer',
        'opus_mt_en_tut': 'MarianTransformer',
        'opus_mt_en_tvl': 'MarianTransformer',
        'opus_mt_en_tw': 'MarianTransformer',
        'opus_mt_en_ty': 'MarianTransformer',
        'opus_mt_en_uk': 'MarianTransformer',
        'opus_mt_en_umb': 'MarianTransformer',
        'opus_mt_en_ur': 'MarianTransformer',
        'opus_mt_en_urj': 'MarianTransformer',
        'opus_mt_en_vi': 'MarianTransformer',
        'opus_mt_en_xh': 'MarianTransformer',
        'opus_mt_en_zh': 'MarianTransformer',
        'opus_mt_en_zle': 'MarianTransformer',
        'opus_mt_en_zls': 'MarianTransformer',
        'opus_mt_en_zlw': 'MarianTransformer',
        'opus_mt_eo_af': 'MarianTransformer',
        'opus_mt_eo_bg': 'MarianTransformer',
        'opus_mt_eo_cs': 'MarianTransformer',
        'opus_mt_eo_da': 'MarianTransformer',
        'opus_mt_eo_de': 'MarianTransformer',
        'opus_mt_eo_el': 'MarianTransformer',
        'opus_mt_eo_en': 'MarianTransformer',
        'opus_mt_eo_es': 'MarianTransformer',
        'opus_mt_eo_fi': 'MarianTransformer',
        'opus_mt_eo_fr': 'MarianTransformer',
        'opus_mt_eo_he': 'MarianTransformer',
        'opus_mt_eo_hu': 'MarianTransformer',
        'opus_mt_eo_it': 'MarianTransformer',
        'opus_mt_eo_nl': 'MarianTransformer',
        'opus_mt_eo_pl': 'MarianTransformer',
        'opus_mt_eo_pt': 'MarianTransformer',
        'opus_mt_eo_ro': 'MarianTransformer',
        'opus_mt_eo_ru': 'MarianTransformer',
        'opus_mt_eo_sh': 'MarianTransformer',
        'opus_mt_eo_sv': 'MarianTransformer',
        'opus_mt_es_aed': 'MarianTransformer',
        'opus_mt_es_af': 'MarianTransformer',
        'opus_mt_es_ar': 'MarianTransformer',
        'opus_mt_es_ase': 'MarianTransformer',
        'opus_mt_es_bcl': 'MarianTransformer',
        'opus_mt_es_ber': 'MarianTransformer',
        'opus_mt_es_bg': 'MarianTransformer',
        'opus_mt_es_bi': 'MarianTransformer',
        'opus_mt_es_bzs': 'MarianTransformer',
        'opus_mt_es_ca': 'MarianTransformer',
        'opus_mt_es_ceb': 'MarianTransformer',
        'opus_mt_es_crs': 'MarianTransformer',
        'opus_mt_es_cs': 'MarianTransformer',
        'opus_mt_es_csg': 'MarianTransformer',
        'opus_mt_es_csn': 'MarianTransformer',
        'opus_mt_es_da': 'MarianTransformer',
        'opus_mt_es_de': 'MarianTransformer',
        'opus_mt_es_ee': 'MarianTransformer',
        'opus_mt_es_efi': 'MarianTransformer',
        'opus_mt_es_el': 'MarianTransformer',
        'opus_mt_es_en': 'MarianTransformer',
        'opus_mt_es_eo': 'MarianTransformer',
        'opus_mt_es_es': 'MarianTransformer',
        'opus_mt_es_et': 'MarianTransformer',
        'opus_mt_es_eu': 'MarianTransformer',
        'opus_mt_es_fi': 'MarianTransformer',
        'opus_mt_es_fj': 'MarianTransformer',
        'opus_mt_es_fr': 'MarianTransformer',
        'opus_mt_es_gaa': 'MarianTransformer',
        'opus_mt_es_gil': 'MarianTransformer',
        'opus_mt_es_gl': 'MarianTransformer',
        'opus_mt_es_guw': 'MarianTransformer',
        'opus_mt_es_ha': 'MarianTransformer',
        'opus_mt_es_he': 'MarianTransformer',
        'opus_mt_es_hil': 'MarianTransformer',
        'opus_mt_es_ho': 'MarianTransformer',
        'opus_mt_es_hr': 'MarianTransformer',
        'opus_mt_es_ht': 'MarianTransformer',
        'opus_mt_es_id': 'MarianTransformer',
        'opus_mt_es_ig': 'MarianTransformer',
        'opus_mt_es_ilo': 'MarianTransformer',
        'opus_mt_es_is': 'MarianTransformer',
        'opus_mt_es_iso': 'MarianTransformer',
        'opus_mt_es_it': 'MarianTransformer',
        'opus_mt_es_kg': 'MarianTransformer',
        'opus_mt_es_ln': 'MarianTransformer',
        'opus_mt_es_loz': 'MarianTransformer',
        'opus_mt_es_lt': 'MarianTransformer',
        'opus_mt_es_lua': 'MarianTransformer',
        'opus_mt_es_lus': 'MarianTransformer',
        'opus_mt_es_mfs': 'MarianTransformer',
        'opus_mt_es_mk': 'MarianTransformer',
        'opus_mt_es_mt': 'MarianTransformer',
        'opus_mt_es_niu': 'MarianTransformer',
        'opus_mt_es_nl': 'MarianTransformer',
        'opus_mt_es_no': 'MarianTransformer',
        'opus_mt_es_nso': 'MarianTransformer',
        'opus_mt_es_ny': 'MarianTransformer',
        'opus_mt_es_pag': 'MarianTransformer',
        'opus_mt_es_pap': 'MarianTransformer',
        'opus_mt_es_pis': 'MarianTransformer',
        'opus_mt_es_pl': 'MarianTransformer',
        'opus_mt_es_pon': 'MarianTransformer',
        'opus_mt_es_prl': 'MarianTransformer',
        'opus_mt_es_rn': 'MarianTransformer',
        'opus_mt_es_ro': 'MarianTransformer',
        'opus_mt_es_ru': 'MarianTransformer',
        'opus_mt_es_rw': 'MarianTransformer',
        'opus_mt_es_sg': 'MarianTransformer',
        'opus_mt_es_sl': 'MarianTransformer',
        'opus_mt_es_sm': 'MarianTransformer',
        'opus_mt_es_sn': 'MarianTransformer',
        'opus_mt_es_srn': 'MarianTransformer',
        'opus_mt_es_st': 'MarianTransformer',
        'opus_mt_es_swc': 'MarianTransformer',
        'opus_mt_es_tl': 'MarianTransformer',
        'opus_mt_es_tll': 'MarianTransformer',
        'opus_mt_es_tn': 'MarianTransformer',
        'opus_mt_es_to': 'MarianTransformer',
        'opus_mt_es_tpi': 'MarianTransformer',
        'opus_mt_es_tvl': 'MarianTransformer',
        'opus_mt_es_tw': 'MarianTransformer',
        'opus_mt_es_ty': 'MarianTransformer',
        'opus_mt_es_tzo': 'MarianTransformer',
        'opus_mt_es_uk': 'MarianTransformer',
        'opus_mt_es_ve': 'MarianTransformer',
        'opus_mt_es_vi': 'MarianTransformer',
        'opus_mt_es_war': 'MarianTransformer',
        'opus_mt_es_wls': 'MarianTransformer',
        'opus_mt_es_xh': 'MarianTransformer',
        'opus_mt_es_yo': 'MarianTransformer',
        'opus_mt_es_yua': 'MarianTransformer',
        'opus_mt_es_zai': 'MarianTransformer',
        'opus_mt_et_de': 'MarianTransformer',
        'opus_mt_et_en': 'MarianTransformer',
        'opus_mt_et_es': 'MarianTransformer',
        'opus_mt_et_fi': 'MarianTransformer',
        'opus_mt_et_fr': 'MarianTransformer',
        'opus_mt_et_ru': 'MarianTransformer',
        'opus_mt_et_sv': 'MarianTransformer',
        'opus_mt_eu_de': 'MarianTransformer',
        'opus_mt_eu_en': 'MarianTransformer',
        'opus_mt_eu_es': 'MarianTransformer',
        'opus_mt_eu_ru': 'MarianTransformer',
        'opus_mt_euq_en': 'MarianTransformer',
        'opus_mt_fi_af': 'MarianTransformer',
        'opus_mt_fi_bcl': 'MarianTransformer',
        'opus_mt_fi_bem': 'MarianTransformer',
        'opus_mt_fi_bg': 'MarianTransformer',
        'opus_mt_fi_bzs': 'MarianTransformer',
        'opus_mt_fi_ceb': 'MarianTransformer',
        'opus_mt_fi_crs': 'MarianTransformer',
        'opus_mt_fi_cs': 'MarianTransformer',
        'opus_mt_fi_de': 'MarianTransformer',
        'opus_mt_fi_ee': 'MarianTransformer',
        'opus_mt_fi_efi': 'MarianTransformer',
        'opus_mt_fi_el': 'MarianTransformer',
        'opus_mt_fi_en': 'MarianTransformer',
        'opus_mt_fi_eo': 'MarianTransformer',
        'opus_mt_fi_es': 'MarianTransformer',
        'opus_mt_fi_et': 'MarianTransformer',
        'opus_mt_fi_fi': 'MarianTransformer',
        'opus_mt_fi_fj': 'MarianTransformer',
        'opus_mt_fi_fr': 'MarianTransformer',
        'opus_mt_fi_fse': 'MarianTransformer',
        'opus_mt_fi_gaa': 'MarianTransformer',
        'opus_mt_fi_gil': 'MarianTransformer',
        'opus_mt_fi_guw': 'MarianTransformer',
        'opus_mt_fi_ha': 'MarianTransformer',
        'opus_mt_fi_he': 'MarianTransformer',
        'opus_mt_fi_hil': 'MarianTransformer',
        'opus_mt_fi_ho': 'MarianTransformer',
        'opus_mt_fi_hr': 'MarianTransformer',
        'opus_mt_fi_ht': 'MarianTransformer',
        'opus_mt_fi_hu': 'MarianTransformer',
        'opus_mt_fi_id': 'MarianTransformer',
        'opus_mt_fi_ig': 'MarianTransformer',
        'opus_mt_fi_ilo': 'MarianTransformer',
        'opus_mt_fi_is': 'MarianTransformer',
        'opus_mt_fi_iso': 'MarianTransformer',
        'opus_mt_fi_it': 'MarianTransformer',
        'opus_mt_fi_kg': 'MarianTransformer',
        'opus_mt_fi_kqn': 'MarianTransformer',
        'opus_mt_fi_lg': 'MarianTransformer',
        'opus_mt_fi_ln': 'MarianTransformer',
        'opus_mt_fi_lu': 'MarianTransformer',
        'opus_mt_fi_lua': 'MarianTransformer',
        'opus_mt_fi_lue': 'MarianTransformer',
        'opus_mt_fi_lus': 'MarianTransformer',
        'opus_mt_fi_lv': 'MarianTransformer',
        'opus_mt_fi_mfe': 'MarianTransformer',
        'opus_mt_fi_mg': 'MarianTransformer',
        'opus_mt_fi_mh': 'MarianTransformer',
        'opus_mt_fi_mk': 'MarianTransformer',
        'opus_mt_fi_mos': 'MarianTransformer',
        'opus_mt_fi_mt': 'MarianTransformer',
        'opus_mt_fi_niu': 'MarianTransformer',
        'opus_mt_fi_nl': 'MarianTransformer',
        'opus_mt_fi_no': 'MarianTransformer',
        'opus_mt_fi_nso': 'MarianTransformer',
        'opus_mt_fi_ny': 'MarianTransformer',
        'opus_mt_fi_pag': 'MarianTransformer',
        'opus_mt_fi_pap': 'MarianTransformer',
        'opus_mt_fi_pis': 'MarianTransformer',
        'opus_mt_fi_pon': 'MarianTransformer',
        'opus_mt_fi_ro': 'MarianTransformer',
        'opus_mt_fi_ru': 'MarianTransformer',
        'opus_mt_fi_run': 'MarianTransformer',
        'opus_mt_fi_rw': 'MarianTransformer',
        'opus_mt_fi_sg': 'MarianTransformer',
        'opus_mt_fi_sk': 'MarianTransformer',
        'opus_mt_fi_sl': 'MarianTransformer',
        'opus_mt_fi_sm': 'MarianTransformer',
        'opus_mt_fi_sn': 'MarianTransformer',
        'opus_mt_fi_sq': 'MarianTransformer',
        'opus_mt_fi_srn': 'MarianTransformer',
        'opus_mt_fi_st': 'MarianTransformer',
        'opus_mt_fi_sv': 'MarianTransformer',
        'opus_mt_fi_sw': 'MarianTransformer',
        'opus_mt_fi_swc': 'MarianTransformer',
        'opus_mt_fi_tiv': 'MarianTransformer',
        'opus_mt_fi_tll': 'MarianTransformer',
        'opus_mt_fi_tn': 'MarianTransformer',
        'opus_mt_fi_to': 'MarianTransformer',
        'opus_mt_fi_toi': 'MarianTransformer',
        'opus_mt_fi_tpi': 'MarianTransformer',
        'opus_mt_fi_tr': 'MarianTransformer',
        'opus_mt_fi_ts': 'MarianTransformer',
        'opus_mt_fi_tvl': 'MarianTransformer',
        'opus_mt_fi_tw': 'MarianTransformer',
        'opus_mt_fi_ty': 'MarianTransformer',
        'opus_mt_fi_uk': 'MarianTransformer',
        'opus_mt_fi_ve': 'MarianTransformer',
        'opus_mt_fi_war': 'MarianTransformer',
        'opus_mt_fi_wls': 'MarianTransformer',
        'opus_mt_fi_xh': 'MarianTransformer',
        'opus_mt_fi_yap': 'MarianTransformer',
        'opus_mt_fi_yo': 'MarianTransformer',
        'opus_mt_fi_zne': 'MarianTransformer',
        'opus_mt_fiu_en': 'MarianTransformer',
        'opus_mt_fiu_fiu': 'MarianTransformer',
        'opus_mt_fj_en': 'MarianTransformer',
        'opus_mt_fj_fr': 'MarianTransformer',
        'opus_mt_fr_af': 'MarianTransformer',
        'opus_mt_fr_ar': 'MarianTransformer',
        'opus_mt_fr_ase': 'MarianTransformer',
        'opus_mt_fr_bcl': 'MarianTransformer',
        'opus_mt_fr_bem': 'MarianTransformer',
        'opus_mt_fr_ber': 'MarianTransformer',
        'opus_mt_fr_bg': 'MarianTransformer',
        'opus_mt_fr_bi': 'MarianTransformer',
        'opus_mt_fr_bzs': 'MarianTransformer',
        'opus_mt_fr_ca': 'MarianTransformer',
        'opus_mt_fr_ceb': 'MarianTransformer',
        'opus_mt_fr_crs': 'MarianTransformer',
        'opus_mt_fr_de': 'MarianTransformer',
        'opus_mt_fr_ee': 'MarianTransformer',
        'opus_mt_fr_efi': 'MarianTransformer',
        'opus_mt_fr_el': 'MarianTransformer',
        'opus_mt_fr_en': 'MarianTransformer',
        'opus_mt_fr_eo': 'MarianTransformer',
        'opus_mt_fr_es': 'MarianTransformer',
        'opus_mt_fr_fj': 'MarianTransformer',
        'opus_mt_fr_gaa': 'MarianTransformer',
        'opus_mt_fr_gil': 'MarianTransformer',
        'opus_mt_fr_guw': 'MarianTransformer',
        'opus_mt_fr_ha': 'MarianTransformer',
        'opus_mt_fr_he': 'MarianTransformer',
        'opus_mt_fr_hil': 'MarianTransformer',
        'opus_mt_fr_ho': 'MarianTransformer',
        'opus_mt_fr_hr': 'MarianTransformer',
        'opus_mt_fr_ht': 'MarianTransformer',
        'opus_mt_fr_hu': 'MarianTransformer',
        'opus_mt_fr_id': 'MarianTransformer',
        'opus_mt_fr_ig': 'MarianTransformer',
        'opus_mt_fr_ilo': 'MarianTransformer',
        'opus_mt_fr_iso': 'MarianTransformer',
        'opus_mt_fr_kg': 'MarianTransformer',
        'opus_mt_fr_kqn': 'MarianTransformer',
        'opus_mt_fr_kwy': 'MarianTransformer',
        'opus_mt_fr_lg': 'MarianTransformer',
        'opus_mt_fr_ln': 'MarianTransformer',
        'opus_mt_fr_loz': 'MarianTransformer',
        'opus_mt_fr_lu': 'MarianTransformer',
        'opus_mt_fr_lua': 'MarianTransformer',
        'opus_mt_fr_lue': 'MarianTransformer',
        'opus_mt_fr_lus': 'MarianTransformer',
        'opus_mt_fr_mfe': 'MarianTransformer',
        'opus_mt_fr_mh': 'MarianTransformer',
        'opus_mt_fr_mos': 'MarianTransformer',
        'opus_mt_fr_ms': 'MarianTransformer',
        'opus_mt_fr_mt': 'MarianTransformer',
        'opus_mt_fr_niu': 'MarianTransformer',
        'opus_mt_fr_no': 'MarianTransformer',
        'opus_mt_fr_nso': 'MarianTransformer',
        'opus_mt_fr_ny': 'MarianTransformer',
        'opus_mt_fr_pag': 'MarianTransformer',
        'opus_mt_fr_pap': 'MarianTransformer',
        'opus_mt_fr_pis': 'MarianTransformer',
        'opus_mt_fr_pl': 'MarianTransformer',
        'opus_mt_fr_pon': 'MarianTransformer',
        'opus_mt_fr_rnd': 'MarianTransformer',
        'opus_mt_fr_ro': 'MarianTransformer',
        'opus_mt_fr_ru': 'MarianTransformer',
        'opus_mt_fr_run': 'MarianTransformer',
        'opus_mt_fr_rw': 'MarianTransformer',
        'opus_mt_fr_sg': 'MarianTransformer',
        'opus_mt_fr_sk': 'MarianTransformer',
        'opus_mt_fr_sl': 'MarianTransformer',
        'opus_mt_fr_sm': 'MarianTransformer',
        'opus_mt_fr_sn': 'MarianTransformer',
        'opus_mt_fr_srn': 'MarianTransformer',
        'opus_mt_fr_st': 'MarianTransformer',
        'opus_mt_fr_sv': 'MarianTransformer',
        'opus_mt_fr_swc': 'MarianTransformer',
        'opus_mt_fr_tiv': 'MarianTransformer',
        'opus_mt_fr_tl': 'MarianTransformer',
        'opus_mt_fr_tll': 'MarianTransformer',
        'opus_mt_fr_tn': 'MarianTransformer',
        'opus_mt_fr_to': 'MarianTransformer',
        'opus_mt_fr_tpi': 'MarianTransformer',
        'opus_mt_fr_ts': 'MarianTransformer',
        'opus_mt_fr_tum': 'MarianTransformer',
        'opus_mt_fr_tvl': 'MarianTransformer',
        'opus_mt_fr_tw': 'MarianTransformer',
        'opus_mt_fr_ty': 'MarianTransformer',
        'opus_mt_fr_uk': 'MarianTransformer',
        'opus_mt_fr_ve': 'MarianTransformer',
        'opus_mt_fr_vi': 'MarianTransformer',
        'opus_mt_fr_war': 'MarianTransformer',
        'opus_mt_fr_wls': 'MarianTransformer',
        'opus_mt_fr_xh': 'MarianTransformer',
        'opus_mt_fr_yap': 'MarianTransformer',
        'opus_mt_fr_yo': 'MarianTransformer',
        'opus_mt_fr_zne': 'MarianTransformer',
        'opus_mt_fse_fi': 'MarianTransformer',
        'opus_mt_ga_en': 'MarianTransformer',
        'opus_mt_gaa_de': 'MarianTransformer',
        'opus_mt_gaa_en': 'MarianTransformer',
        'opus_mt_gaa_es': 'MarianTransformer',
        'opus_mt_gaa_fi': 'MarianTransformer',
        'opus_mt_gaa_fr': 'MarianTransformer',
        'opus_mt_gaa_sv': 'MarianTransformer',
        'opus_mt_gem_en': 'MarianTransformer',
        'opus_mt_gem_gem': 'MarianTransformer',
        'opus_mt_gil_en': 'MarianTransformer',
        'opus_mt_gil_es': 'MarianTransformer',
        'opus_mt_gil_fi': 'MarianTransformer',
        'opus_mt_gil_fr': 'MarianTransformer',
        'opus_mt_gil_sv': 'MarianTransformer',
        'opus_mt_gl_en': 'MarianTransformer',
        'opus_mt_gl_es': 'MarianTransformer',
        'opus_mt_gl_pt': 'MarianTransformer',
        'opus_mt_gmq_en': 'MarianTransformer',
        'opus_mt_gmq_gmq': 'MarianTransformer',
        'opus_mt_gmw_en': 'MarianTransformer',
        'opus_mt_gmw_gmw': 'MarianTransformer',
        'opus_mt_grk_en': 'MarianTransformer',
        'opus_mt_guw_de': 'MarianTransformer',
        'opus_mt_guw_en': 'MarianTransformer',
        'opus_mt_guw_es': 'MarianTransformer',
        'opus_mt_guw_fi': 'MarianTransformer',
        'opus_mt_guw_fr': 'MarianTransformer',
        'opus_mt_guw_sv': 'MarianTransformer',
        'opus_mt_gv_en': 'MarianTransformer',
        'opus_mt_ha_en': 'MarianTransformer',
        'opus_mt_ha_es': 'MarianTransformer',
        'opus_mt_ha_fi': 'MarianTransformer',
        'opus_mt_ha_fr': 'MarianTransformer',
        'opus_mt_ha_sv': 'MarianTransformer',
        'opus_mt_he_ar': 'MarianTransformer',
        'opus_mt_he_de': 'MarianTransformer',
        'opus_mt_he_eo': 'MarianTransformer',
        'opus_mt_he_es': 'MarianTransformer',
        'opus_mt_he_fi': 'MarianTransformer',
        'opus_mt_he_it': 'MarianTransformer',
        'opus_mt_he_ru': 'MarianTransformer',
        'opus_mt_he_sv': 'MarianTransformer',
        'opus_mt_he_uk': 'MarianTransformer',
        'opus_mt_hi_en': 'MarianTransformer',
        'opus_mt_hi_ur': 'MarianTransformer',
        'opus_mt_hil_de': 'MarianTransformer',
        'opus_mt_hil_en': 'MarianTransformer',
        'opus_mt_hil_fi': 'MarianTransformer',
        'opus_mt_ho_en': 'MarianTransformer',
        'opus_mt_hr_es': 'MarianTransformer',
        'opus_mt_hr_fi': 'MarianTransformer',
        'opus_mt_hr_fr': 'MarianTransformer',
        'opus_mt_hr_sv': 'MarianTransformer',
        'opus_mt_ht_en': 'MarianTransformer',
        'opus_mt_ht_es': 'MarianTransformer',
        'opus_mt_ht_fi': 'MarianTransformer',
        'opus_mt_ht_fr': 'MarianTransformer',
        'opus_mt_ht_sv': 'MarianTransformer',
        'opus_mt_hu_de': 'MarianTransformer',
        'opus_mt_hu_en': 'MarianTransformer',
        'opus_mt_hu_eo': 'MarianTransformer',
        'opus_mt_hu_fi': 'MarianTransformer',
        'opus_mt_hu_fr': 'MarianTransformer',
        'opus_mt_hu_sv': 'MarianTransformer',
        'opus_mt_hu_uk': 'MarianTransformer',
        'opus_mt_hy_en': 'MarianTransformer',
        'opus_mt_hy_ru': 'MarianTransformer',
        'opus_mt_id_en': 'MarianTransformer',
        'opus_mt_id_es': 'MarianTransformer',
        'opus_mt_id_fi': 'MarianTransformer',
        'opus_mt_id_fr': 'MarianTransformer',
        'opus_mt_id_sv': 'MarianTransformer',
        'opus_mt_ig_de': 'MarianTransformer',
        'opus_mt_ig_en': 'MarianTransformer',
        'opus_mt_ig_es': 'MarianTransformer',
        'opus_mt_ig_fi': 'MarianTransformer',
        'opus_mt_ig_fr': 'MarianTransformer',
        'opus_mt_ig_sv': 'MarianTransformer',
        'opus_mt_iir_en': 'MarianTransformer',
        'opus_mt_iir_iir': 'MarianTransformer',
        'opus_mt_ilo_de': 'MarianTransformer',
        'opus_mt_ilo_en': 'MarianTransformer',
        'opus_mt_ilo_es': 'MarianTransformer',
        'opus_mt_ilo_fi': 'MarianTransformer',
        'opus_mt_ilo_sv': 'MarianTransformer',
        'opus_mt_inc_en': 'MarianTransformer',
        'opus_mt_inc_inc': 'MarianTransformer',
        'opus_mt_ine_en': 'MarianTransformer',
        'opus_mt_ine_ine': 'MarianTransformer',
        'opus_mt_is_de': 'MarianTransformer',
        'opus_mt_is_en': 'MarianTransformer',
        'opus_mt_is_eo': 'MarianTransformer',
        'opus_mt_is_es': 'MarianTransformer',
        'opus_mt_is_fi': 'MarianTransformer',
        'opus_mt_is_fr': 'MarianTransformer',
        'opus_mt_is_it': 'MarianTransformer',
        'opus_mt_is_sv': 'MarianTransformer',
        'opus_mt_iso_en': 'MarianTransformer',
        'opus_mt_iso_es': 'MarianTransformer',
        'opus_mt_iso_fi': 'MarianTransformer',
        'opus_mt_iso_fr': 'MarianTransformer',
        'opus_mt_iso_sv': 'MarianTransformer',
        'opus_mt_it_ar': 'MarianTransformer',
        'opus_mt_it_bg': 'MarianTransformer',
        'opus_mt_it_ca': 'MarianTransformer',
        'opus_mt_it_de': 'MarianTransformer',
        'opus_mt_it_en': 'MarianTransformer',
        'opus_mt_it_eo': 'MarianTransformer',
        'opus_mt_it_es': 'MarianTransformer',
        'opus_mt_it_fr': 'MarianTransformer',
        'opus_mt_it_is': 'MarianTransformer',
        'opus_mt_it_lt': 'MarianTransformer',
        'opus_mt_it_ms': 'MarianTransformer',
        'opus_mt_it_sv': 'MarianTransformer',
        'opus_mt_it_uk': 'MarianTransformer',
        'opus_mt_it_vi': 'MarianTransformer',
        'opus_mt_itc_en': 'MarianTransformer',
        'opus_mt_itc_itc': 'MarianTransformer',
        'opus_mt_ja_ar': 'MarianTransformer',
        'opus_mt_ja_bg': 'MarianTransformer',
        'opus_mt_ja_da': 'MarianTransformer',
        'opus_mt_ja_de': 'MarianTransformer',
        'opus_mt_ja_en': 'MarianTransformer',
        'opus_mt_ja_es': 'MarianTransformer',
        'opus_mt_ja_fi': 'MarianTransformer',
        'opus_mt_ja_fr': 'MarianTransformer',
        'opus_mt_ja_he': 'MarianTransformer',
        'opus_mt_ja_hu': 'MarianTransformer',
        'opus_mt_ja_it': 'MarianTransformer',
        'opus_mt_ja_ms': 'MarianTransformer',
        'opus_mt_ja_nl': 'MarianTransformer',
        'opus_mt_ja_pl': 'MarianTransformer',
        'opus_mt_ja_pt': 'MarianTransformer',
        'opus_mt_ja_ru': 'MarianTransformer',
        'opus_mt_ja_sh': 'MarianTransformer',
        'opus_mt_ja_sv': 'MarianTransformer',
        'opus_mt_ja_tr': 'MarianTransformer',
        'opus_mt_ja_vi': 'MarianTransformer',
        'opus_mt_jap_en': 'MarianTransformer',
        'opus_mt_ka_en': 'MarianTransformer',
        'opus_mt_ka_ru': 'MarianTransformer',
        'opus_mt_kab_en': 'MarianTransformer',
        'opus_mt_kg_en': 'MarianTransformer',
        'opus_mt_kg_es': 'MarianTransformer',
        'opus_mt_kg_fr': 'MarianTransformer',
        'opus_mt_kg_sv': 'MarianTransformer',
        'opus_mt_kj_en': 'MarianTransformer',
        'opus_mt_kl_en': 'MarianTransformer',
        'opus_mt_ko_de': 'MarianTransformer',
        'opus_mt_ko_en': 'MarianTransformer',
        'opus_mt_ko_es': 'MarianTransformer',
        'opus_mt_ko_fi': 'MarianTransformer',
        'opus_mt_ko_fr': 'MarianTransformer',
        'opus_mt_ko_hu': 'MarianTransformer',
        'opus_mt_ko_ru': 'MarianTransformer',
        'opus_mt_ko_sv': 'MarianTransformer',
        'opus_mt_kqn_en': 'MarianTransformer',
        'opus_mt_kqn_es': 'MarianTransformer',
        'opus_mt_kqn_fr': 'MarianTransformer',
        'opus_mt_kqn_sv': 'MarianTransformer',
        'opus_mt_kwn_en': 'MarianTransformer',
        'opus_mt_kwy_en': 'MarianTransformer',
        'opus_mt_kwy_fr': 'MarianTransformer',
        'opus_mt_kwy_sv': 'MarianTransformer',
        'opus_mt_lg_en': 'MarianTransformer',
        'opus_mt_lg_es': 'MarianTransformer',
        'opus_mt_lg_fi': 'MarianTransformer',
        'opus_mt_lg_fr': 'MarianTransformer',
        'opus_mt_lg_sv': 'MarianTransformer',
        'opus_mt_ln_de': 'MarianTransformer',
        'opus_mt_ln_en': 'MarianTransformer',
        'opus_mt_ln_es': 'MarianTransformer',
        'opus_mt_ln_fr': 'MarianTransformer',
        'opus_mt_loz_de': 'MarianTransformer',
        'opus_mt_loz_en': 'MarianTransformer',
        'opus_mt_loz_es': 'MarianTransformer',
        'opus_mt_loz_fi': 'MarianTransformer',
        'opus_mt_loz_fr': 'MarianTransformer',
        'opus_mt_loz_sv': 'MarianTransformer',
        'opus_mt_lt_de': 'MarianTransformer',
        'opus_mt_lt_eo': 'MarianTransformer',
        'opus_mt_lt_es': 'MarianTransformer',
        'opus_mt_lt_fr': 'MarianTransformer',
        'opus_mt_lt_it': 'MarianTransformer',
        'opus_mt_lt_pl': 'MarianTransformer',
        'opus_mt_lt_ru': 'MarianTransformer',
        'opus_mt_lt_sv': 'MarianTransformer',
        'opus_mt_lt_tr': 'MarianTransformer',
        'opus_mt_lu_en': 'MarianTransformer',
        'opus_mt_lu_es': 'MarianTransformer',
        'opus_mt_lu_fi': 'MarianTransformer',
        'opus_mt_lu_fr': 'MarianTransformer',
        'opus_mt_lu_sv': 'MarianTransformer',
        'opus_mt_lua_en': 'MarianTransformer',
        'opus_mt_lua_es': 'MarianTransformer',
        'opus_mt_lua_fi': 'MarianTransformer',
        'opus_mt_lua_fr': 'MarianTransformer',
        'opus_mt_lua_sv': 'MarianTransformer',
        'opus_mt_lue_en': 'MarianTransformer',
        'opus_mt_lue_es': 'MarianTransformer',
        'opus_mt_lue_fi': 'MarianTransformer',
        'opus_mt_lue_fr': 'MarianTransformer',
        'opus_mt_lue_sv': 'MarianTransformer',
        'opus_mt_lun_en': 'MarianTransformer',
        'opus_mt_luo_en': 'MarianTransformer',
        'opus_mt_lus_en': 'MarianTransformer',
        'opus_mt_lus_es': 'MarianTransformer',
        'opus_mt_lus_fi': 'MarianTransformer',
        'opus_mt_lus_fr': 'MarianTransformer',
        'opus_mt_lus_sv': 'MarianTransformer',
        'opus_mt_lv_en': 'MarianTransformer',
        'opus_mt_lv_es': 'MarianTransformer',
        'opus_mt_lv_fi': 'MarianTransformer',
        'opus_mt_lv_fr': 'MarianTransformer',
        'opus_mt_lv_ru': 'MarianTransformer',
        'opus_mt_lv_sv': 'MarianTransformer',
        'opus_mt_mfe_en': 'MarianTransformer',
        'opus_mt_mfe_es': 'MarianTransformer',
        'opus_mt_mfs_es': 'MarianTransformer',
        'opus_mt_mg_en': 'MarianTransformer',
        'opus_mt_mg_es': 'MarianTransformer',
        'opus_mt_mh_en': 'MarianTransformer',
        'opus_mt_mh_es': 'MarianTransformer',
        'opus_mt_mh_fi': 'MarianTransformer',
        'opus_mt_mk_en': 'MarianTransformer',
        'opus_mt_mk_es': 'MarianTransformer',
        'opus_mt_mk_fi': 'MarianTransformer',
        'opus_mt_mk_fr': 'MarianTransformer',
        'opus_mt_mkh_en': 'MarianTransformer',
        'opus_mt_ml_en': 'MarianTransformer',
        'opus_mt_mos_en': 'MarianTransformer',
        'opus_mt_mr_en': 'MarianTransformer',
        'opus_mt_ms_de': 'MarianTransformer',
        'opus_mt_ms_fr': 'MarianTransformer',
        'opus_mt_ms_it': 'MarianTransformer',
        'opus_mt_ms_ms': 'MarianTransformer',
        'opus_mt_mt_en': 'MarianTransformer',
        'opus_mt_mt_es': 'MarianTransformer',
        'opus_mt_mt_fi': 'MarianTransformer',
        'opus_mt_mt_fr': 'MarianTransformer',
        'opus_mt_mt_sv': 'MarianTransformer',
        'opus_mt_mul_en': 'MarianTransformer',
        'opus_mt_ng_en': 'MarianTransformer',
        'opus_mt_nic_en': 'MarianTransformer',
        'opus_mt_niu_de': 'MarianTransformer',
        'opus_mt_niu_en': 'MarianTransformer',
        'opus_mt_niu_es': 'MarianTransformer',
        'opus_mt_niu_fi': 'MarianTransformer',
        'opus_mt_niu_fr': 'MarianTransformer',
        'opus_mt_niu_sv': 'MarianTransformer',
        'opus_mt_nl_af': 'MarianTransformer',
        'opus_mt_nl_ca': 'MarianTransformer',
        'opus_mt_nl_en': 'MarianTransformer',
        'opus_mt_nl_eo': 'MarianTransformer',
        'opus_mt_nl_es': 'MarianTransformer',
        'opus_mt_nl_fi': 'MarianTransformer',
        'opus_mt_nl_fr': 'MarianTransformer',
        'opus_mt_nl_no': 'MarianTransformer',
        'opus_mt_nl_sv': 'MarianTransformer',
        'opus_mt_nl_uk': 'MarianTransformer',
        'opus_mt_no_da': 'MarianTransformer',
        'opus_mt_no_de': 'MarianTransformer',
        'opus_mt_no_es': 'MarianTransformer',
        'opus_mt_no_fi': 'MarianTransformer',
        'opus_mt_no_fr': 'MarianTransformer',
        'opus_mt_no_nl': 'MarianTransformer',
        'opus_mt_no_no': 'MarianTransformer',
        'opus_mt_no_pl': 'MarianTransformer',
        'opus_mt_no_ru': 'MarianTransformer',
        'opus_mt_no_sv': 'MarianTransformer',
        'opus_mt_no_uk': 'MarianTransformer',
        'opus_mt_nso_de': 'MarianTransformer',
        'opus_mt_nso_en': 'MarianTransformer',
        'opus_mt_nso_es': 'MarianTransformer',
        'opus_mt_nso_fi': 'MarianTransformer',
        'opus_mt_nso_fr': 'MarianTransformer',
        'opus_mt_nso_sv': 'MarianTransformer',
        'opus_mt_ny_de': 'MarianTransformer',
        'opus_mt_ny_en': 'MarianTransformer',
        'opus_mt_ny_es': 'MarianTransformer',
        'opus_mt_nyk_en': 'MarianTransformer',
        'opus_mt_om_en': 'MarianTransformer',
        'opus_mt_pa_en': 'MarianTransformer',
        'opus_mt_pag_de': 'MarianTransformer',
        'opus_mt_pag_en': 'MarianTransformer',
        'opus_mt_pag_es': 'MarianTransformer',
        'opus_mt_pag_fi': 'MarianTransformer',
        'opus_mt_pag_sv': 'MarianTransformer',
        'opus_mt_pap_de': 'MarianTransformer',
        'opus_mt_pap_en': 'MarianTransformer',
        'opus_mt_pap_es': 'MarianTransformer',
        'opus_mt_pap_fi': 'MarianTransformer',
        'opus_mt_pap_fr': 'MarianTransformer',
        'opus_mt_phi_en': 'MarianTransformer',
        'opus_mt_pis_en': 'MarianTransformer',
        'opus_mt_pis_es': 'MarianTransformer',
        'opus_mt_pis_fi': 'MarianTransformer',
        'opus_mt_pis_fr': 'MarianTransformer',
        'opus_mt_pis_sv': 'MarianTransformer',
        'opus_mt_pl_ar': 'MarianTransformer',
        'opus_mt_pl_de': 'MarianTransformer',
        'opus_mt_pl_en': 'MarianTransformer',
        'opus_mt_pl_eo': 'MarianTransformer',
        'opus_mt_pl_es': 'MarianTransformer',
        'opus_mt_pl_fr': 'MarianTransformer',
        'opus_mt_pl_lt': 'MarianTransformer',
        'opus_mt_pl_no': 'MarianTransformer',
        'opus_mt_pl_sv': 'MarianTransformer',
        'opus_mt_pl_uk': 'MarianTransformer',
        'opus_mt_pon_en': 'MarianTransformer',
        'opus_mt_pon_es': 'MarianTransformer',
        'opus_mt_pon_fi': 'MarianTransformer',
        'opus_mt_pon_fr': 'MarianTransformer',
        'opus_mt_pon_sv': 'MarianTransformer',
        'opus_mt_pqe_en': 'MarianTransformer',
        'opus_mt_prl_es': 'MarianTransformer',
        'opus_mt_pt_ca': 'MarianTransformer',
        'opus_mt_pt_eo': 'MarianTransformer',
        'opus_mt_pt_gl': 'MarianTransformer',
        'opus_mt_pt_tl': 'MarianTransformer',
        'opus_mt_pt_uk': 'MarianTransformer',
        'opus_mt_rn_de': 'MarianTransformer',
        'opus_mt_rn_en': 'MarianTransformer',
        'opus_mt_rn_es': 'MarianTransformer',
        'opus_mt_rn_fr': 'MarianTransformer',
        'opus_mt_rn_ru': 'MarianTransformer',
        'opus_mt_rnd_en': 'MarianTransformer',
        'opus_mt_rnd_fr': 'MarianTransformer',
        'opus_mt_rnd_sv': 'MarianTransformer',
        'opus_mt_ro_eo': 'MarianTransformer',
        'opus_mt_ro_fi': 'MarianTransformer',
        'opus_mt_ro_fr': 'MarianTransformer',
        'opus_mt_ro_sv': 'MarianTransformer',
        'opus_mt_roa_en': 'MarianTransformer',
        'opus_mt_ru_af': 'MarianTransformer',
        'opus_mt_ru_ar': 'MarianTransformer',
        'opus_mt_ru_bg': 'MarianTransformer',
        'opus_mt_ru_da': 'MarianTransformer',
        'opus_mt_ru_en': 'MarianTransformer',
        'opus_mt_ru_eo': 'MarianTransformer',
        'opus_mt_ru_es': 'MarianTransformer',
        'opus_mt_ru_et': 'MarianTransformer',
        'opus_mt_ru_eu': 'MarianTransformer',
        'opus_mt_ru_fi': 'MarianTransformer',
        'opus_mt_ru_fr': 'MarianTransformer',
        'opus_mt_ru_he': 'MarianTransformer',
        'opus_mt_ru_hy': 'MarianTransformer',
        'opus_mt_ru_lt': 'MarianTransformer',
        'opus_mt_ru_lv': 'MarianTransformer',
        'opus_mt_ru_no': 'MarianTransformer',
        'opus_mt_ru_sl': 'MarianTransformer',
        'opus_mt_ru_sv': 'MarianTransformer',
        'opus_mt_ru_uk': 'MarianTransformer',
        'opus_mt_ru_vi': 'MarianTransformer',
        'opus_mt_run_en': 'MarianTransformer',
        'opus_mt_run_es': 'MarianTransformer',
        'opus_mt_run_sv': 'MarianTransformer',
        'opus_mt_rw_en': 'MarianTransformer',
        'opus_mt_rw_es': 'MarianTransformer',
        'opus_mt_rw_fr': 'MarianTransformer',
        'opus_mt_rw_sv': 'MarianTransformer',
        'opus_mt_sal_en': 'MarianTransformer',
        'opus_mt_sem_en': 'MarianTransformer',
        'opus_mt_sem_sem': 'MarianTransformer',
        'opus_mt_sg_en': 'MarianTransformer',
        'opus_mt_sg_es': 'MarianTransformer',
        'opus_mt_sg_fi': 'MarianTransformer',
        'opus_mt_sg_fr': 'MarianTransformer',
        'opus_mt_sg_sv': 'MarianTransformer',
        'opus_mt_sh_eo': 'MarianTransformer',
        'opus_mt_sh_uk': 'MarianTransformer',
        'opus_mt_sk_en': 'MarianTransformer',
        'opus_mt_sk_es': 'MarianTransformer',
        'opus_mt_sk_fi': 'MarianTransformer',
        'opus_mt_sk_fr': 'MarianTransformer',
        'opus_mt_sk_sv': 'MarianTransformer',
        'opus_mt_sl_es': 'MarianTransformer',
        'opus_mt_sl_fi': 'MarianTransformer',
        'opus_mt_sl_fr': 'MarianTransformer',
        'opus_mt_sl_ru': 'MarianTransformer',
        'opus_mt_sl_sv': 'MarianTransformer',
        'opus_mt_sl_uk': 'MarianTransformer',
        'opus_mt_sla_en': 'MarianTransformer',
        'opus_mt_sla_sla': 'MarianTransformer',
        'opus_mt_sm_en': 'MarianTransformer',
        'opus_mt_sm_es': 'MarianTransformer',
        'opus_mt_sm_fr': 'MarianTransformer',
        'opus_mt_sn_en': 'MarianTransformer',
        'opus_mt_sn_es': 'MarianTransformer',
        'opus_mt_sn_fr': 'MarianTransformer',
        'opus_mt_sn_sv': 'MarianTransformer',
        'opus_mt_sq_en': 'MarianTransformer',
        'opus_mt_sq_es': 'MarianTransformer',
        'opus_mt_sq_sv': 'MarianTransformer',
        'opus_mt_srn_en': 'MarianTransformer',
        'opus_mt_srn_es': 'MarianTransformer',
        'opus_mt_srn_fr': 'MarianTransformer',
        'opus_mt_srn_sv': 'MarianTransformer',
        'opus_mt_ss_en': 'MarianTransformer',
        'opus_mt_ssp_es': 'MarianTransformer',
        'opus_mt_st_en': 'MarianTransformer',
        'opus_mt_st_es': 'MarianTransformer',
        'opus_mt_st_fi': 'MarianTransformer',
        'opus_mt_st_fr': 'MarianTransformer',
        'opus_mt_st_sv': 'MarianTransformer',
        'opus_mt_sv_af': 'MarianTransformer',
        'opus_mt_sv_ase': 'MarianTransformer',
        'opus_mt_sv_bcl': 'MarianTransformer',
        'opus_mt_sv_bem': 'MarianTransformer',
        'opus_mt_sv_bg': 'MarianTransformer',
        'opus_mt_sv_bi': 'MarianTransformer',
        'opus_mt_sv_bzs': 'MarianTransformer',
        'opus_mt_sv_ceb': 'MarianTransformer',
        'opus_mt_sv_chk': 'MarianTransformer',
        'opus_mt_sv_crs': 'MarianTransformer',
        'opus_mt_sv_cs': 'MarianTransformer',
        'opus_mt_sv_ee': 'MarianTransformer',
        'opus_mt_sv_efi': 'MarianTransformer',
        'opus_mt_sv_el': 'MarianTransformer',
        'opus_mt_sv_en': 'MarianTransformer',
        'opus_mt_sv_eo': 'MarianTransformer',
        'opus_mt_sv_es': 'MarianTransformer',
        'opus_mt_sv_et': 'MarianTransformer',
        'opus_mt_sv_fi': 'MarianTransformer',
        'opus_mt_sv_fj': 'MarianTransformer',
        'opus_mt_sv_fr': 'MarianTransformer',
        'opus_mt_sv_gaa': 'MarianTransformer',
        'opus_mt_sv_gil': 'MarianTransformer',
        'opus_mt_sv_guw': 'MarianTransformer',
        'opus_mt_sv_ha': 'MarianTransformer',
        'opus_mt_sv_he': 'MarianTransformer',
        'opus_mt_sv_hil': 'MarianTransformer',
        'opus_mt_sv_ho': 'MarianTransformer',
        'opus_mt_sv_hr': 'MarianTransformer',
        'opus_mt_sv_ht': 'MarianTransformer',
        'opus_mt_sv_hu': 'MarianTransformer',
        'opus_mt_sv_id': 'MarianTransformer',
        'opus_mt_sv_ig': 'MarianTransformer',
        'opus_mt_sv_ilo': 'MarianTransformer',
        'opus_mt_sv_is': 'MarianTransformer',
        'opus_mt_sv_iso': 'MarianTransformer',
        'opus_mt_sv_kg': 'MarianTransformer',
        'opus_mt_sv_kqn': 'MarianTransformer',
        'opus_mt_sv_kwy': 'MarianTransformer',
        'opus_mt_sv_lg': 'MarianTransformer',
        'opus_mt_sv_ln': 'MarianTransformer',
        'opus_mt_sv_lu': 'MarianTransformer',
        'opus_mt_sv_lua': 'MarianTransformer',
        'opus_mt_sv_lue': 'MarianTransformer',
        'opus_mt_sv_lus': 'MarianTransformer',
        'opus_mt_sv_lv': 'MarianTransformer',
        'opus_mt_sv_mfe': 'MarianTransformer',
        'opus_mt_sv_mh': 'MarianTransformer',
        'opus_mt_sv_mos': 'MarianTransformer',
        'opus_mt_sv_mt': 'MarianTransformer',
        'opus_mt_sv_niu': 'MarianTransformer',
        'opus_mt_sv_nl': 'MarianTransformer',
        'opus_mt_sv_no': 'MarianTransformer',
        'opus_mt_sv_nso': 'MarianTransformer',
        'opus_mt_sv_ny': 'MarianTransformer',
        'opus_mt_sv_pag': 'MarianTransformer',
        'opus_mt_sv_pap': 'MarianTransformer',
        'opus_mt_sv_pis': 'MarianTransformer',
        'opus_mt_sv_pon': 'MarianTransformer',
        'opus_mt_sv_rnd': 'MarianTransformer',
        'opus_mt_sv_ro': 'MarianTransformer',
        'opus_mt_sv_ru': 'MarianTransformer',
        'opus_mt_sv_run': 'MarianTransformer',
        'opus_mt_sv_rw': 'MarianTransformer',
        'opus_mt_sv_sg': 'MarianTransformer',
        'opus_mt_sv_sk': 'MarianTransformer',
        'opus_mt_sv_sl': 'MarianTransformer',
        'opus_mt_sv_sm': 'MarianTransformer',
        'opus_mt_sv_sn': 'MarianTransformer',
        'opus_mt_sv_sq': 'MarianTransformer',
        'opus_mt_sv_srn': 'MarianTransformer',
        'opus_mt_sv_st': 'MarianTransformer',
        'opus_mt_sv_sv': 'MarianTransformer',
        'opus_mt_sv_swc': 'MarianTransformer',
        'opus_mt_sv_th': 'MarianTransformer',
        'opus_mt_sv_tiv': 'MarianTransformer',
        'opus_mt_sv_tll': 'MarianTransformer',
        'opus_mt_sv_tn': 'MarianTransformer',
        'opus_mt_sv_to': 'MarianTransformer',
        'opus_mt_sv_toi': 'MarianTransformer',
        'opus_mt_sv_tpi': 'MarianTransformer',
        'opus_mt_sv_ts': 'MarianTransformer',
        'opus_mt_sv_tum': 'MarianTransformer',
        'opus_mt_sv_tvl': 'MarianTransformer',
        'opus_mt_sv_tw': 'MarianTransformer',
        'opus_mt_sv_ty': 'MarianTransformer',
        'opus_mt_sv_uk': 'MarianTransformer',
        'opus_mt_sv_umb': 'MarianTransformer',
        'opus_mt_sv_ve': 'MarianTransformer',
        'opus_mt_sv_war': 'MarianTransformer',
        'opus_mt_sv_wls': 'MarianTransformer',
        'opus_mt_sv_xh': 'MarianTransformer',
        'opus_mt_sv_yap': 'MarianTransformer',
        'opus_mt_sv_yo': 'MarianTransformer',
        'opus_mt_sv_zne': 'MarianTransformer',
        'opus_mt_swc_en': 'MarianTransformer',
        'opus_mt_swc_es': 'MarianTransformer',
        'opus_mt_swc_fi': 'MarianTransformer',
        'opus_mt_swc_fr': 'MarianTransformer',
        'opus_mt_swc_sv': 'MarianTransformer',
        'opus_mt_taw_en': 'MarianTransformer',
        'opus_mt_th_en': 'MarianTransformer',
        'opus_mt_th_fr': 'MarianTransformer',
        'opus_mt_ti_en': 'MarianTransformer',
        'opus_mt_tiv_en': 'MarianTransformer',
        'opus_mt_tiv_fr': 'MarianTransformer',
        'opus_mt_tiv_sv': 'MarianTransformer',
        'opus_mt_tl_de': 'MarianTransformer',
        'opus_mt_tl_en': 'MarianTransformer',
        'opus_mt_tl_es': 'MarianTransformer',
        'opus_mt_tl_pt': 'MarianTransformer',
        'opus_mt_tll_en': 'MarianTransformer',
        'opus_mt_tll_es': 'MarianTransformer',
        'opus_mt_tll_fi': 'MarianTransformer',
        'opus_mt_tll_fr': 'MarianTransformer',
        'opus_mt_tll_sv': 'MarianTransformer',
        'opus_mt_tn_en': 'MarianTransformer',
        'opus_mt_tn_es': 'MarianTransformer',
        'opus_mt_tn_fr': 'MarianTransformer',
        'opus_mt_tn_sv': 'MarianTransformer',
        'opus_mt_to_en': 'MarianTransformer',
        'opus_mt_to_es': 'MarianTransformer',
        'opus_mt_to_fr': 'MarianTransformer',
        'opus_mt_to_sv': 'MarianTransformer',
        'opus_mt_toi_en': 'MarianTransformer',
        'opus_mt_toi_es': 'MarianTransformer',
        'opus_mt_toi_fi': 'MarianTransformer',
        'opus_mt_toi_fr': 'MarianTransformer',
        'opus_mt_toi_sv': 'MarianTransformer',
        'opus_mt_tpi_en': 'MarianTransformer',
        'opus_mt_tpi_sv': 'MarianTransformer',
        'opus_mt_tr_ar': 'MarianTransformer',
        'opus_mt_tr_az': 'MarianTransformer',
        'opus_mt_tr_en': 'MarianTransformer',
        'opus_mt_tr_eo': 'MarianTransformer',
        'opus_mt_tr_es': 'MarianTransformer',
        'opus_mt_tr_fr': 'MarianTransformer',
        'opus_mt_tr_lt': 'MarianTransformer',
        'opus_mt_tr_sv': 'MarianTransformer',
        'opus_mt_tr_uk': 'MarianTransformer',
        'opus_mt_trk_en': 'MarianTransformer',
        'opus_mt_ts_en': 'MarianTransformer',
        'opus_mt_ts_es': 'MarianTransformer',
        'opus_mt_ts_fi': 'MarianTransformer',
        'opus_mt_ts_fr': 'MarianTransformer',
        'opus_mt_ts_sv': 'MarianTransformer',
        'opus_mt_tum_en': 'MarianTransformer',
        'opus_mt_tum_es': 'MarianTransformer',
        'opus_mt_tum_fr': 'MarianTransformer',
        'opus_mt_tum_sv': 'MarianTransformer',
        'opus_mt_tvl_en': 'MarianTransformer',
        'opus_mt_tvl_es': 'MarianTransformer',
        'opus_mt_tvl_fi': 'MarianTransformer',
        'opus_mt_tvl_fr': 'MarianTransformer',
        'opus_mt_tvl_sv': 'MarianTransformer',
        'opus_mt_tw_es': 'MarianTransformer',
        'opus_mt_tw_fi': 'MarianTransformer',
        'opus_mt_tw_fr': 'MarianTransformer',
        'opus_mt_tw_sv': 'MarianTransformer',
        'opus_mt_ty_es': 'MarianTransformer',
        'opus_mt_ty_fi': 'MarianTransformer',
        'opus_mt_ty_fr': 'MarianTransformer',
        'opus_mt_ty_sv': 'MarianTransformer',
        'opus_mt_tzo_es': 'MarianTransformer',
        'opus_mt_uk_bg': 'MarianTransformer',
        'opus_mt_uk_ca': 'MarianTransformer',
        'opus_mt_uk_cs': 'MarianTransformer',
        'opus_mt_uk_de': 'MarianTransformer',
        'opus_mt_uk_en': 'MarianTransformer',
        'opus_mt_uk_es': 'MarianTransformer',
        'opus_mt_uk_fi': 'MarianTransformer',
        'opus_mt_uk_fr': 'MarianTransformer',
        'opus_mt_uk_he': 'MarianTransformer',
        'opus_mt_uk_hu': 'MarianTransformer',
        'opus_mt_uk_it': 'MarianTransformer',
        'opus_mt_uk_nl': 'MarianTransformer',
        'opus_mt_uk_no': 'MarianTransformer',
        'opus_mt_uk_pl': 'MarianTransformer',
        'opus_mt_uk_pt': 'MarianTransformer',
        'opus_mt_uk_ru': 'MarianTransformer',
        'opus_mt_uk_sh': 'MarianTransformer',
        'opus_mt_uk_sl': 'MarianTransformer',
        'opus_mt_uk_sv': 'MarianTransformer',
        'opus_mt_uk_tr': 'MarianTransformer',
        'opus_mt_umb_en': 'MarianTransformer',
        'opus_mt_ur_en': 'MarianTransformer',
        'opus_mt_urj_en': 'MarianTransformer',
        'opus_mt_urj_urj': 'MarianTransformer',
        'opus_mt_ve_en': 'MarianTransformer',
        'opus_mt_ve_es': 'MarianTransformer',
        'opus_mt_vi_de': 'MarianTransformer',
        'opus_mt_vi_en': 'MarianTransformer',
        'opus_mt_vi_eo': 'MarianTransformer',
        'opus_mt_vi_es': 'MarianTransformer',
        'opus_mt_vi_fr': 'MarianTransformer',
        'opus_mt_vi_it': 'MarianTransformer',
        'opus_mt_vi_ru': 'MarianTransformer',
        'opus_mt_vsl_es': 'MarianTransformer',
        'opus_mt_wa_en': 'MarianTransformer',
        'opus_mt_wal_en': 'MarianTransformer',
        'opus_mt_war_en': 'MarianTransformer',
        'opus_mt_war_es': 'MarianTransformer',
        'opus_mt_war_fi': 'MarianTransformer',
        'opus_mt_war_fr': 'MarianTransformer',
        'opus_mt_war_sv': 'MarianTransformer',
        'opus_mt_wls_en': 'MarianTransformer',
        'opus_mt_wls_fr': 'MarianTransformer',
        'opus_mt_wls_sv': 'MarianTransformer',
        'opus_mt_xh_en': 'MarianTransformer',
        'opus_mt_xh_es': 'MarianTransformer',
        'opus_mt_xh_fr': 'MarianTransformer',
        'opus_mt_xh_sv': 'MarianTransformer',
        'opus_mt_yap_en': 'MarianTransformer',
        'opus_mt_yap_fr': 'MarianTransformer',
        'opus_mt_yap_sv': 'MarianTransformer',
        'opus_mt_yo_en': 'MarianTransformer',
        'opus_mt_yo_es': 'MarianTransformer',
        'opus_mt_yo_fi': 'MarianTransformer',
        'opus_mt_yo_fr': 'MarianTransformer',
        'opus_mt_yo_sv': 'MarianTransformer',
        'opus_mt_zai_es': 'MarianTransformer',
        'opus_mt_zh_bg': 'MarianTransformer',
        'opus_mt_zh_de': 'MarianTransformer',
        'opus_mt_zh_en': 'MarianTransformer',
        'opus_mt_zh_fi': 'MarianTransformer',
        'opus_mt_zh_he': 'MarianTransformer',
        'opus_mt_zh_it': 'MarianTransformer',
        'opus_mt_zh_ms': 'MarianTransformer',
        'opus_mt_zh_nl': 'MarianTransformer',
        'opus_mt_zh_sv': 'MarianTransformer',
        'opus_mt_zh_uk': 'MarianTransformer',
        'opus_mt_zh_vi': 'MarianTransformer',
        'opus_mt_zle_en': 'MarianTransformer',
        'opus_mt_zle_zle': 'MarianTransformer',
        'opus_mt_zls_en': 'MarianTransformer',
        'opus_mt_zls_zls': 'MarianTransformer',
        'opus_mt_zlw_en': 'MarianTransformer',
        'opus_mt_zlw_zlw': 'MarianTransformer',
        'opus_mt_zne_es': 'MarianTransformer',
        'opus_mt_zne_fi': 'MarianTransformer',
        'opus_mt_zne_fr': 'MarianTransformer',
        'opus_mt_zne_sv': 'MarianTransformer',
        'opus_tatoeba_af_ru': 'MarianTransformer',
        'opus_tatoeba_es_zh': 'MarianTransformer',
        'opus_tatoeba_he_fr': 'MarianTransformer',
        'opus_tatoeba_he_it': 'MarianTransformer',
        'opus_tatoeba_it_he': 'MarianTransformer',
        'persian_w2v_cc_300d': 'WordEmbeddingsModel',
        'personer_cc_300d': 'NerDLModel',
        'pos_afribooms': 'PerceptronModel',
        'pos_alksnis': 'PerceptronModel',
        'pos_alpino': 'PerceptronModel',
        'pos_anc': 'PerceptronModel',
        'pos_ancora': 'PerceptronModel',
        'pos_arcosg': 'PerceptronModel',
        'pos_armtdp': 'PerceptronModel',
        'pos_atis': 'PerceptronModel',
        'pos_bdt': 'PerceptronModel',
        'pos_bosque': 'PerceptronModel',
        'pos_btb': 'PerceptronModel',
        'pos_cac': 'PerceptronModel',
        'pos_ccg': 'PerceptronModel',
        'pos_clinical': 'PerceptronModel',
        'pos_cltt': 'PerceptronModel',
        'pos_ctg': 'PerceptronModel',
        'pos_ddt': 'PerceptronModel',
        'pos_ewt': 'PerceptronModel',
        'pos_framenet': 'PerceptronModel',
        'pos_ftb': 'PerceptronModel',
        'pos_gdt': 'PerceptronModel',
        'pos_gsd': 'PerceptronModel',
        'pos_gsdluw': 'PerceptronModel',
        'pos_gum': 'PerceptronModel',
        'pos_hdt': 'PerceptronModel',
        'pos_hdtb': 'PerceptronModel',
        'pos_hiencs': 'PerceptronModel',
        'pos_hse': 'PerceptronModel',
        'pos_htb': 'PerceptronModel',
        'pos_isdt': 'PerceptronModel',
        'pos_ittb': 'PerceptronModel',
        'pos_iu': 'PerceptronModel',
        'pos_kaist': 'PerceptronModel',
        'pos_kenet': 'PerceptronModel',
        'pos_kyoto': 'PerceptronModel',
        'pos_lassysmall': 'PerceptronModel',
        'pos_lines': 'PerceptronModel',
        'pos_llct': 'PerceptronModel',
        'pos_lst20': 'PerceptronModel',
        'pos_modern': 'PerceptronModel',
        'pos_msri': 'PerceptronModel',
        'pos_mtg': 'PerceptronModel',
        'pos_nsc': 'PerceptronModel',
        'pos_parisstories': 'PerceptronModel',
        'pos_partut': 'PerceptronModel',
        'pos_pdb': 'PerceptronModel',
        'pos_pdt': 'PerceptronModel',
        'pos_penn': 'PerceptronModel',
        'pos_perseus': 'PerceptronModel',
        'pos_postwita': 'PerceptronModel',
        'pos_proiel': 'PerceptronModel',
        'pos_rnc': 'PerceptronModel',
        'pos_rrt': 'PerceptronModel',
        'pos_seraji': 'PerceptronModel',
        'pos_set': 'PerceptronModel',
        'pos_simonero': 'PerceptronModel',
        'pos_snk': 'PerceptronModel',
        'pos_srcmf': 'PerceptronModel',
        'pos_ssj': 'PerceptronModel',
        'pos_szeged': 'PerceptronModel',
        'pos_taiga': 'PerceptronModel',
        'pos_talbanken': 'PerceptronModel',
        'pos_torot': 'PerceptronModel',
        'pos_treegal': 'PerceptronModel',
        'pos_ttb': 'PerceptronModel',
        'pos_ud_alpino': 'PerceptronModel',
        'pos_ud_ancora': 'PerceptronModel',
        'pos_ud_armtdp': 'PerceptronModel',
        'pos_ud_att': 'PerceptronModel',
        'pos_ud_bdt': 'PerceptronModel',
        'pos_ud_bhtb': 'PerceptronModel',
        'pos_ud_bosque': 'PerceptronModel',
        'pos_ud_btb': 'PerceptronModel',
        'pos_ud_ddt': 'PerceptronModel',
        'pos_ud_ewt': 'PerceptronModel',
        'pos_ud_gdt': 'PerceptronModel',
        'pos_ud_gsd': 'PerceptronModel',
        'pos_ud_gsd_trad': 'PerceptronModel',
        'pos_ud_hdt': 'PerceptronModel',
        'pos_ud_hdtb': 'PerceptronModel',
        'pos_ud_htb': 'PerceptronModel',
        'pos_ud_idt': 'PerceptronModel',
        'pos_ud_imst': 'PerceptronModel',
        'pos_ud_isdt': 'PerceptronModel',
        'pos_ud_iu': 'PerceptronModel',
        'pos_ud_kaist': 'PerceptronModel',
        'pos_ud_keb': 'PerceptronModel',
        'pos_ud_lfg': 'PerceptronModel',
        'pos_ud_llct': 'PerceptronModel',
        'pos_ud_lvtb': 'PerceptronModel',
        'pos_ud_nynorsk': 'PerceptronModel',
        'pos_ud_padt': 'PerceptronModel',
        'pos_ud_pdt': 'PerceptronModel',
        'pos_ud_perdt': 'PerceptronModel',
        'pos_ud_rrt': 'PerceptronModel',
        'pos_ud_snk': 'PerceptronModel',
        'pos_ud_ssj': 'PerceptronModel',
        'pos_ud_szeged': 'PerceptronModel',
        'pos_ud_tal': 'PerceptronModel',
        'pos_ud_tdt': 'PerceptronModel',
        'pos_ud_treegal': 'PerceptronModel',
        'pos_ud_udtb': 'PerceptronModel',
        'pos_ud_ufal': 'PerceptronModel',
        'pos_ud_ytb': 'PerceptronModel',
        'pos_udt': 'PerceptronModel',
        'pos_vit': 'PerceptronModel',
        'pos_vtb': 'PerceptronModel',
        'pragmatic_sentence_detector': 'SentenceDetector',
        're_ade_biobert': 'RelationExtractionModel',
        're_ade_clinical': 'RelationExtractionModel',
        're_drugprot_clinical': 'RelationExtractionModel',
        're_temporal_events_clinical': 'RelationExtractionModel',
        're_test_result_date': 'RelationExtractionModel',
        're_zeroshot_biobert': 'ZeroShotRelationExtractionModel',
        'redl_ade_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_direction_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_problem_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_procedure_test_biobert': 'RelationExtractionDLModel',
        'redl_chemprot_biobert': 'RelationExtractionDLModel',
        'redl_clinical_biobert': 'RelationExtractionDLModel',
        'redl_date_clinical_biobert': 'RelationExtractionDLModel',
        'redl_drug_drug_interaction_biobert': 'RelationExtractionDLModel',
        'redl_drugprot_biobert': 'RelationExtractionDLModel',
        'redl_human_phenotype_gene_biobert': 'RelationExtractionDLModel',
        'redl_nihss_biobert': 'RelationExtractionDLModel',
        'redl_temporal_events_biobert': 'RelationExtractionDLModel',
        'regex_matcher': 'RegexMatcher',
        'roberta_base': 'RoBertaEmbeddings',
        'roberta_base_biomedical': 'RoBertaEmbeddings',
        'roberta_base_sequence_classifier_ag_news': 'RoBertaForSequenceClassification',
        'roberta_base_sequence_classifier_imdb': 'RoBertaForSequenceClassification',
        'roberta_base_token_classifier_conll03': 'RoBertaForTokenClassification',
        'roberta_base_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'roberta_large': 'RoBertaEmbeddings',
        'roberta_large_token_classifier_conll03': 'RoBertaForTokenClassification',
        'roberta_large_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'roberta_ner_diag_proc': 'MedicalNerModel',
        'roberta_token_classifier_bne_capitel_ner': 'RoBertaForTokenClassification',
        'roberta_token_classifier_icelandic_ner': 'RoBertaForTokenClassification',
        'roberta_token_classifier_pos_tagger': 'RoBertaForTokenClassification',
        'roberta_token_classifier_ticker': 'RoBertaForTokenClassification',
        'roberta_token_classifier_timex_semeval': 'RoBertaForTokenClassification',
        'roberta_token_classifier_zwnj_base_ner': 'RoBertaForTokenClassification',
        'robertaresolve_snomed': 'SentenceEntityResolverModel',
        'sbert_jsl_medium_rxnorm_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_medium_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_medium_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_mini_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_mini_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_tiny_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_tiny_uncased': 'BertSentenceEmbeddings',
        'sbertresolve_icd10cm_slim_billable_hcc_med': 'SentenceEntityResolverModel',
        'sbertresolve_icd10gm': 'SentenceEntityResolverModel',
        'sbertresolve_rxnorm_disposition': 'SentenceEntityResolverModel',
        'sbertresolve_snomed': 'SentenceEntityResolverModel',
        'sbertresolve_snomed_bodyStructure_med': 'SentenceEntityResolverModel',
        'sbertresolve_snomed_conditions': 'SentenceEntityResolverModel',
        'sbiobert_base_cased_mli': 'BertSentenceEmbeddings',
        'sbiobert_jsl_cased': 'BertSentenceEmbeddings',
        'sbiobert_jsl_rxnorm_cased': 'BertSentenceEmbeddings',
        'sbiobert_jsl_umls_cased': 'BertSentenceEmbeddings',
        'sbiobertresolve_HPO': 'SentenceEntityResolverModel',
        'sbiobertresolve_clinical_abbreviation_acronym': 'SentenceEntityResolverModel',
        'sbiobertresolve_clinical_snomed_procedures_measurements': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_procedures_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_procedures_measurements_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_hcc_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_hcpcs': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_augmented_billable_hcc': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_generalised': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_slim_billable_hcc': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10pcs': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo_base': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc_cased': 'SentenceEntityResolverModel',
        'sbiobertresolve_mesh': 'SentenceEntityResolverModel',
        'sbiobertresolve_ndc': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxcui': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_augmented_re': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_disposition': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_ndc': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_auxConcepts': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_auxConcepts_int': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_bodyStructure': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_drug': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings_aux_concepts': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings_int': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_clinical_drugs': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_disease_syndrome': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_drug_substance': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_findings': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_major_concepts': 'SentenceEntityResolverModel',
        'sbluebert_base_uncased_mli': 'BertSentenceEmbeddings',
        'sbluebertresolve_loinc': 'SentenceEntityResolverModel',
        'sbluebertresolve_loinc_uncased': 'SentenceEntityResolverModel',
        'sent_bert_base_cased': 'BertSentenceEmbeddings',
        'sent_bert_base_uncased': 'BertSentenceEmbeddings',
        'sent_bert_base_uncased_legal': 'BertSentenceEmbeddings',
        'sent_bert_large_cased': 'BertSentenceEmbeddings',
        'sent_bert_large_uncased': 'BertSentenceEmbeddings',
        'sent_bert_multi_cased': 'BertSentenceEmbeddings',
        'sent_bert_muril': 'BertSentenceEmbeddings',
        'sent_bert_pubmed': 'BertSentenceEmbeddings',
        'sent_bert_pubmed_squad2': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_en_base': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_en_large': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_multi_base': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_multi_base_br': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_mnli': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_qnli': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_qqp': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_squad2': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_sst2': 'BertSentenceEmbeddings',
        'sent_biobert_clinical_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_discharge_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pmc_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_large_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_pmc_base_cased': 'BertSentenceEmbeddings',
        'sent_covidbert_large_uncased': 'BertSentenceEmbeddings',
        'sent_electra_base_uncased': 'BertSentenceEmbeddings',
        'sent_electra_large_uncased': 'BertSentenceEmbeddings',
        'sent_electra_small_uncased': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_768': 'BertSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_amharic': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_hausa': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_igbo': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_kinyarwanda': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_luganda': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_naija': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_swahili': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_wolof': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_yoruba': 'XlmRoBertaSentenceEmbeddings',
        'sentence_detector_dl': 'SentenceDetectorDLModel',
        'sentence_detector_dl_healthcare': 'SentenceDetectorDLModel',
        'sentiment_jager_use': 'SentimentDLModel',
        'sentiment_vivekn': 'ViveknSentimentModel',
        'sentimentdl_glove_imdb': 'SentimentDLModel',
        'sentimentdl_urduvec_imdb': 'SentimentDLModel',
        'sentimentdl_use_imdb': 'SentimentDLModel',
        'sentimentdl_use_twitter': 'SentimentDLModel',
        'small_bert_L10_128': 'BertEmbeddings',
        'small_bert_L10_256': 'BertEmbeddings',
        'small_bert_L10_512': 'BertEmbeddings',
        'small_bert_L10_768': 'BertEmbeddings',
        'small_bert_L12_128': 'BertEmbeddings',
        'small_bert_L12_256': 'BertEmbeddings',
        'small_bert_L12_512': 'BertEmbeddings',
        'small_bert_L12_768': 'BertEmbeddings',
        'small_bert_L2_128': 'BertEmbeddings',
        'small_bert_L2_256': 'BertEmbeddings',
        'small_bert_L2_512': 'BertEmbeddings',
        'small_bert_L2_768': 'BertEmbeddings',
        'small_bert_L4_128': 'BertEmbeddings',
        'small_bert_L4_256': 'BertEmbeddings',
        'small_bert_L4_512': 'BertEmbeddings',
        'small_bert_L4_768': 'BertEmbeddings',
        'small_bert_L6_128': 'BertEmbeddings',
        'small_bert_L6_256': 'BertEmbeddings',
        'small_bert_L6_512': 'BertEmbeddings',
        'small_bert_L6_768': 'BertEmbeddings',
        'small_bert_L8_128': 'BertEmbeddings',
        'small_bert_L8_256': 'BertEmbeddings',
        'small_bert_L8_512': 'BertEmbeddings',
        'small_bert_L8_768': 'BertEmbeddings',
        'spark_nlp_tokenizer': 'TokenizerModel',
        'spellcheck_dl': 'ContextSpellCheckerModel',
        'spellcheck_drug_norvig': 'NorvigSweetingModel',
        'spellcheck_norvig': 'NorvigSweetingModel',
        'spellcheck_sd': 'SymmetricDeleteModel',
        'stemmer': 'Stemmer',
        'stopwords_af': 'StopWordsCleaner',
        'stopwords_ar': 'StopWordsCleaner',
        'stopwords_bg': 'StopWordsCleaner',
        'stopwords_bn': 'StopWordsCleaner',
        'stopwords_br': 'StopWordsCleaner',
        'stopwords_ca': 'StopWordsCleaner',
        'stopwords_cs': 'StopWordsCleaner',
        'stopwords_de': 'StopWordsCleaner',
        'stopwords_el': 'StopWordsCleaner',
        'stopwords_en': 'StopWordsCleaner',
        'stopwords_eo': 'StopWordsCleaner',
        'stopwords_es': 'StopWordsCleaner',
        'stopwords_eu': 'StopWordsCleaner',
        'stopwords_fa': 'StopWordsCleaner',
        'stopwords_fi': 'StopWordsCleaner',
        'stopwords_fr': 'StopWordsCleaner',
        'stopwords_ga': 'StopWordsCleaner',
        'stopwords_gl': 'StopWordsCleaner',
        'stopwords_ha': 'StopWordsCleaner',
        'stopwords_he': 'StopWordsCleaner',
        'stopwords_hi': 'StopWordsCleaner',
        'stopwords_hu': 'StopWordsCleaner',
        'stopwords_hy': 'StopWordsCleaner',
        'stopwords_id': 'StopWordsCleaner',
        'stopwords_it': 'StopWordsCleaner',
        'stopwords_ja': 'StopWordsCleaner',
        'stopwords_la': 'StopWordsCleaner',
        'stopwords_lv': 'StopWordsCleaner',
        'stopwords_mr': 'StopWordsCleaner',
        'stopwords_pl': 'StopWordsCleaner',
        'stopwords_pt': 'StopWordsCleaner',
        'stopwords_ro': 'StopWordsCleaner',
        'stopwords_ru': 'StopWordsCleaner',
        'stopwords_sk': 'StopWordsCleaner',
        'stopwords_sl': 'StopWordsCleaner',
        'stopwords_so': 'StopWordsCleaner',
        'stopwords_st': 'StopWordsCleaner',
        'stopwords_sv': 'StopWordsCleaner',
        'stopwords_sw': 'StopWordsCleaner',
        'stopwords_th': 'StopWordsCleaner',
        'stopwords_tr': 'StopWordsCleaner',
        'stopwords_yo': 'StopWordsCleaner',
        'stopwords_zu': 'StopWordsCleaner',
        'swedish_ner_6B_100': 'NerDLModel',
        'swedish_ner_6B_300': 'NerDLModel',
        'swedish_ner_840B_300': 'NerDLModel',
        't5_active_to_passive_styletransfer': 'T5Transformer',
        't5_base': 'T5Transformer',
        't5_base_mediqa_mnli': 'T5Transformer',
        't5_formal_to_informal_styletransfer': 'T5Transformer',
        't5_grammar_error_corrector': 'T5Transformer',
        't5_informal_to_formal_styletransfer': 'T5Transformer',
        't5_passive_to_active_styletransfer': 'T5Transformer',
        't5_small': 'T5Transformer',
        't5_small_wikiSQL': 'T5Transformer',
        'text_matcher': 'TextMatcher',
        'tfhub_use': 'UniversalSentenceEncoder',
        'tfhub_use_lg': 'UniversalSentenceEncoder',
        'tfhub_use_multi': 'UniversalSentenceEncoder',
        'tfhub_use_multi_lg': 'UniversalSentenceEncoder',
        'turkish_ner_840B_300': 'NerDLModel',
        'turkish_ner_bert': 'NerDLModel',
        'twitter_xlm_roberta_base': 'XlmRoBertaEmbeddings',
        'uner_mk_140M_300d': 'NerDLModel',
        'urduvec_140M_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'wikiner_6B_100': 'NerDLModel',
        'wikiner_6B_300': 'NerDLModel',
        'wikiner_840B_300': 'NerDLModel',
        'word2vec_gigaword_300': 'Word2VecModel',
        'word2vec_gigaword_wiki_300': 'Word2VecModel',
        'word2vec_wac_200': 'WordEmbeddingsModel',
        'word2vec_wiki_1000': 'WordEmbeddingsModel',
        'wordseg_best': 'WordSegmenterModel',
        'wordseg_ctb9': 'WordSegmenterModel',
        'wordseg_gsd_ud': 'WordSegmenterModel',
        'wordseg_gsd_ud_trad': 'WordSegmenterModel',
        'wordseg_kaist_ud': 'WordSegmenterModel',
        'wordseg_large': 'WordSegmenterModel',
        'wordseg_msra': 'WordSegmenterModel',
        'wordseg_pku': 'WordSegmenterModel',
        'wordseg_weibo': 'WordSegmenterModel',
        'xlm_roberta_base': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_amharic': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_hausa': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_igbo': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_kinyarwanda': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_luganda': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_luo': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_naija': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_swahili': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_wolof': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_yoruba': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_sequence_classifier_ag_news': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_sequence_classifier_allocine': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_sequence_classifier_imdb': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_token_classifier_ner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large': 'XlmRoBertaEmbeddings',
        'xlm_roberta_large_token_classification_ner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_conll03': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_hrl': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_masakhaner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_token_classifier_ner_40_lang': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_xtreme_base': 'XlmRoBertaEmbeddings',
        'xlnet_base_cased': 'XlnetEmbeddings',
        'xlnet_base_sequence_classifier_ag_news': 'XlnetForSequenceClassification',
        'xlnet_base_sequence_classifier_imdb': 'XlnetForSequenceClassification',
        'xlnet_base_token_classifier_conll03': 'XlnetForTokenClassification',
        'xlnet_large_cased': 'XlnetEmbeddings',
        'xlnet_large_token_classifier_conll03': 'XlnetForTokenClassification',
        'yake': 'YakeKeywordExtraction',

        'albert_qa_BioM_xxlarge_SQuAD2': 'AlbertForQuestionAnswering',
        'albert_qa_QA_1e': 'AlbertForQuestionAnswering',
        'albert_qa_ai_club_inductions_21_nlp': 'AlbertForQuestionAnswering',
        'albert_qa_base_v2_squad': 'AlbertForQuestionAnswering',
        'albert_qa_cs224n_squad2.0_base_v2': 'AlbertForQuestionAnswering',
        'albert_qa_cs224n_squad2.0_large_v2': 'AlbertForQuestionAnswering',
        'albert_qa_cs224n_squad2.0_xxlarge_v1': 'AlbertForQuestionAnswering',
        'albert_qa_generic': 'AlbertForQuestionAnswering',
        'albert_qa_nlpunibo': 'AlbertForQuestionAnswering',
        'albert_qa_slp': 'AlbertForQuestionAnswering',
        'albert_qa_squad_2.0': 'AlbertForQuestionAnswering',
        'albert_qa_squad_slp': 'AlbertForQuestionAnswering',
        'albert_qa_vumichien_base_v2_squad2': 'AlbertForQuestionAnswering',
        'albert_qa_xlarge_finetuned': 'AlbertForQuestionAnswering',
        'albert_qa_xlarge_finetuned_squad': 'AlbertForQuestionAnswering',
        'albert_qa_xlarge_v2_squad_v2': 'AlbertForQuestionAnswering',
        'albert_qa_xxlarge_finetuned_squad': 'AlbertForQuestionAnswering',
        'albert_qa_xxlarge_tweetqa': 'AlbertForQuestionAnswering',
        'albert_qa_xxlarge_v1_finetuned_squad2': 'AlbertForQuestionAnswering',
        'albert_qa_xxlarge_v2_squad2': 'AlbertForQuestionAnswering',
        'albert_qa_xxlarge_v2_squad2_covid_deepset': 'AlbertForQuestionAnswering',
        'albert_qa_xxlargev1_squad2_512': 'AlbertForQuestionAnswering',
        'bert_base_cased_qa_squad2': 'BertForQuestionAnswering',
        'bert_qa_Alexander_Learn_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Bertv1_fine': 'BertForQuestionAnswering',
        'bert_qa_COVID_BERTa': 'BertForQuestionAnswering',
        'bert_qa_COVID_BERTb': 'BertForQuestionAnswering',
        'bert_qa_COVID_BERTc': 'BertForQuestionAnswering',
        'bert_qa_FardinSaboori_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_GBERTQnA': 'BertForQuestionAnswering',
        'bert_qa_Graphcore_bert_large_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_Harsit_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_HomayounSadri_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Indobert_QA': 'BertForQuestionAnswering',
        'bert_qa_KevinChoi_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_KevinChoi_bert_finetuned_squad_accelerate': 'BertForQuestionAnswering',
        'bert_qa_Klue_CommonSense_model': 'BertForQuestionAnswering',
        'bert_qa_Laikokwei_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_MTL_bert_base_uncased_ww_squad': 'BertForQuestionAnswering',
        'bert_qa_ManuERT_for_xqua': 'BertForQuestionAnswering',
        'bert_qa_MiniLM_L12_H384_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Multi_ling_BERT': 'BertForQuestionAnswering',
        'bert_qa_Neulvo_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Part_1_mBERT_Model_E1': 'BertForQuestionAnswering',
        'bert_qa_Part_1_mBERT_Model_E2': 'BertForQuestionAnswering',
        'bert_qa_Part_2_BERT_Multilingual_Dutch_Model_E1': 'BertForQuestionAnswering',
        'bert_qa_Part_2_mBERT_Model_E2': 'BertForQuestionAnswering',
        'bert_qa_Paul_Vinh_bert_base_multilingual_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_PruebaBert': 'BertForQuestionAnswering',
        'bert_qa_SciBERT_SQuAD_QuAC': 'BertForQuestionAnswering',
        'bert_qa_Seongkyu_bert_base_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Shushant_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT': 'BertForQuestionAnswering',
        'bert_qa_Sotireas_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT': 'BertForQuestionAnswering',
        'bert_qa_Spanbert_emotion_extraction': 'BertForQuestionAnswering',
        'bert_qa_SreyanG_NVIDIA_bert_base_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_SreyanG_NVIDIA_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_SupriyaArun_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Tianle_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_Trial_3_Results': 'BertForQuestionAnswering',
        'bert_qa_ainize_klue_bert_base_mrc': 'BertForQuestionAnswering',
        'bert_qa_andresestevez_bert_base_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_andresestevez_bert_finetuned_squad_accelerate': 'BertForQuestionAnswering',
        'bert_qa_ankitkupadhyay_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_araSpeedest': 'BertForQuestionAnswering',
        'bert_qa_arap_qa_bert': 'BertForQuestionAnswering',
        'bert_qa_arap_qa_bert_large_v2': 'BertForQuestionAnswering',
        'bert_qa_arap_qa_bert_v2': 'BertForQuestionAnswering',
        'bert_qa_augmented': 'BertForQuestionAnswering',
        'bert_qa_augmented_Squad_Translated': 'BertForQuestionAnswering',
        'bert_qa_base_japanese_wikipedia_ud_head': 'BertForQuestionAnswering',
        'bert_qa_batterybert_cased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batterybert_uncased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batterydata_bert_base_uncased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batteryonlybert_cased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batteryonlybert_uncased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batteryscibert_cased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_batteryscibert_uncased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_bdickson_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert': 'BertForQuestionAnswering',
        'bert_qa_bert_FT_new_newsqa': 'BertForQuestionAnswering',
        'bert_qa_bert_FT_newsqa': 'BertForQuestionAnswering',
        'bert_qa_bert_all': 'BertForQuestionAnswering',
        'bert_qa_bert_all_squad_all_translated': 'BertForQuestionAnswering',
        'bert_qa_bert_all_squad_ben_tel_context': 'BertForQuestionAnswering',
        'bert_qa_bert_all_squad_que_translated': 'BertForQuestionAnswering',
        'bert_qa_bert_all_translated': 'BertForQuestionAnswering',
        'bert_qa_bert_base_1024_full_trivia_copied_embeddings': 'BertForQuestionAnswering',
        'bert_qa_bert_base_2048_full_trivia_copied_embeddings': 'BertForQuestionAnswering',
        'bert_qa_bert_base_4096_full_trivia_copied_embeddings': 'BertForQuestionAnswering',
        'bert_qa_bert_base_512_full_trivia': 'BertForQuestionAnswering',
        'bert_qa_bert_base_cased_IUChatbot_ontologyDts': 'BertForQuestionAnswering',
        'bert_qa_bert_base_cased_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_base_cased_finetuned_squad_test': 'BertForQuestionAnswering',
        'bert_qa_bert_base_cased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_cased_squad_v1.1_portuguese': 'BertForQuestionAnswering',
        'bert_qa_bert_base_chinese_finetuned_squad_colab': 'BertForQuestionAnswering',
        'bert_qa_bert_base_fa_qa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_faquad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_finetuned_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_italian_uncased_squad_it_antoniocappiello': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetune_qa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_dutch_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_klue': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_korquad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_cased_korquad_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_multilingual_xquad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_portuguese_cased_finetuned_squad_v1_pt_mrm8488': 'BertForQuestionAnswering',
        'bert_qa_bert_base_sinhala_qa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_mlqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_sqac': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_tar': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_finetuned_sqac': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad2_es_MMG': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_MMG': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_finetuned_sqac': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_mlqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_sqac': 'BertForQuestionAnswering',
        'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_tar': 'BertForQuestionAnswering',
        'bert_qa_bert_base_squadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_swedish_cased_squad_experimental': 'BertForQuestionAnswering',
        'bert_qa_bert_base_swedish_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3': 'BertForQuestionAnswering',
        'bert_qa_bert_base_turkish_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_coqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_1024_finetuned_squad_seed_42': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_128_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_16_finetuned_squad_seed_42': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_256_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_32_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_512_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_few_shot_k_64_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_docvqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_duorc_bert': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_infovqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_newsqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_squad_frozen_v2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_squad_v2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_finetuned_vi_infovqa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_fiqa_flm_sq_flit': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_qa_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.07_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.13_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.20_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.32_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad1.1_pruned_x3.2_v2': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad2_covid_qa_deepset': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad_L3': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad_L6': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squad_v1_sparse0.25': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1.1_sparse_80_1x4_block_pruneofa': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x1.16_f88.1_d8_unstruct_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x1.84_f88.7_d36_hybrid_filled_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x1.96_f88.3_d27_hybrid_filled_opt_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x2.01_f89.2_d30_hybrid_rewind_opt_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x2.32_f86.6_d15_hybrid_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_base_uncased_squadv1_x2.44_f87.7_d26_hybrid_filled_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_chinese_finetuned': 'BertForQuestionAnswering',
        'bert_qa_bert_fa_QA_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_jackh1995': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_lr2_e5_b16_ep2': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_qa': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_squad1': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_squad_accelerate_10epoch_transformerfrozen': 'BertForQuestionAnswering',
        'bert_qa_bert_finetuned_squad_pytorch': 'BertForQuestionAnswering',
        'bert_qa_bert_italian_finedtuned_squadv1_it_alfa': 'BertForQuestionAnswering',
        'bert_qa_bert_l_squadv1.1_sl256': 'BertForQuestionAnswering',
        'bert_qa_bert_l_squadv1.1_sl384': 'BertForQuestionAnswering',
        'bert_qa_bert_large_cased_squad_v1.1_portuguese': 'BertForQuestionAnswering',
        'bert_qa_bert_large_cased_whole_word_masking_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_large_faquad': 'BertForQuestionAnswering',
        'bert_qa_bert_large_finetuned': 'BertForQuestionAnswering',
        'bert_qa_bert_large_finetuned_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_large_question_answering_finetuned_legal': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_finetuned_docvqa': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_squad2_covid_qa_deepset': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_squadv1.1_sparse_80_1x4_block_pruneofa': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_squadv1.1_sparse_90_unstructured': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_finetuned_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad_finetuned_islamic_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pistherea_conll2003_with_neg_with_repeat': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pwhatisthe_conll2003_with_neg_with_repeat': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_conll2003_with_neg_with_repeat': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_movie_with_neg_with_repeat': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_restaurant_with_neg_with_repeat': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_wwm_squadv2_x2.15_f83.2_d25_hybrid_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_large_uncased_wwm_squadv2_x2.63_f82.6_d16_hybrid_v1': 'BertForQuestionAnswering',
        'bert_qa_bert_medium_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_medium_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_medium_pretrained_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_medium_squad2_distilled': 'BertForQuestionAnswering',
        'bert_qa_bert_medium_wrslb_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_mini_5_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_mini_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_mini_wrslb_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_finedtuned_xquad_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_finedtuned_xquad_tydiqa_goldp': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_finetuned_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_finetuned_xquadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_finetuned_xquadv1_finetuned_squad_colab': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_cased_squad_sv_marbogusz': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_english_german_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_uncased_finetuned_chaii': 'BertForQuestionAnswering',
        'bert_qa_bert_multi_uncased_finetuned_xquadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_qa_vi_nvkha': 'BertForQuestionAnswering',
        'bert_qa_bert_qasper': 'BertForQuestionAnswering',
        'bert_qa_bert_reader_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_set_date_1_lr_2e_5_bs_32_ep_4': 'BertForQuestionAnswering',
        'bert_qa_bert_small_2_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_small_cord19_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_small_cord19qa': 'BertForQuestionAnswering',
        'bert_qa_bert_small_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_small_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_small_pretrained_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_small_wrslb_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_2_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_3_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_4_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_5_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_bert_tiny_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_bert_turkish_question_answering': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_10_H_512_A_8_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_10_H_512_A_8_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_2_H_512_A_8_cord19_200616_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_2_H_512_A_8_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_2_H_512_A_8_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_256_A_4_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_256_A_4_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_512_A_8_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_512_A_8_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_768_A_12_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_4_H_768_A_12_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_6_H_128_A_2_squad2': 'BertForQuestionAnswering',
        'bert_qa_bert_uncased_L_6_H_128_A_2_squad2_covid_qna': 'BertForQuestionAnswering',
        'bert_qa_bertimbau_squad1.1': 'BertForQuestionAnswering',
        'bert_qa_bertserini_bert_base_squad': 'BertForQuestionAnswering',
        'bert_qa_bertserini_bert_large_squad': 'BertForQuestionAnswering',
        'bert_qa_bespin_global_klue_bert_base_mrc': 'BertForQuestionAnswering',
        'bert_qa_beto_base_spanish_sqac': 'BertForQuestionAnswering',
        'bert_qa_bioBERTpt_squad_v1.1_portuguese': 'BertForQuestionAnswering',
        'bert_qa_biobert_base_cased_v1.1_squad': 'BertForQuestionAnswering',
        'bert_qa_biobert_base_cased_v1.1_squad_finetuned_biobert': 'BertForQuestionAnswering',
        'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covbiobert': 'BertForQuestionAnswering',
        'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covdrobert': 'BertForQuestionAnswering',
        'bert_qa_biobert_bioasq': 'BertForQuestionAnswering',
        'bert_qa_biobert_squad2_cased': 'BertForQuestionAnswering',
        'bert_qa_biobert_squad2_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_biobert_v1.1_pubmed_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_biobert_v1.1_pubmed_squad_v2': 'BertForQuestionAnswering',
        'bert_qa_bioformer_cased_v1.0_squad1': 'BertForQuestionAnswering',
        'bert_qa_biomedical_slot_filling_reader_base': 'BertForQuestionAnswering',
        'bert_qa_biomedical_slot_filling_reader_large': 'BertForQuestionAnswering',
        'bert_qa_braquad_bert_qna': 'BertForQuestionAnswering',
        'bert_qa_causal_qa': 'BertForQuestionAnswering',
        'bert_qa_chemical_bert_uncased_squad2': 'BertForQuestionAnswering',
        'bert_qa_chinese_pert_base_mrc': 'BertForQuestionAnswering',
        'bert_qa_chinese_pert_large_mrc': 'BertForQuestionAnswering',
        'bert_qa_chinese_pert_large_open_domain_mrc': 'BertForQuestionAnswering',
        'bert_qa_chinese_pretrain_mrc_macbert_large': 'BertForQuestionAnswering',
        'bert_qa_chinese_pretrain_mrc_roberta_wwm_ext_large': 'BertForQuestionAnswering',
        'bert_qa_covid_squad': 'BertForQuestionAnswering',
        'bert_qa_covidbert_squad': 'BertForQuestionAnswering',
        'bert_qa_csarron_bert_base_uncased_squad_v1': 'BertForQuestionAnswering',
        'bert_qa_danish_bert_botxo_qa_squad': 'BertForQuestionAnswering',
        'bert_qa_datauma_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_debug_squad': 'BertForQuestionAnswering',
        'bert_qa_deepset_bert_base_uncased_squad2': 'BertForQuestionAnswering',
        'bert_qa_demo': 'BertForQuestionAnswering',
        'bert_qa_distilbert_base_uncased_finetuned_custom': 'BertForQuestionAnswering',
        'bert_qa_distilbert_tr_q_a': 'BertForQuestionAnswering',
        'bert_qa_distill_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488': 'BertForQuestionAnswering',
        'bert_qa_eauction_section_parsing_from_pretrained': 'BertForQuestionAnswering',
        'bert_qa_fewrel_zero_shot': 'BertForQuestionAnswering',
        'bert_qa_fine_tuned_squad_aip': 'BertForQuestionAnswering',
        'bert_qa_fine_tuned_tweetqa_aip': 'BertForQuestionAnswering',
        'bert_qa_finetune_bert_base_v1': 'BertForQuestionAnswering',
        'bert_qa_finetune_bert_base_v2': 'BertForQuestionAnswering',
        'bert_qa_finetune_bert_base_v3': 'BertForQuestionAnswering',
        'bert_qa_fpdm_bert_FT_new_newsqa': 'BertForQuestionAnswering',
        'bert_qa_fpdm_bert_FT_newsqa': 'BertForQuestionAnswering',
        'bert_qa_fpdm_hier_bert_FT_new_newsqa': 'BertForQuestionAnswering',
        'bert_qa_fpdm_hier_bert_FT_newsqa': 'BertForQuestionAnswering',
        'bert_qa_fpdm_triplet_bert_FT_new_newsqa': 'BertForQuestionAnswering',
        'bert_qa_fpdm_triplet_bert_FT_newsqa': 'BertForQuestionAnswering',
        'bert_qa_hebert_finetuned_hebrew_squad': 'BertForQuestionAnswering',
        'bert_qa_howey_bert_large_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_huBert_fine_tuned_hungarian_squadv1': 'BertForQuestionAnswering',
        'bert_qa_huggingface_course_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_huggingface_course_bert_finetuned_squad_accelerate': 'BertForQuestionAnswering',
        'bert_qa_internetoftim_bert_large_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_ixambert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_ixambert_finetuned_squad_eu_MarcBrun': 'BertForQuestionAnswering',
        'bert_qa_ixambert_finetuned_squad_eu_en_MarcBrun': 'BertForQuestionAnswering',
        'bert_qa_jatinshah_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_jimypbr_bert_base_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_juliusco_distilbert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_kamilali_distilbert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_kaporter_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_klue_bert_base_aihub_mrc': 'BertForQuestionAnswering',
        'bert_qa_large_japanese_wikipedia_ud_head': 'BertForQuestionAnswering',
        'bert_qa_linkbert_large_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_logo_qna_model': 'BertForQuestionAnswering',
        'bert_qa_loodos_bert_base_uncased_QA_fine_tuned': 'BertForQuestionAnswering',
        'bert_qa_mBERT_all_ty_SQen_SQ20_1': 'BertForQuestionAnswering',
        'bert_qa_mbert_bengali_tydiqa_qa': 'BertForQuestionAnswering',
        'bert_qa_minilm_uncased_squad2': 'BertForQuestionAnswering',
        'bert_qa_model_output': 'BertForQuestionAnswering',
        'bert_qa_mqa_baseline': 'BertForQuestionAnswering',
        'bert_qa_mqa_cls': 'BertForQuestionAnswering',
        'bert_qa_mqa_sim': 'BertForQuestionAnswering',
        'bert_qa_mqa_unsupsim': 'BertForQuestionAnswering',
        'bert_qa_mrbalazs5_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_mrp_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_arabic': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_chinese': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_english': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_german': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_hindi': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_spanish': 'BertForQuestionAnswering',
        'bert_qa_multilingual_bert_base_cased_vietnamese': 'BertForQuestionAnswering',
        'bert_qa_muril_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_muril_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_muril_large_cased_hita_qa': 'BertForQuestionAnswering',
        'bert_qa_muril_large_squad2': 'BertForQuestionAnswering',
        'bert_qa_neuralmagic_bert_squad_12layer_0sparse': 'BertForQuestionAnswering',
        'bert_qa_news_pretrain_bert_FT_new_newsqa': 'BertForQuestionAnswering',
        'bert_qa_news_pretrain_bert_FT_newsqa': 'BertForQuestionAnswering',
        'bert_qa_newsqa_bert_el_Danastos': 'BertForQuestionAnswering',
        'bert_qa_nickmuchi_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_no_need_to_name_this': 'BertForQuestionAnswering',
        'bert_qa_nolog_SciBert_v2': 'BertForQuestionAnswering',
        'bert_qa_nq_bert_el_Danastos': 'BertForQuestionAnswering',
        'bert_qa_ofirzaf_bert_large_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_output_files': 'BertForQuestionAnswering',
        'bert_qa_peterhsu_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_peterhsu_bert_finetuned_squad_accelerate': 'BertForQuestionAnswering',
        'bert_qa_prunebert_base_uncased_6_finepruned_w_distil_squad': 'BertForQuestionAnswering',
        'bert_qa_pubmed_bert_squadv2': 'BertForQuestionAnswering',
        'bert_qa_qa_roberta_base_chinese_extractive': 'BertForQuestionAnswering',
        'bert_qa_qacombination_bert_el_Danastos': 'BertForQuestionAnswering',
        'bert_qa_qaconv_bert_large_uncased_whole_word_masking_squad2': 'BertForQuestionAnswering',
        'bert_qa_question_answering_chinese': 'BertForQuestionAnswering',
        'bert_qa_question_answering_zh_voidful': 'BertForQuestionAnswering',
        'bert_qa_results': 'BertForQuestionAnswering',
        'bert_qa_roberta_base_chinese_extractive_qa': 'BertForQuestionAnswering',
        'bert_qa_roberta_base_chinese_extractive_qa_scratch': 'BertForQuestionAnswering',
        'bert_qa_sagemaker_BioclinicalBERT_ADR': 'BertForQuestionAnswering',
        'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_sapbert_from_pubmedbert_squad2': 'BertForQuestionAnswering',
        'bert_qa_sbert_large_nlu_ru_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_scibert_nli_squad': 'BertForQuestionAnswering',
        'bert_qa_scibert_scivocab_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_scibert_scivocab_uncased_squad_v2': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_2': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_4': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_42': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_6': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_8': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_4': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_6': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_8': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_42': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_2': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_6': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_6': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_8': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_0': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_10': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_2': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_4': 'BertForQuestionAnswering',
        'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_6': 'BertForQuestionAnswering',
        'bert_qa_spanbert_finetuned_squadv1': 'BertForQuestionAnswering',
        'bert_qa_spanbert_finetuned_squadv2': 'BertForQuestionAnswering',
        'bert_qa_spanbert_large_recruit_qa': 'BertForQuestionAnswering',
        'bert_qa_spanbert_recruit_qa': 'BertForQuestionAnswering',
        'bert_qa_squad1.1': 'BertForQuestionAnswering',
        'bert_qa_squad1.1_1': 'BertForQuestionAnswering',
        'bert_qa_squad2.0': 'BertForQuestionAnswering',
        'bert_qa_squad_baseline': 'BertForQuestionAnswering',
        'bert_qa_squad_bert_el_Danastos': 'BertForQuestionAnswering',
        'bert_qa_squad_en_bert_base': 'BertForQuestionAnswering',
        'bert_qa_squad_mbert_en_de_es_model': 'BertForQuestionAnswering',
        'bert_qa_squad_mbert_en_de_es_vi_zh_model': 'BertForQuestionAnswering',
        'bert_qa_squad_mbert_model': 'BertForQuestionAnswering',
        'bert_qa_squad_mbert_model_2': 'BertForQuestionAnswering',
        'bert_qa_squad_ms_bert_base': 'BertForQuestionAnswering',
        'bert_qa_squad_xxl_cased_hub1': 'BertForQuestionAnswering',
        'bert_qa_srmukundb_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_telugu_bertu_tydiqa': 'BertForQuestionAnswering',
        'bert_qa_tests_finetuned_squad_test_bert': 'BertForQuestionAnswering',
        'bert_qa_tests_finetuned_squad_test_bert_2': 'BertForQuestionAnswering',
        'bert_qa_tf_bert_base_cased_squad2': 'BertForQuestionAnswering',
        'bert_qa_tf_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_thai_bert_multi_cased_finetuned_xquadv1_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_tinybert_6l_768d_squad2': 'BertForQuestionAnswering',
        'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned': 'BertForQuestionAnswering',
        'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned_step1': 'BertForQuestionAnswering',
        'bert_qa_triviaqa_bert_el_Danastos': 'BertForQuestionAnswering',
        'bert_qa_twmkn9_bert_base_uncased_squad2': 'BertForQuestionAnswering',
        'bert_qa_unqover_bert_base_uncased_newsqa': 'BertForQuestionAnswering',
        'bert_qa_unqover_bert_base_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_victoraavila_bert_base_uncased_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_vuiseng9_bert_base_uncased_squad': 'BertForQuestionAnswering',
        'bert_qa_xdistil_l12_h384_squad2': 'BertForQuestionAnswering',
        'bert_qa_xquad_th_mbert_base': 'BertForQuestionAnswering',
        'bert_qa_xtremedistil_l6_h256_uncased_TQUAD_finetuned_lr_2e_05_epochs_9': 'BertForQuestionAnswering',
        'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_3': 'BertForQuestionAnswering',
        'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_6': 'BertForQuestionAnswering',
        'bert_qa_ydshieh_bert_base_cased_squad2': 'BertForQuestionAnswering',
        'bert_qa_youngjae_bert_finetuned_squad': 'BertForQuestionAnswering',
        'bert_qa_youngjae_bert_finetuned_squad_accelerate': 'BertForQuestionAnswering',
        'bert_qa_zero_shot': 'BertForQuestionAnswering',
        'deberta_v3_xsmall_qa_squad2': 'DeBertaForQuestionAnswering',
        'distilbert_base_cased_qa_squad2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_21iridescent_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_AQG_CV_Squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Adrian_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Ayoola_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_BERT': 'DistilBertForQuestionAnswering',
        'distilbert_qa_BERT_ClinicalQA': 'DistilBertForQuestionAnswering',
        'distilbert_qa_COVID_DistilBERTa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_COVID_DistilBERTb': 'DistilBertForQuestionAnswering',
        'distilbert_qa_COVID_DistilBERTc': 'DistilBertForQuestionAnswering',
        'distilbert_qa_FOFer_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Firat_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Gayathri_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Hoang_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_HomayounSadri_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_MTL_base_uncased_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_MYX4567_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Nadhiya_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_ParulChaudhari_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Plimpton_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Raphaelg9_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Rocketknight1_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_SAE_base_uncased_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_SEISHIN_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Shashidhar_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Sourabh714_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_SupriyaArun_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Thitaree_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Tianle_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_V3RX2000_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_Wiam_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_aaraki_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_abhinavkulkarni_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_akr_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_andi611_base_uncased_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_anurag0077_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_anurag0077_base_uncased_finetuned_squad2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_arvalinno_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_avioo1_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_cased_distilled_chaii': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_cased_distilled_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_cased_distilled_squad_finetuned_squad_small': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_cased_distilled_squad_finetuned_squad_test': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_cased_sgd_qa_step5000': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_config1': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_config2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_config3': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_squad2_custom_dataset': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_3feb_2022_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_distilled_chaii': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_distilled_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_distilled_squad_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_advers': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_duorc_': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_indosquad_v2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_infovqa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_jumbling_squad_15': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_natural_questions': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_squad3': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_squad_': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_squad_colab': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_squad_frozen_v2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_squad_v1': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_finetuned_triviaqa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_gradient_clinic': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_holtin_finetuned_full_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_holtin_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_qa_with_ner': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_covid_qa_deepset': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner_mit_restaurant_with_neg_with_repeat': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner_with_neg': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi_with_repeat': 'DistilBertForQuestionAnswering',
        'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_repeat': 'DistilBertForQuestionAnswering',
        'distilbert_qa_bdickson_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_bert_base_cased_finetuned_log_parser_winlogbeat': 'DistilBertForQuestionAnswering',
        'distilbert_qa_bizlin_distil_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_caiosantillo_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_checkpoint_500_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_custom': 'DistilBertForQuestionAnswering',
        'distilbert_qa_custom3': 'DistilBertForQuestionAnswering',
        'distilbert_qa_custom4': 'DistilBertForQuestionAnswering',
        'distilbert_qa_custom5': 'DistilBertForQuestionAnswering',
        'distilbert_qa_dbert_3epoch': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distilBertABSA': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distil_bert_finetuned_log_parser_1': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distil_bert_finetuned_log_parser_winlogbeat': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_mlqa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_sqac': 'DistilBertForQuestionAnswering',
        'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_tar': 'DistilBertForQuestionAnswering',
        'distilbert_qa_emre_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_en_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_en_de_es_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_en_de_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_en_de_vi_zh_es_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_fadhilarkan_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_finetuned': 'DistilBertForQuestionAnswering',
        'distilbert_qa_flat_N_max': 'DistilBertForQuestionAnswering',
        'distilbert_qa_gokulkarthik_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_graviraja_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_guhuawuli_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_hark99_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_hcy11_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_hiiii23_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_holtin_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_huggingfaceepita_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_huxxx657_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_jgammack_base_uncased_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_jhoonk_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_jsunster_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_kaggleodin_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_model_QA_5_epoch_RU': 'DistilBertForQuestionAnswering',
        'distilbert_qa_multi_finedtuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_multi_finetuned_for_xqua_on_chaii': 'DistilBertForQuestionAnswering',
        'distilbert_qa_multi_finetuned_for_xqua_on_tydiqa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_mvonwyl_base_uncased_finetuned_squad2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_mysquadv2_8Jan22_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_mysquadv2_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_projectmodel_bert': 'DistilBertForQuestionAnswering',
        'distilbert_qa_qa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_robustqa_baseline_01': 'DistilBertForQuestionAnswering',
        'distilbert_qa_robustqa_baseline_02': 'DistilBertForQuestionAnswering',
        'distilbert_qa_robustqa_tapt': 'DistilBertForQuestionAnswering',
        'distilbert_qa_sdsqna': 'DistilBertForQuestionAnswering',
        'distilbert_qa_single_label_N_max': 'DistilBertForQuestionAnswering',
        'distilbert_qa_single_label_N_max_long_training': 'DistilBertForQuestionAnswering',
        'distilbert_qa_squad_en_de_es_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_squad_en_de_es_vi_zh_model': 'DistilBertForQuestionAnswering',
        'distilbert_qa_squad_slp': 'DistilBertForQuestionAnswering',
        'distilbert_qa_squadv1': 'DistilBertForQuestionAnswering',
        'distilbert_qa_tabo_base_uncased_finetuned_squad2': 'DistilBertForQuestionAnswering',
        'distilbert_qa_test_squad_trained': 'DistilBertForQuestionAnswering',
        'distilbert_qa_test_squad_trained_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_tiny_base_cased_distilled_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_transformers_base_uncased_finetuneQA_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_transformers_qa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_tucan9389_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_unique_N_max': 'DistilBertForQuestionAnswering',
        'distilbert_qa_unqover_base_uncased_newsqa': 'DistilBertForQuestionAnswering',
        'distilbert_qa_unqover_base_uncased_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_usami_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_vitusya_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_vkmr_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'distilbert_qa_vkrishnamoorthy_base_uncased_finetuned_squad': 'DistilBertForQuestionAnswering',
        'electra_qa_AraELECTRA_discriminator_SOQAL': 'BertForQuestionAnswering',
        'electra_qa_AraElectra_base_finetuned_ARCD': 'BertForQuestionAnswering',
        'electra_qa_BioM_Base_SQuAD2': 'BertForQuestionAnswering',
        'electra_qa_BioM_Base_SQuAD2_BioASQ8B': 'BertForQuestionAnswering',
        'electra_qa_BioM_Large_SQuAD2': 'BertForQuestionAnswering',
        'electra_qa_BioM_Large_SQuAD2_BioASQ8B': 'BertForQuestionAnswering',
        'electra_qa_DSPFirst_Finetuning_1': 'BertForQuestionAnswering',
        'electra_qa_DSPFirst_Finetuning_2': 'BertForQuestionAnswering',
        'electra_qa_DSPFirst_Finetuning_3': 'BertForQuestionAnswering',
        'electra_qa_DSPFirst_Finetuning_4': 'BertForQuestionAnswering',
        'electra_qa_DSPFirst_Finetuning_5': 'BertForQuestionAnswering',
        'electra_qa_German_question_answer': 'BertForQuestionAnswering',
        'electra_qa_TestQA2': 'BertForQuestionAnswering',
        'electra_qa_araElectra_SQUAD_ARCD': 'BertForQuestionAnswering',
        'electra_qa_araElectra_SQUAD_ARCD_768': 'BertForQuestionAnswering',
        'electra_qa_ara_base_artydiqa': 'BertForQuestionAnswering',
        'electra_qa_base_best_squad2': 'BertForQuestionAnswering',
        'electra_qa_base_chaii': 'BertForQuestionAnswering',
        'electra_qa_base_discriminator_finetuned_squad': 'BertForQuestionAnswering',
        'electra_qa_base_discriminator_finetuned_squadv1': 'BertForQuestionAnswering',
        'electra_qa_base_discriminator_finetuned_squadv2': 'BertForQuestionAnswering',
        'electra_qa_base_finetuned_squadv1': 'BertForQuestionAnswering',
        'electra_qa_base_finetuned_squadv2': 'BertForQuestionAnswering',
        'electra_qa_base_squad2': 'BertForQuestionAnswering',
        'electra_qa_base_squad2_covid_deepset': 'BertForQuestionAnswering',
        'electra_qa_base_v2_finetuned_korquad': 'BertForQuestionAnswering',
        'electra_qa_base_v2_finetuned_korquad_384': 'BertForQuestionAnswering',
        'electra_qa_base_v3_discriminator_finetuned_klue_v4': 'BertForQuestionAnswering',
        'electra_qa_base_v3_finetuned_korquad': 'BertForQuestionAnswering',
        'electra_qa_biomedtra_small_es_squad2': 'BertForQuestionAnswering',
        'electra_qa_elctrafp': 'BertForQuestionAnswering',
        'electra_qa_electricidad_small_finetuned_squadv1': 'BertForQuestionAnswering',
        'electra_qa_enelpi_squad': 'BertForQuestionAnswering',
        'electra_qa_g_base_germanquad': 'BertForQuestionAnswering',
        'electra_qa_g_base_germanquad_distilled': 'BertForQuestionAnswering',
        'electra_qa_g_large_germanquad': 'BertForQuestionAnswering',
        'electra_qa_google_base_discriminator_squad': 'BertForQuestionAnswering',
        'electra_qa_google_small_discriminator_squad': 'BertForQuestionAnswering',
        'electra_qa_hankzhong_small_discriminator_finetuned_squad': 'BertForQuestionAnswering',
        'electra_qa_klue_mrc_base': 'BertForQuestionAnswering',
        'electra_qa_large_discriminator_squad2_512': 'BertForQuestionAnswering',
        'electra_qa_large_discriminator_squad2_custom_dataset': 'BertForQuestionAnswering',
        'electra_qa_large_finetuned_squadv1': 'BertForQuestionAnswering',
        'electra_qa_large_squad': 'BertForQuestionAnswering',
        'electra_qa_large_synqa': 'BertForQuestionAnswering',
        'electra_qa_long': 'BertForQuestionAnswering',
        'electra_qa_slp': 'BertForQuestionAnswering',
        'electra_qa_small_discriminator_finetuned_squad_1': 'BertForQuestionAnswering',
        'electra_qa_small_discriminator_finetuned_squad_2': 'BertForQuestionAnswering',
        'electra_qa_small_finetuned_squadv1': 'BertForQuestionAnswering',
        'electra_qa_small_finetuned_squadv2': 'BertForQuestionAnswering',
        'electra_qa_small_turkish_uncased_discriminator_finetuned': 'BertForQuestionAnswering',
        'electra_qa_small_v3_finetuned_korquad': 'BertForQuestionAnswering',
        'electra_qa_squad_slp': 'BertForQuestionAnswering',
        'electra_qa_turkish': 'BertForQuestionAnswering',
        'longformer_base_base_qa_squad2': 'LongformerForQuestionAnswering',
        'longformer_qa_Chatbot': 'LongformerForQuestionAnswering',
        'longformer_qa_base_4096_finetuned_squadv2': 'LongformerForQuestionAnswering',
        'longformer_qa_covid': 'LongformerForQuestionAnswering',
        'longformer_qa_large_4096_finetuned_triviaqa': 'LongformerForQuestionAnswering',
        'longformer_qa_ponmari': 'LongformerForQuestionAnswering',
        'longformer_qa_recruit': 'LongformerForQuestionAnswering',
        'longformer_qa_recruit_large': 'LongformerForQuestionAnswering',
        'longformer_qa_recruit_v2': 'LongformerForQuestionAnswering',
        'roberta_base_qa_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_CH_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_DE_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_FI_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_FR_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_FR_XLM_R': 'RoBertaForQuestionAnswering',
        'roberta_qa_ADDI_IT_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_BSC_TeMU_roberta_base_bne_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_BSC_TeMU_roberta_large_bne_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_CV_Custom_DS': 'RoBertaForQuestionAnswering',
        'roberta_qa_CV_Merge_DS': 'RoBertaForQuestionAnswering',
        'roberta_qa_EManuals_RoBERTa_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_Firat_roberta_base_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_IceBERT_QA': 'RoBertaForQuestionAnswering',
        'roberta_qa_PlanTL_GOB_ES_roberta_base_bne_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_PlanTL_GOB_ES_roberta_large_bne_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_QA_for_Event_Extraction': 'RoBertaForQuestionAnswering',
        'roberta_qa_REQA_RoBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_RoBERTa_base_finetuned_squad2_lwt': 'RoBertaForQuestionAnswering',
        'roberta_qa_RoBERTa_emotion_extraction': 'RoBertaForQuestionAnswering',
        'roberta_qa_RoBERTa_for_seizureFrequency_QA': 'RoBertaForQuestionAnswering',
        'roberta_qa_Roberta': 'RoBertaForQuestionAnswering',
        'roberta_qa_Roberta_Custom_Squad_DS': 'RoBertaForQuestionAnswering',
        'roberta_qa_RuPERTa_base_finetuned_squadv1': 'RoBertaForQuestionAnswering',
        'roberta_qa_RuPERTa_base_finetuned_squadv2': 'RoBertaForQuestionAnswering',
        'roberta_qa_SAE_roberta_base_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_TestQaV1': 'RoBertaForQuestionAnswering',
        'roberta_qa_ai_club_inductions_21_nlp_roBERTa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ai_club_inductions_21_nlp_roBERTa_base_squad_v2': 'RoBertaForQuestionAnswering',
        'roberta_qa_akdeniz27_roberta_base_cuad': 'RoBertaForQuestionAnswering',
        'roberta_qa_autotrain_test2_756523213': 'RoBertaForQuestionAnswering',
        'roberta_qa_autotrain_test2_756523214': 'RoBertaForQuestionAnswering',
        'roberta_qa_avioo1_roberta_base_squad2_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_bertin_large_finetuned_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_bertserini_roberta_base': 'RoBertaForQuestionAnswering',
        'roberta_qa_cart': 'RoBertaForQuestionAnswering',
        'roberta_qa_cline_emanuals_techqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_cline_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_cline_techqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_cyberlandr_door': 'RoBertaForQuestionAnswering',
        'roberta_qa_declutr_emanuals_techqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_declutr_model_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_declutr_techqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_deepakvk_roberta_base_squad2_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilrobert_base_squadv2_328seq_128stride_test': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilroberta_base_finetuned_squad2_lwt': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilroberta_base_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilroberta_base_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilroberta_base_squad_v2': 'RoBertaForQuestionAnswering',
        'roberta_qa_distilroberta_finetuned_squadv1': 'RoBertaForQuestionAnswering',
        'roberta_qa_dpr_nq_reader_roberta_base': 'RoBertaForQuestionAnswering',
        'roberta_qa_dpr_nq_reader_roberta_base_v2': 'RoBertaForQuestionAnswering',
        'roberta_qa_fin_RoBERTa_v1_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_fpdm_hier_roberta_FT_new_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_fpdm_hier_roberta_FT_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_fpdm_roberta_FT_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_fpdm_triplet_roberta_FT_new_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_fpdm_triplet_roberta_FT_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ft_lr_cu_leolin12345': 'RoBertaForQuestionAnswering',
        'roberta_qa_huxxx657_roberta_base_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_icebert_texas_squad_is_saattrupdan': 'RoBertaForQuestionAnswering',
        'roberta_qa_legal_qa': 'RoBertaForQuestionAnswering',
        'roberta_qa_longformer_base_4096_spanish_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_marshmellow77_roberta_base_cuad': 'RoBertaForQuestionAnswering',
        'roberta_qa_movie_roberta_MITmovie_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_movie_roberta_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_mrm8488_roberta_base_bne_finetuned_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_navteca_roberta_base_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_negation_detector': 'RoBertaForQuestionAnswering',
        'roberta_qa_news_pretrain_roberta_FT_new_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_news_pretrain_roberta_FT_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_nlp_en_es_roberta_base_bne_finetuned_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_nlpunibo_roberta': 'RoBertaForQuestionAnswering',
        'roberta_qa_priv_qna': 'RoBertaForQuestionAnswering',
        'roberta_qa_prk_roberta_base_squad2_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_qaconv_roberta_large_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_qanlu': 'RoBertaForQuestionAnswering',
        'roberta_qa_quales_iberlef': 'RoBertaForQuestionAnswering',
        'roberta_qa_rahulchakwate_roberta_base_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_robertaABSA': 'RoBertaForQuestionAnswering',
        'roberta_qa_robertaBaseABSA': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_FT_new_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_FT_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_1B_1_finetuned_squadv1': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_1B_1_finetuned_squadv2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_MITmovie_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_QnA_squad2_trained': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_best_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_biomedical_clinical_es_squad2_hackathon_pln': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_biomedical_es_squad2_hackathon_pln': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_bne_squad2_hackathon_pln': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_bne_squad_2.0_es_jamarju': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_ca_cased_qa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_chaii': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_custom_QA': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_emr': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_42': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_42': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_42': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_6': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_8': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_cuad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_cuad_gam': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_deletion_squad_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_deletion_squad_15': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_10': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_10_new': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_15': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_15_new': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_5': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_scrambled_squad_5_new': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_squad_1': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_squad_2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_finetuned_squad_3': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_on_cuad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_spanish_sqac': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_spanish_squades': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_boolq_baseline': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_covid': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_covid_qa_deepset': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_distilled': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_finetuned_selqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad2_nq': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_squad_v1': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_base_tweetqa_model': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_customds_finetune': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_eda_and_parav3': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_edav3': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_fine_tuned_tweet_sentiment_extractor': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_l_squadv1.1': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_bne_squad_2.0_es_jamarju': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_cuad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_data_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_data_seed_4': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_fine_tuned_squad_es_stevemobs': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_finetuned_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_initialization_seed_0': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_squad2_covid_qa_deepset': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_squad2_hp': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_squad_v1': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_synqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_synqa_ext': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_large_tweetqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_paraphrasev3': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_qasper': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_squadv1_base': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_train_json': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_tydiqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_unaugmentedv3': 'RoBertaForQuestionAnswering',
        'roberta_qa_roberta_unaugv3': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_bert_quadruplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_bert_triplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_hier_quadruplet_0.1_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_hier_quadruplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_hier_triplet_0.1_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_hier_triplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_only_classfn_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_only_classfn_twostage_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_twostage_quadruplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_twostagequadruplet_hier_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_twostagetriplet_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_rule_based_roberta_twostagetriplet_hier_epochs_1_shard_1_squad2.0': 'RoBertaForQuestionAnswering',
        'roberta_qa_sumba_roberta_base_squad2_finetuned_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_testABSA': 'RoBertaForQuestionAnswering',
        'roberta_qa_testABSA3': 'RoBertaForQuestionAnswering',
        'roberta_qa_tinyroberta_6l_768d': 'RoBertaForQuestionAnswering',
        'roberta_qa_tinyroberta_squad2': 'RoBertaForQuestionAnswering',
        'roberta_qa_tinyroberta_squad2_step1': 'RoBertaForQuestionAnswering',
        'roberta_qa_unqover_roberta_base_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_unqover_roberta_base_squad': 'RoBertaForQuestionAnswering',
        'roberta_qa_unqover_roberta_large_newsqa': 'RoBertaForQuestionAnswering',
        'roberta_qa_ydshieh_roberta_base_squad2': 'RoBertaForQuestionAnswering',
        'xlm_roberta_base_qa_squad2': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_ADDI_CH_XLM_R': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_ADDI_DE_XLM_R': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_ADDI_FI_XLM_R': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_ADDI_IT_XLM_R': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_Part_1_XLM_Model_E1': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_Part_2_XLM_Model_E1': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_TQA': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_XLM_Turkish': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_XLMr_ENIS_QA_Is': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_XLMr_ENIS_QA_IsQ_EnA': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_afriberta_base_finetuned_tydiqa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_hindi_question_answering_23865268': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265897': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265898': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265899': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265900': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265901': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265902': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265903': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265904': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265905': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265906': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265907': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265908': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265909': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265910': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265911': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465514': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465515': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465516': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465517': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465518': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465519': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465520': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465521': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465522': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465523': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465524': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_autonlp_roberta_base_squad2_24465525': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_distill_xlm_mrc': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_farm2tran': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_hitalmqa_finetuned_squad': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_klue_mrc_roberta_base': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_mrc2reader': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_squadv2_xlm_roberta_base': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_thai_xlm_roberta_base_squad2': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_3lang': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_all': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_l_uetqa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_multi_roberta_large_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_arabic': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_chinese': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_finetune_qa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_finetuned_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_german': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_hindi': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_spanish': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_squad2_distilled': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii_small': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_vietnamese': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_base_xquad': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_ckpt_95000': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_est_qa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_arabic_qa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_fa_qa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_korquad_mask': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_qa_multilingual_finedtuned_ru_ru_AlexKay': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_squad2': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_vi_qa': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_large_xquad': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_qa_chaii': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_squad_tamil': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlm_roberta_squad_v1.1': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_base_texas_squad_da_da_saattrupdan': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_base_texas_squad_de_de_saattrupdan': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_base_texas_squad_es_es_saattrupdan': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_base_texas_squad_fr_fr_saattrupdan': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_base_texas_squad_is_is_saattrupdan': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmr_large_qa_sv_sv_m3hrdadfi': 'XlmRoBertaForQuestionAnswering',
        'xlm_roberta_qa_xlmroberta_large_tweetqa': 'XlmRoBertaForQuestionAnswering',
        'xlmroberta_qa_ukrainian': 'XlmRoBertaForQuestionAnswering',
        'xlmroberta_qa_xlmr_large': 'XlmRoBertaForQuestionAnswering',

    }
