# epmwebapi

A biblioteca **Epmwebapi** desenvolvida pela **Elipse Software**, permite a interação com os dados da sua plataforma 
**Elipse Plant Manager(EPM)**. Possibilitando flexibilidade para buscar, organizar, analisar, compartilhar e monitorar os dados de processo industrial.

Seu uso típico, mas não exclusivo, é a geração de indicadores, análises de dados, estatística e inteligência de processo voltados para sistemas industriais como Indústria Química, Petroquímica, Papel e Celulose, Siderúrgica, Energia, Saneamento, Data Centers, Prédios Inteligentes, entre outros.

Mais informações sobre o **EPM** podem ser encontradas no site https://www.elipse.com.br/produto/elipse-plant-manager/

**Requisitos:**
* EPM Webserver 3.06 (para acesso aos dados do EPM Server, não precisa estar instalado na mesma máquina da epmwebapi).
* Python 3.6 x64 ou superior

**Instalação:**

Online(Recomendado):
* Após instalar o Python, digite no prompt de comando ou terminal: *pip install epmwebapi*. O instalador se encarregará de baixar e instalar a biblioteca e suas dependências.
 
Offline: 
* Faça do download do pacote através do site da [Elipse](https://www.elipse.com.br/downloads).
* Faça a descompactação da pasta **epmwebapi** e copie para o diretório **site-packages** da instalação do Python.
* Instale as dependências: Bibliotecas Numpy, Requests e Python-dateutil.

**Exemplos:**

* [Exemplo básico](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/Quickstart.ipynb) - Exemplos de leituras e escritas de dados e anotações. 
* [Matplotlib](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/basic_use_matplotlib.ipynb) - Utilizando essa biblioteca para gerar gráficos.
* [Pandas](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/basic_use_pandas.ipynb) - Use Pandas para manipular dados tabulares.
* [Pandas e dataviz](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/pandas_and_dataviz.ipynb) - Utilizando essas bibliotecar para manipular dados e gerar visualizções gráficas.
* [Numpy](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/basic_use_numpy.ipynb) - Numpy é uma biblioteca essecial para trabalhar com cálculos de dados em matrizes.
* [Regressão por árvore de decisão](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/decision_tree_regression.ipynb) - Veja como utilizar a biblioteca Scikit-learn para fazer uma regressão. 
* [Utilizando Concorrência](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/concorrencia_historyReadAggregate.ipynb) - Usando concorrência para alta performance de consultas ao EPM Server.
* [Buscando em um webserver e escrevendo no EPM Server](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/write_from_webserver.ipynb) - Lendo dados de temperatura do Webserver do INPE e escrevendo em uma variável do EPM Server. 
* [Machine Learning](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/basic_use_machine_learning.ipynb) - Noções e exemplos de uso dessa técnica cada vez mais utilizada em dados de processo.
* [Análise de temperatura e conforto térmico](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/temp_elipse_ecc.ipynb) - Análises de dados reais de temperaturas das salas da Elipse.
* [Criando mapas](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/maps.ipynb) - Trabalhando com dados de geolocalização e mapas interativos. 
* [Acessando informações do EPM Server](https://github.com/elipsesoftware/epmwebapi/blob/master/exemplos/server_information.ipynb) - Acessando informações como versão, chave de produto, diagnósticos dos Interface Servers, etc. 











