"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WordPress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const ecsPatterns = require("@aws-cdk/aws-ecs-patterns");
const efs = require("@aws-cdk/aws-efs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
class WordPress extends cdk.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const vpc = props.vpc ?? new ec2.Vpc(this, 'Vpc', { maxAzs: 3, natGateways: 1 });
        const rdsInstance = props.rdsInstance ?? new rds.DatabaseInstance(this, 'Database', {
            engine: rds.DatabaseInstanceEngine.mysql({
                version: rds.MysqlEngineVersion.VER_8_0_21,
            }),
            vpc,
            deleteAutomatedBackups: true,
            instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.MICRO),
            allocatedStorage: 10,
        });
        const cluster = props.cluster ?? new ecs.Cluster(this, 'EcsCluster', { vpc });
        const autoScalingGroup = cluster.addCapacity('ASG', {
            instanceType: ec2.InstanceType.of(ec2.InstanceClass.T3A, ec2.InstanceSize.SMALL),
            maxCapacity: 3,
            machineImage: ecs.EcsOptimizedImage.amazonLinux2(),
        });
        autoScalingGroup.scaleOnCpuUtilization('KeepCpuHalfwayLoaded', {
            targetUtilizationPercent: 50,
        });
        const loadBalancedEcsService = new ecsPatterns.ApplicationLoadBalancedEc2Service(this, 'Service', {
            cluster,
            memoryLimitMiB: 512,
            taskImageOptions: {
                image: ecs.ContainerImage.fromRegistry('wordpress'),
                environment: {
                    WORDPRESS_DB_NAME: 'wordpress',
                },
                secrets: {
                    WORDPRESS_DB_HOST: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'host'),
                    WORDPRESS_DB_USER: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'username'),
                    WORDPRESS_DB_PASSWORD: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'password'),
                },
            },
            desiredCount: 2,
        });
        const scaling = loadBalancedEcsService.service.autoScaleTaskCount({
            maxCapacity: 6,
        });
        scaling.scaleOnCpuUtilization('CpuScaling', {
            targetUtilizationPercent: 50,
        });
        loadBalancedEcsService.targetGroup.healthCheck = {
            path: '/wp-includes/images/blank.gif',
            interval: cdk.Duration.minutes(1),
        };
        rdsInstance.connections.allowFrom(loadBalancedEcsService.cluster.connections, ec2.Port.tcp(3306));
        const fileSystem = new efs.FileSystem(this, 'FileSystem', {
            vpc,
            encrypted: true,
        });
        fileSystem.connections.allowFrom(autoScalingGroup.connections.connections, ec2.Port.tcp(2049));
        const volumeName = 'efs';
        loadBalancedEcsService.taskDefinition.addVolume({
            name: volumeName,
            efsVolumeConfiguration: {
                fileSystemId: fileSystem.fileSystemId,
            },
        });
        loadBalancedEcsService.taskDefinition.defaultContainer?.addMountPoints({
            containerPath: '/var/www/html',
            readOnly: false,
            sourceVolume: volumeName,
        });
        this.endpoint = `http://${loadBalancedEcsService.loadBalancer.loadBalancerDnsName}`;
    }
}
exports.WordPress = WordPress;
_a = JSII_RTTI_SYMBOL_1;
WordPress[_a] = { fqn: "cdk-wordpress.WordPress", version: "0.0.540" };
//# sourceMappingURL=data:application/json;base64,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