"""
    Ory APIs

    Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers.   # noqa: E501

    The version of the OpenAPI document: v0.2.0-alpha.45
    Contact: support@ory.sh
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ory_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from ory_client.exceptions import ApiAttributeError


def lazy_import():
    from ory_client.model.keto_namespaces import KetoNamespaces
    from ory_client.model.project_revision_hooks import ProjectRevisionHooks
    from ory_client.model.project_revision_identity_schemas import ProjectRevisionIdentitySchemas
    from ory_client.model.project_revision_third_party_login_providers import ProjectRevisionThirdPartyLoginProviders
    from ory_client.model.string_slice_json_format import StringSliceJSONFormat
    globals()['KetoNamespaces'] = KetoNamespaces
    globals()['ProjectRevisionHooks'] = ProjectRevisionHooks
    globals()['ProjectRevisionIdentitySchemas'] = ProjectRevisionIdentitySchemas
    globals()['ProjectRevisionThirdPartyLoginProviders'] = ProjectRevisionThirdPartyLoginProviders
    globals()['StringSliceJSONFormat'] = StringSliceJSONFormat


class NormalizedProjectRevision(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('hydra_oauth2_grant_jwt_max_ttl',): {
            'regex': {
                'pattern': r'^[0-9]+(ns|us|ms|s|m|h)$',  # noqa: E501
            },
        },
        ('hydra_ttl_access_token',): {
            'regex': {
                'pattern': r'^[0-9]+(ns|us|ms|s|m|h)$',  # noqa: E501
            },
        },
        ('hydra_ttl_auth_code',): {
            'regex': {
                'pattern': r'^[0-9]+(ns|us|ms|s|m|h)$',  # noqa: E501
            },
        },
        ('hydra_ttl_id_token',): {
            'regex': {
                'pattern': r'^[0-9]+(ns|us|ms|s|m|h)$',  # noqa: E501
            },
        },
        ('hydra_ttl_login_consent_request',): {
            'regex': {
                'pattern': r'^[0-9]+(ns|us|ms|s|m|h)$',  # noqa: E501
            },
        },
        ('hydra_ttl_refresh_token',): {
            'regex': {
                'pattern': r'^([0-9]+(ns|us|ms|s|m|h)|-1)$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'name': (str,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'hydra_oauth2_client_credentials_default_grant_allowed_scope': (bool,),  # noqa: E501
            'hydra_oauth2_grant_jwt_iat_optional': (bool,),  # noqa: E501
            'hydra_oauth2_grant_jwt_jti_optional': (bool,),  # noqa: E501
            'hydra_oauth2_grant_jwt_max_ttl': (str,),  # noqa: E501
            'hydra_oauth2_pkce_enforced': (bool,),  # noqa: E501
            'hydra_oauth2_pkce_enforced_for_public_clients': (bool,),  # noqa: E501
            'hydra_oauth2_refresh_token_hook': (str,),  # noqa: E501
            'hydra_oauth2_session_allowed_top_level_claims': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_oauth2_session_exclude_not_before_claim': (bool,),  # noqa: E501
            'hydra_oidc_dynamic_client_registration_default_scope': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_oidc_dynamic_client_registration_enabled': (bool,),  # noqa: E501
            'hydra_oidc_subject_identifiers_pairwise_salt': (str,),  # noqa: E501
            'hydra_oidc_subject_identifiers_supported_types': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_secrets_cookie': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_secrets_system': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_serve_admin_cors_allowed_origins': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_serve_admin_cors_enabled': (bool,),  # noqa: E501
            'hydra_serve_cookies_same_site_legacy_workaround': (bool,),  # noqa: E501
            'hydra_serve_cookies_same_site_mode': (str,),  # noqa: E501
            'hydra_serve_public_cors_allowed_origins': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_serve_public_cors_enabled': (bool,),  # noqa: E501
            'hydra_strategies_access_token': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'hydra_strategies_scope': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'hydra_ttl_access_token': (str,),  # noqa: E501
            'hydra_ttl_auth_code': (str,),  # noqa: E501
            'hydra_ttl_id_token': (str,),  # noqa: E501
            'hydra_ttl_login_consent_request': (str,),  # noqa: E501
            'hydra_ttl_refresh_token': (str,),  # noqa: E501
            'hydra_urls_consent': (str,),  # noqa: E501
            'hydra_urls_error': (str,),  # noqa: E501
            'hydra_urls_login': (str,),  # noqa: E501
            'hydra_urls_logout': (str,),  # noqa: E501
            'hydra_urls_post_logout_redirect': (str,),  # noqa: E501
            'hydra_urls_self_issuer': (str,),  # noqa: E501
            'hydra_webfinger_jwks_broadcast_keys': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_auth_url': (str,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_client_registration_url': (str,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_jwks_url': (str,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_supported_claims': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_supported_scope': (StringSliceJSONFormat,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_token_url': (str,),  # noqa: E501
            'hydra_webfinger_oidc_discovery_userinfo_url': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'keto_namespaces': (KetoNamespaces,),  # noqa: E501
            'keto_read_max_depth': (int, none_type,),  # noqa: E501
            'kratos_cookies_same_site': (str,),  # noqa: E501
            'kratos_courier_smtp_connection_uri': (str,),  # noqa: E501
            'kratos_courier_smtp_from_address': (str,),  # noqa: E501
            'kratos_courier_smtp_from_name': (str,),  # noqa: E501
            'kratos_courier_smtp_headers': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_invalid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_recovery_valid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_verification_invalid_email_subject': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_body_html': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_body_plaintext': (str,),  # noqa: E501
            'kratos_courier_templates_verification_valid_email_subject': (str,),  # noqa: E501
            'kratos_identity_schemas': (ProjectRevisionIdentitySchemas,),  # noqa: E501
            'kratos_secrets_cipher': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_secrets_cookie': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_secrets_default': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_selfservice_allowed_return_urls': (StringSliceJSONFormat,),  # noqa: E501
            'kratos_selfservice_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_error_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_hooks': (ProjectRevisionHooks,),  # noqa: E501
            'kratos_selfservice_flows_login_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_oidc_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_login_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_logout_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_flows_recovery_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_recovery_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_flows_registration_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_registration_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_password_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_after_profile_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_privileged_session_max_age': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_required_aal': (str,),  # noqa: E501
            'kratos_selfservice_flows_settings_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_after_default_browser_return_url': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_flows_verification_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_flows_verification_ui_url': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_config_base_url': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_config_lifespan': (str,),  # noqa: E501
            'kratos_selfservice_methods_link_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_lookup_secret_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_oidc_config_base_redirect_uri': (str,),  # noqa: E501
            'kratos_selfservice_methods_oidc_config_providers': (ProjectRevisionThirdPartyLoginProviders,),  # noqa: E501
            'kratos_selfservice_methods_oidc_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_password_config_haveibeenpwned_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_password_config_ignore_network_errors': (bool,),  # noqa: E501
            'kratos_selfservice_methods_password_config_max_breaches': (int,),  # noqa: E501
            'kratos_selfservice_methods_password_config_min_password_length': (int,),  # noqa: E501
            'kratos_selfservice_methods_password_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_profile_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_totp_config_issuer': (str,),  # noqa: E501
            'kratos_selfservice_methods_totp_enabled': (bool,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_passwordless': (bool,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_display_name': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_icon': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_id': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_config_rp_origin': (str,),  # noqa: E501
            'kratos_selfservice_methods_webauthn_enabled': (bool,),  # noqa: E501
            'kratos_session_cookie_persistent': (bool,),  # noqa: E501
            'kratos_session_cookie_same_site': (str,),  # noqa: E501
            'kratos_session_lifespan': (str,),  # noqa: E501
            'kratos_session_whoami_required_aal': (str,),  # noqa: E501
            'production': (bool,),  # noqa: E501
            'project_id': (str,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'hydra_oauth2_client_credentials_default_grant_allowed_scope': 'hydra_oauth2_client_credentials_default_grant_allowed_scope',  # noqa: E501
        'hydra_oauth2_grant_jwt_iat_optional': 'hydra_oauth2_grant_jwt_iat_optional',  # noqa: E501
        'hydra_oauth2_grant_jwt_jti_optional': 'hydra_oauth2_grant_jwt_jti_optional',  # noqa: E501
        'hydra_oauth2_grant_jwt_max_ttl': 'hydra_oauth2_grant_jwt_max_ttl',  # noqa: E501
        'hydra_oauth2_pkce_enforced': 'hydra_oauth2_pkce_enforced',  # noqa: E501
        'hydra_oauth2_pkce_enforced_for_public_clients': 'hydra_oauth2_pkce_enforced_for_public_clients',  # noqa: E501
        'hydra_oauth2_refresh_token_hook': 'hydra_oauth2_refresh_token_hook',  # noqa: E501
        'hydra_oauth2_session_allowed_top_level_claims': 'hydra_oauth2_session_allowed_top_level_claims',  # noqa: E501
        'hydra_oauth2_session_exclude_not_before_claim': 'hydra_oauth2_session_exclude_not_before_claim',  # noqa: E501
        'hydra_oidc_dynamic_client_registration_default_scope': 'hydra_oidc_dynamic_client_registration_default_scope',  # noqa: E501
        'hydra_oidc_dynamic_client_registration_enabled': 'hydra_oidc_dynamic_client_registration_enabled',  # noqa: E501
        'hydra_oidc_subject_identifiers_pairwise_salt': 'hydra_oidc_subject_identifiers_pairwise_salt',  # noqa: E501
        'hydra_oidc_subject_identifiers_supported_types': 'hydra_oidc_subject_identifiers_supported_types',  # noqa: E501
        'hydra_secrets_cookie': 'hydra_secrets_cookie',  # noqa: E501
        'hydra_secrets_system': 'hydra_secrets_system',  # noqa: E501
        'hydra_serve_admin_cors_allowed_origins': 'hydra_serve_admin_cors_allowed_origins',  # noqa: E501
        'hydra_serve_admin_cors_enabled': 'hydra_serve_admin_cors_enabled',  # noqa: E501
        'hydra_serve_cookies_same_site_legacy_workaround': 'hydra_serve_cookies_same_site_legacy_workaround',  # noqa: E501
        'hydra_serve_cookies_same_site_mode': 'hydra_serve_cookies_same_site_mode',  # noqa: E501
        'hydra_serve_public_cors_allowed_origins': 'hydra_serve_public_cors_allowed_origins',  # noqa: E501
        'hydra_serve_public_cors_enabled': 'hydra_serve_public_cors_enabled',  # noqa: E501
        'hydra_strategies_access_token': 'hydra_strategies_access_token',  # noqa: E501
        'hydra_strategies_scope': 'hydra_strategies_scope',  # noqa: E501
        'hydra_ttl_access_token': 'hydra_ttl_access_token',  # noqa: E501
        'hydra_ttl_auth_code': 'hydra_ttl_auth_code',  # noqa: E501
        'hydra_ttl_id_token': 'hydra_ttl_id_token',  # noqa: E501
        'hydra_ttl_login_consent_request': 'hydra_ttl_login_consent_request',  # noqa: E501
        'hydra_ttl_refresh_token': 'hydra_ttl_refresh_token',  # noqa: E501
        'hydra_urls_consent': 'hydra_urls_consent',  # noqa: E501
        'hydra_urls_error': 'hydra_urls_error',  # noqa: E501
        'hydra_urls_login': 'hydra_urls_login',  # noqa: E501
        'hydra_urls_logout': 'hydra_urls_logout',  # noqa: E501
        'hydra_urls_post_logout_redirect': 'hydra_urls_post_logout_redirect',  # noqa: E501
        'hydra_urls_self_issuer': 'hydra_urls_self_issuer',  # noqa: E501
        'hydra_webfinger_jwks_broadcast_keys': 'hydra_webfinger_jwks_broadcast_keys',  # noqa: E501
        'hydra_webfinger_oidc_discovery_auth_url': 'hydra_webfinger_oidc_discovery_auth_url',  # noqa: E501
        'hydra_webfinger_oidc_discovery_client_registration_url': 'hydra_webfinger_oidc_discovery_client_registration_url',  # noqa: E501
        'hydra_webfinger_oidc_discovery_jwks_url': 'hydra_webfinger_oidc_discovery_jwks_url',  # noqa: E501
        'hydra_webfinger_oidc_discovery_supported_claims': 'hydra_webfinger_oidc_discovery_supported_claims',  # noqa: E501
        'hydra_webfinger_oidc_discovery_supported_scope': 'hydra_webfinger_oidc_discovery_supported_scope',  # noqa: E501
        'hydra_webfinger_oidc_discovery_token_url': 'hydra_webfinger_oidc_discovery_token_url',  # noqa: E501
        'hydra_webfinger_oidc_discovery_userinfo_url': 'hydra_webfinger_oidc_discovery_userinfo_url',  # noqa: E501
        'id': 'id',  # noqa: E501
        'keto_namespaces': 'keto_namespaces',  # noqa: E501
        'keto_read_max_depth': 'keto_read_max_depth',  # noqa: E501
        'kratos_cookies_same_site': 'kratos_cookies_same_site',  # noqa: E501
        'kratos_courier_smtp_connection_uri': 'kratos_courier_smtp_connection_uri',  # noqa: E501
        'kratos_courier_smtp_from_address': 'kratos_courier_smtp_from_address',  # noqa: E501
        'kratos_courier_smtp_from_name': 'kratos_courier_smtp_from_name',  # noqa: E501
        'kratos_courier_smtp_headers': 'kratos_courier_smtp_headers',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_body_html': 'kratos_courier_templates_recovery_invalid_email_body_html',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_body_plaintext': 'kratos_courier_templates_recovery_invalid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_recovery_invalid_email_subject': 'kratos_courier_templates_recovery_invalid_email_subject',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_body_html': 'kratos_courier_templates_recovery_valid_email_body_html',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_body_plaintext': 'kratos_courier_templates_recovery_valid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_recovery_valid_email_subject': 'kratos_courier_templates_recovery_valid_email_subject',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_body_html': 'kratos_courier_templates_verification_invalid_email_body_html',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_body_plaintext': 'kratos_courier_templates_verification_invalid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_verification_invalid_email_subject': 'kratos_courier_templates_verification_invalid_email_subject',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_body_html': 'kratos_courier_templates_verification_valid_email_body_html',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_body_plaintext': 'kratos_courier_templates_verification_valid_email_body_plaintext',  # noqa: E501
        'kratos_courier_templates_verification_valid_email_subject': 'kratos_courier_templates_verification_valid_email_subject',  # noqa: E501
        'kratos_identity_schemas': 'kratos_identity_schemas',  # noqa: E501
        'kratos_secrets_cipher': 'kratos_secrets_cipher',  # noqa: E501
        'kratos_secrets_cookie': 'kratos_secrets_cookie',  # noqa: E501
        'kratos_secrets_default': 'kratos_secrets_default',  # noqa: E501
        'kratos_selfservice_allowed_return_urls': 'kratos_selfservice_allowed_return_urls',  # noqa: E501
        'kratos_selfservice_default_browser_return_url': 'kratos_selfservice_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_error_ui_url': 'kratos_selfservice_flows_error_ui_url',  # noqa: E501
        'kratos_selfservice_flows_hooks': 'kratos_selfservice_flows_hooks',  # noqa: E501
        'kratos_selfservice_flows_login_after_default_browser_return_url': 'kratos_selfservice_flows_login_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_oidc_default_browser_return_url': 'kratos_selfservice_flows_login_after_oidc_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_password_default_browser_return_url': 'kratos_selfservice_flows_login_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url': 'kratos_selfservice_flows_login_after_webauthn_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_login_lifespan': 'kratos_selfservice_flows_login_lifespan',  # noqa: E501
        'kratos_selfservice_flows_login_ui_url': 'kratos_selfservice_flows_login_ui_url',  # noqa: E501
        'kratos_selfservice_flows_logout_after_default_browser_return_url': 'kratos_selfservice_flows_logout_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_recovery_after_default_browser_return_url': 'kratos_selfservice_flows_recovery_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_recovery_enabled': 'kratos_selfservice_flows_recovery_enabled',  # noqa: E501
        'kratos_selfservice_flows_recovery_lifespan': 'kratos_selfservice_flows_recovery_lifespan',  # noqa: E501
        'kratos_selfservice_flows_recovery_ui_url': 'kratos_selfservice_flows_recovery_ui_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_default_browser_return_url': 'kratos_selfservice_flows_registration_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url': 'kratos_selfservice_flows_registration_after_oidc_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_password_default_browser_return_url': 'kratos_selfservice_flows_registration_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url': 'kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_registration_enabled': 'kratos_selfservice_flows_registration_enabled',  # noqa: E501
        'kratos_selfservice_flows_registration_lifespan': 'kratos_selfservice_flows_registration_lifespan',  # noqa: E501
        'kratos_selfservice_flows_registration_ui_url': 'kratos_selfservice_flows_registration_ui_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_default_browser_return_url': 'kratos_selfservice_flows_settings_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_password_default_browser_return_url': 'kratos_selfservice_flows_settings_after_password_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_after_profile_default_browser_return_url': 'kratos_selfservice_flows_settings_after_profile_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_settings_lifespan': 'kratos_selfservice_flows_settings_lifespan',  # noqa: E501
        'kratos_selfservice_flows_settings_privileged_session_max_age': 'kratos_selfservice_flows_settings_privileged_session_max_age',  # noqa: E501
        'kratos_selfservice_flows_settings_required_aal': 'kratos_selfservice_flows_settings_required_aal',  # noqa: E501
        'kratos_selfservice_flows_settings_ui_url': 'kratos_selfservice_flows_settings_ui_url',  # noqa: E501
        'kratos_selfservice_flows_verification_after_default_browser_return_url': 'kratos_selfservice_flows_verification_after_default_browser_return_url',  # noqa: E501
        'kratos_selfservice_flows_verification_enabled': 'kratos_selfservice_flows_verification_enabled',  # noqa: E501
        'kratos_selfservice_flows_verification_lifespan': 'kratos_selfservice_flows_verification_lifespan',  # noqa: E501
        'kratos_selfservice_flows_verification_ui_url': 'kratos_selfservice_flows_verification_ui_url',  # noqa: E501
        'kratos_selfservice_methods_link_config_base_url': 'kratos_selfservice_methods_link_config_base_url',  # noqa: E501
        'kratos_selfservice_methods_link_config_lifespan': 'kratos_selfservice_methods_link_config_lifespan',  # noqa: E501
        'kratos_selfservice_methods_link_enabled': 'kratos_selfservice_methods_link_enabled',  # noqa: E501
        'kratos_selfservice_methods_lookup_secret_enabled': 'kratos_selfservice_methods_lookup_secret_enabled',  # noqa: E501
        'kratos_selfservice_methods_oidc_config_base_redirect_uri': 'kratos_selfservice_methods_oidc_config_base_redirect_uri',  # noqa: E501
        'kratos_selfservice_methods_oidc_config_providers': 'kratos_selfservice_methods_oidc_config_providers',  # noqa: E501
        'kratos_selfservice_methods_oidc_enabled': 'kratos_selfservice_methods_oidc_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_haveibeenpwned_enabled': 'kratos_selfservice_methods_password_config_haveibeenpwned_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled': 'kratos_selfservice_methods_password_config_identifier_similarity_check_enabled',  # noqa: E501
        'kratos_selfservice_methods_password_config_ignore_network_errors': 'kratos_selfservice_methods_password_config_ignore_network_errors',  # noqa: E501
        'kratos_selfservice_methods_password_config_max_breaches': 'kratos_selfservice_methods_password_config_max_breaches',  # noqa: E501
        'kratos_selfservice_methods_password_config_min_password_length': 'kratos_selfservice_methods_password_config_min_password_length',  # noqa: E501
        'kratos_selfservice_methods_password_enabled': 'kratos_selfservice_methods_password_enabled',  # noqa: E501
        'kratos_selfservice_methods_profile_enabled': 'kratos_selfservice_methods_profile_enabled',  # noqa: E501
        'kratos_selfservice_methods_totp_config_issuer': 'kratos_selfservice_methods_totp_config_issuer',  # noqa: E501
        'kratos_selfservice_methods_totp_enabled': 'kratos_selfservice_methods_totp_enabled',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_passwordless': 'kratos_selfservice_methods_webauthn_config_passwordless',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_display_name': 'kratos_selfservice_methods_webauthn_config_rp_display_name',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_icon': 'kratos_selfservice_methods_webauthn_config_rp_icon',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_id': 'kratos_selfservice_methods_webauthn_config_rp_id',  # noqa: E501
        'kratos_selfservice_methods_webauthn_config_rp_origin': 'kratos_selfservice_methods_webauthn_config_rp_origin',  # noqa: E501
        'kratos_selfservice_methods_webauthn_enabled': 'kratos_selfservice_methods_webauthn_enabled',  # noqa: E501
        'kratos_session_cookie_persistent': 'kratos_session_cookie_persistent',  # noqa: E501
        'kratos_session_cookie_same_site': 'kratos_session_cookie_same_site',  # noqa: E501
        'kratos_session_lifespan': 'kratos_session_lifespan',  # noqa: E501
        'kratos_session_whoami_required_aal': 'kratos_session_whoami_required_aal',  # noqa: E501
        'production': 'production',  # noqa: E501
        'project_id': 'project_id',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
    }

    read_only_vars = {
        'created_at',  # noqa: E501
        'id',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, *args, **kwargs):  # noqa: E501
        """NormalizedProjectRevision - a model defined in OpenAPI

        Args:
            name (str): The project's name.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            hydra_oauth2_client_credentials_default_grant_allowed_scope (bool): Automatically grant authorized OAuth2 Scope in OAuth2 Client Credentials Flow.  Each OAuth2 Client is allowed to request a predefined OAuth2 Scope (for example `read write`). If this option is enabled, the full scope is automatically granted when performing the OAuth2 Client Credentials flow.  If disabled, the OAuth2 Client has to request the scope in the OAuth2 request by providing the `scope` query parameter.  Setting this option to true is common if you need compatibility with MITREid.  This governs the \"oauth2.client_credentials.default_grant_allowed_scope\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_iat_optional (bool): Configures if the issued at (`iat`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `iat` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.iat_optional\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_jti_optional (bool): Configures if the JSON Web Token ID (`jti`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `jti` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.jti_optional\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_max_ttl (str): Configures what the maximum age of a JWT assertion used in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523) can be.  This feature uses the `exp` claim and `iat` claim to calculate assertion age. Assertions exceeding the max age will be denied.  Useful as a safety measure and recommended to keep below 720h.  This governs the \"oauth2.grant.jwt.max_ttl\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_oauth2_pkce_enforced (bool): Configures whether PKCE should be enforced for all OAuth2 Clients.  This governs the \"oauth2.pkce.enforced\" setting.. [optional]  # noqa: E501
            hydra_oauth2_pkce_enforced_for_public_clients (bool): Configures whether PKCE should be enforced for OAuth2 Clients without a client secret (public clients).  This governs the \"oauth2.pkce.enforced_for_public_clients\" setting.. [optional]  # noqa: E501
            hydra_oauth2_refresh_token_hook (str): Sets the Refresh Token Hook Endpoint. If set this endpoint will be called during the OAuth2 Token Refresh grant update the OAuth2 Access Token claims.  This governs the \"oauth2.refresh_token_hook\" setting.. [optional]  # noqa: E501
            hydra_oauth2_session_allowed_top_level_claims (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_oauth2_session_exclude_not_before_claim (bool): Set to true if you want to exclude claim `nbf (not before)` part of access token.  This governs the \"oauth2.session.exclude_not_before_claim\" setting.. [optional]  # noqa: E501
            hydra_oidc_dynamic_client_registration_default_scope (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_oidc_dynamic_client_registration_enabled (bool): Configures OpenID Connect Dynamic Client Registration.  This governs the \"oidc.dynamic_client_registration.enabled\" setting.. [optional]  # noqa: E501
            hydra_oidc_subject_identifiers_pairwise_salt (str): Configures OpenID Connect Discovery and overwrites the pairwise algorithm  This governs the \"oidc.subject_identifiers.pairwise_salt\" setting.. [optional]  # noqa: E501
            hydra_oidc_subject_identifiers_supported_types (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_secrets_system (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_admin_cors_allowed_origins (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_admin_cors_enabled (bool): Configures the Ory Hydra CORS Settings  This governs the \"serve.admin.cors.enabled\" setting.. [optional]  # noqa: E501
            hydra_serve_cookies_same_site_legacy_workaround (bool): Configures the Ory Hydra Cookie Same Site Legacy Workaround  This governs the \"serve.cookies.same_site_legacy_workaround\" setting.. [optional]  # noqa: E501
            hydra_serve_cookies_same_site_mode (str): Configures the Ory Hydra Cookie Same Site Mode  This governs the \"serve.cookies.same_site_mode\" setting.. [optional]  # noqa: E501
            hydra_serve_public_cors_allowed_origins (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_public_cors_enabled (bool): Configures the Ory Hydra CORS Settings  This governs the \"serve.public.cors.enabled\" setting.. [optional]  # noqa: E501
            hydra_strategies_access_token (bool, date, datetime, dict, float, int, list, str, none_type): Defines access token type. jwt is a bad idea, see https://www.ory.sh/docs/hydra/advanced#json-web-tokens  This governs the \"strategies.access_token\" setting.. [optional]  # noqa: E501
            hydra_strategies_scope (bool, date, datetime, dict, float, int, list, str, none_type): Defines how scopes are matched. For more details have a look at https://github.com/ory/fosite#scopes  This governs the \"strategies.scope\" setting.. [optional]  # noqa: E501
            hydra_ttl_access_token (str): This governs the \"ttl.access_token\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_auth_code (str): Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.auth_code\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_ttl_id_token (str): This governs the \"ttl.id_token\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_login_consent_request (str): Configures how long a user login and consent flow may take.  This governs the \"ttl.login_consent_request\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_refresh_token (str): Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.refresh_token\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_urls_consent (str): Sets the OAuth2 Consent Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.consent\" setting.. [optional]  # noqa: E501
            hydra_urls_error (str): Sets the OAuth2 Error URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.error\" setting.. [optional]  # noqa: E501
            hydra_urls_login (str): Sets the OAuth2 Login Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.login\" setting.. [optional]  # noqa: E501
            hydra_urls_logout (str): Sets the logout endpoint.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.logout\" setting.. [optional]  # noqa: E501
            hydra_urls_post_logout_redirect (str): When an OAuth2-related user agent requests to log out, they will be redirected to this url afterwards per default.  Defaults to Ory Cloud's Managed UI in development and your application in production mode when a custom domain is connected.  This governs the \"urls.post_logout_redirect\" setting.. [optional]  # noqa: E501
            hydra_urls_self_issuer (str): This value will be used as the issuer in access and ID tokens. It must be specified and using HTTPS protocol, unless the development mode is enabled.  In Ory Cloud it will be very rare that you want to modify this value. If left empty, it will default to the correct value for Ory Cloud.  This governs the \"urls.self.issuer\" setting.. [optional]  # noqa: E501
            hydra_webfinger_jwks_broadcast_keys (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_auth_url (str): Configures OpenID Connect Discovery and overwrites the OAuth2 Authorization URL.  This governs the \"webfinger.oidc.discovery.auth_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_client_registration_url (str): Configures OpenID Connect Discovery and overwrites the OpenID Connect Dynamic Client Registration Endpoint.  This governs the \"webfinger.oidc.discovery.client_registration_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_jwks_url (str): Configures OpenID Connect Discovery and overwrites the JWKS URL.  This governs the \"webfinger.oidc.discovery.jwks_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_supported_claims (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_supported_scope (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_token_url (str): Configures OpenID Connect Discovery and overwrites the OAuth2 Token URL.  This governs the \"webfinger.oidc.discovery.token_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_userinfo_url (str): Configures OpenID Connect Discovery and overwrites userinfo endpoint to be advertised at the OpenID Connect Discovery endpoint /.well-known/openid-configuration. Defaults to Ory Hydra's userinfo endpoint at /userinfo. Set this value if you want to handle this endpoint yourself.  This governs the \"webfinger.oidc.discovery.userinfo_url\" setting.. [optional]  # noqa: E501
            id (str): The revision ID.. [optional]  # noqa: E501
            keto_namespaces (KetoNamespaces): [optional]  # noqa: E501
            keto_read_max_depth (int, none_type): [optional]  # noqa: E501
            kratos_cookies_same_site (str): Configures the Ory Kratos Cookie SameSite Attribute  This governs the \"cookies.same_site\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_connection_uri (str): Configures the Ory Kratos SMTP Connection URI  This governs the \"courier.smtp.connection_uri\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_address (str): Configures the Ory Kratos SMTP From Address  This governs the \"courier.smtp.from_address\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_name (str): Configures the Ory Kratos SMTP From Name  This governs the \"courier.smtp.from_name\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_html (str): Configures the Ory Kratos Invalid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_subject (str): Configures the Ory Kratos Invalid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_html (str): Configures the Ory Kratos Valid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_subject (str): Configures the Ory Kratos Valid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_html (str): Configures the Ory Kratos Invalid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_subject (str): Configures the Ory Kratos Invalid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.invalid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_html (str): Configures the Ory Kratos Valid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_subject (str): Configures the Ory Kratos Valid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_identity_schemas (ProjectRevisionIdentitySchemas): [optional]  # noqa: E501
            kratos_secrets_cipher (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_default (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_allowed_return_urls (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_default_browser_return_url (str): Configures the Ory Kratos Default Return URL  This governs the \"selfservice.allowed_return_urls\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_error_ui_url (str): Configures the Ory Kratos Error UI URL  This governs the \"selfservice.flows.error.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_hooks (ProjectRevisionHooks): [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_default_browser_return_url (str): Configures the Ory Kratos Login Default Return URL  This governs the \"selfservice.flows.login.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Login After OIDC Default Return URL  This governs the \"selfservice.flows.login.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_password_default_browser_return_url (str): Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.login.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Login After WebAuthn Default Return URL  This governs the \"selfservice.flows.login.after.webauthn.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_lifespan (str): Configures the Ory Kratos Login Lifespan  This governs the \"selfservice.flows.login.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_ui_url (str): Configures the Ory Kratos Login UI URL  This governs the \"selfservice.flows.login.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_logout_after_default_browser_return_url (str): Configures the Ory Kratos Logout Default Return URL  This governs the \"selfservice.flows.logout.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_after_default_browser_return_url (str): Configures the Ory Kratos Recovery Default Return URL  This governs the \"selfservice.flows.recovery.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_enabled (bool): Configures the Ory Kratos Recovery Enabled Setting  This governs the \"selfservice.flows.recovery.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_lifespan (str): Configures the Ory Kratos Recovery Lifespan  This governs the \"selfservice.flows.recovery.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_ui_url (str): Configures the Ory Kratos Recovery UI URL  This governs the \"selfservice.flows.recovery.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_default_browser_return_url (str): Configures the Ory Kratos Registration Default Return URL  This governs the \"selfservice.flows.registration.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Registration After OIDC Default Return URL  This governs the \"selfservice.flows.registration.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_password_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_enabled (bool): Configures the Whether Ory Kratos Registration is Enabled  This governs the \"selfservice.flows.registration.enabled\" setting.0. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_lifespan (str): Configures the Ory Kratos Registration Lifespan  This governs the \"selfservice.flows.registration.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_ui_url (str): Configures the Ory Kratos Registration UI URL  This governs the \"selfservice.flows.registration.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL  This governs the \"selfservice.flows.settings.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_password_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Passwords  This governs the \"selfservice.flows.settings.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_profile_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Profiles  This governs the \"selfservice.flows.settings.after.profile.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_lifespan (str): Configures the Ory Kratos Settings Lifespan  This governs the \"selfservice.flows.settings.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_privileged_session_max_age (str): Configures the Ory Kratos Settings Privileged Session Max Age  This governs the \"selfservice.flows.settings.privileged_session_max_age\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_required_aal (str): Configures the Ory Kratos Settings Required AAL  This governs the \"selfservice.flows.settings.required_aal\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_ui_url (str): Configures the Ory Kratos Settings UI URL  This governs the \"selfservice.flows.settings.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_after_default_browser_return_url (str): Configures the Ory Kratos Verification Default Return URL  This governs the \"selfservice.flows.verification.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_enabled (bool): Configures the Ory Kratos Verification Enabled Setting  This governs the \"selfservice.flows.verification.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_lifespan (str): Configures the Ory Kratos Verification Lifespan  This governs the \"selfservice.flows.verification.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_ui_url (str): Configures the Ory Kratos Verification UI URL  This governs the \"selfservice.flows.verification.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_base_url (str): Configures the Base URL which Recovery, Verification, and Login Links Point to  It is recommended to leave this value empty. It will be appropriately configured to the best matching domain (e.g. when using custom domains) automatically.  This governs the \"selfservice.methods.link.config.base_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_lifespan (str): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.config.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_enabled (bool): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_lookup_secret_enabled (bool): Configures whether Ory Kratos TOTP Lookup Secret is enabled  This governs the \"selfservice.methods.lookup_secret.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_base_redirect_uri (str): Configures the Ory Kratos Third Party / OpenID Connect base redirect URI  This governs the \"selfservice.methods.oidc.config.base_redirect_uri\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_providers (ProjectRevisionThirdPartyLoginProviders): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_enabled (bool): Configures whether Ory Kratos Third Party / OpenID Connect Login is enabled  This governs the \"selfservice.methods.oidc.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_haveibeenpwned_enabled (bool): Configures whether Ory Kratos Password HIBP Checks is enabled  This governs the \"selfservice.methods.password.config.haveibeenpwned_enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_identifier_similarity_check_enabled (bool): Configures whether Ory Kratos Password should disable the similarity policy.  This governs the \"selfservice.methods.password.config.identifier_similarity_check_enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_ignore_network_errors (bool): Configures whether Ory Kratos Password Should ignore HIBPWND Network Errors  This governs the \"selfservice.methods.password.config.ignore_network_errors\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_max_breaches (int): Configures Ory Kratos Password Max Breaches Detection  This governs the \"selfservice.methods.password.config.max_breaches\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_min_password_length (int): Configures the minimum length of passwords.  This governs the \"selfservice.methods.password.config.min_password_length\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_enabled (bool): Configures whether Ory Kratos Password Method is enabled  This governs the \"selfservice.methods.password.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_profile_enabled (bool): Configures whether Ory Kratos Profile Method is enabled  This governs the \"selfservice.methods.profile.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_config_issuer (str): Configures Ory Kratos TOTP Issuer  This governs the \"selfservice.methods.totp.config.issuer\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_enabled (bool): Configures whether Ory Kratos TOTP Method is enabled  This governs the \"selfservice.methods.totp.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_passwordless (bool): Configures whether Ory Kratos Webauthn is used for passwordless flows  This governs the \"selfservice.methods.webauthn.config.passwordless\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_display_name (str): Configures the Ory Kratos Webauthn RP Display Name  This governs the \"selfservice.methods.webauthn.config.rp.display_name\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_icon (str): Configures the Ory Kratos Webauthn RP Icon  This governs the \"selfservice.methods.webauthn.config.rp.icon\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_id (str): Configures the Ory Kratos Webauthn RP ID  This governs the \"selfservice.methods.webauthn.config.rp.id\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_origin (str): Configures the Ory Kratos Webauthn RP Origin  This governs the \"selfservice.methods.webauthn.config.rp.origin\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_enabled (bool): Configures whether Ory Kratos Webauthn is enabled  This governs the \"selfservice.methods.webauthn.enabled\" setting.. [optional]  # noqa: E501
            kratos_session_cookie_persistent (bool): Configures the Ory Kratos Session Cookie Persistent Attribute  This governs the \"session.cookie.persistent\" setting.. [optional]  # noqa: E501
            kratos_session_cookie_same_site (str): Configures the Ory Kratos Session Cookie SameSite Attribute  This governs the \"session.cookie.same_site\" setting.. [optional]  # noqa: E501
            kratos_session_lifespan (str): Configures the Ory Kratos Session Lifespan  This governs the \"session.lifespan\" setting.. [optional]  # noqa: E501
            kratos_session_whoami_required_aal (str): Configures the Ory Kratos Session Whoami AAL requirement  This governs the \"session.whoami.required_aal\" setting.. [optional]  # noqa: E501
            production (bool): Whether this project is in production mode or not.  In development mode, a low-security profile is used making it easier to develop against your, for example, local environment.. [optional]  # noqa: E501
            project_id (str): The Revision's Project ID. [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, *args, **kwargs):  # noqa: E501
        """NormalizedProjectRevision - a model defined in OpenAPI

        Args:
            name (str): The project's name.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created_at (datetime): The Project's Revision Creation Date. [optional]  # noqa: E501
            hydra_oauth2_client_credentials_default_grant_allowed_scope (bool): Automatically grant authorized OAuth2 Scope in OAuth2 Client Credentials Flow.  Each OAuth2 Client is allowed to request a predefined OAuth2 Scope (for example `read write`). If this option is enabled, the full scope is automatically granted when performing the OAuth2 Client Credentials flow.  If disabled, the OAuth2 Client has to request the scope in the OAuth2 request by providing the `scope` query parameter.  Setting this option to true is common if you need compatibility with MITREid.  This governs the \"oauth2.client_credentials.default_grant_allowed_scope\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_iat_optional (bool): Configures if the issued at (`iat`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `iat` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.iat_optional\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_jti_optional (bool): Configures if the JSON Web Token ID (`jti`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `jti` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.jti_optional\" setting.. [optional]  # noqa: E501
            hydra_oauth2_grant_jwt_max_ttl (str): Configures what the maximum age of a JWT assertion used in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523) can be.  This feature uses the `exp` claim and `iat` claim to calculate assertion age. Assertions exceeding the max age will be denied.  Useful as a safety measure and recommended to keep below 720h.  This governs the \"oauth2.grant.jwt.max_ttl\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_oauth2_pkce_enforced (bool): Configures whether PKCE should be enforced for all OAuth2 Clients.  This governs the \"oauth2.pkce.enforced\" setting.. [optional]  # noqa: E501
            hydra_oauth2_pkce_enforced_for_public_clients (bool): Configures whether PKCE should be enforced for OAuth2 Clients without a client secret (public clients).  This governs the \"oauth2.pkce.enforced_for_public_clients\" setting.. [optional]  # noqa: E501
            hydra_oauth2_refresh_token_hook (str): Sets the Refresh Token Hook Endpoint. If set this endpoint will be called during the OAuth2 Token Refresh grant update the OAuth2 Access Token claims.  This governs the \"oauth2.refresh_token_hook\" setting.. [optional]  # noqa: E501
            hydra_oauth2_session_allowed_top_level_claims (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_oauth2_session_exclude_not_before_claim (bool): Set to true if you want to exclude claim `nbf (not before)` part of access token.  This governs the \"oauth2.session.exclude_not_before_claim\" setting.. [optional]  # noqa: E501
            hydra_oidc_dynamic_client_registration_default_scope (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_oidc_dynamic_client_registration_enabled (bool): Configures OpenID Connect Dynamic Client Registration.  This governs the \"oidc.dynamic_client_registration.enabled\" setting.. [optional]  # noqa: E501
            hydra_oidc_subject_identifiers_pairwise_salt (str): Configures OpenID Connect Discovery and overwrites the pairwise algorithm  This governs the \"oidc.subject_identifiers.pairwise_salt\" setting.. [optional]  # noqa: E501
            hydra_oidc_subject_identifiers_supported_types (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_secrets_system (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_admin_cors_allowed_origins (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_admin_cors_enabled (bool): Configures the Ory Hydra CORS Settings  This governs the \"serve.admin.cors.enabled\" setting.. [optional]  # noqa: E501
            hydra_serve_cookies_same_site_legacy_workaround (bool): Configures the Ory Hydra Cookie Same Site Legacy Workaround  This governs the \"serve.cookies.same_site_legacy_workaround\" setting.. [optional]  # noqa: E501
            hydra_serve_cookies_same_site_mode (str): Configures the Ory Hydra Cookie Same Site Mode  This governs the \"serve.cookies.same_site_mode\" setting.. [optional]  # noqa: E501
            hydra_serve_public_cors_allowed_origins (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_serve_public_cors_enabled (bool): Configures the Ory Hydra CORS Settings  This governs the \"serve.public.cors.enabled\" setting.. [optional]  # noqa: E501
            hydra_strategies_access_token (bool, date, datetime, dict, float, int, list, str, none_type): Defines access token type. jwt is a bad idea, see https://www.ory.sh/docs/hydra/advanced#json-web-tokens  This governs the \"strategies.access_token\" setting.. [optional]  # noqa: E501
            hydra_strategies_scope (bool, date, datetime, dict, float, int, list, str, none_type): Defines how scopes are matched. For more details have a look at https://github.com/ory/fosite#scopes  This governs the \"strategies.scope\" setting.. [optional]  # noqa: E501
            hydra_ttl_access_token (str): This governs the \"ttl.access_token\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_auth_code (str): Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.auth_code\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_ttl_id_token (str): This governs the \"ttl.id_token\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_login_consent_request (str): Configures how long a user login and consent flow may take.  This governs the \"ttl.login_consent_request\" setting.. [optional] if omitted the server will use the default value of "30m"  # noqa: E501
            hydra_ttl_refresh_token (str): Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.refresh_token\" setting.. [optional] if omitted the server will use the default value of "720h"  # noqa: E501
            hydra_urls_consent (str): Sets the OAuth2 Consent Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.consent\" setting.. [optional]  # noqa: E501
            hydra_urls_error (str): Sets the OAuth2 Error URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.error\" setting.. [optional]  # noqa: E501
            hydra_urls_login (str): Sets the OAuth2 Login Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.login\" setting.. [optional]  # noqa: E501
            hydra_urls_logout (str): Sets the logout endpoint.  Defaults to Ory Cloud's Managed UI if left empty.  This governs the \"urls.logout\" setting.. [optional]  # noqa: E501
            hydra_urls_post_logout_redirect (str): When an OAuth2-related user agent requests to log out, they will be redirected to this url afterwards per default.  Defaults to Ory Cloud's Managed UI in development and your application in production mode when a custom domain is connected.  This governs the \"urls.post_logout_redirect\" setting.. [optional]  # noqa: E501
            hydra_urls_self_issuer (str): This value will be used as the issuer in access and ID tokens. It must be specified and using HTTPS protocol, unless the development mode is enabled.  In Ory Cloud it will be very rare that you want to modify this value. If left empty, it will default to the correct value for Ory Cloud.  This governs the \"urls.self.issuer\" setting.. [optional]  # noqa: E501
            hydra_webfinger_jwks_broadcast_keys (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_auth_url (str): Configures OpenID Connect Discovery and overwrites the OAuth2 Authorization URL.  This governs the \"webfinger.oidc.discovery.auth_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_client_registration_url (str): Configures OpenID Connect Discovery and overwrites the OpenID Connect Dynamic Client Registration Endpoint.  This governs the \"webfinger.oidc.discovery.client_registration_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_jwks_url (str): Configures OpenID Connect Discovery and overwrites the JWKS URL.  This governs the \"webfinger.oidc.discovery.jwks_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_supported_claims (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_supported_scope (StringSliceJSONFormat): [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_token_url (str): Configures OpenID Connect Discovery and overwrites the OAuth2 Token URL.  This governs the \"webfinger.oidc.discovery.token_url\" setting.. [optional]  # noqa: E501
            hydra_webfinger_oidc_discovery_userinfo_url (str): Configures OpenID Connect Discovery and overwrites userinfo endpoint to be advertised at the OpenID Connect Discovery endpoint /.well-known/openid-configuration. Defaults to Ory Hydra's userinfo endpoint at /userinfo. Set this value if you want to handle this endpoint yourself.  This governs the \"webfinger.oidc.discovery.userinfo_url\" setting.. [optional]  # noqa: E501
            id (str): The revision ID.. [optional]  # noqa: E501
            keto_namespaces (KetoNamespaces): [optional]  # noqa: E501
            keto_read_max_depth (int, none_type): [optional]  # noqa: E501
            kratos_cookies_same_site (str): Configures the Ory Kratos Cookie SameSite Attribute  This governs the \"cookies.same_site\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_connection_uri (str): Configures the Ory Kratos SMTP Connection URI  This governs the \"courier.smtp.connection_uri\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_address (str): Configures the Ory Kratos SMTP From Address  This governs the \"courier.smtp.from_address\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_from_name (str): Configures the Ory Kratos SMTP From Name  This governs the \"courier.smtp.from_name\" setting.. [optional]  # noqa: E501
            kratos_courier_smtp_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_html (str): Configures the Ory Kratos Invalid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_invalid_email_subject (str): Configures the Ory Kratos Invalid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_html (str): Configures the Ory Kratos Valid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_recovery_valid_email_subject (str): Configures the Ory Kratos Valid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_html (str): Configures the Ory Kratos Invalid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_body_plaintext (str): Configures the Ory Kratos Invalid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_invalid_email_subject (str): Configures the Ory Kratos Invalid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.invalid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_html (str): Configures the Ory Kratos Valid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.valid.email.body.html\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_body_plaintext (str): Configures the Ory Kratos Valid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.. [optional]  # noqa: E501
            kratos_courier_templates_verification_valid_email_subject (str): Configures the Ory Kratos Valid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.valid.email.subject\" setting.. [optional]  # noqa: E501
            kratos_identity_schemas (ProjectRevisionIdentitySchemas): [optional]  # noqa: E501
            kratos_secrets_cipher (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_cookie (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_secrets_default (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_allowed_return_urls (StringSliceJSONFormat): [optional]  # noqa: E501
            kratos_selfservice_default_browser_return_url (str): Configures the Ory Kratos Default Return URL  This governs the \"selfservice.allowed_return_urls\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_error_ui_url (str): Configures the Ory Kratos Error UI URL  This governs the \"selfservice.flows.error.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_hooks (ProjectRevisionHooks): [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_default_browser_return_url (str): Configures the Ory Kratos Login Default Return URL  This governs the \"selfservice.flows.login.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Login After OIDC Default Return URL  This governs the \"selfservice.flows.login.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_password_default_browser_return_url (str): Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.login.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Login After WebAuthn Default Return URL  This governs the \"selfservice.flows.login.after.webauthn.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_lifespan (str): Configures the Ory Kratos Login Lifespan  This governs the \"selfservice.flows.login.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_login_ui_url (str): Configures the Ory Kratos Login UI URL  This governs the \"selfservice.flows.login.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_logout_after_default_browser_return_url (str): Configures the Ory Kratos Logout Default Return URL  This governs the \"selfservice.flows.logout.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_after_default_browser_return_url (str): Configures the Ory Kratos Recovery Default Return URL  This governs the \"selfservice.flows.recovery.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_enabled (bool): Configures the Ory Kratos Recovery Enabled Setting  This governs the \"selfservice.flows.recovery.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_lifespan (str): Configures the Ory Kratos Recovery Lifespan  This governs the \"selfservice.flows.recovery.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_recovery_ui_url (str): Configures the Ory Kratos Recovery UI URL  This governs the \"selfservice.flows.recovery.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_default_browser_return_url (str): Configures the Ory Kratos Registration Default Return URL  This governs the \"selfservice.flows.registration.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_oidc_default_browser_return_url (str): Configures the Ory Kratos Registration After OIDC Default Return URL  This governs the \"selfservice.flows.registration.after.oidc.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_password_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url (str): Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_enabled (bool): Configures the Whether Ory Kratos Registration is Enabled  This governs the \"selfservice.flows.registration.enabled\" setting.0. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_lifespan (str): Configures the Ory Kratos Registration Lifespan  This governs the \"selfservice.flows.registration.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_registration_ui_url (str): Configures the Ory Kratos Registration UI URL  This governs the \"selfservice.flows.registration.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL  This governs the \"selfservice.flows.settings.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_password_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Passwords  This governs the \"selfservice.flows.settings.after.password.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_after_profile_default_browser_return_url (str): Configures the Ory Kratos Settings Default Return URL After Updating Profiles  This governs the \"selfservice.flows.settings.after.profile.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_lifespan (str): Configures the Ory Kratos Settings Lifespan  This governs the \"selfservice.flows.settings.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_privileged_session_max_age (str): Configures the Ory Kratos Settings Privileged Session Max Age  This governs the \"selfservice.flows.settings.privileged_session_max_age\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_required_aal (str): Configures the Ory Kratos Settings Required AAL  This governs the \"selfservice.flows.settings.required_aal\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_settings_ui_url (str): Configures the Ory Kratos Settings UI URL  This governs the \"selfservice.flows.settings.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_after_default_browser_return_url (str): Configures the Ory Kratos Verification Default Return URL  This governs the \"selfservice.flows.verification.after.default_browser_return_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_enabled (bool): Configures the Ory Kratos Verification Enabled Setting  This governs the \"selfservice.flows.verification.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_lifespan (str): Configures the Ory Kratos Verification Lifespan  This governs the \"selfservice.flows.verification.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_flows_verification_ui_url (str): Configures the Ory Kratos Verification UI URL  This governs the \"selfservice.flows.verification.ui_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_base_url (str): Configures the Base URL which Recovery, Verification, and Login Links Point to  It is recommended to leave this value empty. It will be appropriately configured to the best matching domain (e.g. when using custom domains) automatically.  This governs the \"selfservice.methods.link.config.base_url\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_config_lifespan (str): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.config.lifespan\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_link_enabled (bool): Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_lookup_secret_enabled (bool): Configures whether Ory Kratos TOTP Lookup Secret is enabled  This governs the \"selfservice.methods.lookup_secret.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_base_redirect_uri (str): Configures the Ory Kratos Third Party / OpenID Connect base redirect URI  This governs the \"selfservice.methods.oidc.config.base_redirect_uri\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_config_providers (ProjectRevisionThirdPartyLoginProviders): [optional]  # noqa: E501
            kratos_selfservice_methods_oidc_enabled (bool): Configures whether Ory Kratos Third Party / OpenID Connect Login is enabled  This governs the \"selfservice.methods.oidc.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_haveibeenpwned_enabled (bool): Configures whether Ory Kratos Password HIBP Checks is enabled  This governs the \"selfservice.methods.password.config.haveibeenpwned_enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_identifier_similarity_check_enabled (bool): Configures whether Ory Kratos Password should disable the similarity policy.  This governs the \"selfservice.methods.password.config.identifier_similarity_check_enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_ignore_network_errors (bool): Configures whether Ory Kratos Password Should ignore HIBPWND Network Errors  This governs the \"selfservice.methods.password.config.ignore_network_errors\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_max_breaches (int): Configures Ory Kratos Password Max Breaches Detection  This governs the \"selfservice.methods.password.config.max_breaches\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_config_min_password_length (int): Configures the minimum length of passwords.  This governs the \"selfservice.methods.password.config.min_password_length\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_password_enabled (bool): Configures whether Ory Kratos Password Method is enabled  This governs the \"selfservice.methods.password.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_profile_enabled (bool): Configures whether Ory Kratos Profile Method is enabled  This governs the \"selfservice.methods.profile.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_config_issuer (str): Configures Ory Kratos TOTP Issuer  This governs the \"selfservice.methods.totp.config.issuer\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_totp_enabled (bool): Configures whether Ory Kratos TOTP Method is enabled  This governs the \"selfservice.methods.totp.enabled\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_passwordless (bool): Configures whether Ory Kratos Webauthn is used for passwordless flows  This governs the \"selfservice.methods.webauthn.config.passwordless\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_display_name (str): Configures the Ory Kratos Webauthn RP Display Name  This governs the \"selfservice.methods.webauthn.config.rp.display_name\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_icon (str): Configures the Ory Kratos Webauthn RP Icon  This governs the \"selfservice.methods.webauthn.config.rp.icon\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_id (str): Configures the Ory Kratos Webauthn RP ID  This governs the \"selfservice.methods.webauthn.config.rp.id\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_config_rp_origin (str): Configures the Ory Kratos Webauthn RP Origin  This governs the \"selfservice.methods.webauthn.config.rp.origin\" setting.. [optional]  # noqa: E501
            kratos_selfservice_methods_webauthn_enabled (bool): Configures whether Ory Kratos Webauthn is enabled  This governs the \"selfservice.methods.webauthn.enabled\" setting.. [optional]  # noqa: E501
            kratos_session_cookie_persistent (bool): Configures the Ory Kratos Session Cookie Persistent Attribute  This governs the \"session.cookie.persistent\" setting.. [optional]  # noqa: E501
            kratos_session_cookie_same_site (str): Configures the Ory Kratos Session Cookie SameSite Attribute  This governs the \"session.cookie.same_site\" setting.. [optional]  # noqa: E501
            kratos_session_lifespan (str): Configures the Ory Kratos Session Lifespan  This governs the \"session.lifespan\" setting.. [optional]  # noqa: E501
            kratos_session_whoami_required_aal (str): Configures the Ory Kratos Session Whoami AAL requirement  This governs the \"session.whoami.required_aal\" setting.. [optional]  # noqa: E501
            production (bool): Whether this project is in production mode or not.  In development mode, a low-security profile is used making it easier to develop against your, for example, local environment.. [optional]  # noqa: E501
            project_id (str): The Revision's Project ID. [optional]  # noqa: E501
            updated_at (datetime): Last Time Project's Revision was Updated. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
