# ory-client
Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed
with a valid Personal Access Token. Public APIs are mostly used in browsers.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.2.0-alpha.45
- Package version: v0.2.0-alpha.45
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ory_client
from pprint import pprint
from ory_client.api import admin_api
from ory_client.model.accept_consent_request import AcceptConsentRequest
from ory_client.model.accept_login_request import AcceptLoginRequest
from ory_client.model.completed_request import CompletedRequest
from ory_client.model.consent_request import ConsentRequest
from ory_client.model.flush_inactive_o_auth2_tokens_request import FlushInactiveOAuth2TokensRequest
from ory_client.model.generic_error import GenericError
from ory_client.model.json_web_key import JSONWebKey
from ory_client.model.json_web_key_set import JSONWebKeySet
from ory_client.model.json_error import JsonError
from ory_client.model.json_web_key_set_generator_request import JsonWebKeySetGeneratorRequest
from ory_client.model.login_request import LoginRequest
from ory_client.model.logout_request import LogoutRequest
from ory_client.model.o_auth2_client import OAuth2Client
from ory_client.model.o_auth2_token_introspection import OAuth2TokenIntrospection
from ory_client.model.patch_request import PatchRequest
from ory_client.model.previous_consent_session import PreviousConsentSession
from ory_client.model.reject_request import RejectRequest
from ory_client.model.request_was_handled_response import RequestWasHandledResponse
from ory_client.model.trust_jwt_grant_issuer_body import TrustJwtGrantIssuerBody
from ory_client.model.trusted_jwt_grant_issuer import TrustedJwtGrantIssuer
from ory_client.model.trusted_jwt_grant_issuers import TrustedJwtGrantIssuers
# Defining the host is optional and defaults to https://playground.projects.oryapis.com
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_client.Configuration(
    host = "https://playground.projects.oryapis.com"
)



# Enter a context with an instance of the API client
with ory_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = admin_api.AdminApi(api_client)
    consent_challenge = "consent_challenge_example" # str | 
    accept_consent_request = AcceptConsentRequest(
        grant_access_token_audience=StringSlicePipeDelimiter([
            "grant_access_token_audience_example",
        ]),
        grant_scope=StringSlicePipeDelimiter([
            "grant_scope_example",
        ]),
        handled_at=dateutil_parser('1970-01-01T00:00:00.00Z'),
        remember=True,
        remember_for=1,
        session=ConsentRequestSession(
            access_token=None,
            id_token=None,
        ),
    ) # AcceptConsentRequest |  (optional)

    try:
        # Accept a Consent Request
        api_response = api_instance.accept_consent_request(consent_challenge, accept_consent_request=accept_consent_request)
        pprint(api_response)
    except ory_client.ApiException as e:
        print("Exception when calling AdminApi->accept_consent_request: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://playground.projects.oryapis.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**accept_consent_request**](docs/AdminApi.md#accept_consent_request) | **PUT** /oauth2/auth/requests/consent/accept | Accept a Consent Request
*AdminApi* | [**accept_login_request**](docs/AdminApi.md#accept_login_request) | **PUT** /oauth2/auth/requests/login/accept | Accept a Login Request
*AdminApi* | [**accept_logout_request**](docs/AdminApi.md#accept_logout_request) | **PUT** /oauth2/auth/requests/logout/accept | Accept a Logout Request
*AdminApi* | [**create_json_web_key_set**](docs/AdminApi.md#create_json_web_key_set) | **POST** /keys/{set} | Generate a New JSON Web Key
*AdminApi* | [**create_o_auth2_client**](docs/AdminApi.md#create_o_auth2_client) | **POST** /clients | Create an OAuth 2.0 Client
*AdminApi* | [**delete_json_web_key**](docs/AdminApi.md#delete_json_web_key) | **DELETE** /keys/{set}/{kid} | Delete a JSON Web Key
*AdminApi* | [**delete_json_web_key_set**](docs/AdminApi.md#delete_json_web_key_set) | **DELETE** /keys/{set} | Delete a JSON Web Key Set
*AdminApi* | [**delete_o_auth2_client**](docs/AdminApi.md#delete_o_auth2_client) | **DELETE** /clients/{id} | Deletes an OAuth 2.0 Client
*AdminApi* | [**delete_o_auth2_token**](docs/AdminApi.md#delete_o_auth2_token) | **DELETE** /oauth2/tokens | Delete OAuth2 Access Tokens from a Client
*AdminApi* | [**delete_trusted_jwt_grant_issuer**](docs/AdminApi.md#delete_trusted_jwt_grant_issuer) | **DELETE** /trust/grants/jwt-bearer/issuers/{id} | Delete a Trusted OAuth2 JWT Bearer Grant Type Issuer
*AdminApi* | [**flush_inactive_o_auth2_tokens**](docs/AdminApi.md#flush_inactive_o_auth2_tokens) | **POST** /oauth2/flush | Flush Expired OAuth2 Access Tokens
*AdminApi* | [**get_consent_request**](docs/AdminApi.md#get_consent_request) | **GET** /oauth2/auth/requests/consent | Get Consent Request Information
*AdminApi* | [**get_json_web_key**](docs/AdminApi.md#get_json_web_key) | **GET** /keys/{set}/{kid} | Fetch a JSON Web Key
*AdminApi* | [**get_json_web_key_set**](docs/AdminApi.md#get_json_web_key_set) | **GET** /keys/{set} | Retrieve a JSON Web Key Set
*AdminApi* | [**get_login_request**](docs/AdminApi.md#get_login_request) | **GET** /oauth2/auth/requests/login | Get a Login Request
*AdminApi* | [**get_logout_request**](docs/AdminApi.md#get_logout_request) | **GET** /oauth2/auth/requests/logout | Get a Logout Request
*AdminApi* | [**get_o_auth2_client**](docs/AdminApi.md#get_o_auth2_client) | **GET** /clients/{id} | Get an OAuth 2.0 Client
*AdminApi* | [**get_trusted_jwt_grant_issuer**](docs/AdminApi.md#get_trusted_jwt_grant_issuer) | **GET** /trust/grants/jwt-bearer/issuers/{id} | Get a Trusted OAuth2 JWT Bearer Grant Type Issuer
*AdminApi* | [**introspect_o_auth2_token**](docs/AdminApi.md#introspect_o_auth2_token) | **POST** /oauth2/introspect | Introspect OAuth2 Tokens
*AdminApi* | [**list_o_auth2_clients**](docs/AdminApi.md#list_o_auth2_clients) | **GET** /clients | List OAuth 2.0 Clients
*AdminApi* | [**list_subject_consent_sessions**](docs/AdminApi.md#list_subject_consent_sessions) | **GET** /oauth2/auth/sessions/consent | Lists All Consent Sessions of a Subject
*AdminApi* | [**list_trusted_jwt_grant_issuers**](docs/AdminApi.md#list_trusted_jwt_grant_issuers) | **GET** /trust/grants/jwt-bearer/issuers | List Trusted OAuth2 JWT Bearer Grant Type Issuers
*AdminApi* | [**patch_o_auth2_client**](docs/AdminApi.md#patch_o_auth2_client) | **PATCH** /clients/{id} | Patch an OAuth 2.0 Client
*AdminApi* | [**reject_consent_request**](docs/AdminApi.md#reject_consent_request) | **PUT** /oauth2/auth/requests/consent/reject | Reject a Consent Request
*AdminApi* | [**reject_login_request**](docs/AdminApi.md#reject_login_request) | **PUT** /oauth2/auth/requests/login/reject | Reject a Login Request
*AdminApi* | [**reject_logout_request**](docs/AdminApi.md#reject_logout_request) | **PUT** /oauth2/auth/requests/logout/reject | Reject a Logout Request
*AdminApi* | [**revoke_authentication_session**](docs/AdminApi.md#revoke_authentication_session) | **DELETE** /oauth2/auth/sessions/login | Invalidates All Login Sessions of a Certain User Invalidates a Subject&#39;s Authentication Session
*AdminApi* | [**revoke_consent_sessions**](docs/AdminApi.md#revoke_consent_sessions) | **DELETE** /oauth2/auth/sessions/consent | Revokes Consent Sessions of a Subject for a Specific OAuth 2.0 Client
*AdminApi* | [**trust_jwt_grant_issuer**](docs/AdminApi.md#trust_jwt_grant_issuer) | **POST** /trust/grants/jwt-bearer/issuers | Trust an OAuth2 JWT Bearer Grant Type Issuer
*AdminApi* | [**update_json_web_key**](docs/AdminApi.md#update_json_web_key) | **PUT** /keys/{set}/{kid} | Update a JSON Web Key
*AdminApi* | [**update_json_web_key_set**](docs/AdminApi.md#update_json_web_key_set) | **PUT** /keys/{set} | Update a JSON Web Key Set
*AdminApi* | [**update_o_auth2_client**](docs/AdminApi.md#update_o_auth2_client) | **PUT** /clients/{id} | Update an OAuth 2.0 Client
*MetadataApi* | [**get_version**](docs/MetadataApi.md#get_version) | **GET** /version | Return Running Software Version.
*MetadataApi* | [**is_alive**](docs/MetadataApi.md#is_alive) | **GET** /health/alive | Check HTTP Server Status
*MetadataApi* | [**is_ready**](docs/MetadataApi.md#is_ready) | **GET** /health/ready | Check HTTP Server and Database Status
*PublicApi* | [**disconnect_user**](docs/PublicApi.md#disconnect_user) | **GET** /oauth2/sessions/logout | OpenID Connect Front-Backchannel Enabled Logout
*PublicApi* | [**discover_open_id_configuration**](docs/PublicApi.md#discover_open_id_configuration) | **GET** /.well-known/openid-configuration | OpenID Connect Discovery
*PublicApi* | [**dynamic_client_registration_create_o_auth2_client**](docs/PublicApi.md#dynamic_client_registration_create_o_auth2_client) | **POST** /connect/register | Register an OAuth 2.0 Client using the OpenID / OAuth2 Dynamic Client Registration Management Protocol
*PublicApi* | [**dynamic_client_registration_delete_o_auth2_client**](docs/PublicApi.md#dynamic_client_registration_delete_o_auth2_client) | **DELETE** /connect/register/{id} | Deletes an OAuth 2.0 Client using the OpenID / OAuth2 Dynamic Client Registration Management Protocol
*PublicApi* | [**dynamic_client_registration_get_o_auth2_client**](docs/PublicApi.md#dynamic_client_registration_get_o_auth2_client) | **GET** /connect/register/{id} | Get an OAuth 2.0 Client using the OpenID / OAuth2 Dynamic Client Registration Management Protocol
*PublicApi* | [**dynamic_client_registration_update_o_auth2_client**](docs/PublicApi.md#dynamic_client_registration_update_o_auth2_client) | **PUT** /connect/register/{id} | Update an OAuth 2.0 Client using the OpenID / OAuth2 Dynamic Client Registration Management Protocol
*PublicApi* | [**oauth2_token**](docs/PublicApi.md#oauth2_token) | **POST** /oauth2/token | The OAuth 2.0 Token Endpoint
*PublicApi* | [**oauth_auth**](docs/PublicApi.md#oauth_auth) | **GET** /oauth2/auth | The OAuth 2.0 Authorize Endpoint
*PublicApi* | [**revoke_o_auth2_token**](docs/PublicApi.md#revoke_o_auth2_token) | **POST** /oauth2/revoke | Revoke OAuth2 Tokens
*PublicApi* | [**userinfo**](docs/PublicApi.md#userinfo) | **GET** /userinfo | OpenID Connect Userinfo
*PublicApi* | [**well_known**](docs/PublicApi.md#well_known) | **GET** /.well-known/jwks.json | JSON Web Keys Discovery
*ReadApi* | [**get_check**](docs/ReadApi.md#get_check) | **GET** /relation-tuples/check/openapi | # Check a relation tuple
*ReadApi* | [**get_check_mirror_status**](docs/ReadApi.md#get_check_mirror_status) | **GET** /relation-tuples/check | # Check a relation tuple
*ReadApi* | [**get_expand**](docs/ReadApi.md#get_expand) | **GET** /relation-tuples/expand | # Expand a Relation Tuple
*ReadApi* | [**get_relation_tuples**](docs/ReadApi.md#get_relation_tuples) | **GET** /relation-tuples | # Query relation tuples
*ReadApi* | [**post_check**](docs/ReadApi.md#post_check) | **POST** /relation-tuples/check/openapi | # Check a relation tuple
*ReadApi* | [**post_check_mirror_status**](docs/ReadApi.md#post_check_mirror_status) | **POST** /relation-tuples/check | # Check a relation tuple
*V0alpha2Api* | [**admin_create_identity**](docs/V0alpha2Api.md#admin_create_identity) | **POST** /admin/identities | Create an Identity
*V0alpha2Api* | [**admin_create_self_service_recovery_link**](docs/V0alpha2Api.md#admin_create_self_service_recovery_link) | **POST** /admin/recovery/link | Create a Recovery Link
*V0alpha2Api* | [**admin_delete_identity**](docs/V0alpha2Api.md#admin_delete_identity) | **DELETE** /admin/identities/{id} | Delete an Identity
*V0alpha2Api* | [**admin_delete_identity_sessions**](docs/V0alpha2Api.md#admin_delete_identity_sessions) | **DELETE** /admin/identities/{id}/sessions | Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity.
*V0alpha2Api* | [**admin_extend_session**](docs/V0alpha2Api.md#admin_extend_session) | **PATCH** /admin/sessions/{id}/extend | Calling this endpoint extends the given session ID. If &#x60;session.earliest_possible_extend&#x60; is set it will only extend the session after the specified time has passed.
*V0alpha2Api* | [**admin_get_identity**](docs/V0alpha2Api.md#admin_get_identity) | **GET** /admin/identities/{id} | Get an Identity
*V0alpha2Api* | [**admin_list_identities**](docs/V0alpha2Api.md#admin_list_identities) | **GET** /admin/identities | List Identities
*V0alpha2Api* | [**admin_list_identity_sessions**](docs/V0alpha2Api.md#admin_list_identity_sessions) | **GET** /admin/identities/{id}/sessions | This endpoint returns all sessions that belong to the given Identity.
*V0alpha2Api* | [**admin_patch_identity**](docs/V0alpha2Api.md#admin_patch_identity) | **PATCH** /admin/identities/{id} | Partially updates an Identity&#39;s field using [JSON Patch](https://jsonpatch.com/)
*V0alpha2Api* | [**admin_update_identity**](docs/V0alpha2Api.md#admin_update_identity) | **PUT** /admin/identities/{id} | Update an Identity
*V0alpha2Api* | [**create_project**](docs/V0alpha2Api.md#create_project) | **POST** /projects | # Create a Project
*V0alpha2Api* | [**create_project_api_key**](docs/V0alpha2Api.md#create_project_api_key) | **POST** /projects/{project}/tokens | # Create API Token
*V0alpha2Api* | [**create_self_service_logout_flow_url_for_browsers**](docs/V0alpha2Api.md#create_self_service_logout_flow_url_for_browsers) | **GET** /self-service/logout/browser | Create a Logout URL for Browsers
*V0alpha2Api* | [**delete_project_api_key**](docs/V0alpha2Api.md#delete_project_api_key) | **DELETE** /projects/{project}/tokens/{token_id} | # Delete API Token
*V0alpha2Api* | [**get_identity_schema**](docs/V0alpha2Api.md#get_identity_schema) | **GET** /schemas/{id} | 
*V0alpha2Api* | [**get_project**](docs/V0alpha2Api.md#get_project) | **GET** /projects/{project_id} | # Get a Project
*V0alpha2Api* | [**get_project_members**](docs/V0alpha2Api.md#get_project_members) | **GET** /projects/{project_id}/members | Get all members associated with this project.
*V0alpha2Api* | [**get_self_service_error**](docs/V0alpha2Api.md#get_self_service_error) | **GET** /self-service/errors | Get Self-Service Errors
*V0alpha2Api* | [**get_self_service_login_flow**](docs/V0alpha2Api.md#get_self_service_login_flow) | **GET** /self-service/login/flows | Get Login Flow
*V0alpha2Api* | [**get_self_service_recovery_flow**](docs/V0alpha2Api.md#get_self_service_recovery_flow) | **GET** /self-service/recovery/flows | Get Recovery Flow
*V0alpha2Api* | [**get_self_service_registration_flow**](docs/V0alpha2Api.md#get_self_service_registration_flow) | **GET** /self-service/registration/flows | Get Registration Flow
*V0alpha2Api* | [**get_self_service_settings_flow**](docs/V0alpha2Api.md#get_self_service_settings_flow) | **GET** /self-service/settings/flows | Get Settings Flow
*V0alpha2Api* | [**get_self_service_verification_flow**](docs/V0alpha2Api.md#get_self_service_verification_flow) | **GET** /self-service/verification/flows | # Get Verification Flow
*V0alpha2Api* | [**get_web_authn_java_script**](docs/V0alpha2Api.md#get_web_authn_java_script) | **GET** /.well-known/ory/webauthn.js | Get WebAuthn JavaScript
*V0alpha2Api* | [**initialize_self_service_login_flow_for_browsers**](docs/V0alpha2Api.md#initialize_self_service_login_flow_for_browsers) | **GET** /self-service/login/browser | Initialize Login Flow for Browsers
*V0alpha2Api* | [**initialize_self_service_login_flow_without_browser**](docs/V0alpha2Api.md#initialize_self_service_login_flow_without_browser) | **GET** /self-service/login/api | Initialize Login Flow for APIs, Services, Apps, ...
*V0alpha2Api* | [**initialize_self_service_recovery_flow_for_browsers**](docs/V0alpha2Api.md#initialize_self_service_recovery_flow_for_browsers) | **GET** /self-service/recovery/browser | Initialize Recovery Flow for Browsers
*V0alpha2Api* | [**initialize_self_service_recovery_flow_without_browser**](docs/V0alpha2Api.md#initialize_self_service_recovery_flow_without_browser) | **GET** /self-service/recovery/api | Initialize Recovery Flow for APIs, Services, Apps, ...
*V0alpha2Api* | [**initialize_self_service_registration_flow_for_browsers**](docs/V0alpha2Api.md#initialize_self_service_registration_flow_for_browsers) | **GET** /self-service/registration/browser | Initialize Registration Flow for Browsers
*V0alpha2Api* | [**initialize_self_service_registration_flow_without_browser**](docs/V0alpha2Api.md#initialize_self_service_registration_flow_without_browser) | **GET** /self-service/registration/api | Initialize Registration Flow for APIs, Services, Apps, ...
*V0alpha2Api* | [**initialize_self_service_settings_flow_for_browsers**](docs/V0alpha2Api.md#initialize_self_service_settings_flow_for_browsers) | **GET** /self-service/settings/browser | Initialize Settings Flow for Browsers
*V0alpha2Api* | [**initialize_self_service_settings_flow_without_browser**](docs/V0alpha2Api.md#initialize_self_service_settings_flow_without_browser) | **GET** /self-service/settings/api | Initialize Settings Flow for APIs, Services, Apps, ...
*V0alpha2Api* | [**initialize_self_service_verification_flow_for_browsers**](docs/V0alpha2Api.md#initialize_self_service_verification_flow_for_browsers) | **GET** /self-service/verification/browser | Initialize Verification Flow for Browser Clients
*V0alpha2Api* | [**initialize_self_service_verification_flow_without_browser**](docs/V0alpha2Api.md#initialize_self_service_verification_flow_without_browser) | **GET** /self-service/verification/api | Initialize Verification Flow for APIs, Services, Apps, ...
*V0alpha2Api* | [**list_identity_schemas**](docs/V0alpha2Api.md#list_identity_schemas) | **GET** /schemas | 
*V0alpha2Api* | [**list_project_api_keys**](docs/V0alpha2Api.md#list_project_api_keys) | **GET** /projects/{project}/tokens | # List a Project&#39;s API Tokens
*V0alpha2Api* | [**list_projects**](docs/V0alpha2Api.md#list_projects) | **GET** /projects | # List All Projects
*V0alpha2Api* | [**list_sessions**](docs/V0alpha2Api.md#list_sessions) | **GET** /sessions | This endpoints returns all other active sessions that belong to the logged-in user. The current session can be retrieved by calling the &#x60;/sessions/whoami&#x60; endpoint.
*V0alpha2Api* | [**patch_project**](docs/V0alpha2Api.md#patch_project) | **PATCH** /projects/{project_id} | Patch an Ory Cloud Project Configuration&#x60;
*V0alpha2Api* | [**purge_project**](docs/V0alpha2Api.md#purge_project) | **DELETE** /projects/{project_id} | # Irrecoverably Purge a Project
*V0alpha2Api* | [**remove_project_member**](docs/V0alpha2Api.md#remove_project_member) | **DELETE** /projects/{project_id}/members/{member_id} | Remove a member associated with this project. This also sets their invite status to &#x60;REMOVED&#x60;.
*V0alpha2Api* | [**revoke_session**](docs/V0alpha2Api.md#revoke_session) | **DELETE** /sessions/{id} | Calling this endpoint invalidates the specified session. The current session cannot be revoked. Session data are not deleted.
*V0alpha2Api* | [**revoke_sessions**](docs/V0alpha2Api.md#revoke_sessions) | **DELETE** /sessions | Calling this endpoint invalidates all except the current session that belong to the logged-in user. Session data are not deleted.
*V0alpha2Api* | [**submit_self_service_login_flow**](docs/V0alpha2Api.md#submit_self_service_login_flow) | **POST** /self-service/login | Submit a Login Flow
*V0alpha2Api* | [**submit_self_service_logout_flow**](docs/V0alpha2Api.md#submit_self_service_logout_flow) | **GET** /self-service/logout | Complete Self-Service Logout
*V0alpha2Api* | [**submit_self_service_logout_flow_without_browser**](docs/V0alpha2Api.md#submit_self_service_logout_flow_without_browser) | **DELETE** /self-service/logout/api | Perform Logout for APIs, Services, Apps, ...
*V0alpha2Api* | [**submit_self_service_recovery_flow**](docs/V0alpha2Api.md#submit_self_service_recovery_flow) | **POST** /self-service/recovery | Complete Recovery Flow
*V0alpha2Api* | [**submit_self_service_registration_flow**](docs/V0alpha2Api.md#submit_self_service_registration_flow) | **POST** /self-service/registration | Submit a Registration Flow
*V0alpha2Api* | [**submit_self_service_settings_flow**](docs/V0alpha2Api.md#submit_self_service_settings_flow) | **POST** /self-service/settings | Complete Settings Flow
*V0alpha2Api* | [**submit_self_service_verification_flow**](docs/V0alpha2Api.md#submit_self_service_verification_flow) | **POST** /self-service/verification | # Complete Verification Flow
*V0alpha2Api* | [**to_session**](docs/V0alpha2Api.md#to_session) | **GET** /sessions/whoami | Check Who the Current HTTP Session Belongs To
*V0alpha2Api* | [**update_project**](docs/V0alpha2Api.md#update_project) | **PUT** /projects/{project_id} | # Update an Ory Cloud Project Configuration
*WriteApi* | [**create_relation_tuple**](docs/WriteApi.md#create_relation_tuple) | **PUT** /admin/relation-tuples | # Create a Relation Tuple
*WriteApi* | [**delete_relation_tuples**](docs/WriteApi.md#delete_relation_tuples) | **DELETE** /admin/relation-tuples | # Delete Relation Tuples
*WriteApi* | [**patch_relation_tuples**](docs/WriteApi.md#patch_relation_tuples) | **PATCH** /admin/relation-tuples | # Patch Multiple Relation Tuples


## Documentation For Models

 - [AcceptConsentRequest](docs/AcceptConsentRequest.md)
 - [AcceptLoginRequest](docs/AcceptLoginRequest.md)
 - [ActiveProject](docs/ActiveProject.md)
 - [AdminCreateIdentityBody](docs/AdminCreateIdentityBody.md)
 - [AdminCreateIdentityImportCredentialsOidc](docs/AdminCreateIdentityImportCredentialsOidc.md)
 - [AdminCreateIdentityImportCredentialsOidcConfig](docs/AdminCreateIdentityImportCredentialsOidcConfig.md)
 - [AdminCreateIdentityImportCredentialsOidcProvider](docs/AdminCreateIdentityImportCredentialsOidcProvider.md)
 - [AdminCreateIdentityImportCredentialsPassword](docs/AdminCreateIdentityImportCredentialsPassword.md)
 - [AdminCreateIdentityImportCredentialsPasswordConfig](docs/AdminCreateIdentityImportCredentialsPasswordConfig.md)
 - [AdminCreateSelfServiceRecoveryLinkBody](docs/AdminCreateSelfServiceRecoveryLinkBody.md)
 - [AdminIdentityImportCredentials](docs/AdminIdentityImportCredentials.md)
 - [AdminUpdateIdentityBody](docs/AdminUpdateIdentityBody.md)
 - [AuthenticatorAssuranceLevel](docs/AuthenticatorAssuranceLevel.md)
 - [CloudAccount](docs/CloudAccount.md)
 - [CnameSettings](docs/CnameSettings.md)
 - [CompletedRequest](docs/CompletedRequest.md)
 - [ConsentRequest](docs/ConsentRequest.md)
 - [ConsentRequestSession](docs/ConsentRequestSession.md)
 - [CreateCustomHostnameBody](docs/CreateCustomHostnameBody.md)
 - [CreateProjectApiKeyRequest](docs/CreateProjectApiKeyRequest.md)
 - [CreateProjectBody](docs/CreateProjectBody.md)
 - [CreateSubscriptionPayload](docs/CreateSubscriptionPayload.md)
 - [ErrorAuthenticatorAssuranceLevelNotSatisfied](docs/ErrorAuthenticatorAssuranceLevelNotSatisfied.md)
 - [ExpandTree](docs/ExpandTree.md)
 - [FlushInactiveOAuth2TokensRequest](docs/FlushInactiveOAuth2TokensRequest.md)
 - [FlushLoginConsentRequest](docs/FlushLoginConsentRequest.md)
 - [GenericError](docs/GenericError.md)
 - [GenericErrorContent](docs/GenericErrorContent.md)
 - [GetCheckResponse](docs/GetCheckResponse.md)
 - [GetManagedIdentitySchemaLocation](docs/GetManagedIdentitySchemaLocation.md)
 - [GetProjectAccessResponse](docs/GetProjectAccessResponse.md)
 - [GetRelationTuplesResponse](docs/GetRelationTuplesResponse.md)
 - [GetVersion200Response](docs/GetVersion200Response.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [Identity](docs/Identity.md)
 - [IdentityCredentials](docs/IdentityCredentials.md)
 - [IdentityCredentialsOidc](docs/IdentityCredentialsOidc.md)
 - [IdentityCredentialsOidcProvider](docs/IdentityCredentialsOidcProvider.md)
 - [IdentityCredentialsPassword](docs/IdentityCredentialsPassword.md)
 - [IdentityCredentialsType](docs/IdentityCredentialsType.md)
 - [IdentityList](docs/IdentityList.md)
 - [IdentitySchemaContainer](docs/IdentitySchemaContainer.md)
 - [IdentitySchemaPreset](docs/IdentitySchemaPreset.md)
 - [IdentitySchemaPresets](docs/IdentitySchemaPresets.md)
 - [IdentitySchemas](docs/IdentitySchemas.md)
 - [IdentityState](docs/IdentityState.md)
 - [InvitePayload](docs/InvitePayload.md)
 - [IsOwnerForProjectBySlug](docs/IsOwnerForProjectBySlug.md)
 - [IsOwnerForProjectBySlugPayload](docs/IsOwnerForProjectBySlugPayload.md)
 - [IsReady200Response](docs/IsReady200Response.md)
 - [IsReady503Response](docs/IsReady503Response.md)
 - [JSONWebKey](docs/JSONWebKey.md)
 - [JSONWebKeySet](docs/JSONWebKeySet.md)
 - [JsonError](docs/JsonError.md)
 - [JsonPatch](docs/JsonPatch.md)
 - [JsonPatchDocument](docs/JsonPatchDocument.md)
 - [JsonWebKeySetGeneratorRequest](docs/JsonWebKeySetGeneratorRequest.md)
 - [KetoNamespace](docs/KetoNamespace.md)
 - [KetoNamespaces](docs/KetoNamespaces.md)
 - [ListCustomHostnamesResponse](docs/ListCustomHostnamesResponse.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LogoutRequest](docs/LogoutRequest.md)
 - [ManagedIdentitySchema](docs/ManagedIdentitySchema.md)
 - [ManagedIdentitySchemaValidationResult](docs/ManagedIdentitySchemaValidationResult.md)
 - [ManagedIdentitySchemas](docs/ManagedIdentitySchemas.md)
 - [NeedsPrivilegedSessionError](docs/NeedsPrivilegedSessionError.md)
 - [NormalizedProject](docs/NormalizedProject.md)
 - [NormalizedProjectRevision](docs/NormalizedProjectRevision.md)
 - [NormalizedProjectRevisionHook](docs/NormalizedProjectRevisionHook.md)
 - [NormalizedProjectRevisionIdentitySchema](docs/NormalizedProjectRevisionIdentitySchema.md)
 - [NormalizedProjectRevisionIdentitySchemas](docs/NormalizedProjectRevisionIdentitySchemas.md)
 - [NormalizedProjectRevisionThirdPartyProvider](docs/NormalizedProjectRevisionThirdPartyProvider.md)
 - [NormalizedProjects](docs/NormalizedProjects.md)
 - [NullDuration](docs/NullDuration.md)
 - [NullPlan](docs/NullPlan.md)
 - [OAuth2Client](docs/OAuth2Client.md)
 - [OAuth2TokenIntrospection](docs/OAuth2TokenIntrospection.md)
 - [Oauth2TokenResponse](docs/Oauth2TokenResponse.md)
 - [OauthTokenResponse](docs/OauthTokenResponse.md)
 - [OpenIDConnectContext](docs/OpenIDConnectContext.md)
 - [Pagination](docs/Pagination.md)
 - [PatchDelta](docs/PatchDelta.md)
 - [PatchDocument](docs/PatchDocument.md)
 - [PatchRequest](docs/PatchRequest.md)
 - [PreviousConsentSession](docs/PreviousConsentSession.md)
 - [Project](docs/Project.md)
 - [ProjectApiKey](docs/ProjectApiKey.md)
 - [ProjectApiKeys](docs/ProjectApiKeys.md)
 - [ProjectHost](docs/ProjectHost.md)
 - [ProjectInvite](docs/ProjectInvite.md)
 - [ProjectInvites](docs/ProjectInvites.md)
 - [ProjectMember](docs/ProjectMember.md)
 - [ProjectMembers](docs/ProjectMembers.md)
 - [ProjectMetadata](docs/ProjectMetadata.md)
 - [ProjectMetadataList](docs/ProjectMetadataList.md)
 - [ProjectRevisionHooks](docs/ProjectRevisionHooks.md)
 - [ProjectRevisionIdentitySchemas](docs/ProjectRevisionIdentitySchemas.md)
 - [ProjectRevisionThirdPartyLoginProviders](docs/ProjectRevisionThirdPartyLoginProviders.md)
 - [ProjectRevisions](docs/ProjectRevisions.md)
 - [ProjectServiceIdentity](docs/ProjectServiceIdentity.md)
 - [ProjectServiceOAuth2](docs/ProjectServiceOAuth2.md)
 - [ProjectServicePermission](docs/ProjectServicePermission.md)
 - [ProjectServices](docs/ProjectServices.md)
 - [Projects](docs/Projects.md)
 - [ProvisionMockSubscriptionPayload](docs/ProvisionMockSubscriptionPayload.md)
 - [QuotaCustomDomains](docs/QuotaCustomDomains.md)
 - [QuotaProjectMemberSeats](docs/QuotaProjectMemberSeats.md)
 - [RecoveryAddress](docs/RecoveryAddress.md)
 - [RefreshTokenHookRequest](docs/RefreshTokenHookRequest.md)
 - [RefreshTokenHookResponse](docs/RefreshTokenHookResponse.md)
 - [RejectRequest](docs/RejectRequest.md)
 - [RelationQuery](docs/RelationQuery.md)
 - [RelationTuple](docs/RelationTuple.md)
 - [RequestWasHandledResponse](docs/RequestWasHandledResponse.md)
 - [RevokedSessions](docs/RevokedSessions.md)
 - [SchemaPatch](docs/SchemaPatch.md)
 - [SelfServiceBrowserLocationChangeRequiredError](docs/SelfServiceBrowserLocationChangeRequiredError.md)
 - [SelfServiceError](docs/SelfServiceError.md)
 - [SelfServiceFlowExpiredError](docs/SelfServiceFlowExpiredError.md)
 - [SelfServiceLoginFlow](docs/SelfServiceLoginFlow.md)
 - [SelfServiceLogoutUrl](docs/SelfServiceLogoutUrl.md)
 - [SelfServiceRecoveryFlow](docs/SelfServiceRecoveryFlow.md)
 - [SelfServiceRecoveryFlowState](docs/SelfServiceRecoveryFlowState.md)
 - [SelfServiceRecoveryLink](docs/SelfServiceRecoveryLink.md)
 - [SelfServiceRegistrationFlow](docs/SelfServiceRegistrationFlow.md)
 - [SelfServiceSettingsFlow](docs/SelfServiceSettingsFlow.md)
 - [SelfServiceSettingsFlowState](docs/SelfServiceSettingsFlowState.md)
 - [SelfServiceVerificationFlow](docs/SelfServiceVerificationFlow.md)
 - [SelfServiceVerificationFlowState](docs/SelfServiceVerificationFlowState.md)
 - [Session](docs/Session.md)
 - [SessionAuthenticationMethod](docs/SessionAuthenticationMethod.md)
 - [SessionAuthenticationMethods](docs/SessionAuthenticationMethods.md)
 - [SessionDevice](docs/SessionDevice.md)
 - [SessionList](docs/SessionList.md)
 - [SettingsProfileFormConfig](docs/SettingsProfileFormConfig.md)
 - [StringSliceJSONFormat](docs/StringSliceJSONFormat.md)
 - [StringSlicePipeDelimiter](docs/StringSlicePipeDelimiter.md)
 - [StripeCustomerResponse](docs/StripeCustomerResponse.md)
 - [SubjectSet](docs/SubjectSet.md)
 - [SubmitSelfServiceFlowWithWebAuthnRegistrationMethod](docs/SubmitSelfServiceFlowWithWebAuthnRegistrationMethod.md)
 - [SubmitSelfServiceLoginFlowBody](docs/SubmitSelfServiceLoginFlowBody.md)
 - [SubmitSelfServiceLoginFlowWithLookupSecretMethodBody](docs/SubmitSelfServiceLoginFlowWithLookupSecretMethodBody.md)
 - [SubmitSelfServiceLoginFlowWithOidcMethodBody](docs/SubmitSelfServiceLoginFlowWithOidcMethodBody.md)
 - [SubmitSelfServiceLoginFlowWithPasswordMethodBody](docs/SubmitSelfServiceLoginFlowWithPasswordMethodBody.md)
 - [SubmitSelfServiceLoginFlowWithTotpMethodBody](docs/SubmitSelfServiceLoginFlowWithTotpMethodBody.md)
 - [SubmitSelfServiceLoginFlowWithWebAuthnMethodBody](docs/SubmitSelfServiceLoginFlowWithWebAuthnMethodBody.md)
 - [SubmitSelfServiceLogoutFlowWithoutBrowserBody](docs/SubmitSelfServiceLogoutFlowWithoutBrowserBody.md)
 - [SubmitSelfServiceRecoveryFlowBody](docs/SubmitSelfServiceRecoveryFlowBody.md)
 - [SubmitSelfServiceRecoveryFlowWithLinkMethodBody](docs/SubmitSelfServiceRecoveryFlowWithLinkMethodBody.md)
 - [SubmitSelfServiceRegistrationFlowBody](docs/SubmitSelfServiceRegistrationFlowBody.md)
 - [SubmitSelfServiceRegistrationFlowWithOidcMethodBody](docs/SubmitSelfServiceRegistrationFlowWithOidcMethodBody.md)
 - [SubmitSelfServiceRegistrationFlowWithPasswordMethodBody](docs/SubmitSelfServiceRegistrationFlowWithPasswordMethodBody.md)
 - [SubmitSelfServiceRegistrationFlowWithWebAuthnMethodBody](docs/SubmitSelfServiceRegistrationFlowWithWebAuthnMethodBody.md)
 - [SubmitSelfServiceSettingsFlowBody](docs/SubmitSelfServiceSettingsFlowBody.md)
 - [SubmitSelfServiceSettingsFlowWithLookupMethodBody](docs/SubmitSelfServiceSettingsFlowWithLookupMethodBody.md)
 - [SubmitSelfServiceSettingsFlowWithOidcMethodBody](docs/SubmitSelfServiceSettingsFlowWithOidcMethodBody.md)
 - [SubmitSelfServiceSettingsFlowWithPasswordMethodBody](docs/SubmitSelfServiceSettingsFlowWithPasswordMethodBody.md)
 - [SubmitSelfServiceSettingsFlowWithProfileMethodBody](docs/SubmitSelfServiceSettingsFlowWithProfileMethodBody.md)
 - [SubmitSelfServiceSettingsFlowWithTotpMethodBody](docs/SubmitSelfServiceSettingsFlowWithTotpMethodBody.md)
 - [SubmitSelfServiceSettingsFlowWithWebAuthnMethodBody](docs/SubmitSelfServiceSettingsFlowWithWebAuthnMethodBody.md)
 - [SubmitSelfServiceVerificationFlowBody](docs/SubmitSelfServiceVerificationFlowBody.md)
 - [SubmitSelfServiceVerificationFlowWithLinkMethodBody](docs/SubmitSelfServiceVerificationFlowWithLinkMethodBody.md)
 - [Subscription](docs/Subscription.md)
 - [SuccessfulProjectUpdate](docs/SuccessfulProjectUpdate.md)
 - [SuccessfulSelfServiceLoginWithoutBrowser](docs/SuccessfulSelfServiceLoginWithoutBrowser.md)
 - [SuccessfulSelfServiceRegistrationWithoutBrowser](docs/SuccessfulSelfServiceRegistrationWithoutBrowser.md)
 - [TokenPagination](docs/TokenPagination.md)
 - [TokenPaginationHeaders](docs/TokenPaginationHeaders.md)
 - [TrustJwtGrantIssuerBody](docs/TrustJwtGrantIssuerBody.md)
 - [TrustedJsonWebKey](docs/TrustedJsonWebKey.md)
 - [TrustedJwtGrantIssuer](docs/TrustedJwtGrantIssuer.md)
 - [TrustedJwtGrantIssuers](docs/TrustedJwtGrantIssuers.md)
 - [UiContainer](docs/UiContainer.md)
 - [UiNode](docs/UiNode.md)
 - [UiNodeAnchorAttributes](docs/UiNodeAnchorAttributes.md)
 - [UiNodeAttributes](docs/UiNodeAttributes.md)
 - [UiNodeImageAttributes](docs/UiNodeImageAttributes.md)
 - [UiNodeInputAttributes](docs/UiNodeInputAttributes.md)
 - [UiNodeMeta](docs/UiNodeMeta.md)
 - [UiNodeScriptAttributes](docs/UiNodeScriptAttributes.md)
 - [UiNodeTextAttributes](docs/UiNodeTextAttributes.md)
 - [UiNodes](docs/UiNodes.md)
 - [UiText](docs/UiText.md)
 - [UiTexts](docs/UiTexts.md)
 - [UpdateCustomHostnameBody](docs/UpdateCustomHostnameBody.md)
 - [UpdateProject](docs/UpdateProject.md)
 - [UpdateSubscriptionPayload](docs/UpdateSubscriptionPayload.md)
 - [UserinfoResponse](docs/UserinfoResponse.md)
 - [VerifiableIdentityAddress](docs/VerifiableIdentityAddress.md)
 - [Version](docs/Version.md)
 - [Warning](docs/Warning.md)
 - [WellKnown](docs/WellKnown.md)


## Documentation For Authorization


## basic

- **Type**: HTTP basic authentication


## oauth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://hydra.demo.ory.sh/oauth2/auth
- **Scopes**: 
 - **offline**: A scope required when requesting refresh tokens (alias for `offline_access`)
 - **offline_access**: A scope required when requesting refresh tokens
 - **openid**: Request an OpenID Connect ID Token


## oryAccessToken

- **Type**: Bearer authentication


## Author

support@ory.sh


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ory_client.apis and ory_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ory_client.api.default_api import DefaultApi`
- `from ory_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ory_client
from ory_client.apis import *
from ory_client.models import *
```

