# -*- coding: utf-8 -*-
"""Base classes and metaclasses."""

from .bases import (
    ABSTRACT_TAG,
    FINAL_CLASS_TAG,
    FINAL_METHOD_TAG,
    INITIALIZING_TAG,
    MISSING,
    Base,
    BaseCollection,
    BaseContainer,
    BaseHashable,
    BaseInteractiveCollection,
    BaseIterable,
    BaseMeta,
    BaseMutableCollection,
    BaseProtectedCollection,
    BaseSized,
    Generic,
    abstract_member,
    final,
    init,
    init_context,
    make_base_cls,
    simplify_member_names,
)
from .dict import BaseDict, BaseInteractiveDict, BaseMutableDict, BaseProtectedDict
from .list import BaseInteractiveList, BaseList, BaseMutableList, BaseProtectedList
from .set import BaseInteractiveSet, BaseMutableSet, BaseProtectedSet, BaseSet

__all__ = [
    "MISSING",
    "ABSTRACT_TAG",
    "FINAL_CLASS_TAG",
    "FINAL_METHOD_TAG",
    "INITIALIZING_TAG",
    "final",
    "init_context",
    "init",
    "simplify_member_names",
    "make_base_cls",
    "BaseMeta",
    "Base",
    "abstract_member",
    "Generic",
    "BaseHashable",
    "BaseSized",
    "BaseIterable",
    "BaseContainer",
    "BaseCollection",
    "BaseProtectedCollection",
    "BaseInteractiveCollection",
    "BaseMutableCollection",
    "BaseDict",
    "BaseProtectedDict",
    "BaseInteractiveDict",
    "BaseMutableDict",
    "BaseList",
    "BaseProtectedList",
    "BaseInteractiveList",
    "BaseMutableList",
    "BaseSet",
    "BaseProtectedSet",
    "BaseInteractiveSet",
    "BaseMutableSet",
]
