# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['syncall',
 'syncall.asana',
 'syncall.caldav',
 'syncall.filesystem',
 'syncall.google',
 'syncall.notion',
 'syncall.scripts',
 'syncall.taskwarrior']

package_data = \
{'': ['*'], 'syncall': ['res/*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0',
 'bidict>=0.21.2,<0.22.0',
 'bubop==0.1.10',
 'click>=8.0,<9.0',
 'item-synchronizer>=1.1.4,<2.0.0',
 'loguru>=0.5.3,<0.6.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'pytz>=2021.1,<2022.0',
 'rfc3339>=6.2,<7.0',
 'typing>=3.7.4,<4.0.0']

extras_require = \
{'asana': ['asana>=1.0.0,<2.0.0'],
 'caldav': ['caldav>=0.11.0,<0.12.0', 'icalendar>=5.0.3,<6.0.0'],
 'fs': ['xattr>=0.9.9,<0.10.0'],
 'gkeep': ['gkeepapi>=0.13.7,<0.14.0'],
 'google': ['google-api-python-client>=2.1.0,<3.0.0',
            'google-auth-oauthlib>=0.4.4,<0.5.0'],
 'notion': ['notion-client>=0.7.1,<0.8.0'],
 'tw': ['taskw>=1.3.1,<2.0.0']}

entry_points = \
{'console_scripts': ['fs_gkeep_sync = syncall.scripts.fs_gkeep_sync:main',
                     'tw_asana_sync = syncall.scripts.tw_asana_sync:main',
                     'tw_caldav_sync = syncall.scripts.tw_caldav_sync:main',
                     'tw_gcal_sync = syncall.scripts.tw_gcal_sync:main',
                     'tw_gkeep_sync = syncall.scripts.tw_gkeep_sync:main',
                     'tw_notion_sync = syncall.scripts.tw_notion_sync:main']}

setup_kwargs = {
    'name': 'syncall',
    'version': '1.5.0',
    'description': 'Versatile bi-directional synchronization tool',
    'long_description': '# syncall\n\n<p align="center">\n  <img src="https://raw.githubusercontent.com/bergercookie/syncall/master/misc/meme.png"/>\n</p>\n\n<a href="https://github.com/bergercookie/syncall/actions" alt="master">\n<img src="https://github.com/bergercookie/syncall/actions/workflows/ci.yml/badge.svg?branch=master" /></a>\n<a href=\'https://coveralls.io/github/bergercookie/syncall?branch=master\'>\n<img src=\'https://coveralls.io/repos/github/bergercookie/syncall/badge.svg?branch=master\' alt=\'Coverage Status\' /></a>\n<a href="https://github.com/pre-commit/pre-commit">\n<img src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white" alt="pre-commit"></a>\n<a href="https://github.com/bergercookie/syncall/blob/master/LICENSE" alt="LICENSE">\n<img src="https://img.shields.io/github/license/bergercookie/syncall.svg" /></a>\n<a href="https://pypi.org/project/syncall" alt="PyPI">\n<img src="https://img.shields.io/pypi/pyversions/syncall.svg" /></a>\n<a href="https://badge.fury.io/py/syncall">\n<img src="https://badge.fury.io/py/syncall.svg" alt="PyPI version" height="18"></a>\n<a href="https://pepy.tech/project/syncall">\n<img alt="Downloads" src="https://pepy.tech/badge/syncall"></a>\n<a href="https://github.com/psf/black">\n<img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n\n## Description\n\n`syncall` is your one-stop software to bi-directionally synchronize and keep in\nsync the data from a variety of services. The framework is targeted towards, but\nnot limited to, the synchronization of note-taking and task management data.\nEach synchronization comes with its own executable which handles the\nsynchronization services/sides at hand.\n\nOne of the main goals of `syncall` is to be extendable. Thus it should be easy\nto introduce support for either a new service / synchronization side (e.g.,\nClickUp) or a new synchronization altogether (e.g., ClickUp <-> Google Keep)\ngiven that you [implement the corresponding synchronization\nsides and conversion methods](implement-a-new-synchronization.md). See also the\n[CONTRIBUTING](CONTRIBUTING.md) guide to get started.\n\nAt the moment the list of supported synchronizations is the following:\n\n<table style="undefined;table-layout: fixed; width: 823px">\n<thead>\n  <tr>\n    <th></th>\n    <th>Description</th>\n    <th>Executable</th>\n  </tr>\n</thead>\n<tbody>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-tw-gcal.md">README</a></td>\n    <td> <a href="https://taskwarrior.org/">Taskwarrior</a> ⬄ <a href="https://calendar.google.com/">Google Calendar</a></td>\n    <td><tt>tw-gcal-sync</tt></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-tw-notion.md">README</a></td>\n    <td> <a href="https://taskwarrior.org/">Taskwarrior</a> ⬄ <a href="https://notion.so">Notion Checkboxes</a></td>\n    <td><tt>tw-notion-sync</tt></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-tw-gkeep.md">README</a></td>\n    <td> <a href="https://taskwarrior.org/">Taskwarrior</a> ⬄ <a href="https://www.google.com/keep/">Google Keep Checkboxes</a></td>\n    <td><tt>tw-gkeep-sync</tt></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-tw-asana.md">README</a></td>\n    <td> <a href="https://taskwarrior.org/">Taskwarrior</a> ⬄ <a href="https://www.asana.com">Asana Tasks</a></td>\n    <td><tt>tw-asana-sync</tt></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-tw-caldav.md">README</a></td>\n    <td> <a href="https://taskwarrior.org/">Taskwarrior</a> ⬄ Generic <a href="https://en.wikipedia.org/wiki/CalDAV">Caldav </a> server</td>\n    <td><tt>tw-caldav-sync</tt></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/bergercookie/syncall/blob/master/readme-fs-gkeep.md">README</a></td>\n    <td>  Local Files ⬄  <a href="https://www.google.com/keep/">Google Keep Notes</a></td>\n    <td><tt>fs-gkeep-sync</tt></td>\n  </tr>\n</tbody>\n</table>\n\nEach of the above should support _bi-directional_ synchronization between the\nsaid services. This means that on an _addition_, _modification_, or _deletion_\nof an item on one side, a corresponding addition, modification or deletion of\nthe counterpart item will occur on the other side so that the two sides are\neventually in sync. All synchronizations also support conflict resolution\nmeaning that it can successfully deal with item edits on both sides.\n\nCurrently unless the executable at hand specifies otherwise, the following\nconflict resolution strategies are available:\n\n<!-- START sniff-and-replace tw_gcal_sync --list-resolution-strategies START -->\n<!-- OVERRIDES --no-collapsible --no-markdown OVERRIDES -->\n\n1. MostRecentRS\n2. LeastRecentRS\n3. AlwaysFirstRS\n4. AlwaysSecondRS\n\n<!-- END sniff-and-replace -->\n\nBy the end of the run, it should show you a summary of what\'s been done, like\nthe following.\n\n```\nGoogle Keep\n-----------\n        * Items created: 3\n        * Items updated: 2\n        * Items deleted: 1\n\nTaskwarrior\n-----------\n        * Items created: 1\n        * Items updated: 0\n        * Items deleted: 0\n```\n\nRefer to the corresponding README from the list above for instructions specific\nto the synchronization with that particular service. Before jumping to that\nthough, please complete the installation instructions below.\n\n## Installation instructions\n\n### Requirements\n\n- Python version >= `3.8`\n- For the integrations that require Taskwarrior - ([Installation\n  instructions](https://taskwarrior.org/download/)) version `>=2.6` is required.\n\n### Installation Options\n\nYou have to specify at least one extra. To do so use the `[]` syntax in pip:\n\n```sh\n# for installing integration with google (e.g. Google Keep / Calendar) and Notion\npip3 install syncall[notion,google]\n```\n\nHere\'s some of the available options for installing it:\n\n- From PyPI - e.g., Specify three extras for integrations - Google Calendar, Google Keep, Notion): `pip3 install --user --upgrade syncall[notion,google,gkeep]`\n- From Github - e.g., Specify two extras: `pip3 install --user "syncall[gkeep,fs] @ git+https://github.com/bergercookie/syncall"`\n- Download and install `devel` branch locally - bleeding edge\n\n  ```sh\n  git clone https://github.com/bergercookie/syncall\n  cd syncall\n  git checkout devel\n  pip3 install --user --upgrade .[gkeep,fs,google,tw,caldav,asana]\n  ```\n\n- Setup using [poetry](https://python-poetry.org/) - handy for local\n  development and for isolation of dependencies:\n\n  ```sh\n  git clone https://github.com/bergercookie/syncall\n  poetry install --all-extras\n  # get an interactive shell\n  poetry shell\n\n  # now the executables of all the services should be in your PATH for the\n  # current shell and you can also edit the source code without further\n  # re-installation ...\n  ```\n\n### Sample Usage Instructions\n\nHere\'s the CLI help page for the synchronizations available.\n\n<!-- START sniff-and-replace tw_gcal_sync --help START -->\n\n<details>\n <summary><tt>tw_gcal_sync --help</tt></summary>\n\n```\nUsage: tw_gcal_sync [OPTIONS]\n\n  Synchronize calendars from your Google Calendar with filters from\n  Taskwarrior.\n\n  The list of TW tasks is determined by a combination of TW tags and a TW\n  project while the calendar in GCal should be provided by their name. if it\n  doesn\'t exist it will be crated\n\nOptions:\n  -c, --gcal-calendar TEXT        Name of the Google Calendar to synchronize\n                                  (will be created if not there)\n  --google-secret FILE            Override the client secret used for the\n                                  communication with the Google APIs\n  --oauth-port INTEGER            Port to use for OAuth Authentication with\n                                  Google Applications\n  -t, --taskwarrior-tags TEXT     Taskwarrior tags to synchronize\n  -p, --tw-project TEXT           Taskwarrior project to synchronize\n  --list-combinations             List the available named TW<->Google\n                                  Calendar combinations\n  --list-resolution-strategies    List all the available resolution strategies\n                                  and exit\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved TW<->Google\n                                  Calendar combination\n  -s, --save-as TEXT              Save the given TW<->Google Calendar filters\n                                  combination using a specified custom name.\n  --prefer-scheduled-date         Prefer using the "scheduled" date field\n                                  instead of the "due" date if the former is\n                                  available\n  --default-event-duration-mins INTEGER\n                                  The default duration of an event that is to\n                                  be created on Google Calendar [in minutes]\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n<!-- START sniff-and-replace tw_notion_sync --help START -->\n\n<details>\n <summary><tt>tw_notion_sync --help</tt></summary>\n\n```\nUsage: tw_notion_sync [OPTIONS]\n\n  Synchronise filters of TW tasks with the to_do items of Notion pages\n\n  The list of TW tasks is determined by a combination of TW tags and TW\n  project while the notion pages should be provided by their URLs.\n\nOptions:\n  -n, --notion-page TEXT          Page ID of the Notion page to synchronize\n  --token, --token-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n  -t, --taskwarrior-tags TEXT     Taskwarrior tags to synchronize\n  -p, --tw-project TEXT           Taskwarrior project to synchronize\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved TW<->Notion\n                                  combination\n  --list-combinations             List the available named TW<->Notion\n                                  combinations\n  -s, --save-as TEXT              Save the given TW<->Notion filters\n                                  combination using a specified custom name.\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n<!-- START sniff-and-replace tw_gkeep_sync --help START -->\n\n<details>\n <summary><tt>tw_gkeep_sync --help</tt></summary>\n\n```\nUsage: tw_gkeep_sync [OPTIONS]\n\n  Synchronize Notes from your Google Keep with filters from Taskwarrior.\n\n  The list of TW tasks is determined by a combination of TW tags and a TW\n  project while the note in GKeep should be specified using their full name.\n  if it doesn\'t exist it will be created.\n\n  This service will create TaskWarrior tasks with the specified filter for\n  each one of the checkboxed items in the specified Google Keep note and will\n  create Google Keep items for each one of the tasks in the Taskwarrior\n  filter. You have to first "Show checkboxes" in the Google Keep Note in order\n  to use it with this service.\n\nOptions:\n  -k, --gkeep-note TEXT           Full title of the Google Keep Note to\n                                  synchronize - Make sure you enable the\n                                  checkboxes\n  --user, --user-pass-path TEXT   Path in the UNIX password manager to fetch\n                                  the Google username from\n  --passwd, --passwd-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n                                  the Google password from\n  --token, --token-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n                                  the google keep token from\n  -t, --taskwarrior-tags TEXT     Taskwarrior tags to synchronize\n  -p, --tw-project TEXT           Taskwarrior project to synchronize\n  --list-combinations             List the available named TW<->Google Keep\n                                  combinations\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved TW<->Google Keep\n                                  combination\n  -s, --save-as TEXT              Save the given TW<->Google Keep filters\n                                  combination using a specified custom name.\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n<!-- START sniff-and-replace tw_asana_sync --help START -->\n\n<details>\n <summary><tt>tw_asana_sync --help</tt></summary>\n\n```\nUsage: tw_asana_sync [OPTIONS]\n\nOptions:\n  --token, --token-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n  -w, --asana-workspace-gid TEXT  Asana workspace GID used to filter tasks\n  -W, --asana-workspace-name TEXT\n                                  Asana workspace name used to filter tasks\n  --list-asana-workspaces         List the available Asana workspaces\n  -t, --taskwarrior-tags TEXT     Taskwarrior tags to synchronize\n  -p, --tw-project TEXT           Taskwarrior project to synchronize\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved TW<->Asana\n                                  combination\n  --list-combinations             List the available named TW<->Asana\n                                  combinations\n  -s, --save-as TEXT              Save the given TW<->Asana filters\n                                  combination using a specified custom name.\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n<!-- START sniff-and-replace tw_caldav_sync --help START -->\n\n<details>\n <summary><tt>tw_caldav_sync --help</tt></summary>\n\n```\nUsage: tw_caldav_sync [OPTIONS]\n\n  Synchronize lists of tasks from your caldav Calendar with filters from\n  Taskwarrior.\n\n  The list of TW tasks is determined by a combination of TW tags and a TW\n  project. Use `--all` to synchronize all tasks.\n\n  The calendar in Caldav should be provided by their name. If it doesn\'t exist\n  it will be created.\n\nOptions:\n  --caldav-calendar TEXT          Name of the caldav Calendar to sync (will be\n                                  created if not there)\n  --caldav-url TEXT               URL where the caldav calendar is hosted at\n                                  (including /dav if applicable)\n  --caldav-user TEXT              The caldav username for the given caldav\n                                  instance\n  --caldav-passwd, --caldav-passwd-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n                                  the caldav password from\n  --all, --taskwarrior-all-tasks  Sync all taskwarrior tasks [potentially very\n                                  slow]\n  -t, --taskwarrior-tags TEXT     Taskwarrior tags to synchronize\n  -p, --tw-project TEXT           Taskwarrior project to synchronize\n  --30-days, --only-modified-last-30-days\n                                  Only synchronize Taskwarrior tasks that have\n                                  been modified in the last 30 days\n  --list-combinations             List the available named TW<->Caldav\n                                  combinations\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved TW<->Caldav\n                                  combination\n  -s, --save-as TEXT              Save the given TW<->Caldav filters\n                                  combination using a specified custom name.\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n<!-- START sniff-and-replace fs_gkeep_sync --help START -->\n\n<details>\n <summary><tt>fs_gkeep_sync --help</tt></summary>\n\n```\nUsage: fs_gkeep_sync [OPTIONS]\n\n  Synchronize Notes from your Google Keep with text files in a directory on\n  your filesystem.\n\n  You can only synchronize a subset of your Google Keep notes based on a set\n  of provided labels and you can specify where to create the files by\n  specifying the path to a local directory. If you don\'t specify Google Keep\n  Labels it will synchronize all your Google Keep notes.\n\n  For each Google Keep Note, fs_gkeep_sync will create a corresponding file\n  under the specified root directory with a matching name. Any addition,\n  deletion and modification of the files on the filesystem will result in the\n  corresponding addition, deletion and modification of the corresponding\n  Google Keep item. The same holds the other way around.\n\nOptions:\n  -k, --gkeep-labels TEXT         Google Keep labels whose notes to\n                                  synchronize\n  -i, --gkeep-ignore-labels TEXT  Google Keep labels whose notes will be\n                                  explicitly ignored\n  --user, --user-pass-path TEXT   Path in the UNIX password manager to fetch\n                                  the Google username from\n  --passwd, --passwd-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n                                  the Google password from\n  --token, --token-pass-path TEXT\n                                  Path in the UNIX password manager to fetch\n                                  the google keep token from\n  --ext, --filename-extension TEXT\n                                  Use this extension for locally created files\n  --fs, --fs-root TEXT            Directory to consider as root for\n                                  synchronization operations\n  --list-combinations             List the available named Filesystem<->Google\n                                  Keep combinations\n  -r, --resolution-strategy [MostRecentRS|LeastRecentRS|AlwaysFirstRS|AlwaysSecondRS]\n                                  Resolution strategy to use during conflicts\n  -b, --combination TEXT          Name of an already saved Filesystem<->Google\n                                  Keep combination\n  -s, --save-as TEXT              Save the given Filesystem<->Google Keep\n                                  filters combination using a specified custom\n                                  name.\n  -v, --verbose\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n</details>\n\n<!-- END sniff-and-replace -->\n\n## Mechanics / Automatic synchronization\n\nTo achieve synchronization between two arbitrary services, we use a push-pull\nmechanism which is far easier and less troublesome than an automatic\nsynchronization solution. This means that you have to explicitly call the\nexecutable for the synchronization you want to achieve. If you want to automate\nthis, consider adding a `cron` job or a `systemd` timer.\n\n```sh\ncrontab -e\n...\n\n# Add the following to sync every 10\' - modify the arguments according to your\n# preferences and according to the instructions of the corresponding executable\n# for example for `tw_gcal_sync`:\n#\n# See output and potential errors in your system logs (e.g., `/var/log/syslog`)\n*/10 * * * * tw_gcal_sync -c "TW Reminders" -t "remindme"\n```\n\n## FAQ\n\n<details>\n  <summary>How do I reset the synchronization and start it from scratch?</summary>\n\n1. Remove the combination file that corresponds to your synchronization. For\n   example, if you\'re executing synchronization of `Google Keep` with\n   `Taskwarrior`, like the following, your combination name is\n   `testnote__None__test_tag`.\n\n   ```sh\n   tw_gkeep_sync -t test_tag -k "testnote"\n   ```\n\n   The executable also mentions the combination name at the end of the run.\n\n   ```\n   ...\n   14:00:03.41 | INFO      | Flushing data to remote Google Keep...\n   14:00:04.32 | SUCCESS   | Sync completed successfully. You can now use the -b/--combination option to refer to this particular combination\n\n     tw_gkeep_sync --combination testnote__None__test_tag\n   ```\n\n   For this combination, on Linux, remove\n   `~/.config/syncall/testnote__None__test_tag.yaml`.\n\n1. Remove the section for your combination in the `<sideA_sideB_configs.yaml>`\n   configuration file under the `~/.config/syncall/` directory.\n\n   This section will have the same name as the combination file deleted in the\n   earlier step and will look like this:\n\n   ```yaml\n   ---\n   testnote__None__test_tag:\n     gkeep_note: testnote\n     tw_project: null\n     tw_tags: !!python/tuple\n       - test_tag\n   ```\n\n1. Remove the items of one of the sides. Keep e.g. the items from the Google Keep\n   note and delete the tasks of the tag/project you are using for\n   synchronization.\n1. Rerun synchronization from scratch to populate the one side with the items of\n   the other side.\n\n</details>\n\n<details>\n  <summary>I want to synchronize more than a single (Notion page / TW filter),  (Google Calendar / TW filter) etc. combination.</summary>\n\nSee <a\nhref="https://github.com/bergercookie/syncall/blob/master/combinations.md">combinations.md</a>.\n\n</details>\n\n## Tab Completion\n\nAll synchronization executables support tab auto-completion for their options\nfor `bash`, `zsh` and `fish`. You can find them under `completions/`\n\n## Miscellaneous\n\n- [Implement a New Synchronization Service](implement-a-new-synchronization.md)\n- [Using Multiple Combinations](combinations.md)\n- [Contributing Guide](CONTRIBUTING.md)\n\n## Self Promotion\n\nIf you find this tool useful, please [star it on\nGithub](https://github.com/bergercookie/syncall)\n\n## TODO List\n\nSee [ISSUES list](https://github.com/bergercookie/syncall/issues) for\nthe things that I\'m currently either working on or interested in implementing in\nthe near future. In case there\'s something you are interesting in working on,\ndon\'t hesitate to either ask for clarifications or just do it and directly make\na PR.\n',
    'author': 'Nikos Koukis',
    'author_email': 'nickkouk@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/bergercookie/syncall',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
