///////////////////////////////////////////////////////////////
//Pyxie game engine
//
//  Copyright Kiharu Shishikura 2019. All rights reserved.
///////////////////////////////////////////////////////////////
#pragma once

typedef unsigned int FrameBufferHandle;
typedef unsigned int ColorBufferHandle;
typedef unsigned int DepthBufferHandle;

#include "pyxieResource.h"
namespace pyxie
{
	class pyxieTexture;
		
	enum RenderBufferQuarity
	{
		QuarityLow,
		QuarityHigh
	};

	class PYXIE_EXPORT pyxieRenderTarget : public pyxieResource
	{
		FrameBufferHandle frameBufferHandle;
		ColorBufferHandle colorBufferHandle;
		DepthBufferHandle depthBufferHandle;
		DepthBufferHandle stencilBufferHandle;
		pyxieTexture* colorTexture;
		pyxieTexture* depthTexture;
		uint32_t	width;
		uint32_t	height;
		bool useStencilBuffer;
		bool useDepthBuffer;
		//bool useColorAlpha;
		float scissorX;
		float scissorY;
		float scissorW;
		float scissorH;
	public:

		///useColor         J[obt@g
		///useDepth         fvXobt@g
		///useStencil       XeVobt@g
		//pyxieRenderTarget(uint32_t w, uint32_t h, bool useColor, bool useDepth, bool useStencil = false, bool useColorAlpha = false);
		pyxieRenderTarget(pyxieTexture* colorTex, bool useDepth, bool useStencil = false);
		pyxieRenderTarget(pyxieRenderTarget* org);
		~pyxieRenderTarget();

		void Build();
		void Initialize();
		void Clone(bool afterFinishBuild);
		RESOURCETYPE ResourceType() { return RENDERTARGETTYPE; }

		void Render();

		///J[eNX`擾iuseColor=true̎Lj
		inline pyxieTexture* GetColorTexture(){
			return colorTexture;
		}

		///fvXeNX`擾iuseDepth=trueAuseDepthTexture=trueAuseStencil=false̎Lj
		inline pyxieTexture* GetDepthTexture(){
			return depthTexture;
		}

		///sNZC[W[h
		bool ReadColorBufferImage(unsigned char* ptr);

		inline uint32_t GetWidth() { return width; }
		inline uint32_t GetHeight() { return height; }

		inline FrameBufferHandle GetFrameBufferHandle(){
			return frameBufferHandle;
		}

		///r[|[g̃VUOGAݒ肷
		///(0,0)
		///A(1,1)
		inline void SetScissorArea(float x, float y, float w, float h){
			scissorX = x;
			scissorY = y;
			scissorW = w;
			scissorH = h;
		}

#if defined __ENABLE_SUSPEND_RECOVER__
		virtual bool Restore();
		virtual bool Release();
#endif
	};
}