# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulpcore.configuration import Configuration


class PulpExport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'task': 'str',
        'full': 'bool',
        'dry_run': 'bool',
        'versions': 'list[str]',
        'chunk_size': 'str',
        'start_versions': 'list[str]'
    }

    attribute_map = {
        'task': 'task',
        'full': 'full',
        'dry_run': 'dry_run',
        'versions': 'versions',
        'chunk_size': 'chunk_size',
        'start_versions': 'start_versions'
    }

    def __init__(self, task=None, full=True, dry_run=False, versions=None, chunk_size=None, start_versions=None, local_vars_configuration=None):  # noqa: E501
        """PulpExport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._task = None
        self._full = None
        self._dry_run = None
        self._versions = None
        self._chunk_size = None
        self._start_versions = None
        self.discriminator = None

        self.task = task
        if full is not None:
            self.full = full
        if dry_run is not None:
            self.dry_run = dry_run
        if versions is not None:
            self.versions = versions
        if chunk_size is not None:
            self.chunk_size = chunk_size
        if start_versions is not None:
            self.start_versions = start_versions

    @property
    def task(self):
        """Gets the task of this PulpExport.  # noqa: E501

        A URI of the task that ran the Export.  # noqa: E501

        :return: The task of this PulpExport.  # noqa: E501
        :rtype: str
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this PulpExport.

        A URI of the task that ran the Export.  # noqa: E501

        :param task: The task of this PulpExport.  # noqa: E501
        :type: str
        """

        self._task = task

    @property
    def full(self):
        """Gets the full of this PulpExport.  # noqa: E501

        Do a Full (true) or Incremental (false) export.  # noqa: E501

        :return: The full of this PulpExport.  # noqa: E501
        :rtype: bool
        """
        return self._full

    @full.setter
    def full(self, full):
        """Sets the full of this PulpExport.

        Do a Full (true) or Incremental (false) export.  # noqa: E501

        :param full: The full of this PulpExport.  # noqa: E501
        :type: bool
        """

        self._full = full

    @property
    def dry_run(self):
        """Gets the dry_run of this PulpExport.  # noqa: E501

        Generate report on what would be exported and disk-space required.  # noqa: E501

        :return: The dry_run of this PulpExport.  # noqa: E501
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """Sets the dry_run of this PulpExport.

        Generate report on what would be exported and disk-space required.  # noqa: E501

        :param dry_run: The dry_run of this PulpExport.  # noqa: E501
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def versions(self):
        """Gets the versions of this PulpExport.  # noqa: E501

        List of explicit repo-version hrefs to export (replaces current_version).  # noqa: E501

        :return: The versions of this PulpExport.  # noqa: E501
        :rtype: list[str]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """Sets the versions of this PulpExport.

        List of explicit repo-version hrefs to export (replaces current_version).  # noqa: E501

        :param versions: The versions of this PulpExport.  # noqa: E501
        :type: list[str]
        """

        self._versions = versions

    @property
    def chunk_size(self):
        """Gets the chunk_size of this PulpExport.  # noqa: E501

        Chunk export-tarfile into pieces of chunk_size bytes. Recognizes units of B/KB/MB/GB/TB. A chunk has a maximum size of 1TB.  # noqa: E501

        :return: The chunk_size of this PulpExport.  # noqa: E501
        :rtype: str
        """
        return self._chunk_size

    @chunk_size.setter
    def chunk_size(self, chunk_size):
        """Sets the chunk_size of this PulpExport.

        Chunk export-tarfile into pieces of chunk_size bytes. Recognizes units of B/KB/MB/GB/TB. A chunk has a maximum size of 1TB.  # noqa: E501

        :param chunk_size: The chunk_size of this PulpExport.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                chunk_size is not None and len(chunk_size) < 1):
            raise ValueError("Invalid value for `chunk_size`, length must be greater than or equal to `1`")  # noqa: E501

        self._chunk_size = chunk_size

    @property
    def start_versions(self):
        """Gets the start_versions of this PulpExport.  # noqa: E501

        List of explicit last-exported-repo-version hrefs (replaces last_export).  # noqa: E501

        :return: The start_versions of this PulpExport.  # noqa: E501
        :rtype: list[str]
        """
        return self._start_versions

    @start_versions.setter
    def start_versions(self, start_versions):
        """Sets the start_versions of this PulpExport.

        List of explicit last-exported-repo-version hrefs (replaces last_export).  # noqa: E501

        :param start_versions: The start_versions of this PulpExport.  # noqa: E501
        :type: list[str]
        """

        self._start_versions = start_versions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PulpExport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PulpExport):
            return True

        return self.to_dict() != other.to_dict()
