# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulpcore.configuration import Configuration


class PatchedPulpImporter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'repo_mapping': 'dict(str, str)'
    }

    attribute_map = {
        'name': 'name',
        'repo_mapping': 'repo_mapping'
    }

    def __init__(self, name=None, repo_mapping=None, local_vars_configuration=None):  # noqa: E501
        """PatchedPulpImporter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._repo_mapping = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if repo_mapping is not None:
            self.repo_mapping = repo_mapping

    @property
    def name(self):
        """Gets the name of this PatchedPulpImporter.  # noqa: E501

        Unique name of the Importer.  # noqa: E501

        :return: The name of this PatchedPulpImporter.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PatchedPulpImporter.

        Unique name of the Importer.  # noqa: E501

        :param name: The name of this PatchedPulpImporter.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def repo_mapping(self):
        """Gets the repo_mapping of this PatchedPulpImporter.  # noqa: E501

        Mapping of repo names in an export file to the repo names in Pulp. For example, if the export has a repo named 'foo' and the repo to import content into was 'bar', the mapping would be \"{'foo': 'bar'}\".  # noqa: E501

        :return: The repo_mapping of this PatchedPulpImporter.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._repo_mapping

    @repo_mapping.setter
    def repo_mapping(self, repo_mapping):
        """Sets the repo_mapping of this PatchedPulpImporter.

        Mapping of repo names in an export file to the repo names in Pulp. For example, if the export has a repo named 'foo' and the repo to import content into was 'bar', the mapping would be \"{'foo': 'bar'}\".  # noqa: E501

        :param repo_mapping: The repo_mapping of this PatchedPulpImporter.  # noqa: E501
        :type: dict(str, str)
        """

        self._repo_mapping = repo_mapping

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchedPulpImporter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchedPulpImporter):
            return True

        return self.to_dict() != other.to_dict()
