# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulpcore.configuration import Configuration


class OrphansCleanup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'content_hrefs': 'list[object]',
        'orphan_protection_time': 'int'
    }

    attribute_map = {
        'content_hrefs': 'content_hrefs',
        'orphan_protection_time': 'orphan_protection_time'
    }

    def __init__(self, content_hrefs=None, orphan_protection_time=0, local_vars_configuration=None):  # noqa: E501
        """OrphansCleanup - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._content_hrefs = None
        self._orphan_protection_time = None
        self.discriminator = None

        if content_hrefs is not None:
            self.content_hrefs = content_hrefs
        self.orphan_protection_time = orphan_protection_time

    @property
    def content_hrefs(self):
        """Gets the content_hrefs of this OrphansCleanup.  # noqa: E501

        Will delete specified content and associated Artifacts if they are orphans.  # noqa: E501

        :return: The content_hrefs of this OrphansCleanup.  # noqa: E501
        :rtype: list[object]
        """
        return self._content_hrefs

    @content_hrefs.setter
    def content_hrefs(self, content_hrefs):
        """Sets the content_hrefs of this OrphansCleanup.

        Will delete specified content and associated Artifacts if they are orphans.  # noqa: E501

        :param content_hrefs: The content_hrefs of this OrphansCleanup.  # noqa: E501
        :type: list[object]
        """

        self._content_hrefs = content_hrefs

    @property
    def orphan_protection_time(self):
        """Gets the orphan_protection_time of this OrphansCleanup.  # noqa: E501

        The time in minutes for how long Pulp will hold orphan Content and Artifacts before they become candidates for deletion by this orphan cleanup task. This should ideally be longer than your longest running task otherwise any content created during that task could be cleaned up before the task finishes. If not specified, default is used from settings which is 1440 minutes (24 hours)  # noqa: E501

        :return: The orphan_protection_time of this OrphansCleanup.  # noqa: E501
        :rtype: int
        """
        return self._orphan_protection_time

    @orphan_protection_time.setter
    def orphan_protection_time(self, orphan_protection_time):
        """Sets the orphan_protection_time of this OrphansCleanup.

        The time in minutes for how long Pulp will hold orphan Content and Artifacts before they become candidates for deletion by this orphan cleanup task. This should ideally be longer than your longest running task otherwise any content created during that task could be cleaned up before the task finishes. If not specified, default is used from settings which is 1440 minutes (24 hours)  # noqa: E501

        :param orphan_protection_time: The orphan_protection_time of this OrphansCleanup.  # noqa: E501
        :type: int
        """

        self._orphan_protection_time = orphan_protection_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrphansCleanup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrphansCleanup):
            return True

        return self.to_dict() != other.to_dict()
