# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulpcore.api_client import ApiClient
from pulpcore.client.pulpcore.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TasksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_role(self, task_href, nested_role, **kwargs):  # noqa: E501
        """add_role  # noqa: E501

        Add a role for this object to users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role(task_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param NestedRole nested_role: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NestedRoleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_with_http_info(task_href, nested_role, **kwargs)  # noqa: E501

    def add_role_with_http_info(self, task_href, nested_role, **kwargs):  # noqa: E501
        """add_role  # noqa: E501

        Add a role for this object to users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_with_http_info(task_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param NestedRole nested_role: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NestedRoleResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'nested_role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `add_role`")  # noqa: E501
        # verify the required parameter 'nested_role' is set
        if self.api_client.client_side_validation and ('nested_role' not in local_var_params or  # noqa: E501
                                                        local_var_params['nested_role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `nested_role` when calling `add_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nested_role' in local_var_params:
            body_params = local_var_params['nested_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}add_role/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NestedRoleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, task_href, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(task_href, **kwargs)  # noqa: E501

    def delete_with_http_info(self, task_href, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List tasks  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str child_tasks: Foreign Key referenced by HREF
        :param str created_resources:
        :param datetime finished_at: ISO 8601 formatted dates are supported
        :param datetime finished_at__gt: Filter results where finished_at is greater than value
        :param datetime finished_at__gte: Filter results where finished_at is greater than or equal to value
        :param datetime finished_at__lt: Filter results where finished_at is less than value
        :param datetime finished_at__lte: Filter results where finished_at is less than or equal to value
        :param list[datetime] finished_at__range: Filter results where finished_at is between two comma separated values
        :param int limit: Number of results to return per page.
        :param str logging_cid:
        :param str logging_cid__contains: Filter results where logging_cid contains value
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str parent_task: Foreign Key referenced by HREF
        :param list[str] reserved_resources_record:
        :param datetime started_at: ISO 8601 formatted dates are supported
        :param datetime started_at__gt: Filter results where started_at is greater than value
        :param datetime started_at__gte: Filter results where started_at is greater than or equal to value
        :param datetime started_at__lt: Filter results where started_at is less than value
        :param datetime started_at__lte: Filter results where started_at is less than or equal to value
        :param list[datetime] started_at__range: Filter results where started_at is between two comma separated values
        :param str state:
        :param list[str] state__in: Filter results where state is in a comma-separated list of values
        :param str task_group: Foreign Key referenced by HREF
        :param str worker: Foreign Key referenced by HREF
        :param list[str] worker__in: Filter results where worker is in a comma-separated list of values
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedTaskResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(**kwargs)  # noqa: E501

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List tasks  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str child_tasks: Foreign Key referenced by HREF
        :param str created_resources:
        :param datetime finished_at: ISO 8601 formatted dates are supported
        :param datetime finished_at__gt: Filter results where finished_at is greater than value
        :param datetime finished_at__gte: Filter results where finished_at is greater than or equal to value
        :param datetime finished_at__lt: Filter results where finished_at is less than value
        :param datetime finished_at__lte: Filter results where finished_at is less than or equal to value
        :param list[datetime] finished_at__range: Filter results where finished_at is between two comma separated values
        :param int limit: Number of results to return per page.
        :param str logging_cid:
        :param str logging_cid__contains: Filter results where logging_cid contains value
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str parent_task: Foreign Key referenced by HREF
        :param list[str] reserved_resources_record:
        :param datetime started_at: ISO 8601 formatted dates are supported
        :param datetime started_at__gt: Filter results where started_at is greater than value
        :param datetime started_at__gte: Filter results where started_at is greater than or equal to value
        :param datetime started_at__lt: Filter results where started_at is less than value
        :param datetime started_at__lte: Filter results where started_at is less than or equal to value
        :param list[datetime] started_at__range: Filter results where started_at is between two comma separated values
        :param str state:
        :param list[str] state__in: Filter results where state is in a comma-separated list of values
        :param str task_group: Foreign Key referenced by HREF
        :param str worker: Foreign Key referenced by HREF
        :param list[str] worker__in: Filter results where worker is in a comma-separated list of values
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedTaskResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'child_tasks',
            'created_resources',
            'finished_at',
            'finished_at__gt',
            'finished_at__gte',
            'finished_at__lt',
            'finished_at__lte',
            'finished_at__range',
            'limit',
            'logging_cid',
            'logging_cid__contains',
            'name',
            'name__contains',
            'offset',
            'ordering',
            'parent_task',
            'reserved_resources_record',
            'started_at',
            'started_at__gt',
            'started_at__gte',
            'started_at__lt',
            'started_at__lte',
            'started_at__range',
            'state',
            'state__in',
            'task_group',
            'worker',
            'worker__in',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'child_tasks' in local_var_params and local_var_params['child_tasks'] is not None:  # noqa: E501
            query_params.append(('child_tasks', local_var_params['child_tasks']))  # noqa: E501
        if 'created_resources' in local_var_params and local_var_params['created_resources'] is not None:  # noqa: E501
            query_params.append(('created_resources', local_var_params['created_resources']))  # noqa: E501
        if 'finished_at' in local_var_params and local_var_params['finished_at'] is not None:  # noqa: E501
            query_params.append(('finished_at', local_var_params['finished_at']))  # noqa: E501
        if 'finished_at__gt' in local_var_params and local_var_params['finished_at__gt'] is not None:  # noqa: E501
            query_params.append(('finished_at__gt', local_var_params['finished_at__gt']))  # noqa: E501
        if 'finished_at__gte' in local_var_params and local_var_params['finished_at__gte'] is not None:  # noqa: E501
            query_params.append(('finished_at__gte', local_var_params['finished_at__gte']))  # noqa: E501
        if 'finished_at__lt' in local_var_params and local_var_params['finished_at__lt'] is not None:  # noqa: E501
            query_params.append(('finished_at__lt', local_var_params['finished_at__lt']))  # noqa: E501
        if 'finished_at__lte' in local_var_params and local_var_params['finished_at__lte'] is not None:  # noqa: E501
            query_params.append(('finished_at__lte', local_var_params['finished_at__lte']))  # noqa: E501
        if 'finished_at__range' in local_var_params and local_var_params['finished_at__range'] is not None:  # noqa: E501
            query_params.append(('finished_at__range', local_var_params['finished_at__range']))  # noqa: E501
            collection_formats['finished_at__range'] = 'csv'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'logging_cid' in local_var_params and local_var_params['logging_cid'] is not None:  # noqa: E501
            query_params.append(('logging_cid', local_var_params['logging_cid']))  # noqa: E501
        if 'logging_cid__contains' in local_var_params and local_var_params['logging_cid__contains'] is not None:  # noqa: E501
            query_params.append(('logging_cid__contains', local_var_params['logging_cid__contains']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
        if 'parent_task' in local_var_params and local_var_params['parent_task'] is not None:  # noqa: E501
            query_params.append(('parent_task', local_var_params['parent_task']))  # noqa: E501
        if 'reserved_resources_record' in local_var_params and local_var_params['reserved_resources_record'] is not None:  # noqa: E501
            query_params.append(('reserved_resources_record', local_var_params['reserved_resources_record']))  # noqa: E501
            collection_formats['reserved_resources_record'] = 'multi'  # noqa: E501
        if 'started_at' in local_var_params and local_var_params['started_at'] is not None:  # noqa: E501
            query_params.append(('started_at', local_var_params['started_at']))  # noqa: E501
        if 'started_at__gt' in local_var_params and local_var_params['started_at__gt'] is not None:  # noqa: E501
            query_params.append(('started_at__gt', local_var_params['started_at__gt']))  # noqa: E501
        if 'started_at__gte' in local_var_params and local_var_params['started_at__gte'] is not None:  # noqa: E501
            query_params.append(('started_at__gte', local_var_params['started_at__gte']))  # noqa: E501
        if 'started_at__lt' in local_var_params and local_var_params['started_at__lt'] is not None:  # noqa: E501
            query_params.append(('started_at__lt', local_var_params['started_at__lt']))  # noqa: E501
        if 'started_at__lte' in local_var_params and local_var_params['started_at__lte'] is not None:  # noqa: E501
            query_params.append(('started_at__lte', local_var_params['started_at__lte']))  # noqa: E501
        if 'started_at__range' in local_var_params and local_var_params['started_at__range'] is not None:  # noqa: E501
            query_params.append(('started_at__range', local_var_params['started_at__range']))  # noqa: E501
            collection_formats['started_at__range'] = 'csv'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'state__in' in local_var_params and local_var_params['state__in'] is not None:  # noqa: E501
            query_params.append(('state__in', local_var_params['state__in']))  # noqa: E501
            collection_formats['state__in'] = 'csv'  # noqa: E501
        if 'task_group' in local_var_params and local_var_params['task_group'] is not None:  # noqa: E501
            query_params.append(('task_group', local_var_params['task_group']))  # noqa: E501
        if 'worker' in local_var_params and local_var_params['worker'] is not None:  # noqa: E501
            query_params.append(('worker', local_var_params['worker']))  # noqa: E501
        if 'worker__in' in local_var_params and local_var_params['worker__in'] is not None:  # noqa: E501
            query_params.append(('worker__in', local_var_params['worker__in']))  # noqa: E501
            collection_formats['worker__in'] = 'csv'  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/tasks/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedTaskResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_roles(self, task_href, **kwargs):  # noqa: E501
        """list_roles  # noqa: E501

        List roles assigned to this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ObjectRolesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_roles_with_http_info(task_href, **kwargs)  # noqa: E501

    def list_roles_with_http_info(self, task_href, **kwargs):  # noqa: E501
        """list_roles  # noqa: E501

        List roles assigned to this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles_with_http_info(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ObjectRolesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `list_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}list_roles/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ObjectRolesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def my_permissions(self, task_href, **kwargs):  # noqa: E501
        """my_permissions  # noqa: E501

        List permissions available to the current user on this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.my_permissions(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MyPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.my_permissions_with_http_info(task_href, **kwargs)  # noqa: E501

    def my_permissions_with_http_info(self, task_href, **kwargs):  # noqa: E501
        """my_permissions  # noqa: E501

        List permissions available to the current user on this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.my_permissions_with_http_info(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MyPermissionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method my_permissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `my_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}my_permissions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MyPermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def purge(self, purge, **kwargs):  # noqa: E501
        """Purge Completed Tasks  # noqa: E501

        Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp (tech-preview, may change in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge(purge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Purge purge: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.purge_with_http_info(purge, **kwargs)  # noqa: E501

    def purge_with_http_info(self, purge, **kwargs):  # noqa: E501
        """Purge Completed Tasks  # noqa: E501

        Trigger an asynchronous task that deletes completed tasks that finished prior to a specified timestamp (tech-preview, may change in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge_with_http_info(purge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Purge purge: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'purge'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method purge" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'purge' is set
        if self.api_client.client_side_validation and ('purge' not in local_var_params or  # noqa: E501
                                                        local_var_params['purge'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `purge` when calling `purge`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'purge' in local_var_params:
            body_params = local_var_params['purge']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/tasks/purge/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, task_href, **kwargs):  # noqa: E501
        """Inspect a task  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(task_href, **kwargs)  # noqa: E501

    def read_with_http_info(self, task_href, **kwargs):  # noqa: E501
        """Inspect a task  # noqa: E501

        A customized named ModelViewSet that knows how to register itself with the Pulp API router.  This viewset is discoverable by its name. \"Normal\" Django Models and Master/Detail models are supported by the ``register_with`` method.  Attributes:     lookup_field (str): The name of the field by which an object should be looked up, in         addition to any parent lookups if this ViewSet is nested. Defaults to 'pk'     endpoint_name (str): The name of the final path segment that should identify the ViewSet's         collection endpoint.     nest_prefix (str): Optional prefix under which this ViewSet should be nested. This must         correspond to the \"parent_prefix\" of a router with rest_framework_nested.NestedMixin.         None indicates this ViewSet should not be nested.     parent_lookup_kwargs (dict): Optional mapping of key names that would appear in self.kwargs         to django model filter expressions that can be used with the corresponding value from         self.kwargs, used only by a nested ViewSet to filter based on the parent object's         identity.     schema (DefaultSchema): The schema class to use by default in a viewset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(task_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_role(self, task_href, nested_role, **kwargs):  # noqa: E501
        """remove_role  # noqa: E501

        Remove a role for this object from users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_role(task_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param NestedRole nested_role: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NestedRoleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_role_with_http_info(task_href, nested_role, **kwargs)  # noqa: E501

    def remove_role_with_http_info(self, task_href, nested_role, **kwargs):  # noqa: E501
        """remove_role  # noqa: E501

        Remove a role for this object from users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_role_with_http_info(task_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param NestedRole nested_role: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NestedRoleResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'nested_role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `remove_role`")  # noqa: E501
        # verify the required parameter 'nested_role' is set
        if self.api_client.client_side_validation and ('nested_role' not in local_var_params or  # noqa: E501
                                                        local_var_params['nested_role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `nested_role` when calling `remove_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nested_role' in local_var_params:
            body_params = local_var_params['nested_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}remove_role/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NestedRoleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tasks_cancel(self, task_href, patched_task_cancel, **kwargs):  # noqa: E501
        """Cancel a task  # noqa: E501

        This operation cancels a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tasks_cancel(task_href, patched_task_cancel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param PatchedTaskCancel patched_task_cancel: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tasks_cancel_with_http_info(task_href, patched_task_cancel, **kwargs)  # noqa: E501

    def tasks_cancel_with_http_info(self, task_href, patched_task_cancel, **kwargs):  # noqa: E501
        """Cancel a task  # noqa: E501

        This operation cancels a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tasks_cancel_with_http_info(task_href, patched_task_cancel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_href: (required)
        :param PatchedTaskCancel patched_task_cancel: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_href',
            'patched_task_cancel'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tasks_cancel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_href' is set
        if self.api_client.client_side_validation and ('task_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_href` when calling `tasks_cancel`")  # noqa: E501
        # verify the required parameter 'patched_task_cancel' is set
        if self.api_client.client_side_validation and ('patched_task_cancel' not in local_var_params or  # noqa: E501
                                                        local_var_params['patched_task_cancel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patched_task_cancel` when calling `tasks_cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_href' in local_var_params:
            path_params['task_href'] = local_var_params['task_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patched_task_cancel' in local_var_params:
            body_params = local_var_params['patched_task_cancel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{task_href}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
