from typing import Any, cast, Dict, List, Optional, Type, TypeVar, Union

import attr

from ..extensions import NotPresentError
from ..types import UNSET, Unset

T = TypeVar("T", bound="DatasetManifestManifestItem")


@attr.s(auto_attribs=True, repr=False)
class DatasetManifestManifestItem:
    """ List of files composing a dataset, their names, and their corresponding URLs. """

    _name: Union[Unset, str] = UNSET
    _url: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def __repr__(self):
        fields = []
        fields.append("name={}".format(repr(self._name)))
        fields.append("url={}".format(repr(self._url)))
        fields.append("additional_properties={}".format(repr(self.additional_properties)))
        return "DatasetManifestManifestItem({})".format(", ".join(fields))

    def to_dict(self) -> Dict[str, Any]:
        name = self._name
        url = self._url

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        # Allow the model to serialize even if it was created outside of the constructor, circumventing validation
        if name is not UNSET:
            field_dict["name"] = name
        if url is not UNSET:
            field_dict["url"] = url

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any], strict: bool = False) -> T:
        d = src_dict.copy()

        def get_name() -> Union[Unset, str]:
            name = d.pop("name")
            return name

        try:
            name = get_name()
        except KeyError:
            if strict:
                raise
            name = cast(Union[Unset, str], UNSET)

        def get_url() -> Union[Unset, str]:
            url = d.pop("url")
            return url

        try:
            url = get_url()
        except KeyError:
            if strict:
                raise
            url = cast(Union[Unset, str], UNSET)

        dataset_manifest_manifest_item = cls(
            name=name,
            url=url,
        )

        dataset_manifest_manifest_item.additional_properties = d
        return dataset_manifest_manifest_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties

    def get(self, key, default=None) -> Optional[Any]:
        return self.additional_properties.get(key, default)

    @property
    def name(self) -> str:
        if isinstance(self._name, Unset):
            raise NotPresentError(self, "name")
        return self._name

    @name.setter
    def name(self, value: str) -> None:
        self._name = value

    @name.deleter
    def name(self) -> None:
        self._name = UNSET

    @property
    def url(self) -> str:
        if isinstance(self._url, Unset):
            raise NotPresentError(self, "url")
        return self._url

    @url.setter
    def url(self, value: str) -> None:
        self._url = value

    @url.deleter
    def url(self) -> None:
        self._url = UNSET
