"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const component_1 = require("../component");
const file_1 = require("../file");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const source_code_1 = require("../source-code");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
/**
 * React project without TypeScript.
 *
 * @pjid react
 */
class ReactProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            jest: false,
            ...options,
        });
        this.srcdir = options.srcdir ?? "src";
        new ReactComponent(this, { typescript: false, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new ReactSampleCode(this, {
                fileExt: "jsx",
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, "public", {
                sourceDir: path.join(__dirname, "..", "..", "assets", "web", "react"),
            });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.67.2" };
/**
 * React project with TypeScript.
 *
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        const defaultOptions = {
            srcdir: "src",
            eslint: true,
            jest: false,
            tsconfig: {
                include: ["src"],
                compilerOptions: {
                    target: "es5",
                    lib: ["dom", "dom.iterable", "esnext"],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: "commonjs",
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: javascript_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: options.typescriptVersion ?? "^4.0.3",
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([
            defaultOptions,
            options,
            { sampleCode: false },
        ]));
        this.srcdir = options.srcdir ?? "src";
        this.eslint?.addRules({
            "import/no-extraneous-dependencies": [
                "error",
                {
                    devDependencies: ["**/src/**/*.test.tsx", "**/src/setupTests.ts"],
                    optionalDependencies: false,
                    peerDependencies: true,
                },
            ],
        });
        new ReactComponent(this, { typescript: true, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new ReactSampleCode(this, {
                fileExt: "tsx",
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, "public", {
                sourceDir: path.join(__dirname, "..", "..", "assets", "web", "react"),
            });
        }
        this.package.addPackageResolutions(
        // https://github.com/DefinitelyTyped/DefinitelyTyped/issues/62300
        "@types/express@4.17.13", "@types/express-serve-static-core@4.17.30");
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.67.2" };
class ReactComponent extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.typescript = options.typescript ?? false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps("react", "react-dom", "react-scripts@^5", "web-vitals");
        project.addDevDeps("@testing-library/jest-dom", "@testing-library/react", "@testing-library/user-event");
        if (this.typescript) {
            project.addDevDeps("@types/jest", "@types/react", "@types/react-dom");
        }
        const rewire = options.rewire ?? false;
        if (rewire) {
            const overridesPath = ".projen/react-config-overrides.js";
            project.addDevDeps("react-app-rewired");
            project.addFields({ "config-overrides-path": overridesPath });
            const configOverrides = new source_code_1.SourceCode(this.project, overridesPath);
            if (!configOverrides.marker) {
                configOverrides.line(`// ${configOverrides.marker}`);
            }
            configOverrides.line("/**");
            configOverrides.line(" * Override CRA configuration without needing to eject.");
            configOverrides.line(" *");
            configOverrides.line(" * @see https://www.npmjs.com/package/react-app-rewired");
            configOverrides.line(" */");
            configOverrides.open("module.exports = function override(config, env) {");
            for (const [key, value] of Object.entries(rewire)) {
                configOverrides.line(`config.${key} = ${JSON.stringify(value)};`);
            }
            configOverrides.line("return config;");
            configOverrides.close("};");
        }
        const reactScripts = rewire ? "react-app-rewired" : "react-scripts";
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask("dev", {
            description: "Starts the react application",
            exec: `${reactScripts} start`,
        });
        project.compileTask.exec(`${reactScripts} build`);
        project.testTask.exec(`${reactScripts} test --watchAll=false`);
        const testWatch = project.tasks.tryFind("test:watch");
        testWatch?.reset(`${reactScripts} test`);
        project.npmignore?.exclude("# Build", "/build/");
        project.gitignore.exclude("# Build", "/build/");
        project.package.addField("eslintConfig", {
            extends: ["react-app", "react-app/jest"],
        });
        project.package.addField("browserslist", {
            production: [">0.2%", "not dead", "not op_mini all"],
            development: [
                "last 1 chrome version",
                "last 1 firefox version",
                "last 1 safari version",
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.67.2" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.fileExt = options.fileExt ?? "jsx";
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            "    </g>",
            "</svg>",
            "",
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            "",
            "function App() {",
            "  return (",
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            "        <p>",
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            "        </p>",
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            "        >",
            "          Learn React",
            "        </a>",
            "      </header>",
            "    </div>",
            "  );",
            "}",
            "",
            "export default App;",
            "",
        ];
        const appCss = [
            ".App {",
            "  text-align: center;",
            "}",
            "",
            ".App-logo {",
            "  height: 40vmin;",
            "  pointer-events: none;",
            "}",
            "",
            "@media (prefers-reduced-motion: no-preference) {",
            "  .App-logo {",
            "    animation: App-logo-spin infinite 20s linear;",
            "  }",
            "}",
            "",
            ".App-header {",
            "  background-color: #282c34;",
            "  min-height: 100vh;",
            "  display: flex;",
            "  flex-direction: column;",
            "  align-items: center;",
            "  justify-content: center;",
            "  font-size: calc(10px + 2vmin);",
            "  color: white;",
            "}",
            "",
            ".App-link {",
            "  color: #61dafb;",
            "}",
            "",
            "@keyframes App-logo-spin {",
            "  from {",
            "    transform: rotate(0deg);",
            "  }",
            "  to {",
            "    transform: rotate(360deg);",
            "  }",
            "}",
            "",
        ];
        const appTestJsx = [
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            "",
            "test('renders learn react link', () => {",
            "  render(<App />);",
            "  const linkElement = screen.getByText(/learn react/i);",
            "  expect(linkElement).toBeInTheDocument();",
            "});",
            "",
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            "",
            "ReactDOM.render(",
            "  <React.StrictMode>",
            "    <App />",
            "  </React.StrictMode>,",
            "  document.getElementById('root')",
            ");",
            "",
            "// If you want to start measuring performance in your app, pass a function",
            "// to log results (for example: reportWebVitals(console.log))",
            "// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals",
            "reportWebVitals();",
            "",
        ];
        const indexCss = [
            "body {",
            "  margin: 0;",
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            "    sans-serif;",
            "  -webkit-font-smoothing: antialiased;",
            "  -moz-osx-font-smoothing: grayscale;",
            "}",
            "",
            "code {",
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            "    monospace;",
            "}",
            "",
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            "",
            "const reportWebVitals = (onPerfEntry?: ReportHandler) => {",
            "  if (onPerfEntry && onPerfEntry instanceof Function) {",
            "    import('web-vitals').then(",
            "      ({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            "        getCLS(onPerfEntry);",
            "        getFID(onPerfEntry);",
            "        getFCP(onPerfEntry);",
            "        getLCP(onPerfEntry);",
            "        getTTFB(onPerfEntry);",
            "      },",
            "      () => {}",
            "    );",
            "  }",
            "};",
            "",
            "export default reportWebVitals;",
        ];
        const setupTestsJs = [
            "// jest-dom adds custom jest matchers for asserting on DOM nodes.",
            "// allows you to do things like:",
            "// expect(element).toHaveTextContent(/react/i)",
            "// learn more: https://github.com/testing-library/jest-dom",
            "import '@testing-library/jest-dom';",
            "",
        ];
        const reactTypeDef = ['/// <reference types="react-scripts" />'];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace("x", "");
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                "react-app-env.d.ts": reactTypeDef.join("\n"),
                "logo.svg": logoSvg.join("\n"),
                ["App." + this.fileExt]: appJsx.join("\n"),
                ["App.test." + this.fileExt]: appTestJsx.join("\n"),
                "App.css": appCss.join("\n"),
                ["index." + this.fileExt]: indexJsx.join("\n"),
                "index.css": indexCss.join("\n"),
                ["reportWebVitals." + fileExtWithoutX]: reportWebVitalsJs.join("\n"),
                ["setupTests." + fileExtWithoutX]: setupTestsJs.join("\n"),
            },
        });
    }
}
/**
 * @deprecated No longer used.
 */
class ReactTypeDef extends file_1.FileBase {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    synthesizeContent(_) {
        return ['/// <reference types="react-scripts" />'].join("\n");
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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