"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
/**
 * Manages a standard build process for all projects.
 *
 * Build spawns these tasks in order:
 * 1. default
 * 2. pre-compile
 * 3. compile
 * 4. post-compile
 * 5. test
 * 6. package
 */
class ProjectBuild extends component_1.Component {
    constructor(project) {
        super(project);
        this.preCompileTask = project.tasks.addTask("pre-compile", {
            description: "Prepare the project for compilation",
        });
        this.compileTask = project.tasks.addTask("compile", {
            description: "Only compile",
        });
        this.postCompileTask = project.tasks.addTask("post-compile", {
            description: "Runs after successful compilation",
        });
        this.testTask = project.tasks.addTask("test", {
            description: "Run tests",
        });
        this.packageTask = project.tasks.addTask("package", {
            description: "Creates the distribution package",
        });
        this.buildTask = project.tasks.addTask("build", {
            description: "Full release build",
        });
        // if this is not subproject, execute the "default" task which will
        // synthesize project files.
        if (!this.project.parent && this.project.defaultTask) {
            this.buildTask.spawn(this.project.defaultTask);
        }
        this.buildTask.spawn(this.preCompileTask);
        this.buildTask.spawn(this.compileTask);
        this.buildTask.spawn(this.postCompileTask);
        this.buildTask.spawn(this.testTask);
        this.buildTask.spawn(this.packageTask);
        // do not allow additional build phases
        this.buildTask.lock();
    }
}
exports.ProjectBuild = ProjectBuild;
_a = JSII_RTTI_SYMBOL_1;
ProjectBuild[_a] = { fqn: "projen.ProjectBuild", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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