"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Makefile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * Minimal Makefile.
 */
class Makefile extends file_1.FileBase {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
        const all = options.all ? options.all : [];
        const rules = options.rules ? options.rules : [];
        rules.forEach((e) => this.validateRule(e));
        this.all = {
            targets: ["all"],
            prerequisites: all,
            phony: true,
        };
        this.rules = [this.all, ...rules];
    }
    /**
     * Add a target to all
     */
    addAll(target) {
        this.all.prerequisites.push(target);
        return this;
    }
    /**
     * Add multiple targets to all
     */
    addAlls(...targets) {
        targets.forEach((e) => this.addAll(e));
        return this;
    }
    /**
     * Add a rule to the Makefile.
     */
    addRule(rule) {
        this.validateRule(rule);
        this.rules.push(rule);
        return this;
    }
    /**
     * Add multiple rules to the Makefile.
     */
    addRules(...rules) {
        rules.forEach((e) => this.addRule(e));
        return this;
    }
    validateRule(rule) {
        if (!rule.targets || !rule.targets.length) {
            throw new Error('"targets" cannot be undefined or empty for items in "rules"');
        }
    }
    synthesizeContent(resolver) {
        const rules = resolver.resolve(this.rules);
        const lines = [
            ...rules.map((rule) => {
                const targets = rule.targets.join(" ");
                const prerequisites = (rule.prerequisites ? rule.prerequisites : []).join(" ");
                const recipe = rule.recipe ? rule.recipe : [];
                const phony = rule.phony ? [`.PHONY: ${targets}`] : [];
                return [
                    ...phony,
                    `${targets}: ${prerequisites}`.trim(),
                    ...recipe.map((step) => `\t${step}`),
                ].join("\n");
            }),
        ];
        return `${lines.join("\n\n")}\n`;
    }
}
exports.Makefile = Makefile;
_a = JSII_RTTI_SYMBOL_1;
Makefile[_a] = { fqn: "projen.Makefile", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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