"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptConfig = exports.TypeScriptJsxMode = exports.TypeScriptModuleResolution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
/**
 * Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 */
var TypeScriptModuleResolution;
(function (TypeScriptModuleResolution) {
    /**
     * TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     */
    TypeScriptModuleResolution["CLASSIC"] = "classic";
    /**
     * Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     */
    TypeScriptModuleResolution["NODE"] = "node";
})(TypeScriptModuleResolution = exports.TypeScriptModuleResolution || (exports.TypeScriptModuleResolution = {}));
/**
 * Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 */
var TypeScriptJsxMode;
(function (TypeScriptJsxMode) {
    /**
     * Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     */
    TypeScriptJsxMode["PRESERVE"] = "preserve";
    /**
     * Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     */
    TypeScriptJsxMode["REACT"] = "react";
    /**
     * Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     */
    TypeScriptJsxMode["REACT_NATIVE"] = "react-native";
    /**
     * Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     */
    TypeScriptJsxMode["REACT_JSX"] = "react-jsx";
    /**
     * Same as `REACT_JSX` with additional debug data.
     */
    TypeScriptJsxMode["REACT_JSXDEV"] = "react-jsxdev";
})(TypeScriptJsxMode = exports.TypeScriptJsxMode || (exports.TypeScriptJsxMode = {}));
class TypescriptConfig {
    constructor(project, options) {
        const fileName = options.fileName ?? "tsconfig.json";
        this.include = options.include ?? ["**/*.ts"];
        this.exclude = options.exclude ?? ["node_modules"];
        this.fileName = fileName;
        this.compilerOptions = options.compilerOptions;
        this.file = new json_1.JsonFile(project, fileName, {
            obj: {
                compilerOptions: this.compilerOptions,
                include: () => this.include,
                exclude: () => this.exclude,
            },
        });
        project.npmignore?.exclude(`/${fileName}`);
    }
    addInclude(pattern) {
        this.include.push(pattern);
    }
    addExclude(pattern) {
        this.exclude.push(pattern);
    }
}
exports.TypescriptConfig = TypescriptConfig;
_a = JSII_RTTI_SYMBOL_1;
TypescriptConfig[_a] = { fqn: "projen.javascript.TypescriptConfig", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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