"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
const github_1 = require("../github");
const util_1 = require("../util");
/**
 * Java project.
 *
 * @pjid java
 */
class JavaProject extends github_1.GitHubProject {
    constructor(options) {
        super(options);
        this.distdir = options.distdir ?? "dist/java";
        this.pom = new pom_1.Pom(this, options);
        const rcFileTypeOptions = [options.projenrcJava, options.projenrcJson];
        if (util_1.multipleSelected(rcFileTypeOptions)) {
            throw new Error("Only one of projenrcJava and projenrcJson can be selected.");
        }
        // default to projenrc.java if no other projenrc type was elected
        if (options.projenrcJava ?? !util_1.anySelected(rcFileTypeOptions)) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, options.projenrcJavaOptions);
        }
        const sampleJavaPackage = options.sampleJavaPackage ?? "org.acme";
        if (options.junit ?? true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if (options.sample ?? true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty("project.build.sourceEncoding", "UTF-8");
        this.gitignore.exclude(".classpath");
        this.gitignore.exclude(".project");
        this.gitignore.exclude(".settings");
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin("org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3", {
            executions: [{ id: "enforce-maven", goals: ["enforce"] }],
            configuration: {
                rules: [{ requireMavenVersion: [{ version: "3.6" }] }],
            },
        });
        for (const dep of options.deps ?? []) {
            this.addDependency(dep);
        }
        for (const dep of options.testDeps ?? []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`)
     * @param options plugin options
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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