"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
class IgnoreFile extends file_1.FileBase {
    constructor(project, filePath) {
        super(project, filePath, { editGitignore: filePath !== ".gitignore" });
        this._patterns = new Array();
    }
    /**
     * Add ignore patterns. Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param patterns Ignore patterns.
     */
    addPatterns(...patterns) {
        for (const pattern of patterns) {
            // skip comments
            if (pattern.startsWith("#")) {
                continue;
            }
            this.normalizePatterns(pattern);
            this._patterns.push(pattern);
        }
    }
    normalizePatterns(pattern) {
        const opposite = pattern.startsWith("!") ? pattern.slice(1) : "!" + pattern;
        remove(this._patterns, pattern); // prevent duplicates
        remove(this._patterns, opposite);
        if (pattern.endsWith("/")) {
            const prefix = opposite;
            for (const p of [...this._patterns]) {
                if (p.startsWith(prefix)) {
                    remove(this._patterns, p);
                }
            }
        }
    }
    /**
     * Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     */
    removePatterns(...patterns) {
        for (const p of patterns) {
            remove(this._patterns, p);
        }
    }
    /**
     * Ignore the files that match these patterns.
     * @param patterns The patterns to match.
     */
    exclude(...patterns) {
        return this.addPatterns(...patterns);
    }
    /**
     * Always include the specified file patterns.
     * @param patterns Patterns to include in git commits.
     */
    include(...patterns) {
        for (let pattern of patterns) {
            if (!pattern.startsWith("!")) {
                pattern = "!" + pattern;
            }
            this.addPatterns(pattern);
        }
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            ...this._patterns,
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
}
exports.IgnoreFile = IgnoreFile;
_a = JSII_RTTI_SYMBOL_1;
IgnoreFile[_a] = { fqn: "projen.IgnoreFile", version: "0.67.2" };
// O(n) hooray!
function remove(arr, value) {
    const idx = arr.indexOf(value);
    if (idx >= 0) {
        arr.splice(idx, 1);
    }
}
//# sourceMappingURL=data:application/json;base64,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