"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * CDK8S integration test.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("cdk8s-cli")) {
            project.deps.addDependency(`cdk8s-cli`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = path_1.join(this.tmpDir, "deploy.cdk.out");
        const assertDir = path_1.join(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        // Synth, deploy, and capture the snapshot
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk8s synth --app "${app}" -o ${deployDir}`);
        this.deployTask.exec(`kubectl apply -f ${deployDir}`);
        // If deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        // Run a snapshot
        this.snapshotTask.exec(`rm -fr ${this.snapshotDir}`);
        this.snapshotTask.exec(`cdk8s synth --app "${app}" -o ${this.snapshotDir}`);
        // Assert that the snapshot has not changed (run during tests)
        this.assertTask.exec(`cdk8s synth --app "${app}" -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff ${this.snapshotDir}/ ${assertDir}/`);
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.cdk8s.IntegrationTest", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb24tdGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jZGs4cy9pbnRlZ3JhdGlvbi10ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQTRCO0FBQzVCLGdDQUF5RTtBQUN6RSxrREFBaUQ7QUFRakQ7O0dBRUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEseUJBQW1CO0lBQ3RELFlBQVksT0FBZ0IsRUFBRSxPQUErQjtRQUMzRCxLQUFLLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxFQUFFO1lBQy9DLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsRUFBRSw2QkFBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQy9EO1FBRUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLEVBQUU7WUFDN0MsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxFQUFFLDZCQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7U0FDN0Q7UUFFRCxNQUFNLFNBQVMsR0FBRyxXQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ3RELE1BQU0sU0FBUyxHQUFHLFdBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLGdCQUFnQixDQUFDLENBQUM7UUFDdEQsTUFBTSxHQUFHLEdBQUcsY0FBYyxPQUFPLENBQUMsWUFBWSxJQUFJLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUV2RSwwQ0FBMEM7UUFDMUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFFBQVEsU0FBUyxFQUFFLENBQUMsQ0FBQztRQUNuRSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsU0FBUyxFQUFFLENBQUMsQ0FBQztRQUN0RCx3RUFBd0U7UUFDeEUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLFNBQVMsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUU1RCxpQkFBaUI7UUFDakIsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUNyRCxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxRQUFRLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBRTVFLDhEQUE4RDtRQUM5RCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FDbEIsc0JBQXNCLEdBQUcsUUFBUSxTQUFTLGNBQWMsQ0FDekQsQ0FBQztRQUNGLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFFBQVEsSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEdBQUcsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7O0FBakNILDBDQWtDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGpvaW4gfSBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgSW50ZWdyYXRpb25UZXN0QmFzZU9wdGlvbnMsIEludGVncmF0aW9uVGVzdEJhc2UgfSBmcm9tIFwiLi4vY2RrXCI7XG5pbXBvcnQgeyBEZXBlbmRlbmN5VHlwZSB9IGZyb20gXCIuLi9kZXBlbmRlbmNpZXNcIjtcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi4vcHJvamVjdFwiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIEludGVncmF0aW9uVGVzdFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEludGVncmF0aW9uVGVzdE9wdGlvbnMgZXh0ZW5kcyBJbnRlZ3JhdGlvblRlc3RCYXNlT3B0aW9ucyB7fVxuXG4vKipcbiAqIENESzhTIGludGVncmF0aW9uIHRlc3QuXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnRlZ3JhdGlvblRlc3QgZXh0ZW5kcyBJbnRlZ3JhdGlvblRlc3RCYXNlIHtcbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCwgb3B0aW9uczogSW50ZWdyYXRpb25UZXN0T3B0aW9ucykge1xuICAgIHN1cGVyKHByb2plY3QsIG9wdGlvbnMpO1xuXG4gICAgaWYgKCFwcm9qZWN0LmRlcHMudHJ5R2V0RGVwZW5kZW5jeShcImNkazhzLWNsaVwiKSkge1xuICAgICAgcHJvamVjdC5kZXBzLmFkZERlcGVuZGVuY3koYGNkazhzLWNsaWAsIERlcGVuZGVuY3lUeXBlLkJVSUxEKTtcbiAgICB9XG5cbiAgICBpZiAoIXByb2plY3QuZGVwcy50cnlHZXREZXBlbmRlbmN5KFwidHMtbm9kZVwiKSkge1xuICAgICAgcHJvamVjdC5kZXBzLmFkZERlcGVuZGVuY3koXCJ0cy1ub2RlXCIsIERlcGVuZGVuY3lUeXBlLkJVSUxEKTtcbiAgICB9XG5cbiAgICBjb25zdCBkZXBsb3lEaXIgPSBqb2luKHRoaXMudG1wRGlyLCBcImRlcGxveS5jZGsub3V0XCIpO1xuICAgIGNvbnN0IGFzc2VydERpciA9IGpvaW4odGhpcy50bXBEaXIsIFwiYXNzZXJ0LmNkay5vdXRcIik7XG4gICAgY29uc3QgYXBwID0gYHRzLW5vZGUgLVAgJHtvcHRpb25zLnRzY29uZmlnUGF0aH0gJHtvcHRpb25zLmVudHJ5cG9pbnR9YDtcblxuICAgIC8vIFN5bnRoLCBkZXBsb3ksIGFuZCBjYXB0dXJlIHRoZSBzbmFwc2hvdFxuICAgIHRoaXMuZGVwbG95VGFzay5leGVjKGBybSAtZnIgJHtkZXBsb3lEaXJ9YCk7XG4gICAgdGhpcy5kZXBsb3lUYXNrLmV4ZWMoYGNkazhzIHN5bnRoIC0tYXBwIFwiJHthcHB9XCIgLW8gJHtkZXBsb3lEaXJ9YCk7XG4gICAgdGhpcy5kZXBsb3lUYXNrLmV4ZWMoYGt1YmVjdGwgYXBwbHkgLWYgJHtkZXBsb3lEaXJ9YCk7XG4gICAgLy8gSWYgZGVwbG95bWVudCB3YXMgc3VjY2Vzc2Z1bCwgY29weSB0aGUgZGVwbG95IGRpciB0byB0aGUgZXhwZWN0ZWQgZGlyXG4gICAgdGhpcy5kZXBsb3lUYXNrLmV4ZWMoYHJtIC1mciAke3RoaXMuc25hcHNob3REaXJ9YCk7XG4gICAgdGhpcy5kZXBsb3lUYXNrLmV4ZWMoYG12ICR7ZGVwbG95RGlyfSAke3RoaXMuc25hcHNob3REaXJ9YCk7XG5cbiAgICAvLyBSdW4gYSBzbmFwc2hvdFxuICAgIHRoaXMuc25hcHNob3RUYXNrLmV4ZWMoYHJtIC1mciAke3RoaXMuc25hcHNob3REaXJ9YCk7XG4gICAgdGhpcy5zbmFwc2hvdFRhc2suZXhlYyhgY2RrOHMgc3ludGggLS1hcHAgXCIke2FwcH1cIiAtbyAke3RoaXMuc25hcHNob3REaXJ9YCk7XG5cbiAgICAvLyBBc3NlcnQgdGhhdCB0aGUgc25hcHNob3QgaGFzIG5vdCBjaGFuZ2VkIChydW4gZHVyaW5nIHRlc3RzKVxuICAgIHRoaXMuYXNzZXJ0VGFzay5leGVjKFxuICAgICAgYGNkazhzIHN5bnRoIC0tYXBwIFwiJHthcHB9XCIgLW8gJHthc3NlcnREaXJ9ID4gL2Rldi9udWxsYFxuICAgICk7XG4gICAgdGhpcy5hc3NlcnRUYXNrLmV4ZWMoYGRpZmYgJHt0aGlzLnNuYXBzaG90RGlyfS8gJHthc3NlcnREaXJ9L2ApO1xuICB9XG59XG4iXX0=