"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const internal_1 = require("./internal");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * Cloud integration tests.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("aws-cdk")) {
            project.deps.addDependency(`aws-cdk@^${options.cdkDeps.cdkMajorVersion}`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = path_1.join(this.tmpDir, "deploy.cdk.out");
        const assertDir = path_1.join(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        const opts = [
            `--app "${app}"`,
            "--no-notices",
            "--no-version-reporting",
            // don't inject cloudformation metadata into template
            "--no-asset-metadata",
        ];
        const pathMetadata = options.pathMetadata ?? false;
        if (!pathMetadata) {
            opts.push("--no-path-metadata");
        }
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                "@aws-cdk/core:newStyleStackSynthesis",
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(" ");
        // Determine which stacks to deploy
        const stacks = options.stacks ?? ["**"];
        const stackOpts = stacks.map((stack) => `'${stack}'`).join(" ");
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk deploy ${cdkopts} ${stackOpts} --require-approval=never -o ${deployDir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        this.watchTask = project.addTask(`integ:${this.name}:watch`, {
            description: `watch integration test '${this.name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} ${stackOpts} -o ${deployDir}`,
        });
        this.destroyTask = project.addTask(`integ:${this.name}:destroy`, {
            description: `destroy integration test '${this.name}'`,
            exec: `cdk destroy --app ${this.snapshotDir} ${stackOpts} --no-version-reporting`,
        });
        const destroyAfterDeploy = options.destroyAfterDeploy ?? true;
        if (destroyAfterDeploy) {
            this.deployTask.spawn(this.destroyTask);
        }
        this.snapshotTask.exec(`cdk synth ${cdkopts} -o ${this.snapshotDir} > /dev/null`);
        const exclude = ["asset.*", "cdk.out", "manifest.json", "tree.json"];
        this.assertTask.exec(`cdk synth ${cdkopts} -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff -r ${exclude.map((x) => `-x ${x}`).join(" ")} ${this.snapshotDir}/ ${assertDir}/`);
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${this.snapshotDir}/${x}`);
            project.addGitIgnore(`${this.snapshotDir}/**/${x}`); // nested assemblies
        }
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.67.2" };
//# sourceMappingURL=data:application/json;base64,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