#!/usr/bin/env python
# -*- coding: UTF-8 -*-
""" Crytography Base Functions """


import os

from cryptography.fernet import Fernet

enc = "utf-8"


class CryptoBase(object):
    """ Crytography Base Functions """

    def __init__(self):
        """
        Created:
            2-Mar-2022
            craig@grafflr.ai
            *   https://github.com/grafflr/graffl-core/issues/209
        """

    @staticmethod
    def _key():
        path = os.path.normpath(os.path.join(
            os.environ["GRAFFLR_HOME"],
            "resources/data/config/fernet"))

        f = open(path, 'rb')
        key = f.read()  # The key will be type bytes
        f.close()

        return key

    @staticmethod
    def encrypt_str(some_input: str) -> str:
        return CryptoBase.encrypt(some_input.encode(enc))

    @staticmethod
    def encrypt(message: bytes) -> str:
        f = Fernet(CryptoBase._key())
        return str(f.encrypt(message))

    @staticmethod
    def decrypt_str(some_input: str) -> str:
        return CryptoBase.decrypt(some_input.encode(enc))

    @staticmethod
    def decrypt(message: bytes) -> str:
        f = Fernet(CryptoBase._key())
        return f.decrypt(message).decode(enc)


def main(param1, param2):
    def _action():
        if param1 == "encrypt":
            return CryptoBase.encrypt_str(param2)
        elif param1 == "decrypt":
            return CryptoBase.decrypt_str(param2)
        else:
            raise NotImplementedError("\n".join([
                "Unknown Param: {}".format(param1)]))

    print(_action())


if __name__ == "__main__":
    import plac

    plac.call(main)
