from dataclasses import dataclass, field
from typing import List


@dataclass
class AvailableSizesType:
    """
    :ivar value:
    :ivar small:
    :ivar medium:
    :ivar large:
    """
    value: List[str] = field(
        default_factory=list,
        metadata=dict(
            min_occurs=0,
            max_occurs=9223372036854775807
        )
    )
    small: str = field(
        default="small",
        metadata=dict(
            required=True
        )
    )
    medium: str = field(
        default="medium",
        metadata=dict(
            required=True
        )
    )
    large: str = field(
        default="large",
        metadata=dict(
            required=True
        )
    )
