# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'thirdparties'}

packages = \
['ArmSDK',
 'IpMgrConnectorMux',
 'IpMgrConnectorSerial',
 'SerialConnector',
 'SmartMeshSDK',
 'SmartMeshSDK.ApiDefinition',
 'SmartMeshSDK.IpMgrConnectorMux',
 'SmartMeshSDK.IpMgrConnectorSerial',
 'SmartMeshSDK.SerialConnector',
 'SmartMeshSDK.utils',
 'common',
 'iCOMOXSDK',
 'iCOMOXSDK.common',
 'iCOMOXSDK.communications',
 'iCOMOXSDK.sensors',
 'txp',
 'txp.cloud',
 'txp.cloud.cloud_functions',
 'txp.cloud.cloud_functions.paired_devices_cloud_update',
 'txp.cloud.cloud_functions.state_event_pubsub_to_firestore',
 'txp.cloud.cloud_functions.store_telemetry_event_to_data_lake',
 'txp.cloud.cloud_functions.store_telemetry_event_to_data_lake.test',
 'txp.cloud.cloud_functions.update_firestore_configuration',
 'txp.cloud.cloud_functions.update_iot_gateway_config',
 'txp.cloud.common',
 'txp.cloud.composer',
 'txp.cloud.controllers',
 'txp.cloud.pipelines',
 'txp.cloud.pipelines.batch_pipeline',
 'txp.cloud.pipelines.realtime_pipeline',
 'txp.cloud.pipelines.realtime_pipeline.test',
 'txp.cloud.schemas',
 'txp.cloud.scripts',
 'txp.cloud.scripts.firestore',
 'txp.cloud.scripts.identity_platform',
 'txp.cloud.states_events_anyscale_mocks',
 'txp.common',
 'txp.common.configuration',
 'txp.common.edge',
 'txp.common.ml',
 'txp.common.protos',
 'txp.devices',
 'txp.devices.drivers',
 'txp.devices.drivers.arm_robot',
 'txp.devices.drivers.cli_commands',
 'txp.devices.drivers.icomox',
 'txp.devices.drivers.mock',
 'txp.devices.drivers.thermocouple',
 'txp.devices.drivers.usb',
 'txp.devices.drivers.usb.camera',
 'txp.devices.drivers.voyager',
 'txp.devices.ux',
 'txp.ml',
 'txp.ml.common',
 'txp.ml.common.tasks',
 'txp.ml.common.tasks.slic_cv_tasks',
 'txp.ml.prediction_service',
 'txp.ml.prediction_service.schemas',
 'txp.ml.prediction_service.service_manager',
 'txp.ml.prediction_service.state_managers',
 'txp.ml.training_service',
 'txp.ml.training_service.dataset_fetchers',
 'txp.ml.training_service.model_trainers',
 'txp.web',
 'txp.web.core_components',
 'txp.web.resources',
 'txp.web.views',
 'txp.web.views.analytics']

package_data = \
{'': ['*'],
 'txp.cloud.cloud_functions.state_event_pubsub_to_firestore': ['dist/*'],
 'txp.cloud.cloud_functions.update_firestore_configuration': ['dist/*'],
 'txp.cloud.cloud_functions.update_iot_gateway_config': ['dist/*'],
 'txp.cloud.common': ['configs/*'],
 'txp.cloud.pipelines.realtime_pipeline': ['pub_sub_to_bigquery.egg-info/*'],
 'txp.common': ['configs/*'],
 'txp.devices.drivers.mock': ['resources/*'],
 'txp.ml': ['anyscale/*'],
 'txp.web.resources': ['images/*']}

install_requires = \
['Markdown>=3.3.6,<4.0.0',
 'PyJWT>=2.1.0,<3.0.0',
 'cryptography>=35.0.0,<36.0.0',
 'deepdiff>=5.7.0,<6.0.0',
 'dynaconf>=3.1.4,<4.0.0',
 'fastapi>=0.78.0,<0.79.0',
 'firebase-admin>=5.2.0,<6.0.0',
 'freezegun>=1.1.0,<2.0.0',
 'google-api-python-client>=2.23.0,<3.0.0',
 'google-auth-oauthlib>=0.4.6,<0.5.0',
 'google-cloud-firestore>=2.3.4,<3.0.0',
 'google>=3.0.0,<4.0.0',
 'ifaddr>=0.1.7,<0.2.0',
 'matplotlib',
 'mcp9600',
 'opencv-python-headless>=4.5.5,<5.0.0',
 'paho-mqtt>=1.5.1,<2.0.0',
 'plotly>=5.6.0,<6.0.0',
 'psutil>=5.8.0,<6.0.0',
 'pyserial>=3.5,<4.0',
 'pytz>=2022.1,<2023.0',
 'pyudev>=0.23.1,<0.24.0',
 'queuelib>=1.6.2,<2.0.0',
 'requests>=2.26.0,<3.0.0',
 'schedule>=1.1.0,<2.0.0',
 'scipy>=1.4.0,<2.0.0',
 'six==1.13.0',
 'sklearn>=0.0,<0.1',
 'streamlit==1.4.0',
 'tabulate>=0.8.9,<0.9.0',
 'transitions>=0.8.8,<0.9.0',
 'xgboost==1.6.0']

extras_require = \
{':python_full_version >= "3.7.1" and python_version < "4.0"': ['pandas==1.3.5',
                                                                'streamlit-aggrid>=0.2.3,<0.3.0'],
 ':python_version >= "3.7" and python_version < "3.11"': ['numpy>=1.21.2,<2.0.0',
                                                          'google-cloud-bigquery>=2.31.0,<3.0.0']}

entry_points = \
{'console_scripts': ['txp = txp.cli:txp_cli_entrypoint']}

setup_kwargs = {
    'name': 'txp',
    'version': '0.2.21',
    'description': 'Txp is the main Python Package from Tranxpert predictive maintenance solution',
    'long_description': '# TXP\n\n## Development\nThe following tools are used for this project:\n\n- [Poetry](https://python-poetry.org/) is used for dependency and package managment\n- [Nox](https://nox.thea.codes/en/stable/) is used as automation tool, mainly for testing\n- [Black](https://black.readthedocs.io/en/stable/) is the mandatory formatter tool\n- [PyEnv](https://github.com/pyenv/pyenv) is recommended as a tool to handle multiple python versions in developers machines. \n\n### Setup the development environment\n\n1. Install a supported Python version on your machine (compatible Python versions ^3.8). The recommended way is to use [PyEnv](https://github.com/pyenv/pyenv).\n\n2. Install the global Python required dependencies: \n\n    ```\n    pip install poetry nox\n    ```\n\n3. Clone this repository, and execute the following command in the repository root folder:\n\n    ```\n    poetry install\n    ``` \n    This will install all the dependencies for `txp` in a virtual enviroment created by Poetry for your project. \n    All the required dependencies for development are installed in that virtual enviroment. \n\n4. Configure your IDE to work with the virtual enviroment or the command line if you use an editor. \n\n    To activate the virtual enviroment on your terminal (MacOS, Linux) you can execute:\n    ```\n    source /path/to/poetry/cache/virtualenvs/test-O3eWbxRl-py3.7/bin/activate\n    ```\n\n    The path to your virtual enviroment location can be found with `poetry env info` [command](https://python-poetry.org/docs/managing-environments#displaying-the-environment-information). \n\n### Testing\n',
    'author': 'Tranxpert',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Traxpert/txp',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
