# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simplesecurity']

package_data = \
{'': ['*']}

extras_require = \
{'full': ['poetry>=1.1.10,<2',
          'bandit>=1.7.0,<2',
          'safety>=1.10.3,<2',
          'dodgy>=0.2.1,<2',
          'dlint>=0.11.0,<2',
          'semgrep>=0.67.0,<2']}

entry_points = \
{'console_scripts': ['simplesecurity = simplesecurity:cli']}

setup_kwargs = {
    'name': 'simplesecurity',
    'version': '2021.3.3',
    'description': 'Combine multiple popular python security tools and generate reports or output into different formats',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/SimpleSecurity.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/simplesecurity.svg?style=for-the-badge)](https://pypistats.org/packages/simplesecurity)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fsimplesecurity)](https://pepy.tech/project/simplesecurity)\n[![PyPI Version](https://img.shields.io/pypi/v/simplesecurity.svg?style=for-the-badge)](https://pypi.org/project/simplesecurity)\n\n<!-- omit in toc -->\n# SimpleSecurity\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nCombine multiple popular python security tools and generate reports or output\ninto different formats\n\nPlugins (these require the plugin executable in the system path. e.g. bandit\nrequires bandit to be in the system path...)\n\n- bandit\n- safety\n- dodgy\n- dlint\n- semgrep\n\nFormats\n\n- ansi (for terminal)\n- json\n- markdown\n- csv\n- sarif\n\n## Example Use\n\nSee below for the output if you run `simplesecurity` in this directory\n\n<img src="readme-assets/screenshots/sec.svg" width="500px">\n\n### Help\n\n```txt\nusage: __main__.py [-h] [--format FORMAT] [--plugin PLUGIN] [--file FILE] [--level LEVEL] [--confidence CONFIDENCE]\n                   [--no-colour] [--high-contrast] [--fast] [--zero]\n\nCombine multiple popular python security tools...\n\nand generate reports or output into different formats.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --format FORMAT, -f FORMAT\n                        Output format. One of ansi, json, markdown, csv. default=ansi\n  --plugin PLUGIN, -p PLUGIN\n                        Plugin to use. One of bandit, safety, dodgy, dlint, semgrep, all, default=all\n  --file FILE, -o FILE  Filename to write to (omit for stdout)\n  --level LEVEL, -l LEVEL\n                        Minimum level/ severity to show\n  --confidence CONFIDENCE, -c CONFIDENCE\n                        Minimum confidence to show\n  --no-colour, -z       No ANSI colours\n  --high-contrast, -Z   High contrast colours\n  --fast, --skip        Skip long running jobs. Will omit plugins with long run time (applies to -p all only)\n  --zero, -0            Return non zero exit code if any security vulnerabilities are found\n```\n\nYou can also import this into your own project and use any of the functions\nin the DOCS\n\n<!-- omit in toc -->\n## Table of Contents\n\n- [Example Use](#example-use)\n\t- [Help](#help)\n- [Developer Notes](#developer-notes)\n\t- [Generate semgrep_sec.yaml](#generate-semgrep_secyaml)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Developer Notes\n\n### Generate semgrep_sec.yaml\n\n1. Clone https://github.com/returntocorp/semgrep-rules\n2. cd to project/python\n3. do\n\n   ```bash\n   cat **/security/**/*.yaml >> semgrep_sec.yaml\n   cat **/security/*.yaml >> semgrep_sec.yaml\n   ```\n\n4. Find and replace `rules:` with `` apart from the first instance\n5. Reformat with `ctrl+shift+i`\n6. replace simplesecurity/semgrep_sec.yaml with the new one\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n\n**"Slim" Build:** Install bandit, dlint, dodgy, poetry, and safety with pipx\n\n```python\npip install simplesecurity\n```\n\n**Otherwise:**\n\n```python\npip install simplesecurity[full]\n```\n\nHead to https://pypi.org/project/SimpleSecurity/ for more info\n\n## Language information\n\n### Built for\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/SimpleSecurity\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/SimpleSecurity',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
