#!/usr/bin/env python3


from html.entities import name2codepoint
import regex as re

entities_match = re.compile(r"&#?\w+;")


def convert_entities(text):
    """Convert entities"""

    def fixup(m):
        text = m.group(0)
        if text[:2] == "&#":
            # character reference
            try:
                if text[:3] == "&#x":
                    return chr(int(text[3:-1], 16))
                else:
                    return chr(int(text[2:-1]))
            except ValueError:
                pass
        else:
            # named entity
            try:
                text = chr(name2codepoint[text[1:-1]])
            except KeyError:
                pass
        return text  # leave as is

    return entities_match.sub(fixup, text)
