# NDlib - Network Diffusion Library

[![pyversions](https://img.shields.io/pypi/pyversions/ndlib.svg)](https://badge.fury.io/py/ndlib)
[![Build Status](https://travis-ci.org/GiulioRossetti/ndlib.svg?branch=master)](https://travis-ci.org/GiulioRossetti/ndlib)
[![Coverage Status](https://coveralls.io/repos/github/GiulioRossetti/ndlib/badge.svg?branch=master)](https://coveralls.io/github/GiulioRossetti/ndlib?branch=master)
[![Documentation Status](https://readthedocs.org/projects/ndlib/badge/?version=latest)](http://ndlib.readthedocs.io/en/latest/?badge=latest)
[![Updates](https://pyup.io/repos/github/GiulioRossetti/ndlib/shield.svg)](https://pyup.io/repos/github/GiulioRossetti/ndlib/)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/GiulioRossetti/ndlib.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/GiulioRossetti/ndlib/context:python)
[![Gitter chat](https://badges.gitter.im/gitterHQ/gitter.png)](https://gitter.im/ndlib_nx/community?utm_source=share-link&utm_medium=link&utm_campaign=share-link)
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2FGiulioRossetti%2Fndlib.svg?type=shield)](https://app.fossa.io/projects/git%2Bgithub.com%2FGiulioRossetti%2Fndlib?ref=badge_shield)
[![DOI](https://zenodo.org/badge/59556819.svg)](https://zenodo.org/badge/latestdoi/59556819)
[![PyPI download month](https://img.shields.io/pypi/dm/ndlib.svg?color=blue&style=plastic)](https://pypi.python.org/pypi/ndlib/)


![NDlib logo](https://github.com/GiulioRossetti/ndlib/blob/master/docs/ndlogo2.png)

NDlib provides implementations of several spreading and opinion dynamics models.

The project documentation can be found on [ReadTheDocs](http://ndlib.readthedocs.io).

If you use ``NDlib`` as support to your research consider citing:

> G. Rossetti, L. Milli, S. Rinzivillo, A. Sirbu, D. Pedreschi, F. Giannotti.
> **NDlib: a Python Library to Model and Analyze Diffusion Processes Over Complex Networks.**
> Journal of Data Science and Analytics. 2017. 
> [DOI:0.1007/s41060-017-0086-6](https://doi.org/10.1007/s41060-017-0086-6) (pre-print available on [arXiv](https://arxiv.org/abs/1801.05854))

> G. Rossetti, L. Milli, S. Rinzivillo, A. Sirbu, D. Pedreschi, F. Giannotti.
> "**NDlib: Studying Network Diffusion Dynamics**", 
> IEEE International Conference on Data Science and Advanced Analytics, DSAA. 2017.

## Promo Video

[![Promo](https://img.youtube.com/vi/tYHNOuKJwbE/0.jpg)](https://www.youtube.com/watch?v=tYHNOuKJwbEE)

## Installation

To install the library just download (or clone) the current project and copy the ndlib folder in the root of your application.

Alternatively use pip:
```bash
sudo pip install ndlib
```

## Documentation

For examples, tutorials and a complete reference visit the project documentation website on [ReadTheDocs](http://ndlib.readthedocs.io).

## Jupyter Notebook Tutorial

Interested in an extensive tutorial on NDlib? Check out the official Jupyter Notebooks!

[NDlib Overview](https://colab.research.google.com/github/KDDComplexNetworkAnalysis/CNA_Tutorials/blob/master/NDlib.ipynb#scrollTo=d80DUNRkKIn4)
 
[NDlib-Rest](https://colab.research.google.com/github/KDDComplexNetworkAnalysis/CNA_Tutorials/blob/master/NDlib-REST.ipynb)

## Collaborate with us!

``NDlib`` is an active project, any contribution is welcome!

If you like to include your model in NDlib (as well as in [NDlib-REST](https://github.com/GiulioRossetti/ndlib-rest)) feel free to fork the project, open an issue and contact us.

### How to contribute to this project?

Contributing is good, doing it correctly is better! Check out our [rules](https://github.com/GiulioRossetti/ndlib/blob/master/.github/CONTRIBUTING.md), issue a proper [pull request](https://github.com/GiulioRossetti/ndlib/blob/master/.github/PULL_REQUEST_TEMPLATE.md) /[bug report](https://github.com/GiulioRossetti/ndlib/blob/master/.github/ISSUE_TEMPLATE/bug_report.md) / [feature request](https://github.com/GiulioRossetti/ndlib/blob/master/.github/ISSUE_TEMPLATE/feature_request.md).

Do you want to be part of the NDlib community to discuss enhancements, desiderata, bug fix? Join us on **Slack**!

[<img align="middle" width="150" src="docs/join-slack-team.png">](https://join.slack.com/t/ndlib/shared_invite/enQtNTA2ODk1MzQzODE0LTU2YWEzZjAzNDFiNTBlY2QxN2IyODAwMjgyMDBmYjQ2NzhjZjA4NzA1M2U0ZmZlN2I1NGM5OTI2N2I4ZTFmMzQ)

We are a welcoming community... just follow the [Code of Conduct](https://github.com/GiulioRossetti/ndlib/blob/master/.github/CODE_OF_CONDUCT.md).


## License
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2FGiulioRossetti%2Fndlib.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2FGiulioRossetti%2Fndlib?ref=badge_large)
