from typing import List, Dict, Optional, Tuple, Literal

"""
Model-1: 物种记录（通用记录）
"""

# 照片
# 考虑到未来网页端其他团队用户需要将自己拍摄的照片整合套其他成员的记录之中，这里将
# 照片版权人姓名或昵称写入 key
associatedMedia: List[str] = {
    "徐洲锋": ["https://...."],
    "罗世效": ["https://...."],
    "涂铁要": ["https://...."]
    }
# 记录标识符,无需用户录入，数据若可以共享，由系统自动注册后显示，无需用户填写
occurrenceID: str = "NOI:123456789"  # 新增，未来与NOI对接，作为记录使用和分享的唯一凭证，只有共享的数据才会申请
# 记录人，必填，不外显，导出数据提供
recordedBy: List[str] = ["张三"]
recordedByID: List[int] = [23]
# 物种来源
establishmentMean: Dict[str, str] = {
    "人工培育": "人工圈养或栽培的物种",
    "野生物种": "无法确定是否是本土物种，生长于非人工圈养或栽培的环境下（含逸生物种）",
    "本土原生": "本土物种，非人工圈养或栽培",
    "本土引种": "本土物种，由人工圈养或栽培",
    "外来引种": "外来物种，由人工圈养或栽培",
    "外来物种": "外来物种，非人工圈养或栽培（含逸生的外来物种）",
    "不确定": "无法考证该对象的来源"
}
# 记录时间，必填
eventTime: str = "1964-12-12T00:00:00+08:00"
# 数量
individualCount: int = 321

# 鉴定
identification: str = "Rhododendron delavayi Fr."
# 鉴定等级
identificationVerificationStatus: Dict[str, str] = {
    "错误": "鉴定经专家核查，认为有错", 
    "接受":"鉴定经专家核验，认为正确",
    "待审核":"鉴定尚未经专家审核", 
    "素材不足":"现有素材，专家无法确认鉴定是否正确"}
# 学名标识符
scientificNameID: str = "NOINAME:24234352"
# 学名
scientificName: str = "Rhododendron delavayi Franch." # 注意带有命名人
# 中文名
chineseName: str = "马缨杜鹃"
# 科
family: str = "Ericaceae"
# 科中文名
familyChineseName: str = "杜鹃花科"
# 门
phylum: str = "Angiosperm"
# 门中文名
chinesePhylumName: str = "被子植物门"
# 鉴定人
identifiedBy: List[str] = ["徐洲锋"]
identifiedByID: List[int] = [28]
# 鉴定时间
dateIdentified: str = "1964-12-12T00:00:00+08:00"

# 网格编码，必填
locationID: str = '01233212103'
# 海拔，必填
elevationInMeters: float = 567.3
# 纬度，必填
decimalLatitude: float = 25.1234567
# 经度，必填
decimalLongitude: float = 110.1234567
# 发现备注
occurrenceRemark: str = "居群遍布整个山坡"
# 数据共享协议，非项目记录无需用户选择，记录默认采用 CC BY-NC 4.0 共享
# 项目记录，由用户新建项目时设定整个项目的文本数据共享等级，默认 CC BY-NC 4.0，用户可更改
# 用户新建项目时改动默认共享等级时，需明确提示：“团队新建后，若要修改数据共享协议，创建者只能
# 选择开放程度更高的许可协议；当前所选协议只针对文本记录，并不覆盖文本记录相关的图片、声音、视
# 频等多媒体文件；加入团队的用户将视为接受团队当前乃至未来所选择的的文本数据共享协议。”
license: Dict[str, str ] = {
    "private": "由项目创建者决定文本内容在项目成员之间的共享程度，需注意：由于本平台为公益性平台，该等级的相关要求未来可能会做进一步调整",
    "CC BY-NC-SA 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名，相关衍生内容须采用与本创作相同的协议进行授权。", 
    "CC BY-NC 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名", 
    "CC BY 4.0":"他人可以对内容进行各种处理和衍生，允许应用于商业目的，使用和公开时必须保留创作人对原作品的署名。", 
    "CC0 1.0": "所有责任由使用者承担，发布者和平台不负任何责任。"}
# 数据集名称，不需要外显，程序自动写入所属的项目名称
dataSetName: str = "华南植物园物种引种记录"
# 数据集标识符， 不需要外显，程序自动写入所属项目的ID
dataSetID: int = 242423



"""
Model-2: 栽培植物引种模版
"""
#照片
associatedMedia: List[str] = {
    "徐洲锋": "https://....",
    "罗世效": "https://....", 
    "涂铁要": "https://...."
    }
# 记录标识符，无需用户录入，数据若可以共享，由系统自动注册后显示，无需用户填写
occurrenceID: str = "NOI:123456789"
# 引种人，外显，必填
recordedBy: List[str] = ["张三", "李四"]
recordedByID: List[int] = [23, 49]
# 引种号，必填，类似采集号，可扫码识别
recordNumber :str = "XZF12324"
# 母本来源
establishmentMean: Dict[str, str] = {
    "人工培育": "人工圈养或栽培的物种",
    "野生物种": "无法确定是否是本土物种，生长于非人工圈养或栽培的环境下（含逸生物种）",
    "本土原生": "本土物种，非人工圈养或栽培",
    "本土引种": "本土物种，由人工圈养或栽培",
    "外来引种": "外来物种，由人工圈养或栽培",
    "外来物种": "外来物种，非人工圈养或栽培（含逸生的外来物种）",
    "不确定": "无法考证该对象的来源"
}
# 数量
individualCount: int = 321
# 引种时间，必填
eventTime: str = "964-12-12T00:00:00+08:00"

# 鉴定
identification: str = "Rhododendron delavayi Fr."
# 鉴定等级
identificationVerificationStatus: Dict[str, str] = {
    "错误": "鉴定经专家核查，认为有错", 
    "接受":"鉴定经专家核验，认为正确",
    "待审核":"鉴定尚未经专家审核", 
    "素材不足":"现有素材，专家无法确认鉴定是否正确"}
# 学名标识符
scientificNameID: str = "NOINAME:24234352"
# 学名
scientificName: str = "Rhododendron delavayi Xuzhoufeng var. sinisis Fracnh." # 注意带有命名人
# 中文名
chineseName: str = "马缨杜鹃"
# 科
family: str = "Ericaceae"
# 科中文名
familyChineseName: str = "杜鹃花科"
# 门
phylum: str = "Angiosperm"
# 门中文名
chinesePhylumName: str = "被子植物门"
# 鉴定人
identifiedBy: str = "徐洲锋"
identifiedByID: int = 28
# 鉴定时间
dateIdentified: str = "1964-12-12T00:00:00+08:00"

# 网格编码，必填
locationID: str = '01233212103'
# 行政区编码
higherGeographyID: str = '110000'
# 国
country: str = "中国"
# 省
province: str = "广东省"
# 市
city: str = "广州市"
# 县
county: str = "天河区"
# 小地名，必填
locality: str = "兴科路723号"
# 海拔，必填
elevationInMeters: float = 567.3
# 纬度，必填
decimalLatitude: float = 25.1234567
# 经度，必填
decimalLongitude: float = 110.1234567
# 生存环境，必填
habitat: str = "水边"
# 生物学特性，相关属性，可填可不填
dynamicProperties: Dict = {
    # 生活型
    "habit": Dict[str, str] = {
        "草本": "茎干软弱，多数在生长季节结束后，地上部分或整株植物体死亡", 
        "乔木": "主干明显，通常较高的木本植物", 
        "灌木": "分枝靠近茎的基部，相对矮小的木本植物", 
        "半灌木": "仅茎基部木质化，多年生；而上枝草质并于花后或冬季枯萎",
        "竹类": "各种类型的竹子，茎干常具节，茎内中空", 
        "藤本": "自身不能直立，必须依附他物而向上攀缘的草本或木本植物", 
        "草质藤本": "可攀缘的草质藤本，注意与匍匐草本区分", 
        "木质藤本": None, 
        "水生草本": "包含挺水植物、浮叶植物，沉水植物、漂浮植物以及湿生植物", 
        "腐生草本": "从各类腐殖质上获取营养，自身不能进行光合作用的草本植物", 
        "寄生植物": "从其他活植物体内获取营养，自身不含或只含很少的叶绿素", 
        "附生植物": "不生长于地面，根部附着于其他植物之上，以获取更好的阳光、水分等生存条件", 
    },
    # 频度
    "frequency": Dict[str, str] = {
        "极少": "该物种的植株在调查区域内非常罕见，仅见一两处分布", 
        "少见": "该物种的植株在调查区域内可见多处，但不常见", 
        "常见": "该物种的植株在调查区域内是所属层级的优势物种之一", 
        "较多": "该物种的植株在调查区域内是所属层级中相对更有优势的物种", 
        "多见": "该物种的植株在调查区域内是所在层级中的优势物种", 
        "极多": "该物种的植株在调查区域内形成密度极高的顶级优势群落"}, 
    # 胸径
    "DBH": float = 20.3,
    # 体高
    "heightInMeters": float = 0.14,
    # 根/不定根 
    "root": str = "直根系", 
    # 茎/树皮
    "stem": str = "树皮开裂", 
    # 叶
    "leaf": str = "卵形", 
    # 生殖器官
    "reproductiveOrgans": str = "花黄色", 
    # 繁殖体
    "propagulum": str = "果皮肉质, 种子黑色",
    # 寄主
    "host": str = "榕树"
    }

# 材料类型，必填
organismScope: Dict[str, str] = {
    "SO": "同一植株的种子或花粉", 
    "SM": "多于一株植物的种子",
    "VO": "为同一植株的枝条", 
    "VM": "为多于一株植物的枝条", 
    "SAO": "为同一居群的苗",
    "SAM": "为多于一个居群的幼苗",
    "XX": "为采样方法未知"}

# 发现备注
occurrenceRemark: str = "居群遍布整个山坡"
# 数据共享协议
license: Dict[str, str ] = {
    "private": "由项目创建者决定文本内容在项目成员之间的共享程度，需注意：由于本平台为公益性平台，该等级的相关要求未来可能会做进一步调整",
    "CC BY-NC-SA 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名，相关衍生内容须采用与本创作相同的协议进行授权。", 
    "CC BY-NC 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名", 
    "CC BY 4.0":"他人可以对内容进行各种处理和衍生，允许应用于商业目的，使用和公开时必须保留创作人对原作品的署名。", 
    "CC0 1.0": "所有责任由使用者承担，发布者和平台不负任何责任。"}
# 数据集名称，不需要外显，程序自动写入所属的项目名称
dataSetName: str = "华南植物园物种引种记录"
# 数据集标识符， 不需要外显，程序自动写入所属项目的ID
dataSetID: int = 242423



"""
Model-3: 植物园定植记录模版
"""

# 照片
associatedMedia: List[str] = {
    "徐洲锋": "https://....",
    "罗世效": "https://....", 
    "涂铁要": "https://...."
    }
# 登录号，可扫码识别
accessionNumber: str = "2016.1234"
# 定植号，必填，可扫码识别
establishmentNumber: str = "01234567"
# 植株来源
establishmentMean: Dict[str, str] = {
    "人工培育": "人工圈养或栽培的物种",
    "野生物种": "无法确定是否是本土物种，生长于非人工圈养或栽培的环境下（含逸生物种）",
    "本土原生": "本土物种，非人工圈养或栽培",
    "本土引种": "本土物种，由人工圈养或栽培",
    "外来引种": "外来物种，由人工圈养或栽培",
    "外来物种": "外来物种，非人工圈养或栽培（含逸生的外来物种）",
    "不确定": "无法考证该对象的来源"
}
# 记录标识符,无需用户录入，数据若可以共享，由系统自动注册后显示，无需用户填写
occurrenceID: str = "NOI:123456789"
# 记录人，必填，不外显，导出数据提供
recordedBy: List[str] = ["张三"]
recordedByID: List[int] = [23]
# 记录时间，必填
eventTime: str = "1964-12-12T00:00:00+08:00"
# 数量
individualCount: int = 321

# 鉴定
identification: str = "Rhododendron delavayi Fr."
# 鉴定等级
identificationVerificationStatus: Dict[str, str] = {
    "错误": "鉴定经专家核查，认为有错", 
    "接受":"鉴定经专家核验，认为正确",
    "待审核":"鉴定尚未经专家审核", 
    "素材不足":"现有素材，专家无法确认鉴定是否正确"}
# 学名标识符
scientificNameID: str = "NOINAME:24234352"
# 学名
scientificName: str = "Rhododendron delavayi Franch." # 注意带有命名人
# 中文名
chineseName: str = "马缨杜鹃"
# 科
family: str = "Ericaceae"
# 科中文名
familyChineseName: str = "杜鹃花科"
# 门
phylum: str = "Angiosperm"
# 门中文名
chinesePhylumName: str = "被子植物门"
# 鉴定人
identifiedBy: List[str] = ["徐洲锋"]
identifiedByID: List[int] = [28]
# 鉴定时间
dateIdentified: str = "1964-12-12T00:00:00+08:00"

# 网格编码，必填
locationID: str = '01233212103'
# 海拔，必填
elevationInMeters: float = 567.3
# 纬度，必填
decimalLatitude: float = 25.1234567
# 经度，必填
decimalLongitude: float = 110.1234567
# 发现备注
occurrenceRemark: str = "居群遍布整个山坡"
# 数据共享协议
license: Dict[str, str ] = {
    "private": "由项目创建者决定文本内容在项目成员之间的共享程度，需注意：由于本平台为公益性平台，该等级的相关要求未来可能会做进一步调整",
    "CC BY-NC-SA 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名，相关衍生内容须采用与本创作相同的协议进行授权。", 
    "CC BY-NC 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名", 
    "CC BY 4.0":"他人可以对内容进行各种处理和衍生，允许应用于商业目的，使用和公开时必须保留创作人对原作品的署名。", 
    "CC0 1.0": "所有责任由使用者承担，发布者和平台不负任何责任。"}
# 数据集名称，不需要外显，程序自动写入所属的项目名称
dataSetName: str = "华南植物园物种引种记录"
# 数据集标识符， 不需要外显，程序自动写入所属项目的ID
dataSetID: int = 242423



"""
Model-4: 植物园清查记录模版
"""

# 照片
associatedMedia: List[str] = {
    "徐洲锋": "https://....",
    "罗世效": "https://....", 
    "涂铁要": "https://...."
    }
# 登录号，可扫码识别
accessionNumber: str = "2016.1234"
# 定植号，必填，可扫码识别
establishmentNumber: str = "01234567"
# 植株来源
establishmentMean: Dict[str, str] = {
    "人工培育": "人工圈养或栽培的物种",
    "野生物种": "无法确定是否是本土物种，生长于非人工圈养或栽培的环境下（含逸生物种）",
    "本土原生": "本土物种，非人工圈养或栽培",
    "本土引种": "本土物种，由人工圈养或栽培",
    "外来引种": "外来物种，由人工圈养或栽培",
    "外来物种": "外来物种，非人工圈养或栽培（含逸生的外来物种）",
    "不确定": "无法考证该对象的来源"
}
# 记录标识符,无需用户录入，数据若可以共享，由系统自动注册后显示，无需用户填写
occurrenceID: str = "NOI:123456789"
# 记录人，必填，不外显，导出数据提供
recordedBy: List[str] = ["张三"]
recordedByID: List[int] = [23]
# 记录时间，必填
eventTime: str = "1964-12-12T00:00:00+08:00"
# 数量/规模
individualCount: int = 321

# 鉴定
identification: str = "Rhododendron delavayi Fr."
# 鉴定等级
identificationVerificationStatus: Dict[str, str] = {
    "错误": "鉴定经专家核查，认为有错", 
    "接受":"鉴定经专家核验，认为正确",
    "待审核":"鉴定尚未经专家审核", 
    "素材不足":"现有素材，专家无法确认鉴定是否正确"}
# 学名标识符
scientificNameID: str = "NOINAME:24234352"
# 学名
scientificName: str = "Rhododendron delavayi Franch." # 注意带有命名人
# 中文名
chineseName: str = "马缨杜鹃"
# 科
family: str = "Ericaceae"
# 科中文名
familyChineseName: str = "杜鹃花科"
# 门
phylum: str = "Angiosperm"
# 门中文名
chinesePhylumName: str = "被子植物门"
# 鉴定人
identifiedBy: List[str] = ["徐洲锋"]
identifiedByID: List[int] = [28]
# 鉴定时间
dateIdentified: str = "1964-12-12T00:00:00+08:00"

# 网格编码，必填
locationID: str = '01233212103'
# 海拔，必填
elevationInMeters: float = 567.3
# 纬度，必填
decimalLatitude: float = 25.1234567
# 经度，必填
decimalLongitude: float = 110.1234567
# 发现备注
occurrenceRemark: str = "居群遍布整个山坡"
# 数据共享协议
license: Dict[str, str ] = {
    "private": "由项目创建者决定文本内容在项目成员之间的共享程度，需注意：由于本平台为公益性平台，该等级的相关要求未来可能会做进一步调整",
    "CC BY-NC-SA 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名，相关衍生内容须采用与本创作相同的协议进行授权。", 
    "CC BY-NC 4.0":"他人可以对内容进行各种处理和衍生，但不得应用于商业目的，使用和公开时必须保留创作人对原作品的署名", 
    "CC BY 4.0":"他人可以对内容进行各种处理和衍生，允许应用于商业目的，使用和公开时必须保留创作人对原作品的署名。", 
    "CC0 1.0": "所有责任由使用者承担，发布者和平台不负任何责任。"}
# 数据集名称，不需要外显，程序自动写入所属的项目名称
dataSetName: str = "华南植物园物种引种记录"
# 数据集标识符， 不需要外显，程序自动写入所属项目的ID
dataSetID: int = 242423
# 生活型
habit: Dict[str, str] = {
    "草本": "茎干软弱，多数在生长季节结束后，地上部分或整株植物体死亡", 
    "禾草类": "属于禾本科的草本植物",
    "仙人掌类": None,
    "竹类": "各种类型的竹子，茎干常具节，茎内中空", 
    "蕨类": "属于石松类和蕨类的植物，绝大部分为草本，少数为木本",
    "常绿乔木": "终年具有绿叶的乔木",
    "落叶乔木": "每年特定时期叶全部脱落的乔木", 
    "柔荑花序类": "常见于杨柳科、胡桃科、杨梅科、桦木科、壳斗科、榛科、木麻黄科等植物",
    "球果类": None,
    "常绿灌木": "终年具有绿叶的灌木", 
    "落叶灌木": "每年特定时期叶全部脱落的灌木",
},
# 物候，与上面生活型关联
lifeStage = Dict[str, str] = 
# 生活型为常绿乔木/常绿灌木物候 BBCH 代码
{
    "01": "叶芽膨大始期，芽明显肿胀，芽鳞伸长、具浅色斑块",
    "03": "叶芽膨大末期，芽鳞色浅、分离，局部密被绒毛",
    "07": "叶芽萌发始期，刚见到幼叶叶尖（伸出鳞片）",
    "08": "叶芽萌发末期：明显可见幼叶，但未见到叶柄或叶基之前",
    "11-19": "观察和记录第1-9 片叶展开（观察到叶柄或叶基）的日期",
    "51": "花（序）芽膨大",
    "53": "花（序）芽萌芽：可见有色彩的花（序）尖",
    "60": "始花，花零星开放",
    "65": "盛花，50% 花开放",
    "69": "末花，约有 90% 花已开放，可见座果",
    "71": "果实发育中幼果开始膨大",
    "81": "果熟开始或果实开始变色，出现不同颜色的果实"
}
# 生活型为落叶乔木/落叶灌木物候 BBCH 代码
{
    "01": "叶芽膨大始期，芽明显肿胀，芽鳞伸长、具浅色斑块",
    "03": "叶芽膨大末期，芽鳞色浅、分离，局部密被绒",
    "07": "叶芽萌发始期，刚见到幼叶叶尖（伸出鳞片）",
    "08": "叶芽萌发末期，明显可见幼叶，但未见到叶柄或叶基之前",
    "11-19": "观察和记录第 1-9 片叶展开（观察到叶柄或叶基）",
    "51": "花（序）芽膨大",
    "53": "花（序）芽萌芽，可见有色彩的花（序）尖",
    "60": "始花期，花零星开放",
    "65": "盛花期，50% 花开放",
    "69": "末花期，约有 90% 花已开放，可见座果",
    "71": "果实发育中幼果开始膨大",
    "81": "果熟开始或果实开始变色，出现不同颜色的果实",
    "92": "叶变色始期，叶开始变色",
    "93": "落叶始期，开始落叶",
    "95": "落叶盛期，50% 的叶脱落",
    "97": "落叶末期，叶完全脱落"
}
# 柔荑花序类 BBCH 物候代码
{
    "01": "叶芽膨大始期，芽明显肿胀，芽鳞伸长、具浅色斑块", 
    "03": "叶芽膨大末期，芽鳞色浅、分离，局部密被绒毛",
    "07": "叶芽萌发始期，刚见到幼叶叶尖（伸出鳞片）",
    "08": "叶芽萌发末期，明显可见幼叶，但未见到叶柄或叶基之前",
    "11-19": "观察和记录第1-9 片叶展开（观察到叶柄或叶基）的日期",
    "51": "花（序）芽膨大", 
    "53": "花（序）芽萌芽，可见有色彩的花（序）尖",
    "60": "始花期，花零星开放",
    "65": "盛花期，50%花开放",
    "69": "末花期，约有90%花已开放，可见座果",
    "71": "果实发育中幼果开始膨大",
    "81": "果熟开始或果实开始变色，出现不同颜色的果实",
    "92": "叶变色始期，开始变色", 
    "93": "落叶始期，叶开始脱落",
    "95": "落叶盛期，50% 的叶脱落",
    "97": "落叶末期，叶完全脱落"
}
# 球果类 BBCH 物候代码
{
    "01": "芽膨大开始",
    "07": "叶芽萌发始期，刚见到绿色叶尖突出于鳞片",
    "08": "叶芽萌发末期，明显可见绿色叶（苗）尖，但见叶柄或叶基之前",
    "11": "第一片（对、轮）叶展开或最早的叶开始展开",
    "15": "第五片叶展开但未达最终大小",
    "19": "第九或更多的叶充分扩大并达到其最终大小",
    "60": "始花期，花粉释放初期",
    "65": "花粉释放盛期，50%的球果轻轻摇动或吹风时花粉释放",
    "69": "花粉释放末期，90%花粉释放完成",
    "71": "球果发育中幼果开始膨大",
    "81": "种球成熟期，球果完全成熟"
}
# 草本植物 BBCH 物候代码
{
    "01": "叶芽膨大始期，芽明显肿胀，芽鳞伸长、具浅色斑块",
    "03": "叶芽膨大末期，芽鳞色浅、分离，局部密被绒毛",
    "07": "叶芽萌发始期，刚见到幼叶叶尖（伸出鳞片）",
    "08": "叶芽萌发末期，明显可见幼叶，但未见到叶柄或叶基之前",
    "11-19": "观察和记录第1-9 片叶展开（观察到叶柄或叶基）的日期",
    "51": "花（序）芽膨大，53：花（序）芽萌芽：可见有色彩的花（序）尖",
    "60": "始花，花零星开放",
    "65": "盛花，50%花开放",
    "69": "末花，约有90%花已开放，可见座果",
    "71": "果实发育中幼果开始膨大", 
    "81": "果熟开始或果实开始变色，出现不同颜色的果实",
    "97": "植株或地上部分死亡或休眠"
}
# 禾草类植物 BBCH 物候代码
{
    "01": "叶芽膨大始期，芽明显肿胀，芽鳞伸长、具浅色斑块",
    "03": "叶芽膨大末期，芽鳞色浅、分离，局部密被绒毛", 
    "07": "叶芽萌发始期，刚见到幼叶叶尖（伸出鳞片）",
    "08": "叶芽萌发末期，明显可见幼叶，但未见到叶柄或叶基之前",
    "11-19": "观察和记录第1-9 片叶展开（观察到叶柄或叶基）",
    "51": "花（序）芽膨大，53：花（序）芽萌芽：可见有色彩的花（序）尖",
    "60": "始花，花零星开放",
    "65": "盛花，50%花开放",
    "69": "末花，约有90%花已开放，可见座果",
    "71": "果实发育中幼果开始膨大",
    "81": "果熟开始或果实开始变色，出现不同颜色的果实",
    "97": "植株或地上部分枯死或休眠，谷物类亦指收割时间"
}
# 蕨类
{
    "09": "芽露出地面，刚观察到绿色叶尖",
    "10": "地面上蕨叶卷曲",
    "11": "第一片蕨叶展开或最早的蕨叶开始展开",
    "15": "第五片蕨叶展开但未达最终大小",
    "19": "第九或更多的蕨叶充分扩大并达到其最终大小",
    "60": "孢子囊群开始出现（Sori Emergence），绿色",
    "65": "孢子囊群成熟（Sori Mature），颜色变深且干燥，释放孢子",
    "69": "孢子囊群萎缩脱落（Sori Fall）",
    "92": "蕨叶开始枯萎",
    "95": "50%的蕨叶变黄",
    "99": "植株枯死"
}
# 仙人掌类
{
    "51": "花芽膨大，芽闭合",
    "53": "花芽萌芽，鳞片分离，可见花尖",
    "60": "始花期，花零星开放",
    "65": "盛花期，50%花开放",
    "69": "末花期,开花结束，95-100%花开放，座果",
    "71": "果实发育中幼果开始膨大",
    "81": "果熟开始或果实变色开始，果实开始出现不同的颜色"
}

# 定植状态
degreeOfEstablishment: Dict[str, str] =
{
    "C": "存活",
    "D": "死亡",
    "T": "移至别的专类园区或记录系统",
    "S": "休眠",
    "O": "上述以外的其他状态"
}
# 体高
heightInMeters: float = 0.14
# 胸径
DBH: int = 32
