# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['kharma', 'kharma.app', 'kharma.app.utils']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'ruamel.yaml>=0.17.21,<0.18.0']

entry_points = \
{'console_scripts': ['kharma = kharma.main:main']}

setup_kwargs = {
    'name': 'kharma',
    'version': '0.0.4',
    'description': 'Kharma is a state-of-the-art grammar fuzzer',
    'long_description': '<p align=center>\n  <img src="https://github.com/Rog3rSm1th/Kharma/blob/main/doc/kharma_logo.png?raw=true" width="200" height="200" style="border-radius:4px"/>\n  <br>\n  <code>pip3 install kharma</code></br></br>\n  <a target="_blank" href="https://www.python.org/downloads/" title="Python version"><img src="https://img.shields.io/badge/Made%20with-Python-1f425f.svg"></a>\n  <a target="_blank" href="https://www.python.org/downloads/" title="Python version"><img src="https://img.shields.io/badge/python-%3E=_3.6-green.svg"></a>\n  <a target="_blank" href="LICENSE" title="License: MIT"><img src="https://img.shields.io/badge/License-MIT-blue.svg"></a>\n  <a target="_blank" href="LICENSE" title="License: MIT"><img src="https://img.shields.io/pypi/v/kharma?label=release"></a>\n  <a href="https://twitter.com/intent/follow?screen_name=Rog3rSm1th" title="Follow"><img src="https://img.shields.io/twitter/follow/Rog3rSm1th?label=Rog3rSm1th&style=social"></a>\n  <br>\n  <span><i></i></span>\n</p>\n\n<p align="center">\n  <a href="#installation">Installation</a>\n  &nbsp;&nbsp;&nbsp;>&nbsp;&nbsp;&nbsp;\n  <a href="#usage">Usage</a>\n  &nbsp;&nbsp;&nbsp;>&nbsp;&nbsp;&nbsp;\n  <a href="#templates">Templates</a>\n  &nbsp;&nbsp;&nbsp;>&nbsp;&nbsp;&nbsp;\n  <a href="#contact">Contact</a>\n</p>\n\n<p align="center">\n  <img src="https://github.com/Rog3rSm1th/Kharma/blob/main/doc/kharma_demo.gif?raw=true" alt="Kharma demonstration"/>\n</p>\n\nKharma is a state-of-the-art *grammar fuzzer*. It can generate many random documents based on a grammar, which can be used to improve your testing corpus by increasing code coverage and to find bugs/vulnerabilities in many kinds of applications (interpreters, files parsers, etc...).\n\n## Requirements\n[Python 3](https://www.python.org/)\n\n## Installation\n\n#### Install with pip (recommended)\n\n```bash\npip3 install kharma\n```\n\n#### Install with Docker\n```bash\n/bin/bash ./scripts/docker_install.sh\n```\n\n#### Or build from source\n\nRecommended for developers. It automatically clones the main branch from the kharma repo, and installs from source.\n\n```bash\n# Automatically clone the Kharma repository and install Kharma from source\nbash <(wget -q https://raw.githubusercontent.com/Rog3rSm1th/Kharma/main/scripts/autoinstall.sh -O -)\n```\n\n## Usage\n\n```\nusage: kharma [-h] [-v] -t TEMPLATE -c COUNT [-s] {output} ...\n\npositional arguments:\n  {output}              sub-command help\n    output              output help\n\noptions:\n  -h, --help            show this help message and exit\n  -v, --version         show program\'s version number and exit\n  -t TEMPLATE, --template TEMPLATE\n                        template path, e.g. ./path/to/file.kg\n  -c COUNT, --count COUNT\n                        number of documents to generate\n  -s, --safe-mode       disallow call statements\n```\n#### Basic usage\n\nFor example if you want to generate 10 documents based on the `javascript.kg` template:\n\n```bash\nkharma -t ./javascript.kg -c 10\n```\n\nThe documents will then be printed on *stdout*.\n\n#### Generate files documents\n\nOtherwise, if you want to save the documents into files you should use the **output** option.\n\n```\nusage: kharma output [-h] -d DIRECTORY\n                     [-e EXTENSION]\n```\n\nFor example if you want to output the documents in a `js_documents` folder with the `.js` extension:\n\n```bash\nkharma -t ./javascript.kg -c 10 output -d ./js_documents -e js\n```\n\n## Templates\n\nKharma generates random documents based on grammars defined in templates, those templates are based on the [YAML](https://wikipedia.org/wiki/YAML) format and are divided into different sections.\n\n### Comments\n\n```yaml\n# This is a comment\n\n# This is a \n# Multi-line comment\n```\n### Imports (optional section)\n\nIt is possible to import variables, constants and functions defined in other templates using the **imports** section.\n\n``` yaml\nimports:\n    # You must specify the import name as well as the relative path of the template\n    import: "import.kg"\n```\n\n### Functions (optional section)\n\nThe **function** section allows you to define python functions inside your template.\n\n```yaml\nfunctions:\n    # Here we define the "multiply" function.\n    multiply: |\n                <%python (factor_1, factor_2)\n                    factor_1_int = int(factor_1)\n                    factor_2_int = int(factor_2)\n                    product = factor_1_int*factor_2_int\n                    return product\n                %>\n```\n\n### Constants (optional section)\n\nThe **consts** section allows to define values with only one possible value. Constants can use references to variables and vice versa.\n\n```yaml\nconsts:\n    const_0: "This is a constant"\n    const_1: |\n             Multiple lines\n             constant\n    const_2: "++import:int8++"\n    const_3: "++variable_0++"\n    const_4: "++const_0++"\n    const_5: "@@element_@@"\n    const_6: "[%%range%%](0, 1337)"\n    const_7: "[%%regexp:[A-Za-z0-9]+%%]"\n    const_8: "[%%call~multiply%%](3, 4)"\n    const_9: "[##repeat:1:5:dup:##]{%looped string%}"\n```\n\n### Variables (optional section)\n\nThe **variables** section allows you to define values with several possible values.\n\n```yaml\nvariables:\n    # A variable can have several possible values\n    variable_0: \n        - "double quoted variable"\n        - \'single quoted variable\'\n        - "Unicode string: \\u0398\\u039f\\u03b4"\n        - "Hexadecimal string: \\x49\\x4a\\x4b"\n        - |\n            variable can be written \n            on multiples\n            lines !\n    \n    # An anchor is a reference to another variable\n    variable_anchor:\n        # The anchor will be replaced by one of the possibles values of the variable\n        - "++variable_0++"\n    \n    # Variable can use references to constants\n    variable_const_anchor:\n        - "++const_0++"\n        - "++const_1++"\n        - "++const_2++"\n        - "++const_3++"\n        - "++const_4++"\n        - "++const_5++"\n        - "++const_6++"\n        - "++const_7++"\n        - "++const_8++"\n        - "++const_9++"\n    \n    # You can access variables/consts defined in imported files\n    variable_import_anchor:\n        - "++import:int8++"\n        - "++import:uint8++"\n        - "++import:int16++"\n        - "++import:uint16++"\n        - "++import:int32++"\n        - "++import:uint32++"\n        - "++import:int32++"\n        - "++import:uint32++"\n    \n    # An element has a name and a counter.\n    variable_element:\n        # The first time we call it, the result will be "element_0", the next time\n        # "element_1", and so on\n        - "@@element_@@"\n    \n    # Selection of a random value within the range\n    variable_range:\n        - "[%%range%%](0, 1337)"\n        - "[%%range%%](-100, 100)"\n        - "[%%range%%](-infinity, infinity)"\n        \n    # Generate a random valid input for the regular expression\n    variable_regexp:\n        - "[%%regexp:[A-Za-z0-9]+%%]"\n    \n    # Calls a function defined within the template and gets the return value\n    variable_call:\n        - "[%%call~multiply%%](3, 4)"\n        - "[%%call~multiply%%](++import:int8++, ++import:int8++)"\n        - "[%%call~multiply%%]([%%range%%](-100, 100), [%%range%%](-infinity, infinity))"\n\n    # Calls a function defined in an imported template and gets the return value\n    variable_import_call:\n        - "[%%call~import:sum%%](3, 4)"\n        - "[%%call~import:sum%%](++import:int8++, ++import:int8++)"\n        - "[%%call~import:sum%%]([%%range%%](-100, 100), [%%range%%](-infinity, infinity))"\n\n    # Loop a string\n    variable_loop:\n        # Repeat a string between 1 and 5 times\n        - "[##repeat:1:5:dup:##]{%looped string%}"\n        # Use a custom separator\n        - "[##repeat:1:5:dup:, ##]{%looped string%}"\n        # Repeat an anchor\n        - "[##repeat:1:5:dup:##]{%++variable_anchor++%}"\n        # Remove duplicates\n        - "[##repeat:1:5:nodup:##]{%++variable_anchor++%}"\n        # Repeat an imported anchor\n        - "[##repeat:1:5:dup:##]{%++variable_import_anchor++%}"\n        # Repeat an element reference\n        - "[##repeat:1:5:dup:##]{%++variable_element++%}"\n        # Repeat a range statement\n        - "[##repeat:1:5:dup:##]{%[%%range%%](-100, 100)%}"\n        # Repeat a regexp statement\n        - "[##repeat:1:5:dup:##]{%++variable_regexp++%}"\n        \n    # It is possible to define a static variable by giving it a name starting \n    # with "static_"\n    # A static variable will be evaluated only once and will take the\n    # same value at each call\n    static_variable:\n        - "this is a static value"\n        - "++import:int8++"\n        - "@@element_@@"\n        - "[%%range%%](0, 1337)"\n        - "[%%regexp:[A-Za-z0-9]+%%]"\n        - "[%%call~multiply%%](3, 4)"\n        - "[##repeat:1:5:dup:##]{%looped string%}"\n    \n    # It is possible to use several statements/references\n    several_statements_variables:\n        - "++variable_0++ ++import:int8++ @@element_@@ [%%range%%](0, 1337) [%%regexp:[A-Za-z0-9]+%%] [%%call~multiply%%](3, 4) [##repeat:1:5:dup:##]{%looped string%}"\n```\n\n### Variance (optional section)\n\nThe **variance** section contains the **main** variable which is the entry point of the template.\n\n```yaml\nvariance:\n    # Main is the entry point of the template\n    # it works like a regular variable\n    main:\n        # Happy template generating ! ヽ(o＾▽＾o)ノ\n        - "++several_statements_variables++"\n```\n\n**IMPORTANT**: The order in which the sections are defined is **not important** and all sections are **optionals**.\n\nYou can find a demo template [here](https://github.com/Rog3rSm1th/Kharma/tree/main/grammars/tutorial).\n\n## Contact \n\nfor any remark, suggestion, bug report, or if you found a bug using Kharma, you can contact me at r0g3r5@protonmail.com or on twitter [@Rog3rSm1th](https://twitter.com/Rog3rSm1th)',
    'author': 'Rog3rSm1th',
    'author_email': 'r0g3r5@protonmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Rog3rSm1th/Kharma',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
