"""`perseus_corpus_types` - a mapping of corpus types into common periods, based largely on:
https://en.wikipedia.org/wiki/Latin_literature
"""

perseus_corpus_texts_by_type = {
    "augustan": [
        "propertius-sextus__elegies__latin.json",
        "horace__ars-poetica__latin.json",
        "horace__carmen-saeculare__latin.json",
        "horace__odes__latin.json",
        "horace__satires__latin.json",
        "horace__epistulae__latin.json",
        "horace__epodi__latin.json",
        "ovid__amores__latin.json",
        "ovid__art-of-love__latin.json",
        "ovid__book-of-days__latin.json",
        "ovid__epistulae__latin.json",
        "ovid__ibis__latin.json",
        "ovid__letters-from-the-black-sea__latin.json",
        "ovid__metamorphoses__latin.json",
        "ovid__remedy-of-love__latin.json",
        "ovid__sorrows__latin.json",
        "ovid__art-of-beauty__latin.json",
        "virgil__aeneid__latin.json",
        "virgil__eclogues__latin.json",
        "virgil__georgics__latin.json",
        "tibullus__elegiae__latin.json",
        "vitruvius-pollio__on-architecture__latin.json",
    ],
    "christian": [
        "ausonius-decimus-magnus__epistulae__latin.json",
        "boethius-d-524__de-consolatione-philosophiae__latin.json",
        "boethius-d-524__de-fide-catholica__latin.json",
        "boethius-d-524__quomodo-trinitas-unus-deus-ac-non-tres-dii-de-trinitate__latin.json",
        "claudianus-claudius__panegyricus-de-tertio-consulatu-honorii-augusti__latin.json",
        "gellius-aulus__noctes-atticae__latin.json",
        "jerome-saint-d-419-or-20__epistolae__latin.json",
        "prudentius-b-348__apotheosis__latin.json",
        "prudentius-b-348__cathemerina__latin.json",
        "prudentius-b-348__contra-orationem-symmachia__latin.json",
        "prudentius-b-348__dittochaeon__latin.json",
        "prudentius-b-348__hamartigenia__latin.json",
        "prudentius-b-348__liber-peristephanon__latin.json",
        "prudentius-b-348__praefetio__latin.json",
        "prudentius-b-348__epilogus__latin.json",
        "prudentius-b-348__psychomachia__latin.json",
        "boethius-d-524__liber-de-persona-et-duabus-naturis-contra-eutychen-et-nestorium__latin.json",
        "boethius-d-524__quomodo-substantiae-in-eo-quod-sint-bonae-sint-cum-non-sint-substanialia-bona__latin.json",
        "boethius-d-524__utrum-pater-et-filius-ac-spiritus-sanctus-de-divinitate-substantialiter-praedicentur-liber__latin.json",
        "tertullian-ca-160-ca-230__ad-martyras__latin.json",
        "tertullian-ca-160-ca-230__ad-nationes-libri-duo__latin.json",
        "tertullian-ca-160-ca-230__ad-scapulam__latin.json",
        "tertullian-ca-160-ca-230__ad-uxorem__latin.json",
        "tertullian-ca-160-ca-230__adversus-hermogenem__latin.json",
        "tertullian-ca-160-ca-230__adversus-judaeos-liber__latin.json",
        "tertullian-ca-160-ca-230__adversus-marcionem__latin.json",
        "tertullian-ca-160-ca-230__adversus-praxean__latin.json",
        "tertullian-ca-160-ca-230__adversus-valentinianos__latin.json",
        "tertullian-ca-160-ca-230__apologeticum__latin.json",
        "tertullian-ca-160-ca-230__de-anima__latin.json",
        "tertullian-ca-160-ca-230__de-baptismo__latin.json",
        "tertullian-ca-160-ca-230__de-carne-christi__latin.json",
        "tertullian-ca-160-ca-230__de-carnis-resurrectione__latin.json",
        "tertullian-ca-160-ca-230__de-corona__latin.json",
        "tertullian-ca-160-ca-230__de-cultu-feminarum__latin.json",
        "tertullian-ca-160-ca-230__de-exhortatione-castitatis-liber__latin.json",
        "tertullian-ca-160-ca-230__de-fuga-in-persecutione__latin.json",
        "tertullian-ca-160-ca-230__de-idolatria__latin.json",
        "tertullian-ca-160-ca-230__de-ieiunio-adversus-psychicos__latin.json",
        "tertullian-ca-160-ca-230__de-monogamia__latin.json",
        "tertullian-ca-160-ca-230__de-oratione__latin.json",
        "tertullian-ca-160-ca-230__de-paenitentia__latin.json",
        "tertullian-ca-160-ca-230__de-pallio__latin.json",
        "tertullian-ca-160-ca-230__de-patientia__latin.json",
        "tertullian-ca-160-ca-230__de-praescriptionibus-hereticorum__latin.json",
        "tertullian-ca-160-ca-230__de-pudicitia__latin.json",
        "tertullian-ca-160-ca-230__de-spectaculis__latin.json",
        "tertullian-ca-160-ca-230__de-testimionio-animae__latin.json",
        "tertullian-ca-160-ca-230__de-virginibus-velandis__latin.json",
        "tertullian-ca-160-ca-230__scorpiace__latin.json",
    ],
    "early_silver": [
        "apuleius__florida__latin.json",
        "columella-lucius-junius-moderatus__res-rustica__latin.json",
        "curtius-rufus-quintus__historiarum-alexandri-magni__latin.json",
        "florus-lucius-annaeus__epitome-rerum-romanorum__latin.json",
        "juvenal__satires__latin.json",
        "lucan__civil-war__latin.json",
        "martial__epigrammata__latin.json",
        "nepos-cornelius__cato__latin.json",
        "paris-julius__facta-et-dicta-memorabilia__latin.json",
        "pliny-the-elder__naturalis-historia__latin.json",
        "pliny-the-younger__epistulae__latin.json",
        "seneca-lucius-annaeus__de-consolatione-ad-polybium__latin.json",
        "seneca-lucius-annaeus-55-bc-ca-39-ad__suasoriae__latin.json",
        "seneca-lucius-annaeus-55-bc-ca-39-ad__controversiae__latin.json",
        "seneca-lucius-annaeus-55-bc-ca-39-ad__excerpta-controversiae__latin.json",
        "seneca-lucius-annaeus-55-bc-ca-39-ad__fragmenta__latin.json",
        "seneca-lucius-annaeus-plays__agamemnon__latin.json",
        "seneca-lucius-annaeus-plays__apocolocyntosis__latin.json",
        "seneca-lucius-annaeus-plays__de-clementia__latin.json",
        "seneca-lucius-annaeus-plays__hercules-furens__latin.json",
        "seneca-lucius-annaeus-plays__hercules-oetaeus__latin.json",
        "seneca-lucius-annaeus-plays__medea__latin.json",
        "seneca-lucius-annaeus-plays__octavia__latin.json",
        "seneca-lucius-annaeus-plays__oedipus__latin.json",
        "seneca-lucius-annaeus-plays__phaedra__latin.json",
        "seneca-lucius-annaeus-plays__phoenissae__latin.json",
        "seneca-lucius-annaeus-plays__thyestes__latin.json",
        "seneca-lucius-annaeus-plays__troades-furens__latin.json",
        "seneca-lucius-annaeus__de-brevitate-vitae__latin.json",
        "seneca-lucius-annaeus__de-consolatione-ad-helviam__latin.json",
        "seneca-lucius-annaeus__de-consolatione-ad-marciam__latin.json",
        "seneca-lucius-annaeus__de-constantia__latin.json",
        "seneca-lucius-annaeus__de-ira__latin.json",
        "seneca-lucius-annaeus__de-otio-sapientis__latin.json",
        "seneca-lucius-annaeus__de-providentia__latin.json",
        "seneca-lucius-annaeus__de-tranquilitate-animi__latin.json",
        "seneca-lucius-annaeus__de-vita-beata__latin.json",
        "silius-italicus-tiberius-catius__punica__latin.json",
        "statius-p-papinius-publius-papinius__achilleis__latin.json",
        "statius-p-papinius-publius-papinius__silvae__latin.json",
        "tacitus-cornelius__agricola__latin.json",
        "tacitus-cornelius__germania__latin.json",
        "valerius-flaccus-gaius__argonautica__latin.json",
    ],
    "late_silver": [
        "apuleius__apologia__latin.json",
        "apuleius__metamorphoses__latin.json",
        "claudianus-claudius__carminum-minorum-corpusculum__latin.json",
        "claudianus-claudius__de-bello-gildonico__latin.json",
        "claudianus-claudius__de-bello-gothico__latin.json",
        "claudianus-claudius__de-consulatu-stilichonis__latin.json",
        "claudianus-claudius__de-raptu-proserpinae__latin.json",
        "claudianus-claudius__epithalamium-de-nuptiis-honorii-augusti__latin.json",
        "claudianus-claudius__fescinnina-de-nuptiis-honorii-augusti__latin.json",
        "claudianus-claudius__in-eutropium__latin.json",
        "claudianus-claudius__in-rufinum__latin.json",
        "claudianus-claudius__panegyricus-de-quarto-consulatu-honorii-augusti__latin.json",
        "claudianus-claudius__panegyricus-de-sexto-consulatu-honorii-augusti__latin.json",
        "claudianus-claudius__panegyricus-dictus-manlio-theodoro-consuli__latin.json",
        "claudianus-claudius__panegyricus-dictus-probino-et-olybrio-consulibus__latin.json",
        "suetonius-ca-69-ca-122__galba__latin.json",
        "suetonius-ca-69-ca-122__otho__latin.json",
        "suetonius-ca-69-ca-122__tiberius__latin.json",
        "suetonius-ca-69-ca-122__vitellius__latin.json",
        "suetonius-ca-69-ca-122__caligula__latin.json",
        "suetonius-ca-69-ca-122__divus-augustus__latin.json",
        "suetonius-ca-69-ca-122__divus-claudius__latin.json",
        "suetonius-ca-69-ca-122__divus-julius__latin.json",
        "suetonius-ca-69-ca-122__divus-titus__latin.json",
        "suetonius-ca-69-ca-122__divus-vespasianus__latin.json",
        "suetonius-ca-69-ca-122__domitianus__latin.json",
        "suetonius-ca-69-ca-122__nero__latin.json",
        "ammianus-marcellinus__rerum-gestarum__latin.json",
        "ausonius-decimus-magnus__caesares__latin.json",
        "ausonius-decimus-magnus__oratio-versibus-rhopalicis__latin.json",
        "ausonius-decimus-magnus__versus-paschales-prosodic__latin.json",
        "ausonius-decimus-magnus__bissula__latin.json",
        "ausonius-decimus-magnus__epicedion-in-patrem__latin.json",
        "ausonius-decimus-magnus__genethliacon-ad-ausonium-nepotem__latin.json",
        "ausonius-decimus-magnus__liber-protrepticus-ad-nepotem__latin.json",
        "ausonius-decimus-magnus__commemoratio-professorum-burdigalensium__latin.json",
        "ausonius-decimus-magnus__de-herediolo__latin.json",
        "ausonius-decimus-magnus__eclogarum-liber__latin.json",
        "ausonius-decimus-magnus__ephemeris__latin.json",
        "ausonius-decimus-magnus__epigrammaton-liber__latin.json",
        "ausonius-decimus-magnus__epitaphia__latin.json",
        "ausonius-decimus-magnus__gratiarum-actio__latin.json",
        "ausonius-decimus-magnus__griphus-ternarii-numeri__latin.json",
        "ausonius-decimus-magnus__mosella__latin.json",
        "ausonius-decimus-magnus__ordo-urbium-nobilium__latin.json",
        "ausonius-decimus-magnus__parentalia__latin.json",
        "ausonius-decimus-magnus__praefatiunculae__latin.json",
        "ausonius-decimus-magnus__precationes__latin.json",
        "ausonius-decimus-magnus__technopaegnion__latin.json",
        "vopiscus-flavius-fl-34-jh__severus__latin.json",
        "vopiscus-flavius-fl-34-jh__alexander-severus__latin.json",
        "vopiscus-flavius-fl-34-jh__antoninus-caracalla__latin.json",
        "vopiscus-flavius-fl-34-jh__antoninus-geta__latin.json",
        "vopiscus-flavius-fl-34-jh__antoninus-heliogobalus__latin.json",
        "vopiscus-flavius-fl-34-jh__antoninus-pius__latin.json",
        "vopiscus-flavius-fl-34-jh__avidius-casius__latin.json",
        "vopiscus-flavius-fl-34-jh__carus-et-carinus-et-numerianus__latin.json",
        "vopiscus-flavius-fl-34-jh__clodinus-albinus__latin.json",
        "vopiscus-flavius-fl-34-jh__commodus-antoninus__latin.json",
        "vopiscus-flavius-fl-34-jh__de-vita-hadriani__latin.json",
        "vopiscus-flavius-fl-34-jh__diadumenus-antoninus__latin.json",
        "vopiscus-flavius-fl-34-jh__didius-julianus__latin.json",
        "vopiscus-flavius-fl-34-jh__divus-claudius__latin.json",
        "vopiscus-flavius-fl-34-jh__firmus-saturninus-proculus-et-bonosus__latin.json",
        "vopiscus-flavius-fl-34-jh__gallieni-duo__latin.json",
        "vopiscus-flavius-fl-34-jh__goridani-tres__latin.json",
        "vopiscus-flavius-fl-34-jh__helius__latin.json",
        "vopiscus-flavius-fl-34-jh__marcus-antoninus-philosophus__latin.json",
        "vopiscus-flavius-fl-34-jh__maximini-duo__latin.json",
        "vopiscus-flavius-fl-34-jh__maximus-et-balbinus__latin.json",
        "vopiscus-flavius-fl-34-jh__opilius-macrinus__latin.json",
        "vopiscus-flavius-fl-34-jh__pertinax__latin.json",
        "vopiscus-flavius-fl-34-jh__pescennius-niger__latin.json",
        "vopiscus-flavius-fl-34-jh__probus__latin.json",
        "vopiscus-flavius-fl-34-jh__tacitus__latin.json",
        "vopiscus-flavius-fl-34-jh__tyranni-triginta__latin.json",
        "vopiscus-flavius-fl-34-jh__valeriani-duo__latin.json",
        "vopiscus-flavius-fl-34-jh__verus__latin.json",
        "vopiscus-flavius-fl-34-jh__divus-aurelianus__latin.json",
    ],
    "misc": [
        "celsus-aulus-cornelius__de-medicina__latin.json",
        "minucius-felix-marcus__octavius__latin.json",
    ],
    "neo_latin": [],
    "old": [
        "plautus-titus-maccius__bacchides__latin.json",
        "plautus-titus-maccius__mostellaria__latin.json",
        "plautus-titus-maccius__captivi__latin.json",
        "plautus-titus-maccius__trinummus__latin.json",
        "plautus-titus-maccius__asinaria__latin.json",
        "plautus-titus-maccius__casina__latin.json",
        "plautus-titus-maccius__curculio__latin.json",
        "plautus-titus-maccius__stichus__latin.json",
        "plautus-titus-maccius__aulularia__latin.json",
        "plautus-titus-maccius__epidicus__latin.json",
        "plautus-titus-maccius__menaechmi__latin.json",
        "plautus-titus-maccius__mercator__latin.json",
        "plautus-titus-maccius__miles-gloriosus__latin.json",
        "plautus-titus-maccius__persa__latin.json",
        "plautus-titus-maccius__poenulus__latin.json",
        "plautus-titus-maccius__rudens__latin.json",
        "plautus-titus-maccius__truculentus__latin.json",
        "terence__the-self-tormenter__latin.json",
        "terence__andria__latin.json",
        "terence__the-brothers__latin.json",
        "terence__the-mother-in-law__latin.json",
        "terence__phormio__latin.json",
        "terence__the-eunuch__latin.json",
    ],
    "republican": [
        "caesar-julius__gallic-war__latin.json",
        "cicero__for-marcus-caelius__latin.json",
        "cicero__for-marcus-fonteius__latin.json",
        "cicero__de-inventione__latin.json",
        "cicero__academica__latin.json",
        "cicero__brutus__latin.json",
        "cicero__de-amicitia__latin.json",
        "cicero__de-fato__latin.json",
        "cicero__de-finibus-bonorum-et-malorum__latin.json",
        "cicero__de-natura-deorum__latin.json",
        "cicero__de-officiis__latin.json",
        "cicero__de-optimo-genere-oratorum__latin.json",
        "cicero__de-republica__latin.json",
        "cicero__de-senectute__latin.json",
        "cicero__for-sulla__latin.json",
        "cicero__in-defense-of-l-murena__latin.json",
        "cicero__in-defense-of-lucius-flaccus__latin.json",
        "cicero__in-the-senate-after-his-return__latin.json",
        "cicero__letters-to-atticus__latin.json",
        "cicero__letters-to-brutus__latin.json",
        "cicero__letters-to-his-friends__latin.json",
        "cicero__on-behalf-of-marcus-tullius__latin.json",
        "cicero__orator__latin.json",
        "cicero__paradoxa-stoicorum__latin.json",
        "cicero__partitiones-oratoriae__latin.json",
        "cicero__timaeus__latin.json",
        "cicero__topica__latin.json",
        "cicero__tusculanae-disputationes__latin.json",
        "cicero__against-publius-servilius-rullus__latin.json",
        "cicero__de-divinatione__latin.json",
        "cicero__divinatio-against-q-caecilius__latin.json",
        "cicero__for-archias__latin.json",
        "cicero__for-publius-quinctius__latin.json",
        "cicero__for-quintus-roscius-the-actor__latin.json",
        "cicero__for-sextus-roscius-of-ameria__latin.json",
        "cicero__four-orations-against-lucius-catilina__latin.json",
        "cicero__in-defense-of-aulus-cluentius-habitus__latin.json",
        "cicero__in-defense-of-caius-rabirius__latin.json",
        "cicero__letters-to-his-brother-quintus__latin.json",
        "cicero__lucullus__latin.json",
        "cicero__on-behalf-of-aulus-caecina__latin.json",
        "cicero__on-oratory__latin.json",
        "cicero__on-pompeys-command__latin.json",
        "cicero__orations-against-verres__latin.json",
        "cicero__to-the-citizens-after-his-return__latin.json",
        "lucretius__de-rerum-natura__latin.json",
        "nepos-cornelius__agesilaus__latin.json",
        "nepos-cornelius__alcibiades__latin.json",
        "nepos-cornelius__aristides__latin.json",
        "nepos-cornelius__atticus__latin.json",
        "nepos-cornelius__chabrias__latin.json",
        "nepos-cornelius__cimon__latin.json",
        "nepos-cornelius__conon__latin.json",
        "nepos-cornelius__datames__latin.json",
        "nepos-cornelius__de-regibus__latin.json",
        "nepos-cornelius__dion__latin.json",
        "nepos-cornelius__epaminondas__latin.json",
        "nepos-cornelius__eumenes__latin.json",
        "nepos-cornelius__hamilcar__latin.json",
        "nepos-cornelius__hannibal__latin.json",
        "nepos-cornelius__iphicrates__latin.json",
        "nepos-cornelius__lysander__latin.json",
        "nepos-cornelius__miltiades__latin.json",
        "nepos-cornelius__pausanias__latin.json",
        "nepos-cornelius__pelopidas__latin.json",
        "nepos-cornelius__phocion__latin.json",
        "nepos-cornelius__themistocles__latin.json",
        "nepos-cornelius__thrasybulus__latin.json",
        "nepos-cornelius__timoleon__latin.json",
        "nepos-cornelius__timotheus__latin.json",
        "quintus-tullius-cicero__commentariolum-petitionis__latin.json",
        "sallust__bellum-iugurthinum__latin.json",
        "sallust__catilinae-coniuratio__latin.json",
        "sallust__historiae__latin.json",
    ],
}
